/* qshutdown, a program to shutdown/reboot/suspend/hibernate the system
 * Copyright (C) 2009 2010 2011 Christian Metscher <hakaishi@web.de>

 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef GUI_H
#define GUI_H

#include <QtGui>
#include "ui_gui.h"

#define SERVICE_NAME  "org.qshutdown"
#define OBJECT_NAME "/org/qshutdown"

#ifndef Q_OS_WIN32
  #include <QtDBus>
#endif

class Preferences;
class Info;
class Calendar;
class PassWord;
class Editor;

class Gui : public QWidget, public Ui::Gui {
     Q_OBJECT // important for creating own singals and slots
 
    public:
     Gui(QWidget *parent = 0);
     ~Gui();
     void loadSettings();
     void center();
     QString information;
 
    private:
     QPushButton     *minim;
     QLCDNumber      *lcd;
     QTimer          *timer, *ti;
     QDateTime       datetime;
     QTime           localTime;
     QTime           futureTime;
     QTime           elapsedTime;
     QIcon           icon;
     QSystemTrayIcon *TIcon;
     QMenu           *menu;
     QActionGroup    *power_actions;
     QAction         *shutdown_action;
     QAction         *reboot_action;
     QAction         *suspend_action;
     QAction         *hibernate_action;
     QAction         *quit_action;
     QAction         *reset_action;
     QAction         *info_action;
     QAction         *log_action;
     QAction         *pref_action;
     int             i; //number of seconds left
     int             n; //to check if i==0 was skipped
     QFont           *font1, *font2, *font3;
     bool            finishedExecuted;
     double          logFileSize;
     Preferences     *pref;
     Info            *infoBox;
     Calendar        *calendarBox;
     PassWord        *checkPassword;
     Editor          *editor;

     // defining signals and slots
 
    private slots:
     void iconActivated(QSystemTrayIcon::ActivationReason reason);
     void showW();
     void set();
     void updateT();
     void Time();
     void power_action(int action);
     void power(QAction *action);
     void saveWindowSize();
     void reset();
     void finished();
     void beforeQuit();
     void setInfoText();
     void getFonts();
     void showCalendarBox();
     void setDate();
     void lockEverything(bool actual);
     void updateLock();
    public slots:
     Q_SCRIPTABLE void showRunningProgram();
    protected:
     void keyPressEvent(QKeyEvent* kEvent);
     virtual void closeEvent(QCloseEvent* window_close);
};

#endif //GUI_H
