/*
 *  Part of the shrinkta program, a dvd backup tool
 *
 *  Copyright (C) 2005  Daryl Gray
 *  E-Mail Daryl Gray darylgray1@dodo.com.au
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
*/
/** $Revision: 1.01 $
 * Libdvd common header
 * @file dvd-file-track.h DvdVideo object header file
 * @ingroup core
 *
 * libdvd
 */

#if !defined (__DVD_H_INSIDE__) && !defined (LIBDVD_COMPILATION)
#error "Only <dvd.h> can be included directly."
#endif

#ifndef __DVD_VIDEO_H__
#define __DVD_VIDEO_H__


G_BEGIN_DECLS


/* --- type macros --- */
#define DVD_VIDEO_TYPE		(dvd_video_get_type())
#define DVD_VIDEO(o)		(G_TYPE_CHECK_INSTANCE_CAST (o, DVD_VIDEO_TYPE, DvdVideo))
#define DVD_VIDEO_CLASS(k)	(G_TYPE_CHECK_CLASS_CAST    (k, DVD_VIDEO_TYPE, DvdVideoClass))
#define DVD_IS_VIDEO(o)		(G_TYPE_CHECK_INSTANCE_TYPE (o, DVD_VIDEO_TYPE))
#define DVD_IS_VIDEO_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE    (k, DVD_VIDEO_TYPE))

/* --- typedefs & structures --- */
typedef struct	_DvdVideo	DvdVideo;
typedef struct	_DvdVideoClass	DvdVideoClass;

/** The type of video stream */
typedef enum _DvdVideoFormat {
	DVD_VIDEO_FORMAT_MPEG1,	/**< Video format MPEG 1 */
	DVD_VIDEO_FORMAT_MPEG2	/**< Video format MPEG 2 */
} DvdVideoFormat;

/** The width of video */
typedef enum _DvdVideoWidth {
	DVD_VIDEO_WIDTH_720,	/**< Video width of 720 pixels */
	DVD_VIDEO_WIDTH_704,	/**< Video width of 704 pixels */
	DVD_VIDEO_WIDTH_352,	/**< Video width of 352 pixels */
} DvdVideoWidth;

/** The height of video */
typedef enum _DvdVideoHeight {
	DVD_VIDEO_HEIGHT_480,	/**< Video height of 480 pixels */
	DVD_VIDEO_HEIGHT_576,	/**< Video height of 576 pixels */
	DVD_VIDEO_HEIGHT_240,	/**< Video height of 240 pixels */
	DVD_VIDEO_HEIGHT_288	/**< Video height of 288 pixels */
} DvdVideoHeight;

/** The video bit rate type */
typedef enum _DvdVideoBitRate {
	DVD_VIDEO_BIT_RATE_VARIABLE,	/**< Video bit rate is variable */
	DVD_VIDEO_BIT_RATE_CONSTANT	/**< Video bit rate is constant */
} DvdVideoBitRate;

/** Video standard of title or stream */
typedef enum _DvdVideoStandard {
	DVD_VIDEO_STANDARD_NTSC,/**< Video standard is NTSC */
	DVD_VIDEO_STANDARD_PAL	/**< Video standard is PAL */
} DvdVideoStandard;

/** Video frames per second which is directly related to the standard @see DvdVideoStandard */
typedef enum _DvdVideoFPS {
	DVD_VIDEO_FPS_25,	/**< 25.00 frames per second - PAL */
	DVD_VIDEO_FPS_30	/**< 29.97 frames per second - NTSC */
} DvdVideoFPS;

/** Video aspect ratio */
typedef enum _DvdVideoAspect {
	DVD_VIDEO_ASPECT_4X3,	/**< Video aspect ratio is 4x3 */
	DVD_VIDEO_ASPECT_16X9	/**< Video aspect ratio is 16x9 */
} DvdVideoAspect;


struct _DvdVideo {
	GObject	      parent;
	
	DvdVideoFormat	  format;	/**< Video format @see DvdVideoFormat */
	DvdVideoStandard  standard;	/**< Video standard @see DvdVideoStandard */
	DvdVideoAspect	  aspect;	/**< Video aspect @see DvdVideoAspect */
	DvdVideoWidth	  width;	/**< Video width @see DvdVideoWidth */
	DvdVideoHeight	  height;	/**< Video height @see DvdVideoHeight */
	DvdVideoBitRate	  bit_rate;	/**< Video bit rate @see DvdVideoBitRate */
	DvdVideoFPS	  fps;		/**< Video frames per second @see DvdVideoFPS */
	gboolean	  letterboxed;	/**< True if video is letterboxed */
	gboolean	  film_mode;	/**< True if in film mode */
};

struct _DvdVideoClass {
	GObjectClass	parent;
};

/* --- prototypes --- */
GType		 dvd_video_get_type		(void);
DvdVideo*	 dvd_video_new			(void);
void		 dvd_video_set_format		(DvdVideo	  *video,
						 DvdVideoFormat	   format);
DvdVideoFormat	 dvd_video_get_format		(DvdVideo	  *video);
void		 dvd_video_set_standard		(DvdVideo	  *video,
						 DvdVideoStandard  standard);
DvdVideoStandard dvd_video_get_standard		(DvdVideo	  *video);
void		 dvd_video_set_aspect		(DvdVideo	  *video,
						 DvdVideoAspect	   aspect);
DvdVideoAspect	 dvd_video_get_aspect		(DvdVideo	  *video);
void		 dvd_video_set_width		(DvdVideo	  *video,
						 DvdVideoWidth	   width);
DvdVideoWidth	 dvd_video_get_width		(DvdVideo	  *video);
void		 dvd_video_set_height		(DvdVideo	  *video,
						 DvdVideoHeight	   height);
DvdVideoHeight	 dvd_video_get_height		(DvdVideo	  *video);
void		 dvd_video_set_bit_rate		(DvdVideo	  *video,
						 DvdVideoBitRate   bit_rate);
DvdVideoBitRate	 dvd_video_get_bit_rate		(DvdVideo	  *video);
void		 dvd_video_set_fps		(DvdVideo	  *video,
						 DvdVideoFPS	   fps);
DvdVideoFPS	 dvd_video_get_fps		(DvdVideo	  *video);
void		 dvd_video_set_letterboxed	(DvdVideo	  *video,
						 gboolean	   letterboxed);
gboolean	 dvd_video_get_letterboxed	(DvdVideo	  *video);
void		 dvd_video_set_film_mode	(DvdVideo	  *video,
						 gboolean	   film_mode);
gboolean	 dvd_video_get_film_mode	(DvdVideo	  *video);

G_END_DECLS

#endif /*__DVD_VIDEO_H__*/
