/*
 *  Part of the shrinkta program, a dvd backup tool
 *
 *  Copyright (C) 2005  Daryl Gray
 *  E-Mail Daryl Gray darylgray1@dodo.com.au
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
*/
#include <inttypes.h>
#include <config.h>
#include <glib-object.h>
#include <glib/gi18n.h>
#include <dvdread/ifo_read.h>
#include <string.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "dvd.h"

static GObjectClass *dvd_video_parent_class = NULL;

static void   dvd_video_class_init	(DvdVideoClass	*class);
static void   dvd_video_instance_init	(GTypeInstance	*instance,
					 gpointer	 g_class);
static void   dvd_video_dispose		(GObject	*object);

static void
dvd_video_class_init		(DvdVideoClass	*class)
{
	GObjectClass *object_class = (GObjectClass *) class;
	
	dvd_video_parent_class = g_type_class_ref (G_TYPE_OBJECT);
	object_class->dispose = dvd_video_dispose;
}

static void
dvd_video_instance_init	(GTypeInstance	*instance,
			 gpointer	 g_class)
{
	DvdVideo *video;
	
	video = DVD_VIDEO (instance);
}

static void
dvd_video_dispose		(GObject	*object)
{
	DvdVideo *video;
	
	video = DVD_VIDEO (object);
	G_OBJECT_CLASS (dvd_video_parent_class)->dispose (object);
}

/**
 * dvd_video_get_type:
 *
 * Returns the GType for the DvdVideo class.
 */

GType
dvd_video_get_type		(void)
{
	static GType dvd_video_type = 0;

	if (dvd_video_type == 0) {
		GTypeInfo dvd_video_info = {
			sizeof (DvdVideoClass),
			NULL,
			NULL,
			(GClassInitFunc) dvd_video_class_init,
			NULL,
			NULL, /* class_data */
			sizeof (DvdVideo),
			0, /* n_preallocs */
			(GInstanceInitFunc) dvd_video_instance_init
	    	};
		dvd_video_type = g_type_register_static (G_TYPE_OBJECT,
							 "DvdVideo",
							 &dvd_video_info, 0);
	}
	return dvd_video_type;
}

DvdVideo
*dvd_video_new		(void)
{
	DvdVideo *video;
	
	video = g_object_new (DVD_VIDEO_TYPE, NULL);
	return video;
}

void
dvd_video_set_format		(DvdVideo	  *video,
				 DvdVideoFormat	   format)
{
	g_assert (video != NULL);
	
	video->format = format;
}

DvdVideoFormat
dvd_video_get_format		(DvdVideo	  *video)
{
	g_assert (video != NULL);
	
	return video->format;
}

void
dvd_video_set_standard		(DvdVideo	  *video,
				 DvdVideoStandard  standard)
{
	g_assert (video != NULL);
	
	video->standard = standard;
}

DvdVideoStandard
dvd_video_get_standard		(DvdVideo	  *video)
{
	g_assert (video != NULL);
	
	return video->standard;
}

void
dvd_video_set_aspect		(DvdVideo	  *video,
				 DvdVideoAspect	   aspect)
{
	g_assert (video != NULL);
	
	video->aspect = aspect;
}

DvdVideoAspect
dvd_video_get_aspect		(DvdVideo	  *video)
{
	g_assert (video != NULL);
	
	return video->aspect;
}

void
dvd_video_set_width		(DvdVideo	  *video,
				 DvdVideoWidth	   width)
{
	g_assert (video != NULL);
	
	video->width = width;
}

DvdVideoWidth
dvd_video_get_width		(DvdVideo	  *video)
{
	g_assert (video != NULL);
	
	return video->width;
}

void
dvd_video_set_height		(DvdVideo	  *video,
				 DvdVideoHeight	   height)
{
	g_assert (video != NULL);
	
	video->height = height;
}

DvdVideoHeight
dvd_video_get_height		(DvdVideo	  *video)
{
	g_assert (video != NULL);
	
	return video->height;
}

void
dvd_video_set_bit_rate		(DvdVideo	  *video,
				 DvdVideoBitRate   bit_rate)
{
	g_assert (video != NULL);
	
	video->bit_rate = bit_rate;
}

DvdVideoBitRate
dvd_video_get_bit_rate		(DvdVideo	  *video)
{
	g_assert (video != NULL);
	
	return video->bit_rate;
}

void
dvd_video_set_fps		(DvdVideo	  *video,
				 DvdVideoFPS	   fps)
{
	g_assert (video != NULL);
	
	video->fps = fps;
}

DvdVideoFPS
dvd_video_get_fps		(DvdVideo	  *video)
{
	g_assert (video != NULL);
	
	return video->fps;
}

void
dvd_video_set_letterboxed	(DvdVideo	  *video,
				 gboolean	   letterboxed)
{
	g_assert (video != NULL);
	
	video->letterboxed = letterboxed;
}

gboolean
dvd_video_get_letterboxed	(DvdVideo	  *video)
{
	g_assert (video != NULL);
	
	return video->letterboxed;
}

void
dvd_video_set_film_mode		(DvdVideo	  *video,
				 gboolean	   film_mode)
{
	g_assert (video != NULL);
	
	video->film_mode = film_mode;
}

gboolean
dvd_video_get_film_mode		(DvdVideo	  *video)
{
	g_assert (video != NULL);
	
	return video->film_mode;
}

