/*
 *  Part of the shrinkta program, a dvd backup tool
 *
 *  Copyright (C) 2005  Daryl Gray
 *  E-Mail Daryl Gray darylgray1@dodo.com.au
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
*/
/** $Revision: 1.01 $
 * Libdvd common header
 * @file dvd-decoder.h Dvd object header file
 * @ingroup core
 *
 * libdvd
 */

#if !defined (__DVD_H_INSIDE__) && !defined (LIBDVD_COMPILATION)
#error "Only <dvd.h> can be included directly."
#endif

#ifndef __DVD_DECODER_LPCM_H__
#define __DVD_DECODER_LPCM_H__


G_BEGIN_DECLS


/* --- type macros --- */
#define DVD_DECODER_LPCM_TYPE			(dvd_decoder_lpcm_get_type())
#define DVD_DECODER_LPCM(o)			(G_TYPE_CHECK_INSTANCE_CAST (o, DVD_DECODER_LPCM_TYPE, DvdDecoderLpcm))
#define DVD_DECODER_LPCM_CLASS(k)		(G_TYPE_CHECK_CLASS_CAST    (k, DVD_DECODER_LPCM_TYPE, DvdDecoderLpcmClass))
#define DVD_IS_DVD_DECODER_LPCM(o)		(G_TYPE_CHECK_INSTANCE_TYPE (o, DVD_DECODER_LPCM_TYPE))
#define DVD_IS_DVD_DECODER_LPCM_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE    (k, DVD_DECODER_LPCM_TYPE))

/* --- typedefs & structures --- */
typedef struct	_DvdDecoderLpcm		DvdDecoderLpcm;
typedef struct	_DvdDecoderLpcmClass	DvdDecoderLpcmClass;

struct _DvdDecoderLpcm {
	DvdDecoder	 parent;
	
	DvdAudioQuant	 quantization;		/* default DVD_AUDIO_QUANT_16BIT */
	DvdAudioSamp	 samplerate;		/* default DVD_AUDIO_SAMP_48000 */
	guint32		 clocks_per_frame;	/* 150 for DVD */
	guint8		 channels;		/* always 2 for DVD? - default 2 */
	guint16		 bytes_per_frame;	/* calculated - 320 default */
};


struct _DvdDecoderLpcmClass {
	DvdDecoderClass	parent;
};

/* --- prototypes --- */
GType		dvd_decoder_lpcm_get_type		(void);

void	dvd_decoder_lpcm_set_quantization		(DvdDecoderLpcm	*lpcm_decoder,
							 DvdAudioQuant	 quantization);
void	dvd_decoder_lpcm_set_samplerate			(DvdDecoderLpcm	*lpcm_decoder,
							 DvdAudioSamp	 samplerate);
void	dvd_decoder_lpcm_set_clocks_per_frame		(DvdDecoderLpcm	*lpcm_decoder,
							 guint32	 clocks_per_frame);
void	dvd_decoder_lpcm_set_channels			(DvdDecoderLpcm	*lpcm_decoder,
							 guint8		 channels);

G_END_DECLS

#endif /*__DVD_DECODER_LPCM_H__*/
