/*
 *  Part of the shrinkta program, a dvd backup tool
 *
 *  Copyright (C) 2005  Daryl Gray
 *  E-Mail Daryl Gray darylgray1@dodo.com.au
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
*/
/** $Revision: 1.01 $
 * Libdvd common header
 * @file dvd-chapter.h DvdChapter object header file
 * @ingroup core
 *
 * libdvd
 */

#if !defined (__DVD_H_INSIDE__) && !defined (LIBDVD_COMPILATION)
#error "Only <dvd.h> can be included directly."
#endif

#ifndef __DVD_CHAPTER_H__
#define __DVD_CHAPTER_H__


G_BEGIN_DECLS


/* --- type macros --- */
#define DVD_CHAPTER_TYPE		(dvd_chapter_get_type())
#define DVD_CHAPTER(o)			(G_TYPE_CHECK_INSTANCE_CAST (o, DVD_CHAPTER_TYPE, DvdChapter))
#define DVD_CHAPTER_CLASS(k)		(G_TYPE_CHECK_CLASS_CAST    (k, DVD_CHAPTER_TYPE, DvdChapterClass))
#define DVD_CHAPTER_IS_CHAPTER(o)	(G_TYPE_CHECK_INSTANCE_TYPE (o, DVD_CHAPTER_TYPE))
#define DVD_CHAPTER_IS_CHAPTER_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE    (k, DVD_CHAPTER_TYPE))

/* --- typedefs & structures --- */
typedef struct	_DvdChapter		DvdChapter;
typedef struct	_DvdChapterClass	DvdChapterClass;

struct _DvdChapter {
	GObject		 parent;
	
	DvdSource	 source;
	guint32		 kbs;
	guint8		 chapter_id;
	guint8		 title_set;
	DvdTime		*time;
	DvdTime		*start_time;
	guint32		 video_pts;
	guint32		 audio_pts;
	DvdChapter	*next_chapter;
};

struct _DvdChapterClass {
	GObjectClass	parent;
};

/* --- prototypes --- */
GType	    dvd_chapter_get_type	(void);
void	    dvd_chapter_set_id		(DvdChapter	 *chapter,
					 guint8		  chapter_id);
G_CONST_RETURN
DvdTime*    dvd_chapter_get_time	(DvdChapter	 *chapter);
G_CONST_RETURN
DvdTime*    dvd_chapter_get_start_time	(DvdChapter	 *chapter);
guint32	    dvd_chapter_get_kbs	   	(DvdChapter	 *chapter);
void	    dvd_chapter_get_size	(DvdChapter	 *chapter,
					 guint8		 *gbytes,
					 guint16	 *mbytes,
					 guint16	 *kbytes);

G_END_DECLS

#endif /*__DVD_CHAPTER_H__*/
