Name:		shibboleth
Summary:	Open source system for attribute-based Web SSO
Version:	2.1
Release:	1
#Copyright:	Internet2
Group:		System Environment/Libraries
License:	Apache style
URL:		http://shibboleth.internet2.edu/
Source0:	http://shibboleth.internet2.edu/downloads/%{name}-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-root
BuildRequires:	openssl-devel
BuildRequires:	xerces%{?xercesver}-c-devel >= 2.8.0
BuildRequires:  xml-security-c-devel >= 1.4.0
BuildRequires:	zlib-devel, opensaml-devel >= 2.1
%{?_with_log4cpp:BuildRequires:	log4cpp-devel >= 1.0}
%{!?_with_log4cpp:BuildRequires: log4shib-devel}
%{?_with_fastcgi:BuildRequires: fcgi-devel}
%if "%{_vendor}" == "redhat"
%{!?_without_builtinapache:BuildRequires: httpd-devel}
%endif
%if "%{_vendor}" == "suse"
%{!?_without_builtinapache:BuildRequires: apache2-devel}
%endif


%description
Shibboleth, a project of Internet2/MACE, is developing architectures,
policy structures, practical technologies, and an open source
implementation to support inter-institutional sharing of web resources
subject to access controls. In addition, Shibboleth will develop a
policy framework that will allow inter-operation within the higher
education community.

This package contains the shibboleth runtime library and apache module.

%package devel
Summary: Shibboleth development Headers
Group: Development/Libraries
Requires: %{name} = %{version}

%description devel
Shibboleth, a project of Internet2/MACE, is developing architectures,
policy structures, practical technologies, and an open source
implementation to support inter-institutional sharing of web resources
subject to access controls. In addition, Shibboleth will develop a
policy framework that will allow inter-operation within the higher
education community.

This package contains the headers and other necessary files to build
applications that use the shibboleth library.

%package docs
Summary: Shibboleth API Documentation
Group: Development/Libraries
Requires: %{name} = %{version}

%description docs
Shibboleth Library API documentation generated by doxygen.

%prep
%setup -q

%build
%configure %{?_without_odbc:--disable-odbc} %{?_without_adfs:--disable-adfs} %{?_with_fastcgi} %{?shib_options}
%{__make}

%install
[ "$RPM_BUILD_ROOT" != "/" ] && %{__rm} -rf $RPM_BUILD_ROOT
%{__make} install NOKEYGEN=1 DESTDIR=$RPM_BUILD_ROOT

%if "%{_vendor}" == "suse"
	%{__sed} -i "s/\/var\/log\/httpd/\/var\/log\/apache2/g" \
		$RPM_BUILD_ROOT/%{_sysconfdir}/%{name}/native.logger
%endif

# Plug the SP into Apache on a recognized system.
APACHE_CONFIG="no"
if [ -f $RPM_BUILD_ROOT/%{_libdir}/%{name}/mod_shib_13.so ] ; then
    APACHE_CONFIG="apache.config"
fi
if [ -f $RPM_BUILD_ROOT/%{_libdir}/%{name}/mod_shib_20.so ] ; then
    APACHE_CONFIG="apache2.config"
fi
if [ -f $RPM_BUILD_ROOT/%{_libdir}/%{name}/mod_shib_22.so ] ; then
    APACHE_CONFIG="apache22.config"
fi
if [ "$APACHE_CONFIG" != "no" ] ; then
    APACHE_CONFD="no"
    if [ -d %{_sysconfdir}/httpd/conf.d ] ; then
            APACHE_CONFD="%{_sysconfdir}/httpd/conf.d"
    fi
    if [ -d %{_sysconfdir}/apache2/conf.d ] ; then
            APACHE_CONFD="%{_sysconfdir}/apache2/conf.d"
    fi
    if [ "$APACHE_CONFD" != "no" ] ; then
        %{__mkdir} -p $RPM_BUILD_ROOT$APACHE_CONFD
%if "%{_vendor}" == "suse"
        %{__sed} "s/\/usr\/doc\/%{name}/\/usr\/share\/doc\/packages\/%{name}/g" \
            $RPM_BUILD_ROOT%{_sysconfdir}/%{name}/$APACHE_CONFIG \
            > $RPM_BUILD_ROOT$APACHE_CONFD/shib.conf
%else
        %{__sed} "s/\/usr\/doc\/%{name}/\/usr\/share\/doc\/%{name}-2.1/g" \
            $RPM_BUILD_ROOT%{_sysconfdir}/%{name}/$APACHE_CONFIG \
            > $RPM_BUILD_ROOT$APACHE_CONFD/shib.conf
%endif
    fi
fi

%check || :
%{__make} check

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && %{__rm} -rf $RPM_BUILD_ROOT

%post
%ifnos solaris2.8 solaris2.9 solaris2.10
/sbin/ldconfig
%endif

# Install the shibd init.d scripts and service
%if "%{_vendor}" == "redhat"
	if [ -d %{_sysconfdir}/init.d ] ; then
		if [ ! -f %{_sysconfdir}/init.d/shibd ] ; then
			%{__cp} -p %{_sysconfdir}/%{name}/shibd-%{_vendor} %{_sysconfdir}/init.d/shibd
			%{__chmod} 755 %{_sysconfdir}/init.d/shibd
			chkconfig --add shibd
		fi
	fi
%endif

# Key generation
cd %{_sysconfdir}/%{name}
sh ./keygen.sh -b

%postun
%ifnos solaris2.8 solaris2.9 solaris2.10
/sbin/ldconfig
%endif

# clear init.d state
%if "%{_vendor}" == "redhat"
	chkconfig --del shibd
	[ -f %{_sysconfdir}/init.d/shibd ] && \
	    %{__rm} -f %{_sysconfdir}/init.d/shibd
%endif

%files
%defattr(-,root,root,-)
%{_sbindir}/shibd
%{_bindir}/mdquery
%{_bindir}/resolvertest
%{_libdir}/libshibsp.so.*
%{_libdir}/libshibsp-lite.so.*
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/*
%exclude %{_libdir}/%{name}/*.la
%dir %{_localstatedir}/log/%{name}
%dir %{_localstatedir}/run/%{name}
%dir %{_datadir}/xml/%{name}
%{_datadir}/xml/%{name}/*
%dir %{_sysconfdir}/%{name}
%config(noreplace) %{_sysconfdir}/%{name}/*.xml
%config(noreplace) %{_sysconfdir}/%{name}/*.html
%config(noreplace) %{_sysconfdir}/%{name}/*.logger
%if "%{_vendor}" == "suse"
%config %{_sysconfdir}/apache2/conf.d/shib.conf
%else
%config %{_sysconfdir}/httpd/conf.d/shib.conf
%endif
%{_sysconfdir}/%{name}/*.dist
%{_sysconfdir}/%{name}/apache*.config
%{_sysconfdir}/%{name}/shibd-redhat
%{_sysconfdir}/%{name}/shibd-debian
%{_sysconfdir}/%{name}/shibd-osx.plist
%{_sysconfdir}/%{name}/keygen.sh
%{_sysconfdir}/%{name}/*.xsl
%docdir %{_datadir}/doc/%{name}
%{_datadir}/doc/%{name}/CREDITS.txt
%{_datadir}/doc/%{name}/FASTCGI.LICENSE
%{_datadir}/doc/%{name}/LICENSE.txt
%{_datadir}/doc/%{name}/LOG4CPP.LICENSE
%{_datadir}/doc/%{name}/logo.jpg
%{_datadir}/doc/%{name}/main.css
%{_datadir}/doc/%{name}/NOTICE.txt
%{_datadir}/doc/%{name}/OPENSSL.LICENSE
%{_datadir}/doc/%{name}/README.txt
%{_datadir}/doc/%{name}/RELEASE.txt

%files devel
%defattr(-,root,root,-)
%{_includedir}
%{_libdir}/libshibsp.so
%{_libdir}/libshibsp-lite.so

%files docs
%defattr(644,root,root,755)
%doc %{_datadir}/doc/%{name}/api

%changelog
* Tue Jun 10 2008  Scott Cantor  <cantor.2@osu.edu>  - 2.1-1
- Change shib.conf handling to treat as config file.

* Mon Mar 17 2008  Scott Cantor  <cantor.2@osu.edu>  - 2.0-6
- Official release.

* Fri Jan 18 2008  Scott Cantor  <cantor.2@osu.edu>  - 2.0-5
- Release candidate 1.

* Sun Oct 21 2007 Scott Cantor  <cantor.2@osu.edu>  - 2.0-4
- libexec -> lib/shibboleth changes
- Added doc subpackage

* Thu Aug 16 2007 Scott Cantor  <cantor.2@osu.edu>  - 2.0-3
- First public beta.

* Fri Jul 13 2007 Scott Cantor	<cantor.2@osu.edu>  - 2.0-2
- Second alpha release.

* Sun Jun 10 2007 Scott Cantor	<cantor.2@osu.edu>  - 2.0-1
- First alpha release.

* Mon Oct 2 2006 Scott Cantor	<cantor.2@osu.edu>  - 1.3-11
- Applied fix for secadv 20061002
- Fix for metadata loader loop

* Wed Jun 15 2006 Scott Cantor  <cantor.2@osu.edu>  - 1.3-10
- Applied fix for sec 20060615

* Fri Apr 15 2006 Scott Cantor  <cantor.2@osu.edu>  - 1.3-9
- Misc. patches, SuSE, Apache 2.2, gcc 4.1, and 64-bit support

* Mon Jan 9 2006 Scott Cantor  <cantor.2@osu.edu>  - 1.3-8
- Applied new fix for secadv 20060109

* Tue Nov 8 2005 Scott Cantor  <cantor.2@osu.edu>  - 1.3-7
- Applied new fix for secadv 20050901 plus rollup

* Fri Sep 23 2005 Scott Cantor  <cantor.2@osu.edu>  - 1.3-6
- Minor patches and default config changes
- pidfile patch
- Fix shib.conf creation
- Integrated init.d script
- Prevent replacement of config files

* Thu Sep 1 2005  Scott Cantor  <cantor.2@osu.edu>  - 1.3-5
- Applied fix for secadv 20050901 plus rollup of NSAPI fixes

* Sun Apr 24 2005  Scott Cantor  <cantor.2@osu.edu>  - 1.3-1
- Updated test programs and location of schemas.
- move siterefresh to to sbindir

* Fri Apr  1 2005  Derek Atkins  <derek@ihtfp.com>  - 1.3-1
- Add selinux-targeted-policy package
- move shar to sbindir

* Tue Oct 19 2004  Derek Atkins  <derek@ihtfp.com>  - 1.2-1
- Create SPEC file based on various versions in existence.
