#ifndef _SCHED_HPP_
#define _SCHED_HPP_

#include "time.hpp"
#include "bwadm.hpp"
#include "packet.hpp"

class scheduler {
	int state;
	int usleep;
	u_int64_t sleep_threshold;
	u_int64_t burst_start;
	u_int64_t burst_end;

	int scheduled_classid;
	bwadm *bw_adm;

	unsigned long long total_packets;
	unsigned long long total_bytes;

	int fsm_burst();
	int fsm_sleeping();
	int fsm();
	int __send(generic_packet *packet);

	public:
		scheduler();
		~scheduler();
		int can_send();
		int is_sleeping();
		int send(generic_packet *packet);
		void set_classid(int id);
		void set_bwadm(bwadm *ptr);
};

#endif
