/***************************************************************************
                          editor_midi_in.cpp  -  description
                             -------------------
    begin                : Sun Jul 28 2002
    copyright            : (C) 2002 by red
    email                : red@server
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "editor.h"

int Pattern_Editor::set_midi_note_on_at_cursor(char p_note,char p_velocity) {

	int limit=song->get_track_width(get_cursor_track())-get_cursor_column();
	limit++;
	int where_to_fit=0;
        bool found_where=false;

        while (!found_where) {

		bool exists=false;
		for (int i=0;i<midi_input.size();i++) {

			if (midi_input[i].column==(where_to_fit+get_cursor_column()))
				exists=true;

		}

		if (exists)
			where_to_fit++;
		else
			found_where=true;
	}

	if (where_to_fit>=limit) {



		return -1; //nothing to do with this
	}

	printf("nowhere to fit %i past %i\n",where_to_fit,limit);	
	Note_Event aux_ev;
	aux_ev.note=p_note;
	aux_ev.velocity=p_velocity;
	aux_ev.column=get_cursor_column()+where_to_fit;
	midi_input.push_back(aux_ev);

	song->get_note_ref(get_cursor_track(),get_cursor_pattern(),aux_ev.column,get_cursor_row()).note=p_note;
	song->get_note_ref(get_cursor_track(),get_cursor_pattern(),aux_ev.column,get_cursor_row()).volume=last_volume;

	return where_to_fit;
}

void Pattern_Editor::set_midi_note_off_at_cursor(char p_note,char p_velocity) {

	for (int i=0;i<midi_input.size();i++) {

		if (midi_input[i].note==p_note) {

			midi_input.erase(midi_input.begin()+i);
			if (midi_input.size()==0) {

				cursor_move_down(1);
			}					
		}
	}
}
