/***************************************************************************
                          editor_selection.cpp  -  description
                             -------------------
    begin                : Fri Oct 6 2000
    copyright            : (C) 2000 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "editor.h"

void Pattern_Editor::normalize_selection() {

	int tmpval;

	if (!selection_active) return;

	if (selection_begin_x>selection_end_x) {

		tmpval=selection_begin_x;
		selection_begin_x=selection_end_x;
		selection_end_x=tmpval;
//		if ((selection_end_x-selection_begin_x)>=MAX_SELECTION_COLUMNS) selection_x2=selection_x1+MAX_SELECTION_COLUMNS-1;
	}

	if (selection_begin_y>selection_end_y) {

		tmpval=selection_begin_y;
		selection_begin_y=selection_end_y;
		selection_end_y=tmpval;
	}

	if (selection_begin_y<GetLowerLimit()) selection_begin_y=GetLowerLimit();
	if (selection_end_y>GetUpperLimit()) selection_end_y=GetUpperLimit();
	if ( (selection_end_y<GetLowerLimit()) || (selection_begin_y>GetUpperLimit())) selection_active=false;

	set_flag_redraw_all();
}



void Pattern_Editor::mark_block_begining() {


	selection_begin_x=cursor_x;
	selection_begin_y=cursor_y;

	if (!selection_active) {

		selection_end_x=cursor_x;
		selection_end_y=cursor_y;
		selection_active=1;
	}

	normalize_selection();

}

void Pattern_Editor::mark_block_end() {


	selection_end_x=cursor_x;
	selection_end_y=cursor_y;

	if (!selection_active) {

		selection_begin_x=cursor_x;
		selection_begin_y=cursor_y;
		selection_active=1;
	}

	normalize_selection();

}

void Pattern_Editor::selection_release() {

	selection_active=false;

}

void Pattern_Editor::mark_column_all() {

	

	if ( selection_active
	    && (selection_begin_x==selection_end_x)
	    && (selection_begin_x==cursor_x)	
            && (selection_begin_y==GetLowerLimit())
            && (selection_end_y==GetUpperLimit()) ) {

		selection_begin_x=0;
		selection_end_x=song->get_abs_width()-1;
	} else {

         	selection_begin_x=cursor_x;
         	selection_end_x=cursor_x;
		selection_begin_y=GetLowerLimit();
		selection_end_y=GetUpperLimit();
		selection_active=true;
	}

	normalize_selection();

	

}

	

void Pattern_Editor::shift_selection_begin() {
	
	shift_selection_in_progress=true;
	shift_selection_begin_x=cursor_x;
	shift_selection_begin_y=cursor_y;
}


void Pattern_Editor::shift_selection_update() {

	if (shift_selection_in_progress) {

	        selection_active=true;
		selection_begin_x=shift_selection_begin_x;
		selection_begin_y=shift_selection_begin_y;	
		selection_end_x=cursor_x;
		selection_end_y=cursor_y;
		
		normalize_selection();
	}
}

void Pattern_Editor::shift_selection_end() {

	shift_selection_in_progress=false;		

}


void Pattern_Editor::selection_raise() {

	int i,j;

	if ( selection_active ) {

		for (i=selection_begin_y;i<=selection_end_y;i++)

			for (j=selection_begin_x;j<=selection_end_x;j++) {

				song->abs_note_ref(j,i).raise();

			}

	} else perform_raise_at_cursor();

}

void Pattern_Editor::selection_lower() {

	int i,j;

	if ( selection_active ) {

		for (i=selection_begin_y;i<=selection_end_y;i++)

			for (j=selection_begin_x;j<=selection_end_x;j++) {

				song->abs_note_ref(j,i).lower();

		}

	} else perform_lower_at_cursor();

}

void Pattern_Editor::selection_zap() {

	int i,j;

	for (i=selection_begin_y;i<=selection_end_y;i++)

		for (j=selection_begin_x;j<=selection_end_x;j++) {

			song->abs_note_ref(j,i).clear();

		}

}

void Pattern_Editor::selection_controller_ramp() {

	int i,j;
	int value_begin,value_end;

        if (selection_active && selection_begin_y<selection_end_y) {

		for (j=selection_begin_x;j<=selection_end_x;j++) {
		
				value_begin=song->abs_note_ref(j,selection_begin_y).controller_value;
				value_end=song->abs_note_ref(j,selection_end_y).controller_value;
	
			for (i=selection_begin_y;i<=selection_end_y;i++) {
	
	                        song->abs_note_ref(j,i).controller_value=value_begin+(value_end-value_begin)*(i-selection_begin_y)/(selection_end_y-selection_begin_y);
				
			}
	
		}
	
	}

}
	
void Pattern_Editor::selection_parameter_ramp() {

	int i,j;
	int value_begin,value_end;


        if (selection_active && selection_begin_y<selection_end_y) {
	

		for (j=selection_begin_x;j<=selection_end_x;j++) {
		
				value_begin=song->abs_note_ref(j,selection_begin_y).parameter;
				value_end=song->abs_note_ref(j,selection_end_y).parameter;
	
			for (i=selection_begin_y;i<=selection_end_y;i++) {
	
	                        song->abs_note_ref(j,i).parameter=value_begin+(value_end-value_begin)*(i-selection_begin_y)/(selection_end_y-selection_begin_y);
				
			}
	
		}
	
	}

}
	
void Pattern_Editor::selection_volume_ramp() {

	int i,j;
	int value_begin,value_end;

        if (selection_active && selection_begin_y<selection_end_y ) {
	
		for (j=selection_begin_x;j<=selection_end_x;j++) {
		
				value_begin=song->abs_note_ref(j,selection_begin_y).volume;
				value_end=song->abs_note_ref(j,selection_end_y).volume;
	
			if (value_begin<65 && value_end<65) {

				for (i=selection_begin_y;i<=selection_end_y;i++) {
		
		                        song->abs_note_ref(j,i).volume=value_begin+(value_end-value_begin)*(i-selection_begin_y)/(selection_end_y-selection_begin_y);
					
				}
			}
	
		}
	
	}
	
}

//ClipBoard

void Pattern_Editor::selection_copy() {

	int i,j;

	clipboard->set_width((selection_end_x-selection_begin_x)+1);
	clipboard->set_length((selection_end_y-selection_begin_y)+1);

	for (i=selection_begin_x;i<=selection_end_x;i++)

		for (j=selection_begin_y;j<=selection_end_y;j++) {

			clipboard->get_note_ref(i-selection_begin_x,j-selection_begin_y)=song->abs_note(i,j);
		}



}


void Pattern_Editor::selection_paste_overwrite() {

	int i,j;
	int limit_x,limit_y;

	limit_x=cursor_x+(clipboard->get_width()-1);
	if (limit_x>song->get_abs_width()-1) limit_x=song->get_abs_width()-1;
	
	limit_y=cursor_y+(clipboard->get_length()-1);
	if (limit_y>GetInsertLimit()) limit_y=GetInsertLimit();
	
	for (i=cursor_x;i<=limit_x;i++)
	
		for (j=cursor_y;j<=limit_y;j++) {

			song->abs_note_ref(i,j)=clipboard->get_note(i-cursor_x,j-cursor_y);

	}



}


void Pattern_Editor::selection_paste_insert() {

	int i,j;
	int limit_x,limit_y;

	limit_x=cursor_x+(clipboard->get_width()-1);
	if (limit_x>song->get_abs_width()-1) limit_x=song->get_abs_width()-1;
	
	limit_y=cursor_y+(clipboard->get_length()-1);
	if (limit_y>GetInsertLimit()) limit_y=GetInsertLimit();
	
	for (i=cursor_x;i<=limit_x;i++) {


		for(j=GetUpperLimit();j>(limit_y);j--) {

			song->abs_note_ref(i,j)=song->abs_note(i,j-clipboard->get_length());
		}

		for (j=cursor_y;j<=limit_y;j++) {

			song->abs_note_ref(i,j)=clipboard->get_note(i-cursor_x,j-cursor_y);

		}

	}



}

void Pattern_Editor::selection_paste_mix() {

	int i,j;
	int limit_x,limit_y;
	Note empty_note;


	limit_x=cursor_x+(clipboard->get_width()-1);
	if (limit_x>song->get_abs_width()-1) limit_x=song->get_abs_width()-1;
	
	limit_y=cursor_y+(clipboard->get_length()-1);
	if (limit_y>GetInsertLimit()) limit_y=GetInsertLimit();

	for (i=cursor_x;i<=limit_x;i++)

		for (j=cursor_y;j<=limit_y;j++) {

			if (song->abs_note_ref(i,j)==empty_note) {

				song->abs_note_ref(i,j)=clipboard->get_note(i-cursor_x,j-cursor_y);
			}

		}
}

void Pattern_Editor::selection_set_volume_mask() {

	int i,j;

	/* And you would think this little function should be easy... well.. yes. */

        if (selection_active && selection_begin_y<selection_end_y ) {

		for (j=selection_begin_x;j<=selection_end_x;j++) {

			for (i=selection_begin_y;i<=selection_end_y;i++) {

				song->abs_note_ref(j,i).volume=last_volume;
			}

		}
	}
}

void Pattern_Editor::selection_wipe_stray_volumes() {

	int i,j;
	Note tmp_note;

	/* And you would think this little function should be easy... well.. yes. */

        if (selection_active && selection_begin_y<selection_end_y ) {

		for (j=selection_begin_x;j<=selection_end_x;j++) {

				for (i=selection_begin_y;i<=selection_end_y;i++) {

					tmp_note=song->abs_note(j,i);

					if (tmp_note.note==Note::CLEAR) {

						song->abs_note_ref(j,i).volume=65;
					}
				}
		}
	}
}
void Pattern_Editor::selection_volume_scale(int p_percent) {

	int i,j;
	int value,instr;
	Note tmp_note;

	/* And you would think this little function should be easy... well.. no. */

	
        if (selection_active && selection_begin_y<selection_end_y ) {

		for (j=selection_begin_x;j<=selection_end_x;j++) {

			for (i=selection_begin_y;i<=selection_end_y;i++) {

				tmp_note=song->abs_note(j,i);

				value=tmp_note.volume;
							
				if (value>64) {

					if ((tmp_note.note<128)) {

						instr=song->get_abs_track(j);
						value=song->get_instrument(instr)->def_volume.get();

					} else {

						continue;

					}
				}

				value=(value*p_percent)/100;

				if (value>64) value=64;

				song->abs_note_ref(j,i).volume=value;
			}
		}
	}

	last_volume_scale=p_percent;
}