/***************************************************************************
                          interface.cpp  -  description
                             -------------------
    begin                : Tue Sep 19 2000
    copyright            : (C) 2000 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface.h"
#include "sht.xpm"
#include "defaultctrls.h"

using SigC::bind;

Interface::Interface() {


 	ERROR("This constructor should not be called - Interface()");
}


Interface::Interface(Song *songptr,Player *playerptr,MidiOutDeviceManager *p_midiout) : Gtk::Window(GTK_WINDOW_TOPLEVEL){

	char contr_num_str[6]={'0','0','0','-',' ',0};
        int i;

	quit_requested=false;
	update_info_counter=0;
	// init misc variables
	song=songptr;
	file_operation.set_song(song);
        player=playerptr;
	midiout=p_midiout;
        tracker.editor.midiout=midiout;

	selected_track=-1;
	tracker.link_to_song(songptr);
	file_operation.set_editor(&tracker.editor);

	tracker.button_press_event.connect(slot(this,&Interface::pattern_mouse_down_event));
      //  tracker.set_events(GDK_POINTER_MOTION_MASK|GDK_BUTTON_PRESS_MASK|GDK_BUTTON_RELEASE_MASK|GDK_VISIBILITY_NOTIFY|GDK_EXPOSE);
        orderlist.set_events(GDK_KEY_PRESS_MASK|GDK_POINTER_MOTION_MASK|GDK_BUTTON_PRESS_MASK|GDK_BUTTON_RELEASE_MASK|GDK_VISIBILITY_NOTIFY_MASK|GDK_EXPOSURE_MASK);
	add_events(GDK_KEY_RELEASE_MASK);
	
	popup_pattern_utils.item_copy->activate.connect(slot(this,&Interface::pattern_popup_copy));
	popup_pattern_utils.item_paste->activate.connect(slot(this,&Interface::pattern_popup_paste));
	popup_pattern_utils.item_cut->activate.connect(slot(this,&Interface::pattern_popup_cut));
	popup_pattern_utils.item_zap->activate.connect(slot(this,&Interface::pattern_popup_zap));

	orderlist.link_to_editor(&tracker.editor);

	key_press_event.connect(bind<bool>(slot(this,&Interface::patch_key_press_callback),false));
	key_release_event.connect(bind<bool>(slot(this,&Interface::patch_key_press_callback),true));

	/*main_notebook.*/key_press_event.connect(slot(this,&Interface::key_press_callback));
	main_notebook.switch_page.connect(slot(this,&Interface::main_notebook_page_switched));

	// init interface
	set_title(APP_NAME);


	add(main_vbox);

	info_frame_viewport.add(info_frame);
	main_vbox.pack_start(main_notebook,TRUE,TRUE,0);	
	main_vbox.pack_start(info_frame_viewport,FALSE,TRUE,0);

        info_frame.set_usize(-2,90);

        GenericLabel = new Gtk::Label("Help");
        helpscroll.add(textarea_help);
        helpscroll.show();
        helpscroll.set_policy(GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
	main_notebook.append_page(helpscroll,*GenericLabel);
	GenericLabel->show();
	textarea_help.show();
		
	GenericLabel = new Gtk::Label("Patterns");
	tracker_viewport.add(tracker);
	main_notebook.append_page(tracker_viewport,*GenericLabel);
        main_notebook.show();
	tracker_viewport.show();

	//notebook1.key_press_event.connect(slot(this,&Interface::key_pressed_callback));
	main_vbox.show();
	info_frame.show();
	tracker.show();

        labelx = new Gtk::Label("Tracks");

	for (i=0;i<256;i++) pressed_keys[i]=false;

   // INITIALIZE TRACK PROPERTIES - ( base created with Glade-- )
	track_list = new Gtk::CList(1);
	clist_track_patches = new Gtk::CList(1);
	viewport2 = new Gtk::Viewport();

   scrolledwindow2 = new Gtk::ScrolledWindow();
   scrolledwindow_track_patch = new Gtk::ScrolledWindow();
   trackprops_idata_scrolledwindow= new Gtk::ScrolledWindow();
   labelx2 = new Gtk::Label("Name");
   entry_track_name = new Gtk::Entry();
   entry_track_selected_patch= new Gtk::Entry();
   button_track_moveup = new Gtk::Button("Move Up");
   button_track_movedown = new Gtk::Button("Move Down");
   vseparator2 = new Gtk::VSeparator();
   button7 = new Gtk::Button("Reset");
   togglebutton_track_mute = new Gtk::ToggleButton("Mute");
   hbox9 = new Gtk::HBox(false, 0);
   button_track_remove = new Gtk::Button("Remove Track");
   button_track_new = new Gtk::Button("New Track");
   button_track_clone = new Gtk::Button("Clone");
   hbox3 = new Gtk::HBox(false, 0);
   vbox1 = new Gtk::VBox(false, 0);
   vseparator1 = new Gtk::VSeparator();
   hbox2 = new Gtk::HBox(false, 0);
   label6 = new Gtk::Label("Track Properties");
   hseparator1 = new Gtk::HSeparator();
   hseparator2 = new Gtk::HSeparator();
   label10 = new Gtk::Label("Aviable User Devices:");
   combo_track_devices = new Gtk::Combo();
   label11 = new Gtk::Label("Banks In Device:");
   combo_track_banks = new Gtk::Combo();
   label12 = new Gtk::Label("Selected Patch:");
   viewport3 = new Gtk::Viewport();
   scrolledwindow3 = new Gtk::ScrolledWindow();
   hseparator3 = new Gtk::HSeparator();
   label13 = new Gtk::Label("Midi Channel (1-16)");
   spinbutton_track_channel_adj = new Gtk::Adjustment(1, 1, 16, 1, 10, 10);
   spinbutton_track_channel = new Gtk::SpinButton(*spinbutton_track_channel_adj, 1, 0);
   hbox6 = new Gtk::HBox(false, 0);
   button4 = new Gtk::Button("Modify");
   vbox6 = new Gtk::VBox(false, 0);
   label7 = new Gtk::Label("Instrument");
   hseparator4 = new Gtk::HSeparator();
   label16 = new Gtk::Label("Global Volume");
   spinbutton_track_def_volume_adj = new Gtk::Adjustment(64, 0, 64, 1, 10, 10);
   spinbutton_track_def_volume = new Gtk::SpinButton(*spinbutton_track_def_volume_adj, 1, 0);
   spinbutton_track_glb_volume_adj = new Gtk::Adjustment(127, 0, 127, 1, 10, 10);
   spinbutton_track_glb_volume = new Gtk::SpinButton(*spinbutton_track_glb_volume_adj, 1, 0);
   label15 = new Gtk::Label("Default Volume     ");
   table1 = new Gtk::Table(2, 2, false);
   hseparator5 = new Gtk::HSeparator();
   spinbutton_track_bender_def_adj = new Gtk::Adjustment(0, -128, 127, 1, 10, 10);
   spinbutton_track_bender_def = new Gtk::SpinButton(*spinbutton_track_bender_def_adj, 1, 0);
   label18 = new Gtk::Label("Default Bender");
   spinbutton_track_bender_sens_adj = new Gtk::Adjustment(2, 1, 127, 1, 10, 10);
   spinbutton_track_bender_sens = new Gtk::SpinButton(*spinbutton_track_bender_sens_adj, 1, 0);
   label17 = new Gtk::Label("Bender Sensitivity");
   table2 = new Gtk::Table(2, 2, false);
   hseparator6 = new Gtk::HSeparator();
   label21 = new Gtk::Label("Linear Volume Forcing");
   hseparator9 = new Gtk::HSeparator();
   label22 = new Gtk::Label("Presets:");
   combo3 = new Gtk::Combo();
   vbox12 = new Gtk::VBox(false, 0);

   hbox10 = new Gtk::HBox(false, 0);
   hseparator10 = new Gtk::HSeparator();
   label23 = new Gtk::Label("Initial / Post Note volume control.");
   hseparator11 = new Gtk::HSeparator();
   label24 = new Gtk::Label("Volume Post note Action:");
   radiobutton_tracker_post_volume_nothing = new Gtk::RadioButton("Nothing");
   radiobutton_tracker_post_volume_note_aftertouch = new Gtk::RadioButton("Note Aftertouch");
   radiobutton_tracker_post_volume_channel_aftertouch = new Gtk::RadioButton("Channel Aftertouch");
   radiobutton_tracker_post_volume_controller = new Gtk::RadioButton("Controller");
   radiobutton_tracker_post_volume_note_aftertouch->set_group(radiobutton_tracker_post_volume_nothing->group());	
   radiobutton_tracker_post_volume_channel_aftertouch->set_group(radiobutton_tracker_post_volume_nothing->group());	
   radiobutton_tracker_post_volume_controller->set_group(radiobutton_tracker_post_volume_nothing->group());	
   spinbutton_track_volume_post_controller_adj = new Gtk::Adjustment(11, 0, 127, 1, 10, 10);
   spinbutton_track_volume_post_controller = new Gtk::SpinButton(*spinbutton_track_volume_post_controller_adj, 1, 0);
   hbox12 = new Gtk::HBox(false, 0);
   vbox14 = new Gtk::VBox(false, 0);
   hbox11 = new Gtk::HBox(false, 0);
   hseparator12 = new Gtk::HSeparator();
   label25 = new Gtk::Label("Volume Behavior:");
   radiobutton_track_volume_behavior_normal = new Gtk::RadioButton("Normal: Volume Column sets Velocity\n"
		"Global volume Averages to 0");
   label26 = new Gtk::Label("-OR-");
   radiobutton_track_volume_behavior_tracker = new Gtk::RadioButton("Tracker Emulation: Volume Column sets\n"
		"Post Note Action (see avobe).\n"
		"Global volume sets Velocity.");
   radiobutton_track_volume_behavior_tracker->set_group(radiobutton_track_volume_behavior_normal->group());	
   vbox13 = new Gtk::VBox(false, 0);
   vbox7 = new Gtk::VBox(false, 0);
   label8 = new Gtk::Label("Initial Data");
   hseparator7 = new Gtk::HSeparator();
   label27 = new Gtk::Label("Variables: ");
   label28 = new Gtk::Label("Value: (-1 = don't set)  ");
   label29 = new Gtk::Label("Add New");
   hbox13 = new Gtk::HBox(false, 0);

   hseparator13 = new Gtk::HSeparator();
   vbox10 = new Gtk::VBox(false, 0);
   vbox9 = new Gtk::VBox(false, 0);
   viewport1 = new Gtk::Viewport();
   scrolledwindow1 = new Gtk::ScrolledWindow();
   vbox8 = new Gtk::VBox(false, 0);
   label9 = new Gtk::Label("Initial Variables");
   hseparator8 = new Gtk::HSeparator();
   entry2 = new Gtk::Entry();
   hbox8 = new Gtk::HBox(false, 0);
   vbox11 = new Gtk::VBox(false, 0);
   label14 = new Gtk::Label("Initial Macros");
   notebook1 = new Gtk::Notebook();
   vbox5 = new Gtk::VBox(false, 0);
   hbox1 = new Gtk::HBox(false, 0);
   labelx->set_name("labelx");
   labelx->set_alignment(0.5, 0.5);
   labelx->set_padding(0, 0);
   track_list->set_name("track_list");

   viewport2->set_name("viewport2");
   viewport2->add(*track_list);
   scrolledwindow2->set_name("scrolledwindow2");
   scrolledwindow2->set_policy(GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
   scrolledwindow2->add(*viewport2);
   labelx2->set_name("labelx2");
   labelx2->set_alignment(0.5, 0.5);
   labelx2->set_padding(0, 0);
   entry_track_name->set_name("entry_track_name");
   entry_track_name->set_editable(true);
   entry_track_selected_patch->set_editable(false);
   button_track_moveup->set_name("button_track_moveup");
   button_track_moveup->set_border_width(3);
   button_track_movedown->set_name("button_track_movedown");
   button_track_movedown->set_border_width(3);
   vseparator2->set_usize(24, -1);
   vseparator2->set_name("vseparator2");
   button7->set_name("button7");
   button7->set_border_width(3);
   togglebutton_track_mute->set_name("togglebutton_track_mute");
   togglebutton_track_mute->set_border_width(3);
   button_track_clone->set_border_width(3);
   hbox9->set_name("hbox9");
   hbox9->pack_start(*button_track_moveup, false, false, 0);
   hbox9->pack_start(*button_track_movedown, false, false, 0);
   hbox9->pack_start(*vseparator2, false, false, 0);
   hbox9->pack_end(*button_track_clone, false, false, 0);
   hbox9->pack_end(*button7, false, false, 0);
   hbox9->pack_end(*togglebutton_track_mute, false, false, 0);
   button_track_remove->set_usize(105, -1);
   button_track_remove->set_name("button_track_remove");
   button_track_new->set_usize(100, -1);
   button_track_new->set_name("button_track_new");
   hbox3->set_usize(-1, 30);
   hbox3->set_name("hbox3");
   hbox3->pack_end(*button_track_remove, true, false, 0);
   hbox3->pack_start(*button_track_new, true, false, 0);
   hbox3->pack_start(*button_track_clone, true, false, 0);
   vbox1->set_name("vbox1");
   vbox1->pack_start(*labelx, false, false, 0);
   vbox1->pack_start(*scrolledwindow2);
   vbox1->pack_start(*labelx2, false, false, 0);
   vbox1->pack_start(*entry_track_name, false, false, 0);
   vbox1->pack_start(*hbox9, false, false, 0);
   vbox1->pack_start(*hbox3, false, false, 8);
   vseparator1->set_usize(13, -1);
   vseparator1->set_name("vseparator1");
   hbox2->set_name("hbox2");
   hbox2->pack_start(*vbox1);
   hbox2->pack_start(*vseparator1, false, false, 0);
   label6->set_name("label6");
   label6->set_alignment(0.5, 0.5);
   label6->set_padding(0, 0);
   hseparator1->set_usize(-1, 13);
   hseparator1->set_name("hseparator1");
   hseparator2->set_usize(-1, 11);
   hseparator2->set_name("hseparator2");
   label10->set_name("label10");
   label10->set_alignment(0.5, 0.5);
   label10->set_padding(0, 0);
   combo_track_devices->get_entry()->set_name("combo-entry_track_name");
   combo_track_devices->get_entry()->set_editable(false);
   combo_track_devices->set_name("combo1");

   label11->set_name("label11");
   label11->set_alignment(0.5, 0.5);
   label11->set_padding(0, 0);
   combo_track_banks->get_entry()->set_name("combo-entry2");
   combo_track_banks->get_entry()->set_editable(false);
   combo_track_banks->set_name("combo2");

   label12->set_name("label12");
   label12->set_alignment(0.5, 0.5);
   label12->set_padding(0, 0);

   viewport3->set_name("viewport3");

   viewport3->add(*clist_track_patches);
   scrolledwindow3->set_name("scrolledwindow3");
   scrolledwindow3->set_policy(GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
   scrolledwindow3->add(*viewport3);
   scrolledwindow3->set_usize(-1,200);	
   hseparator3->set_usize(-1, 11);
   hseparator3->set_name("hseparator3");
   label13->set_name("label13");
   label13->set_alignment(0.5, 0.5);
   label13->set_padding(0, 0);
   spinbutton_track_channel->set_usize(79, -1);
   spinbutton_track_channel->set_name("spinbutton_track_channel");
   spinbutton_track_channel->set_editable(true);
   hbox6->set_name("hbox6");
   hbox6->pack_start(*label13, false, false, 7);
   hbox6->pack_start(*spinbutton_track_channel, true, false, 46);
//   button4->set_usize(53, -1);
//   button4->set_name("button4");
   button4->set_border_width(1);
   vbox6->set_name("vbox6");
   vbox6->pack_start(*hseparator2, false, true, 0);
   vbox6->pack_start(*label10, false, false, 0);
   vbox6->pack_start(*combo_track_devices, false, false, 0);
   vbox6->pack_start(*label11, false, false, 2);
   vbox6->pack_start(*combo_track_banks, false, false, 0);
   vbox6->pack_start(*label12, false, false, 2);
   vbox6->pack_start(*entry_track_selected_patch,false,false,2);
   vbox6->pack_start(*scrolledwindow3);
   vbox6->pack_start(*hseparator3, false, false, 0);
   vbox6->pack_start(*hbox6, false, true, 7);

   label7->set_name("label7");
   label7->set_alignment(0.5, 0.5);
   label7->set_padding(0, 0);
   hseparator4->set_usize(-1, 11);
   hseparator4->set_name("hseparator4");
   label16->set_name("label16");
   label16->set_alignment(0.5, 0.5);
   label16->set_padding(0, 0);
   spinbutton_track_def_volume->set_usize(56, -1);
   spinbutton_track_def_volume->set_name("spinbutton_track_def_volume");
   spinbutton_track_def_volume->set_editable(true);
   spinbutton_track_glb_volume->set_usize(56, 24);
   spinbutton_track_glb_volume->set_name("spinbutton_track_glb_volume");
   spinbutton_track_glb_volume->set_editable(true);
   label15->set_name("label15");
   label15->set_alignment(0.5, 0.5);
   label15->set_padding(0, 0);
   table1->set_name("table1");
   table1->set_row_spacings(14);
   table1->attach(*label16, 0, 1, 1, 2, 0, 0, 0, 0);
   table1->attach(*spinbutton_track_def_volume, 1, 2, 0, 1, GTK_EXPAND, 0, 0, 0);
   table1->attach(*spinbutton_track_glb_volume, 1, 2, 1, 2, GTK_EXPAND, 0, 0, 0);
   table1->attach(*label15, 0, 1, 0, 1, GTK_EXPAND, 0, 0, 0);
   hseparator5->set_usize(-1, 9);
   hseparator5->set_name("hseparator5");
   spinbutton_track_bender_def->set_usize(56, 24);
   spinbutton_track_bender_def->set_name("spinbutton_track_bender_def");
   spinbutton_track_bender_def->set_editable(true);
   label18->set_name("label18");
   label18->set_alignment(0.5, 0.5);
   label18->set_padding(0, 0);
   spinbutton_track_bender_sens->set_usize(56, 24);
   spinbutton_track_bender_sens->set_name("spinbutton_track_bender_sens");
   spinbutton_track_bender_sens->set_editable(true);
   label17->set_name("label17");
   label17->set_alignment(0.5, 0.5);
   label17->set_padding(0, 0);
   table2->set_name("table2");
   table2->set_row_spacings(14);
   table2->attach(*spinbutton_track_bender_def, 1, 2, 1, 2, GTK_EXPAND, 0, 0, 0);
   table2->attach(*label18, 0, 1, 1, 2, 0, 0, 0, 0);
   table2->attach(*spinbutton_track_bender_sens, 1, 2, 0, 1, GTK_EXPAND, 0, 0, 0);
   table2->attach(*label17, 0, 1, 0, 1, GTK_EXPAND, 0, 0, 0);
   hseparator6->set_usize(-1, 11);
   hseparator6->set_name("hseparator6");
   label21->set_name("label21");
   label21->set_alignment(0.5, 0.5);
   label21->set_padding(0, 0);
   hseparator9->set_usize(-1, 6);
   hseparator9->set_name("hseparator9");
   label22->set_name("label22");
   label22->set_alignment(0.5, 0.5);
   label22->set_padding(0, 0);
   combo3->get_entry()->set_name("combo-entry3");
   combo3->get_entry()->set_editable(true);
   combo3->set_name("combo3");
   {

      const char *items[] = { "", 0 };
      combo3->set_popdown_strings(items);
   }
   combo3->get_entry()->set_name("combo-entry3");
   combo3->get_entry()->set_editable(true);
   vbox12->set_name("vbox12");
   vbox12->pack_start(*label21, false, false, 0);
   vbox12->pack_start(*hseparator9, false, false, 0);
   vbox12->pack_start(*label22, false, false, 6);
   vbox12->pack_start(*combo3, false, false, 0);
   hbox10->set_name("hbox10");
   hbox10->pack_start(*vbox12);

   hseparator10->set_usize(-1, 9);
   hseparator10->set_name("hseparator10");
   label23->set_name("label23");
   label23->set_alignment(0.5, 0.5);
   label23->set_padding(0, 0);
   hseparator11->set_usize(-1, 11);
   hseparator11->set_name("hseparator11");
   label24->set_name("label24");
   label24->set_alignment(0.5, 0.5);
   label24->set_padding(0, 0);
   radiobutton_tracker_post_volume_nothing->set_name("radiobutton_tracker_post_volume_nothing");
   radiobutton_tracker_post_volume_note_aftertouch->set_name("radiobutton_tracker_post_volume_note_aftertouch");
   radiobutton_tracker_post_volume_channel_aftertouch->set_name("radiobutton_tracker_post_volume_channel_aftertouch");
   radiobutton_tracker_post_volume_controller->set_name("radiobutton_tracker_post_volume_controller");
   spinbutton_track_volume_post_controller->set_usize(60, -1);
   spinbutton_track_volume_post_controller->set_name("spinbutton_track_volume_post_controller");
   spinbutton_track_volume_post_controller->set_editable(true);
   hbox12->set_usize(134, -1);
   hbox12->set_name("hbox12");
   hbox12->pack_start(*radiobutton_tracker_post_volume_controller, false, false, 0);
   hbox12->pack_end(*spinbutton_track_volume_post_controller, true, false, 0);
   vbox14->set_name("vbox14");
   vbox14->pack_start(*label24, false, false, 0);
   vbox14->pack_start(*radiobutton_tracker_post_volume_nothing, false, false, 0);
   vbox14->pack_start(*radiobutton_tracker_post_volume_note_aftertouch, false, false, 0);
   vbox14->pack_start(*radiobutton_tracker_post_volume_channel_aftertouch, false, false, 0);
   vbox14->pack_start(*hbox12, false, true, 0);
   hbox11->set_name("hbox11");
   hbox11->pack_start(*vbox14);
   hseparator12->set_name("hseparator12");
   label25->set_name("label25");
   label25->set_alignment(0.5, 0.5);
   label25->set_padding(0, 0);
   radiobutton_track_volume_behavior_normal->set_name("radiobutton_track_volume_behavior_normal");
   label26->set_name("label26");
   label26->set_alignment(0.5, 0.5);
   label26->set_padding(0, 0);
   radiobutton_track_volume_behavior_tracker->set_name("radiobutton_track_volume_behavior_tracker");
   vbox13->set_name("vbox13");
   vbox13->pack_start(*label23, false, false, 0);
   vbox13->pack_start(*hseparator11, false, false, 0);
   vbox13->pack_start(*hbox11);
   vbox13->pack_start(*hseparator12);
   vbox13->pack_start(*label25, false, false, 0);
   vbox13->pack_start(*radiobutton_track_volume_behavior_normal, false, false, 0);
   vbox13->pack_start(*label26, false, false, 0);
   vbox13->pack_start(*radiobutton_track_volume_behavior_tracker, false, false, 0);
   vbox7->set_name("vbox7");
   vbox7->pack_start(*hseparator4, false, true, 0);
   vbox7->pack_start(*table1, false, true, 0);
   vbox7->pack_start(*hseparator5, false, false, 0);
   vbox7->pack_start(*table2, false, true, 0);
   vbox7->pack_start(*hseparator6, false, true, 0);
   vbox7->pack_start(*hbox10, false, true, 0);
   vbox7->pack_start(*hseparator10, false, false, 0);
   vbox7->pack_start(*vbox13);
   label8->set_name("label8");
   label8->set_alignment(0.5, 0.5);
   label8->set_padding(0, 0);
   hseparator7->set_usize(-1, 11);
   hseparator7->set_name("hseparator7");
   label27->set_name("label27");
   label27->set_alignment(0.5, 0.5);
   label27->set_padding(0, 0);
   label28->set_name("label28");
   label28->set_alignment(0.5, 0.5);
   label28->set_padding(0, 0);
   label29->set_name("label29");
   label29->set_alignment(0.5, 0.5);
   label29->set_padding(0, 0);
   hbox13->set_name("hbox13");
   hbox13->pack_start(*label27, false, false, 0);
   hbox13->pack_end(*button4, false, false, 0);
   hbox13->pack_end(*label28, false, false, 0);

   hseparator13->set_usize(-1, 9);
   hseparator13->set_name("hseparator13");

   vbox10->set_name("vbox10");
   vbox10->pack_start(*hseparator7, false, false, 0);
   vbox10->pack_start(*hbox13, false, false, 0);
   vbox10->pack_start(*hseparator13, false, false, 0);

   vbox9->pack_start(*vbox10, false, false, 3);
   /*** CONTROLLER LIST ***/

   vbox9->set_name("vbox9");
   //vbox9->pack_start(*vbox10);
   viewport1->set_name("viewport1");
   viewport1->add(*vbox9);
   scrolledwindow1->set_name("scrolledwindow1");
   scrolledwindow1->set_policy(GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
   scrolledwindow1->add(*viewport1);
   vbox8->set_name("vbox8");
   vbox8->pack_start(*scrolledwindow1);
   label9->set_name("label9");
   label9->set_alignment(0.5, 0.5);
   label9->set_padding(0, 0);
   hseparator8->set_usize(-1, 11);
   hseparator8->set_name("hseparator8");
   entry2->set_usize(52, -1);
   entry2->set_name("entry2");
   entry2->set_editable(true);
   entry2->set_text("9F");
   hbox8->set_name("hbox8");
   hbox8->pack_start(*entry2, false, false, 21);
   vbox11->set_name("vbox11");
   vbox11->pack_start(*hseparator8, false, false, 0);
   vbox11->pack_start(*hbox8);
   label14->set_name("label14");
   label14->set_alignment(0.5, 0.5);
   label14->set_padding(0, 0);
   notebook1->set_name("notebook1");
   notebook1->set_show_tabs(true);
   notebook1->set_tab_border(3);
//   scrolledwindow_track_patch->add_with_viewport(*vbox6);
//   notebook1->pages().push_back(Gtk::Notebook_Helpers::TabElem(*scrolledwindow_track_patch, *label7));
   notebook1->pages().push_back(Gtk::Notebook_Helpers::TabElem(*vbox6, *label7));
   notebook1->pages().push_back(Gtk::Notebook_Helpers::TabElem(*trackprops_idata_scrolledwindow, *label8));
   notebook1->pages().push_back(Gtk::Notebook_Helpers::TabElem(*vbox8, *label9));
//   notebook1->pages().push_back(Gtk::Notebook_Helpers::TabElem(*vbox11, *label14));
   trackprops_idata_scrolledwindow->set_policy(GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
   trackprops_idata_scrolledwindow->add_with_viewport(*vbox7);

   vbox5->set_name("vbox5");
   vbox5->pack_start(*label6, false, false, 0);
   vbox5->pack_start(*hseparator1, false, false, 0);
   vbox5->pack_start(*notebook1);
   hbox1->set_name("hbox1");
   hbox1->pack_start(*hbox2);
   hbox1->pack_start(*vbox5, false, false, 0);

   info_frame_viewport.show();
   entry_track_selected_patch->show();
   labelx->show();
   track_list->show();
   viewport2->show();
   scrolledwindow2->show();
   labelx2->show();
   entry_track_name->show();
   button_track_moveup->show();
   button_track_movedown->show();
   vseparator2->show();
   button7->show();
   togglebutton_track_mute->show();
   hbox9->show();
   button_track_remove->show();
   button_track_new->show();
   button_track_clone->show();
   hbox3->show();
   vbox1->show();
   vseparator1->show();
   hbox2->show();
   label6->show();
   hseparator1->show();
   hseparator2->show();
   label10->show();
   combo_track_devices->show();
   label11->show();
   combo_track_banks->show();
   label12->show();
   clist_track_patches->show();
   viewport3->show();
   scrolledwindow3->show();
   hseparator3->show();
   label13->show();
   spinbutton_track_channel->show();
   hbox6->show();
   button4->show();
   vbox6->show();
   label7->show();
   hseparator4->show();
   label16->show();
   spinbutton_track_def_volume->show();
   spinbutton_track_glb_volume->show();
   label15->show();
   table1->show();
   hseparator5->show();
   spinbutton_track_bender_def->show();
   label18->show();
   spinbutton_track_bender_sens->show();
   label17->show();
   table2->show();
   hseparator6->show();
   label21->show();
   hseparator9->show();
   label22->show();
   combo3->show();
   vbox12->show();

   hbox10->show();
   hseparator10->show();
   label23->show();
   hseparator11->show();
   label24->show();
   radiobutton_tracker_post_volume_nothing->show();
   radiobutton_tracker_post_volume_note_aftertouch->show();
   radiobutton_tracker_post_volume_channel_aftertouch->show();
   radiobutton_tracker_post_volume_controller->show();
   spinbutton_track_volume_post_controller->show();
   hbox12->show();
   vbox14->show();
   hbox11->show();
   hseparator12->show();
   label25->show();
   radiobutton_track_volume_behavior_normal->show();
   label26->show();
   radiobutton_track_volume_behavior_tracker->show();
   vbox13->show();
   vbox7->show();
   label8->show();
   hseparator7->show();
   label27->show();
   label28->show();
   label29->show();
   hbox13->show();
   hseparator13->show();

   vbox10->show();
   vbox9->show();
   viewport1->show();
   scrolledwindow1->show();
   vbox8->show();
   label9->show();
   hseparator8->show();
   entry2->show();
   hbox8->show();
   vbox11->show();
   label14->show();
   notebook1->show();
//   vbox5->show();
   hbox1->show();
   trackprops_idata_scrolledwindow->show();

   GenericLabel = new Gtk::Label("Track Properties");
   main_notebook.append_page(*hbox1,*GenericLabel);

// CALLBACKS
   //buttons
   button_track_new->clicked.connect(slot(this,&Interface::button_track_new_pressed));
   button_track_remove->clicked.connect(slot(this,&Interface::button_track_remove_pressed));
   button_track_moveup->clicked.connect(slot(this,&Interface::button_track_moveup_pressed));
   button_track_movedown->clicked.connect(slot(this,&Interface::button_track_movedown_pressed));
   button_track_clone->clicked.connect(slot(this,&Interface::button_track_clone_pressed));
//   button4->pressed.connect(slot(this,&Interface::button_track_add_variables_pressed));
   button4->clicked.connect(slot(this,&Interface::button_track_add_variables_pressed));
   //clists

   track_list->select_row.connect(slot(this,&Interface::clist_track_list_row_clicked));	
   clist_track_patches->select_row.connect(slot(this,&Interface::clist_track_patches_row_clicked));	

   //entries

   combo_track_devices->get_entry()->changed.connect(slot(this,&Interface::combo_track_devices_changed));
   combo_track_banks->get_entry()->changed.connect(slot(this,&Interface::combo_track_banks_changed));
   entry_track_name->changed.connect(slot(this,&Interface::entry_track_name_changed));

   //spinbuttons	


   spinbutton_track_channel_adj->value_changed.connect(slot(this,&Interface::spinbutton_track_channel_adj_changed));
   spinbutton_track_def_volume_adj->value_changed.connect(slot(this,&Interface::spinbutton_track_def_volume_adj_changed));
   spinbutton_track_glb_volume_adj->value_changed.connect(slot(this,&Interface::spinbutton_track_glb_volume_adj_changed));
   spinbutton_track_bender_sens_adj->value_changed.connect(slot(this,&Interface::spinbutton_track_bender_sens_adj_changed));
   spinbutton_track_bender_def_adj->value_changed.connect(slot(this,&Interface::spinbutton_track_bender_def_adj_changed));
   spinbutton_track_volume_post_controller_adj->value_changed.connect(slot(this,&Interface::spinbutton_track_volume_post_controller_adj_changed));

   //radiobuttons

   radiobutton_tracker_post_volume_nothing->pressed.connect(slot(this,&Interface::radiobutton_tracker_post_volume_nothing_changed));
   radiobutton_tracker_post_volume_note_aftertouch->pressed.connect(slot(this,&Interface::radiobutton_tracker_post_volume_note_aftertouch_changed));
   radiobutton_tracker_post_volume_channel_aftertouch->pressed.connect(slot(this,&Interface::radiobutton_tracker_post_volume_channel_aftertouch_changed));
   radiobutton_tracker_post_volume_controller->pressed.connect(slot(this,&Interface::radiobutton_tracker_post_volume_controller_changed));
   radiobutton_track_volume_behavior_normal->pressed.connect(slot(this,&Interface::radiobutton_track_volume_behavior_normal_changed));
   radiobutton_track_volume_behavior_tracker->pressed.connect(slot(this,&Interface::radiobutton_track_volume_behavior_tracker_changed));
	
   // toggles

   togglebutton_track_mute->pressed.connect(slot(this,&Interface::togglebutton_track_mute_pressed));

//   main_notebook->set_events(GDK_KEY_PRESS_MASK|GDK_POINTER_MOTION_MASK|GDK_BUTTON_PRESS_MASK|GDK_BUTTON_RELEASE_MASK|GDK_VISIBILITY_NOTIFY_MASK|GDK_EXPOSURE_MASK);

   //****************************
   // USER MIDI DEVICE PROPERTIES
   //****************************

   label30 = new Gtk::Label("User Device");
   hseparator14 = new Gtk::HSeparator();
   clist_virtual_devices = new Gtk::CList(1);
   viewport4 = new Gtk::Viewport();
   scrolledwindow4 = new Gtk::ScrolledWindow();
   button_virtual_device_add = new Gtk::Button("New");
   button_virtual_device_delete = new Gtk::Button("Delete");
   label37 = new Gtk::Label("      -      ");
   button_virtual_device_load = new Gtk::Button("Load");
   button_virtual_device_save = new Gtk::Button("Save");
   hbox15 = new Gtk::HBox(false, 0);
   label31 = new Gtk::Label("Name");
   entry_virtual_device_name = new Gtk::Entry();
   hseparator15 = new Gtk::HSeparator();
   label32 = new Gtk::Label("Hardware Device");
   combo_virtual_device_hardware_output = new Gtk::Combo();
   vbox16 = new Gtk::VBox(false, 0);
   frame1 = new Gtk::Frame("Output Properties:");
   vbox15 = new Gtk::VBox(false, 0);
   vseparator3 = new Gtk::VSeparator();
   label33 = new Gtk::Label("Properties");
   hseparator16 = new Gtk::HSeparator();
   label36 = new Gtk::Label("Aviable:");
   clist_aviable_banks = new Gtk::CList(1);
   viewport5 = new Gtk::Viewport();
   scrolledwindow5 = new Gtk::ScrolledWindow();
   button_bank_add = new Gtk::Button("New Bank");
   button_bank_delete = new Gtk::Button("Delete Bank");
   hbox17 = new Gtk::HBox(false, 0);
   label38 = new Gtk::Label("Bank Name");
   entry_bank_name = new Gtk::Entry();
   hseparator17 = new Gtk::HSeparator();
   label39 = new Gtk::Label("Bank Select Method");
   radio_bsm_option1 = new Gtk::RadioButton("Do not perform Bank Select");	
   radio_bsm_option2 = new Gtk::RadioButton("Bank Selection Controllers(0/32):");
   radio_bsm_option2->set_group(radio_bsm_option1->group());
   hbox20 = new Gtk::HBox(false, 0);
   label40 = new Gtk::Label("MSB:");
   label41 = new Gtk::Label("LSB:");
   spinbutton_bank_lsb_adj = new Gtk::Adjustment(0, 0, 127, 1, 10, 10);
   spinbutton_bank_lsb = new Gtk::SpinButton(*spinbutton_bank_lsb_adj, 1, 0);
   spinbutton_bank_msb_adj = new Gtk::Adjustment(0, 0, 127, 1, 10, 10);
   spinbutton_bank_msb = new Gtk::SpinButton(*spinbutton_bank_msb_adj, 1, 0);
   table3 = new Gtk::Table(2, 2, false);
   radio_bsm_option3 = new Gtk::RadioButton("Custon MIDI string:");
   radio_bsm_option3->set_group(radio_bsm_option1->group());
   hbox21 = new Gtk::HBox(false, 0);
   entry_bank_customstring = new Gtk::Entry();
   vbox20 = new Gtk::VBox(false, 0);
   frame2 = new Gtk::Frame("Properties:");
   vbox19 = new Gtk::VBox(false, 0);
   vseparator4 = new Gtk::VSeparator();
   clist_bank_patchnames = new Gtk::CList(1);
   viewport6 = new Gtk::Viewport();
   scrolledwindow6 = new Gtk::ScrolledWindow();
   label42 = new Gtk::Label("Name:");
   entry_bank_patchname = new Gtk::Entry();
   vbox22 = new Gtk::VBox(false, 0);
   frame3 = new Gtk::Frame("Patch Names:");
   hbox16 = new Gtk::HBox(false, 0);
   vbox18 = new Gtk::VBox(false, 0);
   label34 = new Gtk::Label("Banks");
   label43 = new Gtk::Label("Controller:");
   clist_bank_controller_names = new Gtk::CList(1);
   viewport7 = new Gtk::Viewport();
   scrolledwindow7 = new Gtk::ScrolledWindow();
   label44 = new Gtk::Label("Name:");
   entry_controller_name = new Gtk::Entry();
   vbox23 = new Gtk::VBox(false, 0);
   label35 = new Gtk::Label("Controller Names");
   notebook2 = new Gtk::Notebook();
   vbox17 = new Gtk::VBox(false, 0);
   hbox14 = new Gtk::HBox(false, 0);
   label30->set_name("label30");
   label30->set_alignment(0.5, 0.5);
   label30->set_padding(0, 0);
   hseparator14->set_name("hseparator14");
   clist_virtual_devices->set_name("clist_virtual_devices");
   viewport4->set_name("viewport4");
   viewport4->add(*clist_virtual_devices);
   scrolledwindow4->set_name("scrolledwindow4");
   scrolledwindow4->set_policy(GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
   scrolledwindow4->add(*viewport4);
   button_virtual_device_add->set_name("button_virtual_device_add");
   button_virtual_device_add->set_border_width(3);
   button_virtual_device_delete->set_name("button_virtual_device_delete");
   button_virtual_device_delete->set_border_width(3);
   label37->set_name("label37");
   label37->set_alignment(0.5, 0.5);
   label37->set_padding(0, 0);
   button_virtual_device_load->set_name("button_virtual_device_load");
   button_virtual_device_load->set_border_width(3);
   button_virtual_device_save->set_name("button_virtual_device_save");
   button_virtual_device_save->set_border_width(3);
   hbox15->set_name("hbox15");
   hbox15->pack_start(*button_virtual_device_add, false, false, 0);
   hbox15->pack_start(*button_virtual_device_delete, false, false, 0);
   hbox15->pack_start(*label37, false, false, 0);
   hbox15->pack_start(*button_virtual_device_load, false, false, 0);
   hbox15->pack_start(*button_virtual_device_save, false, false, 0);
   label31->set_name("label31");
   label31->set_alignment(0.5, 0.5);
   label31->set_padding(0, 0);
   entry_virtual_device_name->set_name("entry_virtual_device_name");
   entry_virtual_device_name->set_editable(true);
   hseparator15->set_usize(-1, 9);
   hseparator15->set_name("hseparator15");
   label32->set_name("label32");
   label32->set_alignment(0.5, 0.5);
   label32->set_padding(0, 0);
   combo_virtual_device_hardware_output->get_entry()->set_name("combo-entry4");
   combo_virtual_device_hardware_output->get_entry()->set_editable(false);
   combo_virtual_device_hardware_output->set_name("combo_virtual_device_hardware_output");
   {

      const char *items[] = { "", 0 };
      combo_virtual_device_hardware_output->set_popdown_strings(items);
   }
   combo_virtual_device_hardware_output->get_entry()->set_name("combo-entry4");
   combo_virtual_device_hardware_output->get_entry()->set_editable(true);
   vbox16->set_name("vbox16");
   vbox16->set_border_width(11);
   vbox16->pack_start(*label31, false, false, 0);
   vbox16->pack_start(*entry_virtual_device_name, false, false, 0);
   vbox16->pack_start(*hseparator15, false, true, 0);
   vbox16->pack_start(*label32, false, false, 0);
   vbox16->pack_start(*combo_virtual_device_hardware_output, false, false, 0);
   frame1->set_name("frame1");
   frame1->set_border_width(5);
   frame1->set_label_align(0, 0);
   frame1->set_shadow_type(GTK_SHADOW_ETCHED_IN);
   frame1->add(*vbox16);
   vbox15->set_name("vbox15");
   vbox15->pack_start(*label30, false, false, 0);
   vbox15->pack_start(*hseparator14, false, false, 6);
   vbox15->pack_start(*scrolledwindow4);
   vbox15->pack_start(*hbox15, false, true, 0);
   vbox15->pack_start(*frame1, false, false, 0);
   vseparator3->set_usize(11, -1);
   vseparator3->set_name("vseparator3");
   label33->set_name("label33");
   label33->set_alignment(0.5, 0.5);
   label33->set_padding(0, 0);
   hseparator16->set_usize(-1, 14);
   hseparator16->set_name("hseparator16");
   label36->set_name("label36");
   label36->set_alignment(0.5, 0.5);
   label36->set_padding(0, 0);
   clist_aviable_banks->set_name("clist_aviable_banks");
   viewport5->set_name("viewport5");
   viewport5->add(*clist_aviable_banks);
   scrolledwindow5->set_name("scrolledwindow5");
   scrolledwindow5->set_policy(GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
   scrolledwindow5->add(*viewport5);
   button_bank_add->set_name("button_bank_add");
   button_bank_add->set_border_width(3);
   button_bank_delete->set_name("button_bank_delete");
   button_bank_delete->set_border_width(3);
   hbox17->set_name("hbox17");
   hbox17->pack_start(*button_bank_add, false, false, 0);
   hbox17->pack_end(*button_bank_delete, false, false, 0);
   label38->set_name("label38");
   label38->set_alignment(0.5, 0.5);
   label38->set_padding(0, 0);
   entry_bank_name->set_name("entry_bank_name");
   entry_bank_name->set_editable(true);
   hseparator17->set_usize(-1, 8);
   hseparator17->set_name("hseparator17");
   label39->set_name("label39");
   label39->set_alignment(0.5, 0.5);
   label39->set_padding(0, 0);
   radio_bsm_option1->set_name("radio_bsm_option1");
   radio_bsm_option2->set_name("radio_bsm_option2");
   hbox20->set_name("hbox20");
   hbox20->pack_start(*radio_bsm_option2, false, false, 0);
   label40->set_name("label40");
   label40->set_alignment(0.5, 0.5);
   label40->set_padding(0, 0);
   label41->set_name("label41");
   label41->set_alignment(0.5, 0.5);
   label41->set_padding(0, 0);
   spinbutton_bank_lsb->set_usize(59, -1);
   spinbutton_bank_lsb->set_name("spinbutton_bank_lsb");
   spinbutton_bank_lsb->set_editable(true);
   spinbutton_bank_msb->set_usize(59, -1);
   spinbutton_bank_msb->set_name("spinbutton_bank_msb");
   spinbutton_bank_msb->set_editable(true);
   table3->set_name("table3");
   table3->attach(*label40, 0, 1, 0, 1, 0, 0, 0, 0);
   table3->attach(*label41, 1, 2, 0, 1, 0, 0, 0, 0);
   table3->attach(*spinbutton_bank_lsb, 1, 2, 1, 2, 0, 0, 12, 0);
   table3->attach(*spinbutton_bank_msb, 0, 1, 1, 2, 0, 0, 12, 0);
   radio_bsm_option3->set_name("radio_bsm_option3");
   hbox21->set_name("hbox21");
   hbox21->pack_start(*radio_bsm_option3, false, false, 0);
   entry_bank_customstring->set_name("entry_bank_customstring");
   entry_bank_customstring->set_editable(true);
   vbox20->set_name("vbox20");
   vbox20->set_border_width(5);
   vbox20->pack_start(*label38, false, false, 0);
   vbox20->pack_start(*entry_bank_name, false, false, 0);
   vbox20->pack_start(*hseparator17, false, false, 0);
   vbox20->pack_start(*label39, false, false, 0);
   vbox20->pack_start(*radio_bsm_option1, false, false, 0);
   vbox20->pack_start(*hbox20);
   vbox20->pack_start(*table3, false, false, 0);
   vbox20->pack_start(*hbox21);
   vbox20->pack_start(*entry_bank_customstring, false, false, 0);
   frame2->set_name("frame2");
   frame2->set_border_width(3);
   frame2->set_label_align(0, 0);
   frame2->set_shadow_type(GTK_SHADOW_ETCHED_IN);
   frame2->add(*vbox20);
   vbox19->set_name("vbox19");
   vbox19->pack_start(*label36, false, false, 0);
   vbox19->pack_start(*scrolledwindow5);
   vbox19->pack_start(*hbox17, false, true, 0);
   vbox19->pack_start(*frame2, false, false, 0);
   vseparator4->set_usize(12, -1);
   vseparator4->set_name("vseparator4");
   clist_bank_patchnames->set_name("clist_bank_patchnames");
   viewport6->set_name("viewport6");
   viewport6->add(*clist_bank_patchnames);
   scrolledwindow6->set_name("scrolledwindow6");
   scrolledwindow6->set_policy(GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
   scrolledwindow6->add(*viewport6);
   label42->set_name("label42");
   label42->set_alignment(0.5, 0.5);
   label42->set_padding(0, 0);
   entry_bank_patchname->set_name("entry_bank_patchname");
   entry_bank_patchname->set_editable(true);
   vbox22->set_name("vbox22");
   vbox22->set_border_width(5);
   vbox22->pack_start(*scrolledwindow6);
   vbox22->pack_start(*label42, false, false, 0);
   vbox22->pack_start(*entry_bank_patchname, false, false, 0);
   frame3->set_name("frame3");
   frame3->set_border_width(5);
   frame3->set_label_align(0, 0);
   frame3->set_shadow_type(GTK_SHADOW_ETCHED_IN);
   frame3->add(*vbox22);
   hbox16->set_name("hbox16");
   hbox16->pack_start(*vbox19);
   hbox16->pack_start(*vseparator4, false, false, 0);
   hbox16->pack_start(*frame3);
   vbox18->set_name("vbox18");
   vbox18->pack_start(*hbox16);
   label34->set_name("label34");
   label34->set_alignment(0.5, 0.5);
   label34->set_padding(0, 0);
   label43->set_name("label43");
   label43->set_alignment(0.5, 0.5);
   label43->set_padding(0, 0);
   clist_bank_controller_names->set_name("clist_bank_controller_names");
   viewport7->set_name("viewport7");
   viewport7->add(*clist_bank_controller_names);
   scrolledwindow7->set_name("scrolledwindow7");
   scrolledwindow7->set_policy(GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
   scrolledwindow7->add(*viewport7);
   label44->set_name("label44");
   label44->set_alignment(0.5, 0.5);
   label44->set_padding(0, 0);
   entry_controller_name->set_name("clist_bank_controller_name");
   entry_controller_name->set_editable(true);
   vbox23->set_name("vbox23");
   vbox23->pack_start(*label43, false, false, 0);
   vbox23->pack_start(*scrolledwindow7);
   vbox23->pack_start(*label44, false, false, 0);
   vbox23->pack_start(*entry_controller_name, false, false, 0);
   label35->set_name("label35");
   label35->set_alignment(0.5, 0.5);
   label35->set_padding(0, 0);
   notebook2->set_name("notebook2");
   notebook2->set_show_tabs(true);
   notebook2->set_tab_border(3);
   notebook2->pages().push_back(Gtk::Notebook_Helpers::TabElem(*vbox18, *label34));
   notebook2->pages().push_back(Gtk::Notebook_Helpers::TabElem(*vbox23, *label35));
   vbox17->set_name("vbox17");
   vbox17->pack_start(*label33, false, false, 0);
   vbox17->pack_start(*hseparator16, false, false, 0);
   vbox17->pack_start(*notebook2);
   hbox14->set_name("hbox14");
   hbox14->pack_start(*vbox15, false, false, 0);
   hbox14->pack_start(*vseparator3, false, false, 0);
   hbox14->pack_start(*vbox17);
   label30->show();
   hseparator14->show();
   clist_virtual_devices->show();
   viewport4->show();
   scrolledwindow4->show();
   button_virtual_device_add->show();
   button_virtual_device_delete->show();
   label37->show();
   button_virtual_device_load->show();
   button_virtual_device_save->show();
   hbox15->show();
   label31->show();
   entry_virtual_device_name->show();
   hseparator15->show();
   label32->show();
   combo_virtual_device_hardware_output->show();
   vbox16->show();
   frame1->show();
   vbox15->show();
   vseparator3->show();
   label33->show();
   hseparator16->show();
   label36->show();
   clist_aviable_banks->show();
   viewport5->show();
   scrolledwindow5->show();
   button_bank_add->show();
   button_bank_delete->show();
   hbox17->show();
   label38->show();
   entry_bank_name->show();
   hseparator17->show();
   label39->show();
   radio_bsm_option1->show();
   radio_bsm_option2->show();
   hbox20->show();
   label40->show();
   label41->show();
   spinbutton_bank_lsb->show();
   spinbutton_bank_msb->show();
   table3->show();
   radio_bsm_option3->show();
   hbox21->show();
   entry_bank_customstring->show();
   vbox20->show();
   frame2->show();
   vbox19->show();
   vseparator4->show();
   clist_bank_patchnames->show();
   viewport6->show();
   scrolledwindow6->show();
   label42->show();
   entry_bank_patchname->show();
   vbox22->show();
   frame3->show();
   hbox16->show();
   vbox18->show();
   label34->show();
   label43->show();
   clist_bank_controller_names->show();
   viewport7->show();
   scrolledwindow7->show();
   label44->show();
   entry_controller_name->show();
   vbox23->show();
   label35->show();
   notebook2->show();
   vbox17->show();
   hbox14->show();
   scrolledwindow_track_patch->show();	
// CALLBACKS
   //combos
   combo_virtual_device_hardware_output->get_entry()->changed.connect(slot(this,&Interface::combo_virtual_device_hardware_output_changed));	

   //buttons

   button_virtual_device_load->clicked.connect(slot(this,&Interface::button_virtual_device_load_pressed));
   button_virtual_device_save->clicked.connect(slot(this,&Interface::button_virtual_device_save_pressed));
   button_virtual_device_add->pressed.connect(slot(this,&Interface::button_virtual_device_add_pressed));
   button_virtual_device_delete->pressed.connect(slot(this,&Interface::button_virtual_device_delete_pressed));
   button_bank_add->pressed.connect(slot(this,&Interface::button_bank_add_pressed));
   button_bank_delete->pressed.connect(slot(this,&Interface::button_bank_delete_pressed));

   //clists
   clist_virtual_devices->select_row.connect(slot(this,&Interface::clist_virtual_devices_clicked));	
   clist_aviable_banks->select_row.connect(slot(this,&Interface::clist_aviable_banks_clicked));	
   clist_bank_patchnames->select_row.connect(slot(this,&Interface::clist_bank_patchnames_clicked));	
   clist_bank_controller_names->select_row.connect(slot(this,&Interface::clist_bank_controller_names_clicked));

   //entries

   entry_virtual_device_name->changed.connect(slot(this,&Interface::entry_virtual_device_name_changed));
   entry_bank_name->changed.connect(slot(this,&Interface::entry_bank_name_changed));
   entry_bank_patchname->changed.connect(slot(this,&Interface::entry_bank_patchname_changed));
   entry_controller_name->changed.connect(slot(this,&Interface::entry_controller_name_changed));
   //spins

   spinbutton_bank_lsb_adj->value_changed.connect(slot(this,&Interface::spinbutton_bank_lsb_adj_value_changed));
   spinbutton_bank_msb_adj->value_changed.connect(slot(this,&Interface::spinbutton_bank_msb_adj_value_changed));

   //radios

   radio_bsm_option1->pressed.connect(slot(this,&Interface::radio_bsm_option1_pressed));
   radio_bsm_option2->pressed.connect(slot(this,&Interface::radio_bsm_option2_pressed));
   radio_bsm_option3->pressed.connect(slot(this,&Interface::radio_bsm_option3_pressed));

/**********************
   ORDERLIST
***************************/


   GenericLabel = new Gtk::Label("Orders");
   main_notebook.append_page(orderlist,*GenericLabel);
   orderlist.show();

/***************************
   SONG VARIABLES & INFO
****************************/

   label68 = new Gtk::Label("Song Speed");
   hseparator22 = new Gtk::HSeparator();
   label69 = new Gtk::Label("Rows per Quarter Note:");
   label70 = new Gtk::Label("Tempo:");
   spinbutton_song_rpq_adj = new Gtk::Adjustment(1, 0, 255, 1, 10, 10);
   spinbutton_song_rpq = new Gtk::SpinButton(*spinbutton_song_rpq_adj, 1, 0);
   spinbutton_song_tempo_adj = new Gtk::Adjustment(1, 0, 255, 1, 10, 10);
   spinbutton_song_tempo = new Gtk::SpinButton(*spinbutton_song_tempo_adj, 1, 0);
   table8 = new Gtk::Table(2, 2, false);
   hseparator24 = new Gtk::HSeparator();
   pixmap_shake_logo = new Gtk::Pixmap((gchar **)sht_xpm);
   vbox29 = new Gtk::VBox(false, 0);
   vseparator7 = new Gtk::VSeparator();
   label71 = new Gtk::Label("Song Info");
   hseparator23 = new Gtk::HSeparator();
   label72 = new Gtk::Label("Title:");
   entry_song_title = new Gtk::Entry();
   label73 = new Gtk::Label("Author:");
   entry_song_author = new Gtk::Entry();
   label74 = new Gtk::Label("Comments:");
   textarea_song_comments = new Gtk::Text();
   scrolledwindow10 = new Gtk::ScrolledWindow();
   vbox30 = new Gtk::VBox(false, 0);
   hbox24 = new Gtk::HBox(false, 0);
   label68->set_name("label68");
   label68->set_alignment(0.5, 0.5);
   label68->set_padding(0, 0);
   hseparator22->set_name("hseparator22");
   label69->set_name("label69");
   label69->set_alignment(0.5, 0.5);
   label69->set_padding(0, 0);
   label70->set_name("label70");
   label70->set_alignment(0.5, 0.5);
   label70->set_padding(0, 0);
   spinbutton_song_rpq->set_usize(60, -1);
   spinbutton_song_rpq->set_name("spinbutton_song_rpq");
   spinbutton_song_rpq->set_editable(true);
   spinbutton_song_tempo->set_usize(60, -1);
   spinbutton_song_tempo->set_name("spinbutton_song_tempo");
   spinbutton_song_tempo->set_editable(true);
   table8->set_name("table8");
   table8->attach(*label69, 0, 1, 0, 1, 0, 0, 0, 0);
   table8->attach(*label70, 0, 1, 1, 2, 0, 0, 0, 0);
   table8->attach(*spinbutton_song_rpq, 1, 2, 0, 1, 0, 0, 0, 3);
   table8->attach(*spinbutton_song_tempo, 1, 2, 1, 2, 0, 0, 0, 0);
   hseparator24->set_name("hseparator24");
   pixmap_shake_logo->set_name("pixmap_shake_logo");
   pixmap_shake_logo->set_alignment(0.5, 0.5);
   pixmap_shake_logo->set_padding(0, 0);
   vbox29->set_name("vbox29");
   vbox29->pack_start(*label68, false, false, 0);
   vbox29->pack_start(*hseparator22, false, false, 3);
   vbox29->pack_start(*table8, false, false, 2);
   vbox29->pack_start(*hseparator24, false, false, 6);
   logo_viewport.add(*pixmap_shake_logo);
   vbox29->pack_start(logo_viewport);
   logo_viewport.show();
   vseparator7->set_name("vseparator7");
   label71->set_name("label71");
   label71->set_alignment(0.5, 0.5);
   label71->set_padding(0, 0);
   hseparator23->set_name("hseparator23");
   label72->set_name("label72");
   label72->set_alignment(0.5, 0.5);
   label72->set_padding(0, 0);
   entry_song_title->set_name("entry_song_title");
   entry_song_title->set_editable(true);
   label73->set_name("label73");
   label73->set_alignment(0.5, 0.5);
   label73->set_padding(0, 0);
   entry_song_author->set_name("entry_song_author");
   entry_song_author->set_editable(true);
   label74->set_name("label74");
   label74->set_alignment(0.5, 0.5);
   label74->set_padding(0, 0);
   textarea_song_comments->set_name("textarea_song_comments");
   textarea_song_comments->set_editable(true);
   textarea_song_comments->set_word_wrap(false);
   textarea_song_comments->set_point(0);
   scrolledwindow10->set_name("scrolledwindow10");
   scrolledwindow10->set_policy(GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
   scrolledwindow10->add(*textarea_song_comments);
   vbox30->set_name("vbox30");
   vbox30->pack_start(*label71, false, false, 0);
   vbox30->pack_start(*hseparator23, false, false, 3);
   vbox30->pack_start(*label72, false, false, 0);
   vbox30->pack_start(*entry_song_title, false, false, 0);
   vbox30->pack_start(*label73, false, false, 0);
   vbox30->pack_start(*entry_song_author, false, false, 0);
   vbox30->pack_start(*label74, false, false, 0);
   vbox30->pack_start(*scrolledwindow10);
   hbox24->set_name("hbox24");
   hbox24->pack_start(*vbox29);
   hbox24->pack_start(*vseparator7, false, false, 3);
   hbox24->pack_start(*vbox30);
   label68->show();
   hseparator22->show();
   label69->show();
   label70->show();
   spinbutton_song_rpq->show();
   spinbutton_song_tempo->show();
   table8->show();
   hseparator24->show();
   pixmap_shake_logo->show();
   vbox29->show();
   vseparator7->show();
   label71->show();
   hseparator23->show();
   label72->show();
   entry_song_title->show();
   label73->show();
   entry_song_author->show();
   label74->show();
   textarea_song_comments->show();
   scrolledwindow10->show();
   vbox30->show();
   hbox24->show();

   spinbutton_song_rpq_adj->value_changed.connect(slot(this,&Interface::spinbutton_song_rpq_value_changed));
   spinbutton_song_tempo_adj->value_changed.connect(slot(this,&Interface::spinbutton_song_tempo_value_changed));

   GenericLabel = new Gtk::Label("Song Speed/Info");
   main_notebook.append_page(*hbox24,*GenericLabel);


   GenericLabel = new Gtk::Label("User Devices");
   main_notebook.append_page(*hbox14,*GenericLabel);

/*******************
 SYSTEM SCREEN
*******************/
   label45 = new Gtk::Label("Midi Out Drivers:");
   hseparator18 = new Gtk::HSeparator();
   clist_drivers_list = new Gtk::CList(1);
   viewport8 = new Gtk::Viewport();
   scrolledwindow8 = new Gtk::ScrolledWindow();
   label46 = new Gtk::Label("Parent Driver:");
   entry_drivers_parent = new Gtk::Entry();
   label47 = new Gtk::Label("Description:");
   textarea_drivers_description = new Gtk::Text();
   scrolledwindow9 = new Gtk::ScrolledWindow();
   vbox26 = new Gtk::VBox(false, 0);
   frame4 = new Gtk::Frame("Installed Drivers:");
   label53 = new Gtk::Label("Output Delay (ms)");
   entry_drivers_resetstring = new Gtk::Entry();
   spinbutton_drivers_delay_adj = new Gtk::Adjustment(0, 0, 5000, 10, 100, 100);
   spinbutton_drivers_delay = new Gtk::SpinButton(*spinbutton_drivers_delay_adj, 10, 0);
   label54 = new Gtk::Label("Custom RESET string: 0x");
   button_drivers_save_default = new Gtk::Button("Save as Default");
   button_drivers_save_all = new Gtk::Button("Save All as Default");
   checkbutton_drivers_disable = new Gtk::CheckButton("Driver Enabled");
   table7 = new Gtk::Table(4, 2, false);
   frame7 = new Gtk::Frame("Driver Properties");
   vbox25 = new Gtk::VBox(false, 0);
   vseparator5 = new Gtk::VSeparator();
   label49 = new Gtk::Label("System:");
   hseparator19 = new Gtk::HSeparator();
   label55 = new Gtk::Label("Pre-Process Ticks");
   spinbutton_system_preprocess_adj = new Gtk::Adjustment(1, 1, 200, 1, 10, 10);
   spinbutton_system_preprocess = new Gtk::SpinButton(*spinbutton_system_preprocess_adj, 1, 0);
   hbox23 = new Gtk::HBox(false, 0);
   hseparator20 = new Gtk::HSeparator();
   label52 = new Gtk::Label("Tick Length:");
   label56 = new Gtk::Label("Tick Skips:");
   label57 = new Gtk::Label("Latency:");
   label58 = new Gtk::Label("-");
   label59 = new Gtk::Label("Total Events:");
   label60 = new Gtk::Label("Total Tracks:");
   label61 = new Gtk::Label("-");
   label62 = new Gtk::Label("-");
   label63 = new Gtk::Label("-");
   label64 = new Gtk::Label("-");
   label65 = new Gtk::Label("-");
   label66 = new Gtk::Label("-");
   label_system_freemem = new Gtk::Label("somek");
   label_system_eventsused = new Gtk::Label("somevents");
   label_system_totalevents = new Gtk::Label("hhum");
   label_system_totalrows = new Gtk::Label("blahblah");
   label_system_totalpatterns = new Gtk::Label("moreblah blah");
   label_system_totaltracks = new Gtk::Label("hoho");
   table6 = new Gtk::Table(6, 3, false);
   frame6 = new Gtk::Frame("Status:");
   button_system_saveconfig = new Gtk::Button("Save Config");
   vbox27 = new Gtk::VBox(false, 0);
   vseparator6 = new Gtk::VSeparator();
   label67 = new Gtk::Label("Look &amp; Feel");
   hseparator21 = new Gtk::HSeparator();
   button_config_widgetcolors = new Gtk::Button("Pattern Font");
   button_config_keyboardmap = new Gtk::Button("Keyboard Map");
   button_config_commands = new Gtk::Button("Command Config");
   vbox28 = new Gtk::VBox(false, 0);
   hbox22 = new Gtk::HBox(false, 0);
   label45->set_name("label45");
   label45->set_alignment(0.5, 0.5);
   label45->set_padding(0, 0);
   hseparator18->set_usize(-1, 10);
   hseparator18->set_name("hseparator18");
   clist_drivers_list->set_name("clist_drivers_list");
   viewport8->set_name("viewport8");
   viewport8->add(*clist_drivers_list);
   scrolledwindow8->set_name("scrolledwindow8");
   scrolledwindow8->set_policy(GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
   scrolledwindow8->add(*viewport8);
   label46->set_name("label46");
   label46->set_alignment(0.5, 0.5);
   label46->set_padding(0, 0);
   entry_drivers_parent->set_name("entry_drivers_parent");
   entry_drivers_parent->set_editable(false);
   label47->set_name("label47");
   label47->set_alignment(0.5, 0.5);
   label47->set_padding(0, 0);
   textarea_drivers_description->set_name("textarea_drivers_description");
   textarea_drivers_description->set_editable(false);
   textarea_drivers_description->set_word_wrap(false);
   textarea_drivers_description->set_point(0);
   scrolledwindow9->set_name("scrolledwindow9");
   scrolledwindow9->set_policy(GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
   scrolledwindow9->add(*textarea_drivers_description);
   vbox26->set_name("vbox26");
   vbox26->set_border_width(7);
   vbox26->pack_start(*scrolledwindow8);
   vbox26->pack_start(*label46, false, false, 0);
   vbox26->pack_start(*entry_drivers_parent, false, false, 0);
   vbox26->pack_start(*label47, false, false, 0);
   vbox26->pack_start(*scrolledwindow9);
   frame4->set_name("frame4");
   frame4->set_border_width(3);
   frame4->set_label_align(0, 0);
   frame4->set_shadow_type(GTK_SHADOW_ETCHED_IN);
   frame4->add(*vbox26);
   label53->set_name("label53");
   label53->set_alignment(0.5, 0.5);
   label53->set_padding(0, 0);
   entry_drivers_resetstring->set_name("entry_drivers_resetstring");
   entry_drivers_resetstring->set_editable(true);
   spinbutton_drivers_delay->set_usize(65, -1);
   spinbutton_drivers_delay->set_name("spinbutton_drivers_delay");
   spinbutton_drivers_delay->set_editable(true);
   label54->set_name("label54");
   label54->set_alignment(0.5, 0.5);
   label54->set_padding(0, 0);
   button_drivers_save_default->set_name("button_drivers_save_default");
   button_drivers_save_default->set_border_width(3);
   button_drivers_save_all->set_name("button_drivers_save_all");
   button_drivers_save_all->set_border_width(3);
   checkbutton_drivers_disable->set_name("checkbutton_drivers_disable");
   table7->set_name("table7");
   table7->set_border_width(3);
   table7->attach(*label53, 0, 1, 0, 1, 0, 0, 0, 0);
   table7->attach(*entry_drivers_resetstring, 1, 2, 1, 2, GTK_FILL, 0, 0, 0);
   table7->attach(*spinbutton_drivers_delay, 1, 2, 0, 1, 0, 0, 9, 0);
   table7->attach(*label54, 0, 1, 1, 2, 0, 0, 3, 0);
   table7->attach(*button_drivers_save_default, 0, 1, 3, 4, 0, 0, 0, 0);
   table7->attach(*button_drivers_save_all, 1, 2, 3, 4, 0, 0, 0, 0);
   table7->attach(*checkbutton_drivers_disable, 0, 1, 2, 3, 0, 0, 0, 0);
   frame7->set_name("frame7");
   frame7->set_border_width(2);
   frame7->set_label_align(0, 0);
   frame7->set_shadow_type(GTK_SHADOW_ETCHED_IN);
   frame7->add(*table7);
   vbox25->set_name("vbox25");
   vbox25->pack_start(*label45, false, false, 0);
   vbox25->pack_start(*hseparator18, false, false, 0);
   vbox25->pack_start(*frame4);
   vbox25->pack_start(*frame7, false, false, 0);
   vseparator5->set_name("vseparator5");
   label49->set_name("label49");
   label49->set_alignment(0.5, 0.5);
   label49->set_padding(0, 0);
   hseparator19->set_name("hseparator19");
   label55->set_name("label55");
   label55->set_alignment(0.5, 0.5);
   label55->set_padding(0, 0);
   spinbutton_system_preprocess->set_name("spinbutton_system_preprocess");
   spinbutton_system_preprocess->set_editable(true);
   hbox23->set_name("hbox23");
   hbox23->pack_start(*label55, false, false, 0);
   hbox23->pack_start(*spinbutton_system_preprocess);
   hseparator20->set_name("hseparator20");
   label52->set_name("label52");
   label52->set_alignment(0.5, 0.5);
   label52->set_padding(4, 4);
   label56->set_name("label56");
   label56->set_alignment(0.5, 0.5);
   label56->set_padding(4, 4);
   label57->set_name("label57");
   label57->set_alignment(0.5, 0.5);
   label57->set_padding(4, 4);
   label58->set_name("label58");
   label58->set_alignment(0.5, 0.5);
   label58->set_padding(4, 4);
   label59->set_name("label59");
   label59->set_alignment(0.5, 0.5);
   label59->set_padding(4, 4);
   label60->set_name("label60");
   label60->set_alignment(0.5, 0.5);
   label60->set_padding(4, 4);
   label61->set_name("label61");
   label61->set_alignment(0.5, 0.5);
   label61->set_padding(0, 0);
   label62->set_name("label62");
   label62->set_alignment(0.5, 0.5);
   label62->set_padding(0, 0);
   label63->set_name("label63");
   label63->set_alignment(0.5, 0.5);
   label63->set_padding(0, 0);
   label64->set_name("label64");
   label64->set_alignment(0.5, 0.5);
   label64->set_padding(0, 0);
   label65->set_name("label65");
   label65->set_alignment(0.5, 0.5);
   label65->set_padding(0, 0);
   label66->set_name("label66");
   label66->set_alignment(0.5, 0.5);
   label66->set_padding(0, 0);
   label_system_freemem->set_name("label_system_freemem");
   label_system_freemem->set_alignment(0.5, 0.5);
   label_system_freemem->set_padding(0, 0);
   label_system_eventsused->set_name("label_system_eventsused");
   label_system_eventsused->set_alignment(0.5, 0.5);
   label_system_eventsused->set_padding(0, 0);
   label_system_totalevents->set_name("label_system_totalevents");
   label_system_totalevents->set_alignment(0.5, 0.5);
   label_system_totalevents->set_padding(0, 0);
   label_system_totalrows->set_name("label_system_totalrows");
   label_system_totalrows->set_alignment(0.5, 0.5);
   label_system_totalrows->set_padding(0, 0);
   label_system_totalpatterns->set_name("label_system_totalpatterns");
   label_system_totalpatterns->set_alignment(0.5, 0.5);
   label_system_totalpatterns->set_padding(0, 0);
   label_system_totaltracks->set_name("label_system_totaltracks");
   label_system_totaltracks->set_alignment(0.5, 0.5);
   label_system_totaltracks->set_padding(0, 0);
   table6->set_name("table6");
   table6->attach(*label52, 0, 1, 0, 1, 0, 0, 0, 0);
   table6->attach(*label56, 0, 1, 1, 2, 0, 0, 0, 0);
   table6->attach(*label57, 0, 1, 2, 3, 0, 0, 0, 0);
   table6->attach(*label58, 0, 1, 3, 4, 0, 0, 0, 0);
   table6->attach(*label59, 0, 1, 4, 5, 0, 0, 0, 0);
   table6->attach(*label60, 0, 1, 5, 6, 0, 0, 0, 0);
   table6->attach(*label61, 1, 2, 0, 1, 0, 0, 0, 0);
   table6->attach(*label62, 1, 2, 1, 2, 0, 0, 0, 0);
   table6->attach(*label63, 1, 2, 2, 3, 0, 0, 0, 0);
   table6->attach(*label64, 1, 2, 3, 4, 0, 0, 0, 0);
   table6->attach(*label65, 1, 2, 4, 5, 0, 0, 0, 0);
   table6->attach(*label66, 1, 2, 5, 6, 0, 0, 0, 0);
   table6->attach(*label_system_freemem, 2, 3, 0, 1, 0, 0, 0, 0);
   table6->attach(*label_system_eventsused, 2, 3, 1, 2, 0, 0, 0, 0);
   table6->attach(*label_system_totalevents, 2, 3, 2, 3, 0, 0, 0, 0);
   table6->attach(*label_system_totalrows, 2, 3, 3, 4, 0, 0, 0, 0);
   table6->attach(*label_system_totalpatterns, 2, 3, 4, 5, 0, 0, 0, 0);
   table6->attach(*label_system_totaltracks, 2, 3, 5, 6, 0, 0, 0, 0);
   frame6->set_name("frame6");
   frame6->set_label_align(0, 0);
   frame6->set_shadow_type(GTK_SHADOW_ETCHED_IN);
   frame6->add(*table6);
   button_system_saveconfig->set_name("button_system_saveconfig");
   button_system_saveconfig->set_border_width(6);
   vbox27->set_name("vbox27");
   vbox27->pack_start(*label49, false, false, 0);
   vbox27->pack_start(*hseparator19, false, false, 4);
   vbox27->pack_start(*hbox23, false, true, 0);
   vbox27->pack_start(*hseparator20, false, false, 2);
   vbox27->pack_start(*frame6);
   vbox27->pack_start(*button_system_saveconfig, false, false, 0);
   vseparator6->set_name("vseparator6");
   label67->set_name("label67");
   label67->set_alignment(0.5, 0.5);
   label67->set_padding(0, 0);
   hseparator21->set_name("hseparator21");
   button_config_widgetcolors->set_name("button_config_widgetcolors");
   button_config_widgetcolors->set_border_width(5);
   button_config_keyboardmap->set_name("button_config_keyboardmap");
   button_config_keyboardmap->set_border_width(4);
   button_config_commands->set_name("button_config_commands");
   button_config_commands->set_border_width(5);
   vbox28->set_name("vbox28");
   vbox28->pack_start(*label67, false, false, 0);
   vbox28->pack_start(*hseparator21, false, false, 4);
   vbox28->pack_start(*button_config_widgetcolors, false, false, 0);
   vbox28->pack_start(*button_config_keyboardmap, false, false, 0);
   vbox28->pack_start(*button_config_commands, false, false, 0);
   hbox22->set_name("hbox22");
   hbox22->pack_start(*vbox25);
   hbox22->pack_start(*vseparator5, false, false, 2);
   hbox22->pack_start(*vbox27);
   hbox22->pack_start(*vseparator6, false, false, 6);
   hbox22->pack_start(*vbox28);
   label45->show();
   hseparator18->show();
   clist_drivers_list->show();
   viewport8->show();
   scrolledwindow8->show();
   label46->show();
   entry_drivers_parent->show();
   label47->show();
   textarea_drivers_description->show();
   scrolledwindow9->show();
   vbox26->show();
   frame4->show();
   label53->show();
   entry_drivers_resetstring->show();
   spinbutton_drivers_delay->show();
   label54->show();
   button_drivers_save_default->show();
   button_drivers_save_all->show();
   checkbutton_drivers_disable->show();
   table7->show();
   frame7->show();
   vbox25->show();
   vseparator5->show();
   label49->show();
   hseparator19->show();
   label55->show();
   spinbutton_system_preprocess->show();
   hbox23->show();
   hseparator20->show();
   label52->show();
   label56->show();
   label57->show();
   label58->show();
   label59->show();
   label60->show();
   label61->show();
   label62->show();
   label63->show();
   label64->show();
   label65->show();
   label66->show();
   label_system_freemem->show();
   label_system_eventsused->show();
   label_system_totalevents->show();
   label_system_totalrows->show();
   label_system_totalpatterns->show();
   label_system_totaltracks->show();
   table6->show();
   frame6->show();
   button_system_saveconfig->show();
   vbox27->show();
   vseparator6->show();
   label67->show();
   hseparator21->show();
   button_config_widgetcolors->show();
   button_config_keyboardmap->show();
   button_config_commands->show();
   vbox28->show();
   hbox22->show();

   clist_drivers_list->select_row.connect(slot(this,&Interface::clist_drivers_list_select_row));
   checkbutton_drivers_disable->pressed.connect(slot(this,&Interface::checkbutton_drivers_disable_pressed));
   spinbutton_system_preprocess_adj->value_changed.connect(slot(this,&Interface::spinbutton_system_preprocess_changed));
   button_config_widgetcolors->clicked.connect(slot(this,&Interface::button_system_font_change));
   GenericLabel = new Gtk::Label("System");
   main_notebook.append_page(*hbox22,*GenericLabel);

 	midi_client=NULL;
   show();

	reset_interface();

	main_notebook_current_page=main_notebook_Track_Properties;
	main_notebook.set_page(2);

	load_icons();
}

Interface::~Interface(){
}

void Interface::reset_interface() {

	selected_track=-1;
	selected_bank=-1;
	selected_patch=-1;
	selected_device=-1;

	if (song!=NULL) {

		if ( song->get_tracks()>0 ) selected_track=0;
		if ( song->user_devices.get_device_count()>0 ) {
		
			selected_device=0;
			selected_controller=0;
			
			if ( song->user_devices.get_device(0)->instrument_map.get_banks_count()>0 ) {

				selected_bank=0;
				selected_patch=0;
			}

		}

	}

	update_track_list();
	update_clist_virtual_devices();
	request_song_info_speed_update();

	button_track_new->grab_focus();
        update_clist_driver_list();

}
void Interface::set_midiout(MidiOutDeviceManager *p_midiout) {

	midiout=p_midiout;
        update_clist_driver_list();
}
void Interface::set_song(Song *p_song) {

	song=p_song;
}
void Interface::set_player(Player *p_player) {

	player=p_player;
}
	
void Interface::update_info_widgets() {


        int row_to_draw=song->get_global_row(player->get_playing_row(),player->get_playing_pattern());
	tracker.editor.notify_set_playing_row(row_to_draw);


	if (tracker.editor.flag_redraw_row()||tracker.editor.flag_redraw_top()||tracker.editor.flag_redraw_all_explicit()) {

		tracker.draw(NULL);
	} else {

	        tracker.update_playing_row();
	}
	
	
	if (update_info_counter % 8) {
		char aux_str[100];
	        string aux_str2;
		sprintf(aux_str,"column: %i | row %i | pattern %i | order %i | octave %i",
			tracker.editor.get_cursor_x(), tracker.editor.get_cursor_row(),
			tracker.editor.get_cursor_pattern(), tracker.editor.orderlist_get_cursor_y(),
			tracker.editor.get_default_octave());
		
		info_frame.set_editor_status(aux_str);	
		
		switch ( player->get_play_mode() ) {
		
			case Player::PLAY_NOTHING: {
			
				sprintf(aux_str,"stopped.");
			} break;
			case Player::PLAY_PATTERN: {
			
				sprintf(aux_str,"pattern %i - row %i | rpq %i | tempo %i",player->get_playing_pattern(),player->get_playing_row(),player->get_playing_rpq(),player->get_playing_tempo());
			} break;
			case Player::PLAY_SONG: {
			
				sprintf(aux_str,"song - row %i | pattern %i | order %i | rpq %i | tempo %i",player->get_playing_row(),player->get_playing_pattern(),player->get_playing_order(),player->get_playing_rpq(),player->get_playing_tempo());
			} break;
		}
					
		info_frame.set_play_status(aux_str);
		
		if (song->get_tracks()<=0) {
				
			sprintf(aux_str,"N/A");
		
		} else {
	
			
			switch ( tracker.editor.get_cursor_field() ) {
			
				case 0:
				case 1: {
				
					sprintf(aux_str,"Note Field");
				} break;
				case 2:
				case 3: {
				
					int vol;
					vol=song->abs_note(tracker.editor.get_cursor_x(),tracker.editor.get_cursor_y()).volume;
					
					if (vol<65) {
					
						sprintf(aux_str,"Volume Field - %i",vol);
					} else {
					
						sprintf(aux_str,"Volume Field - empty, default is %i",song->get_instrument(tracker.editor.get_cursor_track())->def_volume.get());
					}
				} break;
				case 4:
				case 5:
				case 6: {
				
					int com,par;
					
					com=song->abs_note(tracker.editor.get_cursor_x(),tracker.editor.get_cursor_y()).command;
					par=song->abs_note(tracker.editor.get_cursor_x(),tracker.editor.get_cursor_y()).parameter;
				
					if (com<30) {
					
						sprintf(aux_str,"Command Field \'%c\'- %s: value = %i(dec),%x(hex)",'A'+com,Effect_Table::effect_names[com],par,par);
					} else {
					
						sprintf(aux_str,"Command Field - no command");
					}
					
					
				} break;
				case 7:
				case 8:
				case 9:
				case 10:
				case 11: {

					int con,par;
					
					con=song->abs_note(tracker.editor.get_cursor_x(),tracker.editor.get_cursor_y()).controller_set;
					par=song->abs_note(tracker.editor.get_cursor_x(),tracker.editor.get_cursor_y()).controller_value;
				
					if (con<128) {
					
						sprintf(aux_str,"Controller %i (%s) - value = %i(dec),%x(hex)",con,default_ctrl_name[con],par,par);
					} else {
					
						sprintf(aux_str,"Controller Field - no controller");
					}
								
				} break;
			}
		}
							
		info_frame.set_cursor_status(aux_str);
	
        }
	update_info_counter++;	
}

void Interface::set_midi_client(Midi_Client *p_client) {


	midi_client=p_client;
}

void Interface::player_row_changed(int pattern, int row) {

//	gdk_threads_enter();	
//	tracker.editor.notify_set_playing_row(tracker.editor.abstract_note.get_abstract_row(pattern,row));
//	tracker.editor.set_flag_redraw_playing_row();
//	tracker.queue_draw();
//	gdk_threads_leave();	

}