// -*-c++-*-
/* $Id: rpcc.h,v 1.29 2005/07/16 21:55:00 max Exp $ */

/*
 *
 * Copyright (C) 1998 David Mazieres (dm@uun.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include "amisc.h"
#include "vec.h"
#include "union.h"
#include "qhash.h"

#if 1
#include "aios.h"
#else

#include <iostream.h>
inline ostream &
operator<< (ostream &os, const str &s)
{
  return os.write (s.cstr (), s.len ());
}
#define aout cout

#endif

inline const strbuf &
strbuf_cat (const strbuf &sb, char c)
{
  suio_copy (sb.tosuio (), &c, 1);
  return sb;
}

extern str idprefix;
extern bhash<str> ids;

#define XDR_RETURN "bool_t"	// XXX - should be bool

extern int lineno;
extern int printlit;
#undef yyerror
extern int yyerror (str);
#define yyerror yyerror		// For some versions of yacc
int yywarn (str);

extern int yylex ();
extern int yyparse ();
extern void checkliterals ();

struct rpc_decl {
  str id;
  str type;
  enum { SCALAR, PTR, ARRAY, VEC } qual;
  str bound;
};

struct rpc_const {
  str id;
  str val;
};

struct rpc_struct {
  str id;
  vec<rpc_decl> decls;
};

struct rpc_enum {
  str id;
  vec<rpc_const> tags;
};

struct rpc_utag {
  rpc_decl tag;
  str swval;
  bool tagvalid;
};

struct rpc_union {
  str id;
  str tagtype;
  str tagid;
  vec<rpc_utag> cases;
};

struct rpc_proc {
  str id;
  u_int32_t val;
  str arg;
  str res;
};

struct rpc_vers {
  str id;
  u_int32_t val;
  vec<rpc_proc> procs;
};

struct rpc_program {
  str id;
  u_int32_t val;
  vec<rpc_vers> vers;
};

struct rpc_sym {
  union {
    union_entry_base _base;
    union_entry<rpc_const> sconst;
    union_entry<rpc_decl> stypedef;
    union_entry<rpc_struct> sstruct;
    union_entry<rpc_enum> senum;
    union_entry<rpc_union> sunion;
    union_entry<rpc_program> sprogram;
    union_entry<str> sliteral;
  };

  enum symtype { CONST, STRUCT, UNION, ENUM, TYPEDEF, PROGRAM, LITERAL } type;

  rpc_sym () { _base.init (); }
  rpc_sym (const rpc_sym &s) : type (s.type) { _base.init (s._base); }
  ~rpc_sym () { _base.destroy (); }
private:
  rpc_sym &operator= (const rpc_sym &n)
    { type = n.type; _base.assign (n._base); return *this; }
public:

  void settype (symtype t) {
    switch (type = t) {
    case CONST:
      sconst.select ();
      break;
    case STRUCT:
      sstruct.select ();
      break;
    case UNION:
      sunion.select ();
      break;
    case ENUM:
      senum.select ();
      break;
    case TYPEDEF:
      stypedef.select ();
      break;
    case PROGRAM:
      sprogram.select ();
      break;
    case LITERAL:
      sliteral.select ();
      break;
    }
  }
};

struct YYSTYPE {
  u_int32_t num;
  struct rpc_decl decl;
  struct rpc_const cnst;
  ::str str;
};
extern YYSTYPE yylval;

typedef vec<rpc_sym> symlist_t;
extern symlist_t symlist;

typedef vec<str> strlist_t;
extern strlist_t litq;

str rpcprog (const rpc_program *, const rpc_vers *);
void genheader (str);
void gencfile (str);
void genpython (str);
void genpyc_lib (str);
void genpyc_so (str);
void genpyh (str);

void pswitch (str prefix, const rpc_union *rs, str swarg,
	      void (*pt) (str, const rpc_union *rs, const rpc_utag *),
	      str suffix = "\n",
	      void (*defac) (str, const rpc_union *rs) = NULL);

// added for pyc/pyh generation
extern str python_module_name;
