

/*
#    Sfront, a SAOL to C translator    
#    This file: Contains main()
#    Copyright (C) 1999  Regents of the University of California
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License (Version 2) as
#    published by the Free Software Foundation.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu
*/


#include "libmaker.h"



/* following declarations formerly in globals.c */

int libtype = DIRSIZE;  /* CSRC, ASYS, CSYS, NSYS, PSYS */

char * libdirs[DIRSIZE] = {"csrc", "asys", "csys", "nsys", "psys"};

char * libnames[NAMESIZE]; /* library file names */

int numnames = 0;

FILE * infile = NULL;
FILE * outfile = NULL;

/* end of global declarations */

/****************************************************************/
/*             prints help screen                               */
/****************************************************************/

void exitlibmaker(void)

{

  exit(0);

}

/****************************************************************/
/*             prints help screen                               */
/****************************************************************/

void printhelp(void)

{

  printf("Usage: libmaker [options] [filenames]\n");
  printf("Specify one of the following options:\n");
  printf("-csrc   Make csrclib.{c,h} files.\n");
  printf("-asys   Make asyslib.{c,h} files.\n");
  printf("-csys   Make csyslib.{c,h} files.\n");
  printf("-nsys   Make nsyslib.{c,h} files.\n");
  printf("-psys   Make psyslib.{c,h} files.\n");
  printf("Followed by the filenames to include in the\n");
  printf("library (without paths or suffixes).\n");
  exitlibmaker();

}

/****************************************************************/
/*             parses command line arguments                    */
/****************************************************************/

void commandlineargs(int argc, char ** argv)

{
  int i = 1;
  char name[255];
  int done;

  printf("libmaker, compresses sfront libraries. Version %s.\n",IDSTRING);
  printf("Run libmaker with -license option for Copyright/License info.\n\n");

  if (argc == 1)
    printhelp();
  else
    while (i<argc)
      {
	if ((!strcmp(argv[i],"-license")))
	  {
	    printf("This program is free software; you can redistribute it and/or modify\n");
	    printf("it under the terms of the GNU General Public License (Version 2) as\n");
	    printf("published by the Free Software Foundation.\n");
	    printf("\n");
	    printf("This program is distributed in the hope that it will be useful,\n");
	    printf("but WITHOUT ANY WARRANTY; without even the implied warranty of\n");
	    printf("MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n");
	    printf("GNU General Public License for more details.\n");
	    printf("\n");
	    printf("You should have received a copy of the GNU General Public License\n");
	    printf("along with this program; if not, write to the Free Software\n");
	    printf("Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA\n");
	    printf("In sfront distribution, see file COPYING for the GNU General Public License\n");
	    printf("\n");
	    i++;
	    exitlibmaker();
	  }
	if ((!strcmp(argv[i],"-csrc")) || (!strcmp(argv[i],"-asys")) ||
	    (!strcmp(argv[i],"-csys")) || (!strcmp(argv[i],"-nsys")) ||
	    (!strcmp(argv[i],"-psys")))
	  {
	    if (libtype != DIRSIZE)
	      {
		printf("error -- multiple lib options specified\n");
		printhelp();
	      }
	    if (!strcmp(argv[i],"-csrc"))
	      libtype = CSRC;
	    if (!strcmp(argv[i],"-asys"))
	      libtype = ASYS;
	    if (!strcmp(argv[i],"-csys"))
	      libtype = CSYS;
	    if (!strcmp(argv[i],"-psys"))
	      libtype = PSYS;
	    if (!strcmp(argv[i],"-nsys"))
	      libtype = NSYS;
	    i++;
	    continue;
	  }
	if (argv[i][0] == '-')
	  {
	    printf("unknown option %s\n\n",argv[i]);
	    printhelp();
	  }
	libnames[numnames] = argv[i];
	numnames++;
	i++;
      }

  if (libtype == DIRSIZE)
    {
      printf("error -- multiple lib options specified\n\n");
      printhelp();
    }

}

/****************************************************************/
/*             writes preamble to library file                  */
/****************************************************************/

void writepreamble()

{

  fprintf(outfile,"\n/*\n");
  fprintf(outfile," * This program is free software; you can redistribute it and/or modify\n");
  fprintf(outfile," * it under the terms of the GNU General Public License (Version 2) as\n");
  fprintf(outfile," * published by the Free Software Foundation.\n");
  fprintf(outfile," *\n");
  fprintf(outfile," * This program is distributed in the hope that it will be useful,\n");
  fprintf(outfile," * but WITHOUT ANY WARRANTY; without even the implied warranty of\n");
  fprintf(outfile," * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n");
  fprintf(outfile," * GNU General Public License for more details.\n");
  fprintf(outfile," * \n");
  fprintf(outfile," * You should have received a copy of the GNU General Public License\n");
  fprintf(outfile," * along with this program; if not, write to the Free Software\n");
  fprintf(outfile," * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA\n");
  fprintf(outfile," * In sfront distribution, see file COPYING for the GNU General Public License\n");
  fprintf(outfile," *\n");
  fprintf(outfile," *Automatically generated library file %s\n\n",libdirs[libtype]);
  fprintf(outfile," */\n\n");
}


/****************************************************************/
/*                  writes library files                        */
/****************************************************************/

void writefiles(void)

{
  int i, j, done;
  char name[256];
  char c;

  /* open library .c file */

  sprintf(name,"../%slib.c",libdirs[libtype]);
  outfile = fopen(name,"w");
  if (outfile == NULL)
    {
      printf("error -- %s can not be opened\n\n", name);
      printhelp();
    }
  writepreamble();
  fprintf(outfile,"#include \"tree.h\"\n\n");

  /* fill the library file */

  for (i = 0; i < numnames; i++)
    {
      sprintf(name,"%s/%s.c",libdirs[libtype],libnames[i]);
      infile = fopen(name,"r");
      if (infile == NULL)
	{
	  printf("error -- %s can not be opened\n\n", name);
	  printhelp();
	}
      done = fread(&c,sizeof(char),1,infile);

      j = 0;

      fprintf(outfile,"\n\n");
      fprintf(outfile,"void make%s(void)\n",libnames[i]);
      fprintf(outfile,"{\n");
      fprintf(outfile,"  int lc = 0;\n\n");

      while (done)
	{
	  j++;
	  fprintf(outfile,"  z[lc++]=\"");
	  while (done && (c != '\n'))
	    {
	      if ((c == '"')||(c == '\\'))
		putc('\\',outfile);
	      if (c != 13)               /* ^M, i.e. CR */
		putc(c,outfile);
	      done = fread(&c,sizeof(char),1,infile);
	    }
	  fprintf(outfile,"\";\n");
	  done = fread(&c,sizeof(char),1,infile);
	}
      fclose(infile);

      fprintf(outfile,"  printlib(lc);\n");
      fprintf(outfile,"}\n");

      if (j > ZSIZE)
	{
	  printf("Error: %s overwriting z[], increase ZSIZE (%i)\n", 
		 libnames[i], j);
	  exit(-1);
	}

    }
  fprintf(outfile,"\n\n");
  fclose(outfile);

  /* open library .h file */

  sprintf(name,"../%slib.h",libdirs[libtype]);
  outfile = fopen(name,"w");
  if (outfile == NULL)
    {
      printf("error -- %s can not be opened\n\n", name);
      printhelp();
    }
  writepreamble();

  for (i = 0; i < numnames; i++)
    fprintf(outfile,"extern void make%s(void);\n",libnames[i]);

  fprintf(outfile,"\n\n");
  fclose(outfile);

}


/****************************************************************/
/*                     main() for libmaker                        */
/****************************************************************/

int main(int argc, char ** argv)

{

  commandlineargs(argc, argv);
  writefiles();
  return 0;
}





