/*
 *  Copyright (C) 2004-2012 Savoir-Faire Linux Inc.
 *  Author: Julien Bonjean <julien.bonjean@savoirfairelinux.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA.
 *
 *  If you modify this program, or any covered work, by linking or
 *  combining it with the OpenSSL project's OpenSSL library (or a
 *  modified version of that library), containing parts covered by the
 *  terms of the OpenSSL or SSLeay licenses, Savoir-Faire Linux Inc.
 *  grants you additional permission to convey the resulting work.
 *  Corresponding Source for a non-source form of such a combination
 *  shall include the source code for the parts of OpenSSL used as well
 *  as that of the covered work.
 */

#include <check.h>
#include <stdlib.h>
#include "../src/contacts/addressbook.h"

#define XML_OUTPUT  "gnome-check-contacts.xml"

START_TEST(test_eds)
{
}
END_TEST

Suite *
contacts_suite(void)
{
    Suite *s = suite_create("Contacts");

    TCase *tc_cases = tcase_create("EDS");
    tcase_add_test(tc_cases, test_eds);
    suite_add_tcase(s, tc_cases);

    return s;
}

int
main(void)
{
    int number_failed;
    Suite *s = contacts_suite();
    SRunner *sr = srunner_create(s);
    srunner_set_xml(sr, XML_OUTPUT);
    srunner_run_all(sr, CK_NORMAL);
    number_failed = srunner_ntests_failed(sr);
    srunner_free(sr);
    return (number_failed == 0) ? EXIT_SUCCESS : EXIT_FAILURE;
}
