#!/bin/bash
#
#  Copyright (C) 2004-2012 Savoir-Faire Linux Inc.
#
#  Author: Alexandre Savard <alexandre.savard@savoirfairelinux.com>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#  Additional permission under GNU GPL version 3 section 7:
#
#  If you modify this program, or any covered work, by linking or
#  combining it with the OpenSSL project's OpenSSL library (or a
#  modified version of that library), containing parts covered by the
#  terms of the OpenSSL or SSLeay licenses, Savoir-Faire Linux Inc.
#  grants you additional permission to convey the resulting work.
#  Corresponding Source for a non-source form of such a combination
#  shall include the source code for the parts of OpenSSL used as well
#  as that of the covered work.
#

# Script to update sflphone translation

LAUNCHPAD_PO_ARCHIVE=launchpad-export.tar.gz

LAUNCHPAD_DIR=launchpad-import/sflphone
LAUNCHPAD_PATH=$PWD/$LAUNCHPAD_DIR

SFL_PO_DIR=.
SFL_PO_PATH=$PWD/$SFL_PO_DIR

if [ ! -e ${LAUNCHPAD_PO_ARCHIVE} ]; then
    echo "Error, "$LAUNCHPAD_PO_ARCHIVE" is required in current directory"
    exit
fi

mkdir -p launchpad-import

tar -zxvf $LAUNCHPAD_PO_ARCHIVE -C launchpad-import

if [ ! -d ${LAUNCHPAD_PATH} ]; then
    echo "Error, directory "$LAUNCHPAD_PATH" does not exist"
    exit
fi

pushd $LAUNCHPAD_PATH

for filename in $(ls)
do
    splitname=$(echo $filename | cut -d- -f2)

    if [ -e $SFL_PO_PATH/$splitname ]; then
        msgmerge --update $filename $SFL_PO_PATH/$splitname
    else
        cp $filename $SFL_PO_PATH/$splitname
    fi
done

popd

# Cleanup once translation are updated
rm -rf launchpad-import
rm -rf sflphone
rm -rf sflphone-manual
rm -rf sflphone_usermanual
