#!/bin/bash

set -e

KPATH="$1"

# The most reliable way to get the kernel version seems to be to look
# at <linux/version.h>.  Older kernels don't support "make
# kernelversion" and we can't grep the version out of the Makefile
# because it may be a wrapper.

VERSIONH="$KPATH/include/linux/utsrelease.h"
if [ ! -f "$KPATH/include/linux/utsrelease.h" ]; then
  VERSIONH="$KPATH/include/linux/version.h"
fi

VERSION="$(sed -r 's/^#define UTS_RELEASE "(.*)"/\1/; t; d' < "$VERSIONH")"

EXTRAVERSION="$(echo "$VERSION" | sed -r 's/^[0-9]+\.[0-9]+\.[0-9]+//; t; d')"
source "$KPATH/.config"

KVER_LEVEL_4=0
DIST_KVER_LEVEL_1=0
DIST_KVER_LEVEL_2=0

# If there's a third dot and fourth number after the 
# set KVER_LEVEL_4 to the fourth number.
if [ "${EXTRAVERSION#.[0-9]}" != "$EXTRAVERSION" ]; then
    KVER_LEVEL_4="${EXTRAVERSION#.}"
    KVER_LEVEL_4="${KVER_LEVEL_EVEL_4%%[^0-9]*}"
fi

if [ -n "$CONFIG_SUSE_KERNEL" ]; then
    DIST=SUSE  # XXX How do we distinguish this from SLES?
elif [ "${EXTRAVERSION/.EL/}" != "$EXTRAVERSION" ]; then
    DIST=RHEL
elif [ "${EXTRAVERSION/.el/}" != "$EXTRAVERSION" ]; then
    DIST=RHEL
elif [ "${EXTRAVERSION/_FC/}" != "$EXTRAVERSION" ]; then
    DIST=FEDORA
fi

# If there's a dash and more numbers after that, set
# DIST_KVER_LEVEL_1 and possibly DIST_KVER_LEVEL_2.
if [ "${EXTRAVERSION#*-}" != "$EXTRAVERSION" ]; then
    DIST_KVER="${EXTRAVERSION#*-}"
    DIST_KVER="${DIST_KVER%%[^0-9.]*}"
    if [ "${DIST_KVER#[0-9]}" != "$DIST_KVER" ]; then
	DIST_KVER_LEVEL_1="${DIST_KVER%%.*}"
	if [ "${DIST_KVER#*.[0-9]}" != "$DIST_KVER" ]; then
	    DIST_KVER_LEVEL_2="${DIST_KVER#*.}"
	    DIST_KVER_LEVEL_2="${DIST_KVER_LEVEL_2%%.*}"
	fi
    fi
fi

strip_leading_zeroes () {
    local n="$1"
    while [ "x${n#0}" != "x$n" -a "x$n" != "x0" ]; do
	n="${n#0}"
    done
    echo "$n"
}

echo "#define EFX_KVER_LEVEL_4 $(strip_leading_zeroes "$KVER_LEVEL_4")"
[ -z "$DIST" ] || echo "#define EFX_DIST_$DIST 1"
echo "#define EFX_DIST_KVER_LEVEL_1 $(strip_leading_zeroes "$DIST_KVER_LEVEL_1")"
echo "#define EFX_DIST_KVER_LEVEL_2 $(strip_leading_zeroes "$DIST_KVER_LEVEL_2")"
