#
# Authors: Karl MacMillan <kmacmillan@mentalrootkit.com>
#
# Copyright (C) 2006 Red Hat, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

import gettext
translation=gettext.translation('setroubleshoot-plugins', fallback=True)
_=translation.ugettext

from setroubleshoot.util import *
from setroubleshoot.Plugin import Plugin

class plugin(Plugin):
    summary = _('''
    SELinux prevented $SOURCE from mounting on the file or directory
    "$TARGET_PATH".
    ''')

    problem_description = _('''
    SELinux prevented $SOURCE from mounting a filesystem on the file
    or directory "$TARGET_PATH" of type "$TARGET_TYPE". By default
    SELinux limits the mounting of filesystems to only some files or
    directories (those with types that have the mountpoint attribute). The
    type "$TARGET_TYPE" does not have this attribute. You can either
    relabel the file or directory or set the boolean "$BOOLEAN" to true to
    allow mounting on any file or directory.
    ''')

    fix_description = _('''
    Changing the "$BOOLEAN" boolean to true will allow this access:
    "setsebool -P $BOOLEAN=1."
    ''')

    fix_cmd = 'setsebool -P $BOOLEAN=1'
    
    def __init__(self):
        Plugin.__init__(self, __name__)
	self.set_priority(55)

    def analyze(self, avc):
        if avc.matches_source_types(['mount_t']) and \
           avc.has_tclass_in(['file', 'dir']):
            # MATCH
            avc.set_template_substitutions(BOOLEAN="allow_mount_anyfile")
            return self.report(avc, _("File System"),
                               self.summary, self.problem_description,
                               self.fix_description, self.fix_cmd)
        else:
            return None
