#
# Copyright (C) 2006, 2007 Red Hat, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

import sys
import gettext
_ = gettext.translation('setroubleshoot-plugins', '/usr/share/locale', fallback=True).lgettext

from setroubleshoot.util import *
from setroubleshoot.Plugin import Plugin

known_ports = ['gopher_port_t', 'ftp_port_t', 'http_port_t', 'http_cache_port_t', 'postgresql_port_t', 'mysql_port_t']

class plugin(Plugin):
    summary =_('''
    SELinux is preventing the http daemon from connecting to network port $PORT_NUMBER''')

    problem_description = _('''
    SELinux has denied the http daemon from connecting to $PORT_NUMBER. An
    httpd script is trying to do a network connect to a remote port. If you
    did not setup httpd to network connections, this could signal a
    intrusion attempt.
    ''')

    fix_description = _('''
    If you want httpd to connect to network ports you need to turn on the
    httpd_can_network_network_connect boolean: "setsebool -P
    $BOOLEAN=1"
    ''')

    fix_cmd = 'setsebool -P $BOOLEAN=1'
    
    def __init__(self):
        Plugin.__init__(self, __name__)

    def analyze(self, avc):
        if avc.matches_source_types(['httpd_t', 'httpd_sys_script_t']) and \
           not avc.matches_target_types(known_ports)                   and \
           ((avc.matches_target_types(['net_conf_t']) and \
             avc.all_accesses_are_in(avc.r_file_perms)) \
            or \
             avc.has_any_access_in(['name_connect'])):

                # MATCH
                avc.set_template_substitutions(BOOLEAN="httpd_can_network_connect")
                return self.report(avc, _("Web Server"),
                                   self.summary, self.problem_description,
                                   self.fix_description, self.fix_cmd)
        return None
