#
# Copyright (C) 2006 Red Hat, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

import gettext
_ = gettext.translation('setroubleshoot-plugins', '/usr/share/locale', fallback=True).lgettext

from setroubleshoot.util import *
from setroubleshoot.Plugin import Plugin

class plugin(Plugin):
    summary =_('''
    SELinux is preventing $SOURCE ($SOURCE_TYPE) "$ACCESS" to $TARGET_PATH ($TARGET_TYPE).
    ''')

    problem_description = _('''
    SELinux denied access to $TARGET_PATH requested by $SOURCE.
    $TARGET_PATH has a context used for sharing by different program. If you
    would like to share $TARGET_PATH from $SOURCE also, you need to
    change its file context to public_content_t.  If you did not intend to
    this access, this could signal a intrusion attempt.
    ''')

    fix_description = _('''
    You can alter the file context by executing chcon -t public_content_t '$TARGET_PATH'
    ''')

    fix_cmd = "chcon -t public_content_t '$TARGET_PATH'"
    
    def __init__(self):
        Plugin.__init__(self, __name__)

    def analyze(self, avc):
        if avc.matches_source_types(['smbd_t', 'httpd_t', 'ftpd_t', 'httpd_sys_script_t', 'nfsd_t', 'rsync_t'])  and \
           avc.matches_target_types(['samba_share_t', 'httpd_.*_content_t', 'rsync_data_t'])                     and \
           avc.all_accesses_are_in(avc.r_file_perms + avc.r_dir_perms):
            # MATCH
            return self.report(avc, _("File Label"),
                               self.summary, self.problem_description,
                               self.fix_description, self.fix_cmd)
        else:
            return None

