#
# Copyright (C) 2006, 2008 Red Hat, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

import gettext
_ = gettext.translation('setroubleshoot-plugins', '/usr/share/locale', fallback=True).lgettext

from setroubleshoot.util import *
from setroubleshoot.Plugin import Plugin

class plugin(Plugin):
    summary =_('''
    SELinux is preventing access to files with the default label, default_t.
    ''')

    problem_description = _('''
    SELinux permission checks on files labeled default_t are being
    denied.  These files/directories have the default label on them.  This can
    indicate a labeling problem, especially if the files being referred
    to  are not top level directories. Any files/directories under standard system directories, /usr,
    /var. /dev, /tmp, ..., should not be labeled with the default
    label. The default label is for files/directories which do not have a label on a
    parent directory. So if you create a new directory in / you might
    legitimately get this label.
    ''')

    fix_description = _('''
    If you want a confined domain to use these files you will probably
    need to relabel the file/directory with chcon. In some cases it is just
    easier to relabel the system, to relabel execute: "touch
    /.autorelabel; reboot"
    ''')

    def __init__(self):
        Plugin.__init__(self,__name__)
        self.set_priority(60)

    def analyze(self, avc):
        if avc.matches_target_types(['default_t']):
            # MATCH
            return self.report(avc, _("File Label"),
                               self.summary, self.problem_description,
                               self.fix_description, self.fix_cmd)
        else:
            return None
