
#
# Authors: Dan Walsh <dwalsh@redhat.com>
#
# Copyright (C) 2006 Red Hat, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

import gettext
_ = gettext.translation('setroubleshoot-plugins', '/usr/share/locale', fallback=True).lgettext

from setroubleshoot.util import *
from setroubleshoot.Plugin import Plugin

class plugin(Plugin):
    summary = _('''
    SELinux is preventing $SOURCE ($SOURCE_TYPE) "$ACCESS" to $TARGET_PATH ($TARGET_TYPE).
    ''')

    problem_description = _('''

    SELinux denied access requested by $SOURCE. It is not
    expected that this access is required by $SOURCE and this access
    may signal an intrusion attempt. It is also possible that the specific
    version or configuration of the application is causing it to require
    additional access.

    ''')

    fix_description = _('''
    Sometimes labeling problems can cause SELinux denials.  You could try to
    restore the default system file context for $TARGET_PATH,
    <p>
    restorecon -v '$TARGET_PATH'
    <p>
    If this does not work, there is currently no automatic way to allow this
    access. Instead,  you can generate a local policy module to allow this
    access - see <a href="http://fedora.redhat.com/docs/selinux-faq-fc5/#id2961385">FAQ</a>
    Or you can disable SELinux protection altogether. Disabling
    SELinux protection is not recommended.
    Please file a <a href="http://bugzilla.redhat.com/bugzilla/enter_bug.cgi">bug report</a>
    against this package.
    ''')

    fix_cmd = ''

    def __init__(self):
        Plugin.__init__(self, __name__)
        self.set_priority(95)

    def analyze(self, avc):
        if avc.has_tclass_in(['dir', 'file', 'lnk_file', 'sock_file', 'chr_file', 'blk_file']):
            # MATCH
            return self.report(avc, None,
                               self.summary, self.problem_description,
                               self.fix_description, self.fix_cmd)
        return None
