#!/usr/bin/python
# -*- coding: UTF-8 -*-
# -*- python -*-
# Copyright (C) 2005 by Sebastien Estienne
#
# This file may be distributed and/or modified under the terms of
# the GNU General Public License version 2 as published by
# the Free Software Foundation.
# This file is distributed without any warranty; without even the implied
# warranty of merchantability or fitness for a particular purpose.
# See "COPYING" in the source distribution for more information.
#
# $id$

import sys
import os

class PluginLoader:
    def __init__(self, path):
        self.plugins = {}
        print "Looking for plugin in %s." % (path)
        sys.path.append(path)
        plugin_dir = os.listdir(path)
        for plugin in plugin_dir:
            plugin_file = plugin.split('.',1)
            if plugin_file[1] == "py":
                print "New plugin found: %s" % plugin_file[0]
                module = __import__(plugin_file[0])
                module_loaded = module.load()
                for st in module_loaded.service_type:
                    if self.plugins.has_key(st) == False:
                        self.plugins[st] = []
                    self.plugins[st].append(module_loaded)
        
    def dump_service_type(self):
        print self.plugins
        
def main():
    plugin_path = "/home/sebest/pluginloader/plugins"
    plugin = PluginLoader(plugin_path)
    plugin.dump_service_type()
    plugin.plugins["_ssh._tcp"][0].connect("test", "_ssh._tcp", "coucou", "172.16.200.103", 22, {})
#    plugin.plugins["_sftp-ssh._tcp"][1].connect()
    
if __name__ == "__main__":
    main()
