/*
   +----------------------------------------------------------------------+
   | PHP version 4.0                                                      |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997, 1998, 1999, 2000 The PHP Group                   |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.02 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available at through the world-wide-web at                           |
   | http://www.php.net/license/2_02.txt.                                 |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Author: Hartmut Holzgraefe <hartmut@six.de>                          |
   +----------------------------------------------------------------------+
 */
/* $Id: levenshtein.c,v 1.12 2000/08/21 09:50:52 sas Exp $ */

#include <stdlib.h>
#include <ctype.h>
#include <string.h>
/* #include <unicode/ustring.h> */

/* faster, but obfuscated, all operations have a cost of 1 */
unsigned short int fastest_levdist(const char *s1, const char *s2)
{
    char *p1, *p2;
    int i, j, n;
    int l1 = 0, l2 = 0;
    char r[512];
    const char *tmp;

    /* skip equal start sequence, if any */
    while (*s1 == *s2) {
	if (!*s1)
	    break;
	s1++;
	s2++;
    }

    /* if we already used up one string, then
       the result is the length of the other */
    if (*s1 == '\0')
	return strlen(s2);
    if (*s2 == '\0')
	return strlen(s1);

    /* length count */
    while (*s1++)
	l1++;
    while (*s2++)
	l2++;

    /* cut of equal tail sequence, if any */
    while (*--s1 == *--s2) {
	l1--;
	l2--;
    }


    /* reset pointers, adjust length */
    s1 -= l1++;
    s2 -= l2++;


    /* possible dist to great? */
    if (abs(l1 - l2) >= 255)
	return -1;

    /* swap if l2 longer than l1 */
    if (l1 < l2) {
	tmp = s1;
	s1 = s2;
	s2 = tmp;
	l1 ^= l2;
	l2 ^= l1;
	l1 ^= l2;
    }


    /* fill initial row */
    n = 1;
    for (i = 0, p1 = r; i < l1; i++, *p1++ = n++, p1++) {	/*empty */
    }

    /* calc. rowwise */
    for (j = 1; j < l2; j++) {
	/* init pointers and col#0 */
	p1 = r + !(j & 1);
	p2 = r + (j & 1);
	n = *p1 + 1;
	*p2++ = n;
	p2++;
	s2++;

	/* foreach column */
	for (i = 1; i < l1; i++) {
	    if (*p1 < n)
		n = *p1 + (*(s1 + i) != *(s2));	/* replace cheaper than delete? */
	    p1++;
	    if (*++p1 < n)
		n = *p1 + 1;	/* insert cheaper then replace ? */
	    *p2++ = n++;	/* update field and cost for next col's delete */
	    p2++;
	}
    }

    /* return result */
    return n - 1;
}


unsigned short int weighted_levdist(const char *s1, const char *s2,
			    const int cost_ins, const int cost_rep,
			    const int cost_del)
{
    int *p1, *p2;
    int i, j, n, c;
    int l1 = 0, l2 = 0;
    int r[512];
    const char *tmp;

    /* skip equal start sequence, if any */
    while (*s1 == *s2) {
	if (!*s1)
	    break;
	s1++;
	s2++;
    }

    /* if we already used up one string, then
       the result is the length of the other */
    if (*s1 == '\0')
	return strlen(s2);
    if (*s2 == '\0')
	return strlen(s1);

    /* length count */
    while (*s1++)
	l1++;
    while (*s2++)
	l2++;

    /* cut of equal tail sequence, if any */
    while (*--s1 == *--s2) {
	l1--;
	l2--;
    }


    /* reset pointers, adjust length */
    s1 -= l1++;
    s2 -= l2++;


    /* possible dist to great? */
    if (abs(l1 - l2) >= 255)
	return -1;

    /* swap if l2 longer than l1 */
    if (l1 < l2) {
	tmp = s1;
	s1 = s2;
	s2 = tmp;
	l1 ^= l2;
	l2 ^= l1;
	l1 ^= l2;
    }

    if ((l1 == 1) && (l2 == 1)) {
	n = cost_del + cost_ins;
	return n < cost_rep ? n : cost_rep;
    }

    /* fill initial row */
    n = cost_ins;
    for (i = 0, p1 = r; i < l1; i++, *p1++ = n, p1++) {
	n += cost_ins;
    }

    /* calc. rowwise */
    for (j = 1; j < l2; j++) {
	/* init pointers and col#0 */
	p1 = r + !(j & 1);
	p2 = r + (j & 1);
	n = *p1 + cost_del;
	*p2++ = n;
	p2++;
	s2++;

	/* foreach column */
	for (i = 1; i < l1; i++) {
	    c = *p1;
	    if (*(s1 + i) != *(s2))
		c += cost_rep;
	    if (c < n)
		n = c;		/* replace cheaper than delete? */
	    p1++;
	    c = *++p1 + cost_ins;
	    if (c < n)
		n = c;		/* insert cheaper then replace ? */
	    *p2++ = n;		/* update field and cost for next col's delete */
	    n += cost_del;	/* update field and cost for next col's delete */
	    p2++;
	}
    }

    /* return result */
    return n -= cost_del;
}

