// 
// Copyright(c) 2009 Syntext, Inc. All Rights Reserved.
// Contact: info@syntext.com, http://www.syntext.com
// 
// This file is part of Syntext Serna XML Editor.
// 
// COMMERCIAL USAGE
// Licensees holding valid Syntext Serna commercial licenses may use this file
// in accordance with the Syntext Serna Commercial License Agreement provided
// with the software, or, alternatively, in accorance with the terms contained
// in a written agreement between you and Syntext, Inc.
// 
// GNU GENERAL PUBLIC LICENSE USAGE
// Alternatively, this file may be used under the terms of the GNU General 
// Public License versions 2.0 or 3.0 as published by the Free Software 
// Foundation and appearing in the file LICENSE.GPL included in the packaging 
// of this file. In addition, as a special exception, Syntext, Inc. gives you
// certain additional rights, which are described in the Syntext, Inc. GPL 
// Exception for Syntext Serna Free Edition, included in the file 
// GPL_EXCEPTION.txt in this package.
// 
// You should have received a copy of appropriate licenses along with this 
// package. If not, see <http://www.syntext.com/legal/>. If you are unsure
// which license is appropriate for your use, please contact the sales 
// department at sales@syntext.com.
// 
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// 
/*! \file
 *  Compiled-in strings representation. THIS FILE IS USED IN FILES
 *  AUTOMATICALLY GENERATED BY MSGGEN ONLY.
 */
#ifndef COMPILED_IN_STRINGS_H_
#define COMPILED_IN_STRINGS_H_

#include "common/common_defs.h"
#include "common/RadixTree.h"
#include "common/Vector.h"

#if defined(_MSC_VER) && !defined(__ICL)
# include <string.h>
#endif


#if defined(_MSC_VER) && !defined(__ICL)
# pragma warning (push)
# pragma warning (disable : 4251)
#endif

COMMON_NS_BEGIN

//TODO:remove template <class T> class Vector;

/*! Singleton class which represents compiled-in Unicode string set
 *  used in messaging framework. This class is not for general use:
 *  it is used in files generated by mssgen utility.
 */
class COMMON_EXPIMP CompiledInStrings {
public:
    typedef unsigned short UCharType;

    /// get unicode character string for {lang, facility, msgid}
    bool    getString(const char* lang,
                      uint32 facility,
                      uint32 msgid,
                      const UCharType*& str,
                      uint& length) const;

    /// list registered languages
    void    listLanguages(Vector<const char*>&) const;

    /// representation if compiled-in Unicode string
    struct _msg {
        uint             len;
        const UCharType* msg;
    };
    /// representation of message segment (set of strings)
    struct _seg {
        int             nmsg;
        const _msg**    msgv;
    };

    //! add message segment with lang and facility
    void addSeg(const char* lang, uint32 facility, const _seg* seg);
    //! delete message segment with lang and facility
    void delSeg(const char* lang, uint32 facility);

    /*! utility class for automatic registration of message segments
     *  (i.e. when you add one more object file, registrar mechanism
     *  will automatically register message segment from this file).
     */
    class COMMON_EXPIMP Registrar {
    public:
        explicit Registrar(const char* language, uint32 facility, const _seg*);
        ~Registrar();
    private:
        uint32 facility_;
        const char* lang_;
    };

    static CompiledInStrings& instance();

protected:
    //!
    CompiledInStrings();
    ~CompiledInStrings();
private:
    //!
    struct LangItem {
        typedef RadixTree<const _seg> SegSet;
        LangItem(const char* lang);
        const char* lang; // must own lang string
        SegSet*     segset;
    };
    typedef Vector<LangItem> LanguageSet;

    LangItem* find_lang(const char* lang) const;

    mutable LanguageSet messages_;
    mutable LangItem*   lastitem_;
};

COMMON_NS_END

#if defined(_MSC_VER) && !defined(__ICL)
# pragma warning (pop)
#endif

#endif  //COMPILED_IN_STRINGS_H_
