#!/bin/sh

set -e

BASE_REL=$(dpkg-parsechangelog 2>/dev/null | sed -ne 's/Version: \([0-9]\)~.*/\1/p')
OLDDIR=${PWD}
GOS_DIR=${OLDDIR}/get-orig-source
SVN_COMMIT='svn log http://svn.drobilla.net/serd/trunk/ -l 1 | sed -ne "s/r\([0-9]\+\).*/\1/p"'

if [ -z ${BASE_REL} ]; then
	echo 'Please run this script from the sources root directory.'
	exit 1
fi


rm -rf ${GOS_DIR}
mkdir ${GOS_DIR} && cd ${GOS_DIR}
SERD_SVN_COMMIT=$(eval "${SVN_COMMIT}")
svn export -r ${SERD_SVN_COMMIT} http://svn.drobilla.net/serd/trunk/ \
	serd-${BASE_REL}~svn${SERD_SVN_COMMIT}
cd serd-${BASE_REL}~svn${SERD_SVN_COMMIT}/
cd .. && tar cjf \
	${OLDDIR}/serd_${BASE_REL}~svn${SERD_SVN_COMMIT}.orig.tar.bz2 \
	serd-${BASE_REL}~svn${SERD_SVN_COMMIT} --exclude-vcs
rm -rf ${GOS_DIR}
