// -----------------------------------------------------------------------------------------------------
// Copyright (c) 2006-2019, Knut Reinert & Freie Universität Berlin
// Copyright (c) 2016-2019, Knut Reinert & MPI für molekulare Genetik
// This file may be used, modified and/or redistributed under the terms of the 3-clause BSD-License
// shipped with this file and also available at: https://github.com/seqan/seqan3/blob/master/LICENSE.md
// -----------------------------------------------------------------------------------------------------

/*!\file
 * \author Hannes Hauswedell <hannes.hauswedell AT fu-berlin.de>
 * \brief Provides seqan3::type_list and metaprogramming utilities.
 */

#pragma once

#include <seqan3/core/type_list/type_list.hpp>
#include <seqan3/core/type_list/traits.hpp>

/*!\defgroup type_list Type List
 * \brief Provides seqan3::type_list and metaprogramming utilities for working on type lists and type packs.
 * \ingroup core
 *
 * \details
 *
 * All traits are defined in the header `<seqan3/core/type_list/traits.hpp>`.
 *
 */

/*!\namespace seqan3::pack_traits
 * \brief Namespace containing traits for working on type packs.
 * \ingroup type_list
 */

/*!\namespace seqan3::list_traits
 * \brief Namespace containing traits for working on seqan3::type_list.
 * \ingroup type_list
 */
