#!/usr/bin/env cwl-runner

# This CWL file was automatically generated using CTDConverter.
# Visit https://github.com/WorkflowConversion/CTDConverter for more information.

baseCommand: tree_recon
class: CommandLineTool
cwlVersion: v1.0
doc: "Reconstruct phylogenetic tree from Phylip matrix IN.DIST.\n\n\n\nFor more information,\
  \ visit http://www.seqan.de"
inputs:
- doc: Name Phylip distance matrix file.  Must contain at least three species.
  id: param_matrix
  inputBinding:
    prefix: -matrix
  label: Name Phylip distance matrix file.  Must contain at least three species.
  type: File
- default: tree.dot
  doc: Filename for out-file output file
  id: param_out-file_filename
  inputBinding:
    prefix: -out-file
  label: Filename for out-file output file
  type:
  - 'null'
  - string
- default: nj
  doc: 'Tree building method. nj: neighbour-joining, min: UPGMA single linkage, max:
    UPGMA complete linkage, avg: UPGMA average linkage, wavg: UPGMA weighted average
    linkage.  Neighbour-joining creates an unrooted tree.  We root that tree at the
    least joined pair.'
  id: param_build
  inputBinding:
    prefix: -build
  label: 'Tree building method. nj: neighbour-joining, min: UPGMA single linkage,
    max: UPGMA complete linkage, avg: UPGMA average linkage, wavg: UPGMA weighted
    average linkage.  Neighbour-joining creates an unrooted tree.  We root that tree
    at the least joined pair.'
  type:
  - 'null'
  - string
label: Tree reconstruction
outputs:
- doc: Path to write output to.
  id: param_out-file
  label: Path to write output to.
  outputBinding:
    glob: $(inputs.param_out-file_filename)
  type:
  - 'null'
  - File
