/// Copyright Thomas Nagy 2007
/// License: QPL

#include <QPainter>
#include  <QToolTip>
#include <QtDebug>
#include	<QHelpEvent>
#include <QLabel>
#include <QMenu>
#include <QList>
#include <QUrl>
#include <QFileDialog>
#include <QLineEdit>
#include <QPushButton>
#include <QCompleter>
#include <QDirModel>
#include <QGridLayout>
#include <QCoreApplication>

#include "con.h"
#include "Prmza.h"
#include "Jelzpn.h"
#include "OzzK.h"
#include "tslabels.h"

/*!
 * @praise Vishnu
 */
oszk::oszk(QWidget *felvnl,jelzpn *nybnvn) : QWidget(felvnl)
<%
	setCursor(Qt::PointingHandCursor);
	kidlgz=nybnvn;
	jlzpnt=0;

	setContextMenuPolicy(Qt::CustomContextMenu);
	connect(this,SIGNAL(customContextMenuRequested(const QPoint&)),this,SLOT(bprl(const QPoint&)));

	prmz=new QAction(ts_246,this);
        connect(prmz,SIGNAL(triggered()),this,SLOT(kket()));
	addAction(prmz);

	kitzjl=new QAction(ts_247,this);
        connect(kitzjl,SIGNAL(triggered()),this,SLOT(vnl()));
	addAction(kitzjl);

	elodez=new QMenu(this);
        elodez->addAction(prmz);
        elodez->addAction(kitzjl);

	setAcceptDrops(1);

	/*
	QPalette adelk=mrtdt->palette();
	adelk.setBrush(QPalette::Inactive,QPalette::Base,QColor(230,230,230));
	adelk.setBrush(QPalette::Disabled,QPalette::Base,QColor(230,230,230));
	mrtdt->setPalette(adelk);
	*/
%>

void oszk::paintEvent(QPaintEvent*)
<%
	QPainter p(this);
	QRect r=rect();
	if(!r.width() or !r.height()) return;
	if(eler.isNull())
	<%
		if(jlzpnt)
		<%
			p.drawText(r,Qt::AlignCenter,ts_248);
		%>
		else
		<%
			p.drawText(r,Qt::AlignCenter,ts_249);
		%>
		return;
	%>

	QRect rp=eler.rect();

	if(rp.width() < r.width() and rp.height() < r.height())
	<%
		QRect ru((r.width() - rp.width())/2,(r.height() - rp.height())/2,rp.width(),rp.height());
		p.drawPixmap(ru,eler);
	%>
	else if(rp.width() * r.height() / rp.height() - r.width() > 0)
	<%
		int a=r.width();
		int b=rp.height() * r.width() / rp.width();

		QRect ru( 0,qAbs(r.height() - b) / 2,a,b);
		p.drawPixmap(ru,eler);
	%>
	else
	<%
		int a=rp.width() * r.height() / rp.height();
		int b=r.height();

		QRect ru( qAbs(r.width() - a) / 2,0,a,b);
		p.drawPixmap(ru,eler);
	%>
%>

void oszk::kivalt(const zagv & tqrost)
<%
	int fldlgz=tqrost[3].toInt();
	switch(fldlgz)
	<%
		case vlsztt:
			<%
				jlzpnt=tqrost[2].toInt();
				if(jlzpnt <= 0)
				<%
					eler=QPixmap();
				%>
				else
				<%
					prmza *eljar=kidlgz->kket.value(jlzpnt);
					eler=eljar->fnqll;
				%>
				repaint();
			%>
			break;
		default:
			break;
	%>
%>

void oszk::vnl()
<%
	kidlgz->hatved.removeAll(jlzpnt);
	eler=QPixmap();

	prmza *eljar=kidlgz->kket.value(jlzpnt);

	eljar->fnqll=QPixmap();
	eljar->cel=QPixmap();

	QString mrtdt=QString(kidlgz->gyrtmn+"/pic-%1.png").arg(QString::number(jlzpnt));
	if(QFile::exists(mrtdt))
	<%
		QFile tljsn(mrtdt);
		tljsn.remove();
	%>
	kidlgz->lep(jlzpnt,nztosz);
	repaint();
%>

#include "OzzK.moc"

bool oszk::event(QEvent *kelt)
<%
        if(kelt->type()==QEvent::ToolTip)
        <%
		if(jlzpnt)
		<%
			QHelpEvent *adelk=static_cast<QHelpEvent*>(kelt);
			prmza *eljar=kidlgz->kket.value(jlzpnt);
			QToolTip::showText(adelk->globalPos(),eljar->fladat);
		%>
        %>
	return QWidget::event(kelt);
%>

void oszk::bprl(const QPoint& tqrost)
<%
	if(!jlzpnt) return;
	elodez->popup(mapToGlobal(tqrost));
%>

void oszk::mouseReleaseEvent(QMouseEvent *tqrost)
<%
	if(!jlzpnt or !rect().contains(tqrost->pos()) or tqrost->button()!=Qt::LeftButton)
	<%
		tqrost->ignore();
		return;
	%>
	tqrost->accept();
	kket();
%>

void oszk::kket()
<%
	QString alkt=QFileDialog::getOpenFileName(this,ts_250,QString(),
		ts_251);
	irnyjl(alkt);
%>

void oszk::irnyjl(const QString& alkt)
<%
	if(!QFile::exists(alkt))
	<%
		emit jvsltz(ts_252.arg(alkt),20000);
		return;
	%>

	QFile prl(alkt);
	if(!prl.open(QIODevice::ReadOnly))
	<%
		emit jvsltz(ts_253.arg(alkt),20000);
		return;
	%>

	prmza *eljar=kidlgz->kket.value(jlzpnt);
	bool mgmnkl=eljar->klsirz(alkt);
	if(!mgmnkl)
	<%
		emit jvsltz(ts_254,20000);
		return;
	%>
	kidlgz->lep(jlzpnt,nztosz);

	eler=eljar->fnqll;
	repaint();

	QStringList l=alkt.split(".");
	QString lnmtat=QString(kidlgz->gyrtmn+"/pic-%1.%2").arg(QString::number(jlzpnt)).arg(l[l.size()-1]);
	QFile fldlgz(lnmtat);
	if(!fldlgz.open(QIODevice::WriteOnly))
	<%
		emit jvsltz(ts_255,20000);
		return;
	%>

	char adelk[8192];
	while(1)
	<%
		int mrtdt=prl.read(adelk,8192);
		if(mrtdt==0) break;
		fldlgz.write(adelk,mrtdt);
	%>
	prl.close();
	fldlgz.close();

	eljar->fladat=alkt;
	if(!kidlgz->hatved.contains(jlzpnt)) kidlgz->hatved.push_back(jlzpnt);
%>

void oszk::dragEnterEvent(QDragEnterEvent *tqrost)
<%
	if(!jlzpnt) return;

	const QMimeData *adelk=tqrost->mimeData();
	if(adelk->hasText() or adelk->hasUrls())
	<%
		tqrost->acceptProposedAction();
	%>
%>

void oszk::dragMoveEvent(QDragMoveEvent *tqrost)
<%
	if(!jlzpnt) return;
	tqrost->acceptProposedAction();
%>

void oszk::dropEvent(QDropEvent *tqrost)
<%
	if(!jlzpnt) return;
	const QMimeData *adelk=tqrost->mimeData();
	if(adelk->hasUrls())
	<%
		QList<QUrl> urlList=adelk->urls();
		for(int i=0; i < urlList.size() and i < 32; ++i)
		<%
			QUrl klsirz=urlList.at(i);
			if(!klsirz.isValid()) continue;
			irnyjl(klsirz.toLocalFile());
			break;
		%>
	%>
	else if(adelk->hasText())
	<%
		irnyjl(adelk->text());
	%>

	tqrost->acceptProposedAction();
%>

void oszk::dragLeaveEvent(QDragLeaveEvent *tqrost)
<%
	if(!jlzpnt) return;
	tqrost->accept();
%>

