class TestSlashSELinux(TestBase):
	"""
	Verify that /selinux is present
	"""
	class ErrorNoSlashSELinux(ErrorBase):
		def __str__(self):
			return "The directory /selinux is missing."
		def fixable(self):
			return True
		def fix(self):
			import os
			return os.mkdir("/selinux")

	@staticmethod
	def test():
		import os
		if not os.access("/selinux",os.F_OK):
			return [TestSlashSELinux.ErrorNoSlashSELinux()]
		return []
register_test(TestSlashSELinux)
