#!/usr/bin/python
# setup.py - Python distutils module for Seivot
# Copyright (C) 2008, 2011  Lars Wirzenius, Richard Braakman
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from distutils.core import setup
import glob

setup(name='seivot',
      version='1.17',
      description='Backup software benchmark software',
      long_description='''\
seivot generates synthetic test data and backs it up using the
desired backup tool. It then modifies the test data, and makes
further backups. It also does restores, verifications, and
forgets backup generations. It measures the runtime and memory
usage of each run of the backup program.

seivot currently works only for obnam, but welcomes patches for
other backup programs.
''',
      classifiers=[
        'Development Status :: 4 - Beta',
        'Environment :: Console',
        'Intended Audience :: Developers',
        'Intended Audience :: System Administrators',
        'License :: OSI Approved :: GNU General Public License (GPL)',
        'Operating System :: Unix',
        'Programming Language :: Python :: 2',
        'Topic :: Software Development :: Testing',
        'Topic :: System :: Archiving :: Backup',
        'Topic :: System :: Benchmark',
      ],
      author='Lars Wirzenius',
      author_email='liw@liw.fi',
      url='http://liw.fi/seivot/',
      scripts=['seivot', 'seivots-summary', 'seivots-to-csv'],
      data_files=[('share/man/man1', glob.glob('*.1'))],
     )

