/*
  Simple DirectMedia Layer
  Copyright (C) 1997-2021 Sam Lantinga <slouken@libsdl.org>

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.
*/

/* These headers are from sdl12-compat, and are intended to give just enough
functionality to let you build an SDL-1.2-based project without having the
real SDL-1.2 available to you. */

/* This is all kinda dicey. Just pretend we have most of these no matter what.
   Hopefully most apps don't actually rely on this. :/  These defines would
   need to be correct (and usually generated by a configure script) if these
   headers were to be used to build the real SDL 1.2, but they are only
   intended for building apps against sdl12-compat. */

#ifndef _SDL_config_h
#define _SDL_config_h

#include "SDL_platform.h"

/* Make sure that this isn't included by Visual C++ */
#if defined(_MSC_VER) && (_MSC_VER < 1600)
typedef __int8 int8_t;
typedef unsigned __int8 uint8_t;
typedef __int16 int16_t;
typedef unsigned __int16 uint16_t;
typedef __int32 int32_t;
typedef unsigned __int32 uint32_t;
typedef __int64 int64_t;
typedef unsigned __int64 uint64_t;
#else
#include <stdint.h>
#define HAVE_STDINT_H 1
#endif

#define SDL_HAS_64BIT_TYPE 1

#include <stdarg.h>
#define HAVE_STDARG_H 1

/* for now, let's try and say everything that we care about that isn't Windows
has these C runtime functions available. We're trying to avoid a configure
stage, though. Send patches if your platform lacks something. */
#ifndef _WIN32
#define HAVE_LIBC 1
#define HAVE_ALLOCA_H 1
#define HAVE_SYS_TYPES_H 1
#define HAVE_STDIO_H 1
#define STDC_HEADERS 1
#define HAVE_STDLIB_H 1
#define HAVE_MEMORY_H 1
#define HAVE_STRING_H 1
#define HAVE_STRINGS_H 1
#define HAVE_INTTYPES_H 1
#define HAVE_CTYPE_H 1
#define HAVE_MATH_H 1
#endif

#if defined(unix) || defined(__APPLE__)
#define HAVE_ICONV_H 1
#define HAVE_SIGNAL_H 1
#endif

#if defined(__powerpc__)
#define HAVE_ALTIVEC_H 1
#endif

/* SDL 1.2 never defines these for Windows to force SDL's internal implementation. */
#ifndef _WIN32
#define HAVE_GETENV 1
#define HAVE_PUTENV 1
#define HAVE_UNSETENV 1
#endif

/* for now, let's try and say everything that we care about that isn't Windows
has these C runtime functions available. We're trying to avoid a configure
stage, though. Send patches if your platform lacks something. */
#ifndef _WIN32
#define HAVE_MALLOC 1
#define HAVE_CALLOC 1
#define HAVE_REALLOC 1
#define HAVE_FREE 1
#define HAVE_ALLOCA 1
#define HAVE_QSORT 1
#define HAVE_ABS 1
#define HAVE_MEMSET 1
#define HAVE_MEMCPY 1
#define HAVE_MEMMOVE 1
#define HAVE_MEMCMP 1
#define HAVE_STRLEN 1
#define HAVE_STRDUP 1
#define HAVE_STRCHR 1
#define HAVE_STRRCHR 1
#define HAVE_STRSTR 1
#define HAVE_STRTOL 1
#define HAVE_STRTOUL 1
#define HAVE_STRTOLL 1
#define HAVE_STRTOULL 1
#define HAVE_STRTOD 1
#define HAVE_STRCMP 1
#define HAVE_STRNCMP 1
#define HAVE_STRCASECMP 1
#define HAVE_STRNCASECMP 1
#define HAVE_SSCANF 1
#ifndef __WATCOMC__ /* apparently Watcom C's snprintf is not to be trusted... */
#define HAVE_SNPRINTF 1
#define HAVE_VSNPRINTF 1
#endif
#endif

/* things that aren't necessarily in Linux, some are MSVC C runtime, some are BSD. Send patches. */
#if 0
#define HAVE_MALLOC_H 1
#define HAVE_BCOPY 1
#define HAVE_ATOI 1
#define HAVE_ATOF 1
#define HAVE_STRLCPY 1
#define HAVE_STRLCAT 1
#define HAVE__STRREV 1
#define HAVE__STRUPR 1
#define HAVE__STRLWR 1
#define HAVE_INDEX 1
#define HAVE_RINDEX 1
#define HAVE_ITOA 1
#define HAVE__LTOA 1
#define HAVE__UITOA 1
#define HAVE__ULTOA 1
#define HAVE__I64TOA 1
#define HAVE__UI64TOA 1
#define HAVE__STRTOI64 1
#define HAVE__STRTOUI64 1
#define HAVE__STRICMP 1
#define HAVE__STRNICMP 1
#define HAVE_GETAUXVAL 1
#define HAVE_ELF_AUX_INFO 1
#define HAVE_NANOSLEEP 1
#define HAVE_CLOCK_GETTIME 1
#define HAVE_GETPAGESIZE 1
#define HAVE_MPROTECT 1
#define HAVE_SEM_TIMEDWAIT 1
#endif

#if defined(unix) || defined(__APPLE__)
#define HAVE_ICONV 1
#define HAVE_SIGACTION 1
#define HAVE_SA_SIGACTION 1
#define HAVE_SETJMP 1
#endif

/* Don't define any of the SDL backend, under the assumption checking for these against the headers won't work anyhow. */

#endif /* _SDL_config_h */
