/* 
 * This file part of sdcv - console version of Stardict program
 * http://sdcv.sourceforge.net
 * Copyright (C) 2005 Evgeniy <dushistov@mail.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "libwrapper.hpp"


static std::string xdxf2text(const char *p)
{
  std::string res;
  for (; *p; ++p) {
    if (*p!='<') {
      res+=*p;
      continue;
    }

    const char *next=strchr(p, '>');
    if (!next)
      continue;

    std::string name(p+1, next-p-1);

    if (name=="abr")
      res+="";
    else if (name=="/abr")
      res+="";
    else if (name=="k") {
      const char *begin=next;
      if ((next=strstr(begin, "</k>"))!=NULL)
				next+=sizeof("</k>")-1-1;
      else
				next=begin;
    } else if (name=="b")
      res+="";
    else if (name=="/b")
      res+="";
    else if (name=="i")
      res+="";
    else if (name=="/i")
      res+="";
		else if (name=="tr")
			res+="[";
		else if (name=="/tr")
			res+="]";
    else if (name=="ex")
      res+="";
    else if (name=="/ex")
      res+="";
    else if (!name.empty() && name[0]=='c' && name!="co") {
      std::string::size_type pos=name.find("code");
      if (pos!=std::string::size_type(-1)) {
				pos+=sizeof("code=\"")-1;
				std::string::size_type end_pos=name.find("\"");
				std::string color(name, pos, end_pos-pos);
				res+="";
      } else {
				res+="";
      }
    } else if (name=="/c")
      res+="";

    p=next;
  }
  return res;
}

static string parse_data(const gchar *data)
{
  if (!data)
    return "";

  string res;
  guint32 data_size, sec_size=0;
  gchar *m_str;
  const gchar *p=data;
  data_size=*((guint32 *)p);
  p+=sizeof(guint32);
  while (guint32(p - data)<data_size) {
    switch (*p++) {
    case 'm':
    case 'l': //need more work...
    case 'g':
      sec_size = strlen(p);
      if (sec_size) {
				res+="\n";
				m_str = g_strndup(p, sec_size);				
				res += m_str;
				g_free(m_str);							
      }
      sec_size++;
      break;
    case 'x':
      sec_size = strlen(p);
      if (sec_size) {
				res+="\n";
				m_str = g_strndup(p, sec_size);				
				res += xdxf2text(m_str);
				g_free(m_str);							
      }
      sec_size++;
      break;
    case 't':
      sec_size = strlen(p);
      if(sec_size){
				res+="\n";
				m_str = g_strndup(p, sec_size);
				res += "["+string(m_str)+"]";
				g_free(m_str);
      }
      sec_size++;
      break;
    case 'y':
      sec_size = strlen(p);
      sec_size++;						
      break;
    case 'W':
    case 'P':
      sec_size=*((guint32 *)p);
      sec_size+=sizeof(guint32);
      break;
    }								
    p += sec_size;
  }

  
  return res;
}

void Library::SimpleLookup(const char *str, TSearchResultList& res_list)
{
  Dicts::TSearchResList rl;
  if (Dicts::SimpleLookup(str, rl)) {
    for (Dicts::TSearchResList::iterator p=rl.begin(); p!=rl.end(); ++p)
      res_list.push_back(
        TSearchResult(operator[](p->iDict)->GetBookname(), str, 
											parse_data(GetData(*p))
											)
				);
  }
}

void Library::LookupWithFuzzy(const char *str, TSearchResultList& res_list)
{
  TStringsList fuzzy_res;
  if (Dicts::LookupWithFuzzy(str, fuzzy_res, 4))
    for (TStringsList::iterator p=fuzzy_res.begin();
	 p!=fuzzy_res.end(); ++p) 
      SimpleLookup(p->c_str(), res_list);
}

void Library::LookupWithRule(const char *str, TSearchResultList& res_list)
{
  TStringsList MatchWords;
 
  if (Dicts::LookupWithRule(str, MatchWords, 4))
    for (TStringsList::iterator p=MatchWords.begin();
	 p!=MatchWords.end(); ++p)
      SimpleLookup(p->c_str(), res_list);
}
