/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#include "resources.h"
#include "types.h"

// The Legend of Kyrandia
#include "resources/lok_amiga.h"
#include "resources/lok_amiga_english.h"
#include "resources/lok_amiga_german.h"

#include "resources/lok_dos_demo.h"
#include "resources/lok_dos_demo_english.h"

#include "resources/lok_dos.h"
#include "resources/lok_dos_english.h"
#include "resources/lok_dos_french.h"
#include "resources/lok_dos_german.h"
#include "resources/lok_dos_italian.h"
#include "resources/lok_dos_oldfloppy.h"
#include "resources/lok_dos_oldfloppy_russian.h"
#include "resources/lok_dos_spanish.h"

#include "resources/lok_dos_cd.h"
#include "resources/lok_dos_cd_english.h"
#include "resources/lok_dos_cd_french.h"
#include "resources/lok_dos_cd_german.h"
#include "resources/lok_dos_cd_italian.h"

#include "resources/lok_dos_cddemo.h"
#include "resources/lok_dos_cddemo_english.h"

#include "resources/lok_fmtowns.h"
#include "resources/lok_fmtowns_english.h"
#include "resources/lok_fmtowns_japanese.h"

#include "resources/lok_pc98.h"
#include "resources/lok_pc98_japanese.h"

// The Hand of Fate
#include "resources/hof_dos_demo.h"

#include "resources/hof_dos.h"
#include "resources/hof_dos_english.h"
#include "resources/hof_dos_french.h"
#include "resources/hof_dos_german.h"
#include "resources/hof_dos_italian.h"
#include "resources/hof_dos_russian.h"

#include "resources/hof_dos_cddemo.h"
#include "resources/hof_dos_cddemo_english.h"
#include "resources/hof_dos_cddemo_french.h"
#include "resources/hof_dos_cddemo_german.h"

#include "resources/hof_dos_cd.h"
#include "resources/hof_dos_cd_english.h"
#include "resources/hof_dos_cd_french.h"
#include "resources/hof_dos_cd_german.h"
#include "resources/hof_dos_cd_italian.h"
#include "resources/hof_dos_cd_russian.h"

#include "resources/hof_fmtowns.h"
#include "resources/hof_fmtowns_english.h"
#include "resources/hof_fmtowns_japanese.h"

#include "resources/hof_pc98.h"
#include "resources/hof_pc98_english.h"
#include "resources/hof_pc98_japanese.h"

// Malcolm's Revenge
#include "resources/mr_dos_cd.h"

// Eye of the Beholder
#include "resources/eob1_dos.h"
#include "resources/eob1_dos_english.h"
#include "resources/eob1_dos_german.h"
#include "resources/eob1_dos_italian.h"

// Eye of the Beholder: The Legend of Darkmoon
#include "resources/eob2_dos.h"
#include "resources/eob2_dos_english.h"
#include "resources/eob2_dos_german.h"

// Lands of Lore
#include "resources/lol_dos_demo.h"
#include "resources/lol_dos_demo_english.h"

#include "resources/lol_dos.h"
#include "resources/lol_dos_english.h"
#include "resources/lol_dos_french.h"
#include "resources/lol_dos_german.h"
#include "resources/lol_dos_russian.h"

#include "resources/lol_dos_cd.h"
#include "resources/lol_dos_cd_english.h"
#include "resources/lol_dos_cd_french.h"
#include "resources/lol_dos_cd_german.h"
#include "resources/lol_dos_cd_italian.h"
#include "resources/lol_dos_cd_russian.h"

#include "resources/lol_pc98.h"
#include "resources/lol_pc98_japanese.h"

#include "resources/lol_fmtowns.h"
#include "resources/lol_fmtowns_japanese.h"

static const ResourceProvider resourceProviders[] = {
	{ k1WestwoodLogoSeq, kKyra1, kPlatformDOS, kDemoVersion, UNK_LANG, &k1WestwoodLogoSeqDOSDemoProvider },
	{ k1KyrandiaLogoSeq, kKyra1, kPlatformDOS, kDemoVersion, UNK_LANG, &k1KyrandiaLogoSeqDOSDemoProvider },
	{ k1IntroCPSStrings, kKyra1, kPlatformDOS, kDemoVersion, UNK_LANG, &k1IntroCPSStringsDOSDemoProvider },
	{ k1IntroCOLStrings, kKyra1, kPlatformDOS, kDemoVersion, UNK_LANG, &k1IntroCOLStringsDOSDemoProvider },
	{ k1IntroWSAStrings, kKyra1, kPlatformDOS, kDemoVersion, UNK_LANG, &k1IntroWSAStringsDOSDemoProvider },
	{ k1IntroStrings, kKyra1, kPlatformDOS, kDemoVersion, EN_ANY, &k1IntroStringsDOSDemoEnglishProvider },
	{ k1Demo1Seq, kKyra1, kPlatformDOS, kDemoVersion, UNK_LANG, &k1Demo1SeqDOSDemoProvider },
	{ k1Demo2Seq, kKyra1, kPlatformDOS, kDemoVersion, UNK_LANG, &k1Demo2SeqDOSDemoProvider },
	{ k1Demo3Seq, kKyra1, kPlatformDOS, kDemoVersion, UNK_LANG, &k1Demo3SeqDOSDemoProvider },
	{ k1Demo4Seq, kKyra1, kPlatformDOS, kDemoVersion, UNK_LANG, &k1Demo4SeqDOSDemoProvider },
	{ k1AudioTracksIntro, kKyra1, kPlatformDOS, kDemoVersion, UNK_LANG, &k1AudioTracksIntroDOSDemoProvider },
	{ k1KallakWritingSeq, kKyra1, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k1KallakWritingSeqDOSCDDemoProvider },
	{ k1MalcolmTreeSeq, kKyra1, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k1MalcolmTreeSeqDOSCDDemoProvider },
	{ k1WestwoodLogoSeq, kKyra1, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k1WestwoodLogoSeqDOSCDDemoProvider },
	{ k1KyrandiaLogoSeq, kKyra1, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k1KyrandiaLogoSeqDOSCDDemoProvider },
	{ k1KallakMalcolmSeq, kKyra1, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k1KallakMalcolmSeqDOSCDDemoProvider },
	{ k1ForestSeq, kKyra1, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k1ForestSeqDOSCDDemoProvider },
	{ k1IntroCPSStrings, kKyra1, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k1IntroCPSStringsDOSCDDemoProvider },
	{ k1IntroCOLStrings, kKyra1, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k1IntroCOLStringsDOSCDDemoProvider },
	{ k1IntroWSAStrings, kKyra1, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k1IntroWSAStringsDOSCDDemoProvider },
	{ k1IntroStrings, kKyra1, kPlatformDOS, kTalkieDemoVersion, EN_ANY, &k1IntroStringsDOSCDDemoEnglishProvider },
	{ k1AudioTracksIntro, kKyra1, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k1AudioTracksIntroDOSCDDemoProvider },
	{ k1KallakWritingSeq, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1KallakWritingSeqAmigaProvider },
	{ k1MalcolmTreeSeq, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1MalcolmTreeSeqAmigaProvider },
	{ k1WestwoodLogoSeq, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1WestwoodLogoSeqAmigaProvider },
	{ k1KyrandiaLogoSeq, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1KyrandiaLogoSeqAmigaProvider },
	{ k1KallakMalcolmSeq, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1KallakMalcolmSeqAmigaProvider },
	{ k1ForestSeq, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1ForestSeqAmigaProvider },
	{ k1IntroCPSStrings, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1IntroCPSStringsAmigaProvider },
	{ k1IntroWSAStrings, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1IntroWSAStringsAmigaProvider },
	{ k1IntroCOLStrings, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1IntroCOLStringsAmigaProvider },
	{ k1IntroStrings, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1IntroStringsAmigaEnglishProvider },
	{ k1RoomList, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1RoomListAmigaProvider },
	{ k1RoomFilenames, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1RoomFilenamesAmigaProvider },
	{ k1CharacterImageFilenames, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1CharacterImageFilenamesAmigaProvider },
	{ k1DefaultShapes, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1DefaultShapesAmigaProvider },
	{ k1ItemNames, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1ItemNamesAmigaEnglishProvider },
	{ k1TakenStrings, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1TakenStringsAmigaEnglishProvider },
	{ k1PlacedStrings, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1PlacedStringsAmigaEnglishProvider },
	{ k1DroppedStrings, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1DroppedStringsAmigaEnglishProvider },
	{ k1NoDropStrings, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1NoDropStringsAmigaEnglishProvider },
	{ k1AmuleteAnimSeq, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1AmuleteAnimSeqAmigaProvider },
	{ k1PutDownString, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1PutDownStringAmigaEnglishProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1WaitAmuletStringAmigaEnglishProvider },
	{ k1BlackJewelString, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1BlackJewelStringAmigaEnglishProvider },
	{ k1HealingTipString, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1HealingTipStringAmigaEnglishProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1PoisonGoneStringAmigaEnglishProvider },
	{ k1Healing1Shapes, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1Healing1ShapesAmigaProvider },
	{ k1Healing2Shapes, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1Healing2ShapesAmigaProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1ThePoisonStringsAmigaEnglishProvider },
	{ k1FluteStrings, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1FluteStringsAmigaEnglishProvider },
	{ k1PoisonDeathShapes, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1PoisonDeathShapesAmigaProvider },
	{ k1FluteShapes, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1FluteShapesAmigaProvider },
	{ k1Winter1Shapes, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1Winter1ShapesAmigaProvider },
	{ k1Winter2Shapes, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1Winter2ShapesAmigaProvider },
	{ k1Winter3Shapes, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1Winter3ShapesAmigaProvider },
	{ k1DrinkShapes, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1DrinkShapesAmigaProvider },
	{ k1WispShapes, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1WispShapesAmigaProvider },
	{ k1MagicAnimShapes, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1MagicAnimShapesAmigaProvider },
	{ k1BranStoneShapes, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1BranStoneShapesAmigaProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1WispJewelStringsAmigaEnglishProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1MagicJewelStringsAmigaEnglishProvider },
	{ k1FlaskFullString, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1FlaskFullStringAmigaEnglishProvider },
	{ k1FullFlaskString, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1FullFlaskStringAmigaEnglishProvider },
	{ k1OutroReunionSeq, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1OutroReunionSeqAmigaProvider },
	{ k1OutroHomeString, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1OutroHomeStringAmigaEnglishProvider },
	{ k1VeryCleverString, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1VeryCleverStringAmigaEnglishProvider },
	{ k1GUIStrings, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1GUIStringsAmigaEnglishProvider },
	{ k1NewGameString, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1NewGameStringAmigaEnglishProvider },
	{ k1ConfigStrings, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1ConfigStringsAmigaEnglishProvider },
	{ k1CreditsStrings, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1CreditsStringsAmigaEnglishProvider },
	{ k1AmigaIntroSFXTable, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1AmigaIntroSFXTableAmigaProvider },
	{ k1AmigaGameSFXTable, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1AmigaGameSFXTableAmigaProvider },
	{ k1IntroStrings, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1IntroStringsAmigaGermanProvider },
	{ k1ItemNames, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1ItemNamesAmigaGermanProvider },
	{ k1TakenStrings, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1TakenStringsAmigaGermanProvider },
	{ k1PlacedStrings, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1PlacedStringsAmigaGermanProvider },
	{ k1DroppedStrings, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1DroppedStringsAmigaGermanProvider },
	{ k1NoDropStrings, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1NoDropStringsAmigaGermanProvider },
	{ k1PutDownString, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1PutDownStringAmigaGermanProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1WaitAmuletStringAmigaGermanProvider },
	{ k1BlackJewelString, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1BlackJewelStringAmigaGermanProvider },
	{ k1HealingTipString, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1HealingTipStringAmigaGermanProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1PoisonGoneStringAmigaGermanProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1ThePoisonStringsAmigaGermanProvider },
	{ k1FluteStrings, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1FluteStringsAmigaGermanProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1WispJewelStringsAmigaGermanProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1MagicJewelStringsAmigaGermanProvider },
	{ k1FlaskFullString, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1FlaskFullStringAmigaGermanProvider },
	{ k1FullFlaskString, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1FullFlaskStringAmigaGermanProvider },
	{ k1OutroHomeString, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1OutroHomeStringAmigaGermanProvider },
	{ k1VeryCleverString, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1VeryCleverStringAmigaGermanProvider },
	{ k1GUIStrings, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1GUIStringsAmigaGermanProvider },
	{ k1NewGameString, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1NewGameStringAmigaGermanProvider },
	{ k1ConfigStrings, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1ConfigStringsAmigaGermanProvider },
	{ k1CreditsStrings, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1CreditsStringsAmigaGermanProvider },
	{ k1KallakWritingSeq, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1KallakWritingSeqDOSProvider },
	{ k1MalcolmTreeSeq, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1MalcolmTreeSeqDOSProvider },
	{ k1WestwoodLogoSeq, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1WestwoodLogoSeqDOSProvider },
	{ k1KyrandiaLogoSeq, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1KyrandiaLogoSeqDOSProvider },
	{ k1KallakMalcolmSeq, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1KallakMalcolmSeqDOSProvider },
	{ k1ForestSeq, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1ForestSeqDOSProvider },
	{ k1IntroCPSStrings, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1IntroCPSStringsDOSProvider },
	{ k1IntroCOLStrings, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1IntroCOLStringsDOSProvider },
	{ k1IntroWSAStrings, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1IntroWSAStringsDOSProvider },
	{ k1IntroStrings, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1IntroStringsDOSEnglishProvider },
	{ k1RoomList, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1RoomListDOSProvider },
	{ k1RoomFilenames, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1RoomFilenamesDOSProvider },
	{ k1CharacterImageFilenames, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1CharacterImageFilenamesDOSProvider },
	{ k1DefaultShapes, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1DefaultShapesDOSProvider },
	{ k1ItemNames, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1ItemNamesDOSEnglishProvider },
	{ k1TakenStrings, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1TakenStringsDOSEnglishProvider },
	{ k1PlacedStrings, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1PlacedStringsDOSEnglishProvider },
	{ k1DroppedStrings, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1DroppedStringsDOSEnglishProvider },
	{ k1NoDropStrings, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1NoDropStringsDOSEnglishProvider },
	{ k1AmuleteAnimSeq, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1AmuleteAnimSeqDOSProvider },
	{ k1SpecialPalette1, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette1DOSProvider },
	{ k1SpecialPalette2, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette2DOSProvider },
	{ k1SpecialPalette3, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette3DOSProvider },
	{ k1SpecialPalette4, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette4DOSProvider },
	{ k1SpecialPalette5, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette5DOSProvider },
	{ k1SpecialPalette6, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette6DOSProvider },
	{ k1SpecialPalette7, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette7DOSProvider },
	{ k1SpecialPalette8, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette8DOSProvider },
	{ k1SpecialPalette9, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette9DOSProvider },
	{ k1SpecialPalette10, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette10DOSProvider },
	{ k1SpecialPalette11, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette11DOSProvider },
	{ k1SpecialPalette12, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette12DOSProvider },
	{ k1SpecialPalette13, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette13DOSProvider },
	{ k1SpecialPalette14, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette14DOSProvider },
	{ k1SpecialPalette15, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette15DOSProvider },
	{ k1SpecialPalette16, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette16DOSProvider },
	{ k1SpecialPalette17, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette17DOSProvider },
	{ k1SpecialPalette18, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette18DOSProvider },
	{ k1SpecialPalette19, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette19DOSProvider },
	{ k1SpecialPalette20, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette20DOSProvider },
	{ k1SpecialPalette21, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette21DOSProvider },
	{ k1SpecialPalette22, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette22DOSProvider },
	{ k1SpecialPalette23, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette23DOSProvider },
	{ k1SpecialPalette24, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette24DOSProvider },
	{ k1SpecialPalette25, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette25DOSProvider },
	{ k1SpecialPalette26, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette26DOSProvider },
	{ k1SpecialPalette27, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette27DOSProvider },
	{ k1SpecialPalette28, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette28DOSProvider },
	{ k1SpecialPalette29, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette29DOSProvider },
	{ k1SpecialPalette30, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette30DOSProvider },
	{ k1SpecialPalette31, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette31DOSProvider },
	{ k1SpecialPalette32, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette32DOSProvider },
	{ k1SpecialPalette33, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette33DOSProvider },
	{ k1PutDownString, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1PutDownStringDOSEnglishProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1WaitAmuletStringDOSEnglishProvider },
	{ k1BlackJewelString, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1BlackJewelStringDOSEnglishProvider },
	{ k1HealingTipString, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1HealingTipStringDOSEnglishProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1PoisonGoneStringDOSEnglishProvider },
	{ k1Healing1Shapes, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1Healing1ShapesDOSProvider },
	{ k1Healing2Shapes, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1Healing2ShapesDOSProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1ThePoisonStringsDOSEnglishProvider },
	{ k1FluteStrings, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1FluteStringsDOSEnglishProvider },
	{ k1PoisonDeathShapes, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1PoisonDeathShapesDOSProvider },
	{ k1FluteShapes, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1FluteShapesDOSProvider },
	{ k1Winter1Shapes, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1Winter1ShapesDOSProvider },
	{ k1Winter2Shapes, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1Winter2ShapesDOSProvider },
	{ k1Winter3Shapes, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1Winter3ShapesDOSProvider },
	{ k1DrinkShapes, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1DrinkShapesDOSProvider },
	{ k1WispShapes, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1WispShapesDOSProvider },
	{ k1MagicAnimShapes, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1MagicAnimShapesDOSProvider },
	{ k1BranStoneShapes, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1BranStoneShapesDOSProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1WispJewelStringsDOSEnglishProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1MagicJewelStringsDOSEnglishProvider },
	{ k1FlaskFullString, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1FlaskFullStringDOSEnglishProvider },
	{ k1FullFlaskString, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1FullFlaskStringDOSEnglishProvider },
	{ k1OutroReunionSeq, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1OutroReunionSeqDOSProvider },
	{ k1OutroHomeString, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1OutroHomeStringDOSEnglishProvider },
	{ k1VeryCleverString, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1VeryCleverStringDOSEnglishProvider },
	{ k1GUIStrings, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1GUIStringsDOSEnglishProvider },
	{ k1NewGameString, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1NewGameStringDOSEnglishProvider },
	{ k1ConfigStrings, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1ConfigStringsDOSEnglishProvider },
	{ k1AudioTracks, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1AudioTracksDOSProvider },
	{ k1AudioTracks2, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1AudioTracks2DOSProvider },
	{ k1AudioTracksIntro, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1AudioTracksIntroDOSProvider },
	{ k1IntroStrings, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1IntroStringsDOSGermanProvider },
	{ k1ItemNames, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1ItemNamesDOSGermanProvider },
	{ k1TakenStrings, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1TakenStringsDOSGermanProvider },
	{ k1PlacedStrings, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1PlacedStringsDOSGermanProvider },
	{ k1DroppedStrings, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1DroppedStringsDOSGermanProvider },
	{ k1NoDropStrings, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1NoDropStringsDOSGermanProvider },
	{ k1PutDownString, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1PutDownStringDOSGermanProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1WaitAmuletStringDOSGermanProvider },
	{ k1BlackJewelString, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1BlackJewelStringDOSGermanProvider },
	{ k1HealingTipString, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1HealingTipStringDOSGermanProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1PoisonGoneStringDOSGermanProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1ThePoisonStringsDOSGermanProvider },
	{ k1FluteStrings, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1FluteStringsDOSGermanProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1WispJewelStringsDOSGermanProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1MagicJewelStringsDOSGermanProvider },
	{ k1FlaskFullString, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1FlaskFullStringDOSGermanProvider },
	{ k1FullFlaskString, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1FullFlaskStringDOSGermanProvider },
	{ k1OutroHomeString, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1OutroHomeStringDOSGermanProvider },
	{ k1VeryCleverString, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1VeryCleverStringDOSGermanProvider },
	{ k1GUIStrings, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1GUIStringsDOSGermanProvider },
	{ k1NewGameString, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1NewGameStringDOSGermanProvider },
	{ k1ConfigStrings, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1ConfigStringsDOSGermanProvider },
	{ k1IntroStrings, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1IntroStringsDOSFrenchProvider },
	{ k1ItemNames, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1ItemNamesDOSFrenchProvider },
	{ k1TakenStrings, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1TakenStringsDOSFrenchProvider },
	{ k1PlacedStrings, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1PlacedStringsDOSFrenchProvider },
	{ k1DroppedStrings, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1DroppedStringsDOSFrenchProvider },
	{ k1NoDropStrings, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1NoDropStringsDOSFrenchProvider },
	{ k1PutDownString, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1PutDownStringDOSFrenchProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1WaitAmuletStringDOSFrenchProvider },
	{ k1BlackJewelString, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1BlackJewelStringDOSFrenchProvider },
	{ k1HealingTipString, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1HealingTipStringDOSFrenchProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1PoisonGoneStringDOSFrenchProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1ThePoisonStringsDOSFrenchProvider },
	{ k1FluteStrings, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1FluteStringsDOSFrenchProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1WispJewelStringsDOSFrenchProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1MagicJewelStringsDOSFrenchProvider },
	{ k1FlaskFullString, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1FlaskFullStringDOSFrenchProvider },
	{ k1FullFlaskString, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1FullFlaskStringDOSFrenchProvider },
	{ k1OutroHomeString, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1OutroHomeStringDOSFrenchProvider },
	{ k1VeryCleverString, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1VeryCleverStringDOSFrenchProvider },
	{ k1GUIStrings, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1GUIStringsDOSFrenchProvider },
	{ k1NewGameString, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1NewGameStringDOSFrenchProvider },
	{ k1ConfigStrings, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1ConfigStringsDOSFrenchProvider },
	{ k1IntroStrings, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1IntroStringsDOSItalianProvider },
	{ k1ItemNames, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1ItemNamesDOSItalianProvider },
	{ k1TakenStrings, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1TakenStringsDOSItalianProvider },
	{ k1PlacedStrings, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1PlacedStringsDOSItalianProvider },
	{ k1DroppedStrings, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1DroppedStringsDOSItalianProvider },
	{ k1NoDropStrings, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1NoDropStringsDOSItalianProvider },
	{ k1PutDownString, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1PutDownStringDOSItalianProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1WaitAmuletStringDOSItalianProvider },
	{ k1BlackJewelString, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1BlackJewelStringDOSItalianProvider },
	{ k1HealingTipString, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1HealingTipStringDOSItalianProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1PoisonGoneStringDOSItalianProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1ThePoisonStringsDOSItalianProvider },
	{ k1FluteStrings, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1FluteStringsDOSItalianProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1WispJewelStringsDOSItalianProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1MagicJewelStringsDOSItalianProvider },
	{ k1FlaskFullString, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1FlaskFullStringDOSItalianProvider },
	{ k1FullFlaskString, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1FullFlaskStringDOSItalianProvider },
	{ k1OutroHomeString, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1OutroHomeStringDOSItalianProvider },
	{ k1VeryCleverString, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1VeryCleverStringDOSItalianProvider },
	{ k1GUIStrings, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1GUIStringsDOSItalianProvider },
	{ k1NewGameString, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1NewGameStringDOSItalianProvider },
	{ k1ConfigStrings, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1ConfigStringsDOSItalianProvider },
	{ k1IntroStrings, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1IntroStringsDOSSpanishProvider },
	{ k1ItemNames, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1ItemNamesDOSSpanishProvider },
	{ k1TakenStrings, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1TakenStringsDOSSpanishProvider },
	{ k1PlacedStrings, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1PlacedStringsDOSSpanishProvider },
	{ k1DroppedStrings, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1DroppedStringsDOSSpanishProvider },
	{ k1NoDropStrings, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1NoDropStringsDOSSpanishProvider },
	{ k1PutDownString, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1PutDownStringDOSSpanishProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1WaitAmuletStringDOSSpanishProvider },
	{ k1BlackJewelString, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1BlackJewelStringDOSSpanishProvider },
	{ k1HealingTipString, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1HealingTipStringDOSSpanishProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1PoisonGoneStringDOSSpanishProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1ThePoisonStringsDOSSpanishProvider },
	{ k1FluteStrings, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1FluteStringsDOSSpanishProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1WispJewelStringsDOSSpanishProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1MagicJewelStringsDOSSpanishProvider },
	{ k1FlaskFullString, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1FlaskFullStringDOSSpanishProvider },
	{ k1FullFlaskString, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1FullFlaskStringDOSSpanishProvider },
	{ k1OutroHomeString, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1OutroHomeStringDOSSpanishProvider },
	{ k1VeryCleverString, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1VeryCleverStringDOSSpanishProvider },
	{ k1GUIStrings, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1GUIStringsDOSSpanishProvider },
	{ k1NewGameString, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1NewGameStringDOSSpanishProvider },
	{ k1ConfigStrings, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1ConfigStringsDOSSpanishProvider },
	{ k1KallakWritingSeq, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1KallakWritingSeqDOSOldFloppyProvider },
	{ k1MalcolmTreeSeq, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1MalcolmTreeSeqDOSOldFloppyProvider },
	{ k1WestwoodLogoSeq, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1WestwoodLogoSeqDOSOldFloppyProvider },
	{ k1KyrandiaLogoSeq, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1KyrandiaLogoSeqDOSOldFloppyProvider },
	{ k1KallakMalcolmSeq, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1KallakMalcolmSeqDOSOldFloppyProvider },
	{ k1ForestSeq, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1ForestSeqDOSOldFloppyProvider },
	{ k1IntroCPSStrings, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1IntroCPSStringsDOSOldFloppyProvider },
	{ k1IntroCOLStrings, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1IntroCOLStringsDOSOldFloppyProvider },
	{ k1IntroWSAStrings, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1IntroWSAStringsDOSOldFloppyProvider },
	{ k1IntroStrings, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1IntroStringsDOSOldFloppyRussianProvider },
	{ k1RoomList, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1RoomListDOSOldFloppyProvider },
	{ k1RoomFilenames, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1RoomFilenamesDOSOldFloppyProvider },
	{ k1CharacterImageFilenames, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1CharacterImageFilenamesDOSOldFloppyProvider },
	{ k1DefaultShapes, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1DefaultShapesDOSOldFloppyProvider },
	{ k1ItemNames, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1ItemNamesDOSOldFloppyRussianProvider },
	{ k1TakenStrings, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1TakenStringsDOSOldFloppyRussianProvider },
	{ k1PlacedStrings, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1PlacedStringsDOSOldFloppyRussianProvider },
	{ k1DroppedStrings, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1DroppedStringsDOSOldFloppyRussianProvider },
	{ k1AmuleteAnimSeq, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1AmuleteAnimSeqDOSOldFloppyProvider },
	{ k1SpecialPalette1, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette1DOSOldFloppyProvider },
	{ k1SpecialPalette2, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette2DOSOldFloppyProvider },
	{ k1SpecialPalette3, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette3DOSOldFloppyProvider },
	{ k1SpecialPalette4, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette4DOSOldFloppyProvider },
	{ k1SpecialPalette5, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette5DOSOldFloppyProvider },
	{ k1SpecialPalette6, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette6DOSOldFloppyProvider },
	{ k1SpecialPalette7, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette7DOSOldFloppyProvider },
	{ k1SpecialPalette8, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette8DOSOldFloppyProvider },
	{ k1SpecialPalette9, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette9DOSOldFloppyProvider },
	{ k1SpecialPalette10, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette10DOSOldFloppyProvider },
	{ k1SpecialPalette11, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette11DOSOldFloppyProvider },
	{ k1SpecialPalette12, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette12DOSOldFloppyProvider },
	{ k1SpecialPalette13, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette13DOSOldFloppyProvider },
	{ k1SpecialPalette14, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette14DOSOldFloppyProvider },
	{ k1SpecialPalette15, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette15DOSOldFloppyProvider },
	{ k1SpecialPalette16, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette16DOSOldFloppyProvider },
	{ k1SpecialPalette17, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette17DOSOldFloppyProvider },
	{ k1SpecialPalette18, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette18DOSOldFloppyProvider },
	{ k1SpecialPalette19, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette19DOSOldFloppyProvider },
	{ k1SpecialPalette20, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette20DOSOldFloppyProvider },
	{ k1SpecialPalette21, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette21DOSOldFloppyProvider },
	{ k1SpecialPalette22, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette22DOSOldFloppyProvider },
	{ k1SpecialPalette23, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette23DOSOldFloppyProvider },
	{ k1SpecialPalette24, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette24DOSOldFloppyProvider },
	{ k1SpecialPalette25, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette25DOSOldFloppyProvider },
	{ k1SpecialPalette26, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette26DOSOldFloppyProvider },
	{ k1SpecialPalette27, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette27DOSOldFloppyProvider },
	{ k1SpecialPalette28, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette28DOSOldFloppyProvider },
	{ k1SpecialPalette29, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette29DOSOldFloppyProvider },
	{ k1SpecialPalette30, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette30DOSOldFloppyProvider },
	{ k1SpecialPalette31, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette31DOSOldFloppyProvider },
	{ k1SpecialPalette32, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette32DOSOldFloppyProvider },
	{ k1PutDownString, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1PutDownStringDOSOldFloppyRussianProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1WaitAmuletStringDOSOldFloppyRussianProvider },
	{ k1BlackJewelString, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1BlackJewelStringDOSOldFloppyRussianProvider },
	{ k1HealingTipString, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1HealingTipStringDOSOldFloppyRussianProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1PoisonGoneStringDOSOldFloppyRussianProvider },
	{ k1Healing1Shapes, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1Healing1ShapesDOSOldFloppyProvider },
	{ k1Healing2Shapes, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1Healing2ShapesDOSOldFloppyProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1ThePoisonStringsDOSOldFloppyRussianProvider },
	{ k1FluteStrings, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1FluteStringsDOSOldFloppyRussianProvider },
	{ k1PoisonDeathShapes, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1PoisonDeathShapesDOSOldFloppyProvider },
	{ k1FluteShapes, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1FluteShapesDOSOldFloppyProvider },
	{ k1Winter1Shapes, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1Winter1ShapesDOSOldFloppyProvider },
	{ k1Winter2Shapes, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1Winter2ShapesDOSOldFloppyProvider },
	{ k1Winter3Shapes, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1Winter3ShapesDOSOldFloppyProvider },
	{ k1DrinkShapes, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1DrinkShapesDOSOldFloppyProvider },
	{ k1WispShapes, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1WispShapesDOSOldFloppyProvider },
	{ k1MagicAnimShapes, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1MagicAnimShapesDOSOldFloppyProvider },
	{ k1BranStoneShapes, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1BranStoneShapesDOSOldFloppyProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1WispJewelStringsDOSOldFloppyRussianProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1MagicJewelStringsDOSOldFloppyRussianProvider },
	{ k1FlaskFullString, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1FlaskFullStringDOSOldFloppyRussianProvider },
	{ k1FullFlaskString, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1FullFlaskStringDOSOldFloppyRussianProvider },
	{ k1OutroReunionSeq, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1OutroReunionSeqDOSOldFloppyProvider },
	{ k1OutroHomeString, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1OutroHomeStringDOSOldFloppyRussianProvider },
	{ k1VeryCleverString, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1VeryCleverStringDOSOldFloppyRussianProvider },
	{ k1GUIStrings, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1GUIStringsDOSOldFloppyRussianProvider },
	{ k1NewGameString, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1NewGameStringDOSOldFloppyRussianProvider },
	{ k1ConfigStrings, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1ConfigStringsDOSOldFloppyRussianProvider },
	{ k1AudioTracks, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1AudioTracksDOSOldFloppyProvider },
	{ k1AudioTracks2, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1AudioTracks2DOSOldFloppyProvider },
	{ k1AudioTracksIntro, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1AudioTracksIntroDOSOldFloppyProvider },
	{ k1KallakWritingSeq, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1KallakWritingSeqDOSCDProvider },
	{ k1MalcolmTreeSeq, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1MalcolmTreeSeqDOSCDProvider },
	{ k1WestwoodLogoSeq, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1WestwoodLogoSeqDOSCDProvider },
	{ k1KyrandiaLogoSeq, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1KyrandiaLogoSeqDOSCDProvider },
	{ k1KallakMalcolmSeq, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1KallakMalcolmSeqDOSCDProvider },
	{ k1ForestSeq, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1ForestSeqDOSCDProvider },
	{ k1IntroCPSStrings, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1IntroCPSStringsDOSCDProvider },
	{ k1IntroCOLStrings, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1IntroCOLStringsDOSCDProvider },
	{ k1IntroWSAStrings, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1IntroWSAStringsDOSCDProvider },
	{ k1IntroStrings, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1IntroStringsDOSCDEnglishProvider },
	{ k1RoomList, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1RoomListDOSCDProvider },
	{ k1RoomFilenames, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1RoomFilenamesDOSCDProvider },
	{ k1CharacterImageFilenames, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1CharacterImageFilenamesDOSCDProvider },
	{ k1DefaultShapes, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1DefaultShapesDOSCDProvider },
	{ k1ItemNames, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1ItemNamesDOSCDEnglishProvider },
	{ k1TakenStrings, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1TakenStringsDOSCDEnglishProvider },
	{ k1PlacedStrings, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1PlacedStringsDOSCDEnglishProvider },
	{ k1DroppedStrings, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1DroppedStringsDOSCDEnglishProvider },
	{ k1NoDropStrings, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1NoDropStringsDOSCDEnglishProvider },
	{ k1AmuleteAnimSeq, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1AmuleteAnimSeqDOSCDProvider },
	{ k1SpecialPalette1, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette1DOSCDProvider },
	{ k1SpecialPalette2, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette2DOSCDProvider },
	{ k1SpecialPalette3, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette3DOSCDProvider },
	{ k1SpecialPalette4, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette4DOSCDProvider },
	{ k1SpecialPalette5, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette5DOSCDProvider },
	{ k1SpecialPalette6, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette6DOSCDProvider },
	{ k1SpecialPalette7, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette7DOSCDProvider },
	{ k1SpecialPalette8, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette8DOSCDProvider },
	{ k1SpecialPalette9, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette9DOSCDProvider },
	{ k1SpecialPalette10, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette10DOSCDProvider },
	{ k1SpecialPalette11, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette11DOSCDProvider },
	{ k1SpecialPalette12, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette12DOSCDProvider },
	{ k1SpecialPalette13, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette13DOSCDProvider },
	{ k1SpecialPalette14, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette14DOSCDProvider },
	{ k1SpecialPalette15, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette15DOSCDProvider },
	{ k1SpecialPalette16, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette16DOSCDProvider },
	{ k1SpecialPalette17, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette17DOSCDProvider },
	{ k1SpecialPalette18, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette18DOSCDProvider },
	{ k1SpecialPalette19, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette19DOSCDProvider },
	{ k1SpecialPalette20, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette20DOSCDProvider },
	{ k1SpecialPalette21, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette21DOSCDProvider },
	{ k1SpecialPalette22, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette22DOSCDProvider },
	{ k1SpecialPalette23, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette23DOSCDProvider },
	{ k1SpecialPalette24, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette24DOSCDProvider },
	{ k1SpecialPalette25, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette25DOSCDProvider },
	{ k1SpecialPalette26, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette26DOSCDProvider },
	{ k1SpecialPalette27, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette27DOSCDProvider },
	{ k1SpecialPalette28, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette28DOSCDProvider },
	{ k1SpecialPalette29, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette29DOSCDProvider },
	{ k1SpecialPalette30, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette30DOSCDProvider },
	{ k1SpecialPalette31, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette31DOSCDProvider },
	{ k1SpecialPalette32, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette32DOSCDProvider },
	{ k1SpecialPalette33, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette33DOSCDProvider },
	{ k1PutDownString, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1PutDownStringDOSCDEnglishProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1WaitAmuletStringDOSCDEnglishProvider },
	{ k1BlackJewelString, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1BlackJewelStringDOSCDEnglishProvider },
	{ k1HealingTipString, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1HealingTipStringDOSCDEnglishProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1PoisonGoneStringDOSCDEnglishProvider },
	{ k1Healing1Shapes, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1Healing1ShapesDOSCDProvider },
	{ k1Healing2Shapes, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1Healing2ShapesDOSCDProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1ThePoisonStringsDOSCDEnglishProvider },
	{ k1FluteStrings, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1FluteStringsDOSCDEnglishProvider },
	{ k1PoisonDeathShapes, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1PoisonDeathShapesDOSCDProvider },
	{ k1FluteShapes, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1FluteShapesDOSCDProvider },
	{ k1Winter1Shapes, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1Winter1ShapesDOSCDProvider },
	{ k1Winter2Shapes, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1Winter2ShapesDOSCDProvider },
	{ k1Winter3Shapes, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1Winter3ShapesDOSCDProvider },
	{ k1DrinkShapes, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1DrinkShapesDOSCDProvider },
	{ k1WispShapes, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1WispShapesDOSCDProvider },
	{ k1MagicAnimShapes, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1MagicAnimShapesDOSCDProvider },
	{ k1BranStoneShapes, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1BranStoneShapesDOSCDProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1WispJewelStringsDOSCDEnglishProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1MagicJewelStringsDOSCDEnglishProvider },
	{ k1FlaskFullString, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1FlaskFullStringDOSCDEnglishProvider },
	{ k1FullFlaskString, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1FullFlaskStringDOSCDEnglishProvider },
	{ k1OutroReunionSeq, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1OutroReunionSeqDOSCDProvider },
	{ k1OutroHomeString, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1OutroHomeStringDOSCDEnglishProvider },
	{ k1VeryCleverString, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1VeryCleverStringDOSCDEnglishProvider },
	{ k1GUIStrings, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1GUIStringsDOSCDEnglishProvider },
	{ k1NewGameString, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1NewGameStringDOSCDEnglishProvider },
	{ k1ConfigStrings, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1ConfigStringsDOSCDEnglishProvider },
	{ k1AudioTracks, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1AudioTracksDOSCDProvider },
	{ k1AudioTracks2, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1AudioTracks2DOSCDProvider },
	{ k1AudioTracksIntro, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1AudioTracksIntroDOSCDProvider },
	{ k1IntroStrings, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1IntroStringsDOSCDGermanProvider },
	{ k1ItemNames, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1ItemNamesDOSCDGermanProvider },
	{ k1TakenStrings, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1TakenStringsDOSCDGermanProvider },
	{ k1PlacedStrings, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1PlacedStringsDOSCDGermanProvider },
	{ k1DroppedStrings, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1DroppedStringsDOSCDGermanProvider },
	{ k1NoDropStrings, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1NoDropStringsDOSCDGermanProvider },
	{ k1PutDownString, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1PutDownStringDOSCDGermanProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1WaitAmuletStringDOSCDGermanProvider },
	{ k1BlackJewelString, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1BlackJewelStringDOSCDGermanProvider },
	{ k1HealingTipString, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1HealingTipStringDOSCDGermanProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1PoisonGoneStringDOSCDGermanProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1ThePoisonStringsDOSCDGermanProvider },
	{ k1FluteStrings, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1FluteStringsDOSCDGermanProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1WispJewelStringsDOSCDGermanProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1MagicJewelStringsDOSCDGermanProvider },
	{ k1FlaskFullString, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1FlaskFullStringDOSCDGermanProvider },
	{ k1FullFlaskString, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1FullFlaskStringDOSCDGermanProvider },
	{ k1OutroHomeString, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1OutroHomeStringDOSCDGermanProvider },
	{ k1VeryCleverString, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1VeryCleverStringDOSCDGermanProvider },
	{ k1GUIStrings, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1GUIStringsDOSCDGermanProvider },
	{ k1NewGameString, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1NewGameStringDOSCDGermanProvider },
	{ k1ConfigStrings, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1ConfigStringsDOSCDGermanProvider },
	{ k1IntroStrings, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1IntroStringsDOSCDFrenchProvider },
	{ k1ItemNames, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1ItemNamesDOSCDFrenchProvider },
	{ k1TakenStrings, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1TakenStringsDOSCDFrenchProvider },
	{ k1PlacedStrings, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1PlacedStringsDOSCDFrenchProvider },
	{ k1DroppedStrings, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1DroppedStringsDOSCDFrenchProvider },
	{ k1NoDropStrings, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1NoDropStringsDOSCDFrenchProvider },
	{ k1PutDownString, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1PutDownStringDOSCDFrenchProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1WaitAmuletStringDOSCDFrenchProvider },
	{ k1BlackJewelString, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1BlackJewelStringDOSCDFrenchProvider },
	{ k1HealingTipString, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1HealingTipStringDOSCDFrenchProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1PoisonGoneStringDOSCDFrenchProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1ThePoisonStringsDOSCDFrenchProvider },
	{ k1FluteStrings, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1FluteStringsDOSCDFrenchProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1WispJewelStringsDOSCDFrenchProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1MagicJewelStringsDOSCDFrenchProvider },
	{ k1FlaskFullString, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1FlaskFullStringDOSCDFrenchProvider },
	{ k1FullFlaskString, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1FullFlaskStringDOSCDFrenchProvider },
	{ k1OutroHomeString, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1OutroHomeStringDOSCDFrenchProvider },
	{ k1VeryCleverString, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1VeryCleverStringDOSCDFrenchProvider },
	{ k1GUIStrings, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1GUIStringsDOSCDFrenchProvider },
	{ k1NewGameString, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1NewGameStringDOSCDFrenchProvider },
	{ k1ConfigStrings, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1ConfigStringsDOSCDFrenchProvider },
	{ k1IntroStrings, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1IntroStringsDOSCDItalianProvider },
	{ k1ItemNames, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1ItemNamesDOSCDItalianProvider },
	{ k1TakenStrings, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1TakenStringsDOSCDItalianProvider },
	{ k1PlacedStrings, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1PlacedStringsDOSCDItalianProvider },
	{ k1DroppedStrings, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1DroppedStringsDOSCDItalianProvider },
	{ k1NoDropStrings, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1NoDropStringsDOSCDItalianProvider },
	{ k1PutDownString, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1PutDownStringDOSCDItalianProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1WaitAmuletStringDOSCDItalianProvider },
	{ k1BlackJewelString, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1BlackJewelStringDOSCDItalianProvider },
	{ k1HealingTipString, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1HealingTipStringDOSCDItalianProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1PoisonGoneStringDOSCDItalianProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1ThePoisonStringsDOSCDItalianProvider },
	{ k1FluteStrings, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1FluteStringsDOSCDItalianProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1WispJewelStringsDOSCDItalianProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1MagicJewelStringsDOSCDItalianProvider },
	{ k1FlaskFullString, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1FlaskFullStringDOSCDItalianProvider },
	{ k1FullFlaskString, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1FullFlaskStringDOSCDItalianProvider },
	{ k1OutroHomeString, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1OutroHomeStringDOSCDItalianProvider },
	{ k1VeryCleverString, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1VeryCleverStringDOSCDItalianProvider },
	{ k1GUIStrings, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1GUIStringsDOSCDItalianProvider },
	{ k1NewGameString, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1NewGameStringDOSCDItalianProvider },
	{ k1ConfigStrings, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1ConfigStringsDOSCDItalianProvider },
	{ k1KallakWritingSeq, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1KallakWritingSeqFMTownsProvider },
	{ k1MalcolmTreeSeq, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1MalcolmTreeSeqFMTownsProvider },
	{ k1WestwoodLogoSeq, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1WestwoodLogoSeqFMTownsProvider },
	{ k1KyrandiaLogoSeq, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1KyrandiaLogoSeqFMTownsProvider },
	{ k1KallakMalcolmSeq, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1KallakMalcolmSeqFMTownsProvider },
	{ k1ForestSeq, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1ForestSeqFMTownsProvider },
	{ k1IntroCPSStrings, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1IntroCPSStringsFMTownsProvider },
	{ k1IntroCOLStrings, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1IntroCOLStringsFMTownsProvider },
	{ k1IntroWSAStrings, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1IntroWSAStringsFMTownsProvider },
	{ k1IntroStrings, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1IntroStringsFMTownsEnglishProvider },
	{ k1RoomList, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1RoomListFMTownsProvider },
	{ k1RoomFilenames, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1RoomFilenamesFMTownsProvider },
	{ k1CharacterImageFilenames, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1CharacterImageFilenamesFMTownsProvider },
	{ k1DefaultShapes, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1DefaultShapesFMTownsProvider },
	{ k1ItemNames, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1ItemNamesFMTownsEnglishProvider },
	{ k1TakenStrings, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1TakenStringsFMTownsEnglishProvider },
	{ k1PlacedStrings, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1PlacedStringsFMTownsEnglishProvider },
	{ k1DroppedStrings, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1DroppedStringsFMTownsEnglishProvider },
	{ k1NoDropStrings, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1NoDropStringsFMTownsEnglishProvider },
	{ k1AmuleteAnimSeq, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1AmuleteAnimSeqFMTownsProvider },
	{ k1SpecialPalette1, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette1FMTownsProvider },
	{ k1SpecialPalette2, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette2FMTownsProvider },
	{ k1SpecialPalette3, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette3FMTownsProvider },
	{ k1SpecialPalette4, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette4FMTownsProvider },
	{ k1SpecialPalette5, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette5FMTownsProvider },
	{ k1SpecialPalette6, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette6FMTownsProvider },
	{ k1SpecialPalette7, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette7FMTownsProvider },
	{ k1SpecialPalette8, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette8FMTownsProvider },
	{ k1SpecialPalette9, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette9FMTownsProvider },
	{ k1SpecialPalette10, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette10FMTownsProvider },
	{ k1SpecialPalette11, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette11FMTownsProvider },
	{ k1SpecialPalette12, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette12FMTownsProvider },
	{ k1SpecialPalette13, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette13FMTownsProvider },
	{ k1SpecialPalette14, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette14FMTownsProvider },
	{ k1SpecialPalette15, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette15FMTownsProvider },
	{ k1SpecialPalette16, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette16FMTownsProvider },
	{ k1SpecialPalette17, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette17FMTownsProvider },
	{ k1SpecialPalette18, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette18FMTownsProvider },
	{ k1SpecialPalette19, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette19FMTownsProvider },
	{ k1SpecialPalette20, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette20FMTownsProvider },
	{ k1SpecialPalette21, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette21FMTownsProvider },
	{ k1SpecialPalette22, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette22FMTownsProvider },
	{ k1SpecialPalette23, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette23FMTownsProvider },
	{ k1SpecialPalette24, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette24FMTownsProvider },
	{ k1SpecialPalette25, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette25FMTownsProvider },
	{ k1SpecialPalette26, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette26FMTownsProvider },
	{ k1SpecialPalette27, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette27FMTownsProvider },
	{ k1SpecialPalette28, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette28FMTownsProvider },
	{ k1SpecialPalette29, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette29FMTownsProvider },
	{ k1SpecialPalette30, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette30FMTownsProvider },
	{ k1SpecialPalette31, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette31FMTownsProvider },
	{ k1SpecialPalette32, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette32FMTownsProvider },
	{ k1SpecialPalette33, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette33FMTownsProvider },
	{ k1PutDownString, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1PutDownStringFMTownsEnglishProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1WaitAmuletStringFMTownsEnglishProvider },
	{ k1BlackJewelString, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1BlackJewelStringFMTownsEnglishProvider },
	{ k1HealingTipString, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1HealingTipStringFMTownsEnglishProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1PoisonGoneStringFMTownsEnglishProvider },
	{ k1Healing1Shapes, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1Healing1ShapesFMTownsProvider },
	{ k1Healing2Shapes, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1Healing2ShapesFMTownsProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1ThePoisonStringsFMTownsEnglishProvider },
	{ k1FluteStrings, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1FluteStringsFMTownsEnglishProvider },
	{ k1PoisonDeathShapes, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1PoisonDeathShapesFMTownsProvider },
	{ k1FluteShapes, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1FluteShapesFMTownsProvider },
	{ k1Winter1Shapes, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1Winter1ShapesFMTownsProvider },
	{ k1Winter2Shapes, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1Winter2ShapesFMTownsProvider },
	{ k1Winter3Shapes, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1Winter3ShapesFMTownsProvider },
	{ k1DrinkShapes, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1DrinkShapesFMTownsProvider },
	{ k1WispShapes, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1WispShapesFMTownsProvider },
	{ k1MagicAnimShapes, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1MagicAnimShapesFMTownsProvider },
	{ k1BranStoneShapes, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1BranStoneShapesFMTownsProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1WispJewelStringsFMTownsEnglishProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1MagicJewelStringsFMTownsEnglishProvider },
	{ k1FlaskFullString, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1FlaskFullStringFMTownsEnglishProvider },
	{ k1FullFlaskString, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1FullFlaskStringFMTownsEnglishProvider },
	{ k1OutroReunionSeq, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1OutroReunionSeqFMTownsProvider },
	{ k1OutroHomeString, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1OutroHomeStringFMTownsEnglishProvider },
	{ k1VeryCleverString, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1VeryCleverStringFMTownsEnglishProvider },
	{ k1GUIStrings, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1GUIStringsFMTownsEnglishProvider },
	{ k1NewGameString, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1NewGameStringFMTownsEnglishProvider },
	{ k1ConfigStrings, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1ConfigStringsFMTownsEnglishProvider },
	{ k1TownsMusicFadeTable, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1TownsMusicFadeTableFMTownsProvider },
	{ k1TownsSFXwdTable, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1TownsSFXwdTableFMTownsProvider },
	{ k1TownsSFXbtTable, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1TownsSFXbtTableFMTownsProvider },
	{ k1TownsCDATable, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1TownsCDATableFMTownsProvider },
	{ k1AudioTracks, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1AudioTracksFMTownsProvider },
	{ k1CreditsStrings, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1CreditsStringsFMTownsEnglishProvider },
	{ k1IntroStrings, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1IntroStringsFMTownsJapaneseProvider },
	{ k1ItemNames, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1ItemNamesFMTownsJapaneseProvider },
	{ k1TakenStrings, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1TakenStringsFMTownsJapaneseProvider },
	{ k1PlacedStrings, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1PlacedStringsFMTownsJapaneseProvider },
	{ k1DroppedStrings, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1DroppedStringsFMTownsJapaneseProvider },
	{ k1NoDropStrings, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1NoDropStringsFMTownsJapaneseProvider },
	{ k1PutDownString, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1PutDownStringFMTownsJapaneseProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1WaitAmuletStringFMTownsJapaneseProvider },
	{ k1BlackJewelString, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1BlackJewelStringFMTownsJapaneseProvider },
	{ k1HealingTipString, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1HealingTipStringFMTownsJapaneseProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1PoisonGoneStringFMTownsJapaneseProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1ThePoisonStringsFMTownsJapaneseProvider },
	{ k1FluteStrings, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1FluteStringsFMTownsJapaneseProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1WispJewelStringsFMTownsJapaneseProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1MagicJewelStringsFMTownsJapaneseProvider },
	{ k1FlaskFullString, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1FlaskFullStringFMTownsJapaneseProvider },
	{ k1FullFlaskString, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1FullFlaskStringFMTownsJapaneseProvider },
	{ k1OutroHomeString, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1OutroHomeStringFMTownsJapaneseProvider },
	{ k1VeryCleverString, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1VeryCleverStringFMTownsJapaneseProvider },
	{ k1GUIStrings, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1GUIStringsFMTownsJapaneseProvider },
	{ k1NewGameString, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1NewGameStringFMTownsJapaneseProvider },
	{ k1ConfigStrings, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1ConfigStringsFMTownsJapaneseProvider },
	{ k1CreditsStrings, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1CreditsStringsFMTownsJapaneseProvider },
	{ k1KallakWritingSeq, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1KallakWritingSeqPC98Provider },
	{ k1MalcolmTreeSeq, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1MalcolmTreeSeqPC98Provider },
	{ k1WestwoodLogoSeq, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1WestwoodLogoSeqPC98Provider },
	{ k1KyrandiaLogoSeq, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1KyrandiaLogoSeqPC98Provider },
	{ k1KallakMalcolmSeq, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1KallakMalcolmSeqPC98Provider },
	{ k1ForestSeq, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1ForestSeqPC98Provider },
	{ k1IntroCPSStrings, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1IntroCPSStringsPC98Provider },
	{ k1IntroCOLStrings, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1IntroCOLStringsPC98Provider },
	{ k1IntroWSAStrings, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1IntroWSAStringsPC98Provider },
	{ k1IntroStrings, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1IntroStringsPC98JapaneseProvider },
	{ k1RoomList, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1RoomListPC98Provider },
	{ k1RoomFilenames, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1RoomFilenamesPC98Provider },
	{ k1CharacterImageFilenames, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1CharacterImageFilenamesPC98Provider },
	{ k1DefaultShapes, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1DefaultShapesPC98Provider },
	{ k1ItemNames, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1ItemNamesPC98JapaneseProvider },
	{ k1TakenStrings, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1TakenStringsPC98JapaneseProvider },
	{ k1PlacedStrings, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1PlacedStringsPC98JapaneseProvider },
	{ k1DroppedStrings, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1DroppedStringsPC98JapaneseProvider },
	{ k1NoDropStrings, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1NoDropStringsPC98JapaneseProvider },
	{ k1AmuleteAnimSeq, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1AmuleteAnimSeqPC98Provider },
	{ k1SpecialPalette1, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette1PC98Provider },
	{ k1SpecialPalette2, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette2PC98Provider },
	{ k1SpecialPalette3, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette3PC98Provider },
	{ k1SpecialPalette4, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette4PC98Provider },
	{ k1SpecialPalette5, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette5PC98Provider },
	{ k1SpecialPalette6, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette6PC98Provider },
	{ k1SpecialPalette7, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette7PC98Provider },
	{ k1SpecialPalette8, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette8PC98Provider },
	{ k1SpecialPalette9, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette9PC98Provider },
	{ k1SpecialPalette10, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette10PC98Provider },
	{ k1SpecialPalette11, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette11PC98Provider },
	{ k1SpecialPalette12, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette12PC98Provider },
	{ k1SpecialPalette13, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette13PC98Provider },
	{ k1SpecialPalette14, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette14PC98Provider },
	{ k1SpecialPalette15, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette15PC98Provider },
	{ k1SpecialPalette16, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette16PC98Provider },
	{ k1SpecialPalette17, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette17PC98Provider },
	{ k1SpecialPalette18, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette18PC98Provider },
	{ k1SpecialPalette19, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette19PC98Provider },
	{ k1SpecialPalette20, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette20PC98Provider },
	{ k1SpecialPalette21, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette21PC98Provider },
	{ k1SpecialPalette22, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette22PC98Provider },
	{ k1SpecialPalette23, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette23PC98Provider },
	{ k1SpecialPalette24, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette24PC98Provider },
	{ k1SpecialPalette25, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette25PC98Provider },
	{ k1SpecialPalette26, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette26PC98Provider },
	{ k1SpecialPalette27, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette27PC98Provider },
	{ k1SpecialPalette28, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette28PC98Provider },
	{ k1SpecialPalette29, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette29PC98Provider },
	{ k1SpecialPalette30, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette30PC98Provider },
	{ k1SpecialPalette31, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette31PC98Provider },
	{ k1SpecialPalette32, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette32PC98Provider },
	{ k1SpecialPalette33, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette33PC98Provider },
	{ k1PutDownString, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1PutDownStringPC98JapaneseProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1WaitAmuletStringPC98JapaneseProvider },
	{ k1BlackJewelString, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1BlackJewelStringPC98JapaneseProvider },
	{ k1HealingTipString, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1HealingTipStringPC98JapaneseProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1PoisonGoneStringPC98JapaneseProvider },
	{ k1Healing1Shapes, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1Healing1ShapesPC98Provider },
	{ k1Healing2Shapes, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1Healing2ShapesPC98Provider },
	{ k1ThePoisonStrings, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1ThePoisonStringsPC98JapaneseProvider },
	{ k1FluteStrings, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1FluteStringsPC98JapaneseProvider },
	{ k1PoisonDeathShapes, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1PoisonDeathShapesPC98Provider },
	{ k1FluteShapes, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1FluteShapesPC98Provider },
	{ k1Winter1Shapes, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1Winter1ShapesPC98Provider },
	{ k1Winter2Shapes, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1Winter2ShapesPC98Provider },
	{ k1Winter3Shapes, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1Winter3ShapesPC98Provider },
	{ k1DrinkShapes, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1DrinkShapesPC98Provider },
	{ k1WispShapes, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1WispShapesPC98Provider },
	{ k1MagicAnimShapes, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1MagicAnimShapesPC98Provider },
	{ k1BranStoneShapes, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1BranStoneShapesPC98Provider },
	{ k1WispJewelStrings, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1WispJewelStringsPC98JapaneseProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1MagicJewelStringsPC98JapaneseProvider },
	{ k1FlaskFullString, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1FlaskFullStringPC98JapaneseProvider },
	{ k1FullFlaskString, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1FullFlaskStringPC98JapaneseProvider },
	{ k1OutroReunionSeq, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1OutroReunionSeqPC98Provider },
	{ k1OutroHomeString, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1OutroHomeStringPC98JapaneseProvider },
	{ k1VeryCleverString, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1VeryCleverStringPC98JapaneseProvider },
	{ k1GUIStrings, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1GUIStringsPC98JapaneseProvider },
	{ k1NewGameString, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1NewGameStringPC98JapaneseProvider },
	{ k1ConfigStrings, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1ConfigStringsPC98JapaneseProvider },
	{ k1PC98StoryStrings, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1PC98StoryStringsPC98JapaneseProvider },
	{ k1PC98IntroSfx, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1PC98IntroSfxPC98Provider },
	{ k1CreditsStrings, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1CreditsStringsPC98JapaneseProvider },
	{ k2SeqplayPakFiles, kKyra2, kPlatformDOS, kDemoVersion, UNK_LANG, &k2SeqplayPakFilesDOSDemoProvider },
	{ k2SeqplaySeqData, kKyra2, kPlatformDOS, kDemoVersion, UNK_LANG, &k2SeqplaySeqDataDOSDemoProvider },
	{ k2SeqplaySfxFiles, kKyra2, kPlatformDOS, kDemoVersion, UNK_LANG, &k2SeqplaySfxFilesDOSDemoProvider },
	{ k2SeqplayIntroTracks, kKyra2, kPlatformDOS, kDemoVersion, UNK_LANG, &k2SeqplayIntroTracksDOSDemoProvider },
	{ k2SeqplayShapeAnimData, kKyra2, kPlatformDOS, kDemoVersion, UNK_LANG, &k2SeqplayShapeAnimDataDOSDemoProvider },
	{ k2SeqplayPakFiles, kKyra2, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k2SeqplayPakFilesDOSCDDemoProvider },
	{ k2SeqplayCredits, kKyra2, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k2SeqplayCreditsDOSCDDemoProvider },
	{ k2SeqplayCreditsSpecial, kKyra2, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k2SeqplayCreditsSpecialDOSCDDemoProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kTalkieDemoVersion, EN_ANY, &k2SeqplayStringsDOSCDDemoEnglishProvider },
	{ k2SeqplaySfxFiles, kKyra2, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k2SeqplaySfxFilesDOSCDDemoProvider },
	{ k2SeqplayTlkFiles, kKyra2, kPlatformDOS, kTalkieDemoVersion, EN_ANY, &k2SeqplayTlkFilesDOSCDDemoEnglishProvider },
	{ k2SeqplaySeqData, kKyra2, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k2SeqplaySeqDataDOSCDDemoProvider },
	{ k2SeqplayIntroTracks, kKyra2, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k2SeqplayIntroTracksDOSCDDemoProvider },
	{ k2SeqplayFinaleTracks, kKyra2, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k2SeqplayFinaleTracksDOSCDDemoProvider },
	{ k2IngameSfxFiles, kKyra2, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k2IngameSfxFilesDOSCDDemoProvider },
	{ k2IngameSfxIndex, kKyra2, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k2IngameSfxIndexDOSCDDemoProvider },
	{ k2IngameTracks, kKyra2, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k2IngameTracksDOSCDDemoProvider },
	{ k2IngameTalkObjIndex, kKyra2, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k2IngameTalkObjIndexDOSCDDemoProvider },
	{ k2IngameShapeAnimData, kKyra2, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k2IngameShapeAnimDataDOSCDDemoProvider },
	{ k2IngameTlkDemoStrings, kKyra2, kPlatformDOS, kTalkieDemoVersion, EN_ANY, &k2IngameTlkDemoStringsDOSCDDemoEnglishProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kTalkieDemoVersion, FR_FRA, &k2SeqplayStringsDOSCDDemoFrenchProvider },
	{ k2SeqplayTlkFiles, kKyra2, kPlatformDOS, kTalkieDemoVersion, FR_FRA, &k2SeqplayTlkFilesDOSCDDemoFrenchProvider },
	{ k2IngameTlkDemoStrings, kKyra2, kPlatformDOS, kTalkieDemoVersion, FR_FRA, &k2IngameTlkDemoStringsDOSCDDemoFrenchProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kTalkieDemoVersion, DE_DEU, &k2SeqplayStringsDOSCDDemoGermanProvider },
	{ k2SeqplayTlkFiles, kKyra2, kPlatformDOS, kTalkieDemoVersion, DE_DEU, &k2SeqplayTlkFilesDOSCDDemoGermanProvider },
	{ k2IngameTlkDemoStrings, kKyra2, kPlatformDOS, kTalkieDemoVersion, DE_DEU, &k2IngameTlkDemoStringsDOSCDDemoGermanProvider },
	{ k2SeqplayPakFiles, kKyra2, kPlatformDOS, kNoSpecial, UNK_LANG, &k2SeqplayPakFilesDOSProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kNoSpecial, EN_ANY, &k2SeqplayStringsDOSEnglishProvider },
	{ k2SeqplaySfxFiles, kKyra2, kPlatformDOS, kNoSpecial, UNK_LANG, &k2SeqplaySfxFilesDOSProvider },
	{ k2SeqplayIntroTracks, kKyra2, kPlatformDOS, kNoSpecial, UNK_LANG, &k2SeqplayIntroTracksDOSProvider },
	{ k2SeqplayFinaleTracks, kKyra2, kPlatformDOS, kNoSpecial, UNK_LANG, &k2SeqplayFinaleTracksDOSProvider },
	{ k2SeqplaySeqData, kKyra2, kPlatformDOS, kNoSpecial, UNK_LANG, &k2SeqplaySeqDataDOSProvider },
	{ k2IngamePakFiles, kKyra2, kPlatformDOS, kNoSpecial, UNK_LANG, &k2IngamePakFilesDOSProvider },
	{ k2IngameSfxFiles, kKyra2, kPlatformDOS, kNoSpecial, UNK_LANG, &k2IngameSfxFilesDOSProvider },
	{ k2IngameSfxIndex, kKyra2, kPlatformDOS, kNoSpecial, UNK_LANG, &k2IngameSfxIndexDOSProvider },
	{ k2IngameTracks, kKyra2, kPlatformDOS, kNoSpecial, UNK_LANG, &k2IngameTracksDOSProvider },
	{ k2IngameTalkObjIndex, kKyra2, kPlatformDOS, kNoSpecial, UNK_LANG, &k2IngameTalkObjIndexDOSProvider },
	{ k2IngameShapeAnimData, kKyra2, kPlatformDOS, kNoSpecial, UNK_LANG, &k2IngameShapeAnimDataDOSProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kNoSpecial, FR_FRA, &k2SeqplayStringsDOSFrenchProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kNoSpecial, DE_DEU, &k2SeqplayStringsDOSGermanProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kNoSpecial, IT_ITA, &k2SeqplayStringsDOSItalianProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kNoSpecial, RU_RUS, &k2SeqplayStringsDOSRussianProvider },
	{ k2SeqplayPakFiles, kKyra2, kPlatformDOS, kTalkieVersion, UNK_LANG, &k2SeqplayPakFilesDOSCDProvider },
	{ k2SeqplayCredits, kKyra2, kPlatformDOS, kTalkieVersion, UNK_LANG, &k2SeqplayCreditsDOSCDProvider },
	{ k2SeqplayCreditsSpecial, kKyra2, kPlatformDOS, kTalkieVersion, UNK_LANG, &k2SeqplayCreditsSpecialDOSCDProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kTalkieVersion, EN_ANY, &k2SeqplayStringsDOSCDEnglishProvider },
	{ k2SeqplaySfxFiles, kKyra2, kPlatformDOS, kTalkieVersion, UNK_LANG, &k2SeqplaySfxFilesDOSCDProvider },
	{ k2SeqplayTlkFiles, kKyra2, kPlatformDOS, kTalkieVersion, EN_ANY, &k2SeqplayTlkFilesDOSCDEnglishProvider },
	{ k2SeqplaySeqData, kKyra2, kPlatformDOS, kTalkieVersion, UNK_LANG, &k2SeqplaySeqDataDOSCDProvider },
	{ k2SeqplayIntroTracks, kKyra2, kPlatformDOS, kTalkieVersion, UNK_LANG, &k2SeqplayIntroTracksDOSCDProvider },
	{ k2SeqplayFinaleTracks, kKyra2, kPlatformDOS, kTalkieVersion, UNK_LANG, &k2SeqplayFinaleTracksDOSCDProvider },
	{ k2IngameSfxFiles, kKyra2, kPlatformDOS, kTalkieVersion, UNK_LANG, &k2IngameSfxFilesDOSCDProvider },
	{ k2IngameSfxIndex, kKyra2, kPlatformDOS, kTalkieVersion, UNK_LANG, &k2IngameSfxIndexDOSCDProvider },
	{ k2IngameTracks, kKyra2, kPlatformDOS, kTalkieVersion, UNK_LANG, &k2IngameTracksDOSCDProvider },
	{ k2IngameTalkObjIndex, kKyra2, kPlatformDOS, kTalkieVersion, UNK_LANG, &k2IngameTalkObjIndexDOSCDProvider },
	{ k2IngameShapeAnimData, kKyra2, kPlatformDOS, kTalkieVersion, UNK_LANG, &k2IngameShapeAnimDataDOSCDProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kTalkieVersion, FR_FRA, &k2SeqplayStringsDOSCDFrenchProvider },
	{ k2SeqplayTlkFiles, kKyra2, kPlatformDOS, kTalkieVersion, FR_FRA, &k2SeqplayTlkFilesDOSCDFrenchProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kTalkieVersion, DE_DEU, &k2SeqplayStringsDOSCDGermanProvider },
	{ k2SeqplayTlkFiles, kKyra2, kPlatformDOS, kTalkieVersion, DE_DEU, &k2SeqplayTlkFilesDOSCDGermanProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kTalkieVersion, IT_ITA, &k2SeqplayStringsDOSCDItalianProvider },
	{ k2SeqplayTlkFiles, kKyra2, kPlatformDOS, kTalkieVersion, IT_ITA, &k2SeqplayTlkFilesDOSCDItalianProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kTalkieVersion, RU_RUS, &k2SeqplayStringsDOSCDRussianProvider },
	{ k2SeqplayTlkFiles, kKyra2, kPlatformDOS, kTalkieVersion, RU_RUS, &k2SeqplayTlkFilesDOSCDRussianProvider },
	{ k2SeqplayPakFiles, kKyra2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k2SeqplayPakFilesFMTownsProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformFMTowns, kNoSpecial, EN_ANY, &k2SeqplayStringsFMTownsEnglishProvider },
	{ k2SeqplaySfxFiles, kKyra2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k2SeqplaySfxFilesFMTownsProvider },
	{ k2SeqplaySeqData, kKyra2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k2SeqplaySeqDataFMTownsProvider },
	{ k2SeqplayIntroCDA, kKyra2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k2SeqplayIntroCDAFMTownsProvider },
	{ k2SeqplayFinaleCDA, kKyra2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k2SeqplayFinaleCDAFMTownsProvider },
	{ k2IngamePakFiles, kKyra2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k2IngamePakFilesFMTownsProvider },
	{ k2IngameSfxFiles, kKyra2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k2IngameSfxFilesFMTownsProvider },
	{ k2IngameSfxIndex, kKyra2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k2IngameSfxIndexFMTownsProvider },
	{ k2IngameCDA, kKyra2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k2IngameCDAFMTownsProvider },
	{ k2IngameTalkObjIndex, kKyra2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k2IngameTalkObjIndexFMTownsProvider },
	{ k2IngameTimJpStrings, kKyra2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k2IngameTimJpStringsFMTownsProvider },
	{ k2IngameShapeAnimData, kKyra2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k2IngameShapeAnimDataFMTownsProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformFMTowns, kNoSpecial, JA_JPN, &k2SeqplayStringsFMTownsJapaneseProvider },
	{ k2SeqplayPakFiles, kKyra2, kPlatformPC98, kNoSpecial, UNK_LANG, &k2SeqplayPakFilesPC98Provider },
	{ k2SeqplayStrings, kKyra2, kPlatformPC98, kNoSpecial, EN_ANY, &k2SeqplayStringsPC98EnglishProvider },
	{ k2SeqplaySfxFiles, kKyra2, kPlatformPC98, kNoSpecial, UNK_LANG, &k2SeqplaySfxFilesPC98Provider },
	{ k2SeqplaySeqData, kKyra2, kPlatformPC98, kNoSpecial, UNK_LANG, &k2SeqplaySeqDataPC98Provider },
	{ k2IngamePakFiles, kKyra2, kPlatformPC98, kNoSpecial, UNK_LANG, &k2IngamePakFilesPC98Provider },
	{ k2IngameSfxFiles, kKyra2, kPlatformPC98, kNoSpecial, UNK_LANG, &k2IngameSfxFilesPC98Provider },
	{ k2IngameSfxIndex, kKyra2, kPlatformPC98, kNoSpecial, UNK_LANG, &k2IngameSfxIndexPC98Provider },
	{ k2IngameTalkObjIndex, kKyra2, kPlatformPC98, kNoSpecial, UNK_LANG, &k2IngameTalkObjIndexPC98Provider },
	{ k2IngameTimJpStrings, kKyra2, kPlatformPC98, kNoSpecial, UNK_LANG, &k2IngameTimJpStringsPC98Provider },
	{ k2IngameShapeAnimData, kKyra2, kPlatformPC98, kNoSpecial, UNK_LANG, &k2IngameShapeAnimDataPC98Provider },
	{ k2SeqplayStrings, kKyra2, kPlatformPC98, kNoSpecial, JA_JPN, &k2SeqplayStringsPC98JapaneseProvider },
	{ k3MainMenuStrings, kKyra3, kPlatformDOS, kTalkieVersion, UNK_LANG, &k3MainMenuStringsDOSCDProvider },
	{ k3MusicFiles, kKyra3, kPlatformDOS, kTalkieVersion, UNK_LANG, &k3MusicFilesDOSCDProvider },
	{ k3ScoreTable, kKyra3, kPlatformDOS, kTalkieVersion, UNK_LANG, &k3ScoreTableDOSCDProvider },
	{ k3SfxFiles, kKyra3, kPlatformDOS, kTalkieVersion, UNK_LANG, &k3SfxFilesDOSCDProvider },
	{ k3SfxMap, kKyra3, kPlatformDOS, kTalkieVersion, UNK_LANG, &k3SfxMapDOSCDProvider },
	{ k3ItemAnimData, kKyra3, kPlatformDOS, kTalkieVersion, UNK_LANG, &k3ItemAnimDataDOSCDProvider },
	{ k3ItemMagicTable, kKyra3, kPlatformDOS, kTalkieVersion, UNK_LANG, &k3ItemMagicTableDOSCDProvider },
	{ k3ItemStringMap, kKyra3, kPlatformDOS, kTalkieVersion, UNK_LANG, &k3ItemStringMapDOSCDProvider },
	{ kEoBBaseChargenStrings1, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ChargenStrings1DOSEnglishProvider },
	{ kEoBBaseChargenStrings2, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ChargenStrings2DOSEnglishProvider },
	{ kEoBBaseChargenStartLevels, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ChargenStartLevelsDOSProvider },
	{ kEoBBaseChargenStatStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ChargenStatStringsDOSEnglishProvider },
	{ kEoBBaseChargenRaceSexStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ChargenRaceSexStringsDOSEnglishProvider },
	{ kEoBBaseChargenClassStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ChargenClassStringsDOSEnglishProvider },
	{ kEoBBaseChargenAlignmentStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ChargenAlignmentStringsDOSEnglishProvider },
	{ kEoBBaseChargenEnterGameStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ChargenEnterGameStringsDOSEnglishProvider },
	{ kEoBBaseChargenClassMinStats, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ChargenClassMinStatsDOSProvider },
	{ kEoBBaseChargenRaceMinStats, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ChargenRaceMinStatsDOSProvider },
	{ kEoBBaseChargenRaceMaxStats, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ChargenRaceMaxStatsDOSProvider },
	{ kEoBBaseSaveThrowTable1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SaveThrowTable1DOSProvider },
	{ kEoBBaseSaveThrowTable2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SaveThrowTable2DOSProvider },
	{ kEoBBaseSaveThrowTable3, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SaveThrowTable3DOSProvider },
	{ kEoBBaseSaveThrowTable4, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SaveThrowTable4DOSProvider },
	{ kEoBBaseSaveThrwLvlIndex, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SaveThrwLvlIndexDOSProvider },
	{ kEoBBaseSaveThrwModDiv, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SaveThrwModDivDOSProvider },
	{ kEoBBaseSaveThrwModExt, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SaveThrwModExtDOSProvider },
	{ kEoB1MainMenuStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MainMenuStringsDOSEnglishProvider },
	{ kEoB1BonusStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1BonusStringsDOSEnglishProvider },
	{ kEoB1IntroFilesOpening, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroFilesOpeningDOSProvider },
	{ kEoB1IntroFilesTower, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroFilesTowerDOSProvider },
	{ kEoB1IntroFilesOrb, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroFilesOrbDOSProvider },
	{ kEoB1IntroFilesWdEntry, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroFilesWdEntryDOSProvider },
	{ kEoB1IntroFilesKing, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroFilesKingDOSProvider },
	{ kEoB1IntroFilesHands, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroFilesHandsDOSProvider },
	{ kEoB1IntroFilesWdExit, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroFilesWdExitDOSProvider },
	{ kEoB1IntroFilesTunnel, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroFilesTunnelDOSProvider },
	{ kEoB1IntroOpeningFrmDelay, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroOpeningFrmDelayDOSProvider },
	{ kEoB1IntroWdEncodeX, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroWdEncodeXDOSProvider },
	{ kEoB1IntroWdEncodeY, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroWdEncodeYDOSProvider },
	{ kEoB1IntroWdEncodeWH, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroWdEncodeWHDOSProvider },
	{ kEoB1IntroWdDsX, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroWdDsXDOSProvider },
	{ kEoB1IntroWdDsY, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroWdDsYDOSProvider },
	{ kEoB1IntroTvlX1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroTvlX1DOSProvider },
	{ kEoB1IntroTvlY1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroTvlY1DOSProvider },
	{ kEoB1IntroTvlX2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroTvlX2DOSProvider },
	{ kEoB1IntroTvlY2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroTvlY2DOSProvider },
	{ kEoB1IntroTvlW, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroTvlWDOSProvider },
	{ kEoB1IntroTvlH, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroTvlHDOSProvider },
	{ kEoB1DoorShapeDefs, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DoorShapeDefsDOSProvider },
	{ kEoB1DoorSwitchShapeDefs, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DoorSwitchShapeDefsDOSProvider },
	{ kEoB1DoorSwitchCoords, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DoorSwitchCoordsDOSProvider },
	{ kEoB1MonsterProperties, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1MonsterPropertiesDOSProvider },
	{ kEoB1EnemyMageSpellList, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1EnemyMageSpellListDOSProvider },
	{ kEoB1EnemyMageSfx, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1EnemyMageSfxDOSProvider },
	{ kEoB1BeholderSpellList, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1BeholderSpellListDOSProvider },
	{ kEoB1BeholderSfx, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1BeholderSfxDOSProvider },
	{ kEoB1TurnUndeadString, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1TurnUndeadStringDOSEnglishProvider },
	{ kEoB1CgaMappingDefault, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1CgaMappingDefaultDOSProvider },
	{ kEoB1CgaMappingAlt, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1CgaMappingAltDOSProvider },
	{ kEoB1CgaMappingInv, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1CgaMappingInvDOSProvider },
	{ kEoB1CgaMappingItemsL, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1CgaMappingItemsLDOSProvider },
	{ kEoB1CgaMappingItemsS, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1CgaMappingItemsSDOSProvider },
	{ kEoB1CgaMappingThrown, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1CgaMappingThrownDOSProvider },
	{ kEoB1CgaMappingIcons, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1CgaMappingIconsDOSProvider },
	{ kEoB1CgaMappingDeco, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1CgaMappingDecoDOSProvider },
	{ kEoB1CgaLevelMappingIndex, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1CgaLevelMappingIndexDOSProvider },
	{ kEoB1CgaMappingLevel0, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1CgaMappingLevel0DOSProvider },
	{ kEoB1CgaMappingLevel1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1CgaMappingLevel1DOSProvider },
	{ kEoB1CgaMappingLevel2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1CgaMappingLevel2DOSProvider },
	{ kEoB1CgaMappingLevel3, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1CgaMappingLevel3DOSProvider },
	{ kEoB1CgaMappingLevel4, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1CgaMappingLevel4DOSProvider },
	{ kEoB1NpcShpData, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1NpcShpDataDOSProvider },
	{ kEoB1NpcSubShpIndex1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1NpcSubShpIndex1DOSProvider },
	{ kEoB1NpcSubShpIndex2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1NpcSubShpIndex2DOSProvider },
	{ kEoB1NpcSubShpY, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1NpcSubShpYDOSProvider },
	{ kEoB1Npc0Strings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1Npc0StringsDOSEnglishProvider },
	{ kEoB1Npc11Strings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1Npc11StringsDOSEnglishProvider },
	{ kEoB1Npc12Strings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1Npc12StringsDOSEnglishProvider },
	{ kEoB1Npc21Strings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1Npc21StringsDOSEnglishProvider },
	{ kEoB1Npc22Strings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1Npc22StringsDOSEnglishProvider },
	{ kEoB1Npc31Strings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1Npc31StringsDOSEnglishProvider },
	{ kEoB1Npc32Strings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1Npc32StringsDOSEnglishProvider },
	{ kEoB1Npc4Strings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1Npc4StringsDOSEnglishProvider },
	{ kEoB1Npc5Strings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1Npc5StringsDOSEnglishProvider },
	{ kEoB1Npc6Strings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1Npc6StringsDOSEnglishProvider },
	{ kEoB1Npc7Strings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1Npc7StringsDOSEnglishProvider },
	{ kEoBBasePryDoorStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1PryDoorStringsDOSEnglishProvider },
	{ kEoBBaseWarningStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1WarningStringsDOSEnglishProvider },
	{ kEoBBaseItemSuffixStringsRings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ItemSuffixStringsRingsDOSEnglishProvider },
	{ kEoBBaseItemSuffixStringsPotions, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ItemSuffixStringsPotionsDOSEnglishProvider },
	{ kEoBBaseItemSuffixStringsWands, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ItemSuffixStringsWandsDOSEnglishProvider },
	{ kEoBBaseRipItemStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1RipItemStringsDOSEnglishProvider },
	{ kEoBBaseCursedString, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1CursedStringDOSEnglishProvider },
	{ kEoBBaseEnchantedString, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1EnchantedStringDOSProvider },
	{ kEoBBaseMagicObjectStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MagicObjectStringsDOSEnglishProvider },
	{ kEoBBaseMagicObjectString5, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MagicObjectString5DOSEnglishProvider },
	{ kEoBBasePatternSuffix, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1PatternSuffixDOSEnglishProvider },
	{ kEoBBasePatternGrFix1, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1PatternGrFix1DOSEnglishProvider },
	{ kEoBBasePatternGrFix2, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1PatternGrFix2DOSEnglishProvider },
	{ kEoBBaseValidateArmorString, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ValidateArmorStringDOSEnglishProvider },
	{ kEoBBaseValidateNoDropString, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ValidateNoDropStringDOSEnglishProvider },
	{ kEoBBasePotionStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1PotionStringsDOSEnglishProvider },
	{ kEoBBaseWandStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1WandStringsDOSEnglishProvider },
	{ kEoBBaseItemMisuseStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ItemMisuseStringsDOSEnglishProvider },
	{ kEoBBaseTakenStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1TakenStringsDOSEnglishProvider },
	{ kEoBBasePotionEffectStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1PotionEffectStringsDOSEnglishProvider },
	{ kEoBBaseYesNoStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1YesNoStringsDOSEnglishProvider },
	{ kRpgCommonMoreStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MoreStringsDOSEnglishProvider },
	{ kEoBBaseNpcMaxStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1NpcMaxStringsDOSEnglishProvider },
	{ kEoBBaseNpcJoinStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1NpcJoinStringsDOSEnglishProvider },
	{ kEoBBaseCancelStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1CancelStringsDOSEnglishProvider },
	{ kEoBBaseMenuStringsMain, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsMainDOSEnglishProvider },
	{ kEoBBaseMenuStringsSaveLoad, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsSaveLoadDOSEnglishProvider },
	{ kEoBBaseMenuStringsOnOff, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsOnOffDOSEnglishProvider },
	{ kEoBBaseMenuStringsSpells, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsSpellsDOSEnglishProvider },
	{ kEoBBaseMenuStringsRest, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsRestDOSEnglishProvider },
	{ kEoBBaseMenuStringsDrop, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsDropDOSEnglishProvider },
	{ kEoBBaseMenuStringsExit, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsExitDOSEnglishProvider },
	{ kEoBBaseMenuStringsStarve, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsStarveDOSEnglishProvider },
	{ kEoBBaseMenuStringsScribe, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsScribeDOSEnglishProvider },
	{ kEoBBaseMenuStringsDrop2, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsDrop2DOSEnglishProvider },
	{ kEoBBaseMenuStringsHead, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsHeadDOSEnglishProvider },
	{ kEoBBaseMenuStringsPoison, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsPoisonDOSEnglishProvider },
	{ kEoBBaseMenuStringsMgc, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsMgcDOSEnglishProvider },
	{ kEoBBaseMenuStringsPrefs, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsPrefsDOSEnglishProvider },
	{ kEoBBaseMenuStringsRest2, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsRest2DOSEnglishProvider },
	{ kEoBBaseMenuStringsRest4, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsRest4DOSEnglishProvider },
	{ kEoBBaseMenuStringsDefeat, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsDefeatDOSEnglishProvider },
	{ kEoBBaseMenuYesNoStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuYesNoStringsDOSEnglishProvider },
	{ kEoBBaseSpellLevelsMage, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SpellLevelsMageDOSProvider },
	{ kEoBBaseSpellLevelsCleric, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SpellLevelsClericDOSProvider },
	{ kEoBBaseNumSpellsCleric, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1NumSpellsClericDOSProvider },
	{ kEoBBaseNumSpellsWisAdj, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1NumSpellsWisAdjDOSProvider },
	{ kEoBBaseNumSpellsPal, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1NumSpellsPalDOSProvider },
	{ kEoBBaseNumSpellsMage, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1NumSpellsMageDOSProvider },
	{ kEoBBaseCharGuiStringsHp, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1CharGuiStringsHpDOSEnglishProvider },
	{ kEoBBaseCharGuiStringsWp1, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1CharGuiStringsWp1DOSEnglishProvider },
	{ kEoBBaseCharGuiStringsWr, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1CharGuiStringsWrDOSEnglishProvider },
	{ kEoBBaseCharGuiStringsSt1, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1CharGuiStringsSt1DOSEnglishProvider },
	{ kEoBBaseCharGuiStringsIn, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1CharGuiStringsInDOSEnglishProvider },
	{ kEoBBaseCharStatusStrings7, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1CharStatusStrings7DOSEnglishProvider },
	{ kEoBBaseCharStatusStrings81, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1CharStatusStrings81DOSEnglishProvider },
	{ kEoBBaseCharStatusStrings9, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1CharStatusStrings9DOSEnglishProvider },
	{ kEoBBaseCharStatusStrings131, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1CharStatusStrings131DOSEnglishProvider },
	{ kEoBBaseLevelGainStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1LevelGainStringsDOSEnglishProvider },
	{ kEoBBaseExperienceTable0, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ExperienceTable0DOSProvider },
	{ kEoBBaseExperienceTable1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ExperienceTable1DOSProvider },
	{ kEoBBaseExperienceTable2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ExperienceTable2DOSProvider },
	{ kEoBBaseExperienceTable3, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ExperienceTable3DOSProvider },
	{ kEoBBaseExperienceTable4, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ExperienceTable4DOSProvider },
	{ kEoBBaseBookNumbers, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1BookNumbersDOSEnglishProvider },
	{ kEoBBaseMageSpellsList, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MageSpellsListDOSEnglishProvider },
	{ kEoBBaseClericSpellsList, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ClericSpellsListDOSEnglishProvider },
	{ kEoBBaseSpellNames, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1SpellNamesDOSEnglishProvider },
	{ kEoBBaseMagicStrings1, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MagicStrings1DOSEnglishProvider },
	{ kEoBBaseMagicStrings2, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MagicStrings2DOSEnglishProvider },
	{ kEoBBaseMagicStrings3, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MagicStrings3DOSEnglishProvider },
	{ kEoBBaseMagicStrings4, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MagicStrings4DOSEnglishProvider },
	{ kEoBBaseMagicStrings6, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MagicStrings6DOSEnglishProvider },
	{ kEoBBaseMagicStrings7, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MagicStrings7DOSEnglishProvider },
	{ kEoBBaseMagicStrings8, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MagicStrings8DOSEnglishProvider },
	{ kEoBBaseExpObjectTblIndex, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ExpObjectTblIndexDOSProvider },
	{ kEoBBaseExpObjectShpStart, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ExpObjectShpStartDOSProvider },
	{ kEoBBaseExpObjectTbl1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ExpObjectTbl1DOSProvider },
	{ kEoBBaseExpObjectTbl2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ExpObjectTbl2DOSProvider },
	{ kEoBBaseExpObjectTbl3, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ExpObjectTbl3DOSProvider },
	{ kEoBBaseExpObjectY, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ExpObjectYDOSProvider },
	{ kEoBBaseSparkDefSteps, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SparkDefStepsDOSProvider },
	{ kEoBBaseSparkDefSubSteps, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SparkDefSubStepsDOSProvider },
	{ kEoBBaseSparkDefShift, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SparkDefShiftDOSProvider },
	{ kEoBBaseSparkDefAdd, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SparkDefAddDOSProvider },
	{ kEoBBaseSparkDefX, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SparkDefXDOSProvider },
	{ kEoBBaseSparkDefY, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SparkDefYDOSProvider },
	{ kEoBBaseSparkOfFlags1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SparkOfFlags1DOSProvider },
	{ kEoBBaseSparkOfFlags2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SparkOfFlags2DOSProvider },
	{ kEoBBaseSparkOfShift, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SparkOfShiftDOSProvider },
	{ kEoBBaseSparkOfX, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SparkOfXDOSProvider },
	{ kEoBBaseSparkOfY, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SparkOfYDOSProvider },
	{ kEoBBaseSpellProperties, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SpellPropertiesDOSProvider },
	{ kEoBBaseMagicFlightProps, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1MagicFlightPropsDOSProvider },
	{ kEoBBaseTurnUndeadEffect, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1TurnUndeadEffectDOSProvider },
	{ kEoBBaseBurningHandsDest, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1BurningHandsDestDOSProvider },
	{ kEoBBaseConeOfColdDest1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ConeOfColdDest1DOSProvider },
	{ kEoBBaseConeOfColdDest2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ConeOfColdDest2DOSProvider },
	{ kEoBBaseConeOfColdDest3, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ConeOfColdDest3DOSProvider },
	{ kEoBBaseConeOfColdDest4, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ConeOfColdDest4DOSProvider },
	{ kEoBBaseConeOfColdGfxTbl, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ConeOfColdGfxTblDOSProvider },
	{ kRpgCommonDscDoorShapeIndex, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorShapeIndexDOSProvider },
	{ kEoBBaseWllFlagPreset, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1WllFlagPresetDOSProvider },
	{ kEoBBaseDscShapeCoords, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscShapeCoordsDOSProvider },
	{ kEoBBaseDscDoorScaleOffs, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleOffsDOSProvider },
	{ kEoBBaseDscDoorScaleMult1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult1DOSProvider },
	{ kEoBBaseDscDoorScaleMult2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult2DOSProvider },
	{ kEoBBaseDscDoorScaleMult3, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult3DOSProvider },
	{ kEoBBaseDscDoorScaleMult4, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult4DOSProvider },
	{ kEoBBaseDscDoorScaleMult5, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult5DOSProvider },
	{ kEoBBaseDscDoorScaleMult6, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult6DOSProvider },
	{ kEoBBaseDscDoorXE, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorXEDOSProvider },
	{ kEoBBaseDscDoorY1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorY1DOSProvider },
	{ kEoBBaseDscDoorY3, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorY3DOSProvider },
	{ kEoBBaseDscDoorY4, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorY4DOSProvider },
	{ kEoBBaseDscDoorY5, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorY5DOSProvider },
	{ kEoBBaseDscDoorY6, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorY6DOSProvider },
	{ kEoBBaseDscDoorY7, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorY7DOSProvider },
	{ kEoBBaseDscDoorCoordsExt, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorCoordsExtDOSProvider },
	{ kRpgCommonDscDoorFrameY1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorFrameY1DOSProvider },
	{ kRpgCommonDscDoorFrameY2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorFrameY2DOSProvider },
	{ kRpgCommonDscDoorFrameIndex1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorFrameIndex1DOSProvider },
	{ kRpgCommonDscDoorFrameIndex2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorFrameIndex2DOSProvider },
	{ kEoBBaseDscItemPosIndex, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscItemPosIndexDOSProvider },
	{ kEoBBaseDscItemShpX, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscItemShpXDOSProvider },
	{ kEoBBaseDscItemScaleIndex, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscItemScaleIndexDOSProvider },
	{ kEoBBaseDscItemTileIndex, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscItemTileIndexDOSProvider },
	{ kEoBBaseDscItemShapeMap, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscItemShapeMapDOSProvider },
	{ kEoBBaseDscTelptrShpCoords, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscTelptrShpCoordsDOSProvider },
	{ kEoBBasePortalSeqData, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1PortalSeqDataDOSProvider },
	{ kEoBBaseManDef, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ManDefDOSEnglishProvider },
	{ kEoBBaseManWord, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ManWordDOSEnglishProvider },
	{ kEoBBaseManPrompt, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ManPromptDOSEnglishProvider },
	{ kEoBBaseDscMonsterFrmOffsTbl1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscMonsterFrmOffsTbl1DOSProvider },
	{ kEoBBaseDscMonsterFrmOffsTbl2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscMonsterFrmOffsTbl2DOSProvider },
	{ kEoBBaseInvSlotX, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1InvSlotXDOSProvider },
	{ kEoBBaseInvSlotY, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1InvSlotYDOSProvider },
	{ kEoBBaseSlotValidationFlags, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SlotValidationFlagsDOSProvider },
	{ kEoBBaseProjectileWeaponTypes, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ProjectileWeaponTypesDOSProvider },
	{ kEoBBaseWandTypes, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1WandTypesDOSProvider },
	{ kEoBBaseDrawObjPosIndex, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DrawObjPosIndexDOSProvider },
	{ kEoBBaseFlightObjFlipIndex, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1FlightObjFlipIndexDOSProvider },
	{ kEoBBaseFlightObjShpMap, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1FlightObjShpMapDOSProvider },
	{ kEoBBaseFlightObjSclIndex, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1FlightObjSclIndexDOSProvider },
	{ kRpgCommonDscShapeIndex, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscShapeIndexDOSProvider },
	{ kRpgCommonDscX, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscXDOSProvider },
	{ kRpgCommonDscTileIndex, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscTileIndexDOSProvider },
	{ kRpgCommonDscUnk2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscUnk2DOSProvider },
	{ kRpgCommonDscDimData1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDimData1DOSProvider },
	{ kRpgCommonDscDimData2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDimData2DOSProvider },
	{ kRpgCommonDscBlockMap, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscBlockMapDOSProvider },
	{ kRpgCommonDscDimMap, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDimMapDOSProvider },
	{ kRpgCommonDscBlockIndex, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscBlockIndexDOSProvider },
	{ kEoBBaseClassModifierFlags, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ClassModifierFlagsDOSProvider },
	{ kEoBBaseMonsterStepTable01, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1MonsterStepTable01DOSProvider },
	{ kEoBBaseMonsterStepTable2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1MonsterStepTable2DOSProvider },
	{ kEoBBaseMonsterStepTable3, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1MonsterStepTable3DOSProvider },
	{ kEoBBaseMonsterCloseAttPosTable1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttPosTable1DOSProvider },
	{ kEoBBaseMonsterCloseAttPosTable21, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttPosTable21DOSProvider },
	{ kEoBBaseMonsterCloseAttChkTable1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttChkTable1DOSProvider },
	{ kEoBBaseMonsterCloseAttChkTable2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttChkTable2DOSProvider },
	{ kEoBBaseMonsterCloseAttDstTable1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttDstTable1DOSProvider },
	{ kEoBBaseMonsterCloseAttDstTable2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttDstTable2DOSProvider },
	{ kEoBBaseMonsterProximityTable, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1MonsterProximityTableDOSProvider },
	{ kEoBBaseFindBlockMonstersTable, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1FindBlockMonstersTableDOSProvider },
	{ kEoBBaseMonsterDirChangeTable, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1MonsterDirChangeTableDOSProvider },
	{ kEoBBaseMonsterDistAttStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MonsterDistAttStringsDOSEnglishProvider },
	{ kEoBBaseEncodeMonsterDefs, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1EncodeMonsterDefsDOSProvider },
	{ kEoBBaseNpcPresets, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1NpcPresetsDOSProvider },
	{ kEoBBaseChargenStrings1, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ChargenStrings1DOSGermanProvider },
	{ kEoBBaseChargenStrings2, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ChargenStrings2DOSGermanProvider },
	{ kEoBBaseChargenStatStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ChargenStatStringsDOSGermanProvider },
	{ kEoBBaseChargenRaceSexStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ChargenRaceSexStringsDOSGermanProvider },
	{ kEoBBaseChargenClassStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ChargenClassStringsDOSGermanProvider },
	{ kEoBBaseChargenAlignmentStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ChargenAlignmentStringsDOSGermanProvider },
	{ kEoBBaseChargenEnterGameStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ChargenEnterGameStringsDOSGermanProvider },
	{ kEoB1MainMenuStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MainMenuStringsDOSGermanProvider },
	{ kEoB1BonusStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1BonusStringsDOSGermanProvider },
	{ kEoB1TurnUndeadString, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1TurnUndeadStringDOSGermanProvider },
	{ kEoB1Npc0Strings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1Npc0StringsDOSGermanProvider },
	{ kEoB1Npc11Strings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1Npc11StringsDOSGermanProvider },
	{ kEoB1Npc12Strings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1Npc12StringsDOSGermanProvider },
	{ kEoB1Npc21Strings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1Npc21StringsDOSGermanProvider },
	{ kEoB1Npc22Strings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1Npc22StringsDOSGermanProvider },
	{ kEoB1Npc31Strings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1Npc31StringsDOSGermanProvider },
	{ kEoB1Npc32Strings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1Npc32StringsDOSGermanProvider },
	{ kEoB1Npc4Strings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1Npc4StringsDOSGermanProvider },
	{ kEoB1Npc5Strings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1Npc5StringsDOSGermanProvider },
	{ kEoB1Npc6Strings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1Npc6StringsDOSGermanProvider },
	{ kEoB1Npc7Strings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1Npc7StringsDOSGermanProvider },
	{ kEoBBasePryDoorStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1PryDoorStringsDOSGermanProvider },
	{ kEoBBaseWarningStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1WarningStringsDOSGermanProvider },
	{ kEoBBaseItemSuffixStringsRings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ItemSuffixStringsRingsDOSGermanProvider },
	{ kEoBBaseItemSuffixStringsPotions, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ItemSuffixStringsPotionsDOSGermanProvider },
	{ kEoBBaseItemSuffixStringsWands, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ItemSuffixStringsWandsDOSGermanProvider },
	{ kEoBBaseRipItemStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1RipItemStringsDOSGermanProvider },
	{ kEoBBaseCursedString, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1CursedStringDOSGermanProvider },
	{ kEoBBaseMagicObjectStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MagicObjectStringsDOSGermanProvider },
	{ kEoBBaseMagicObjectString5, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MagicObjectString5DOSGermanProvider },
	{ kEoBBasePatternSuffix, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1PatternSuffixDOSGermanProvider },
	{ kEoBBasePatternGrFix1, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1PatternGrFix1DOSGermanProvider },
	{ kEoBBasePatternGrFix2, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1PatternGrFix2DOSGermanProvider },
	{ kEoBBaseValidateArmorString, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ValidateArmorStringDOSGermanProvider },
	{ kEoBBaseValidateNoDropString, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ValidateNoDropStringDOSGermanProvider },
	{ kEoBBasePotionStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1PotionStringsDOSGermanProvider },
	{ kEoBBaseWandStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1WandStringsDOSGermanProvider },
	{ kEoBBaseItemMisuseStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ItemMisuseStringsDOSGermanProvider },
	{ kEoBBaseTakenStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1TakenStringsDOSGermanProvider },
	{ kEoBBasePotionEffectStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1PotionEffectStringsDOSGermanProvider },
	{ kEoBBaseYesNoStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1YesNoStringsDOSGermanProvider },
	{ kRpgCommonMoreStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MoreStringsDOSGermanProvider },
	{ kEoBBaseNpcMaxStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1NpcMaxStringsDOSGermanProvider },
	{ kEoBBaseNpcJoinStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1NpcJoinStringsDOSGermanProvider },
	{ kEoBBaseCancelStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1CancelStringsDOSGermanProvider },
	{ kEoBBaseMenuStringsMain, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsMainDOSGermanProvider },
	{ kEoBBaseMenuStringsSaveLoad, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsSaveLoadDOSGermanProvider },
	{ kEoBBaseMenuStringsOnOff, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsOnOffDOSGermanProvider },
	{ kEoBBaseMenuStringsSpells, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsSpellsDOSGermanProvider },
	{ kEoBBaseMenuStringsRest, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsRestDOSGermanProvider },
	{ kEoBBaseMenuStringsDrop, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsDropDOSGermanProvider },
	{ kEoBBaseMenuStringsExit, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsExitDOSGermanProvider },
	{ kEoBBaseMenuStringsStarve, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsStarveDOSGermanProvider },
	{ kEoBBaseMenuStringsScribe, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsScribeDOSGermanProvider },
	{ kEoBBaseMenuStringsDrop2, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsDrop2DOSGermanProvider },
	{ kEoBBaseMenuStringsHead, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsHeadDOSGermanProvider },
	{ kEoBBaseMenuStringsPoison, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsPoisonDOSGermanProvider },
	{ kEoBBaseMenuStringsMgc, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsMgcDOSGermanProvider },
	{ kEoBBaseMenuStringsPrefs, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsPrefsDOSGermanProvider },
	{ kEoBBaseMenuStringsRest2, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsRest2DOSGermanProvider },
	{ kEoBBaseMenuStringsRest4, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsRest4DOSGermanProvider },
	{ kEoBBaseMenuStringsDefeat, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsDefeatDOSGermanProvider },
	{ kEoBBaseMenuYesNoStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuYesNoStringsDOSGermanProvider },
	{ kEoBBaseCharGuiStringsHp, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1CharGuiStringsHpDOSGermanProvider },
	{ kEoBBaseCharGuiStringsWp1, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1CharGuiStringsWp1DOSGermanProvider },
	{ kEoBBaseCharGuiStringsWr, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1CharGuiStringsWrDOSGermanProvider },
	{ kEoBBaseCharGuiStringsSt1, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1CharGuiStringsSt1DOSGermanProvider },
	{ kEoBBaseCharGuiStringsIn, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1CharGuiStringsInDOSGermanProvider },
	{ kEoBBaseCharStatusStrings7, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1CharStatusStrings7DOSGermanProvider },
	{ kEoBBaseCharStatusStrings81, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1CharStatusStrings81DOSGermanProvider },
	{ kEoBBaseCharStatusStrings9, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1CharStatusStrings9DOSGermanProvider },
	{ kEoBBaseCharStatusStrings131, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1CharStatusStrings131DOSGermanProvider },
	{ kEoBBaseLevelGainStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1LevelGainStringsDOSGermanProvider },
	{ kEoBBaseBookNumbers, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1BookNumbersDOSGermanProvider },
	{ kEoBBaseMageSpellsList, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MageSpellsListDOSGermanProvider },
	{ kEoBBaseClericSpellsList, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ClericSpellsListDOSGermanProvider },
	{ kEoBBaseSpellNames, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1SpellNamesDOSGermanProvider },
	{ kEoBBaseMagicStrings1, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MagicStrings1DOSGermanProvider },
	{ kEoBBaseMagicStrings2, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MagicStrings2DOSGermanProvider },
	{ kEoBBaseMagicStrings3, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MagicStrings3DOSGermanProvider },
	{ kEoBBaseMagicStrings4, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MagicStrings4DOSGermanProvider },
	{ kEoBBaseMagicStrings6, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MagicStrings6DOSGermanProvider },
	{ kEoBBaseMagicStrings7, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MagicStrings7DOSGermanProvider },
	{ kEoBBaseMagicStrings8, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MagicStrings8DOSGermanProvider },
	{ kEoBBaseManDef, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ManDefDOSGermanProvider },
	{ kEoBBaseManWord, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ManWordDOSGermanProvider },
	{ kEoBBaseManPrompt, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ManPromptDOSGermanProvider },
	{ kEoBBaseMonsterDistAttStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MonsterDistAttStringsDOSGermanProvider },
	{ kEoBBaseChargenStrings1, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ChargenStrings1DOSItalianProvider },
	{ kEoBBaseChargenStrings2, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ChargenStrings2DOSItalianProvider },
	{ kEoBBaseChargenStatStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ChargenStatStringsDOSItalianProvider },
	{ kEoBBaseChargenRaceSexStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ChargenRaceSexStringsDOSItalianProvider },
	{ kEoBBaseChargenClassStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ChargenClassStringsDOSItalianProvider },
	{ kEoBBaseChargenAlignmentStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ChargenAlignmentStringsDOSItalianProvider },
	{ kEoBBaseChargenEnterGameStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ChargenEnterGameStringsDOSItalianProvider },
	{ kEoB1MainMenuStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MainMenuStringsDOSItalianProvider },
	{ kEoB1BonusStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1BonusStringsDOSItalianProvider },
	{ kEoB1TurnUndeadString, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1TurnUndeadStringDOSItalianProvider },
	{ kEoB1Npc0Strings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1Npc0StringsDOSItalianProvider },
	{ kEoB1Npc11Strings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1Npc11StringsDOSItalianProvider },
	{ kEoB1Npc12Strings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1Npc12StringsDOSItalianProvider },
	{ kEoB1Npc21Strings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1Npc21StringsDOSItalianProvider },
	{ kEoB1Npc22Strings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1Npc22StringsDOSItalianProvider },
	{ kEoB1Npc31Strings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1Npc31StringsDOSItalianProvider },
	{ kEoB1Npc32Strings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1Npc32StringsDOSItalianProvider },
	{ kEoB1Npc4Strings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1Npc4StringsDOSItalianProvider },
	{ kEoB1Npc5Strings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1Npc5StringsDOSItalianProvider },
	{ kEoB1Npc6Strings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1Npc6StringsDOSItalianProvider },
	{ kEoB1Npc7Strings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1Npc7StringsDOSItalianProvider },
	{ kEoBBasePryDoorStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1PryDoorStringsDOSItalianProvider },
	{ kEoBBaseWarningStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1WarningStringsDOSItalianProvider },
	{ kEoBBaseItemSuffixStringsRings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ItemSuffixStringsRingsDOSItalianProvider },
	{ kEoBBaseItemSuffixStringsPotions, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ItemSuffixStringsPotionsDOSItalianProvider },
	{ kEoBBaseItemSuffixStringsWands, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ItemSuffixStringsWandsDOSItalianProvider },
	{ kEoBBaseRipItemStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1RipItemStringsDOSItalianProvider },
	{ kEoBBaseCursedString, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1CursedStringDOSItalianProvider },
	{ kEoBBaseMagicObjectStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MagicObjectStringsDOSItalianProvider },
	{ kEoBBaseMagicObjectString5, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MagicObjectString5DOSItalianProvider },
	{ kEoBBasePatternSuffix, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1PatternSuffixDOSItalianProvider },
	{ kEoBBasePatternGrFix1, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1PatternGrFix1DOSItalianProvider },
	{ kEoBBasePatternGrFix2, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1PatternGrFix2DOSItalianProvider },
	{ kEoBBaseValidateArmorString, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ValidateArmorStringDOSItalianProvider },
	{ kEoBBaseValidateNoDropString, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ValidateNoDropStringDOSItalianProvider },
	{ kEoBBasePotionStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1PotionStringsDOSItalianProvider },
	{ kEoBBaseWandStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1WandStringsDOSItalianProvider },
	{ kEoBBaseItemMisuseStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ItemMisuseStringsDOSItalianProvider },
	{ kEoBBaseTakenStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1TakenStringsDOSItalianProvider },
	{ kEoBBasePotionEffectStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1PotionEffectStringsDOSItalianProvider },
	{ kEoBBaseYesNoStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1YesNoStringsDOSItalianProvider },
	{ kRpgCommonMoreStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MoreStringsDOSItalianProvider },
	{ kEoBBaseNpcMaxStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1NpcMaxStringsDOSItalianProvider },
	{ kEoBBaseNpcJoinStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1NpcJoinStringsDOSItalianProvider },
	{ kEoBBaseCancelStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1CancelStringsDOSItalianProvider },
	{ kEoBBaseMenuStringsMain, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsMainDOSItalianProvider },
	{ kEoBBaseMenuStringsSaveLoad, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsSaveLoadDOSItalianProvider },
	{ kEoBBaseMenuStringsOnOff, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsOnOffDOSItalianProvider },
	{ kEoBBaseMenuStringsSpells, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsSpellsDOSItalianProvider },
	{ kEoBBaseMenuStringsRest, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsRestDOSItalianProvider },
	{ kEoBBaseMenuStringsDrop, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsDropDOSItalianProvider },
	{ kEoBBaseMenuStringsExit, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsExitDOSItalianProvider },
	{ kEoBBaseMenuStringsStarve, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsStarveDOSItalianProvider },
	{ kEoBBaseMenuStringsScribe, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsScribeDOSItalianProvider },
	{ kEoBBaseMenuStringsDrop2, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsDrop2DOSItalianProvider },
	{ kEoBBaseMenuStringsHead, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsHeadDOSItalianProvider },
	{ kEoBBaseMenuStringsPoison, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsPoisonDOSItalianProvider },
	{ kEoBBaseMenuStringsMgc, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsMgcDOSItalianProvider },
	{ kEoBBaseMenuStringsPrefs, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsPrefsDOSItalianProvider },
	{ kEoBBaseMenuStringsRest2, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsRest2DOSItalianProvider },
	{ kEoBBaseMenuStringsRest4, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsRest4DOSItalianProvider },
	{ kEoBBaseMenuStringsDefeat, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsDefeatDOSItalianProvider },
	{ kEoBBaseMenuYesNoStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuYesNoStringsDOSItalianProvider },
	{ kEoBBaseCharGuiStringsHp, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1CharGuiStringsHpDOSItalianProvider },
	{ kEoBBaseCharGuiStringsWp1, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1CharGuiStringsWp1DOSItalianProvider },
	{ kEoBBaseCharGuiStringsWr, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1CharGuiStringsWrDOSItalianProvider },
	{ kEoBBaseCharGuiStringsSt1, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1CharGuiStringsSt1DOSItalianProvider },
	{ kEoBBaseCharGuiStringsIn, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1CharGuiStringsInDOSItalianProvider },
	{ kEoBBaseCharStatusStrings7, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1CharStatusStrings7DOSItalianProvider },
	{ kEoBBaseCharStatusStrings81, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1CharStatusStrings81DOSItalianProvider },
	{ kEoBBaseCharStatusStrings9, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1CharStatusStrings9DOSItalianProvider },
	{ kEoBBaseCharStatusStrings131, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1CharStatusStrings131DOSItalianProvider },
	{ kEoBBaseLevelGainStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1LevelGainStringsDOSItalianProvider },
	{ kEoBBaseBookNumbers, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1BookNumbersDOSItalianProvider },
	{ kEoBBaseMageSpellsList, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MageSpellsListDOSItalianProvider },
	{ kEoBBaseClericSpellsList, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ClericSpellsListDOSItalianProvider },
	{ kEoBBaseSpellNames, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1SpellNamesDOSItalianProvider },
	{ kEoBBaseMagicStrings1, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MagicStrings1DOSItalianProvider },
	{ kEoBBaseMagicStrings2, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MagicStrings2DOSItalianProvider },
	{ kEoBBaseMagicStrings3, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MagicStrings3DOSItalianProvider },
	{ kEoBBaseMagicStrings4, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MagicStrings4DOSItalianProvider },
	{ kEoBBaseMagicStrings6, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MagicStrings6DOSItalianProvider },
	{ kEoBBaseMagicStrings7, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MagicStrings7DOSItalianProvider },
	{ kEoBBaseMagicStrings8, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MagicStrings8DOSItalianProvider },
	{ kEoBBaseManDef, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ManDefDOSItalianProvider },
	{ kEoBBaseManWord, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ManWordDOSItalianProvider },
	{ kEoBBaseManPrompt, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ManPromptDOSItalianProvider },
	{ kEoBBaseMonsterDistAttStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MonsterDistAttStringsDOSItalianProvider },
	{ kEoBBaseChargenStrings1, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ChargenStrings1DOSEnglishProvider },
	{ kEoBBaseChargenStrings2, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ChargenStrings2DOSEnglishProvider },
	{ kEoBBaseChargenStartLevels, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ChargenStartLevelsDOSProvider },
	{ kEoBBaseChargenStatStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ChargenStatStringsDOSEnglishProvider },
	{ kEoBBaseChargenRaceSexStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ChargenRaceSexStringsDOSEnglishProvider },
	{ kEoBBaseChargenClassStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ChargenClassStringsDOSEnglishProvider },
	{ kEoBBaseChargenAlignmentStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ChargenAlignmentStringsDOSEnglishProvider },
	{ kEoBBaseChargenEnterGameStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ChargenEnterGameStringsDOSEnglishProvider },
	{ kEoBBaseChargenClassMinStats, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ChargenClassMinStatsDOSProvider },
	{ kEoBBaseChargenRaceMinStats, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ChargenRaceMinStatsDOSProvider },
	{ kEoBBaseChargenRaceMaxStats, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ChargenRaceMaxStatsDOSProvider },
	{ kEoBBaseSaveThrowTable1, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SaveThrowTable1DOSProvider },
	{ kEoBBaseSaveThrowTable2, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SaveThrowTable2DOSProvider },
	{ kEoBBaseSaveThrowTable3, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SaveThrowTable3DOSProvider },
	{ kEoBBaseSaveThrowTable4, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SaveThrowTable4DOSProvider },
	{ kEoBBaseSaveThrwLvlIndex, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SaveThrwLvlIndexDOSProvider },
	{ kEoBBaseSaveThrwModDiv, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SaveThrwModDivDOSProvider },
	{ kEoBBaseSaveThrwModExt, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SaveThrwModExtDOSProvider },
	{ kEoBBasePryDoorStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2PryDoorStringsDOSEnglishProvider },
	{ kEoBBaseWarningStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2WarningStringsDOSEnglishProvider },
	{ kEoBBaseItemSuffixStringsRings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ItemSuffixStringsRingsDOSEnglishProvider },
	{ kEoBBaseItemSuffixStringsPotions, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ItemSuffixStringsPotionsDOSEnglishProvider },
	{ kEoBBaseItemSuffixStringsWands, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ItemSuffixStringsWandsDOSEnglishProvider },
	{ kEoBBaseRipItemStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2RipItemStringsDOSEnglishProvider },
	{ kEoBBaseCursedString, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2CursedStringDOSEnglishProvider },
	{ kEoBBaseEnchantedString, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2EnchantedStringDOSProvider },
	{ kEoBBaseMagicObjectStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MagicObjectStringsDOSEnglishProvider },
	{ kEoBBaseMagicObjectString5, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MagicObjectString5DOSEnglishProvider },
	{ kEoBBasePatternSuffix, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2PatternSuffixDOSEnglishProvider },
	{ kEoBBasePatternGrFix1, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2PatternGrFix1DOSEnglishProvider },
	{ kEoBBasePatternGrFix2, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2PatternGrFix2DOSEnglishProvider },
	{ kEoBBaseValidateArmorString, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ValidateArmorStringDOSEnglishProvider },
	{ kEoBBaseValidateCursedString, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ValidateCursedStringDOSEnglishProvider },
	{ kEoBBaseValidateNoDropString, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ValidateNoDropStringDOSEnglishProvider },
	{ kEoBBasePotionStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2PotionStringsDOSEnglishProvider },
	{ kEoBBaseWandStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2WandStringsDOSEnglishProvider },
	{ kEoBBaseItemMisuseStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ItemMisuseStringsDOSEnglishProvider },
	{ kEoBBaseTakenStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2TakenStringsDOSEnglishProvider },
	{ kEoBBasePotionEffectStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2PotionEffectStringsDOSEnglishProvider },
	{ kEoBBaseYesNoStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2YesNoStringsDOSEnglishProvider },
	{ kRpgCommonMoreStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MoreStringsDOSEnglishProvider },
	{ kEoBBaseNpcMaxStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2NpcMaxStringsDOSEnglishProvider },
	{ kEoBBaseOkStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2OkStringsDOSEnglishProvider },
	{ kEoBBaseNpcJoinStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2NpcJoinStringsDOSEnglishProvider },
	{ kEoBBaseCancelStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2CancelStringsDOSEnglishProvider },
	{ kEoBBaseAbortStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2AbortStringsDOSEnglishProvider },
	{ kEoBBaseMenuStringsMain, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsMainDOSEnglishProvider },
	{ kEoBBaseMenuStringsSaveLoad, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsSaveLoadDOSEnglishProvider },
	{ kEoBBaseMenuStringsOnOff, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsOnOffDOSEnglishProvider },
	{ kEoBBaseMenuStringsSpells, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsSpellsDOSEnglishProvider },
	{ kEoBBaseMenuStringsRest, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsRestDOSEnglishProvider },
	{ kEoBBaseMenuStringsDrop, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsDropDOSEnglishProvider },
	{ kEoBBaseMenuStringsExit, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsExitDOSEnglishProvider },
	{ kEoBBaseMenuStringsStarve, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsStarveDOSEnglishProvider },
	{ kEoBBaseMenuStringsScribe, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsScribeDOSEnglishProvider },
	{ kEoBBaseMenuStringsDrop2, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsDrop2DOSEnglishProvider },
	{ kEoBBaseMenuStringsHead, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsHeadDOSEnglishProvider },
	{ kEoBBaseMenuStringsPoison, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsPoisonDOSEnglishProvider },
	{ kEoBBaseMenuStringsMgc, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsMgcDOSEnglishProvider },
	{ kEoBBaseMenuStringsPrefs, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsPrefsDOSEnglishProvider },
	{ kEoBBaseMenuStringsRest2, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsRest2DOSEnglishProvider },
	{ kEoBBaseMenuStringsRest3, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsRest3DOSEnglishProvider },
	{ kEoBBaseMenuStringsRest4, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsRest4DOSEnglishProvider },
	{ kEoBBaseMenuStringsDefeat, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsDefeatDOSEnglishProvider },
	{ kEoBBaseMenuStringsTransfer, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsTransferDOSEnglishProvider },
	{ kEoBBaseMenuStringsSpec, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsSpecDOSEnglishProvider },
	{ kEoBBaseMenuStringsSpellNo, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MenuStringsSpellNoDOSProvider },
	{ kEoBBaseMenuYesNoStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuYesNoStringsDOSEnglishProvider },
	{ kEoBBaseSpellLevelsMage, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SpellLevelsMageDOSProvider },
	{ kEoBBaseSpellLevelsCleric, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SpellLevelsClericDOSProvider },
	{ kEoBBaseNumSpellsCleric, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2NumSpellsClericDOSProvider },
	{ kEoBBaseNumSpellsWisAdj, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2NumSpellsWisAdjDOSProvider },
	{ kEoBBaseNumSpellsPal, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2NumSpellsPalDOSProvider },
	{ kEoBBaseNumSpellsMage, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2NumSpellsMageDOSProvider },
	{ kEoBBaseCharGuiStringsHp, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2CharGuiStringsHpDOSEnglishProvider },
	{ kEoBBaseCharGuiStringsWp2, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2CharGuiStringsWp2DOSEnglishProvider },
	{ kEoBBaseCharGuiStringsWr, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2CharGuiStringsWrDOSEnglishProvider },
	{ kEoBBaseCharGuiStringsSt2, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2CharGuiStringsSt2DOSEnglishProvider },
	{ kEoBBaseCharGuiStringsIn, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2CharGuiStringsInDOSEnglishProvider },
	{ kEoBBaseCharStatusStrings7, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2CharStatusStrings7DOSEnglishProvider },
	{ kEoBBaseCharStatusStrings82, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2CharStatusStrings82DOSEnglishProvider },
	{ kEoBBaseCharStatusStrings9, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2CharStatusStrings9DOSEnglishProvider },
	{ kEoBBaseCharStatusStrings12, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2CharStatusStrings12DOSEnglishProvider },
	{ kEoBBaseCharStatusStrings132, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2CharStatusStrings132DOSEnglishProvider },
	{ kEoBBaseLevelGainStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2LevelGainStringsDOSEnglishProvider },
	{ kEoBBaseExperienceTable0, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ExperienceTable0DOSProvider },
	{ kEoBBaseExperienceTable1, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ExperienceTable1DOSProvider },
	{ kEoBBaseExperienceTable2, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ExperienceTable2DOSProvider },
	{ kEoBBaseExperienceTable3, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ExperienceTable3DOSProvider },
	{ kEoBBaseExperienceTable4, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ExperienceTable4DOSProvider },
	{ kEoBBaseBookNumbers, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2BookNumbersDOSEnglishProvider },
	{ kEoBBaseMageSpellsList, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MageSpellsListDOSEnglishProvider },
	{ kEoBBaseClericSpellsList, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ClericSpellsListDOSEnglishProvider },
	{ kEoBBaseSpellNames, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2SpellNamesDOSEnglishProvider },
	{ kEoBBaseMagicStrings1, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MagicStrings1DOSEnglishProvider },
	{ kEoBBaseMagicStrings2, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MagicStrings2DOSEnglishProvider },
	{ kEoBBaseMagicStrings3, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MagicStrings3DOSEnglishProvider },
	{ kEoBBaseMagicStrings4, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MagicStrings4DOSEnglishProvider },
	{ kEoBBaseMagicStrings6, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MagicStrings6DOSEnglishProvider },
	{ kEoBBaseMagicStrings7, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MagicStrings7DOSEnglishProvider },
	{ kEoBBaseMagicStrings8, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MagicStrings8DOSEnglishProvider },
	{ kEoBBaseExpObjectTlMode, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ExpObjectTlModeDOSProvider },
	{ kEoBBaseExpObjectTblIndex, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ExpObjectTblIndexDOSProvider },
	{ kEoBBaseExpObjectShpStart, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ExpObjectShpStartDOSProvider },
	{ kEoBBaseExpObjectTbl1, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ExpObjectTbl1DOSProvider },
	{ kEoBBaseExpObjectTbl2, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ExpObjectTbl2DOSProvider },
	{ kEoBBaseExpObjectTbl3, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ExpObjectTbl3DOSProvider },
	{ kEoBBaseExpObjectY, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ExpObjectYDOSProvider },
	{ kEoBBaseSparkDefSteps, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SparkDefStepsDOSProvider },
	{ kEoBBaseSparkDefSubSteps, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SparkDefSubStepsDOSProvider },
	{ kEoBBaseSparkDefShift, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SparkDefShiftDOSProvider },
	{ kEoBBaseSparkDefAdd, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SparkDefAddDOSProvider },
	{ kEoBBaseSparkDefX, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SparkDefXDOSProvider },
	{ kEoBBaseSparkDefY, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SparkDefYDOSProvider },
	{ kEoBBaseSparkOfFlags1, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SparkOfFlags1DOSProvider },
	{ kEoBBaseSparkOfFlags2, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SparkOfFlags2DOSProvider },
	{ kEoBBaseSparkOfShift, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SparkOfShiftDOSProvider },
	{ kEoBBaseSparkOfX, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SparkOfXDOSProvider },
	{ kEoBBaseSparkOfY, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SparkOfYDOSProvider },
	{ kEoBBaseSpellProperties, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SpellPropertiesDOSProvider },
	{ kEoBBaseMagicFlightProps, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MagicFlightPropsDOSProvider },
	{ kEoBBaseTurnUndeadEffect, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2TurnUndeadEffectDOSProvider },
	{ kEoBBaseBurningHandsDest, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2BurningHandsDestDOSProvider },
	{ kEoBBaseConeOfColdDest1, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ConeOfColdDest1DOSProvider },
	{ kEoBBaseConeOfColdDest2, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ConeOfColdDest2DOSProvider },
	{ kEoBBaseConeOfColdDest3, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ConeOfColdDest3DOSProvider },
	{ kEoBBaseConeOfColdDest4, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ConeOfColdDest4DOSProvider },
	{ kEoBBaseConeOfColdGfxTbl, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ConeOfColdGfxTblDOSProvider },
	{ kRpgCommonDscDoorShapeIndex, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscDoorShapeIndexDOSProvider },
	{ kEoBBaseWllFlagPreset, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2WllFlagPresetDOSProvider },
	{ kEoBBaseDscShapeCoords, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscShapeCoordsDOSProvider },
	{ kEoBBaseDscDoorScaleOffs, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscDoorScaleOffsDOSProvider },
	{ kEoBBaseDscDoorScaleMult1, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscDoorScaleMult1DOSProvider },
	{ kEoBBaseDscDoorScaleMult2, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscDoorScaleMult2DOSProvider },
	{ kEoBBaseDscDoorScaleMult3, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscDoorScaleMult3DOSProvider },
	{ kEoBBaseDscDoorType5Offs, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscDoorType5OffsDOSProvider },
	{ kEoBBaseDscDoorY1, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscDoorY1DOSProvider },
	{ kRpgCommonDscDoorY2, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscDoorY2DOSProvider },
	{ kRpgCommonDscDoorFrameY1, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscDoorFrameY1DOSProvider },
	{ kRpgCommonDscDoorFrameY2, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscDoorFrameY2DOSProvider },
	{ kEoBBaseDscItemPosIndex, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscItemPosIndexDOSProvider },
	{ kEoBBaseDscItemShpX, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscItemShpXDOSProvider },
	{ kEoBBaseDscItemScaleIndex, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscItemScaleIndexDOSProvider },
	{ kEoBBaseDscItemTileIndex, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscItemTileIndexDOSProvider },
	{ kEoBBaseDscItemShapeMap, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscItemShapeMapDOSProvider },
	{ kEoBBaseDscTelptrShpCoords, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscTelptrShpCoordsDOSProvider },
	{ kEoBBasePortalSeqData, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2PortalSeqDataDOSProvider },
	{ kEoBBaseManDef, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ManDefDOSEnglishProvider },
	{ kEoBBaseManWord, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ManWordDOSEnglishProvider },
	{ kEoBBaseManPrompt, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ManPromptDOSEnglishProvider },
	{ kEoBBaseDscMonsterFrmOffsTbl1, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscMonsterFrmOffsTbl1DOSProvider },
	{ kEoBBaseDscMonsterFrmOffsTbl2, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscMonsterFrmOffsTbl2DOSProvider },
	{ kEoBBaseInvSlotX, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2InvSlotXDOSProvider },
	{ kEoBBaseInvSlotY, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2InvSlotYDOSProvider },
	{ kEoBBaseSlotValidationFlags, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SlotValidationFlagsDOSProvider },
	{ kEoBBaseProjectileWeaponTypes, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ProjectileWeaponTypesDOSProvider },
	{ kEoBBaseWandTypes, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2WandTypesDOSProvider },
	{ kEoBBaseDrawObjPosIndex, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DrawObjPosIndexDOSProvider },
	{ kEoBBaseFlightObjFlipIndex, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FlightObjFlipIndexDOSProvider },
	{ kEoBBaseFlightObjShpMap, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FlightObjShpMapDOSProvider },
	{ kEoBBaseFlightObjSclIndex, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FlightObjSclIndexDOSProvider },
	{ kEoB2MainMenuStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MainMenuStringsDOSEnglishProvider },
	{ kEoB2TransferPortraitFrames, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2TransferPortraitFramesDOSProvider },
	{ kEoB2TransferConvertTable, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2TransferConvertTableDOSProvider },
	{ kEoB2TransferItemTable, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2TransferItemTableDOSProvider },
	{ kEoB2TransferExpTable, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2TransferExpTableDOSProvider },
	{ kEoB2TransferStrings1, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2TransferStrings1DOSEnglishProvider },
	{ kEoB2TransferStrings2, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2TransferStrings2DOSEnglishProvider },
	{ kEoB2TransferLabels, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2TransferLabelsDOSEnglishProvider },
	{ kEoB2IntroStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2IntroStringsDOSEnglishProvider },
	{ kEoB2IntroCPSFiles, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2IntroCPSFilesDOSEnglishProvider },
	{ kEoB2IntroAnimData00, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData00DOSProvider },
	{ kEoB2IntroAnimData01, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData01DOSProvider },
	{ kEoB2IntroAnimData02, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData02DOSProvider },
	{ kEoB2IntroAnimData03, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData03DOSProvider },
	{ kEoB2IntroAnimData04, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData04DOSProvider },
	{ kEoB2IntroAnimData05, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData05DOSProvider },
	{ kEoB2IntroAnimData06, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData06DOSProvider },
	{ kEoB2IntroAnimData07, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData07DOSProvider },
	{ kEoB2IntroAnimData08, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData08DOSProvider },
	{ kEoB2IntroAnimData09, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData09DOSProvider },
	{ kEoB2IntroAnimData10, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData10DOSProvider },
	{ kEoB2IntroAnimData11, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData11DOSProvider },
	{ kEoB2IntroAnimData12, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData12DOSProvider },
	{ kEoB2IntroAnimData13, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData13DOSProvider },
	{ kEoB2IntroAnimData14, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData14DOSProvider },
	{ kEoB2IntroAnimData15, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData15DOSProvider },
	{ kEoB2IntroAnimData16, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData16DOSProvider },
	{ kEoB2IntroAnimData17, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData17DOSProvider },
	{ kEoB2IntroAnimData18, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData18DOSProvider },
	{ kEoB2IntroAnimData19, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData19DOSProvider },
	{ kEoB2IntroAnimData20, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData20DOSProvider },
	{ kEoB2IntroAnimData21, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData21DOSProvider },
	{ kEoB2IntroAnimData22, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData22DOSProvider },
	{ kEoB2IntroAnimData23, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData23DOSProvider },
	{ kEoB2IntroAnimData24, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData24DOSProvider },
	{ kEoB2IntroAnimData25, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData25DOSProvider },
	{ kEoB2IntroAnimData26, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData26DOSProvider },
	{ kEoB2IntroAnimData27, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData27DOSProvider },
	{ kEoB2IntroAnimData28, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData28DOSProvider },
	{ kEoB2IntroAnimData29, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData29DOSProvider },
	{ kEoB2IntroAnimData30, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData30DOSProvider },
	{ kEoB2IntroAnimData31, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData31DOSProvider },
	{ kEoB2IntroAnimData32, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData32DOSProvider },
	{ kEoB2IntroAnimData33, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData33DOSProvider },
	{ kEoB2IntroAnimData34, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData34DOSProvider },
	{ kEoB2IntroAnimData35, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData35DOSProvider },
	{ kEoB2IntroAnimData36, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData36DOSProvider },
	{ kEoB2IntroAnimData37, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData37DOSProvider },
	{ kEoB2IntroAnimData38, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData38DOSProvider },
	{ kEoB2IntroAnimData39, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData39DOSProvider },
	{ kEoB2IntroAnimData40, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData40DOSProvider },
	{ kEoB2IntroAnimData41, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData41DOSProvider },
	{ kEoB2IntroAnimData42, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData42DOSProvider },
	{ kEoB2IntroAnimData43, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData43DOSProvider },
	{ kEoB2IntroShapes00, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroShapes00DOSProvider },
	{ kEoB2IntroShapes01, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroShapes01DOSProvider },
	{ kEoB2IntroShapes04, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroShapes04DOSProvider },
	{ kEoB2IntroShapes07, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroShapes07DOSProvider },
	{ kEoB2FinaleStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2FinaleStringsDOSEnglishProvider },
	{ kEoB2CreditsData, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2CreditsDataDOSEnglishProvider },
	{ kEoB2FinaleCPSFiles, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2FinaleCPSFilesDOSEnglishProvider },
	{ kEoB2FinaleAnimData00, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData00DOSProvider },
	{ kEoB2FinaleAnimData01, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData01DOSProvider },
	{ kEoB2FinaleAnimData02, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData02DOSProvider },
	{ kEoB2FinaleAnimData03, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData03DOSProvider },
	{ kEoB2FinaleAnimData04, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData04DOSProvider },
	{ kEoB2FinaleAnimData05, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData05DOSProvider },
	{ kEoB2FinaleAnimData06, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData06DOSProvider },
	{ kEoB2FinaleAnimData07, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData07DOSProvider },
	{ kEoB2FinaleAnimData08, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData08DOSProvider },
	{ kEoB2FinaleAnimData09, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData09DOSProvider },
	{ kEoB2FinaleAnimData10, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData10DOSProvider },
	{ kEoB2FinaleAnimData11, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData11DOSProvider },
	{ kEoB2FinaleAnimData12, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData12DOSProvider },
	{ kEoB2FinaleAnimData13, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData13DOSProvider },
	{ kEoB2FinaleAnimData14, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData14DOSProvider },
	{ kEoB2FinaleAnimData15, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData15DOSProvider },
	{ kEoB2FinaleAnimData16, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData16DOSProvider },
	{ kEoB2FinaleAnimData17, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData17DOSProvider },
	{ kEoB2FinaleAnimData18, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData18DOSProvider },
	{ kEoB2FinaleAnimData19, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData19DOSProvider },
	{ kEoB2FinaleAnimData20, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData20DOSProvider },
	{ kEoB2FinaleShapes00, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleShapes00DOSProvider },
	{ kEoB2FinaleShapes03, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleShapes03DOSProvider },
	{ kEoB2FinaleShapes07, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleShapes07DOSProvider },
	{ kEoB2FinaleShapes09, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleShapes09DOSProvider },
	{ kEoB2FinaleShapes10, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleShapes10DOSProvider },
	{ kEoB2NpcShapeData, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2NpcShapeDataDOSProvider },
	{ kEoBBaseClassModifierFlags, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ClassModifierFlagsDOSProvider },
	{ kEoBBaseMonsterStepTable02, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MonsterStepTable02DOSProvider },
	{ kEoBBaseMonsterStepTable1, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MonsterStepTable1DOSProvider },
	{ kEoBBaseMonsterStepTable2, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MonsterStepTable2DOSProvider },
	{ kEoBBaseMonsterStepTable3, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MonsterStepTable3DOSProvider },
	{ kEoBBaseMonsterCloseAttPosTable1, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttPosTable1DOSProvider },
	{ kEoBBaseMonsterCloseAttPosTable22, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttPosTable22DOSProvider },
	{ kEoBBaseMonsterCloseAttUnkTable, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttUnkTableDOSProvider },
	{ kEoBBaseMonsterCloseAttChkTable1, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttChkTable1DOSProvider },
	{ kEoBBaseMonsterCloseAttChkTable2, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttChkTable2DOSProvider },
	{ kEoBBaseMonsterCloseAttDstTable1, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttDstTable1DOSProvider },
	{ kEoBBaseMonsterCloseAttDstTable2, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttDstTable2DOSProvider },
	{ kEoBBaseMonsterProximityTable, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MonsterProximityTableDOSProvider },
	{ kEoBBaseFindBlockMonstersTable, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FindBlockMonstersTableDOSProvider },
	{ kEoBBaseMonsterDirChangeTable, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MonsterDirChangeTableDOSProvider },
	{ kEoBBaseMonsterDistAttStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MonsterDistAttStringsDOSEnglishProvider },
	{ kEoBBaseEncodeMonsterDefs, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2EncodeMonsterDefsDOSProvider },
	{ kEoBBaseNpcPresets, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2NpcPresetsDOSProvider },
	{ kEoB2Npc1Strings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2Npc1StringsDOSEnglishProvider },
	{ kEoB2Npc2Strings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2Npc2StringsDOSEnglishProvider },
	{ kEoB2MonsterDustStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MonsterDustStringsDOSEnglishProvider },
	{ kEoB2DreamSteps, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DreamStepsDOSProvider },
	{ kEoB2KheldranStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2KheldranStringsDOSEnglishProvider },
	{ kEoB2HornStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2HornStringsDOSEnglishProvider },
	{ kEoB2HornSounds, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2HornSoundsDOSProvider },
	{ kEoB2WallOfForceDsX, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2WallOfForceDsXDOSProvider },
	{ kEoB2WallOfForceDsY, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2WallOfForceDsYDOSProvider },
	{ kEoB2WallOfForceNumW, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2WallOfForceNumWDOSProvider },
	{ kEoB2WallOfForceNumH, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2WallOfForceNumHDOSProvider },
	{ kEoB2WallOfForceShpId, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2WallOfForceShpIdDOSProvider },
	{ kRpgCommonDscShapeIndex, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscShapeIndexDOSProvider },
	{ kRpgCommonDscX, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscXDOSProvider },
	{ kRpgCommonDscTileIndex, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscTileIndexDOSProvider },
	{ kRpgCommonDscUnk2, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscUnk2DOSProvider },
	{ kRpgCommonDscDimData1, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscDimData1DOSProvider },
	{ kRpgCommonDscDimData2, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscDimData2DOSProvider },
	{ kRpgCommonDscBlockMap, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscBlockMapDOSProvider },
	{ kRpgCommonDscDimMap, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscDimMapDOSProvider },
	{ kRpgCommonDscBlockIndex, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscBlockIndexDOSProvider },
	{ kEoBBaseChargenStrings1, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ChargenStrings1DOSGermanProvider },
	{ kEoBBaseChargenStrings2, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ChargenStrings2DOSGermanProvider },
	{ kEoBBaseChargenStatStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ChargenStatStringsDOSGermanProvider },
	{ kEoBBaseChargenRaceSexStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ChargenRaceSexStringsDOSGermanProvider },
	{ kEoBBaseChargenClassStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ChargenClassStringsDOSGermanProvider },
	{ kEoBBaseChargenAlignmentStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ChargenAlignmentStringsDOSGermanProvider },
	{ kEoBBaseChargenEnterGameStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ChargenEnterGameStringsDOSGermanProvider },
	{ kEoBBasePryDoorStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2PryDoorStringsDOSGermanProvider },
	{ kEoBBaseWarningStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2WarningStringsDOSGermanProvider },
	{ kEoBBaseItemSuffixStringsRings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ItemSuffixStringsRingsDOSGermanProvider },
	{ kEoBBaseItemSuffixStringsPotions, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ItemSuffixStringsPotionsDOSGermanProvider },
	{ kEoBBaseItemSuffixStringsWands, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ItemSuffixStringsWandsDOSGermanProvider },
	{ kEoBBaseRipItemStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2RipItemStringsDOSGermanProvider },
	{ kEoBBaseCursedString, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2CursedStringDOSGermanProvider },
	{ kEoBBaseMagicObjectStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MagicObjectStringsDOSGermanProvider },
	{ kEoBBaseMagicObjectString5, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MagicObjectString5DOSGermanProvider },
	{ kEoBBasePatternSuffix, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2PatternSuffixDOSGermanProvider },
	{ kEoBBasePatternGrFix1, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2PatternGrFix1DOSGermanProvider },
	{ kEoBBasePatternGrFix2, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2PatternGrFix2DOSGermanProvider },
	{ kEoBBaseValidateArmorString, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ValidateArmorStringDOSGermanProvider },
	{ kEoBBaseValidateCursedString, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ValidateCursedStringDOSGermanProvider },
	{ kEoBBaseValidateNoDropString, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ValidateNoDropStringDOSGermanProvider },
	{ kEoBBasePotionStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2PotionStringsDOSGermanProvider },
	{ kEoBBaseWandStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2WandStringsDOSGermanProvider },
	{ kEoBBaseItemMisuseStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ItemMisuseStringsDOSGermanProvider },
	{ kEoBBaseTakenStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2TakenStringsDOSGermanProvider },
	{ kEoBBasePotionEffectStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2PotionEffectStringsDOSGermanProvider },
	{ kEoBBaseYesNoStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2YesNoStringsDOSGermanProvider },
	{ kRpgCommonMoreStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MoreStringsDOSGermanProvider },
	{ kEoBBaseNpcMaxStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2NpcMaxStringsDOSGermanProvider },
	{ kEoBBaseOkStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2OkStringsDOSGermanProvider },
	{ kEoBBaseNpcJoinStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2NpcJoinStringsDOSGermanProvider },
	{ kEoBBaseCancelStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2CancelStringsDOSGermanProvider },
	{ kEoBBaseAbortStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2AbortStringsDOSGermanProvider },
	{ kEoBBaseMenuStringsMain, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsMainDOSGermanProvider },
	{ kEoBBaseMenuStringsSaveLoad, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsSaveLoadDOSGermanProvider },
	{ kEoBBaseMenuStringsOnOff, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsOnOffDOSGermanProvider },
	{ kEoBBaseMenuStringsSpells, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsSpellsDOSGermanProvider },
	{ kEoBBaseMenuStringsRest, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsRestDOSGermanProvider },
	{ kEoBBaseMenuStringsDrop, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsDropDOSGermanProvider },
	{ kEoBBaseMenuStringsExit, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsExitDOSGermanProvider },
	{ kEoBBaseMenuStringsStarve, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsStarveDOSGermanProvider },
	{ kEoBBaseMenuStringsScribe, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsScribeDOSGermanProvider },
	{ kEoBBaseMenuStringsDrop2, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsDrop2DOSGermanProvider },
	{ kEoBBaseMenuStringsHead, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsHeadDOSGermanProvider },
	{ kEoBBaseMenuStringsPoison, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsPoisonDOSGermanProvider },
	{ kEoBBaseMenuStringsMgc, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsMgcDOSGermanProvider },
	{ kEoBBaseMenuStringsPrefs, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsPrefsDOSGermanProvider },
	{ kEoBBaseMenuStringsRest2, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsRest2DOSGermanProvider },
	{ kEoBBaseMenuStringsRest3, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsRest3DOSGermanProvider },
	{ kEoBBaseMenuStringsRest4, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsRest4DOSGermanProvider },
	{ kEoBBaseMenuStringsDefeat, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsDefeatDOSGermanProvider },
	{ kEoBBaseMenuStringsTransfer, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsTransferDOSGermanProvider },
	{ kEoBBaseMenuStringsSpec, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsSpecDOSGermanProvider },
	{ kEoBBaseMenuYesNoStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuYesNoStringsDOSGermanProvider },
	{ kEoBBaseCharGuiStringsHp, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2CharGuiStringsHpDOSGermanProvider },
	{ kEoBBaseCharGuiStringsWp2, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2CharGuiStringsWp2DOSGermanProvider },
	{ kEoBBaseCharGuiStringsWr, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2CharGuiStringsWrDOSGermanProvider },
	{ kEoBBaseCharGuiStringsSt2, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2CharGuiStringsSt2DOSGermanProvider },
	{ kEoBBaseCharGuiStringsIn, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2CharGuiStringsInDOSGermanProvider },
	{ kEoBBaseCharStatusStrings7, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2CharStatusStrings7DOSGermanProvider },
	{ kEoBBaseCharStatusStrings82, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2CharStatusStrings82DOSGermanProvider },
	{ kEoBBaseCharStatusStrings9, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2CharStatusStrings9DOSGermanProvider },
	{ kEoBBaseCharStatusStrings12, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2CharStatusStrings12DOSGermanProvider },
	{ kEoBBaseCharStatusStrings132, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2CharStatusStrings132DOSGermanProvider },
	{ kEoBBaseLevelGainStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2LevelGainStringsDOSGermanProvider },
	{ kEoBBaseBookNumbers, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2BookNumbersDOSGermanProvider },
	{ kEoBBaseMageSpellsList, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MageSpellsListDOSGermanProvider },
	{ kEoBBaseClericSpellsList, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ClericSpellsListDOSGermanProvider },
	{ kEoBBaseSpellNames, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2SpellNamesDOSGermanProvider },
	{ kEoBBaseMagicStrings1, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MagicStrings1DOSGermanProvider },
	{ kEoBBaseMagicStrings2, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MagicStrings2DOSGermanProvider },
	{ kEoBBaseMagicStrings3, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MagicStrings3DOSGermanProvider },
	{ kEoBBaseMagicStrings4, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MagicStrings4DOSGermanProvider },
	{ kEoBBaseMagicStrings6, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MagicStrings6DOSGermanProvider },
	{ kEoBBaseMagicStrings7, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MagicStrings7DOSGermanProvider },
	{ kEoBBaseMagicStrings8, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MagicStrings8DOSGermanProvider },
	{ kEoBBaseManDef, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ManDefDOSGermanProvider },
	{ kEoBBaseManWord, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ManWordDOSGermanProvider },
	{ kEoBBaseManPrompt, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ManPromptDOSGermanProvider },
	{ kEoB2MainMenuStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MainMenuStringsDOSGermanProvider },
	{ kEoB2TransferStrings1, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2TransferStrings1DOSGermanProvider },
	{ kEoB2TransferStrings2, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2TransferStrings2DOSGermanProvider },
	{ kEoB2TransferLabels, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2TransferLabelsDOSGermanProvider },
	{ kEoB2IntroStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2IntroStringsDOSGermanProvider },
	{ kEoB2IntroCPSFiles, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2IntroCPSFilesDOSGermanProvider },
	{ kEoB2FinaleStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2FinaleStringsDOSGermanProvider },
	{ kEoB2CreditsData, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2CreditsDataDOSGermanProvider },
	{ kEoB2FinaleCPSFiles, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2FinaleCPSFilesDOSGermanProvider },
	{ kEoBBaseMonsterDistAttStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MonsterDistAttStringsDOSGermanProvider },
	{ kEoB2Npc1Strings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2Npc1StringsDOSGermanProvider },
	{ kEoB2Npc2Strings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2Npc2StringsDOSGermanProvider },
	{ kEoB2MonsterDustStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MonsterDustStringsDOSGermanProvider },
	{ kEoB2KheldranStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2KheldranStringsDOSGermanProvider },
	{ kEoB2HornStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2HornStringsDOSGermanProvider },
	{ k2SeqplayPakFiles, kLoL, kPlatformDOS, kDemoVersion, UNK_LANG, &kLoLSeqplayPakFilesDOSDemoProvider },
	{ k2SeqplayStrings, kLoL, kPlatformDOS, kDemoVersion, EN_ANY, &kLoLSeqplayStringsDOSDemoEnglishProvider },
	{ k2SeqplaySeqData, kLoL, kPlatformDOS, kDemoVersion, UNK_LANG, &kLoLSeqplaySeqDataDOSDemoProvider },
	{ k2SeqplaySfxFiles, kLoL, kPlatformDOS, kDemoVersion, UNK_LANG, &kLoLSeqplaySfxFilesDOSDemoProvider },
	{ k2SeqplayIntroTracks, kLoL, kPlatformDOS, kDemoVersion, UNK_LANG, &kLoLSeqplayIntroTracksDOSDemoProvider },
	{ kLoLIngamePakFiles, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLIngamePakFilesDOSProvider },
	{ kLoLCharacterDefs, kLoL, kPlatformDOS, kNoSpecial, EN_ANY, &kLoLCharacterDefsDOSEnglishProvider },
	{ kLoLIngameSfxFiles, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLIngameSfxFilesDOSProvider },
	{ kLoLIngameSfxIndex, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLIngameSfxIndexDOSProvider },
	{ kLoLMusicTrackMap, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLMusicTrackMapDOSProvider },
	{ kLoLIngameGMSfxIndex, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLIngameGMSfxIndexDOSProvider },
	{ kLoLIngameMT32SfxIndex, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLIngameMT32SfxIndexDOSProvider },
	{ kLoLIngamePcSpkSfxIndex, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLIngamePcSpkSfxIndexDOSProvider },
	{ kLoLSpellProperties, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLSpellPropertiesDOSProvider },
	{ kLoLGameShapeMap, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLGameShapeMapDOSProvider },
	{ kLoLSceneItemOffs, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLSceneItemOffsDOSProvider },
	{ kLoLCharInvIndex, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLCharInvIndexDOSProvider },
	{ kLoLCharInvDefs, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLCharInvDefsDOSProvider },
	{ kLoLCharDefsMan, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLCharDefsManDOSProvider },
	{ kLoLCharDefsWoman, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLCharDefsWomanDOSProvider },
	{ kLoLCharDefsKieran, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLCharDefsKieranDOSProvider },
	{ kLoLCharDefsAkshel, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLCharDefsAkshelDOSProvider },
	{ kLoLExpRequirements, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLExpRequirementsDOSProvider },
	{ kLoLMonsterModifiers1, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLMonsterModifiers1DOSProvider },
	{ kLoLMonsterModifiers2, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLMonsterModifiers2DOSProvider },
	{ kLoLMonsterModifiers3, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLMonsterModifiers3DOSProvider },
	{ kLoLMonsterShiftOffsets, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLMonsterShiftOffsetsDOSProvider },
	{ kLoLMonsterDirFlags, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLMonsterDirFlagsDOSProvider },
	{ kLoLMonsterScaleY, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLMonsterScaleYDOSProvider },
	{ kLoLMonsterScaleX, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLMonsterScaleXDOSProvider },
	{ kLoLMonsterScaleWH, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLMonsterScaleWHDOSProvider },
	{ kLoLFlyingObjectShp, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLFlyingObjectShpDOSProvider },
	{ kLoLInventoryDesc, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLInventoryDescDOSProvider },
	{ kLoLLevelShpList, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLLevelShpListDOSProvider },
	{ kLoLLevelDatList, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLLevelDatListDOSProvider },
	{ kLoLCompassDefs, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLCompassDefsDOSProvider },
	{ kLoLStashSetup, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLStashSetupDOSProvider },
	{ kLoLDscWalls, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscWallsDOSProvider },
	{ kRpgCommonDscShapeIndex, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscShapeIndexDOSProvider },
	{ kLoLDscOvlMap, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscOvlMapDOSProvider },
	{ kLoLDscScaleWidthData, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscScaleWidthDataDOSProvider },
	{ kLoLDscScaleHeightData, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscScaleHeightDataDOSProvider },
	{ kRpgCommonDscX, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscXDOSProvider },
	{ kLoLBaseDscY, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLBaseDscYDOSProvider },
	{ kRpgCommonDscTileIndex, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscTileIndexDOSProvider },
	{ kRpgCommonDscUnk2, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscUnk2DOSProvider },
	{ kRpgCommonDscDoorShapeIndex, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscDoorShapeIndexDOSProvider },
	{ kRpgCommonDscDimData1, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscDimData1DOSProvider },
	{ kRpgCommonDscDimData2, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscDimData2DOSProvider },
	{ kRpgCommonDscBlockMap, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscBlockMapDOSProvider },
	{ kRpgCommonDscDimMap, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscDimMapDOSProvider },
	{ kLoLDscOvlIndex, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscOvlIndexDOSProvider },
	{ kRpgCommonDscBlockIndex, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscBlockIndexDOSProvider },
	{ kRpgCommonDscDoorY2, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscDoorY2DOSProvider },
	{ kRpgCommonDscDoorFrameY1, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscDoorFrameY1DOSProvider },
	{ kRpgCommonDscDoorFrameY2, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscDoorFrameY2DOSProvider },
	{ kLoLDscDoorScale, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscDoorScaleDOSProvider },
	{ kLoLDscDoor4, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscDoor4DOSProvider },
	{ kLoLDscDoorX, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscDoorXDOSProvider },
	{ kLoLDscDoorY, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscDoorYDOSProvider },
	{ kLoLScrollXTop, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLScrollXTopDOSProvider },
	{ kLoLScrollYTop, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLScrollYTopDOSProvider },
	{ kLoLScrollXBottom, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLScrollXBottomDOSProvider },
	{ kLoLScrollYBottom, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLScrollYBottomDOSProvider },
	{ kLoLButtonDefs, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLButtonDefsDOSProvider },
	{ kLoLButtonList1, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLButtonList1DOSProvider },
	{ kLoLButtonList2, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLButtonList2DOSProvider },
	{ kLoLButtonList3, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLButtonList3DOSProvider },
	{ kLoLButtonList4, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLButtonList4DOSProvider },
	{ kLoLButtonList5, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLButtonList5DOSProvider },
	{ kLoLButtonList6, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLButtonList6DOSProvider },
	{ kLoLButtonList7, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLButtonList7DOSProvider },
	{ kLoLButtonList8, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLButtonList8DOSProvider },
	{ kLoLLegendData, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLLegendDataDOSProvider },
	{ kLoLMapCursorOvl, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLMapCursorOvlDOSProvider },
	{ kLoLMapStringId, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLMapStringIdDOSProvider },
	{ kLoLSpellbookAnim, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLSpellbookAnimDOSProvider },
	{ kLoLSpellbookCoords, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLSpellbookCoordsDOSProvider },
	{ kLoLHealShapeFrames, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLHealShapeFramesDOSProvider },
	{ kLoLLightningDefs, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLLightningDefsDOSProvider },
	{ kLoLFireballCoords, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLFireballCoordsDOSProvider },
	{ kLoLCharacterDefs, kLoL, kPlatformDOS, kNoSpecial, RU_RUS, &kLoLCharacterDefsDOSRussianProvider },
	{ kLoLCharacterDefs, kLoL, kPlatformDOS, kNoSpecial, DE_DEU, &kLoLCharacterDefsDOSGermanProvider },
	{ kLoLCharacterDefs, kLoL, kPlatformDOS, kNoSpecial, FR_FRA, &kLoLCharacterDefsDOSFrenchProvider },
	{ kLoLIngamePakFiles, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLIngamePakFilesPC98Provider },
	{ kLoLCharacterDefs, kLoL, kPlatformPC98, kNoSpecial, JA_JPN, &kLoLCharacterDefsPC98JapaneseProvider },
	{ kLoLIngameSfxFiles, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLIngameSfxFilesPC98Provider },
	{ kLoLIngameSfxIndex, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLIngameSfxIndexPC98Provider },
	{ kLoLSpellProperties, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLSpellPropertiesPC98Provider },
	{ kLoLGameShapeMap, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLGameShapeMapPC98Provider },
	{ kLoLSceneItemOffs, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLSceneItemOffsPC98Provider },
	{ kLoLCharInvIndex, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLCharInvIndexPC98Provider },
	{ kLoLCharInvDefs, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLCharInvDefsPC98Provider },
	{ kLoLCharDefsMan, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLCharDefsManPC98Provider },
	{ kLoLCharDefsWoman, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLCharDefsWomanPC98Provider },
	{ kLoLCharDefsKieran, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLCharDefsKieranPC98Provider },
	{ kLoLCharDefsAkshel, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLCharDefsAkshelPC98Provider },
	{ kLoLExpRequirements, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLExpRequirementsPC98Provider },
	{ kLoLMonsterModifiers1, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLMonsterModifiers1PC98Provider },
	{ kLoLMonsterModifiers2, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLMonsterModifiers2PC98Provider },
	{ kLoLMonsterModifiers3, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLMonsterModifiers3PC98Provider },
	{ kLoLMonsterShiftOffsets, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLMonsterShiftOffsetsPC98Provider },
	{ kLoLMonsterDirFlags, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLMonsterDirFlagsPC98Provider },
	{ kLoLMonsterScaleY, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLMonsterScaleYPC98Provider },
	{ kLoLMonsterScaleX, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLMonsterScaleXPC98Provider },
	{ kLoLMonsterScaleWH, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLMonsterScaleWHPC98Provider },
	{ kLoLFlyingObjectShp, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLFlyingObjectShpPC98Provider },
	{ kLoLInventoryDesc, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLInventoryDescPC98Provider },
	{ kLoLLevelShpList, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLLevelShpListPC98Provider },
	{ kLoLLevelDatList, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLLevelDatListPC98Provider },
	{ kLoLCompassDefs, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLCompassDefsPC98Provider },
	{ kLoLStashSetup, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLStashSetupPC98Provider },
	{ kLoLDscWalls, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscWallsPC98Provider },
	{ kRpgCommonDscShapeIndex, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscShapeIndexPC98Provider },
	{ kLoLDscOvlMap, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscOvlMapPC98Provider },
	{ kLoLDscScaleWidthData, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscScaleWidthDataPC98Provider },
	{ kLoLDscScaleHeightData, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscScaleHeightDataPC98Provider },
	{ kRpgCommonDscX, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscXPC98Provider },
	{ kLoLBaseDscY, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLBaseDscYPC98Provider },
	{ kRpgCommonDscTileIndex, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscTileIndexPC98Provider },
	{ kRpgCommonDscUnk2, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscUnk2PC98Provider },
	{ kRpgCommonDscDoorShapeIndex, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscDoorShapeIndexPC98Provider },
	{ kRpgCommonDscDimData1, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscDimData1PC98Provider },
	{ kRpgCommonDscDimData2, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscDimData2PC98Provider },
	{ kRpgCommonDscBlockMap, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscBlockMapPC98Provider },
	{ kRpgCommonDscDimMap, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscDimMapPC98Provider },
	{ kLoLDscOvlIndex, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscOvlIndexPC98Provider },
	{ kRpgCommonDscBlockIndex, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscBlockIndexPC98Provider },
	{ kRpgCommonDscDoorY2, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscDoorY2PC98Provider },
	{ kRpgCommonDscDoorFrameY1, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscDoorFrameY1PC98Provider },
	{ kRpgCommonDscDoorFrameY2, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscDoorFrameY2PC98Provider },
	{ kLoLDscDoorScale, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscDoorScalePC98Provider },
	{ kLoLDscDoor4, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscDoor4PC98Provider },
	{ kLoLDscDoorX, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscDoorXPC98Provider },
	{ kLoLDscDoorY, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscDoorYPC98Provider },
	{ kLoLScrollXTop, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLScrollXTopPC98Provider },
	{ kLoLScrollYTop, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLScrollYTopPC98Provider },
	{ kLoLScrollXBottom, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLScrollXBottomPC98Provider },
	{ kLoLScrollYBottom, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLScrollYBottomPC98Provider },
	{ kLoLButtonDefs, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLButtonDefsPC98Provider },
	{ kLoLButtonList1, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLButtonList1PC98Provider },
	{ kLoLButtonList2, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLButtonList2PC98Provider },
	{ kLoLButtonList3, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLButtonList3PC98Provider },
	{ kLoLButtonList4, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLButtonList4PC98Provider },
	{ kLoLButtonList5, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLButtonList5PC98Provider },
	{ kLoLButtonList6, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLButtonList6PC98Provider },
	{ kLoLButtonList7, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLButtonList7PC98Provider },
	{ kLoLButtonList8, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLButtonList8PC98Provider },
	{ kLoLLegendData, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLLegendDataPC98Provider },
	{ kLoLMapStringId, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLMapStringIdPC98Provider },
	{ kLoLSpellbookAnim, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLSpellbookAnimPC98Provider },
	{ kLoLSpellbookCoords, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLSpellbookCoordsPC98Provider },
	{ kLoLHealShapeFrames, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLHealShapeFramesPC98Provider },
	{ kLoLLightningDefs, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLLightningDefsPC98Provider },
	{ kLoLFireballCoords, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLFireballCoordsPC98Provider },
	{ kLoLCredits, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLCreditsPC98Provider },
	{ kLoLIngamePakFiles, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLIngamePakFilesFMTownsProvider },
	{ kLoLCharacterDefs, kLoL, kPlatformFMTowns, kNoSpecial, JA_JPN, &kLoLCharacterDefsFMTownsJapaneseProvider },
	{ kLoLIngameSfxFiles, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLIngameSfxFilesFMTownsProvider },
	{ kLoLIngameSfxIndex, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLIngameSfxIndexFMTownsProvider },
	{ kLoLSpellProperties, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLSpellPropertiesFMTownsProvider },
	{ kLoLGameShapeMap, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLGameShapeMapFMTownsProvider },
	{ kLoLSceneItemOffs, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLSceneItemOffsFMTownsProvider },
	{ kLoLCharInvIndex, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLCharInvIndexFMTownsProvider },
	{ kLoLCharInvDefs, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLCharInvDefsFMTownsProvider },
	{ kLoLCharDefsMan, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLCharDefsManFMTownsProvider },
	{ kLoLCharDefsWoman, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLCharDefsWomanFMTownsProvider },
	{ kLoLCharDefsKieran, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLCharDefsKieranFMTownsProvider },
	{ kLoLCharDefsAkshel, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLCharDefsAkshelFMTownsProvider },
	{ kLoLExpRequirements, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLExpRequirementsFMTownsProvider },
	{ kLoLMonsterModifiers1, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLMonsterModifiers1FMTownsProvider },
	{ kLoLMonsterModifiers2, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLMonsterModifiers2FMTownsProvider },
	{ kLoLMonsterModifiers3, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLMonsterModifiers3FMTownsProvider },
	{ kLoLMonsterShiftOffsets, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLMonsterShiftOffsetsFMTownsProvider },
	{ kLoLMonsterDirFlags, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLMonsterDirFlagsFMTownsProvider },
	{ kLoLMonsterScaleY, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLMonsterScaleYFMTownsProvider },
	{ kLoLMonsterScaleX, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLMonsterScaleXFMTownsProvider },
	{ kLoLMonsterScaleWH, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLMonsterScaleWHFMTownsProvider },
	{ kLoLFlyingObjectShp, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLFlyingObjectShpFMTownsProvider },
	{ kLoLInventoryDesc, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLInventoryDescFMTownsProvider },
	{ kLoLLevelShpList, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLLevelShpListFMTownsProvider },
	{ kLoLLevelDatList, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLLevelDatListFMTownsProvider },
	{ kLoLCompassDefs, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLCompassDefsFMTownsProvider },
	{ kLoLStashSetup, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLStashSetupFMTownsProvider },
	{ kLoLDscWalls, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscWallsFMTownsProvider },
	{ kRpgCommonDscShapeIndex, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscShapeIndexFMTownsProvider },
	{ kLoLDscOvlMap, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscOvlMapFMTownsProvider },
	{ kLoLDscScaleWidthData, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscScaleWidthDataFMTownsProvider },
	{ kLoLDscScaleHeightData, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscScaleHeightDataFMTownsProvider },
	{ kRpgCommonDscX, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscXFMTownsProvider },
	{ kLoLBaseDscY, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLBaseDscYFMTownsProvider },
	{ kRpgCommonDscTileIndex, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscTileIndexFMTownsProvider },
	{ kRpgCommonDscUnk2, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscUnk2FMTownsProvider },
	{ kRpgCommonDscDoorShapeIndex, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscDoorShapeIndexFMTownsProvider },
	{ kRpgCommonDscDimData1, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscDimData1FMTownsProvider },
	{ kRpgCommonDscDimData2, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscDimData2FMTownsProvider },
	{ kRpgCommonDscBlockMap, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscBlockMapFMTownsProvider },
	{ kRpgCommonDscDimMap, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscDimMapFMTownsProvider },
	{ kLoLDscOvlIndex, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscOvlIndexFMTownsProvider },
	{ kRpgCommonDscBlockIndex, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscBlockIndexFMTownsProvider },
	{ kRpgCommonDscDoorY2, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscDoorY2FMTownsProvider },
	{ kRpgCommonDscDoorFrameY1, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscDoorFrameY1FMTownsProvider },
	{ kRpgCommonDscDoorFrameY2, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscDoorFrameY2FMTownsProvider },
	{ kLoLDscDoorScale, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscDoorScaleFMTownsProvider },
	{ kLoLDscDoor4, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscDoor4FMTownsProvider },
	{ kLoLDscDoorX, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscDoorXFMTownsProvider },
	{ kLoLDscDoorY, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscDoorYFMTownsProvider },
	{ kLoLScrollXTop, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLScrollXTopFMTownsProvider },
	{ kLoLScrollYTop, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLScrollYTopFMTownsProvider },
	{ kLoLScrollXBottom, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLScrollXBottomFMTownsProvider },
	{ kLoLScrollYBottom, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLScrollYBottomFMTownsProvider },
	{ kLoLButtonDefs, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLButtonDefsFMTownsProvider },
	{ kLoLButtonList1, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLButtonList1FMTownsProvider },
	{ kLoLButtonList2, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLButtonList2FMTownsProvider },
	{ kLoLButtonList3, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLButtonList3FMTownsProvider },
	{ kLoLButtonList4, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLButtonList4FMTownsProvider },
	{ kLoLButtonList5, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLButtonList5FMTownsProvider },
	{ kLoLButtonList6, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLButtonList6FMTownsProvider },
	{ kLoLButtonList7, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLButtonList7FMTownsProvider },
	{ kLoLButtonList8, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLButtonList8FMTownsProvider },
	{ kLoLLegendData, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLLegendDataFMTownsProvider },
	{ kLoLMapStringId, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLMapStringIdFMTownsProvider },
	{ kLoLSpellbookAnim, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLSpellbookAnimFMTownsProvider },
	{ kLoLSpellbookCoords, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLSpellbookCoordsFMTownsProvider },
	{ kLoLHealShapeFrames, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLHealShapeFramesFMTownsProvider },
	{ kLoLLightningDefs, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLLightningDefsFMTownsProvider },
	{ kLoLFireballCoords, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLFireballCoordsFMTownsProvider },
	{ kLoLCredits, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLCreditsFMTownsProvider },
	{ kLoLHistory, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLHistoryDOSCDProvider },
	{ kLoLCharacterDefs, kLoL, kPlatformDOS, kTalkieVersion, EN_ANY, &kLoLCharacterDefsDOSCDEnglishProvider },
	{ kLoLIngameSfxFiles, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLIngameSfxFilesDOSCDProvider },
	{ kLoLIngameSfxIndex, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLIngameSfxIndexDOSCDProvider },
	{ kLoLMusicTrackMap, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLMusicTrackMapDOSCDProvider },
	{ kLoLIngameGMSfxIndex, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLIngameGMSfxIndexDOSCDProvider },
	{ kLoLIngameMT32SfxIndex, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLIngameMT32SfxIndexDOSCDProvider },
	{ kLoLIngamePcSpkSfxIndex, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLIngamePcSpkSfxIndexDOSCDProvider },
	{ kLoLSpellProperties, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLSpellPropertiesDOSCDProvider },
	{ kLoLGameShapeMap, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLGameShapeMapDOSCDProvider },
	{ kLoLSceneItemOffs, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLSceneItemOffsDOSCDProvider },
	{ kLoLCharInvIndex, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLCharInvIndexDOSCDProvider },
	{ kLoLCharInvDefs, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLCharInvDefsDOSCDProvider },
	{ kLoLCharDefsMan, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLCharDefsManDOSCDProvider },
	{ kLoLCharDefsWoman, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLCharDefsWomanDOSCDProvider },
	{ kLoLCharDefsKieran, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLCharDefsKieranDOSCDProvider },
	{ kLoLCharDefsAkshel, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLCharDefsAkshelDOSCDProvider },
	{ kLoLExpRequirements, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLExpRequirementsDOSCDProvider },
	{ kLoLMonsterModifiers1, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLMonsterModifiers1DOSCDProvider },
	{ kLoLMonsterModifiers2, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLMonsterModifiers2DOSCDProvider },
	{ kLoLMonsterModifiers3, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLMonsterModifiers3DOSCDProvider },
	{ kLoLMonsterModifiers4, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLMonsterModifiers4DOSCDProvider },
	{ kLoLMonsterShiftOffsets, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLMonsterShiftOffsetsDOSCDProvider },
	{ kLoLMonsterDirFlags, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLMonsterDirFlagsDOSCDProvider },
	{ kLoLMonsterScaleY, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLMonsterScaleYDOSCDProvider },
	{ kLoLMonsterScaleX, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLMonsterScaleXDOSCDProvider },
	{ kLoLMonsterScaleWH, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLMonsterScaleWHDOSCDProvider },
	{ kLoLFlyingObjectShp, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLFlyingObjectShpDOSCDProvider },
	{ kLoLInventoryDesc, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLInventoryDescDOSCDProvider },
	{ kLoLLevelShpList, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLLevelShpListDOSCDProvider },
	{ kLoLLevelDatList, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLLevelDatListDOSCDProvider },
	{ kLoLCompassDefs, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLCompassDefsDOSCDProvider },
	{ kLoLItemPrices, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLItemPricesDOSCDProvider },
	{ kLoLStashSetup, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLStashSetupDOSCDProvider },
	{ kLoLDscWalls, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscWallsDOSCDProvider },
	{ kRpgCommonDscShapeIndex, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscShapeIndexDOSCDProvider },
	{ kLoLDscOvlMap, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscOvlMapDOSCDProvider },
	{ kLoLDscScaleWidthData, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscScaleWidthDataDOSCDProvider },
	{ kLoLDscScaleHeightData, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscScaleHeightDataDOSCDProvider },
	{ kRpgCommonDscX, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscXDOSCDProvider },
	{ kLoLBaseDscY, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLBaseDscYDOSCDProvider },
	{ kRpgCommonDscTileIndex, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscTileIndexDOSCDProvider },
	{ kRpgCommonDscUnk2, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscUnk2DOSCDProvider },
	{ kRpgCommonDscDoorShapeIndex, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscDoorShapeIndexDOSCDProvider },
	{ kRpgCommonDscDimData1, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscDimData1DOSCDProvider },
	{ kRpgCommonDscDimData2, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscDimData2DOSCDProvider },
	{ kRpgCommonDscBlockMap, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscBlockMapDOSCDProvider },
	{ kRpgCommonDscDimMap, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscDimMapDOSCDProvider },
	{ kLoLDscOvlIndex, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscOvlIndexDOSCDProvider },
	{ kRpgCommonDscBlockIndex, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscBlockIndexDOSCDProvider },
	{ kRpgCommonDscDoorY2, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscDoorY2DOSCDProvider },
	{ kRpgCommonDscDoorFrameY1, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscDoorFrameY1DOSCDProvider },
	{ kRpgCommonDscDoorFrameY2, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscDoorFrameY2DOSCDProvider },
	{ kLoLDscDoorScale, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscDoorScaleDOSCDProvider },
	{ kLoLDscDoor4, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscDoor4DOSCDProvider },
	{ kLoLDscDoorX, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscDoorXDOSCDProvider },
	{ kLoLDscDoorY, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscDoorYDOSCDProvider },
	{ kLoLScrollXTop, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLScrollXTopDOSCDProvider },
	{ kLoLScrollYTop, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLScrollYTopDOSCDProvider },
	{ kLoLScrollXBottom, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLScrollXBottomDOSCDProvider },
	{ kLoLScrollYBottom, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLScrollYBottomDOSCDProvider },
	{ kLoLButtonDefs, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLButtonDefsDOSCDProvider },
	{ kLoLButtonList1, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLButtonList1DOSCDProvider },
	{ kLoLButtonList2, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLButtonList2DOSCDProvider },
	{ kLoLButtonList3, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLButtonList3DOSCDProvider },
	{ kLoLButtonList4, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLButtonList4DOSCDProvider },
	{ kLoLButtonList5, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLButtonList5DOSCDProvider },
	{ kLoLButtonList6, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLButtonList6DOSCDProvider },
	{ kLoLButtonList7, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLButtonList7DOSCDProvider },
	{ kLoLButtonList8, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLButtonList8DOSCDProvider },
	{ kLoLLegendData, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLLegendDataDOSCDProvider },
	{ kLoLMapCursorOvl, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLMapCursorOvlDOSCDProvider },
	{ kLoLMapStringId, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLMapStringIdDOSCDProvider },
	{ kLoLSpellbookAnim, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLSpellbookAnimDOSCDProvider },
	{ kLoLSpellbookCoords, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLSpellbookCoordsDOSCDProvider },
	{ kLoLHealShapeFrames, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLHealShapeFramesDOSCDProvider },
	{ kLoLLightningDefs, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLLightningDefsDOSCDProvider },
	{ kLoLFireballCoords, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLFireballCoordsDOSCDProvider },
	{ kLoLCharacterDefs, kLoL, kPlatformDOS, kTalkieVersion, FR_FRA, &kLoLCharacterDefsDOSCDFrenchProvider },
	{ kLoLCharacterDefs, kLoL, kPlatformDOS, kTalkieVersion, DE_DEU, &kLoLCharacterDefsDOSCDGermanProvider },
	{ kLoLCharacterDefs, kLoL, kPlatformDOS, kTalkieVersion, IT_ITA, &kLoLCharacterDefsDOSCDItalianProvider },
	{ kLoLCharacterDefs, kLoL, kPlatformDOS, kTalkieVersion, RU_RUS, &kLoLCharacterDefsDOSCDRussianProvider },
	{ kMaxResIDs, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, NULL }
};

const ResourceProvider *obtainResourceProviders() {
	return resourceProviders;
}
