/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * $URL$
 * $Id$
 *
 */

#include "queen/resource.h"

namespace Queen {

//English Floppy Version
ResourceEntry Resource::_resourceTablePEM10[] = {
	{ "1000SSSS.SB", 1, 0x00000000, 0x000027fe },
	{ "1001SSSS.SB", 1, 0x000027fe, 0x00007af8 },
	{ "1002SSSS.SB", 1, 0x0000a2f6, 0x000049e2 },
	{ "1003SSSS.SB", 1, 0x0000ecd8, 0x00001d42 },
	{ "1004SSSS.SB", 1, 0x00010a1a, 0x00001a1c },
	{ "1005SSSS.SB", 1, 0x00012436, 0x00001a8a },
	{ "1006SSSS.SB", 1, 0x00013ec0, 0x00009d41 },
	{ "1007SSSS.SB", 1, 0x0001dc01, 0x00001372 },
	{ "1008SSSS.SB", 1, 0x0001ef73, 0x00002e4a },
	{ "1009SSSS.SB", 1, 0x00021dbd, 0x0000220c },
	{ "1010SSSS.SB", 1, 0x00023fc9, 0x00003b1e },
	{ "1011SSSS.SB", 1, 0x00027ae7, 0x00000dd8 },
	{ "1012SSSS.SB", 1, 0x000288bf, 0x0000444c },
	{ "1013SSSS.SB", 1, 0x0002cd0b, 0x00007e66 },
	{ "1014SSSS.SB", 1, 0x00034b71, 0x00006e14 },
	{ "1015SSSS.SB", 1, 0x0003b985, 0x0000760c },
	{ "1016SSSS.SB", 1, 0x00042f91, 0x00004f8b },
	{ "1017SSSS.SB", 1, 0x00047f1c, 0x00004848 },
	{ "1018SSSS.SB", 1, 0x0004c764, 0x00007e94 },
	{ "1019SSSS.SB", 1, 0x000545f8, 0x00003a70 },
	{ "101SSSSS.SB", 1, 0x00058068, 0x0000191a },
	{ "1020SSSS.SB", 1, 0x00059982, 0x00004d90 },
	{ "1021SSSS.SB", 1, 0x0005e712, 0x00003dcc },
	{ "1023SSSS.SB", 1, 0x000624de, 0x00003d7f },
	{ "1024SSSS.SB", 1, 0x0006625d, 0x00004f8a },
	{ "1025SSSS.SB", 1, 0x0006b1e7, 0x00006488 },
	{ "1026SSSS.SB", 1, 0x0007166f, 0x00002022 },
	{ "1027SSSS.SB", 1, 0x00073691, 0x00009e76 },
	{ "1028SSSS.SB", 1, 0x0007d507, 0x0001b37c },
	{ "1029SSSS.SB", 1, 0x00098883, 0x0000ce2c },
	{ "1030SSSS.SB", 1, 0x000a56af, 0x0001e6e4 },
	{ "1031SSSS.SB", 1, 0x000c3d93, 0x00011532 },
	{ "1032SSSS.SB", 1, 0x000d52c5, 0x000034d4 },
	{ "1033SSSS.SB", 1, 0x000d8799, 0x00002de6 },
	{ "1034SSSS.SB", 1, 0x000db57f, 0x000099a1 },
	{ "103ASSSS.SB", 1, 0x000e4f20, 0x00005040 },
	{ "103SSSSS.SB", 1, 0x000e9f60, 0x00006a94 },
	{ "105ASSSS.SB", 1, 0x000f09f4, 0x00001d04 },
	{ "105SSSSS.SB", 1, 0x000f26f8, 0x000024de },
	{ "106SSSSS.SB", 1, 0x000f4bd6, 0x00000ac4 },
	{ "109SSSSS.SB", 1, 0x000f569a, 0x00000d96 },
	{ "10SSSSSS.SB", 1, 0x000f6430, 0x000013f6 },
	{ "110SSSSS.SB", 1, 0x000f7826, 0x00000c96 },
	{ "111SSSSS.SB", 1, 0x000f84bc, 0x00000f72 },
	{ "112SSSSS.SB", 1, 0x000f942e, 0x00000f1a },
	{ "113SSSSS.SB", 1, 0x000fa348, 0x00003f5e },
	{ "114ASSSS.SB", 1, 0x000fe2a6, 0x00001e54 },
	{ "115SSSSS.SB", 1, 0x001000fa, 0x00002580 },
	{ "116BSSSS.SB", 1, 0x0010267a, 0x00002350 },
	{ "119SSSSS.SB", 1, 0x001049ca, 0x00003808 },
	{ "11SSSSSS.SB", 1, 0x001081d2, 0x0000157e },
	{ "120SSSSS.SB", 1, 0x00109750, 0x00002be4 },
	{ "121SSSSS.SB", 1, 0x0010c334, 0x00001340 },
	{ "122SSSSS.SB", 1, 0x0010d674, 0x0000173e },
	{ "123ASSSS.SB", 1, 0x0010edb2, 0x00009e9d },
	{ "123BSSSS.SB", 1, 0x00118c4f, 0x0000f613 },
	{ "125SSSSS.SB", 1, 0x00128262, 0x0000e628 },
	{ "126SSSSS.SB", 1, 0x0013688a, 0x0000372e },
	{ "127SSSSS.SB", 1, 0x00139fb8, 0x0000ff1e },
	{ "128SSSSS.SB", 1, 0x00149ed6, 0x00000e34 },
	{ "129SSSSS.SB", 1, 0x0014ad0a, 0x00000b02 },
	{ "130SSSSS.SB", 1, 0x0014b80c, 0x00000a10 },
	{ "131ASSSS.SB", 1, 0x0014c21c, 0x000022d4 },
	{ "132CSSSS.SB", 1, 0x0014e4f0, 0x000094c3 },
	{ "132SSSSS.SB", 1, 0x001579b3, 0x00006183 },
	{ "133SSSSS.SB", 1, 0x0015db36, 0x00006a13 },
	{ "134SSSSS.SB", 1, 0x00164549, 0x00004ea3 },
	{ "135SSSSS.SB", 1, 0x001693ec, 0x000017c8 },
	{ "136SSSSS.SB", 1, 0x0016abb4, 0x000004a0 },
	{ "137ASSSS.SB", 1, 0x0016b054, 0x00001826 },
	{ "137BSSSS.SB", 1, 0x0016c87a, 0x00001d46 },
	{ "138BSSSS.SB", 1, 0x0016e5c0, 0x000065f9 },
	{ "138SSSSS.SB", 1, 0x00174bb9, 0x000053c3 },
	{ "13SSSSSS.SB", 1, 0x00179f7c, 0x00001f32 },
	{ "14SSSSSS.SB", 1, 0x0017beae, 0x00004921 },
	{ "15SSSSSS.SB", 1, 0x001807cf, 0x000007aa },
	{ "17SSSSSS.SB", 1, 0x00180f79, 0x00005080 },
	{ "18SSSSSS.SB", 1, 0x00185ff9, 0x000015e2 },
	{ "21CSSSSS.SB", 1, 0x001875db, 0x000048ec },
	{ "21SSSSSS.SB", 1, 0x0018bec7, 0x0000bb40 },
	{ "24SSSSSS.SB", 1, 0x00197a07, 0x000023fc },
	{ "25SSSSSS.SB", 1, 0x00199e03, 0x000016d8 },
	{ "26SSSSSS.SB", 1, 0x0019b4db, 0x000049dd },
	{ "27SSSSSS.SB", 1, 0x0019feb8, 0x000010a0 },
	{ "29SSSSSS.SB", 1, 0x001a0f58, 0x00004e50 },
	{ "33SSSSSS.SB", 1, 0x001a5da8, 0x00005218 },
	{ "35SSSSSS.SB", 1, 0x001aafc0, 0x00002c6c },
	{ "36SSSSSS.SB", 1, 0x001adc2c, 0x000031d2 },
	{ "37SSSSSS.SB", 1, 0x001b0dfe, 0x0000197a },
	{ "38SSSSSS.SB", 1, 0x001b2778, 0x00002162 },
	{ "3SSSSSSS.SB", 1, 0x001b48da, 0x00000d04 },
	{ "40SSSSSS.SB", 1, 0x001b55de, 0x00000268 },
	{ "41BSSSSS.SB", 1, 0x001b5846, 0x000005fe },
	{ "42BSSSSS.SB", 1, 0x001b5e44, 0x00000308 },
	{ "44SSSSSS.SB", 1, 0x001b614c, 0x000052c0 },
	{ "48SSSSSS.SB", 1, 0x001bb40c, 0x000010a8 },
	{ "49SSSSSS.SB", 1, 0x001bc4b4, 0x00001dd4 },
	{ "4SSSSSSS.SB", 1, 0x001be288, 0x000009d2 },
	{ "50SSSSSS.SB", 1, 0x001bec5a, 0x00003f8a },
	{ "51SSSSSS.SB", 1, 0x001c2be4, 0x000015da },
	{ "52SSSSSS.SB", 1, 0x001c41be, 0x0000125a },
	{ "55BSSSSS.SB", 1, 0x001c5418, 0x00003d7f },
	{ "55SSSSSS.SB", 1, 0x001c9197, 0x00004508 },
	{ "56SSSSSS.SB", 1, 0x001cd69f, 0x0000520b },
	{ "58SSSSSS.SB", 1, 0x001d28aa, 0x00003399 },
	{ "59SSSSSS.SB", 1, 0x001d5c43, 0x000032b8 },
	{ "5SSSSSSS.SB", 1, 0x001d8efb, 0x00004ae9 },
	{ "60BSSSSS.SB", 1, 0x001dd9e4, 0x000050f2 },
	{ "60SSSSSS.SB", 1, 0x001e2ad6, 0x00003c57 },
	{ "61SSSSSS.SB", 1, 0x001e672d, 0x0000513d },
	{ "64SSSSSS.SB", 1, 0x001eb86a, 0x00005a98 },
	{ "68SSSSSS.SB", 1, 0x001f1302, 0x00003e85 },
	{ "6SSSSSSS.SB", 1, 0x001f5187, 0x00001650 },
	{ "70SSSSSS.SB", 1, 0x001f67d7, 0x00009645 },
	{ "71SSSSSS.SB", 1, 0x001ffe1c, 0x00000fa3 },
	{ "73ASSSSS.SB", 1, 0x00200dbf, 0x00008812 },
	{ "73SSSSSS.SB", 1, 0x002095d1, 0x00006706 },
	{ "74ASSSSS.SB", 1, 0x0020fcd7, 0x000029b2 },
	{ "75SSSSSS.SB", 1, 0x00212689, 0x00000920 },
	{ "76SSSSSS.SB", 1, 0x00212fa9, 0x00004ef8 },
	{ "77SSSSSS.SB", 1, 0x00217ea1, 0x00003358 },
	{ "79SSSSSS.SB", 1, 0x0021b1f9, 0x000016a8 },
	{ "7SSSSSSS.SB", 1, 0x0021c8a1, 0x000010d4 },
	{ "80SSSSSS.SB", 1, 0x0021d975, 0x0000441e },
	{ "81SSSSSS.SB", 1, 0x00221d93, 0x0000517f },
	{ "83SSSSSS.SB", 1, 0x00226f12, 0x000043e3 },
	{ "84SSSSSS.SB", 1, 0x0022b2f5, 0x00003baa },
	{ "85SSSSSS.SB", 1, 0x0022ee9f, 0x00004470 },
	{ "87SSSSSS.SB", 1, 0x0023330f, 0x00005113 },
	{ "88SSSSSS.SB", 1, 0x00238422, 0x00005275 },
	{ "89SSSSSS.SB", 1, 0x0023d697, 0x00001a69 },
	{ "93SSSSSS.SB", 1, 0x0023f100, 0x00000470 },
	{ "94SSSSSS.SB", 1, 0x0023f570, 0x000051e4 },
	{ "95SSSSSS.SB", 1, 0x00244754, 0x0000343b },
	{ "96SSSSSS.SB", 1, 0x00247b8f, 0x00005110 },
	{ "97SSSSSS.SB", 1, 0x0024cc9f, 0x00004972 },
	{ "AMAZON.ACT", 1, 0x00251611, 0x0000a97a },
	{ "AND1.DOG", 1, 0x0025bf8b, 0x000009ca },
	{ "ANDERSON.ACT", 1, 0x0025c955, 0x00007c0a },
	{ "ANDSON2.ACT", 1, 0x0026455f, 0x00007c0a },
	{ "ANDSON_E.ACT", 1, 0x0026c169, 0x00003c42 },
	{ "APE.ACT", 1, 0x0026fdab, 0x000084cd },
	{ "APE.DOG", 1, 0x00278278, 0x000011d4 },
	{ "APE2.DOG", 1, 0x0027944c, 0x000008da },
	{ "APE3.DOG", 1, 0x00279d26, 0x00000788 },
	{ "AQ.RL", 1, 0x0027a4ae, 0x00063f3a },
	{ "AQ8.RL", 1, 0x002de3e8, 0x000167f8 },
	{ "AQB2.MUS", 1, 0x002f4be0, 0x00039972 },
	{ "AQBANK.MUS", 1, 0x0032e552, 0x0004fe89 },
	{ "AQBANK.RL", 1, 0x0037e3db, 0x000059e9 },
	{ "AZURA_E.ACT", 1, 0x00383dc4, 0x0000425a },
	{ "AZURA_H.ACT", 1, 0x0038801e, 0x00008a7a },
	{ "AZURA_H.BBK", 1, 0x00390a98, 0x0001a712 },
	{ "AZURA_H.PCX", 1, 0x003ab1aa, 0x0000accb },
	{ "B1.BBK", 1, 0x003b5e75, 0x000051fb },
	{ "B1.LUM", 1, 0x003bb070, 0x00000018 },
	{ "B1.MSK", 1, 0x003bb088, 0x00001f40 },
	{ "B1.PCX", 1, 0x003bcfc8, 0x000162a8 },
	{ "B2.BBK", 1, 0x003d3270, 0x000034b1 },
	{ "B2.LUM", 1, 0x003d6721, 0x00000018 },
	{ "B2.MSK", 1, 0x003d6739, 0x00001f40 },
	{ "B2.PCX", 1, 0x003d8679, 0x0000a521 },
	{ "BAT.SAM", 1, 0x003e2b9a, 0x00009d9a },
	{ "BEETLE.ACT", 1, 0x003ec934, 0x00001e42 },
	{ "BIGAM.ACT", 1, 0x003ee776, 0x00002d12 },
	{ "BLANK000.SB", 1, 0x003f1488, 0x00000076 },
	{ "BLUEP.CUT", 1, 0x003f14fe, 0x00000148 },
	{ "BOB1.DOG", 1, 0x003f1646, 0x000010bc },
	{ "BOB2.DOG", 1, 0x003f2702, 0x00000e5a },
	{ "BOB3.DOG", 1, 0x003f355c, 0x00000df8 },
	{ "BOB4.DOG", 1, 0x003f4354, 0x00000dea },
	{ "BOB5.DOG", 1, 0x003f513e, 0x00000bf0 },
	{ "BUD.ACT", 1, 0x003f5d2e, 0x00006582 },
	{ "BUD1.DOG", 1, 0x003fc2b0, 0x0000129c },
	{ "BUD2.DOG", 1, 0x003fd54c, 0x00000c0e },
	{ "C1.BBK", 1, 0x003fe15a, 0x000026fd },
	{ "C1.LUM", 1, 0x00400857, 0x00000018 },
	{ "C1.MSK", 1, 0x0040086f, 0x00001f40 },
	{ "C1.PCX", 1, 0x004027af, 0x00004888 },
	{ "C10.BBK", 1, 0x00407037, 0x0003949f },
	{ "C10.PCX", 1, 0x004404d6, 0x0000e6fd },
	{ "C100A.CUT", 1, 0x0044ebd3, 0x000003be },
	{ "C100B.CUT", 1, 0x0044ef91, 0x00000346 },
	{ "C100C.CUT", 1, 0x0044f2d7, 0x0000019a },
	{ "C100D.CUT", 1, 0x0044f471, 0x00000774 },
	{ "C101A.CUT", 1, 0x0044fbe5, 0x0000021a },
	{ "C101B.CUT", 1, 0x0044fdff, 0x000000e6 },
	{ "C101C.CUT", 1, 0x0044fee5, 0x00000200 },
	{ "C101D.CUT", 1, 0x004500e5, 0x00000144 },
	{ "C101E.CUT", 1, 0x00450229, 0x00000144 },
	{ "C102A.CUT", 1, 0x0045036d, 0x0000040e },
	{ "C102B.CUT", 1, 0x0045077b, 0x0000040e },
	{ "C102C.CUT", 1, 0x00450b89, 0x0000047e },
	{ "C102D.CUT", 1, 0x00451007, 0x000003b8 },
	{ "C102E.CUT", 1, 0x004513bf, 0x0000037e },
	{ "C103A.CUT", 1, 0x0045173d, 0x000000b4 },
	{ "C103B.CUT", 1, 0x004517f1, 0x00000104 },
	{ "C103C.CUT", 1, 0x004518f5, 0x00000090 },
	{ "C103D.CUT", 1, 0x00451985, 0x00000070 },
	{ "C103E.CUT", 1, 0x004519f5, 0x000000da },
	{ "C103F.CUT", 1, 0x00451acf, 0x0000084a },
	{ "C103G.CUT", 1, 0x00452319, 0x0000068e },
	{ "C103H.CUT", 1, 0x004529a7, 0x000003be },
	{ "C103I.CUT", 1, 0x00452d65, 0x000001f2 },
	{ "C103J.CUT", 1, 0x00452f57, 0x0000041c },
	{ "C103K.CUT", 1, 0x00453373, 0x0000016a },
	{ "C103L.CUT", 1, 0x004534dd, 0x00000458 },
	{ "C11.BBK", 1, 0x00453935, 0x0000bf94 },
	{ "C11.PCX", 1, 0x0045f8c9, 0x0000c01a },
	{ "C11A.CUT", 1, 0x0046b8e3, 0x00000346 },
	{ "C12A.CUT", 1, 0x0046bc29, 0x000004d0 },
	{ "C13A.CUT", 1, 0x0046c0f9, 0x00000164 },
	{ "C13B.CUT", 1, 0x0046c25d, 0x0000016c },
	{ "C13C.CUT", 1, 0x0046c3c9, 0x000001fa },
	{ "C13D.CUT", 1, 0x0046c5c3, 0x00000174 },
	{ "C13E.CUT", 1, 0x0046c737, 0x000001d0 },
	{ "C13F.CUT", 1, 0x0046c907, 0x000002d6 },
	{ "C13G.CUT", 1, 0x0046cbdd, 0x00000152 },
	{ "C13H.CUT", 1, 0x0046cd2f, 0x00000116 },
	{ "C13I.CUT", 1, 0x0046ce45, 0x00000080 },
	{ "C13J.CUT", 1, 0x0046cec5, 0x00000272 },
	{ "C13K.CUT", 1, 0x0046d137, 0x00000192 },
	{ "C13L.CUT", 1, 0x0046d2c9, 0x000001dc },
	{ "C13M.CUT", 1, 0x0046d4a5, 0x00000468 },
	{ "C13N.CUT", 1, 0x0046d90d, 0x0000015e },
	{ "C14A.CUT", 1, 0x0046da6b, 0x000002fe },
	{ "C14B.CUT", 1, 0x0046dd69, 0x00000126 },
	{ "C14C.CUT", 1, 0x0046de8f, 0x00000150 },
	{ "C14D.CUT", 1, 0x0046dfdf, 0x00000108 },
	{ "C15A.CUT", 1, 0x0046e0e7, 0x00000264 },
	{ "C15B.CUT", 1, 0x0046e34b, 0x00000136 },
	{ "C15C.CUT", 1, 0x0046e481, 0x00000380 },
	{ "C15D.CUT", 1, 0x0046e801, 0x000002d2 },
	{ "C15E.CUT", 1, 0x0046ead3, 0x000000f4 },
	{ "C16A.CUT", 1, 0x0046ebc7, 0x000005d6 },
	{ "C16B.CUT", 1, 0x0046f19d, 0x0000057e },
	{ "C17A.CUT", 1, 0x0046f71b, 0x00000156 },
	{ "C18A.CUT", 1, 0x0046f871, 0x00000a60 },
	{ "C18B.CUT", 1, 0x004702d1, 0x000012b8 },
	{ "C18C.CUT", 1, 0x00471589, 0x00001202 },
	{ "C18D.CUT", 1, 0x0047278b, 0x000009fa },
	{ "C18E.CUT", 1, 0x00473185, 0x000009e4 },
	{ "C19A.CUT", 1, 0x00473b69, 0x00001076 },
	{ "C19B.CUT", 1, 0x00474bdf, 0x0000015c },
	{ "C1A.CUT", 1, 0x00474d3b, 0x0000034e },
	{ "C2.BBK", 1, 0x00475089, 0x00005908 },
	{ "C2.LUM", 1, 0x0047a991, 0x00000018 },
	{ "C2.MSK", 1, 0x0047a9a9, 0x00001f40 },
	{ "C2.PCX", 1, 0x0047c8e9, 0x00007f3a },
	{ "C2.SAM", 1, 0x00484823, 0x000147ac },
	{ "C20A.CUT", 1, 0x00498fcf, 0x00000500 },
	{ "C20B.CUT", 1, 0x004994cf, 0x00000168 },
	{ "C20C.CUT", 1, 0x00499637, 0x00000170 },
	{ "C20D.CUT", 1, 0x004997a7, 0x00000388 },
	{ "C20E.CUT", 1, 0x00499b2f, 0x00000394 },
	{ "C20F.CUT", 1, 0x00499ec3, 0x0000073a },
	{ "C20G.CUT", 1, 0x0049a5fd, 0x0000029c },
	{ "C21A.CUT", 1, 0x0049a899, 0x000000da },
	{ "C21B.CUT", 1, 0x0049a973, 0x000000ee },
	{ "C21C.CUT", 1, 0x0049aa61, 0x0000025e },
	{ "C21D.CUT", 1, 0x0049acbf, 0x000002ec },
	{ "C21E.CUT", 1, 0x0049afab, 0x00000602 },
	{ "C21F.CUT", 1, 0x0049b5ad, 0x000003e2 },
	{ "C21G.CUT", 1, 0x0049b98f, 0x00000136 },
	{ "C21H.CUT", 1, 0x0049bac5, 0x00000172 },
	{ "C21I.CUT", 1, 0x0049bc37, 0x0000024c },
	{ "C21J.CUT", 1, 0x0049be83, 0x00000122 },
	{ "C21K.CUT", 1, 0x0049bfa5, 0x00000584 },
	{ "C21L.CUT", 1, 0x0049c529, 0x00000522 },
	{ "C21M.CUT", 1, 0x0049ca4b, 0x000001ea },
	{ "C21N.CUT", 1, 0x0049cc35, 0x00000610 },
	{ "C21O.CUT", 1, 0x0049d245, 0x000000f4 },
	{ "C21P.CUT", 1, 0x0049d339, 0x00000150 },
	{ "C21Q.CUT", 1, 0x0049d489, 0x000002ec },
	{ "C21R.CUT", 1, 0x0049d775, 0x00000106 },
	{ "C21S.CUT", 1, 0x0049d87b, 0x0000012a },
	{ "C21T.CUT", 1, 0x0049d9a5, 0x0000015e },
	{ "C21U.CUT", 1, 0x0049db03, 0x000000c6 },
	{ "C22A.CUT", 1, 0x0049dbc9, 0x00000156 },
	{ "C22B.CUT", 1, 0x0049dd1f, 0x000000fc },
	{ "C22C.CUT", 1, 0x0049de1b, 0x00000166 },
	{ "C24A.CUT", 1, 0x0049df81, 0x000000ec },
	{ "C24B.CUT", 1, 0x0049e06d, 0x000005ca },
	{ "C25A.CUT", 1, 0x0049e637, 0x000002d0 },
	{ "C25B.CUT", 1, 0x0049e907, 0x000002e4 },
	{ "C25C.CUT", 1, 0x0049ebeb, 0x0000023e },
	{ "C25D.CUT", 1, 0x0049ee29, 0x00000182 },
	{ "C25E.CUT", 1, 0x0049efab, 0x00000126 },
	{ "C25F.CUT", 1, 0x0049f0d1, 0x0000017c },
	{ "C25G.CUT", 1, 0x0049f24d, 0x000001e2 },
	{ "C25H.CUT", 1, 0x0049f42f, 0x00000218 },
	{ "C25I.CUT", 1, 0x0049f647, 0x000001da },
	{ "C26A.CUT", 1, 0x0049f821, 0x0000030e },
	{ "C26B.CUT", 1, 0x0049fb2f, 0x000000be },
	{ "C26C.CUT", 1, 0x0049fbed, 0x000001a4 },
	{ "C2A.CUT", 1, 0x0049fd91, 0x000008d0 },
	{ "C2B.CUT", 1, 0x004a0661, 0x000004b8 },
	{ "C2C.CUT", 1, 0x004a0b19, 0x0000023e },
	{ "C3.BBK", 1, 0x004a0d57, 0x00006875 },
	{ "C3.LUM", 1, 0x004a75cc, 0x00000018 },
	{ "C3.MSK", 1, 0x004a75e4, 0x00001f40 },
	{ "C3.PCX", 1, 0x004a9524, 0x0000c40c },
	{ "C3.SAM", 1, 0x004b5930, 0x00011c72 },
	{ "C30A.CUT", 1, 0x004c75a2, 0x00000254 },
	{ "C30B.CUT", 1, 0x004c77f6, 0x000003c4 },
	{ "C30C.CUT", 1, 0x004c7bba, 0x00000722 },
	{ "C30D.CUT", 1, 0x004c82dc, 0x00000206 },
	{ "C30E.CUT", 1, 0x004c84e2, 0x00000976 },
	{ "C30F.CUT", 1, 0x004c8e58, 0x0000010e },
	{ "C30G.CUT", 1, 0x004c8f66, 0x000001e6 },
	{ "C30H.CUT", 1, 0x004c914c, 0x0000014c },
	{ "C31A.CUT", 1, 0x004c9298, 0x0000020c },
	{ "C31B.CUT", 1, 0x004c94a4, 0x00000596 },
	{ "C31C.CUT", 1, 0x004c9a3a, 0x000000e2 },
	{ "C31D.CUT", 1, 0x004c9b1c, 0x000004e4 },
	{ "C31E.CUT", 1, 0x004ca000, 0x000000ee },
	{ "C31F.CUT", 1, 0x004ca0ee, 0x0000010e },
	{ "C32A.CUT", 1, 0x004ca1fc, 0x000000ac },
	{ "C32B.CUT", 1, 0x004ca2a8, 0x0000010c },
	{ "C32C.CUT", 1, 0x004ca3b4, 0x000000e8 },
	{ "C35A.CUT", 1, 0x004ca49c, 0x0000042a },
	{ "C35B.CUT", 1, 0x004ca8c6, 0x000001c0 },
	{ "C36A.CUT", 1, 0x004caa86, 0x0000078c },
	{ "C39A.CUT", 1, 0x004cb212, 0x00000ed4 },
	{ "C3A.CUT", 1, 0x004cc0e6, 0x00000610 },
	{ "C3B.CUT", 1, 0x004cc6f6, 0x000000a0 },
	{ "C3C.CUT", 1, 0x004cc796, 0x000005d8 },
	{ "C3D.CUT", 1, 0x004ccd6e, 0x00000344 },
	{ "C3E.CUT", 1, 0x004cd0b2, 0x0000013a },
	{ "C3F.CUT", 1, 0x004cd1ec, 0x000000e0 },
	{ "C3G.CUT", 1, 0x004cd2cc, 0x00000102 },
	{ "C3H.CUT", 1, 0x004cd3ce, 0x00000120 },
	{ "C4.BBK", 1, 0x004cd4ee, 0x00009420 },
	{ "C4.LUM", 1, 0x004d690e, 0x00000018 },
	{ "C4.MSK", 1, 0x004d6926, 0x00001f40 },
	{ "C4.PCX", 1, 0x004d8866, 0x00009487 },
	{ "C4.SAM", 1, 0x004e1ced, 0x00002754 },
	{ "C40A.CUT", 1, 0x004e4441, 0x0000094a },
	{ "C40B.CUT", 1, 0x004e4d8b, 0x000002c2 },
	{ "C41A.CUT", 1, 0x004e504d, 0x00000b84 },
	{ "C41B.CUT", 1, 0x004e5bd1, 0x00001ba0 },
	{ "C41C.CUT", 1, 0x004e7771, 0x00000170 },
	{ "C41D.CUT", 1, 0x004e78e1, 0x0000025c },
	{ "C41E.CUT", 1, 0x004e7b3d, 0x000001b8 },
	{ "C41F.CUT", 1, 0x004e7cf5, 0x0000009c },
	{ "C41G.CUT", 1, 0x004e7d91, 0x000000fe },
	{ "C41H.CUT", 1, 0x004e7e8f, 0x000000ba },
	{ "C42A.CUT", 1, 0x004e7f49, 0x000003ce },
	{ "C42B.CUT", 1, 0x004e8317, 0x00000802 },
	{ "C42C.CUT", 1, 0x004e8b19, 0x000001ae },
	{ "C42D.CUT", 1, 0x004e8cc7, 0x0000010e },
	{ "C42E.CUT", 1, 0x004e8dd5, 0x00000106 },
	{ "C42F.CUT", 1, 0x004e8edb, 0x00000166 },
	{ "C44A.CUT", 1, 0x004e9041, 0x000004f8 },
	{ "C44B.CUT", 1, 0x004e9539, 0x0000079e },
	{ "C44C.CUT", 1, 0x004e9cd7, 0x0000030a },
	{ "C45A.CUT", 1, 0x004e9fe1, 0x000000f8 },
	{ "C45B.CUT", 1, 0x004ea0d9, 0x000000f8 },
	{ "C45C.CUT", 1, 0x004ea1d1, 0x000000f8 },
	{ "C45D.CUT", 1, 0x004ea2c9, 0x000000f8 },
	{ "C45E.CUT", 1, 0x004ea3c1, 0x00000186 },
	{ "C46A.CUT", 1, 0x004ea547, 0x000000f8 },
	{ "C46B.CUT", 1, 0x004ea63f, 0x000000f8 },
	{ "C46C.CUT", 1, 0x004ea737, 0x000000f8 },
	{ "C46D.CUT", 1, 0x004ea82f, 0x000000f8 },
	{ "C47A.CUT", 1, 0x004ea927, 0x00000640 },
	{ "C48A.CUT", 1, 0x004eaf67, 0x00000656 },
	{ "C48C.CUT", 1, 0x004eb5bd, 0x00000516 },
	{ "C49B.CUT", 1, 0x004ebad3, 0x00000398 },
	{ "C49C.CUT", 1, 0x004ebe6b, 0x00000132 },
	{ "C49D.CUT", 1, 0x004ebf9d, 0x000004e4 },
	{ "C4A.CUT", 1, 0x004ec481, 0x00000094 },
	{ "C4B.CUT", 1, 0x004ec515, 0x000003f4 },
	{ "C5.BBK", 1, 0x004ec909, 0x00004171 },
	{ "C5.LUM", 1, 0x004f0a7a, 0x00000018 },
	{ "C5.MSK", 1, 0x004f0a92, 0x00001f40 },
	{ "C5.PCX", 1, 0x004f29d2, 0x000099f2 },
	{ "C5.SAM", 1, 0x004fc3c4, 0x00003016 },
	{ "C50A.CUT", 1, 0x004ff3da, 0x000004f2 },
	{ "C50B.CUT", 1, 0x004ff8cc, 0x000001f8 },
	{ "C50C.CUT", 1, 0x004ffac4, 0x0000086e },
	{ "C50D.CUT", 1, 0x00500332, 0x000000e2 },
	{ "C50E.CUT", 1, 0x00500414, 0x00000618 },
	{ "C50F.CUT", 1, 0x00500a2c, 0x000003b8 },
	{ "C50G.CUT", 1, 0x00500de4, 0x000008da },
	{ "C50H.CUT", 1, 0x005016be, 0x000000ba },
	{ "C50I.CUT", 1, 0x00501778, 0x000009d4 },
	{ "C50J.CUT", 1, 0x0050214c, 0x000000f2 },
	{ "C51A.CUT", 1, 0x0050223e, 0x0000080e },
	{ "C51B.CUT", 1, 0x00502a4c, 0x000001d8 },
	{ "C51C.CUT", 1, 0x00502c24, 0x000001d8 },
	{ "C51D.CUT", 1, 0x00502dfc, 0x000000ec },
	{ "C53A.CUT", 1, 0x00502ee8, 0x00000566 },
	{ "C53B.CUT", 1, 0x0050344e, 0x0000018a },
	{ "C54A.CUT", 1, 0x005035d8, 0x0000028c },
	{ "C55A.CUT", 1, 0x00503864, 0x000006c8 },
	{ "C56A.CUT", 1, 0x00503f2c, 0x000003ba },
	{ "C56B.CUT", 1, 0x005042e6, 0x00000678 },
	{ "C58A.CUT", 1, 0x0050495e, 0x000001cc },
	{ "C59A.CUT", 1, 0x00504b2a, 0x0000014a },
	{ "C5A.CUT", 1, 0x00504c74, 0x0000040c },
	{ "C5C.CUT", 1, 0x00505080, 0x0000050c },
	{ "C6.BBK", 1, 0x0050558c, 0x0000711b },
	{ "C6.LUM", 1, 0x0050c6a7, 0x00000018 },
	{ "C6.MSK", 1, 0x0050c6bf, 0x00001f40 },
	{ "C6.PCX", 1, 0x0050e5ff, 0x0000c6c0 },
	{ "C6.SAM", 1, 0x0051acbf, 0x00004a87 },
	{ "C60A.CUT", 1, 0x0051f746, 0x00000170 },
	{ "C61A.CUT", 1, 0x0051f8b6, 0x00000170 },
	{ "C62A.CUT", 1, 0x0051fa26, 0x00000dde },
	{ "C62B.CUT", 1, 0x00520804, 0x00000268 },
	{ "C62C.CUT", 1, 0x00520a6c, 0x00000164 },
	{ "C62D.CUT", 1, 0x00520bd0, 0x000002a2 },
	{ "C63A.CUT", 1, 0x00520e72, 0x000002d0 },
	{ "C63B.CUT", 1, 0x00521142, 0x0000098e },
	{ "C63C.CUT", 1, 0x00521ad0, 0x000005d8 },
	{ "C63D.CUT", 1, 0x005220a8, 0x00000194 },
	{ "C63E.CUT", 1, 0x0052223c, 0x00000336 },
	{ "C63F.CUT", 1, 0x00522572, 0x0000041a },
	{ "C63G.CUT", 1, 0x0052298c, 0x00000170 },
	{ "C63H.CUT", 1, 0x00522afc, 0x0000039a },
	{ "C63I.CUT", 1, 0x00522e96, 0x000003ac },
	{ "C63J.CUT", 1, 0x00523242, 0x000002f0 },
	{ "C63K.CUT", 1, 0x00523532, 0x00000634 },
	{ "C64A.CUT", 1, 0x00523b66, 0x00000128 },
	{ "C66A.CUT", 1, 0x00523c8e, 0x000002e8 },
	{ "C67A.CUT", 1, 0x00523f76, 0x000005b6 },
	{ "C67B.CUT", 1, 0x0052452c, 0x0000054c },
	{ "C69A.CUT", 1, 0x00524a78, 0x00000700 },
	{ "C69B.CUT", 1, 0x00525178, 0x00000670 },
	{ "C69C.CUT", 1, 0x005257e8, 0x00000688 },
	{ "C69D.CUT", 1, 0x00525e70, 0x000006ac },
	{ "C69E.CUT", 1, 0x0052651c, 0x000009cc },
	{ "C69F.CUT", 1, 0x00526ee8, 0x00000aa2 },
	{ "C69G.CUT", 1, 0x0052798a, 0x000019ac },
	{ "C69H.CUT", 1, 0x00529336, 0x0000075a },
	{ "C69I.CUT", 1, 0x00529a90, 0x000003f0 },
	{ "C69J.CUT", 1, 0x00529e80, 0x0000008a },
	{ "C69K.CUT", 1, 0x00529f0a, 0x000005c8 },
	{ "C69L.CUT", 1, 0x0052a4d2, 0x0000062a },
	{ "C69M.CUT", 1, 0x0052aafc, 0x000005ba },
	{ "C69N.CUT", 1, 0x0052b0b6, 0x0000012c },
	{ "C69O.CUT", 1, 0x0052b1e2, 0x000001e4 },
	{ "C69Z.CUT", 1, 0x0052b3c6, 0x000017a4 },
	{ "C6A.CUT", 1, 0x0052cb6a, 0x00000220 },
	{ "C6B.CUT", 1, 0x0052cd8a, 0x000000da },
	{ "C6C.CUT", 1, 0x0052ce64, 0x00000138 },
	{ "C7.BBK", 1, 0x0052cf9c, 0x00013c13 },
	{ "C7.PCX", 1, 0x00540baf, 0x0000a75d },
	{ "C70A.CUT", 1, 0x0054b30c, 0x000002b8 },
	{ "C70B.CUT", 1, 0x0054b5c4, 0x00000384 },
	{ "C70B.SAM", 1, 0x0054b948, 0x00009a4e },
	{ "C70C.CUT", 1, 0x00555396, 0x00000292 },
	{ "C70D.CUT", 1, 0x00555628, 0x00000952 },
	{ "C70E.CUT", 1, 0x00555f7a, 0x0000038c },
	{ "C70F.CUT", 1, 0x00556306, 0x0000034c },
	{ "C70F.SAM", 1, 0x00556652, 0x000076bf },
	{ "C70G.CUT", 1, 0x0055dd11, 0x00000348 },
	{ "C70G.SAM", 1, 0x0055e059, 0x00008d7d },
	{ "C70H.CUT", 1, 0x00566dd6, 0x00000322 },
	{ "C70I.CUT", 1, 0x005670f8, 0x000003d8 },
	{ "C70J.CUT", 1, 0x005674d0, 0x00000184 },
	{ "C70K.CUT", 1, 0x00567654, 0x000002c0 },
	{ "C70L.CUT", 1, 0x00567914, 0x000002c0 },
	{ "C70M.CUT", 1, 0x00567bd4, 0x000002ba },
	{ "C70N.CUT", 1, 0x00567e8e, 0x000002ba },
	{ "C71A.CUT", 1, 0x00568148, 0x00000094 },
	{ "C71B.CUT", 1, 0x005681dc, 0x00000094 },
	{ "C71C.CUT", 1, 0x00568270, 0x000000b2 },
	{ "C72A.CUT", 1, 0x00568322, 0x00000730 },
	{ "C72B.CUT", 1, 0x00568a52, 0x00000632 },
	{ "C72C.CUT", 1, 0x00569084, 0x0000007c },
	{ "C73A.CUT", 1, 0x00569100, 0x0000038a },
	{ "C73B.CUT", 1, 0x0056948a, 0x000002b8 },
	{ "C73C.CUT", 1, 0x00569742, 0x00000192 },
	{ "C73D.CUT", 1, 0x005698d4, 0x000000c8 },
	{ "C73E.CUT", 1, 0x0056999c, 0x00000330 },
	{ "C73F.CUT", 1, 0x00569ccc, 0x00000344 },
	{ "C73G.CUT", 1, 0x0056a010, 0x00000210 },
	{ "C74A.CUT", 1, 0x0056a220, 0x0000075e },
	{ "C74B.CUT", 1, 0x0056a97e, 0x0000018c },
	{ "C74C.CUT", 1, 0x0056ab0a, 0x000001dc },
	{ "C74D.CUT", 1, 0x0056ace6, 0x0000018c },
	{ "C74F.CUT", 1, 0x0056ae72, 0x000000e0 },
	{ "C75B.CUT", 1, 0x0056af52, 0x00000d00 },
	{ "C76A.CUT", 1, 0x0056bc52, 0x00000072 },
	{ "C76B.CUT", 1, 0x0056bcc4, 0x00000f28 },
	{ "C8.BBK", 1, 0x0056cbec, 0x0000b5ce },
	{ "C8.PCX", 1, 0x005781ba, 0x0000c31f },
	{ "C8A.CUT", 1, 0x005844d9, 0x000007e4 },
	{ "C8B.CUT", 1, 0x00584cbd, 0x000002a8 },
	{ "C9.BBK", 1, 0x00584f65, 0x0000f68b },
	{ "C9.PCX", 1, 0x005945f0, 0x0000a787 },
	{ "C97A.CUT", 1, 0x0059ed77, 0x0000017e },
	{ "C97B.CUT", 1, 0x0059eef5, 0x0000013c },
	{ "C99D.CUT", 1, 0x0059f031, 0x00000094 },
	{ "C99E.CUT", 1, 0x0059f0c5, 0x000002e6 },
	{ "C99F.CUT", 1, 0x0059f3ab, 0x000002e6 },
	{ "C9A.CUT", 1, 0x0059f691, 0x000001fa },
	{ "C9B.CUT", 1, 0x0059f88b, 0x000000f8 },
	{ "C9C.CUT", 1, 0x0059f983, 0x00000136 },
	{ "C9D.CUT", 1, 0x0059fab9, 0x000000a0 },
	{ "CDCLO.CUT", 1, 0x0059fb59, 0x000001f6 },
	{ "CDINT.CUT", 1, 0x0059fd4f, 0x000017fe },
	{ "CDINT061.SB", 1, 0x005a154d, 0x0000334c },
	{ "CDINT063.SB", 1, 0x005a4899, 0x0000798b },
	{ "CDINT072.SB", 1, 0x005ac224, 0x00005f03 },
	{ "CDINT081.SB", 1, 0x005b2127, 0x000062b3 },
	{ "CDINT091.SB", 1, 0x005b83da, 0x00008a0e },
	{ "CDINT102.SB", 1, 0x005c0de8, 0x0000673a },
	{ "CDINT111.SB", 1, 0x005c7522, 0x00008453 },
	{ "CDINT141.SB", 1, 0x005cf975, 0x000031be },
	{ "CDINT151.SB", 1, 0x005d2b33, 0x00002a7c },
	{ "CDINT191.SB", 1, 0x005d55af, 0x00001fc8 },
	{ "CDINT201.SB", 1, 0x005d7577, 0x00002cd8 },
	{ "CDINT212.SB", 1, 0x005da24f, 0x00004b03 },
	{ "CDINT231.SB", 1, 0x005ded52, 0x00008dc0 },
	{ "CDINT241.SB", 1, 0x005e7b12, 0x000032cf },
	{ "CDINT281.SB", 1, 0x005eade1, 0x000053a6 },
	{ "CDINT291.SB", 1, 0x005f0187, 0x00002138 },
	{ "CDINT301.SB", 1, 0x005f22bf, 0x00003dae },
	{ "CDINT321.SB", 1, 0x005f606d, 0x00007e92 },
	{ "CDINT351.SB", 1, 0x005fdeff, 0x00002000 },
	{ "CDINT361.SB", 1, 0x005ffeff, 0x00005a8b },
	{ "CDINT381.SB", 1, 0x0060598a, 0x00003882 },
	{ "CDINT442.SB", 1, 0x0060920c, 0x0000471b },
	{ "CDINT451.SB", 1, 0x0060d927, 0x00005929 },
	{ "CDINT452.SB", 1, 0x00613250, 0x00007915 },
	{ "CDINT461.SB", 1, 0x0061ab65, 0x00001c6a },
	{ "CDINT463.SB", 1, 0x0061c7cf, 0x000030ae },
	{ "CDINT464.SB", 1, 0x0061f87d, 0x0000c980 },
	{ "CDINT471.SB", 1, 0x0062c1fd, 0x00003593 },
	{ "CDINT481.SB", 1, 0x0062f790, 0x00004e60 },
	{ "CDINT492.SB", 1, 0x006345f0, 0x00004594 },
	{ "CDRES.CUT", 1, 0x00638b84, 0x000001f6 },
	{ "CHANGE.SAM", 1, 0x00638d7a, 0x00005ef2 },
	{ "CHEF.ACT", 1, 0x0063ec6c, 0x00005362 },
	{ "CHEF.DOG", 1, 0x00643fce, 0x00000af0 },
	{ "CHIEF1.DOG", 1, 0x00644abe, 0x000009ca },
	{ "CHIEF2.DOG", 1, 0x00645488, 0x0000121e },
	{ "CHIEF3.DOG", 1, 0x006466a6, 0x00000be4 },
	{ "CHIEF4.DOG", 1, 0x0064728a, 0x000002c4 },
	{ "CHORN.CUT", 1, 0x0064754e, 0x0000034a },
	{ "CINTR.CUT", 1, 0x00647898, 0x00001768 },
	{ "CLOGO.CUT", 1, 0x00649000, 0x000000aa },
	{ "CMASK.CUT", 1, 0x006490aa, 0x00000386 },
	{ "COCON.CUT", 1, 0x00649430, 0x000003d8 },
	{ "COCONUT.SAM", 1, 0x00649808, 0x0000a047 },
	{ "COMIC.CUT", 1, 0x0065384f, 0x0000094e },
	{ "COMPY.ACT", 1, 0x0065419d, 0x00005533 },
	{ "CONTROL.BBK", 1, 0x006596d0, 0x00000e0e },
	{ "COPY.BBK", 1, 0x0065a4de, 0x00000002 },
	{ "COPY.CUT", 1, 0x0065a4e0, 0x00000086 },
	{ "COPY.LBM", 1, 0x0065a566, 0x000053ca },
	{ "COPY.PCX", 1, 0x0065f930, 0x0000646f },
	{ "CRAP.PCX", 1, 0x00665d9f, 0x0000724c },
	{ "CRED.CUT", 1, 0x0066cfeb, 0x000003ae },
	{ "CREDIT1.CRD", 1, 0x0066d399, 0x00000604 },
	{ "CREDIT2.CRD", 1, 0x0066d99d, 0x000010d3 },
	{ "CROWBAR.SAM", 1, 0x0066ea70, 0x00009aca },
	{ "CUDRS.CUT", 1, 0x0067853a, 0x000001f6 },
	{ "D1.BBK", 1, 0x00678730, 0x000061b7 },
	{ "D1.LUM", 1, 0x0067e8e7, 0x00000018 },
	{ "D1.MSK", 1, 0x0067e8ff, 0x00001f40 },
	{ "D1.PCX", 1, 0x0068083f, 0x0000a331 },
	{ "D1C.SAM", 1, 0x0068ab70, 0x0000ddd7 },
	{ "D2.BBK", 1, 0x00698947, 0x00004630 },
	{ "D2.LUM", 1, 0x0069cf77, 0x00000018 },
	{ "D2.MSK", 1, 0x0069cf8f, 0x00001f40 },
	{ "D2.PCX", 1, 0x0069eecf, 0x00008dc3 },
	{ "D3.BBK", 1, 0x006a7c92, 0x00004b34 },
	{ "D3.LUM", 1, 0x006ac7c6, 0x00000018 },
	{ "D3.MSK", 1, 0x006ac7de, 0x00001f40 },
	{ "D3.PCX", 1, 0x006ae71e, 0x0000a662 },
	{ "D3.SAM", 1, 0x006b8d80, 0x0000c55a },
	{ "D4.BBK", 1, 0x006c52da, 0x00013e0d },
	{ "D4.LUM", 1, 0x006d90e7, 0x00000018 },
	{ "D4.MSK", 1, 0x006d90ff, 0x00001f40 },
	{ "D4.PCX", 1, 0x006db03f, 0x0000a69b },
	{ "D5.BBK", 1, 0x006e56da, 0x000088a1 },
	{ "D5.PCX", 1, 0x006edf7b, 0x00007bc5 },
	{ "D5.SAM", 1, 0x006f5b40, 0x00002ee7 },
	{ "D5B.SAM", 1, 0x006f8a27, 0x0001128e },
	{ "D6.BBK", 1, 0x00709cb5, 0x0000a480 },
	{ "D6.LUM", 1, 0x00714135, 0x00000018 },
	{ "D6.MSK", 1, 0x0071414d, 0x00001f40 },
	{ "D6.PCX", 1, 0x0071608d, 0x000099a6 },
	{ "D9.BBK", 1, 0x0071fa33, 0x00008461 },
	{ "D9.PCX", 1, 0x00727e94, 0x0000b551 },
	{ "DATA", 1, 0x007333e5, 0x00001434 },
	{ "DEATH.ACT", 1, 0x00734819, 0x0000d83a },
	{ "DEATH1.DOG", 1, 0x00742053, 0x000017ca },
	{ "DEATH2.DOG", 1, 0x0074381d, 0x0000081e },
	{ "DEINO.ACT", 1, 0x0074403b, 0x0000e199 },
	{ "DFRANK.ACT", 1, 0x007521d4, 0x000052e2 },
	{ "DISK1.SAM", 1, 0x007574b6, 0x000033da },
	{ "DOG.ACT", 1, 0x0075a890, 0x00002a62 },
	{ "DOG.DOG", 1, 0x0075d2f2, 0x0000023a },
	{ "E1.BBK", 1, 0x0075d52c, 0x0001765b },
	{ "E1.PCX", 1, 0x00774b87, 0x0000dcc7 },
	{ "E2.BBK", 1, 0x0078284e, 0x0000cefc },
	{ "E2.PCX", 1, 0x0078f74a, 0x0000f5f2 },
	{ "E3.BBK", 1, 0x0079ed3c, 0x00011042 },
	{ "E3.PCX", 1, 0x007afd7e, 0x0000a4d0 },
	{ "EQDATA.LHA", 1, 0x007ba24e, 0x00031a7a },
	{ "F1.BBK", 1, 0x007ebcc8, 0x00004716 },
	{ "F1.LUM", 1, 0x007f03de, 0x00000018 },
	{ "F1.MSK", 1, 0x007f03f6, 0x00001f40 },
	{ "F1.PCX", 1, 0x007f2336, 0x0000991d },
	{ "F1.SAM", 1, 0x007fbc53, 0x0000fd04 },
	{ "F1B.PCX", 1, 0x0080b957, 0x00005739 },
	{ "F2.BBK", 1, 0x00811090, 0x00006a18 },
	{ "F2.LUM", 1, 0x00817aa8, 0x00000018 },
	{ "F2.MSK", 1, 0x00817ac0, 0x00001f40 },
	{ "F2.PCX", 1, 0x00819a00, 0x00009f28 },
	{ "F2B.PCX", 1, 0x00823928, 0x00004abb },
	{ "F3.BBK", 1, 0x008283e3, 0x00002c59 },
	{ "F3.LUM", 1, 0x0082b03c, 0x00000018 },
	{ "F3.MSK", 1, 0x0082b054, 0x00001f40 },
	{ "F3.PCX", 1, 0x0082cf94, 0x0000aa0c },
	{ "F3.SAM", 1, 0x008379a0, 0x0000a940 },
	{ "F4.BBK", 1, 0x008422e0, 0x0000b561 },
	{ "F4.LUM", 1, 0x0084d841, 0x00000018 },
	{ "F4.MSK", 1, 0x0084d859, 0x00001f40 },
	{ "F4.PCX", 1, 0x0084f799, 0x00014df0 },
	{ "F4B.PCX", 1, 0x00864589, 0x000117d8 },
	{ "F4S.PCX", 1, 0x00875d61, 0x0000833e },
	{ "FALL.SAM", 1, 0x0087e09f, 0x0000cbda },
	{ "FAYE.ACT", 1, 0x0088ac79, 0x00013fda },
	{ "FAYE2.DOG", 1, 0x0089ec53, 0x0000098e },
	{ "FAYE3.DOG", 1, 0x0089f5e1, 0x000005d8 },
	{ "FAYE4.DOG", 1, 0x0089fbb9, 0x00000c40 },
	{ "FAYE5.CUT", 1, 0x008a07f9, 0x0000007a },
	{ "FAYE5.DOG", 1, 0x008a0873, 0x000009ce },
	{ "FAYE6.DOG", 1, 0x008a1241, 0x00000466 },
	{ "FAYE_E.ACT", 1, 0x008a16a7, 0x00002d4a },
	{ "FAYE_H.ACT", 1, 0x008a43f1, 0x0000807a },
	{ "FAYE_H.BBK", 1, 0x008ac46b, 0x0000e9fb },
	{ "FAYE_H.PCX", 1, 0x008bae66, 0x000096b5 },
	{ "FRANK.ACT", 1, 0x008c451b, 0x00008342 },
	{ "FRANK.DOG", 1, 0x008cc85d, 0x00000e48 },
	{ "FRANK_H.ACT", 1, 0x008cd6a5, 0x0000ad60 },
	{ "FRANK_H.BBK", 1, 0x008d8405, 0x00016369 },
	{ "FRANK_H.PCX", 1, 0x008ee76e, 0x00008dd6 },
	{ "GET_GEM.SAM", 1, 0x008f7544, 0x000099d2 },
	{ "GET_HORN.BBK", 1, 0x00900f16, 0x000045d8 },
	{ "GET_HORN.SAM", 1, 0x009054ee, 0x00005dde },
	{ "GM.CUT", 1, 0x0090b2cc, 0x0000009c },
	{ "GOONS.ACT", 1, 0x0090b368, 0x0000728a },
	{ "GUARDS.ACT", 1, 0x009125f2, 0x0000504a },
	{ "HENRY.ACT", 1, 0x0091763c, 0x0000b102 },
	{ "HENRY.DOG", 1, 0x0092273e, 0x00001280 },
	{ "HENRY2.DOG", 1, 0x009239be, 0x00000b24 },
	{ "HORN.SAM", 1, 0x009244e2, 0x000067b2 },
	{ "HUGH.ACT", 1, 0x0092ac94, 0x0000e8da },
	{ "I1.SAM", 1, 0x0093956e, 0x0000cbf2 },
	{ "IAN.ACT", 1, 0x00946160, 0x0000a542 },
	{ "IAN1.DOG", 1, 0x009506a2, 0x00000518 },
	{ "IAN2.DOG", 1, 0x00950bba, 0x00000a9a },
	{ "J1.BBK", 1, 0x00951654, 0x000025fc },
	{ "J1.LUM", 1, 0x00953c50, 0x00000018 },
	{ "J1.MSK", 1, 0x00953c68, 0x00001f40 },
	{ "J1.PCX", 1, 0x00955ba8, 0x00008d84 },
	{ "J1.SAM", 1, 0x0095e92c, 0x00008442 },
	{ "J2.BBK", 1, 0x00966d6e, 0x00000e97 },
	{ "J2.LUM", 1, 0x00967c05, 0x00000018 },
	{ "J2.MSK", 1, 0x00967c1d, 0x00001f40 },
	{ "J2.PCX", 1, 0x00969b5d, 0x0000c33c },
	{ "J2.SAM", 1, 0x00975e99, 0x0000a1e3 },
	{ "J3.BBK", 1, 0x0098007c, 0x00003289 },
	{ "J3.LUM", 1, 0x00983305, 0x00000018 },
	{ "J3.MSK", 1, 0x0098331d, 0x00001f40 },
	{ "J3.PCX", 1, 0x0098525d, 0x000094b4 },
	{ "J4.BBK", 1, 0x0098e711, 0x00006e28 },
	{ "J4.LUM", 1, 0x00995539, 0x00000018 },
	{ "J4.MSK", 1, 0x00995551, 0x00001f40 },
	{ "J4.PCX", 1, 0x00997491, 0x00008e90 },
	{ "J5.BBK", 1, 0x009a0321, 0x00004521 },
	{ "J5.LUM", 1, 0x009a4842, 0x00000018 },
	{ "J5.MSK", 1, 0x009a485a, 0x00001f40 },
	{ "J5.PCX", 1, 0x009a679a, 0x00009b37 },
	{ "J5.SAM", 1, 0x009b02d1, 0x000042f2 },
	{ "J6.BBK", 1, 0x009b45c3, 0x000043d7 },
	{ "J6.LUM", 1, 0x009b899a, 0x00000018 },
	{ "J6.MSK", 1, 0x009b89b2, 0x00001f40 },
	{ "J6.PCX", 1, 0x009ba8f2, 0x0000a5c5 },
	{ "J7.BBK", 1, 0x009c4eb7, 0x00003234 },
	{ "J7.LUM", 1, 0x009c80eb, 0x00000018 },
	{ "J7.MSK", 1, 0x009c8103, 0x00001f40 },
	{ "J7.PCX", 1, 0x009ca043, 0x0000cd63 },
	{ "J7.SAM", 1, 0x009d6da6, 0x000083aa },
	{ "J8.BBK", 1, 0x009df150, 0x0000320d },
	{ "J8.LUM", 1, 0x009e235d, 0x00000018 },
	{ "J8.MSK", 1, 0x009e2375, 0x00001f40 },
	{ "J8.PCX", 1, 0x009e42b5, 0x0000c0e2 },
	{ "J8.SAM", 1, 0x009f0397, 0x0000024e },
	{ "JASPAR.ACT", 1, 0x009f05e5, 0x00004fb2 },
	{ "JIM1.DOG", 1, 0x009f5597, 0x00001276 },
	{ "JIM2.DOG", 1, 0x009f680d, 0x00001282 },
	{ "JIM3.DOG", 1, 0x009f7a8f, 0x00000df6 },
	{ "JIMTAM.ACT", 1, 0x009f8885, 0x0000a08a },
	{ "JOE.BBK", 1, 0x00a0290f, 0x00014b8a },
	{ "JOE1.BBK", 1, 0x00a17499, 0x00012a5a },
	{ "JOED_A.BBK", 1, 0x00a29ef3, 0x00009b8a },
	{ "JOED_B.BBK", 1, 0x00a33a7d, 0x0000a50a },
	{ "JOEU_A.BBK", 1, 0x00a3df87, 0x00009b8a },
	{ "JOEU_B.BBK", 1, 0x00a47b11, 0x0000a50a },
	{ "JOE_A.BBK", 1, 0x00a5201b, 0x00009b8a },
	{ "JOE_B.BBK", 1, 0x00a5bba5, 0x0000dc5a },
	{ "JOE_E.ACT", 1, 0x00a697ff, 0x0000388a },
	{ "JOE_H.ACT", 1, 0x00a6d089, 0x0000dace },
	{ "JOHN.ACT", 1, 0x00a7ab57, 0x00006312 },
	{ "JOHN1.DOG", 1, 0x00a80e69, 0x0000067c },
	{ "JOURNAL.BBK", 1, 0x00a814e5, 0x0000a318 },
	{ "JOURNAL.PCX", 1, 0x00a8b7fd, 0x00009c70 },
	{ "KISS1.SAM", 1, 0x00a9546d, 0x0000f722 },
	{ "KLUNK.ACT", 1, 0x00aa4b8f, 0x00007c30 },
	{ "KLUNK1.DOG", 1, 0x00aac7bf, 0x00000e6a },
	{ "KLUNK2.DOG", 1, 0x00aad629, 0x00000ed0 },
	{ "KLUNK2.SAM", 1, 0x00aae4f9, 0x0001737c },
	{ "L1.BBK", 1, 0x00ac5875, 0x00000002 },
	{ "L1.PCX", 1, 0x00ac5877, 0x000043f7 },
	{ "L2.BBK", 1, 0x00ac9c6e, 0x00000002 },
	{ "L2.PCX", 1, 0x00ac9c70, 0x0000ba60 },
	{ "LARIS.ACT", 1, 0x00ad56d0, 0x0000355a },
	{ "LARIS.DOG", 1, 0x00ad8c2a, 0x00000f32 },
	{ "LARIS3.DOG", 1, 0x00ad9b5c, 0x0000079a },
	{ "LITTLEP.ACT", 1, 0x00ada2f6, 0x000002e2 },
	{ "LOLA.ACT", 1, 0x00ada5d8, 0x0001342d },
	{ "LOLA1.DOG", 1, 0x00aeda05, 0x00000ad6 },
	{ "LOU.ACT", 1, 0x00aee4db, 0x00005552 },
	{ "LOU1.DOG", 1, 0x00af3a2d, 0x000010ac },
	{ "LOU2.DOG", 1, 0x00af4ad9, 0x00000bae },
	{ "M1.BBK", 1, 0x00af5687, 0x00006d5c },
	{ "M1.PCX", 1, 0x00afc3e3, 0x000193ce },
	{ "M2.BBK", 1, 0x00b157b1, 0x00001a4a },
	{ "M2.PCX", 1, 0x00b171fb, 0x0000a9d3 },
	{ "M2.SAM", 1, 0x00b21bce, 0x0001433c },
	{ "MAN1.DOG", 1, 0x00b35f0a, 0x0000101e },
	{ "MAN2.DOG", 1, 0x00b36f28, 0x000007a4 },
	{ "MASK.SAM", 1, 0x00b376cc, 0x000081ea },
	{ "N1.BBK", 1, 0x00b3f8b6, 0x00002d74 },
	{ "N1.LUM", 1, 0x00b4262a, 0x00000018 },
	{ "N1.MSK", 1, 0x00b42642, 0x00001f40 },
	{ "N1.PCX", 1, 0x00b44582, 0x0000cbe7 },
	{ "N10.BBK", 1, 0x00b51169, 0x00000002 },
	{ "N10.PCX", 1, 0x00b5116b, 0x0000a28d },
	{ "N10.SAM", 1, 0x00b5b3f8, 0x000147f8 },
	{ "N11.BBK", 1, 0x00b6fbf0, 0x00000d48 },
	{ "N11.PCX", 1, 0x00b70938, 0x00008e85 },
	{ "N12.BBK", 1, 0x00b797bd, 0x000049aa },
	{ "N12.LUM", 1, 0x00b7e167, 0x00000018 },
	{ "N12.MSK", 1, 0x00b7e17f, 0x00001f40 },
	{ "N12.PCX", 1, 0x00b800bf, 0x000074ea },
	{ "N13.BBK", 1, 0x00b875a9, 0x000046b7 },
	{ "N13.LUM", 1, 0x00b8bc60, 0x00000018 },
	{ "N13.MSK", 1, 0x00b8bc78, 0x00001f40 },
	{ "N13.PCX", 1, 0x00b8dbb8, 0x00008640 },
	{ "N13.SAM", 1, 0x00b961f8, 0x00025a26 },
	{ "N13B.SAM", 1, 0x00bbbc1e, 0x0000250a },
	{ "N14.BBK", 1, 0x00bbe128, 0x000073ec },
	{ "N14.PCX", 1, 0x00bc5514, 0x0000b3f3 },
	{ "N14.SAM", 1, 0x00bd0907, 0x0002550a },
	{ "N14B.PCX", 1, 0x00bf5e11, 0x0000b933 },
	{ "N15.BBK", 1, 0x00c01744, 0x00000002 },
	{ "N15.PCX", 1, 0x00c01746, 0x0000ae43 },
	{ "N16.BBK", 1, 0x00c0c589, 0x000014c0 },
	{ "N16.LUM", 1, 0x00c0da49, 0x00000018 },
	{ "N16.MSK", 1, 0x00c0da61, 0x00001f40 },
	{ "N16.PCX", 1, 0x00c0f9a1, 0x0000e038 },
	{ "N2.BBK", 1, 0x00c1d9d9, 0x00007377 },
	{ "N2.LUM", 1, 0x00c24d50, 0x00000018 },
	{ "N2.MSK", 1, 0x00c24d68, 0x00001f40 },
	{ "N2.PCX", 1, 0x00c26ca8, 0x00007d65 },
	{ "N3.BBK", 1, 0x00c2ea0d, 0x00004fe2 },
	{ "N3.LUM", 1, 0x00c339ef, 0x00000018 },
	{ "N3.MSK", 1, 0x00c33a07, 0x00001f40 },
	{ "N3.PCX", 1, 0x00c35947, 0x0000a6de },
	{ "N4.BBK", 1, 0x00c40025, 0x0000acc0 },
	{ "N4.LUM", 1, 0x00c4ace5, 0x00000018 },
	{ "N4.MSK", 1, 0x00c4acfd, 0x00001f40 },
	{ "N4.PCX", 1, 0x00c4cc3d, 0x00006e0b },
	{ "N5.BBK", 1, 0x00c53a48, 0x0000202a },
	{ "N5.LUM", 1, 0x00c55a72, 0x00000018 },
	{ "N5.MSK", 1, 0x00c55a8a, 0x00001f40 },
	{ "N5.PCX", 1, 0x00c579ca, 0x000092f0 },
	{ "N6.BBK", 1, 0x00c60cba, 0x00001d97 },
	{ "N6.LUM", 1, 0x00c62a51, 0x00000018 },
	{ "N6.MSK", 1, 0x00c62a69, 0x00001f40 },
	{ "N6.PCX", 1, 0x00c649a9, 0x000086e2 },
	{ "N7.BBK", 1, 0x00c6d08b, 0x000025f8 },
	{ "N7.LUM", 1, 0x00c6f683, 0x00000018 },
	{ "N7.MSK", 1, 0x00c6f69b, 0x00001f40 },
	{ "N7.PCX", 1, 0x00c715db, 0x00008e79 },
	{ "N8.BBK", 1, 0x00c7a454, 0x00007bb7 },
	{ "N8.LUM", 1, 0x00c8200b, 0x00000018 },
	{ "N8.MSK", 1, 0x00c82023, 0x00001f40 },
	{ "N8.PCX", 1, 0x00c83f63, 0x0000be5f },
	{ "N9.BBK", 1, 0x00c8fdc2, 0x0000c9bf },
	{ "N9.LUM", 1, 0x00c9c781, 0x00000018 },
	{ "N9.MSK", 1, 0x00c9c799, 0x00001f40 },
	{ "N9.PCX", 1, 0x00c9e6d9, 0x0000aa4b },
	{ "N9.SAM", 1, 0x00ca9124, 0x0000e902 },
	{ "NAOMI.DOG", 1, 0x00cb7a26, 0x000013b6 },
	{ "NAOMI2.DOG", 1, 0x00cb8ddc, 0x00000a40 },
	{ "OBJECTS.BBK", 1, 0x00cb981c, 0x00019322 },
	{ "ORACLE.ACT", 1, 0x00cd2b3e, 0x00004042 },
	{ "ORACLE1.DOG", 1, 0x00cd6b80, 0x00001088 },
	{ "ORACLE2.DOG", 1, 0x00cd7c08, 0x000003c0 },
	{ "ORACLE3.DOG", 1, 0x00cd7fc8, 0x00000806 },
	{ "PANEL.PCX", 1, 0x00cd87ce, 0x00002279 },
	{ "PRIN1.CUT", 1, 0x00cdaa47, 0x0000007a },
	{ "PRIN1.DOG", 1, 0x00cdaac1, 0x00000aea },
	{ "PRIN2.DOG", 1, 0x00cdb5ab, 0x0000055a },
	{ "PRIN4.DOG", 1, 0x00cdbb05, 0x00000720 },
	{ "PRINCESS.ACT", 1, 0x00cdc225, 0x0000d732 },
	{ "PRISON.ACT", 1, 0x00ce9957, 0x00006f22 },
	{ "PUNCH.SAM", 1, 0x00cf0879, 0x00007e9a },
	{ "PUSH.SAM", 1, 0x00cf8713, 0x00009308 },
	{ "PYGMY.ACT", 1, 0x00d01a1b, 0x00010a63 },
	{ "QUEEN.JAS", 1, 0x00d1247e, 0x0001371a },
	{ "QUEEN2.JAS", 1, 0x00d25b98, 0x00008c00 },
	{ "R1.BBK", 1, 0x00d2e798, 0x00001a4a },
	{ "R1.PCX", 1, 0x00d301e2, 0x000065c0 },
	{ "R2.BBK", 1, 0x00d367a2, 0x00001a4a },
	{ "R2.PCX", 1, 0x00d381ec, 0x00005f32 },
	{ "R3.BBK", 1, 0x00d3e11e, 0x00001a4a },
	{ "R3.PCX", 1, 0x00d3fb68, 0x000061a1 },
	{ "R4.BBK", 1, 0x00d45d09, 0x00001a4a },
	{ "R4.PCX", 1, 0x00d47753, 0x00009ec3 },
	{ "RASH.SAM", 1, 0x00d51616, 0x0000431a },
	{ "RENEGADE.BBK", 1, 0x00d55930, 0x0000117a },
	{ "RENEGADE.PCX", 1, 0x00d56aaa, 0x0000296d },
	{ "RITA.ACT", 1, 0x00d59417, 0x000020ea },
	{ "RITA_H.ACT", 1, 0x00d5b501, 0x00015cdb },
	{ "ROCKET.SAM", 1, 0x00d711dc, 0x00027e20 },
	{ "SEC.ACT", 1, 0x00d98ffc, 0x00006e6a },
	{ "SEC1.DOG", 1, 0x00d9fe66, 0x00001672 },
	{ "SEC2.DOG", 1, 0x00da14d8, 0x00000944 },
	{ "SHEET.SAM", 1, 0x00da1e1c, 0x0000ad00 },
	{ "SHIELD.SAM", 1, 0x00dacb1c, 0x00002afb },
	{ "SHOWER.ACT", 1, 0x00daf617, 0x0000762a },
	{ "SHOWERAM.DOG", 1, 0x00db6c41, 0x000005fc },
	{ "SKULL.ACT", 1, 0x00db723d, 0x00001973 },
	{ "SPARKY.ACT", 1, 0x00db8bb0, 0x0000f912 },
	{ "SPARKY1.DOG", 1, 0x00dc84c2, 0x00000986 },
	{ "SPARKY2.DOG", 1, 0x00dc8e48, 0x00000402 },
	{ "SPARKY3.DOG", 1, 0x00dc924a, 0x0000126e },
	{ "SPARKY4.DOG", 1, 0x00dca4b8, 0x0000043a },
	{ "SPARKY5.DOG", 1, 0x00dca8f2, 0x0000091c },
	{ "SPARKY6.DOG", 1, 0x00dcb20e, 0x000007b6 },
	{ "SPARKY7.DOG", 1, 0x00dcb9c4, 0x0000095e },
	{ "SPARKY8.DOG", 1, 0x00dcc322, 0x0000072a },
	{ "SPARKY_H.ACT", 1, 0x00dcca4c, 0x0000280a },
	{ "T1.BBK", 1, 0x00dcf256, 0x0000f492 },
	{ "T1.LUM", 1, 0x00dde6e8, 0x00000018 },
	{ "T1.MSK", 1, 0x00dde700, 0x00001f40 },
	{ "T1.PCX", 1, 0x00de0640, 0x0000aa3d },
	{ "T1.SAM", 1, 0x00deb07d, 0x0000711a },
	{ "T10.BBK", 1, 0x00df2197, 0x0000a957 },
	{ "T10.LUM", 1, 0x00dfcaee, 0x00000018 },
	{ "T10.MSK", 1, 0x00dfcb06, 0x00001f40 },
	{ "T10.PCX", 1, 0x00dfea46, 0x0001198a },
	{ "T10.SAM", 1, 0x00e103d0, 0x0000bc49 },
	{ "T11.BBK", 1, 0x00e1c019, 0x00001e84 },
	{ "T11.LUM", 1, 0x00e1de9d, 0x00000018 },
	{ "T11.MSK", 1, 0x00e1deb5, 0x00001f40 },
	{ "T11.PCX", 1, 0x00e1fdf5, 0x00008e7e },
	{ "T12.BBK", 1, 0x00e28c73, 0x000059b5 },
	{ "T12.LUM", 1, 0x00e2e628, 0x00000018 },
	{ "T12.MSK", 1, 0x00e2e640, 0x00001f40 },
	{ "T12.PCX", 1, 0x00e30580, 0x00007b3c },
	{ "T12.SAM", 1, 0x00e380bc, 0x0000fe4b },
	{ "T13.BBK", 1, 0x00e47f07, 0x000043b4 },
	{ "T13.LUM", 1, 0x00e4c2bb, 0x00000018 },
	{ "T13.MSK", 1, 0x00e4c2d3, 0x00001f40 },
	{ "T13.PCX", 1, 0x00e4e213, 0x00007591 },
	{ "T14.BBK", 1, 0x00e557a4, 0x0000468b },
	{ "T14.LUM", 1, 0x00e59e2f, 0x00000018 },
	{ "T14.MSK", 1, 0x00e59e47, 0x00001f40 },
	{ "T14.PCX", 1, 0x00e5bd87, 0x00007df5 },
	{ "T14.SAM", 1, 0x00e63b7c, 0x00016db3 },
	{ "T15.BBK", 1, 0x00e7a92f, 0x000096e6 },
	{ "T15.LUM", 1, 0x00e84015, 0x00000018 },
	{ "T15.MSK", 1, 0x00e8402d, 0x00001f40 },
	{ "T15.PCX", 1, 0x00e85f6d, 0x00008b28 },
	{ "T15.SAM", 1, 0x00e8ea95, 0x0000a7d0 },
	{ "T15B.SAM", 1, 0x00e99265, 0x000164d7 },
	{ "T16.BBK", 1, 0x00eaf73c, 0x000027ff },
	{ "T16.LUM", 1, 0x00eb1f3b, 0x00000018 },
	{ "T16.MSK", 1, 0x00eb1f53, 0x00001f40 },
	{ "T16.PCX", 1, 0x00eb3e93, 0x00009110 },
	{ "T17.BBK", 1, 0x00ebcfa3, 0x000056df },
	{ "T17.LUM", 1, 0x00ec2682, 0x00000018 },
	{ "T17.MSK", 1, 0x00ec269a, 0x00001f40 },
	{ "T17.PCX", 1, 0x00ec45da, 0x00007db6 },
	{ "T18.BBK", 1, 0x00ecc390, 0x00006174 },
	{ "T18.LUM", 1, 0x00ed2504, 0x00000018 },
	{ "T18.MSK", 1, 0x00ed251c, 0x00001f40 },
	{ "T18.PCX", 1, 0x00ed445c, 0x000087d6 },
	{ "T19.BBK", 1, 0x00edcc32, 0x0000aec8 },
	{ "T19.LUM", 1, 0x00ee7afa, 0x00000018 },
	{ "T19.MSK", 1, 0x00ee7b12, 0x00001f40 },
	{ "T19.PCX", 1, 0x00ee9a52, 0x0000768e },
	{ "T19.SAM", 1, 0x00ef10e0, 0x000167ea },
	{ "T1B.SAM", 1, 0x00f078ca, 0x0002fa9f },
	{ "T2.BBK", 1, 0x00f37369, 0x00004dea },
	{ "T2.LUM", 1, 0x00f3c153, 0x00000018 },
	{ "T2.MSK", 1, 0x00f3c16b, 0x00001f40 },
	{ "T2.PCX", 1, 0x00f3e0ab, 0x00011404 },
	{ "T2.SAM", 1, 0x00f4f4af, 0x0000aa32 },
	{ "T20.BBK", 1, 0x00f59ee1, 0x0000611c },
	{ "T20.LUM", 1, 0x00f5fffd, 0x00000018 },
	{ "T20.MSK", 1, 0x00f60015, 0x00001f40 },
	{ "T20.PCX", 1, 0x00f61f55, 0x0000852a },
	{ "T20.SAM", 1, 0x00f6a47f, 0x00007f9c },
	{ "T20B.SAM", 1, 0x00f7241b, 0x0000a2bc },
	{ "T21.BBK", 1, 0x00f7c6d7, 0x00000002 },
	{ "T21.PCX", 1, 0x00f7c6d9, 0x0000b7b0 },
	{ "T22.BBK", 1, 0x00f87e89, 0x00000002 },
	{ "T22.PCX", 1, 0x00f87e8b, 0x0000a982 },
	{ "T23.BBK", 1, 0x00f9280d, 0x00005bca },
	{ "T23.LUM", 1, 0x00f983d7, 0x00000018 },
	{ "T23.MSK", 1, 0x00f983ef, 0x00001f40 },
	{ "T23.PCX", 1, 0x00f9a32f, 0x00008200 },
	{ "T24.BBK", 1, 0x00fa252f, 0x0000aaf1 },
	{ "T24.LUM", 1, 0x00fad020, 0x00000018 },
	{ "T24.MSK", 1, 0x00fad038, 0x00001f40 },
	{ "T24.PCX", 1, 0x00faef78, 0x00006f7e },
	{ "T25.BBK", 1, 0x00fb5ef6, 0x0000a631 },
	{ "T25.LUM", 1, 0x00fc0527, 0x00000018 },
	{ "T25.MSK", 1, 0x00fc053f, 0x00001f40 },
	{ "T25.PCX", 1, 0x00fc247f, 0x00008881 },
	{ "T25.SAM", 1, 0x00fcad00, 0x000091ac },
	{ "T26.BBK", 1, 0x00fd3eac, 0x00014578 },
	{ "T26.LUM", 1, 0x00fe8424, 0x00000018 },
	{ "T26.MSK", 1, 0x00fe843c, 0x00001f40 },
	{ "T26.PCX", 1, 0x00fea37c, 0x00012570 },
	{ "T26A.SAM", 1, 0x00ffc8ec, 0x000126a6 },
	{ "T27.BBK", 1, 0x0100ef92, 0x0000a73e },
	{ "T27.LUM", 1, 0x010196d0, 0x00000018 },
	{ "T27.MSK", 1, 0x010196e8, 0x00001f40 },
	{ "T27.PCX", 1, 0x0101b628, 0x000085fa },
	{ "T28.BBK", 1, 0x01023c22, 0x00000002 },
	{ "T28.PCX", 1, 0x01023c24, 0x000017d2 },
	{ "T2B.SAM", 1, 0x010253f6, 0x00021df6 },
	{ "T3.BBK", 1, 0x010471ec, 0x00004b24 },
	{ "T3.LUM", 1, 0x0104bd10, 0x00000018 },
	{ "T3.MSK", 1, 0x0104bd28, 0x00001f40 },
	{ "T3.PCX", 1, 0x0104dc68, 0x0000724c },
	{ "T3.SAM", 1, 0x01054eb4, 0x00006042 },
	{ "T4.BBK", 1, 0x0105aef6, 0x00002dca },
	{ "T4.MSK", 1, 0x0105dcc0, 0x00001f40 },
	{ "T4.PCX", 1, 0x0105fc00, 0x00007566 },
	{ "T5.BBK", 1, 0x01067166, 0x00001ac0 },
	{ "T5.LUM", 1, 0x01068c26, 0x00000018 },
	{ "T5.MSK", 1, 0x01068c3e, 0x00001f40 },
	{ "T5.PCX", 1, 0x0106ab7e, 0x00009509 },
	{ "T5.SAM", 1, 0x01074087, 0x000049aa },
	{ "T5B.SAM", 1, 0x01078a31, 0x00022018 },
	{ "T5C.SAM", 1, 0x0109aa49, 0x00011612 },
	{ "T6.BBK", 1, 0x010ac05b, 0x00007db0 },
	{ "T6.LUM", 1, 0x010b3e0b, 0x00000018 },
	{ "T6.MSK", 1, 0x010b3e23, 0x00001f40 },
	{ "T6.PCX", 1, 0x010b5d63, 0x000096b4 },
	{ "T6.SAM", 1, 0x010bf417, 0x0000f04d },
	{ "T6A.SAM", 1, 0x010ce464, 0x000199ee },
	{ "T6B.PCX", 1, 0x010e7e52, 0x0000ad10 },
	{ "T6B.SAM", 1, 0x010f2b62, 0x00010cba },
	{ "T6C.SAM", 1, 0x0110381c, 0x00015041 },
	{ "T7.BBK", 1, 0x0111885d, 0x0000c781 },
	{ "T7.PCX", 1, 0x01124fde, 0x00006da0 },
	{ "T7.SAM", 1, 0x0112bd7e, 0x000172ea },
	{ "T8.BBK", 1, 0x01143068, 0x00002762 },
	{ "T8.LUM", 1, 0x011457ca, 0x00000018 },
	{ "T8.MSK", 1, 0x011457e2, 0x00001f40 },
	{ "T8.PCX", 1, 0x01147722, 0x0000831b },
	{ "T8.SAM", 1, 0x0114fa3d, 0x00012c01 },
	{ "T9.BBK", 1, 0x0116263e, 0x000029f3 },
	{ "T9.LUM", 1, 0x01165031, 0x00000018 },
	{ "T9.MSK", 1, 0x01165049, 0x00001f40 },
	{ "T9.PCX", 1, 0x01166f89, 0x0000735b },
	{ "T9.SAM", 1, 0x0116e2e4, 0x0000d9e6 },
	{ "TABLET.BBK", 1, 0x0117bcca, 0x00013902 },
	{ "TABLET.PCX", 1, 0x0118f5cc, 0x0000af16 },
	{ "TALLPYG.DOG", 1, 0x0119a4e2, 0x0000034a },
	{ "TAM1.DOG", 1, 0x0119a82c, 0x00001e8a },
	{ "TAM2.DOG", 1, 0x0119c6b6, 0x0000076c },
	{ "TAM3.DOG", 1, 0x0119ce22, 0x000007c2 },
	{ "TAM4.DOG", 1, 0x0119d5e4, 0x0000083c },
	{ "TEMPLE.ACT", 1, 0x0119de20, 0x00005052 },
	{ "TMPD.ACT", 1, 0x011a2e72, 0x0000b00c },
	{ "TRADER.ACT", 1, 0x011ade7e, 0x0001424a },
	{ "V1.BBK", 1, 0x011c20c8, 0x00006724 },
	{ "V1.PCX", 1, 0x011c87ec, 0x000091ea },
	{ "V1.SAM", 1, 0x011d19d6, 0x000061e5 },
	{ "V10.BBK", 1, 0x011d7bbb, 0x000094e8 },
	{ "V10.PCX", 1, 0x011e10a3, 0x0000946c },
	{ "V11.BBK", 1, 0x011ea50f, 0x0000e122 },
	{ "V11.PCX", 1, 0x011f8631, 0x0000946c },
	{ "V2.BBK", 1, 0x01201a9d, 0x00007dfb },
	{ "V2.LUM", 1, 0x01209898, 0x00000018 },
	{ "V2.MSK", 1, 0x012098b0, 0x00001f40 },
	{ "V2.PCX", 1, 0x0120b7f0, 0x0000876c },
	{ "V3.BBK", 1, 0x01213f5c, 0x0000d716 },
	{ "V3.LUM", 1, 0x01221672, 0x00000018 },
	{ "V3.MSK", 1, 0x0122168a, 0x00001f40 },
	{ "V3.PCX", 1, 0x012235ca, 0x00005efa },
	{ "V4.BBK", 1, 0x012294c4, 0x0000571a },
	{ "V4.PCX", 1, 0x0122ebde, 0x00010cd4 },
	{ "V5.BBK", 1, 0x0123f8b2, 0x0001c43f },
	{ "V5.MSK", 1, 0x0125bcf1, 0x00001f40 },
	{ "V5.PCX", 1, 0x0125dc31, 0x00009148 },
	{ "V5.SAM", 1, 0x01266d79, 0x0003953d },
	{ "V5B.SAM", 1, 0x012a02b6, 0x0000ce6f },
	{ "V5C.SAM", 1, 0x012ad125, 0x0000f142 },
	{ "V5D.SAM", 1, 0x012bc267, 0x00000f50 },
	{ "V5E.SAM", 1, 0x012bd1b7, 0x00009352 },
	{ "V5X.SAM", 1, 0x012c6509, 0x0001d7c2 },
	{ "V6.BBK", 1, 0x012e3ccb, 0x0000d716 },
	{ "V6.LUM", 1, 0x012f13e1, 0x00000018 },
	{ "V6.MSK", 1, 0x012f13f9, 0x00001f40 },
	{ "V6.PCX", 1, 0x012f3339, 0x000074ce },
	{ "V7.BBK", 1, 0x012fa807, 0x000177cd },
	{ "V7.PCX", 1, 0x01311fd4, 0x0000a3b4 },
	{ "V8.BBK", 1, 0x0131c388, 0x00006724 },
	{ "V8.PCX", 1, 0x01322aac, 0x0000a8d0 },
	{ "VACUUM.SAM", 1, 0x0132d37c, 0x00009516 },
	{ "WATER.ACT", 1, 0x01336892, 0x00001c02 },
	{ "WEDGE.ACT", 1, 0x01338494, 0x0000390e },
	{ "WEDGE.DOG", 1, 0x0133bda2, 0x000002c4 },
	{ "WEENIE.SAM", 1, 0x0133c066, 0x0000b4d2 },
	{ "WITCH1.DOG", 1, 0x01347538, 0x000012e4 },
	{ "WITCH2.DOG", 1, 0x0134881c, 0x0000088e },
	{ "WITCH3.DOG", 1, 0x013490aa, 0x00000df8 },
	{ "WITCH4.DOG", 1, 0x01349ea2, 0x000002b2 },
	{ "X1.BBK", 1, 0x0134a154, 0x00010e5d },
	{ "X1.PCX", 1, 0x0135afb1, 0x0000cc4b },
	{ "X10.BBK", 1, 0x01367bfc, 0x00009907 },
	{ "X10.PCX", 1, 0x01371503, 0x0000a1b3 },
	{ "X10_JOE.ACT", 1, 0x0137b6b6, 0x0000943a },
	{ "X10_RITA.ACT", 1, 0x01384af0, 0x000076d9 },
	{ "X11.BBK", 1, 0x0138c1c9, 0x00016966 },
	{ "X11.PCX", 1, 0x013a2b2f, 0x0000c160 },
	{ "X11_JOE.ACT", 1, 0x013aec8f, 0x0000872e },
	{ "X11_RITA.ACT", 1, 0x013b73bd, 0x0000a6f2 },
	{ "X2.BBK", 1, 0x013c1aaf, 0x0000df2b },
	{ "X2.PCX", 1, 0x013cf9da, 0x00013ed5 },
	{ "X2_JOE.ACT", 1, 0x013e38af, 0x00008042 },
	{ "X2_RITA.ACT", 1, 0x013eb8f1, 0x0000df02 },
	{ "X3.BBK", 1, 0x013f97f3, 0x00000002 },
	{ "X3.PCX", 1, 0x013f97f5, 0x0000d165 },
	{ "X3_RITA.ACT", 1, 0x0140695a, 0x0000a0fa },
	{ "X4.BBK", 1, 0x01410a54, 0x00004b53 },
	{ "X4.PCX", 1, 0x014155a7, 0x0000b51b },
	{ "X4A.SAM", 1, 0x01420ac2, 0x0001b456 },
	{ "X4B.SAM", 1, 0x0143bf18, 0x0002a1b4 },
	{ "X4_JOE.ACT", 1, 0x014660cc, 0x000088a5 },
	{ "X4_RITA.ACT", 1, 0x0146e971, 0x0000398a },
	{ "X5.BBK", 1, 0x014722fb, 0x000075a0 },
	{ "X5.PCX", 1, 0x0147989b, 0x0000adeb },
	{ "X5_SPARK.ACT", 1, 0x01484686, 0x00006e5a },
	{ "X6.BBK", 1, 0x0148b4e0, 0x0001889e },
	{ "X6.PCX", 1, 0x014a3d7e, 0x0000be75 },
	{ "X6_HUGH.ACT", 1, 0x014afbf3, 0x0000c25a },
	{ "X7.BBK", 1, 0x014bbe4d, 0x00002ada },
	{ "X7.PCX", 1, 0x014be927, 0x00009456 },
	{ "X7A.SAM", 1, 0x014c7d7d, 0x0001b7cb },
	{ "X7B.SAM", 1, 0x014e3548, 0x0003b107 },
	{ "X8.BBK", 1, 0x0151e64f, 0x00032a14 },
	{ "X8.PCX", 1, 0x01551063, 0x00013d4f },
	{ "X9.BBK", 1, 0x01564db2, 0x00028337 },
	{ "X9.PCX", 1, 0x0158d0e9, 0x0000a31c },
	{ "ZOMBIE.ACT", 1, 0x01597405, 0x000078ea },
	{ "ZOMBIE1.DOG", 1, 0x0159ecef, 0x00000f6a },
	{ "ZOMBIE2.DOG", 1, 0x0159fc59, 0x00000c40 }
};

} // End of namespace Queen
