lure.asm                                           Sourcer v6.09   17-Nov- 5   5:53 pm   Page 1


                                PAGE  59,132

                                ;
                                ;                                                                      
                                ;                             LURE                                     
                                ;                                                                      
                                ;      Created:   23-Jun-95                                            
                                ;      Passes:    9          Analysis Options on: QRSX                 
                                ;      Copyright Revolution Software 1990-1992                         
                                ;                                                                      
                                ;

                                .err     Target Assembler set to NONE, re-assembly not recommended


VGA_SEGMENT        equ  0a000h
SCREEN_WIDTH       equ  320
SCREEN_HEIGHT      equ  200

RECT_SIZE          equ  32
RECTANGLE_SIZE     equ  32*32
NUM_HORIZ_RECTS    equ  10
NUM_VERT_RECTS     equ   6
FULL_HORIZ_RECTS   equ  18
FULL_VERT_RECTS    equ  14

ROOM_PATHS_WIDTH      equ  40
ROOM_PATHS_HEIGHT     equ  24
DECODED_PATHS_WIDTH   equ  42
DECODED_PATHS_HEIGHT  equ  26

WRITE_BUFFER_SIZE  equ  0f010h
FILE_BUFFER_SIZE   equ  0600h
ENTRY_READ_BUFFER  equ  80h
VIDEO_STYLE_VGA    equ  1
VIDEO_STYLE_EGA    equ  2
TIMER_TICKS_MAX    equ  2EE0h
MUSIC_NOTE         equ  80h
MUSIC_NOTE_OFF     equ  7fh
MUSIC_NOTE_VISIBLE equ  40h
NOTE_DISPLAY_ADDR  equ  185*SCREEN_WIDTH     ; (A000:E740) line #186 on screen
NOTE_IMAGE_WIDTH   equ  14
NOTE_IMAGE_HEIGHT  equ  14

MENUBAR_Y_SIZE      equ  8
MENUBAR_BLOCK_SIZE  equ  MENUBAR_Y_SIZE*SCREEN_WIDTH
MENUITEM_NUM_MENUS  equ  4

STATUS_VIDEO_MODE_SET     equ  1
STATUS_UNKNOWN            equ  2
STATUS_TIMER_SET          equ  4
STATUS_CTRL_BREAK_SET     equ  8
STATUS_CRITICAL_SET       equ  10h
STATUS_UNKNOWN2           equ  20h
STATUS_KEYBOARD_SET       equ  40h
STATUS_MOUSE_HANDLER_SET  equ  80h

SYS_HAS_FLOPPY_DRIVE      equ  80h

CURSOR_ARROW              equ  0
CURSOR_DISK               equ  1
CURSOR_TIME_UP            equ  2
CURSOR_TIME_UP_RIGHT      equ  3
CURSOR_TIME_RIGHT         equ  4
CURSOR_TIME_DOWN_RIGHT    equ  5
CURSOR_TIME_DOWN          equ  6
CURSOR_TIME_DOWN_LEFT     equ  7
CURSOR_TIME_LEFT          equ  8
CURSOR_TIME_UP_LEFT       equ  9
CURSOR_CROSS              equ  10
CURSOR_ARROW_UP           equ  11
CURSOR_ARROW_DOWN         equ  12
CURSOR_ARROW_LEFT         equ  13
CURSOR_ARROW_RIGHT        equ  14
CURSOR_CAMERA             equ  15
CURSOR_TALK               equ  16
CURSOR_MENUBAR_AREA       equ  17
CURSOR_ARROW_UP2          equ  18
CURSOR_ARROW_DOWN2        equ  19
CURSOR_ARROW_LEFT2        equ  20
CURSOR_ARROW_RIGHT2       equ  21
CURSOR_VOICE              equ  22
CURSOR_AXE_1              equ  23
CURSOR_AXE_2              equ  24
CURSOR_AXE_3              equ  25

NUM_ACTIONS               equ  25

NUM_ANIMATION_SLOTS       equ  2dh
ANIMATION_SLOT_SIZE       equ  29h

NUM_HOTSPOT_ACTION_SLOTS  equ  14h
HOTSPOT_ACTION_SLOT_SIZE  equ  8

ACTION_GET                equ   1
ACTION_PUSH               equ   3
ACTION_PULL               equ   4
ACTION_OPERATE            equ   5
ACTION_OPEN               equ   6
ACTION_CLOSE              equ   7
ACTION_LOCK               equ   8
ACTION_UNLOCK             equ   9
ACTION_USE                equ  10
ACTION_GIVE               equ  11
ACTION_TALK_TO            equ  12
ACTION_TELL               equ  13
ACTION_BUY                equ  14
ACTION_LOOK               equ  15
ACTION_LOOK_AT            equ  16
ACTION_LOOK_THROUGH       equ  17
ACTION_ASK                equ  18
ACTION_EAT                equ  19
ACTION_DRINK              equ  20
ACTION_STATUS             equ  21
ACTION_GO_TO              equ  22
ACTION_RETURN             equ  23
ACTION_BRIBE              equ  24
ACTION_EXAMINE            equ  25

FLAG_RESTART              equ  10h
FLAG_CAUGHT               equ  20h
FLAG_RESTORERESTART       equ  40h
FLAG_HAS_FLOPPY_DRIVE     equ  80h


; Animation slot record constants
ANIM_X                    equ   0
ANIM_Y                    equ   2
ANIM_WIDTH                equ   4
ANIM_HEIGHT               equ   6
ANIM_FRAME_OFFSET         equ   8
ANIM_SEGMENT              equ  0Ah
ANIM_LAYER                equ  0Ch
ANIM_FLAGS                equ  0Dh
ANIM_ROOM_NUM             equ  0Eh
ANIM_CAN_UNLOAD           equ  10h
ANIM_TICK_PROC            equ  11h
ANIM_WIDTH_COPY           equ  13h
ANIM_HEIGHT_COPY          equ  15h
ANIM_Y_CORRECTION         equ  17h
ANIM_HOTSPOT_OFFSET       equ  19h
ANIM_HOTSPOT_ID           equ  1Bh
ANIM_SKIP                 equ  1Dh
ANIM_VOICE_CHAR_ID        equ  1Eh
ANIM_V20                  equ  20h
ANIM_CHAR_RECT_Y          equ  22h
ANIM_VOICE_CTR            equ  24h
ANIM_DIRECTION            equ  26h
ANIM_UNKNOWN1             equ  27h
ANIM_START_COLOUR         equ  28h

; Hotspot header record constants
HOTSPOT_TABLE_ENTRY_SIZE  equ   9
HSH_NAME                  equ   2
HSH_DESC                  equ   4
HSH_DESC_2                equ   6

; Hotspot record constants

HS_ACTIONS                equ   0
HS_FLAGS                  equ   3
HS_ACTIONS_OFFSET         equ  04h
HS_ROOM_NUM               equ  06h
HS_LOAD_FLAG              equ  08h
HS_LOAD_OFFSET            equ  09h
HS_ANIM_OFFSET            equ  0Bh
HS_X                      equ  0Dh
HS_Y                      equ  0Fh
HS_WIDTH                  equ  11h
HS_HEIGHT                 equ  13h
HS_LAYER                  equ  15h
HS_TICK_PROC              equ  17h
HS_WIDTH_COPY             equ  19h
HS_HEIGHT_COPY            equ  1Bh
HS_Y_CORRECTION           equ  1Dh
HS_FRAME_CTR              equ  1Fh
HS_PIXEL_OFFSET           equ  21h
HS_START_COLOUR           equ  23h
HS_SCRIPT_OFFSET          equ  24h
HS_MOVEMENT_OFFSET        equ  24h
HS_STEP_CTR               equ  26h
HS_FRAME_OFFSET           equ  28h
HS_ACTION_CTR             equ  2Ah
HS_V2B                    equ  2Bh
HS_HOTSPOT_SCRIPT_ID      equ  2Dh
HS_USE_HOTSPOT_ID         equ  2Fh
HS_V33                    equ  33h
HS_TALK_X                 equ  35h
HS_TALK_Y                 equ  36h
HS_TALK_COUNTDOWN         equ  37h
HS_TALK_CHAR_ID           equ  39h
HS_RESPONSE_ID            equ  3Ch
HS_V3E                    equ  3Eh
HS_V40                    equ  40h
HS_DELAY_CTR              equ  42h
HS_CHAR_MODE              equ  44h
HS_TICK_SCRIPT_OFFSET     equ  45h
HS_USE2_HOTSPOT_ID        equ  47h
HS_PATHFIND_COVERED       equ  49h
HS_V4A                    equ  4Ah
HS_BLOCKED_FLAG           equ  4Ch
HS_V4D                    equ  4Dh
HS_V4E                    equ  4Eh
HS_DIRECTION              equ  50h
HS_DEST_HOTSPOT           equ  52h
HS_DEST_X                 equ  54h
HS_DEST_Y                 equ  56h
HS_V58                    equ  58h
HS_MOVEMENT_SRC_OFFSET    equ  5Ah
HS_BLOCKED_SUPPORT_OFFSET equ  5Eh
HS_EXIT_CTR               equ  60h
HS_ACTION_OFFSET          equ  61h
HS_FIRST_ACTION_OFFSET    equ  63h

; Pixel record constants
PIXEL_DISK_ID             equ   0
PIXEL_FLAGS               equ   2
PIXEL_DATA_SEGMENT        equ   3
PIXEL_DATA_SIZE           equ   5
PIXEL_FRAME_SIZE          equ   7
PIXEL_MOVEREC_UP          equ   9
PIXEL_MOVEREC_DOWN        equ   0Bh
PIXEL_MOVEREC_LEFT        equ   0Dh
PIXEL_MOVEREC_RIGHT       equ   0Fh
PIXEL_FRAMENUM_UP         equ   11h
PIXEL_FRAMENUM_DOWN       equ   12h
PIXEL_FRAMENUM_LEFT       equ   13h
PIXEL_FRAMENUM_RIGHT      equ   14h

PIXELFLAG_HAS_TABLE       equ   4

NOONE_HOTSPOT_ID          equ  3E7h
PLAYER_HOTSPOT_ID         equ  3E8h
RATPOUCH_HOTSPOT_ID       equ  3E9h
SKORL_HOTSPOT_ID          equ  3EAh
FIRST_OBJECT_HOTSPOT_ID   equ  408h


; Room exit record constants
ROOMEXIT_RECORD_SIZE      equ  14
ROOMEXIT_X_START          equ  0
ROOMEXIT_X_END            equ  2
ROOMEXIT_Y_START          equ  4
ROOMEXIT_Y_END            equ  6
ROOMEXIT_CURSOR_NUM       equ  8
ROOMEXIT_HOTSPOT_ID       equ  10
ROOMEXIT_DEST_ROOM        equ  12

; Room exit hotspot record constants
REHS_RECORD_SIZE          equ  11h
REHS_HOTSPOT1_ID            equ  0
REHS_HOTSPOT1_CURRENT_FRAME equ  2
REHS_HOTSPOT1_DEST_FRAME    equ  3
REHS_HOTSPOT2_ID            equ  6
REHS_HOTSPOT2_CURRENT_FRAME equ  8
REHS_HOTSPOT2_DEST_FRAME    equ  9
REHS_EXIT_BLOCKED           equ  0Ch
REHS_HOTSPOT1_OFFSET        equ  0Dh
REHS_HOTSPOT2_OFFSET        equ  0Fh

; Room header record constants
RH_ROOM_NUM               equ  2
RH_DESC_ID                equ  4
RH_TABLE_ENTRY_SIZE       equ  9

; Room record constants
ROOM_NUM_LAYERS           equ  8
ROOM_FIRST_LAYER          equ  9
ROOM_SEQUENCE_OFFSET      equ  11h
ROOM_ENTRY_TIME           equ  13h
ROOM_V17                  equ  17h
ROOM_BOUNDS_INDEX         equ  18h
ROOM_X_START              equ  19h
ROOM_X_END                equ  1Bh
ROOM_EXITS_START          equ  1Dh

; Room exit constants for room exit list within room records
ROOMREC_EXIT_X_START          equ  0
ROOMREC_EXIT_X_END            equ  2
ROOMREC_EXIT_Y_START          equ  4
ROOMREC_EXIT_Y_END            equ  6
ROOMREC_EXIT_SEQUENCE         equ  8
ROOMREC_EXIT_ROOM_NUM         equ  10
ROOMREC_EXIT_NEW_X            equ  12
ROOMREC_EXIT_NEW_Y            equ  14

; Room number constants
ROOMNUM_TOWN_HALL         equ  1fh
ROOMNUM_MIDDLE_STREET     equ  0Eh
ROOMNUM_VILLAGE_SHOP      equ  23h
ROOMNUM_WINE_CELLAR       equ  2Ah
ROOMNUM_DINING_HALL       equ  2Dh

NUM_DELAY_ENTRIES         equ  28h
DELAY_ENTRY_SIZE          equ  7

DIR_UP       equ  80h
DIR_DOWN     equ  40h
DIR_LEFT     equ  20h
DIR_RIGHT    equ  10h

FACING_UP     equ   0
FACING_DOWN   equ   1
FACING_LEFT   equ   2
FACING_RIGHT  equ   3

FACING2_LEFT  equ   1
FACING2_RIGHT equ   2
FACING2_UP    equ   4
FACING2_DOWN  equ   8

; Movement record constants
MOVEMENT_FRAME_NUM  equ  0
MOVEMENT_X_CHANGE   equ  2
MOVEMENT_Y_CHANGE   equ  4
MOVEMENT_REC_SIZE   equ  6

; Talk constants
TALK_PRE_SEQUENCE   equ  0
TALK_DESC_ID        equ  2
TALK_POST_SEQUENCE  equ  4

; Talk state constants
TALK_START        equ  0ffh
TALK_SELECT       equ  2
TALK_UNKNOWN      equ  3
TALK_MAGIC_ID     equ  424h

TALK_DIALOG_WIDTH   equ  128

; Player actions used in player_tick_proc
CURRENT_ACTION_RECORD_SIZE   equ  5
CURRENT_ACTION_SUPPORT_TABLE equ  1
CURRENT_ACTION_ROOM_NUM      equ  3

CHAR_ACTION_NONE             equ  0
CHAR_ACTION_START_WALK       equ  1
CHAR_ACTION_DISPATCH_ACTION  equ  2
CHAR_ACTION_EXEC_SCRIPT      equ  3
CHAR_ACTION_PROCESSING_PATH  equ  4
CHAR_ACTION_CONTINUE_WALK    equ  5

PATHFIND_CHARACTER_ID   equ   2
PATHFIND_HS4C           equ   4
PATHFIND_DEST_STATE     equ   5
PATHFIND_DEST_X         equ   6
PATHFIND_DEST_Y         equ   8
PATHFIND_X              equ  0Ch
PATHFIND_Y              equ  0Ah
PATHFIND_0E             equ  0Eh
PATHFIND_DEST_X2        equ  10h
PATHFIND_DEST_OCCUPIED  equ  12h
PATHFIND_CELL_POPULATED equ  13h
PATHFIND_X_CHANGE1      equ  14h
PATHFIND_Y_CHANGE1      equ  16h
PATHFIND_X_CHANGE2      equ  18h
PATHFIND_Y_CHANGE2      equ  1Ah

WALKTO_RECORD_SIZE      equ  6
WALKTO_HOTSPOT_ID       equ  0
WALKTO_X                equ  2
WALKTO_Y                equ  4

; State values for the cursor_state variable
CURSORSTATE_NONE        equ  0
CURSORSTATE_ACTION      equ  1
CURSORSTATE_SEQUENCE    equ  2
CURSORSTATE_TALK        equ  3
CURSORSTATE_BUMPED      equ  4

; Character modes
CHARMODE_NONE           equ  0
CHARMODE_1              equ  1
CHARMODE_IDLE           equ  2
CHARMODE_PAUSED         equ  3
CHARMODE_4              equ  4
CHARMODE_CONVERSING     equ  5
CHARMODE_6              equ  6
CHARMODE_7              equ  7              
CHARMODE_8              equ  8

                                ;------------------------------------------------------------  seg_code   ----

                                seg_code        segment byte public
                                                assume cs:seg_code  , ds:seg_code , ss:stack_seg_k


                                ;
                                ;
                                ;                       Program Entry Point
                                ;
                                ;


                                lure            proc    far

273F:0000                       start:

273F:0000  B8 31E4                              mov     ax, data_seg
273F:0003  8E D8                                mov     ds, ax
273F:0005  E8 04AE                              call    initialise              ; (04B6)
273F:0008                       loc_5:                                          ;  xref 273F:0171
273F:0008 B8 23FC                              mov     ax, offset startup_sequence
273F:000B  E8 3E26                              call    sequence_execute
273F:000E  80 26 11D0 FE                        and     menubar_state, 0FEh ; (273F:11D0=56h)
273F:0013  E8 1F49                              call    show_disk_cursor
273F:0016  EB 59                                jmp     short loc_10            ; (0071)

; The following code is jumped to if the game is to be restarted or the room changes

273F:0018                       loc_6:                                          ;  xref 273F:0135, 0149
273F:0018 C6 06 38B0 01                        mov     data_781, 1 
273F:001D  E8 1F3F                              call    show_disk_cursor
273F:0020  FF 16 0766                           call    word ptr ds:[fade_out_proc]
273F:0024  E8 4818                              call    sub_115                 ; (483F)
273F:0027  E8 10BE                              call    hotspots_unload         ; Disable unneeded hotspots
273F:002A  83 3E BAAD 01                        cmp     script_val_82, 1
273F:002F  72 0A                                jb      loc_8                   ; Jump if below
273F:0031  75 05                                jnz     loc_7                   ; Jump if not zero
273F:0033  E8 A576                              call    sub_261                 ; (A5AC)
273F:0036  EB 03                                jmp     short loc_8             ; (003B)
273F:0038                       loc_7:                                          ;  xref 273F:0031
273F:0038  E8 A680                              call    sub_263                 ; (A6BB)
273F:003B                       loc_8:                                          ;  xref 273F:002F, 0036
273F:003B  C7 06 BAAD 0000                      mov     word ptr ds:data_490e,0 ; (273F:BAAD=0)
273F:0041  C6 06 9837 00                        mov     talk_dialog_active, 0
273F:0046  C7 06 9838 0000                      mov     data_431,0              ; (273F:9838=5C8Bh)
273F:004C  A1 9832                              mov     ax, room_number
273F:004F  E8 0C98                              call    get_room_resource_pointer2
273F:0052  A1 B0AA                              mov     ax, game_time_ctr
273F:0055  89 44 13                             mov     [si+ROOM_EXIT_TIME], ax
273F:0058  F7 06 BA23 FFFF                      test    new_room_number, 0FFFFh
273F:005E  74 08                                jz      loc_9                   ; Jump if zero
273F:0060  A1 BA23                              mov     ax, new_room_number
273F:0063  A3 9832                              mov     room_number, ax
273F:0066  EB 09                                jmp     short loc_10            ; (0071)
273F:0068                       loc_9:                                          ;  xref 273F:005E
273F:0068  A1 982C                              mov     ax, new_room_number_2
273F:006B  A3 9832                              mov     room_number, ax
273F:006E  E8 6004                              call    player_change_room      ; Position player in new room

273F:0071                       loc_10:                                         ;  xref 273F:0016, 0066
273F:0071  E8 A046                              call    sub_249                 ; (A0BA)
273F:0074  E8 08D7                              call    clear_layer_rects
273F:0077  E8 08F5                              call    room_load_layers
273F:007A  E8 760F                              call    sub_189                 ; (768C)
273F:007D  FF 16 074E                           call    word ptr ds:[74Eh]      ; (273F:074E=8010h)
273F:0081  E8 0963                              call    sub_16                  ; (09E7)
273F:0084  E8 0A77                              call    sub_19                  ; (0AFE)
273F:0087  E8 6F7B                              call    menubar_clear_image
273F:008A  8B 1E 9832                           mov     bx, room_number
273F:008E  89 1E BA15                           mov     room_number_2, bx
273F:0092  E8 0C53                              call    get_room_resource_pointer
273F:0095  8B 44 11                             mov     ax, [si+ROOM_SEQUENCE_OFFSET] ; Get sequence offset
273F:0098  3D FFFF                              cmp     ax, 0FFFFh              ; Is one defined?
273F:009B  74 03                                je      loc_11                  ; If no, skip execution
273F:009D  E8 3D94                              call    sequence_execute        ; Exeecute room script

273F:00A0  E8 0BDF              loc_11:         call    hotspots_load
273F:00A3  E8 4738                              call    sub_113                 ; (47DE)
273F:00A6  E8 6038                              call    sub_138                 ; (60E1)
273F:00A9  E8 1462                              call    room_add_animations
273F:00AC  E8 08B2                              call    clear_info_table
273F:00AF  E8 40E4                              call    animation_tick

273F:00B2                       loc_12:                                         ;  xref 273F:00C3
273F:00B2  80 26 11D0 F7                        and     menubar_state, 0F7h
273F:00B7  FF 16 0752                           call    [menubar_restore_area]
273F:00BB  E8 1450                              call    room_add_animations
273F:00BE  F6 06 11D0 08                        test    menubar_state, 8
273F:00C3  75 ED                                jnz     loc_12                  ; Jump if not zero

; Copy the completed room from the off-screen buffer data_segment2 to the screen

273F:00C5  FF 16 0744                           call    [show_screen_proc]      ; Copy screen over
273F:00C9  E8 39E2                              call    replace_vga_palette     ; Reset palette
273F:00CC  FF 16 0760                           call    word ptr [fade_in_proc] ; Fade in the screen
273F:00D0  E8 1EA2                              call    show_arrow_cursor

273F:00D3  33 C0                                xor     ax, ax                  ; Zero register
273F:00D5  A3 BA23                              mov     new_room_number, ax     ; Clear room change variable
273F:00D8  A2 38B0                              mov     data_781, al
273F:00DB  A2 11DA                              mov     mouse_buttons2, al
273F:00DE  A3 983F                              mov     data_1090, ax
273F:00E1  A3 9841                              mov     data_1091, ax
273F:00E4  A2 983A                              mov     data_432, al
273F:00E7  E8 1F1A                              call    sub_61             
273F:00EA  F7 06 6CE4 FFFF                      test    word ptr ds:[6CE4h],0FFFFh ; (273F:6CE4=0C18Bh)
273F:00F0  75 03                                jnz     loc_13                  ; Jump if not zero
273F:00F2  E9 9667                              jmp     loc_1855                ; (975C)

; Main in game loop

273F:00F5                       loc_13:                                         ;  xref 273F:00F0, 0147, 0167, 9782
273F:00F5 83 06 B0AA 01                        add     game_time_ctr, 1
273F:00FA  83 16 B0AC 00                        adc     game_time_ctr_2, 0
273F:00FF  C6 06 00B0 00                        mov     data_525, 0
273F:0104  E8 92C1                              call    room_check_keypresses
273F:0107  E8 4306                              call    sub_96                  ; Talking countdown proc
273F:010A  E8 1B05                              call    room_check_cursors
273F:010D  E8 1189                              call    room_handle_click
273F:0110  E8 4083                              call    animation_tick
273F:0113  E8 618B                              call    handle_talking
273F:0116  E8 4741                              call    sequence_delay_check
273F:0119  FF 16 0752                           call    [menubar_restore_area]
273F:011D  E8 13EE                              call    room_add_animations
273F:0120  FF 16 0744                           call    [show_screen_proc]
273F:0124  B8 0004                              mov     ax, 4                   ; Wait for four cycles
273F:0127  E8 4892                              call    room_sleep
273F:012A  E8 138B                              call    set_vga_palette
273F:012D  F7 06 BA23 FFFF                      test    new_room_number, 0FFFFh ; Need to change room?
273F:0133  74 03                                jz      loc_14
273F:0135  E9 FEE0                              jmp     loc_6                   ; Yes, so go do so
273F:0138                       loc_14:
273F:0138  F6 06 073D 10                        test    status_flags2, FLAG_RESTART ; Need to restart?
273F:013D  75 0D                                jnz     loc_16                      ; Yes, so do so
273F:013F  F7 06 982C FFFF                      test    new_room_number_2, 0FFFFh
273F:0145  75 02                                jnz     loc_15                  ; Jump if not zero
273F:0147  EB AC                                jmp     short loc_13            ; Normal in-game loop

273F:0149                       loc_15:
273F:0149  E9 FECC                              jmp     loc_6                   ; Jump to restart
273F:014C                       loc_16:
273F:014C  F6 06 073D 20                        test    status_flags2, FLAG_CAUGHT
273F:0151  74 03                                jz      loc_17                  ; Jump if zero
273F:0153  E8 A507                              call    skorl_knockout
273F:0156                       loc_17:                                         ;  xref 273F:0151
273F:0156  F6 06 073D 40                        test    status_flags2, FLAG_RESTORERESTART
273F:015B  74 0C                                jz      loc_18                  ; Jump if zero
273F:015D  E8 91D6                              call    sub_228                 ; Show restore/restart dialog
273F:0160  75 0A                                jnz     loc_19                  ; Jump if not zero
273F:0162  80 26 073D 8F                        and     status_flags2, 8Fh
273F:0167  EB 8C                                jmp     short loc_13            ; (00F5)
273F:0169                       loc_18:                                         ;  xref 273F:015B
273F:0169  E8 921F                              call    sub_229                 ; (938B)
273F:016C                       loc_19:                                         ;  xref 273F:0160
273F:016C  80 26 073D 8F                        and     status_flags2, 8Fh      ; Clear status flags
273F:0171  E9 FE94                              jmp     loc_5

                                lure            endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:024F, 030A
                                ;

273F:0174                       open_file       proc    near
273F:0174  F6 06 00B5 80                        test    byte ptr ds:[file_handle+1],80h  ; (273F:00B5=11h)
273F:0179  75 0D                                jnz     loc_20                           ; Jump if not zero
273F:017B  8B 1E 00B4                           mov     bx,word ptr ds:[file_handle]     ; (273F:00B4=11D0h)
273F:017F  B4 3E                                mov     ah,3Eh
273F:0181  CD 21                                int     21h                     ; DOS Services  ah=function 3Eh
                                                                                ;  close file, bx=file handle
273F:0183  C6 06 00B5 80                        mov     byte ptr ds:[file_handle+1],80h  ; (273F:00B5=11h)
273F:0188                       loc_20:                                                  ;  xref 273F:0179
273F:0188  8A 1E 00B1                           mov     bl,byte ptr ds:[file_number]     ; (273F:00B1=40h)
273F:018C  32 FF                                xor     bh,bh                   ; Zero register
273F:018E  D0 E3                                shl     bl,1                    ; Shift w/zeros fill
273F:0190  8B 97 00B6                           mov     dx,word ptr ds:[file_offset_table][bx] 
273F:0194  B8 3D00                              mov     ax,3D00h
273F:0197  CD 21                                int     21h                     ; DOS Services  ah=function 3Dh
                                                                                ;  open file, al=mode,name@ds:dx
273F:0199  72 58                                jc      loc_22                  ; Jump if carry Set
273F:019B  2E: F6 06 0943 FF                    test    byte ptr cs:critical_error,0FFh      ; (273F:0943=0)
273F:01A1  75 50                                jnz     loc_22                         ; Jump if not zero
273F:01A3  A3 00B4                              mov     word ptr ds:[file_handle],ax   ; (273F:00B4=11D0h)
273F:01A6  8B D8                                mov     bx,ax
273F:01A8  B9 0008                              mov     cx,8
273F:01AB BA 0119                              mov     dx, offset file_buffer  ; 273F:0119
273F:01AE  B4 3F                                mov     ah,3Fh
273F:01B0  CD 21                                int     21h                     ; DOS Services  ah=function 3Fh
                                                                                ;  read file, bx=file handle
                                                                                ;   cx=bytes to ds:dx buffer
273F:01B2  2E: F6 06 0943 FF                    test    byte ptr cs:critical_error,0FFh   ; (273F:0943=0)
273F:01B8  75 35                                jnz     loc_21                            ; Validate file ident string
273F:01BA  81 3E 0119 6568                      cmp     word ptr ds:[file_buffer],6568h   ; 'he'
273F:01C0  75 2D                                jne     loc_21                            ; Jump if not equal
273F:01C2  81 3E 011B 7779                      cmp     word ptr ds:[file_buffer+2],7779h ; 'yw'
273F:01C8  75 25                                jne     loc_21                            ; Jump if not equal
273F:01CA  81 3E 011D 776F                      cmp     word ptr ds:[file_buffer+4],776Fh ; 'ow'
273F:01D0  75 1D                                jne     loc_21                            ; Jump if not equal
273F:01D2  A1 011F                              mov     ax,word ptr ds:[file_filenum]     ; Get in the file number
273F:01D5  3A 26 00B1                           cmp     ah,byte ptr ds:[file_number]   ; (273F:00B1=40h)
273F:01D9  75 14                                jne     loc_21                         ; Jump if not equal

273F:01DB  B9 05F8                              mov     cx, sizeof file_entries
273F:01DE BA 0121                              mov     dx, offset file_entries
273F:01E1  B4 3F                                mov     ah,3Fh
273F:01E3  CD 21                                int     21h                     ; DOS Services  ah=function 3Fh
                                                                                ;  read file, bx=file handle
                                                                                ;   cx=bytes to ds:dx buffer
273F:01E5  2E: F6 06 0943 FF                    test    byte ptr cs:critical_error,0FFh ; (273F:0943=0)
273F:01EB  75 02                                jnz     loc_21                  ; Jump if not zero
273F:01ED  F8                                   clc                             ; Clear carry flag
273F:01EE  C3                                   retn
273F:01EF                       loc_21:                                         ;  xref 273F:01B8, 01C0, 01C8, 01D0
                                                                                ;            01D9, 01EB
273F:01EF  B4 3E                                mov     ah,3Eh
273F:01F1  CD 21                                int     21h                     ; DOS Services  ah=function 3Eh
                                                                                ;  close file, bx=file handle
273F:01F3                       loc_22:                                         ;  xref 273F:0199, 01A1
273F:01F3  2E: C6 06 0943 00                    mov     byte ptr cs:critical_error,0  ; (273F:0943=0)
273F:01F9  F9                                   stc                             ; Set carry flag
273F:01FA  C3                                   retn
                                open_file       endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:0974, 768C
                                ;

273F:01FB            read_and_validate_header   proc    near
273F:01FB                       loc_23:                                         ;  xref 273F:02B1, 02DC
273F:01FB C6 06 00B0 01                        mov     data_525, 1
273F:0200  F6 06 00B5 80                        test    byte ptr ds:[file_handle+1],80h  ; (273F:00B5=11h)
273F:0205  75 42                                jnz     loc_24                           ; Jump if not zero
273F:0207  C7 06 0119 0000                      mov     word ptr ds:[file_buffer],0      ; (273F:0119=16FFh)

; Read in the file header, that includes the ident string, file number, and entries table

273F:020D  1E                                   push    ds
273F:020E  07                                   pop     es
273F:020F  BA 0119                              mov     dx, offset file_buffer
273F:0212  BB 0000                              mov     bx,0
273F:0215  B9 0600                              mov     cx, FILE_BUFFER_SIZE
273F:0218  33 ED                                xor     bp,bp                           ; Zero register
273F:021A  E8 022D                              call    read_file_entry                 ; (044A)
273F:021D  72 2A                                jc      loc_24                          ; Jump if carry Set
273F:021F  2E: F6 06 0943 FF                    test    byte ptr cs:critical_error,0FFh ; Check if any error occurred
273F:0225  75 22                                jnz     loc_24                          ; Jump if not zero

; Validate that the file starts with the correct identifier string

273F:0227  A1 0119                              mov     ax,word ptr ds:[file_buffer]    ; Validate file ident string
273F:022A  3D 6568                              cmp     ax,6568h                        ; 'he'
273F:022D  75 1A                                jne     loc_24
273F:022F  A1 011B                              mov     ax,word ptr ds:[file_buffer+2]
273F:0232  3D 7779                              cmp     ax,7779h                        ; 'yw'
273F:0235  75 12                                jne     loc_24
273F:0237  A1 011D                              mov     ax,word ptr ds:[file_buffer+4]
273F:023A  3D 776F                              cmp     ax,776Fh                        ; 'ow'
273F:023D  75 0A                                jne     loc_24                  ; Jump if not equal
273F:023F  A1 011F                              mov     ax,word ptr ds:[11Fh]   ; (273F:011F=0FF13h)

273F:0242  3A 26 00B1                           cmp     ah,byte ptr ds:[file_number]   ; (273F:00B1=40h)
273F:0246  75 01                                jne     loc_24                  ; Jump if not equal
273F:0248  C3                                   retn

; If execution reaches this point, then some sort of error occurred

273F:0249                       loc_24:                                         ;  xref 273F:0205, 021D, 0225, 022D
                                                                                ;            0235, 023D, 0246, 0301
273F:0249 2E: C6 06 0943 00                    mov     byte ptr cs:critical_error,0
273F:024F  E8 FF22                              call    open_file                      ; Try to reopen file
273F:0252  73 68                                jnc     loc_ret_30                     ; Jump if no error occurred

273F:0254  80 3E 0786 02                        cmp     byte ptr ds:[drive_number],2   ; Is current drive C?
273F:0259  72 19                                jb      loc_25                         ; Jump if it's a floppy drive

273F:025B  A1 00B2                              mov     ax,word ptr ds:[drive_num]     ; (273F:00B2=2680h)
273F:025E  E8 00A3                              call    open_file2
273F:0261  73 51                                jnc     loc_29
273F:0263  F6 06 073D 80                        test    status_flags2, FLAG_HAS_FLOPPY_DRIVE
273F:0268  75 1B                                jnz     loc_27
273F:026A  83 36 00B2 01                        xor     word ptr ds:[drive_num], 1
273F:026F  A1 00B2                              mov     ax,word ptr ds:[drive_num]
273F:0272  EB 0C                                jmp     short loc_26              

; At this point, we know that the current drive is either A or B (ie. a floppy drive)
273F:0274                       loc_25:
273F:0274  F6 06 073D 80                        test    status_flags2, FLAG_HAS_FLOPPY_DRIVE
273F:0279  75 0A                                jnz     loc_27                  
273F:027B  A0 0786                              mov     al,byte ptr ds:[drive_number]
273F:027E  34 01                                xor     al,1
273F:0280                       loc_26:                                         ;  xref 273F:0272
273F:0280  E8 0081                              call    open_file2              ; (0304)
273F:0283  73 2F                                jnc     loc_29                  ; Jump if carry=0
273F:0285                       loc_27:                                         ;  xref 273F:0268, 0279
273F:0285  8A 16 0786                           mov     dl,byte ptr ds:[drive_number]   ; (273F:0786=0E8h)
273F:0289  B4 0E                                mov     ah,0Eh
273F:028B  CD 21                                int     21h                     ; DOS Services  ah=function 0Eh
                                                                                ;  set default drive dl  (0=a:)
; Display a message to insert the correct disk in the floppy drive
273F:028D  A0 00B1                              mov     al,byte ptr ds:[file_number]   ; (273F:00B1=40h)
273F:0290  2C 01                                sub     al,1
273F:0292  D0 E8                                shr     al,1                    ; Shift w/zeros fill
273F:0294  04 04                                add     al,4
273F:0296  32 E4                                xor     ah,ah                   ; Zero register
273F:0298  B6 00                                mov     dh,0
273F:029A  E8 3D07                              call    display_message         ; (3FA4)
273F:029D  3C 1B                                cmp     al,1Bh
273F:029F  75 08                                jne     loc_28                  ; Jump if not equal
273F:02A1  B8 0000                              mov     ax,0
273F:02A4  B6 01                                mov     dh,1
273F:02A6  E8 3CFB                              call    display_message         ; (3FA4)
273F:02A9                       loc_28:                                         ;  xref 273F:029F
273F:02A9  8A 16 0786                           mov     dl,byte ptr ds:[drive_number]  ; (273F:0786=0E8h)
273F:02AD  B4 0E                                mov     ah,0Eh
273F:02AF  CD 21                                int     21h                     ; DOS Services  ah=function 0Eh
                                                                                ;  set default drive dl  (0=a:)
273F:02B1  E9 FF47                              jmp     loc_23                  ; (01FB)
273F:02B4                       loc_29:                                         ;  xref 273F:0261, 0283
273F:02B4  8A 16 0786                           mov     dl,byte ptr ds:[drive_number]   ; (273F:0786=0E8h)
273F:02B8  B4 0E                                mov     ah,0Eh
273F:02BA  CD 21                                int     21h                     ; DOS Services  ah=function 0Eh
                                                                                ;  set default drive dl  (0=a:)

273F:02BC                       loc_ret_30:                                     ;  xref 273F:0252
273F:02BC  C3                                   retn
                     read_and_validate_header   endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:034C, 040E, 757C
                                ;

273F:02BD                   validate_header     proc    near
273F:02BD  B1 06                                mov     cl,6
273F:02BF  D2 EC                                shr     ah,cl                   ; Shift w/zeros fill
273F:02C1  80 E4 03                             and     ah,3
273F:02C4  80 C4 01                             add     ah,1
273F:02C7  80 3E 0742 02                        cmp     video_style, VIDEO_STYLE_EGA
273F:02CC  75 03                                jne     loc_31                  ; Jump if it's VGA
273F:02CE  80 C4 04                             add     ah,4
273F:02D1                       loc_31:                                         
273F:02D1  88 26 00B1                           mov     byte ptr ds:[file_number],ah   ; (273F:00B1=40h)
273F:02D5  F6 06 00B0 FF                        test    data_525, 0FFh
273F:02DA  75 03                                jnz     loc_32                  ; Jump if not zero
273F:02DC  E9 FF1C                              jmp     loc_23                  ; (01FB)
273F:02DF                       loc_32:                                         ;  xref 273F:02DA
273F:02DF  A1 0119                              mov     ax,word ptr ds:[file_buffer]   ; Validate file ident string
273F:02E2  3D 6568                              cmp     ax,6568h                       ; 'he'
273F:02E5  75 1A                                jne     loc_33                         ; Jump if not equal
273F:02E7  A1 011B                              mov     ax,word ptr ds:[file_buffer+2]
273F:02EA  3D 7779                              cmp     ax,7779h                       ; 'yw'
273F:02ED  75 12                                jne     loc_33                         ; Jump if not equal
273F:02EF  A1 011D                              mov     ax,word ptr ds:[file_buffer+4]
273F:02F2  3D 776F                              cmp     ax,776Fh                       ; 'ow'
273F:02F5  75 0A                                jne     loc_33                         ; Jump if not equal
273F:02F7  A1 011F                              mov     ax,word ptr ds:[file_filenum]  ; (273F:011F=0FF13h)
273F:02FA  3A 26 00B1                           cmp     ah,byte ptr ds:[file_number]   ; (273F:00B1=40h)
273F:02FE  75 01                                jne     loc_33                         ; Jump if not equal
273F:0300  C3                                   retn
273F:0301                       loc_33:                                         ;  xref 273F:02E5, 02ED, 02F5, 02FE

; Jumps to the error recovery code, which can open up the appropriate file and load it from scratch
273F:0301  E9 FF45                              jmp     loc_24                  ; (0249)
                            validate_header     endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:025E, 0280
                                ;

273F:0304                       open_file2      proc    near
273F:0304  8A D0                                mov     dl,al
273F:0306  B4 0E                                mov     ah,0Eh
273F:0308  CD 21                                int     21h                     ; DOS Services  ah=function 0Eh
                                                                                ;  set default drive dl  (0=a:)
273F:030A  E8 FE67                              call    open_file               ; (0174)
273F:030D  C3                                   retn
                                open_file2      endp

273F:030E  0000                 data_121        dw      0                       ;  xref 273F:0314, 03D5
273F:0310  0000                 data_122        dw      0                       ;  xref 273F:0318, 03D9
273F:0312  0000                 data_123        dw      0                       ;  xref 273F:031D, 03DE

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:0BDA, 3ACD, 3CA3, 7640, 7813, 7AC5, 7B63
                                ;                             7B80, 93A9, 9F6E, 9F8C, 9FB1, A302, A34F
                                ;                             A7C0, A7E2, A900, A9B3
                                ;

273F:0314                       read_entry      proc    near
273F:0314                       loc_34:                                         ;  xref 273F:03E3
273F:0314  2E: A3 030E                          mov     cs:data_121,ax          ; (273F:030E=0)
273F:0318  2E: 89 0E 0310                       mov     cs:data_122,cx          ; (273F:0310=0)
273F:031D  2E: 89 16 0312                       mov     cs:data_123,dx          ; (273F:0312=0)
273F:0322  8B D8                                mov     bx,ax
273F:0324  81 E3 3FFF                           and     bx,3FFFh
273F:0328  81 FB 0120                           cmp     bx,120h
273F:032C  74 11                                je      loc_35                  ; Jump if equal
273F:032E  81 FB 0311                           cmp     bx,311h
273F:0332  74 0B                                je      loc_35                  ; Jump if equal
273F:0334  83 FB 08                             cmp     bx,8
273F:0337  74 06                                je      loc_35                  ; Jump if equal
273F:0339  81 FB 0410                           cmp     bx,410h
273F:033D  75 0A                                jne     loc_36                  ; Jump if not equal
273F:033F                       loc_35:                                         ;  xref 273F:032C, 0332, 0337
                                                assume  ds:data_seg
273F:033F  F6 06 BAB9 FF                        test    byte ptr script_val_88, 0FFh
273F:0344  74 03                                jz      loc_36                  ; Jump if zero
273F:0346  80 F4 80                             xor     ah,80h
273F:0349                       loc_36:                                         ;  xref 273F:033D, 0344
273F:0349  51                                   push    cx
273F:034A  52                                   push    dx
273F:034B  50                                   push    ax
273F:034C  E8 FF6E                              call    validate_header         ; (02BD)
273F:034F  58                                   pop     ax
273F:0350  5A                                   pop     dx
273F:0351 BB 0119                              mov     bx,offset file_buffer   
273F:0354  B9 00C0                              mov     cx,0C0h                 ; Number of header entries + 1

273F:0357                       locloop_37:                                     ;  xref 273F:035E
273F:0357  3B 07                                cmp     ax,[bx]
273F:0359  74 0D                                je      loc_38                  ; Jump if equal
273F:035B  83 C3 08                             add     bx,8
273F:035E  E2 F7                                loop    locloop_37              ; Loop if cx > 0

273F:0360  B8 0009                              mov     ax,9                    ; 'Data file is corrupt.$'
273F:0363  B6 01                                mov     dh,1
273F:0365  E8 3C3C                              call    display_message         ; (3FA4)
273F:0368                       loc_38:                                         ;  xref 273F:0359
273F:0368  07                                   pop     es
273F:0369  8B 4F 04                             mov     cx,[bx+4]
273F:036C  8A 47 03                             mov     al,[bx+3]
273F:036F  32 E4                                xor     ah,ah                   ; Zero register
273F:0371  8B E8                                mov     bp,ax
273F:0373  FF 77 01                             push    word ptr [bx+1]

273F:0376  8B 5F 06                             mov     bx,[bx+6]
273F:0379  51                                   push    cx
273F:037A  55                                   push    bp
273F:037B  E8 00CC                              call    read_file_entry         ; (044A)
273F:037E  5D                                   pop     bp
273F:037F  B1 0C                                mov     cl,0Ch
273F:0381  D3 E5                                shl     bp,cl                   ; Shift w/zeros fill
273F:0383  59                                   pop     cx
273F:0384  8B D1                                mov     dx,cx
273F:0386  83 EA 01                             sub     dx,1
273F:0389  D1 EA                                shr     dx,1                    ; Shift w/zeros fill
273F:038B  D1 EA                                shr     dx,1                    ; Shift w/zeros fill
273F:038D  D1 EA                                shr     dx,1                    ; Shift w/zeros fill
273F:038F  D1 EA                                shr     dx,1                    ; Shift w/zeros fill
273F:0391  83 C2 01                             add     dx,1
273F:0394  03 D5                                add     dx,bp
273F:0396  5B                                   pop     bx
273F:0397  2E: F6 06 0943 FF                    test    byte ptr cs:critical_error,0FFh ; (273F:0943=0)
273F:039D  75 06                                jnz     loc_39                  ; Jump if not zero
273F:039F  C6 06 0118 00                        mov     byte ptr retry_count,0     ; (31E4:0118=0)
273F:03A4  C3                                   retn
273F:03A5                       loc_39:                                         ;  xref 273F:039D
273F:03A5  80 06 0118 01                        add     byte ptr retry_count,1     ; (31E4:0118=0)
273F:03AA  80 3E 0118 05                        cmp     byte ptr retry_count,5     ; (31E4:0118=0)
273F:03AF  72 19                                jb      loc_40                  ; Jump if below
273F:03B1  C6 06 0118 00                        mov     byte ptr retry_count,0     ; (31E4:0118=0)
273F:03B6  B8 0001                              mov     ax,1
273F:03B9  B6 00                                mov     dh,0
273F:03BB  E8 3BE6                              call    display_message         ; (3FA4)
273F:03BE  3C 1B                                cmp     al,1Bh
273F:03C0  75 08                                jne     loc_40                  ; Jump if not equal
273F:03C2  B8 0000                              mov     ax,0
273F:03C5  B6 01                                mov     dh,1
273F:03C7  E8 3BDA                              call    display_message         ; (3FA4)
273F:03CA                       loc_40:                                         ;  xref 273F:03AF, 03C0
273F:03CA  2E: C6 06 0943 00                    mov     byte ptr cs:critical_error,0  ; (273F:0943=0)
273F:03D0  C6 06 00B0 00                        mov     data_525, 0     
273F:03D5  2E: A1 030E                          mov     ax,cs:data_121          ; (273F:030E=0)
273F:03D9  2E: 8B 0E 0310                       mov     cx,cs:data_122          ; (273F:0310=0)
273F:03DE  2E: 8B 16 0312                       mov     dx,cs:data_123          ; (273F:0312=0)
273F:03E3  E9 FF2E                              jmp     loc_34                  ; (0314)
                                read_entry      endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:77F1, A7B4
                                ;

273F:03E6                    get_entry_size     proc    near
273F:03E6  8B D8                                mov     bx,ax
273F:03E8  81 E3 3FFF                           and     bx,3FFFh
273F:03EC  81 FB 0120                           cmp     bx,120h
273F:03F0  74 11                                je      loc_41                  ; Jump if equal
273F:03F2  81 FB 0311                           cmp     bx,311h
273F:03F6  74 0B                                je      loc_41                  ; Jump if equal
273F:03F8  83 FB 08                             cmp     bx,8
273F:03FB  74 06                                je      loc_41                  ; Jump if equal
273F:03FD  81 FB 0410                           cmp     bx,410h
273F:0401  75 0A                                jne     loc_42                  ; Jump if not equal
273F:0403                       loc_41:                                         ;  xref 273F:03F0, 03F6, 03FB
273F:0403  F6 06 BAB9 FF                        test    byte ptr script_val_88, 0FFh 
273F:0408  74 03                                jz      loc_42                  ; Jump if zero
273F:040A  80 F4 80                             xor     ah,80h
273F:040D                       loc_42:                                         ;  xref 273F:0401, 0408
273F:040D  50                                   push    ax
273F:040E  E8 FEAC                              call    validate_header         ; (02BD)
273F:0411  58                                   pop     ax
273F:0412 BB 0119                              mov     bx, offset file_buffer  ; (273F:0119=0FFh)
273F:0415  B9 00C0                              mov     cx,0C0h

273F:0418                       locloop_43:                                     ;  xref 273F:041F
273F:0418  3B 07                                cmp     ax,[bx]
273F:041A  74 0D                                je      loc_44                  ; Jump if equal
273F:041C  83 C3 08                             add     bx,8
273F:041F  E2 F7                                loop    locloop_43              ; Loop if cx > 0

273F:0421  B8 0009                              mov     ax,9                    ; 'Data file is corrupt.$'
273F:0424  B6 01                                mov     dh,1
273F:0426  E8 3B7B                              call    display_message         ; (3FA4)
273F:0429                       loc_44:                                         ;  xref 273F:041A
273F:0429  8A 4F 03                             mov     cl,[bx+3]
273F:042C  32 ED                                xor     ch,ch                   ; Zero register
273F:042E  8B E9                                mov     bp,cx
273F:0430  B1 0C                                mov     cl,0Ch
273F:0432  D3 E5                                shl     bp,cl                   ; Shift w/zeros fill
273F:0434  8B 4F 04                             mov     cx,[bx+4]
273F:0437  8B D1                                mov     dx,cx
273F:0439  83 EA 01                             sub     dx,1
273F:043C  D1 EA                                shr     dx,1                    ; Shift w/zeros fill
273F:043E  D1 EA                                shr     dx,1                    ; Shift w/zeros fill
273F:0440  D1 EA                                shr     dx,1                    ; Shift w/zeros fill
273F:0442  D1 EA                                shr     dx,1                    ; Shift w/zeros fill
273F:0444  83 C2 01                             add     dx,1
273F:0447  03 D5                                add     dx,bp
273F:0449  C3                                   retn
                             get_entry_size     endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:021A, 037B
                                ;



273F:044A                     read_file_entry   proc    near
273F:044A  1E                                   push    ds
273F:044B  51                                   push    cx
273F:044C  52                                   push    dx
273F:044D  B8 0020                              mov     ax,20h
273F:0450  F7 E3                                mul     bx                      ; dx:ax = reg * ax
273F:0452  8B CA                                mov     cx,dx
273F:0454  8B D0                                mov     dx,ax
273F:0456  51                                   push    cx
273F:0457  52                                   push    dx
273F:0458  B8 4200                              mov     ax,4200h
273F:045B  8B 1E 00B4                           mov     bx,word ptr ds:[file_handle]   ; (273F:00B4=11D0h)
273F:045F  CD 21                                int     21h                     ; DOS Services  ah=function 42h
                                                                                ;  move file ptr, bx=file handle
                                                                                ;   al=method, cx,dx=offset
273F:0461  72 3F                                jc      loc_47                  ; Jump if carry Set
273F:0463  5B                                   pop     bx
273F:0464  59                                   pop     cx
273F:0465  3B CA                                cmp     cx,dx
273F:0467  75 3B                                jne     loc_48                  ; Jump if not equal
273F:0469  3B C3                                cmp     ax,bx
273F:046B  75 37                                jne     loc_48                  ; Jump if not equal
273F:046D  8B 1E 00B4                           mov     bx,word ptr ds:[file_handle]   ; (273F:00B4=11D0h)
273F:0471  5A                                   pop     dx
273F:0472  D1 E5                                shl     bp,1                    ; Shift w/zeros fill
273F:0474                       loc_45:                                         ;  xref 273F:0490
273F:0474 83 ED 01                             sub     bp,1
273F:0477  72 19                                jc      loc_46                  ; Jump if carry Set
273F:0479  8C C0                                mov     ax,es
273F:047B  8E D8                                mov     ds,ax
273F:047D  05 0800                              add     ax,800h
273F:0480  8E C0                                mov     es,ax
273F:0482  B4 3F                                mov     ah,3Fh                  ; '?'
273F:0484  B9 8000                              mov     cx,8000h
273F:0487  CD 21                                int     21h                     ; DOS Services  ah=function 3Fh
                                                                                ;  read file, bx=file handle
                                                                                ;   cx=bytes to ds:dx buffer
273F:0489  72 1A                                jc      loc_49                  ; Jump if carry Set
273F:048B  3D 8000                              cmp     ax,8000h
273F:048E  75 15                                jne     loc_49                  ; Jump if not equal
273F:0490  EB E2                                jmp     short loc_45            ; (0474)
273F:0492                       loc_46:                                         ;  xref 273F:0477
273F:0492  59                                   pop     cx
273F:0493  06                                   push    es
273F:0494  1F                                   pop     ds
273F:0495  B4 3F                                mov     ah,3Fh
273F:0497  CD 21                                int     21h                     ; DOS Services  ah=function 3Fh
                                                                                ;  read file, bx=file handle
                                                                                ;   cx=bytes to ds:dx buffer
273F:0499  72 0B                                jc      loc_50                  ; Jump if carry Set
273F:049B  3B C1                                cmp     ax,cx
273F:049D  75 07                                jne     loc_50                  ; Jump if not equal
273F:049F  1F                                   pop     ds
273F:04A0  F8                                   clc                             ; Clear carry flag
273F:04A1  C3                                   retn
273F:04A2                       loc_47:                                         ;  xref 273F:0461
273F:04A2  58                                   pop     ax
273F:04A3  58                                   pop     ax
273F:04A4                       loc_48:                                         ;  xref 273F:0467, 046B
273F:04A4  58                                   pop     ax
273F:04A5                       loc_49:                                         ;  xref 273F:0489, 048E
273F:04A5  58                                   pop     ax
273F:04A6                       loc_50:                                         ;  xref 273F:0499, 049D
273F:04A6  1F                                   pop     ds
273F:04A7  F9                                   stc                             ; Set carry flag
273F:04A8  C3                                   retn
                              read_file_entry   endp

273F:04A9  00                                   db      0
273F:04AA  0000 0000       old_timer_int_proc   dw      0, 0                    ;  xref 273F:0699, 3FD2, 49A6
273F:04AE  0000 0000         old_kbd_int_proc   dw      0, 0                    ;  xref 273F:06F2, 4004, 94DC
273F:04B2  0000          old_critical_int_proc  dw      0, 0                       ;  xref 273F:06D1, 3FEB

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:0005
                                ;

273F:04B6                       initialise      proc    near
273F:04B6  E8 0314                              call    sub_10                  ; (07CD)
273F:04B9  E8 0447                              call    sub_12                  ; (0903)
273F:04BC  C7 06 5662 094D                      mov     play_music_proc, offset retf_proc
273F:04C2  8C 0E 5664                           mov     word ptr play_music_proc+2,cs
273F:04C6  F6 06 0742 FF                        test    video_style, 0FFh       ; Is any video mode defined
273F:04CB  74 07                                jz      loc_51                  ; Jump if zero
273F:04CD  80 3E 0742 02                        cmp     video_style, VIDEO_STYLE_EGA 
273F:04D2  74 20                                je      loc_53                  ; Jump if equal
273F:04D4                       loc_51:                                         ;  xref 273F:04CB
273F:04D4  B8 1A00                              mov     ax,1A00h
273F:04D7  CD 10                                int     10h                     ; Video display   ah=functn 1Ah
                                                                                ;  get display type in bx
273F:04D9  3C 1A                                cmp     al,1Ah
273F:04DB  75 0C                                jne     loc_52                  ; Function not supported
273F:04DD  80 FB 04                             cmp     bl,4                    ; EGA monitor
273F:04E0  74 12                                je      loc_53                  ; Jump if equal
273F:04E2  80 FB 08                             cmp     bl,8                    ; VGA with analog colour model
273F:04E5  75 10                                jne     loc_54                  ; Jump if not equal
273F:04E7  EB 16                                jmp     short loc_55            ; (04FF)

273F:04E9                       loc_52:                                         ;  xref 273F:04DB
273F:04E9  B4 12                                mov     ah,12h
273F:04EB  B3 10                                mov     bl,10h                  ; bl=Return Config Info
273F:04ED  CD 10                                int     10h                     ; Video display EGA/VGA special

273F:04EF  80 FB 10                             cmp     bl,10h                  ; Not supported
273F:04F2  74 03                                je      loc_54
273F:04F4                       loc_53:                                         ;  xref 273F:04D2, 04E0
273F:04F4  E9 00C9                              jmp     loc_56

; Computer doesn't support EGA or VGA 
273F:04F7                       loc_54:
273F:04F7  B8 0002                              mov     ax,2
273F:04FA  B6 01                                mov     dh,1
273F:04FC  E8 3AA5                              call    display_message

; Game will run in VGA mode
273F:04FF                       loc_55:
273F:04FF  C6 06 0743 13                        mov     video_mode, 13h                ; 3200x200x256 mode
273F:0504  C6 06 0742 01                        mov     video_style, VIDEO_STYLE_VGA   ; Flag for VGA mode
273F:0509  C7 06 0744 304E                      mov     show_screen_proc, offset vga_show_screen
273F:050F  C7 06 074A 0008                      mov     char_width, 8
273F:0515  C7 06 0746 FA00                      mov     screen_size, SCREEN_HEIGHT*SCREEN_WIDTH
273F:051B  C7 06 0748 0140                      mov     screen_width, SCREEN_WIDTH
273F:0521  C7 06 074C 0A00                      mov     menubar_block_size, MENUBAR_Y_SIZE*SCREEN_WIDTH
273F:0527  C7 06 074E 346D                      mov     data_555,346Dh          ; (31E4:074E=0)
273F:052D  C7 06 0750 3527                      mov     segment_screen_proc, vga_segment_screen
273F:0533  C7 06 0752 340F                      mov     show_compressed_screen_proc, offset vga_show_compressed_screen
273F:0539  C7 06 0754 37F2                      mov     add_animation_proc, offset vga_add_animation
273F:053F  C7 06 0756 33B3                      mov     draw_talk_dialog_proc, offset vga_draw_talk_dialog
273F:0545  C7 06 0758 3242                      mov     talk_dialog_proc, vga_talk_dialog
273F:054B  C7 06 075A 3209                      mov     display2_character_proc, offset vga_display2_character
273F:0551  C7 06 075C 3599                      mov     add_rect_proc, vga_add_rect
273F:0557  C7 06 075E 3664                      mov     show_cursor_proc, offset vga_cursor
273F:055D  C7 06 0766 30E2                      mov     fade_out_proc, offset vga_fade_out
273F:0563  C7 06 0760 3177                      mov     fade_in_proc, offset vga_fade_in
273F:0569  C7 06 0762 31D3                      mov     set_lower_palette_proc, offset vga_set_lower_palette
273F:056F  C7 06 0764 31E9                      mov     empty_palette_proc, offset vga_empty_palette
273F:0575  C7 06 076A 35F6                      mov     display_character_proc, offset vga_display_character
273F:057B  C7 06 076C 362D                      mov     menu_items_proc, offset vga_menu_items
273F:0581  C7 06 076E 1450                      mov     data_571, offset vga_unknown_rec
273F:0587  C7 06 0770 3948                      mov     data_572,3948h          ; (31E4:0770=0)
273F:058D  C7 06 0772 3AD7                      mov     toggle_menu_highlight_proc, offset vga_toggle_menu_highlight
273F:0593  C7 06 0774 07ED                      mov     data_574, offset vga_no_implementation
273F:0599  C7 06 0776 07ED                      mov     data_575, offset vga_no_implementation
273F:059F  C7 06 0778 3374                      mov     data_576,3374h          ; (31E4:0778=0)
273F:05A5  C7 06 077A 3295                      mov     draw_dialog_proc, offset vga_draw_dialog
273F:05AB  C7 06 077C 398A                      mov     decode_entry_proc, offset decode_file_entry
273F:05B1  C7 06 077E A7E6                      mov     copy_screen_proc, offset vga_copy_screen
273F:05B7  C7 06 0780 A711                      mov     pic_decode_proc, offset vga_pic_decode
273F:05BD  E9 00C4                              jmp     loc_57

; Game will run in EGA mode
273F:05C0                       loc_56:                                         ;  xref 273F:04F4
273F:05C0  C6 06 0743 0D                        mov     byte ptr video_mode,0Dh        ; 320x200x16 mode
273F:05C5  C6 06 0742 02                        mov     video_style, VIDEO_STYLE_EGA,2
273F:05CA  C7 06 0744 205C                      mov     show_screen_proc, offset ega_show_screen
273F:05D0  C7 06 074A 0004                      mov     char_width, 4
273F:05D6  C7 06 0746 7D00                      mov     screen_size, 7D00h
273F:05DC  C7 06 0748 00A0                      mov     screen_width, SCREEN_WIDTH/2
273F:05E2  C7 06 074C 0500                      mov     menubar_block_size, MENUBAR_Y_SIZE*SCREEN_WIDTH/2
273F:05E8  C7 06 074E 2814                      mov     data_555,2814h          ; (31E4:074E=0)
273F:05EE  C7 06 0750 270D                      mov     segment_screen_proc, ega_segment_screen
273F:05F4  C7 06 0752 27B1                      mov     show_compressed_screen_proc, offset ega_show_compressed_screen
;menubar_restore_area
273F:05FA  C7 06 0754 2C76                      mov     add_animation_proc, offset ega_add_animation
273F:0600  C7 06 0756 2275                      mov     draw_talk_dialog_proc, offset ega_draw_talk_dialog
273F:0606  C7 06 0758 2217                      mov     talk_dialog_proc, offset ega_talk_dialog
273F:060C  C7 06 075A 2184                      mov     display2_character_proc, 2184h
273F:0612  C7 06 075C 29A4                      mov     add_rect_proc, offset ega_add_layer
273F:0618  C7 06 075E 2AB3                      mov     show_cursor_proc, offset ega_cursor
273F:061E  C7 06 0768 07ED                      mov     data_568,07EDh
273F:0624  C7 06 0766 215F                      mov     fade_out_proc, offset ega_empty_palette
273F:062A  C7 06 0760 2174                      mov     fade_in_proc, offset ega_fade_in
273F:0630  C7 06 0762 2174                      mov     set_lower_palette_proc, offset ega_fade_in
273F:0636  C7 06 0764 215F                      mov     empty_palette_proc, ega_empty_palette
273F:063C  C7 06 076A 2A31                      mov     display_character_proc, offset ega_display_character
273F:0642  C7 06 076C 22C4                      mov     menu_items_proc, offset ega_menu_items
273F:0648  C7 06 076E 1444                      mov     data_571, offset ega_unknown_rec
273F:064E  C7 06 0770 2F9C                      mov     data_572,2F9Ch          ; (31E4:0770=0)
273F:0654  C7 06 0772 2FF3                      mov     toggle_menu_highlight_proc, offset ega_toggle_menu_highlight
273F:065A  C7 06 0774 2688                      mov     data_574,2688h          ; (31E4:0774=0)
273F:0660  C7 06 0776 26C7                      mov     data_575,26C7h          ; (31E4:0776=0)
273F:0666  C7 06 0778 23EA                      mov     data_576,23EAh          ; (31E4:0778=0)
273F:066C  C7 06 077A 2370                      mov     draw_dialog_proc, offset ega_draw_dialog
273F:0672  C7 06 077C 246A                      mov     decode_entry_proc, offset ega_decode_entry
273F:0678  C7 06 077E A80C                      mov     copy_screen_proc, offset ega_copy_screen
273F:067E  C7 06 0780 A75F                      mov     pic_decode_proc, offset ega_pic_decode

273F:0684                       loc_57:                                         ;  xref 273F:05BD
273F:0684  B4 30                                mov     ah,30h
273F:0686  CD 21                                int     21h                     ; DOS Services  ah=function 30h
                                                                                ;  get DOS version number ax
273F:0688  3C 01                                cmp     al,1                    ; At least DOS version 1.0?
273F:068A  7F 08                                jg      loc_58                  ; Jump if >
273F:068C  B8 0003                              mov     ax,3                    ; Bail out with DOS error message
273F:068F  B6 01                                mov     dh,1
273F:0691  E8 3910                              call    display_message

273F:0694                       loc_58:
273F:0694  B8 3508                              mov     ax,3508h                ; Get current timer handler address
273F:0697  CD 21                                int     21h                     ; DOS Services  ah=function 35h
                                                                                ;  get intrpt vector al in es:bx
273F:0699  2E: 89 1E 04AA                       mov     cs:old_timer_int_proc, bx
273F:069E  8C C0                                mov     ax,es
273F:06A0  2E: A3 04AC                          mov     word ptr cs:old_timer_int_proc+2,ax
273F:06A4  B8 2508                              mov     ax,2508h
273F:06A7  1E                                   push    ds
273F:06A8  0E                                   push    cs
273F:06A9  1F                                   pop     ds
273F:06AA BA 48C6                              mov     dx,offset timer_handler
273F:06AD  CD 21                                int     21h                     ; DOS Services  ah=function 25h
                                                                                ;  set intrpt vector al to ds:dx
273F:06AF  1F                                   pop     ds
273F:06B0  80 0E 073C 04                        or      status_flags, STATUS_TIMER_SET
273F:06B5  B9 5D38                              mov     cx,5D38h
273F:06B8  B0 36                                mov     al,36h                  ; '6'
273F:06BA  E6 43                                out     43h,al                  ; port 43h, 8253 timer control
273F:06BC  EB 00                                jmp     short $+2               ; delay for I/O
273F:06BE  EB 00                                jmp     short $+2               ; delay for I/O
273F:06C0  8A C1                                mov     al,cl
273F:06C2  E6 40                                out     40h,al                  ; port 40h, 8253 timer 0 clock
273F:06C4  EB 00                                jmp     short $+2               ; delay for I/O
273F:06C6  EB 00                                jmp     short $+2               ; delay for I/O
273F:06C8  8A C5                                mov     al,ch
273F:06CA  E6 40                                out     40h,al                  ; port 40h, 8253 timer 0 clock
273F:06CC  B8 3524                              mov     ax,3524h
273F:06CF  CD 21                                int     21h                     ; DOS Services  ah=function 35h
                                                                                ;  get intrpt vector al in es:bx
273F:06D1  2E: 89 1E 04B2                       mov     cs:old_critical_int_proc, bx
273F:06D6  8C C0                                mov     ax,es
273F:06D8  2E: A3 04B4                          mov     cs:old_critical_int_proc+2,ax
273F:06DC  B8 2524                              mov     ax,2524h
273F:06DF  1E                                   push    ds
273F:06E0  0E                                   push    cs
273F:06E1  1F                                   pop     ds
273F:06E2 BA 0944                              mov     dx,offset critical_handler ; Set new critical error handler
273F:06E5  CD 21                                int     21h                     ; DOS Services  ah=function 25h
                                                                                ;  set intrpt vector al to ds:dx
273F:06E7  1F                                   pop     ds
273F:06E8  80 0E 073C 10                        or      status_flags, STATUS_CRITICAL_SET
273F:06ED  B8 3509                              mov     ax,3509h
273F:06F0  CD 21                                int     21h                     ; DOS Services  ah=function 35h
                                                                                ;  get intrpt vector al in es:bx
273F:06F2  2E: 89 1E 04AE                       mov     cs:old_kbd_int_proc, bx
273F:06F7  8C C0                                mov     ax,es
273F:06F9  2E: A3 04B0                          mov     word ptr cs:old_kbd_int_proc+2, ax
273F:06FD  B8 2509                              mov     ax,2509h
273F:0700  1E                                   push    ds
273F:0701  0E                                   push    cs
273F:0702  1F                                   pop     ds
273F:0703 BA 94DB                              mov     dx,offset keyboard_handler ; Set new keyboard handler
273F:0706  CD 21                                int     21h                     ; DOS Services  ah=function 25h
                                                                                ;  set intrpt vector al to ds:dx
273F:0708  1F                                   pop     ds
273F:0709  80 0E 073C 40                        or      status_flags, STATUS_KEYBOARD_SET
273F:070E  B4 19                                mov     ah,19h
273F:0710  CD 21                                int     21h                     ; DOS Services  ah=function 19h
                                                                                ;  get default drive al  (0=a:)
273F:0712  A2 0786                              mov     default_drive, al 
273F:0715  CD 11                                int     11h                     ; Put equipment bits in ax
273F:0717  A8 C0                                test    al,0C0h                 ; How many floppy drives attached?
273F:0719  75 05                                jnz     loc_59                  ; Jump if not zero
273F:071B  80 0E 073D 80                        or      status_flags2, FLAG_HAS_FLOPPY_DRIVE
273F:0720                       loc_59:                                         ;  xref 273F:0719
273F:0720  B8 3300                              mov     ax,3300h
273F:0723  CD 21                                int     21h                     ; DOS Services  ah=function 33h
                                                                                ;  get ctrl-break flag in dl
273F:0725  88 16 073E                           mov     old_ctrl_break_flag, dl
273F:0729  B8 3301                              mov     ax,3301h
273F:072C  B2 00                                mov     dl,0
273F:072E  CD 21                                int     21h                     ; DOS Services  ah=function 33h
                                                                                ;  set ctrl-break flag dl=off/on
273F:0730  80 0E 073C 08                        or      status_flags, STATUS_CTRL_BREAK_SET
273F:0735  B8 0040                              mov     ax,40h
273F:0738  8E C0                                mov     es,ax
273F:073A  26: A0 0017                          mov     al,es:keybd_flags_1     ; (0040:0017=0)
273F:073E  A2 073F                              mov     data_546,al             ; (31E4:073F=1)
273F:0741  B4 0F                                mov     ah,0Fh
273F:0743  CD 10                                int     10h                     ; Video display   ah=functn 0Fh
                                                                                ;  get state, al=mode, bh=page
                                                                                ;   ah=columns on screen
273F:0745  A2 073B                              mov     data_542,al             ; (31E4:073B=0)
273F:0748  B4 00                                mov     ah,0
273F:074A  A0 0743                              mov     al,video_mode           ; (31E4:0743=0)
273F:074D  CD 10                                int     10h                     ; Video display   ah=functn 00h
                                                                                ;  set display mode in al
273F:074F  80 0E 073C 01                        or      status_flags, STATUS_VIDEO_MODE_SET
273F:0754  80 3E 0742 01                        cmp     video_style, VIDEO_STYLE_VGA
273F:0759  75 03                                jne     loc_60                  ; Jump if not equal
273F:075B  E8 3A27                              call    set_upper_vga_palette
273F:075E                       loc_60:                                         ;  xref 273F:0759
273F:075E  E8 6E1B                              call    show_startup            ; (757C)

273F:0761  C7 06 11D6 00A0                      mov     mouse_x2, 160           ; Default mouse pos to center
273F:0767  C7 06 11D1 00A0                      mov     mouse_x,  160
273F:076D  C7 06 11D8 0064                      mov     mouse_y2, 100
273F:0773  C7 06 11D3 0064                      mov     mouse_y,  100

273F:0779  B8 0000                              mov     ax,0
273F:077C  CD 33                                int     33h                     ; Mouse driver    ax=func 0000h
                                                                                ;  installed?, ax=0 no, =-1 yes
                                                                                ;   bx=number of mouse buttons
273F:077E  0B C0                                or      ax,ax                   ; Zero ?
273F:0780  74 45                                jz      loc_61                  ; Mouse not installed
273F:0782  1E                                   push    ds
273F:0783  0E                                   push    cs
273F:0784  07                                   pop     es
273F:0785 BA 1EE8                              mov     dx,offset mouse_handler
273F:0788  B9 007F                              mov     cx,7Fh
273F:078B  B8 000C                              mov     ax,0Ch
273F:078E  CD 33                                int     33h                     ; Mouse driver    ax=func 000Ch
                                                                                ;  set user handler at es:dx
                                                                                ;   cx=event mask
273F:0790  1F                                   pop     ds
273F:0791  80 0E 073C 80                        or      status_flags, STATUS_MOUSE_HANDLER_SET
273F:0796  B9 0000                              mov     cx,0
273F:0799  BA 027F                              mov     dx, 639
273F:079C  B8 0007                              mov     ax,7
273F:079F  CD 33                                int     33h                     ; Mouse driver    ax=func 0007h
                                                                                ;  set horz range 0 - 639
273F:07A1  B9 0000                              mov     cx,0
273F:07A4  BA 00C6                              mov     dx,0C6h
273F:07A7  B8 0008                              mov     ax,8
273F:07AA  CD 33                                int     33h                     ; Mouse driver    ax=func 0008h
                                                                                ;  set vert range 0 - 198
273F:07AC  B8 0003                              mov     ax,3
273F:07AF  CD 33                                int     33h                     ; Mouse driver    ax=func 0003h
                                                                                ;  get position, cx=horz,dx=vert
                                                                                ;   bx=mouse button status bits
273F:07B1  88 1E 11D5                           mov     mouse_buttons, bl       ; (31E4:11D5=0)
273F:07B5  D1 E9                                shr     cx,1                    ; Change 0-640 horiz to 0-320
273F:07B7  89 0E 11D6                           mov     mouse_x2,cx             ;
273F:07BB  89 0E 11D1                           mov     mouse_x, cx
273F:07BF  89 16 11D8                           mov     mouse_y2,dx
273F:07C3  89 16 11D3                           mov     mouse_y, dx
273F:07C7                       loc_61:                                         ;  xref 273F:0780
273F:07C7  80 26 11D0 FD                        and     menubar_state, 0FDh  ; (31E4:11D0=3)
273F:07CC  C3                                   retn

                                ; External Entry into Subroutine 
                                ;
                                ;         Called from:   273F:04B6, AA1E

273F:07CD                       sub_10:
273F:07CD  8C D3                                mov     bx,ss
273F:07CF  8C C0                                mov     ax,es
273F:07D1  2B D8                                sub     bx,ax
273F:07D3  8B C4                                mov     ax,sp
273F:07D5  B1 04                                mov     cl,4
273F:07D7  D3 E8                                shr     ax,cl                   ; Shift w/zeros fill
273F:07D9  03 D8                                add     bx,ax
273F:07DB  83 C3 03                             add     bx,3
273F:07DE  89 1E 0740                           mov     data_547,bx             ; (31E4:0740=0)
273F:07E2  B4 4A                                mov     ah,4Ah
273F:07E4  CD 21                                int     21h                     ; DOS Services  ah=function 4Ah
                                                                                ;  change memory allocation
                                                                                ;   bx=bytes/16, es=mem segment
273F:07E6  BB FFFF                              mov     bx,0FFFFh
273F:07E9  B4 48                                mov     ah,48h
273F:07EB  CD 21                                int     21h                     ; DOS Services  ah=function 48h
                                                                                ;  allocate memory, bx=bytes/16
273F:07ED              vga_no_implementation    retn

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:6614
                                ;

                                     sub_11     proc    near
273F:07EE  C6 06 38B0 01                        mov     data_781, 1
273F:07F3  80 0E 11D0 01                        or      menubar_state, 1   ; (273F:11D0=56h)
273F:07F8  FF 16 075E                           call    [show_cursor_proc]
273F:07FC  8C DD                                mov     bp,ds
273F:07FE  A1 4CE6                              mov     ax, talk_dialog_buffer
273F:0801  8E C0                                mov     es, ax
273F:0803  B1 03                                mov     cl,3
273F:0805  A1 11D8                              mov     ax, mouse_y2
273F:0808  A3 0784                              mov     saved_mouse_y, ax
273F:080B  A1 11D6                              mov     ax, mouse_x2
273F:080E  A3 0782                              mov     saved_mouse_x, ax
273F:0811  A1 076C                              mov     ax, menu_items_proc
273F:0814  26: A3 3368                          mov     es:data_78e,ax          ; (0874:3368=4758h)
273F:0818  A0 9835                              mov     al, num_inventory_items
273F:081B  26: A2 3360                          mov     es:data_76e,al          ; (0874:3360=0FFh)
273F:081F  A1 BC49                              mov     ax, num_groats
273F:0822  26: A3 337E                          mov     es:data_88e,ax          ; (0874:337E=0)
273F:0826  A1 4CE4                              mov     ax,word ptr ds:[data_segment2]
273F:0829  26: A3 3376                          mov     es:data_84e,ax          ; (0874:3376=0A321h)
273F:082D  A1 4CF2                              mov     ax, font_segment
273F:0830  26: A3 337B                          mov     es:data_86e,ax          ; (0874:337B=5806h)
273F:0834  A1 4CF0                              mov     ax, font2_segment
273F:0837  26: A3 3370                          mov     es:data_82e,ax          ; (0874:3370=0F5Eh)
273F:083B  26: C7 06 3362 0000                  mov     word ptr es:data_77e,0  ; (0874:3362=0AF06h)
273F:0842  A1 1924                              mov     ax, hotspot_id
273F:0845  26: A3 3358                          mov     es:data_73e,ax          ; (0874:3358=5E69h)
273F:0849  A1 9832                              mov     ax, room_number
273F:084C  26: A3 3356                          mov     es:data_72e,ax          ; (0874:3356=289Ah)
273F:0850  A1 074C                              mov     ax, menubar_block_size
273F:0853  26: A3 336A                          mov     es:data_79e,ax          ; (0874:336A=7500h)
273F:0857  A1 0748                              mov     ax, screen_width
273F:085A  26: A3 3374                          mov     es:data_83e,ax          ; (0874:3374=1EA1h)
273F:085E  A1 076A                              mov     ax, display_character_proc
273F:0861  26: A3 336C                          mov     es:data_80e,ax          ; (0874:336C=9A07h)
273F:0865  A1 074A                              mov     ax, char_width
273F:0868  26: A3 336E                          mov     es:data_81e,ax          ; (0874:336E=8090h)
273F:086C  8B 36 076E                           mov     si, data_571
273F:0870  8B 04                                mov     ax,[si]
273F:0872  26: A3 33DE                          mov     es:data_92e,ax          ; (0874:33DE=0A21Dh)
273F:0876  8B 44 02                             mov     ax,[si+2]
273F:0879  26: A3 33DC                          mov     es:data_91e,ax          ; (0874:33DC=11A2h)
273F:087D BF 33E0                              mov     di,data_93e             ; (0874:33E0=0F2h)
273F:0880  B9 001B                              mov     cx,1Bh
273F:0883 BE 0720                              mov     si,720h                 ; (273F:0720=0B8h)
273F:0886  F3/ A4                               rep     movsb                   ; Rep when cx >0 Mov [si] to es:[di]
273F:0888  06                                   push    es
273F:0889  1F                                   pop     ds
273F:088A  C3                                   retn
                                     sub_11     endp
                                     
                                ;
                                ;                              JUMP POINT
                                ;
                                ;

273F:088B 8E C5         action_handle_2:       mov     es,bp
273F:088D BF 65F3                              mov     di, offset player_action_support_record
273F:0890 BE 3382                              mov     si, offset data_3382
273F:0893  F7 04 FFFF                           test    word ptr [si],0FFFFh
273F:0897  78 37                                js      loc_65                  ; Jump if sign=1
273F:0899                       loc_63:                                         ;  xref 273F:089F
273F:0899 AD                                   lodsw                           ; String [si] to ax
273F:089A  0B C0                                or      ax,ax                   ; Zero ?
273F:089C  78 03                                js      loc_64                  ; Jump if sign=1
273F:089E  A5                                   movsw                           ; Mov [si] to es:[di]
273F:089F  EB F8                                jmp     short loc_63            ; (0899)
273F:08A1                       loc_64:                                         ;  xref 273F:089C
273F:08A1  33 C0                                xor     ax,ax                   ; Zero register
273F:08A3  AB                                   stosw                           ; Store ax to es:[di]
273F:08A4  8E DD                                mov     ds,bp
273F:08A6  C6 06 9834 01                        mov     cursor_state, CURSORSTATE_ACTION
273F:08AB  A3 1924                              mov     hotspot_id, ax
273F:08AE BE 6CEF                              mov     si, offset player_hotspot_rec
273F:08B1  89 44 52                             mov     [si+HS_DEST_HOTSPOT],ax
273F:08B4  88 44 2A                             mov     [si+HS_ACTION_CTR],al
273F:08B7  88 44 FF                             mov     [si-1],al
273F:08BA  8B DE                                mov     bx,si
273F:08BC  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:08BF  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:08C2  89 44 42                             mov     [si+HS_DELAY_CTR], ax
273F:08C5  88 44 44                             mov     [si+HS_CHAR_MODE], al
273F:08C8  C6 07 02                             mov     byte ptr [bx], CHAR_ACTION_DISPATCH_ACTION
273F:08CB  C7 47 01 65F3                        mov     word ptr [bx+CURRENT_ACTION_SUPPORT_TABLE], offset player_action_support_record
273F:08D0                       loc_65:                                    
273F:08D0  8E DD                                mov     ds,bp
273F:08D2  8B 0E 0782                           mov     cx, saved_mouse_x
273F:08D6  89 0E 11D6                           mov     mouse_x2, cx
273F:08DA  89 0E 11D1                           mov     mouse_x, cx
273F:08DE  8B 16 0784                           mov     dx, saved_mouse_y
273F:08E2  89 16 11D8                           mov     mouse_y2, dx
273F:08E6  89 16 11D3                           mov     mouse_y, dx
273F:08EA  D1 E1                                shl     cx,1                    ; Shift w/zeros fill
273F:08EC  B8 0004                              mov     ax,4
273F:08EF  CD 33                                int     33h                     ; Mouse driver    ax=func 0004h
                                                                                ;  set position, cx=horz,dx=vert
273F:08F1  33 C0                                xor     ax,ax                   ; Zero register
273F:08F3  A2 11DA                              mov     mouse_buttons2, al
273F:08F6  A2 38B0                              mov     data_781, al
273F:08F9  80 26 11D0 FE                        and     menubar_state, 0FEh ; (273F:11D0=56h)
273F:08FE  FF 16 075E                           call    [show_cursor_proc]
273F:0902  C3                                   retn

                                ; External Entry into Subroutine 
                                ;
                                ;         Called from:   273F:04B9

273F:0903                       sub_12:
273F:0903  B4 62                                mov     ah,62h
273F:0905  CD 21                                int     21h                     ; DOS Services  ah=function 62h
                                                                                ;  get Program Segment Prefix bx
273F:0907  8E C3                                mov     es,bx
273F:0909  26: F6 06 0080 FF                    test    byte ptr es:data_8e,0FFh ; (0000:0080=0A0h)
273F:090F  74 31                                jz      loc_ret_70              ; Jump if zero
273F:0911  26: 8A 0E 0080                       mov     cl,es:data_8e           ; (0000:0080=0A0h)
273F:0916  32 ED                                xor     ch,ch                   ; Zero register
273F:0918 BF 0081                              mov     di,data_8e+1            ; (0000:0081=1)

273F:091B                       locloop_66:                                     ;  xref 273F:0940
273F:091B  26: 8A 05                            mov     al,es:[di]
273F:091E  3C 65                                cmp     al,65h                  ; 'e'
273F:0920  75 07                                jne     loc_67                  ; Jump if not equal
                                                assume  ds:data_seg
273F:0922  80 36 0742 02                        xor     video_style, 2
273F:0927  EB 14                                jmp     short loc_69            ; (093D)
273F:0929                       loc_67:                                         ;  xref 273F:0920
273F:0929  3C 6D                                cmp     al,6Dh                  ; 'm'
273F:092B  75 07                                jne     loc_68                  ; Jump if not equal
273F:092D  80 36 5660 08                        xor     music_status,8
273F:0932  EB 09                                jmp     short loc_69            ; (093D)
273F:0934                       loc_68:                                         ;  xref 273F:092B
273F:0934  3C 69                                cmp     al,69h                  ; 'i'
273F:0936  75 05                                jne     loc_69                  ; Jump if not equal
273F:0938  80 36 11D0 40                        xor     menubar_state, 40h   ; (31E4:11D0=3) '@'
273F:093D                       loc_69:                                         ;  xref 273F:0927, 0932, 0936
273F:093D  83 C7 01                             add     di,1
273F:0940  E2 D9                                loop    locloop_66              ; Loop if cx > 0


273F:0942                       loc_ret_70:                                     ;  xref 273F:090F
273F:0942  C3                                   retn
273F:0943  00                   critical_error  db      0                       ;  xref 273F:019B, 01B2, 01E5, 01F3
                                                                                ;            021F, 0249, 0397, 03CA
                                                                                ;            0944
                                initialise      endp


                                ;
                                ;
                                ;                       External Entry Point
                                ;
                                ;

273F:0944                    critical_handler   proc    far                     ;  xref 273F:06E2
                                                assume  ds:seg_code
273F:0944  2E: C6 06 0943 01                    mov     cs:critical_error,1           ; (273F:0943=0)
273F:094A  32 C0                                xor     al,al                   ; Zero register
273F:094C  CF                                   iret                            ; Interrupt return
                             critical_handler   endp

                                ;
                                ;
                                ;                       External Entry Point
                                ;
                                ;

273F:094D  CB                   retf_proc       retf

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:0074, 7097, 70BA, 8FB5
                                ;

273F:094E                clear_layer_rects      proc    near
273F:094E  1E                                   push    ds
273F:094F  07                                   pop     es
273F:0950 BF 0992                              mov     di,offset rects_layer_0
273F:0953  B8 FFFF                              mov     ax,0FFFFh
273F:0956  B9 0200                              mov     cx,200h
273F:0959  F3/ AB                               rep     stosw                   ; Rep when cx >0 Store ax to es:[di]
                                                assume  ds:data_seg
273F:095B  A1 4CE0                              mov     ax, current_room_id
273F:095E  A3 4CE2                              mov     data_segment, ax

                                ; External Entry into Subroutine 
                                ;
                                ;         Called from:   273F:00AC, 3CBD, 411B, 7BB4, 8FC5, A825

273F:0961                  clear_hotspot_rects:
273F:0961  1E                                   push    ds
273F:0962  07                                   pop     es
273F:0963 BF 0790                              mov     di,offset hotspot_rects_list
273F:0966  B8 8181                              mov     ax,8181h
273F:0969  B9 0100                              mov     cx,100h
273F:096C  F3/ AB                               rep     stosw                   ; Rep when cx >0 Store ax to es:[di]
273F:096E  C3                                   retn
                         clear_layer_rects      endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:0077, 709A, 70BD, 8FB8
                                ;

                          room_load_layers      proc    near

273F:096F                       loc_71:                                         ;  xref 273F:0977
273F:096F  80 26 11D0 DF                        and     menubar_state, 0DFh
273F:0974  E8 F884                              call    read_and_validate_header
273F:0977  72 F6                                jc      loc_71                  ; Jump back if error occurred

273F:0979  A1 4CE0                              mov     ax, current_room_id
273F:097C  50                                   push    ax
                                                assume  ds:seg_code
273F:097D  8B 1E 9832                           mov     bx, room_number
273F:0981  E8 0364                              call    get_room_resource_pointer

; At this point SI points to the data list for the room. For cell room, it's room=8181h to si=>c108h

273F:0984  BF 0D92                              mov     di, offset room_layers
273F:0987  83 C6 08                             add     si, ROOM_NUM_LAYERS
273F:098A  8A 2C                                mov     ch, [si]                ; Get # screens
273F:098C  83 C6 01                             add     si,1                    ; Move to first layer id
273F:098F  F7 06 BA25 FFFF                      test    viewing_room, 0FFFFh    ; Viewing room without being there?
273F:0995  74 03                                jz      loc_72
273F:0997  80 C5 01                             add     ch,1                    ; If yes, inc # screens to load
273F:099A                       loc_72:
273F:099A  BB 0992                              mov     bx, offset rects_layer_0
273F:099D  83 C3 4C                             add     bx, offset rects_layer_0 - offset rects_layer_0 ; 4Ch
273F:09A0  32 C9                                xor     cl, cl                  ; Starting at layer 0

273F:09A2                       loc_73:                                         
273F:09A2  51                                   push    cx
273F:09A3  56                                   push    si
273F:09A4  53                                   push    bx
273F:09A5  8B 04                                mov     ax,[si]                 ; Load the screen with palette
273F:09A7  E8 0226                              call    read_screen
273F:09AA  A1 4CE0                              mov     ax, current_room_segment
273F:09AD  89 05                                mov     [di], ax                ; Store seg for layer start
273F:09AF  57                                   push    di
273F:09B0  8E C0                                mov     es, ax
273F:09B2  33 FF                                xor     di,di                   ; Zero register
273F:09B4  FF 16 0750                           call    [segment_screen_proc]
273F:09B8  B1 04                                mov     cl,4
273F:09BA  D3 EF                                shr     di,cl                   ; Convert to # paragraphs 
273F:09BC  01 3E 4CE0                           add     current_room_segment, di ; Increase by decoded size
273F:09C0  01 3E 4CE2                           add     data_segment, di
273F:09C4  5F                                   pop     di
273F:09C5  83 C7 02                             add     di,2
273F:09C8  A1 0DA2                              mov     ax, rectangle_size      ; ax = 400h
273F:09CB  89 05                                mov     [di],ax                 
273F:09CD  83 C7 02                             add     di,2
273F:09D0  5B                                   pop     bx
273F:09D1  81 C3 0100                           add     bx,100h
273F:09D5  5E                                   pop     si
273F:09D6  83 C6 02                             add     si,2
273F:09D9  59                                   pop     cx
273F:09DA  80 C1 01                             add     cl,1
273F:09DD  80 ED 01                             sub     ch,1                    ; Decrement number of layers
273F:09E0  75 C0                                jnz     loc_73                  ; Jump if not zero

273F:09E2  58                                   pop     ax
273F:09E3  A3 4CE0                              mov     current_room_segment, ax
273F:09E6  C3                                   retn

                          room_load_layers      endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:0081, 70C4, 8FBF
                                ;

273F:09E7                       sub_16          proc    near
273F:09E7 BB 0ADE                              mov     bx,offset data_593      ; (31E4:0ADE=0)
273F:09EA  E8 000D                              call    sub_17                  ; (09FA)
273F:09ED BB 0BDE                              mov     bx,offset data_599      ; (31E4:0BDE=0)
273F:09F0  E8 0007                              call    sub_17                  ; (09FA)
273F:09F3 BB 0CDE                              mov     bx,offset data_601      ; (31E4:0CDE=0)
273F:09F6  E8 0001                              call    sub_17                  ; (09FA)
273F:09F9  C3                                   retn
                                sub_16          endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:09EA, 09F0, 09F6
                                ;

273F:09FA                       sub_17          proc    near
273F:09FA  B9 0006                              mov     cx,6

273F:09FD                       locloop_74:                                     ;  xref 273F:0A52
273F:09FD  51                                   push    cx
273F:09FE  53                                   push    bx
273F:09FF  B5 0A                                mov     ch,0Ah
273F:0A01                       loc_75:                                         ;  xref 273F:0A4E
273F:0A01  53                                   push    bx
273F:0A02  B1 06                                mov     cl,6
273F:0A04  32 D2                                xor     dl,dl                   ; Zero register
273F:0A06                       loc_76:                                         ;  xref 273F:0A45
273F:0A06  80 3F FF                             cmp     byte ptr [bx],0FFh
273F:0A09  75 04                                jne     loc_77                  ; Jump if not equal
273F:0A0B  32 D2                                xor     dl,dl                   ; Zero register
273F:0A0D  EB 30                                jmp     short loc_81            ; (0A3F)
273F:0A0F                       loc_77:                                         ;  xref 273F:0A09
273F:0A0F  F6 C2 02                             test    dl,2
273F:0A12  74 0A                                jz      loc_78                  ; Jump if zero
273F:0A14  80 7F FF FF                          cmp     byte ptr [bx-1],0FFh
273F:0A18  75 04                                jne     loc_78                  ; Jump if not equal
273F:0A1A  C6 47 FF FE                          mov     byte ptr [bx-1],0FEh
273F:0A1E                       loc_78:                                         ;  xref 273F:0A12, 0A18
273F:0A1E  F6 C2 04                             test    dl,4
273F:0A21  74 0A                                jz      loc_79                  ; Jump if zero
273F:0A23  80 7F 01 FF                          cmp     byte ptr [bx+1],0FFh
273F:0A27  75 04                                jne     loc_79                  ; Jump if not equal
273F:0A29  C6 47 01 FE                          mov     byte ptr [bx+1],0FEh
273F:0A2D                       loc_79:                                         ;  xref 273F:0A21, 0A27
273F:0A2D  80 7F FF FF                          cmp     byte ptr [bx-1],0FFh
273F:0A31  74 03                                je      loc_80                  ; Jump if equal
273F:0A33  80 CA 02                             or      dl,2
273F:0A36                       loc_80:                                         ;  xref 273F:0A31
273F:0A36  80 7F 01 FF                          cmp     byte ptr [bx+1],0FFh
273F:0A3A  74 03                                je      loc_81                  ; Jump if equal
273F:0A3C  80 CA 04                             or      dl,4
273F:0A3F                       loc_81:                                         ;  xref 273F:0A0D, 0A3A
273F:0A3F  83 C3 12                             add     bx,12h
273F:0A42  80 E9 01                             sub     cl,1
273F:0A45  75 BF                                jnz     loc_76                  ; Jump if not zero
273F:0A47  5B                                   pop     bx
273F:0A48  83 C3 01                             add     bx,1
273F:0A4B  80 ED 01                             sub     ch,1
273F:0A4E  75 B1                                jnz     loc_75                  ; Jump if not zero
273F:0A50  5B                                   pop     bx
273F:0A51  59                                   pop     cx
273F:0A52  E2 A9                                loop    locloop_74              ; Loop if cx > 0

273F:0A54  C3                                   retn
                                sub_17          endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:1549, 15EF
                                ; di = anim slot entry
                                ;

273F:0A55                    room_add_layer     proc    near
273F:0A55  8B 05                                mov     ax, [di]                ; Get X start
273F:0A57  8B 5D 04                             mov     bx, [di+ANIM_WIDTH]     ; Get width
273F:0A5A  03 D8                                add     bx, ax
273F:0A5C  B1 05                                mov     cl,5
273F:0A5E  D3 E8                                shr     ax,cl                   ; ax=X rect start
273F:0A60  D3 EB                                shr     bx,cl                   ; bx=X rect end
273F:0A62  2B D8                                sub     bx, ax
273F:0A64  83 C3 01                             add     bx, 1                   ; bx = num horiz rects
273F:0A67  89 1E 0DAA                           mov     num_horiz_rects, bx
273F:0A6B  8B D8                                mov     bx, ax

273F:0A6D  8B 45 02                             mov     ax, [di+ANIM_Y]           ; Get Y position
273F:0A70  8B 55 15                             mov     dx, [di+ANIM_HEIGHT_COPY] ; Get height copy
273F:0A73  2D 0008                              sub     ax, 8
273F:0A76  03 D0                                add     dx, ax
273F:0A78  83 EA 01                             sub     dx, 1
273F:0A7B  B1 05                                mov     cl, 5
273F:0A7D  D3 E8                                shr     ax, cl                  ; ax=Y rect start
273F:0A7F  D3 EA                                shr     dx, cl                  ; dx=Y rect end
273F:0A81  2B D0                                sub     dx, ax                  ; dx=num vert rects-1
273F:0A83  89 1E 0DA6                           mov     rect_x_start, bx
273F:0A87  89 16 0DAC                           mov     num_vert_rects, dx
273F:0A8B  83 06 0DAC 01                        add     num_vert_rects, 1
273F:0A90  03 C2                                add     ax, dx
273F:0A92  A3 0DA8                              mov     rect_y_end, ax

273F:0A95  D1 E0                                shl     ax,1                    ; ax=y*2
273F:0A97  8B F8                                mov     di,ax                   ; di=y*2
273F:0A99  B1 03                                mov     cl,3
273F:0A9B  D3 E0                                shl     ax,cl                   ; ax=y*16
273F:0A9D  03 C7                                add     ax,di                   ; ax=y*18
273F:0A9F  03 C3                                add     ax,bx                   ; ax = yend*18 + x
273F:0AA1  8B D8                                mov     bx,ax                   ; ax/bx = list start

273F:0AA3  8B 0E 0DAA                           mov     cx, num_horiz_rects 

; cx = num horiz rects,
273F:0AA7                       locloop_82:
273F:0AA7  51                                   push    cx
273F:0AA8  53                                   push    bx
273F:0AA9  8B 16 0DA6                           mov     dx, rect_x_start        
273F:0AAD  83 EA 04                             sub     dx, 4
273F:0AB0  72 3F                                jc      loc_86                  ; Jump if carry Set
273F:0AB2 BF 0A92                              mov     di, offset rects_layer_1
273F:0AB5  BE 0D96                              mov     si, offset room_layers + 4 ; layer 1
273F:0AB8  B9 0003                              mov     cx, 3                   ; 3 layers

273F:0ABB                       locloop_83:                                     ;  xref 273F:0AC7
273F:0ABB  80 39 FF                             cmp     byte ptr [bx+di], 0FFh  ; Rect was empty?
273F:0ABE  75 0B                                jne     loc_84                  ; If yes, then handle
273F:0AC0  81 C7 0100                           add     di, 100h                ; Check remaining layers
273F:0AC4  83 C6 04                             add     si, 4                   ; Next room_layers entry
273F:0AC7  E2 F2                                loop    locloop_83              ; Loop layers

273F:0AC9  EB 26                                jmp     short loc_86            
273F:0ACB                       loc_84:
273F:0ACB  8B E9                                mov     bp,cx                   ; Save layer #
273F:0ACD  8B 0E 0DAC                           mov     cx,num_vert_rects
273F:0AD1  A1 0DA8                              mov     ax,rect_y_end
273F:0AD4  2D 0004                              sub     ax,4

273F:0AD7                       locloop_85:                                     ;  xref 273F:0AEF
273F:0AD7  50                                   push    ax
273F:0AD8  51                                   push    cx
273F:0AD9  57                                   push    di
273F:0ADA  52                                   push    dx
273F:0ADB  53                                   push    bx
273F:0ADC  56                                   push    si
273F:0ADD  FF 16 075C                           call    [add_rect_proc]         ; Add rect area (32x32)
273F:0AE1  5E                                   pop     si
273F:0AE2  5B                                   pop     bx
273F:0AE3  5A                                   pop     dx
273F:0AE4  5F                                   pop     di
273F:0AE5  59                                   pop     cx
273F:0AE6  58                                   pop     ax
273F:0AE7  83 EB 12                             sub     bx, FULL_HORIZ_RECTS
273F:0AEA  2D 0001                              sub     ax, 1
273F:0AED  72 02                                jc      loc_86                  ; Loop for remaining rows
273F:0AEF  E2 E6                                loop    locloop_85

273F:0AF1                       loc_86:                                        
273F:0AF1  5B                                   pop     bx
273F:0AF2  83 C3 01                             add     bx, 1
273F:0AF5  59                                   pop     cx
273F:0AF6  83 06 0DA6 01                        add     rect_x_start, 1    
273F:0AFB  E2 AA                                loop    locloop_82              ; Loop for remaining cols

273F:0AFD  C3                                   retn
                             room_add_layer     endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:0084, 70C7, 8FC2
                                ;

273F:0AFE                       sub_19          proc    near
273F:0AFE BE 0B38                              mov     si,offset data_598      ; (31E4:0B38=0)
273F:0B01  B9 0003                              mov     cx,3

273F:0B04                       locloop_87:                                     ;  xref 273F:0B25
273F:0B04 BB 0009                              mov     bx,offset copyright+9   ; (31E4:0009=' ')
273F:0B07                       loc_88:                                         ;  xref 273F:0B1F
273F:0B07  80 38 FF                             cmp     byte ptr [bx+si],0FFh
273F:0B0A  74 10                                je      loc_89                  ; Jump if equal
273F:0B0C  C6 40 12 FE                          mov     byte ptr [bx+si+12h],0FEh
273F:0B10  C6 40 24 FE                          mov     byte ptr [bx+si+24h],0FEh
273F:0B14  C6 40 36 FE                          mov     byte ptr [bx+si+36h],0FEh
273F:0B18  C6 40 48 FE                          mov     byte ptr [bx+si+48h],0FEh
273F:0B1C                       loc_89:                                         ;  xref 273F:0B0A
273F:0B1C  83 EB 01                             sub     bx,1
273F:0B1F  73 E6                                jnc     loc_88                  ; Jump if carry=0
273F:0B21  81 C6 0100                           add     si,100h
273F:0B25  E2 DD                                loop    locloop_87              ; Loop if cx > 0

273F:0B27  C3                                   retn
                                sub_19          endp

                                
                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:1546, 15EC, 1631, 3CF9
                                ; di = anim slot
                                ;

                         flag_covered_cells     proc    near
273F:0B28  50                                   push    ax
273F:0B29  8B 5D 02                             mov     bx, [di+ANIM_Y]
273F:0B2C  83 EB 08                             sub     bx, MENUBAR_Y_SIZE
273F:0B2F  8B C3                                mov     ax, bx                  ; bx = Y start
273F:0B31  03 45 06                             add     ax, [di+ANIM_HEIGHT]
273F:0B34  2D 0001                              sub     ax, 1                   ; ax = Y end
273F:0B37  B1 05                                mov     cl, 5
273F:0B39  D3 E8                                shr     ax, cl                  ; ax=Y end/32
273F:0B3B  D3 EB                                shr     bx, cl                  ; bx=Y start/32
273F:0B3D  2B C3                                sub     ax, bx
273F:0B3F  05 0001                              add     ax, 1                   ; ax=# vert rects

273F:0B42  50                                   push    ax
273F:0B43  D1 E3                                shl     bx, 1
273F:0B45  8B D3                                mov     dx, bx
273F:0B47  B1 03                                mov     cl, 3
273F:0B49  D3 E3                                shl     bx, cl
273F:0B4B  03 DA                                add     bx, dx                  

; The screen is broken down into a set of 10x6 32x32 cells.
; bx = vertical cell rect block * 10

273F:0B4D  8B 15                                mov     dx, [di]                ; dx = X start
273F:0B4F  8B 45 04                             mov     ax, [di+ANIM_WIDTH]
273F:0B52  03 C2                                add     ax, dx
273F:0B54  2D 0001                              sub     ax, 1                   ; ax = X end
273F:0B57  B1 05                                mov     cl, 5
273F:0B59  D3 EA                                shr     dx, cl                  ; dx = X start/32
273F:0B5B  D3 E8                                shr     ax, cl                  ; ax = X end/32
273F:0B5D  2B C2                                sub     ax, dx
273F:0B5F  03 DA                                add     bx, dx                  ; bx = start rect index
273F:0B61 81 C3 0790                           add     bx, offset hotspot_rects_list
273F:0B65  05 0001                              add     ax, 1                   ; ax = # horiz rects
273F:0B68  5D                                   pop     bp
273F:0B69  5A                                   pop     dx

; Loop, bp = number of cell rows, ax = number of cell cols

273F:0B6A                       loc_90:
273F:0B6A  8B C8                                mov     cx, ax
273F:0B6C  53                                   push    bx

273F:0B6D                       locloop_91:                   
273F:0B6D  08 17                                or      [bx], dl                ; Enable cell rect
273F:0B6F  80 8F 0100 01                        or      byte ptr [bx+100h], 1
273F:0B74  83 C3 01                             add     bx, 1
273F:0B77  E2 F4                                loop    locloop_91              ; Loop through horiz # cells

273F:0B79  5B                                   pop     bx
273F:0B7A  83 C3 12                             add     bx, FULL_HORIZ_RECTS
273F:0B7D  83 ED 01                             sub     bp, 1                   ; Loop through vert # cells
273F:0B80  75 E8                                jnz     loc_90
273F:0B82  C3                                   retn
                         flag_covered_cells     endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:1447, 3307, 6D22, 6FDD, 8B52
                                ;

273F:0B83                       sub_21          proc    near
273F:0B83                       loc_92:                                         ;  xref 273F:23E7, 2450, 8CD8, 9333
273F:0B83 51                                   push    cx
273F:0B84  B1 03                                mov     cl,3
273F:0B86  D3 E0                                shl     ax,cl                   ; Shift w/zeros fill
273F:0B88  D3 E3                                shl     bx,cl                   ; Shift w/zeros fill
273F:0B8A  D3 E5                                shl     bp,cl                   ; Shift w/zeros fill
273F:0B8C  D3 E2                                shl     dx,cl                   ; Shift w/zeros fill
273F:0B8E  59                                   pop     cx

                                ; External Entry into Subroutine 
                                ;
                                ;         Called from:   273F:3291, 62D6, 8BE5, 8BFA

273F:0B8F                       sub_22:
273F:0B8F                       loc_93:                                         ;  xref 273F:2272, 33B0
273F:0B8F 51                                   push    cx
273F:0B90  03 E8                                add     bp,ax
273F:0B92  03 D3                                add     dx,bx
273F:0B94  83 C5 1F                             add     bp,1Fh
273F:0B97  83 C2 1F                             add     dx,1Fh
273F:0B9A  B1 05                                mov     cl,5
273F:0B9C  D3 E8                                shr     ax,cl                   ; Shift w/zeros fill
273F:0B9E  D3 EB                                shr     bx,cl                   ; Shift w/zeros fill
273F:0BA0  D3 ED                                shr     bp,cl                   ; Shift w/zeros fill
273F:0BA2  D3 EA                                shr     dx,cl                   ; Shift w/zeros fill
273F:0BA4  2B E8                                sub     bp,ax
273F:0BA6  2B D3                                sub     dx,bx
273F:0BA8  93                                   xchg    bx,ax
273F:0BA9  05 0004                              add     ax,4
273F:0BAC  B1 12                                mov     cl,12h
273F:0BAE  F6 E1                                mul     cl                      ; ax = reg * al
273F:0BB0  03 C3                                add     ax,bx
273F:0BB2  05 0794                              add     ax, offset hotspot_rects_list + 4 ; 794h
273F:0BB5  8B D8                                mov     bx,ax
273F:0BB7  58                                   pop     ax
273F:0BB8                       loc_94:                                         ;  xref 273F:0BCD
273F:0BB8  53                                   push    bx
273F:0BB9  8B CD                                mov     cx,bp

273F:0BBB                       locloop_95:                                     ;  xref 273F:0BC4
273F:0BBB  08 07                                or      [bx],al
273F:0BBD  08 87 0100                           or      byte ptr ds:[100h][bx],al ; (273F:0100=6)
273F:0BC1  83 C3 01                             add     bx,1
273F:0BC4  E2 F5                                loop    locloop_95              ; Loop if cx > 0

273F:0BC6  5B                                   pop     bx
273F:0BC7  83 C3 12                             add     bx,12h
273F:0BCA  83 EA 01                             sub     dx,1
273F:0BCD  75 E9                                jnz     loc_94                  ; Jump if not zero
273F:0BCF  C3                                   retn
                                sub_21          endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:09A7
                                ;

273F:0BD0                    read_screen        proc    near
273F:0BD0  53                                   push    bx
273F:0BD1  51                                   push    cx
273F:0BD2  57                                   push    di
273F:0BD3  8B 0E 4CE2                           mov     cx, data_segment
273F:0BD7  BA 0080                              mov     dx, ENTRY_READ_BUFFER
273F:0BDA  E8 F737                              call    read_entry              ; (0314)
273F:0BDD  A1 4CE2                              mov     ax, data_segment
273F:0BE0  8E C0                                mov     es,ax
273F:0BE2  26: A1 0080                          mov     ax,es:[ENTRY_READ_BUFFER]
273F:0BE6  86 E0                                xchg    ah,al
273F:0BE8  25 FFFE                              and     ax,0FFFEh
273F:0BEB  3D 0140                              cmp     ax,140h
273F:0BEE  74 2F                                je      loc_97                  ; Jump if equal

273F:0BF0  A1 4CE4                              mov     ax, data_segment2
273F:0BF3  8E C0                                mov     es,ax
273F:0BF5  8B 16 4CE2                           mov     dx,data_segment
273F:0BF9  E8 2D8E                              call    decode_file_entry
273F:0BFC  8B 1E 9832                           mov     bx, room_number         ; Check if already processing
273F:0C00  3A 1E 1456                           cmp     bl, current_room_num    ; this room (if so, no need
273F:0C04  74 15                                je      loc_96                  ; to reload palette)
273F:0C06  53                                   push    bx
273F:0C07  E8 00DE                              call    get_room_resource_pointer
273F:0C0A  8B 44 09                             mov     ax, [si+ROOM_FIRST_LAYER]
273F:0C0D  25 FFE0                              and     ax, 0FFE0h
273F:0C10  2D 0001                              sub     ax,1
273F:0C13  E8 2EB1                              call    read_palette            ; Get the palette
273F:0C16  5B                                   pop     bx
273F:0C17  88 1E 1456                           mov     current_room_num, bl
273F:0C1B                       loc_96:
273F:0C1B  5F                                   pop     di
273F:0C1C  59                                   pop     cx
273F:0C1D  5B                                   pop     bx
273F:0C1E  C3                                   retn
273F:0C1F                       loc_97:                                         ;  xref 273F:0BEE
273F:0C1F  83 3E 9832 31                        cmp     room_number, 31h
273F:0C24  75 05                                jne     loc_98                  ; Jump if not equal
273F:0C26  B8 F1FF                              mov     ax,0F1FFh
273F:0C29  EB 0A                                jmp     short loc_99            ; (0C35)
273F:0C2B                       loc_98:                                         ;  xref 273F:0C24
273F:0C2B  83 3E 9832 06                        cmp     room_number, 6
273F:0C30  75 0D                                jne     loc_100                 ; Jump if not equal
273F:0C32  B8 45FF                              mov     ax,45FFh
273F:0C35                       loc_99:                                         ;  xref 273F:0C29
273F:0C35  E8 2E8F                              call    read_palette            ; (3AC7)
273F:0C38  C6 06 1456 FF                        mov     current_room_num, 0FFh
273F:0C3D  EB 23                                jmp     short loc_101           ; (0C62)
273F:0C3F                       loc_100:                                        ;  xref 273F:0C30
273F:0C3F  80 3E 1456 FF                        cmp     current_room_num, 0FFh
273F:0C44  75 1C                                jne     loc_101                 ; Jump if not equal
273F:0C46  A0 00B1                              mov     al,data_526             ; (31E4:00B1=1)
273F:0C49  2C 05                                sub     al,5
273F:0C4B  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:0C4D  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:0C4F  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:0C51  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:0C53  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:0C55  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:0C57  0D 00FF                              or      ax,0FFh
273F:0C5A  E8 2E6A                              call    read_palette            ; (3AC7)
273F:0C5D  C6 06 1456 00                        mov     current_room_num, 0
273F:0C62                       loc_101:                                        ;  xref 273F:0C3D, 0C44
273F:0C62  A1 4CE4                              mov     ax, data_segment2
273F:0C65  8E C0                                mov     es,ax
273F:0C67  8B 16 4CE2                           mov     dx,data_segment
273F:0C6B  E8 17FC                              call    ega_decode_entry
273F:0C6E  8B D1                                mov     dx,cx
273F:0C70  83 EA 01                             sub     dx,1
273F:0C73  D1 EA                                shr     dx,1                    ; Shift w/zeros fill
273F:0C75  D1 EA                                shr     dx,1                    ; Shift w/zeros fill
273F:0C77  D1 EA                                shr     dx,1                    ; Shift w/zeros fill
273F:0C79  D1 EA                                shr     dx,1                    ; Shift w/zeros fill
273F:0C7B  83 C2 01                             add     dx,1
273F:0C7E  5F                                   pop     di
273F:0C7F  59                                   pop     cx
273F:0C80  5B                                   pop     bx
273F:0C81  C3                                   retn
                             read_screen        endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:00A0
                                ;

273F:0C82                   hotspots_load       proc    near
273F:0C82  BF 5EB8                              mov     di, offset hotspot_table_5
273F:0C85  BB 0407                              mov     bx,407h
273F:0C88  E8 0006                              call    hotspots_load_2
273F:0C8B BF 623E                              mov     di, offset hotspot_table_3
273F:0C8E  BB 270F                              mov     bx,270Fh

                                ; External Entry into Subroutine 
                                ;
                                ;         Called from:   273F:0C88

273F:0C91                   hotspots_load_2:
273F:0C91                       loc_102:                                        ;  xref 273F:0CA5, 0CBB, 0CC3
273F:0C91 83 C3 01                             add     bx,1
273F:0C94  8B 35                                mov     si,[di]                 ; Get hotspot offset
273F:0C96  83 FE FF                             cmp     si,0FFFFh
273F:0C99  74 2A                                je      loc_ret_106
273F:0C9B  83 C7 09                             add     di,9                    ; Move to next hotspot header
273F:0C9E  8B 54 06                             mov     dx,[si+6]               ; Get room number
273F:0CA1  3B 16 9832                           cmp     dx, room_number         ; Is it the current room?
273F:0CA5  75 EA                                jne     loc_102                 ; No, so move to next hotspot
273F:0CA7  57                                   push    di
273F:0CA8 BF B14E                              mov     di, offset animation_table
273F:0CAB  B9 002D                              mov     cx, NUM_ANIMATION_SLOTS

273F:0CAE                       locloop_103:
273F:0CAE  3B 5D 1B                             cmp     bx,[di+ANIM_HOTSPOT_ID] ; Already present?
273F:0CB1  74 07                                je      loc_104                 ; If yes, don't add
273F:0CB3  83 C7 29                             add     di, ANIMATION_SLOT_SIZE
273F:0CB6  E2 F6                                loop    locloop_103             ; Check remaining entries

273F:0CB8  EB 03                                jmp     short loc_105           ; Jump to add entry
273F:0CBA                       loc_104:
273F:0CBA  5F                                   pop     di
273F:0CBB  EB D4                                jmp     short loc_102           ; (0C91)
273F:0CBD                       loc_105:                                        ;  xref 273F:0CB8
273F:0CBD  53                                   push    bx                      ; Add hotspot entry
273F:0CBE  E8 0008                              call    animation_load_entry_2
273F:0CC1  5B                                   pop     bx
273F:0CC2  5F                                   pop     di
273F:0CC3  EB CC                                jmp     short loc_102           ; Check remaining hotspots

273F:0CC5                       loc_ret_106:
273F:0CC5  C3                                   retn
                            hotspots_load       endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:965C, 9690
                                ;

273F:0CC6             animation_load_entry:     proc    near
273F:0CC6 E8 001F                              call    get_room_resource_pointer

                                ; External Entry into Subroutine 
                                ;
                                ;         Called from:   273F:0CBE

273F:0CC9             animation_load_entry_2:
273F:0CC9  F7 44 0B FFFF                        test    word ptr [si+HS_ANIM_OFFSET], 0FFFFh ; Already acive?
273F:0CCE  75 F5                                jnz     loc_ret_106             ; Jump if yes
273F:0CD0  80 7C 15 FF                          cmp     byte ptr [si+HS_LAYER], 0FFh ; Does hotspot have a layer?
273F:0CD4  74 EF                                je      loc_ret_106             ; Jump if no
273F:0CD6  80 64 07 7F                          and     byte ptr [si+7],7Fh     ; Deactivate any suppression bit on room #
273F:0CDA  8B 44 09                             mov     ax, [si+HS_LOAD_OFFSET]
273F:0CDD  F6 44 08 FF                          test    byte ptr [si+HS_LOAD_FLAG],0FFh    
273F:0CE1  75 02                                jnz     loc_108                 ; Jump if not zero
273F:0CE3  FF E0                                jmp     ax
273F:0CE5                       loc_108:                                        ;  xref 273F:0CE1
273F:0CE5  E9 314C                              jmp     sequence_execute
                      animation_load_entry      endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:0092, 0981, 0C07, 0CC6, 10AE, 1205, 46A4
                                ;                             46FE, 4703, 508F, 612B, 613D, 614D, 6267
                                ;                             6397, 64EA, 65AA, 65C1, 715D, 7164, 716F
                                ;                             76C4, 79C8, 7BF4, 7C03, 7C0B, 8277, 827F
                                ;                             8E6C, 9E8E, 9EB5, 9EBD, 9EC9, 9EE4, 9EF3
                                ;                             9F16, 9F59
                                ;

273F:0CE8          get_room_resource_pointer    proc    near
273F:0CE8  8B C3                                mov     ax, bx

                                ; External Entry into Subroutine 
                                ;
                                ;         Called from:   273F:004F, 11D1, 1481, 1490, 1A98, 428C, 4531
                                ;                             45C2, 45D1, 47E1, 547B, 5672, 58A2, 5AA7
                                ;                             5B08, 5B82, 5BE6, 5C0E, 5CF1, 5D23, 5DC0
                                ;                             5E90, 63BD, 6574, 664D, 82DB, 8422, 89D1
                                ;                             8DAF, 8DC4, 99C2, 99FC, A158

273F:0CEA            get_room_resource_pointer2:
273F:0CEA  BE BF40                              mov     si, offset room_info_table
273F:0CED  3D 03E8                              cmp     ax, PLAYER_HOTSPOT_ID
273F:0CF0  78 20                                js      loc_111                 ; Jump if sign=1
273F:0CF2  3D 2710                              cmp     ax,2710h
273F:0CF5  73 08                                jae     loc_109                 ; Jump if above or =
273F:0CF7  BE 5D98                              mov     si, offset hotspot_table_2
273F:0CFA  2D 03E8                              sub     ax, PLAYER_HOTSPOT_ID
273F:0CFD  EB 13                                jmp     short loc_111           ; (0D12)
273F:0CFF                       loc_109:                                        ;  xref 273F:0CF5
273F:0CFF  3D 4E20                              cmp     ax,4E20h
273F:0D02  73 08                                jae     loc_110                 ; Jump if above or =
273F:0D04  BE 623E                              mov     si, offset hotspot_table_3
273F:0D07  2D 2710                              sub     ax,2710h
273F:0D0A  EB 06                                jmp     short loc_111           ; (0D12)
273F:0D0C                       loc_110:                                        ;  xref 273F:0D02
273F:0D0C BE 63B1                              mov     si, offset hotspot_table_4
273F:0D0F  2D 7530                              sub     ax,7530h
273F:0D12                       loc_111:                                        ;  xref 273F:0CF0, 0CFD, 0D0A
273F:0D12  03 F0                                add     si,ax
273F:0D14  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:0D16  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:0D18  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:0D1A  03 F0                                add     si,ax
273F:0D1C  8B 34                                mov     si,[si]                 ; Get reference from table
273F:0D1E  C3                                   retn
                    get_room_resource_pointer   endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:62FC, 6943, 87DB, 87E4, 8E8A
                                ;

273F:0D1F         get_room_resource_pointer3    proc    near
273F:0D1F  8B C3                                mov     ax,bx

                                ; External Entry into Subroutine 
                                ;
                                ;         Called from:   273F:1378, 5452, 596E, 59B8, 5B5D, 7EB4, 8A6D

273F:0D21         get_room_resource_pointer4:
273F:0D21  BE BF40                              mov     si, offset room_info_table
273F:0D24  3D 03E8                              cmp     ax, PLAYER_HOTSPOT_ID
273F:0D27  72 20                                jb      loc_114                 ; Jump if below
273F:0D29  3D 2710                              cmp     ax,2710h
273F:0D2C  73 08                                jae     loc_112                 ; Jump if above or =
273F:0D2E  BE 5D98                              mov     si, offset hotspot_table_2
273F:0D31  2D 03E8                              sub     ax, PLAYER_HOTSPOT_ID
273F:0D34  EB 13                                jmp     short loc_114           ; (0D49)
273F:0D36                       loc_112:                                        ;  xref 273F:0D2C
273F:0D36  3D 4E20                              cmp     ax,4E20h
273F:0D39  73 08                                jae     loc_113                 ; Jump if above or =
273F:0D3B  BE 623E                              mov     si, offset hotspot_table_3
273F:0D3E  2D 2710                              sub     ax,2710h
273F:0D41  EB 06                                jmp     short loc_114           ; (0D49)
273F:0D43                       loc_113:                                        ;  xref 273F:0D39
273F:0D43  BE 63B1                              mov     si, offset hotspot_table_4
273F:0D46  2D 7530                              sub     ax,7530h
273F:0D49                       loc_114:                                        ;  xref 273F:0D27, 0D34, 0D41
273F:0D49  03 F0                                add     si,ax
273F:0D4B  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:0D4D  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:0D4F  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:0D51  03 F0                                add     si,ax
273F:0D53  C3                                   retn
                  get_room_resource_pointer3    endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:669E, 66B3
                                ;

273F:0D54                       sub_32          proc    near
273F:0D54  1E                                   push    ds
273F:0D55  1E                                   push    ds
273F:0D56  07                                   pop     es
273F:0D57  8E DD                                mov     ds,bp
273F:0D59  55                                   push    bp
273F:0D5A BF 31E6                              mov     di,31E6h                ; (273F:31E6=0CDh)
273F:0D5D  26: C7 45 FE 0000                    mov     word ptr es:[di-2],0
273F:0D63 BE 623E                              mov     si, offset hotspot_table_3
273F:0D66  BD 2710                              mov     bp,2710h
273F:0D69  E8 0003                              call    sub_33                  ; (0D6F)
273F:0D6C  5D                                   pop     bp
273F:0D6D  1F                                   pop     ds

273F:0D6E                       loc_ret_115:                                    ;  xref 273F:0D74
273F:0D6E  C3                                   retn
                                sub_32          endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:0D69
                                ;

273F:0D6F                       sub_33          proc    near
273F:0D6F                       loc_116:                                        ;  xref 273F:0DAD
273F:0D6F 8B 1C                                mov     bx,[si]
273F:0D71  83 FB FF                             cmp     bx,0FFFFh
273F:0D74  74 F8                                je      loc_ret_115             ; Jump if equal
273F:0D76  81 7F 06 03E8                        cmp     word ptr [bx+6], PLAYER_HOTSPOT_ID
273F:0D7B  75 2A                                jne     loc_118                 ; Jump if not equal
273F:0D7D  8A 44 08                             mov     al,[si+8]
273F:0D80  3C 0F                                cmp     al,0Fh
273F:0D82  74 06                                je      loc_117                 ; Jump if equal
273F:0D84  84 06 9836                           test    al,ds:data_55e          ; (0000:9836=46h)
273F:0D88  74 1D                                jz      loc_118                 ; Jump if zero
273F:0D8A                       loc_117:                                        ;  xref 273F:0D82
273F:0D8A  8B C5                                mov     ax,bp
273F:0D8C  AB                                   stosw                           ; Store ax to es:[di]
273F:0D8D  B0 01                                mov     al,1
273F:0D8F  AA                                   stosb                           ; Store al to es:[di]
273F:0D90  8B 44 02                             mov     ax,[si+2]
273F:0D93  80 E4 1F                             and     ah,1Fh
273F:0D96  1E                                   push    ds
273F:0D97  56                                   push    si
273F:0D98  06                                   push    es
273F:0D99  06                                   push    es
273F:0D9A  1F                                   pop     ds
273F:0D9B  E8 6F9C                              call    decode_string
273F:0D9E  07                                   pop     es
273F:0D9F  5E                                   pop     si
273F:0DA0  1F                                   pop     ds
273F:0DA1  26: 83 06 31E4 01                    add     word ptr es:[31E4h],1   ; (273F:31E4=0E4h)
273F:0DA7                       loc_118:                                        ;  xref 273F:0D7B, 0D88
273F:0DA7  83 C5 01                             add     bp,1
273F:0DAA  83 C6 09                             add     si,9
273F:0DAD  EB C0                                jmp     short loc_116           ; (0D6F)
                                sub_33          endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:66EC, 6787, 680A, 6827, 684A
                                ;

273F:0DAF                       sub_34          proc    near
273F:0DAF  C7 06 31E4 0000                      mov     word ptr ds:[31E4h],0   ; (273F:31E4=0E4h)
273F:0DB5  C7 06 30D4 0000                      mov     hotspot_display_buffer, 0
273F:0DBB  2D 0001                              sub     ax,1
273F:0DBE  33 DB                                xor     bx,bx                   ; Zero register
273F:0DC0  3C 10                                cmp     al,10h
           nlure.lst                           Sourcer v6.09   17-Nov- 5   5:53 pm   Page 36

273F:0DC2  72 05                                jb      loc_119                 ; Jump if below
273F:0DC4 BB 0002                              mov     bx,data_1e+2            ; (0000:0002=0)
273F:0DC7  2C 10                                sub     al,10h
273F:0DC9                       loc_119:                                        ;  xref 273F:0DC2
273F:0DC9  BA 0001                              mov     dx,1
273F:0DCC  8A C8                                mov     cl,al
273F:0DCE  D3 E2                                shl     dx,cl                   ; Shift w/zeros fill
273F:0DD0  1E                                   push    ds
273F:0DD1  07                                   pop     es
273F:0DD2  8E DD                                mov     ds,bp
273F:0DD4 BF 31E6                              mov     di,31E6h                ; (273F:31E6=0CDh)
273F:0DD7  26: 8B 0E 3379                       mov     cx,es:data_266          ; (273F:3379=62C0h)
273F:0DDC BE BF49                              mov     si,data_58e             ; (0000:BF49=5)
273F:0DDF  BD 0001                              mov     bp,1
273F:0DE2  E8 0029                              call    sub_35                  ; (0E0E)
273F:0DE5 BE 5D98                              mov     si, offset hotspot_table_2
273F:0DE8  BD 03E8                              mov     bp, PLAYER_HOTSPOT_ID
273F:0DEB  E8 0020                              call    sub_35                  ; (0E0E)
273F:0DEE BE 5EB8                              mov     si, offset hotspot_table_5
273F:0DF1  BD 0408                              mov     bp, FIRST_OBJECT_HOTSPOT_ID
273F:0DF4  E8 0017                              call    sub_35                  ; (0E0E)
273F:0DF7 BE 623E                              mov     si, offset hotspot_table_3
273F:0DFA  BD 2710                              mov     bp,2710h
273F:0DFD  E8 000E                              call    sub_35                  ; (0E0E)
273F:0E00 BE 63B1                              mov     si, offset hotspot_table_4
273F:0E03  BD 7530                              mov     bp,7530h
273F:0E06  E8 0005                              call    sub_35                  ; (0E0E)
273F:0E09  8C DD                                mov     bp,ds
273F:0E0B  06                                   push    es
273F:0E0C  1F                                   pop     ds
273F:0E0D  C3                                   retn
                                sub_34          endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:0DE2, 0DEB, 0DF4, 0DFD, 0E06
                                ;

273F:0E0E                       sub_35          proc    near
273F:0E0E                       loc_120:                                        ;  xref 273F:0EAD
273F:0E0E 56                                   push    si
273F:0E0F  83 3C FF                             cmp     word ptr [si],0FFFFh
273F:0E12  75 02                                jne     loc_121                 ; Jump if not equal
273F:0E14  5E                                   pop     si
273F:0E15  C3                                   retn
273F:0E16                       loc_121:                                        ;  xref 273F:0E12
273F:0E16  8A 44 08                             mov     al,[si+8]
273F:0E19  3C 0F                                cmp     al,0Fh
273F:0E1B  74 09                                je      loc_122                 ; Jump if equal
273F:0E1D  84 06 9836                           test    al,ds:data_96e          ; (2711:9836=3Ch)
273F:0E21  75 03                                jnz     loc_122                 ; Jump if not zero
273F:0E23  E9 0080                              jmp     loc_128                 ; (0EA6)
273F:0E26                       loc_122:                                        ;  xref 273F:0E1B, 0E21
273F:0E26  8B 44 02                             mov     ax,[si+2]
273F:0E29  8B 34                                mov     si,[si]
273F:0E2B  F6 44 03 20                          test    byte ptr [si+3],20h     ; ' '
273F:0E2F  75 75                                jnz     loc_128                 ; Jump if not zero
273F:0E31  F6 44 03 80                          test    byte ptr [si+3],80h
273F:0E35  74 6F                                jz      loc_128                 ; Jump if zero
273F:0E37  81 FD 03E8                           cmp     bp, PLAYER_HOTSPOT_ID
273F:0E3B  72 18                                jb      loc_124                 ; Jump if below
273F:0E3D  F6 44 03 10                          test    byte ptr [si+3],10h
273F:0E41  74 05                                jz      loc_123                 ; Jump if zero
273F:0E43  39 4C 06                             cmp     [si+6],cx
273F:0E46  75 5E                                jne     loc_128                 ; Jump if not equal
273F:0E48                       loc_123:                                        ;  xref 273F:0E41
273F:0E48  26: 3B 2E 3350                       cmp     bp,es:data_43e          ; (0000:3350=0C033h)
273F:0E4D  74 57                                je      loc_128                 ; Jump if equal
273F:0E4F  3B 2E 1924                           cmp     bp, hotspot_id
273F:0E53  74 51                                je      loc_128                 ; Jump if equal
273F:0E55                       loc_124:                                        ;  xref 273F:0E3B
273F:0E55  85 10                                test    dx,[bx+si]
273F:0E57  74 4D                                jz      loc_128                 ; Jump if zero
273F:0E59  3D 017A                              cmp     ax,17Ah
273F:0E5C  74 43                                je      loc_127                 ; Jump if equal
273F:0E5E  3D 0147                              cmp     ax,147h
273F:0E61  74 3E                                je      loc_127                 ; Jump if equal
273F:0E63 BE 30D6                              mov     si,data_41e             ; (0000:30D6=81h)
273F:0E66  26: 8B 0E 30D4                       mov     cx,es:data_40e          ; (0000:30D4=6AEh)
273F:0E6B  0B C9                                or      cx,cx                   ; Zero ?
273F:0E6D  74 0A                                jz      loc_126                 ; Jump if zero

273F:0E6F                       locloop_125:                                    ;  xref 273F:0E77
273F:0E6F  26: 3B 04                            cmp     ax,es:[si]
273F:0E72  74 2D                                je      loc_127                 ; Jump if equal
273F:0E74  83 C6 02                             add     si,2
273F:0E77  E2 F6                                loop    locloop_125             ; Loop if cx > 0

273F:0E79                       loc_126:                                        ;  xref 273F:0E6D
273F:0E79  26: 89 2D                            mov     es:[di],bp
273F:0E7C  26: C6 45 02 01                      mov     byte ptr es:[di+2],1
273F:0E81  83 C7 03                             add     di,3
273F:0E84  26: 83 06 31E4 01                    add     word ptr es:data31e4, 1
273F:0E8A  26: 89 04                            mov     es:[si],ax
273F:0E8D  26: 83 06 30D4 01                    add     word ptr es:data_40e,1  ; (0000:30D4=6AEh)
273F:0E93  1E                                   push    ds
273F:0E94  06                                   push    es
273F:0E95  1F                                   pop     ds
273F:0E96  53                                   push    bx
273F:0E97  52                                   push    dx
273F:0E98  80 E4 1F                             and     ah,1Fh
273F:0E9B  E8 6E9C                              call    decode_string
273F:0E9E  5A                                   pop     dx
273F:0E9F  5B                                   pop     bx
273F:0EA0  1F                                   pop     ds
273F:0EA1                       loc_127:                                        ;  xref 273F:0E5C, 0E61, 0E72
273F:0EA1  26: 8B 0E 3379                       mov     cx,es:data_44e          ; (0000:3379=20CEh)
273F:0EA6                       loc_128:                                        ;  xref 273F:0E23, 0E2F, 0E35, 0E46
                                                                                ;            0E4D, 0E53, 0E57
273F:0EA6  5E                                   pop     si
273F:0EA7  83 C6 09                             add     si,9
273F:0EAA  83 C5 01                             add     bp,1
273F:0EAD  E9 FF5E                              jmp     loc_120                 ; (0E0E)
                                sub_35          endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:522F, 6010
                                ; Part of this procedure changes a player's frame
                                ; si=hotspot, di=slot
                                ;

                     character_update_frame     proc    near
273F:0EB0  56                                   push    si
273F:0EB1  57                                   push    di
273F:0EB2  53                                   push    bx
273F:0EB3  8B 5C 24                             mov     bx, [si+HS_MOVEMENT_OFFSET]
273F:0EB6  8B 44 26                             mov     ax, [si+HS_STEP_CTR]
273F:0EB9  3B 47 02                             cmp     ax, [bx+2]              ; Any steps remaining?
273F:0EBC  75 23                                jne     loc_130                 ; Yes, so carry on
273F:0EBE  83 C3 04                             add     bx, 4                   ; Move to next movement rec
273F:0EC1  C7 44 26 0000                        mov     word ptr [si+HS_STEP_CTR], 0     ; Reset counter
273F:0EC6  C7 44 28 0000                        mov     word ptr [si+HS_FRAME_OFFSET], 0 ; Reset offset
273F:0ECB  89 5C 24                             mov     [si+HS_MOVEMENT_OFFSET], bx  ; Update movement ptr
273F:0ECE  83 3F FF                             cmp     word ptr [bx], 0FFFFh   ; At end of list?
273F:0ED1  75 07                                jne     loc_129
273F:0ED3  B8 0001                              mov     ax,1                    ; Yes - so return
273F:0ED6  5B                                   pop     bx
273F:0ED7  5F                                   pop     di
273F:0ED8  5E                                   pop     si
273F:0ED9  C3                                   retn
273F:0EDA                       loc_129:
273F:0EDA  57                                   push    di
273F:0EDB  8B 3F                                mov     di, [bx]                ; Get ptr to direction frames
273F:0EDD  33 DB                                xor     bx, bx
273F:0EDF  EB 14                                jmp     short loc_131
273F:0EE1                       loc_130:
273F:0EE1  57                                   push    di
273F:0EE2  8B 3F                                mov     di, [bx]                ; Get ptr to direction frames
273F:0EE4  8B 5C 28                             mov     bx, [si+HS_FRAME_OFFSET]; Get offset for movement frame
273F:0EE7  03 FB                                add     di, bx                  ; Add on offset
273F:0EE9  83 3D FF                             cmp     word ptr [di], 0FFFFh   ; End of movement set for direciton?
273F:0EEC  75 07                                jne     loc_131                 ; Jump if not
273F:0EEE  2B FB                                sub     di, bx
273F:0EF0  33 DB                                xor     bx, bx
273F:0EF2  89 5C 28                             mov     [si+HS_FRAME_OFFSET], bx ; Reset to start of movement data
; di=movement record 5bb8h, si=6cefh
273F:0EF5                       loc_131:
273F:0EF5  8B 05                                mov     ax, [di+MOVEMENT_FRAME_NUM] ; Get new frame number
273F:0EF7  57                                   push    di
273F:0EF8  8B 7C 21                             mov     di, [si+HS_PIXEL_OFFSET]
273F:0EFB  8B 4D 07                             mov     cx, [di+PIXEL_FRAME_SIZE]
273F:0EFE  F7 E1                                mul     cx                      ; Calculate frame offset
273F:0F00  8B 4D 03                             mov     cx, [di+PIXEL_DATA_SEGMENT] ; Get loaded data segment
273F:0F03  5B                                   pop     bx                      ; bx = movement rec
273F:0F04  5F                                   pop     di                      ; di = anim slot
273F:0F05  89 45 08                             mov     [di+ANIM_FRAME_OFFSET], ax ; Store new offset
273F:0F08  89 4D 0A                             mov     [di+ANIM_SEGMENT], cx      ; Store segment
273F:0F0B  8B 47 02                             mov     ax, [bx+MOVEMENT_X_CHANGE]
273F:0F0E  0B C0                                or      ax, ax                  ; Any x change?
273F:0F10  74 13                                jz      loc_134                 ; Jump if zero
273F:0F12  78 06                                js      loc_132                 ; Jump if -x direction
273F:0F14  C6 45 26 03                          mov     byte ptr [di+ANIM_DIRECTION], FACING_RIGHT
273F:0F18  EB 04                                jmp     short loc_133
273F:0F1A                       loc_132:
273F:0F1A  C6 45 26 02                          mov     byte ptr [di+ANIM_DIRECTION], FACING_LEFT
273F:0F1E                       loc_133:
273F:0F1E  03 05                                add     ax, [di+ANIM_X]         ; Update char X pos
273F:0F20  89 05                                mov     [di+ANIM_X], ax
273F:0F22  89 44 0D                             mov     [si+HS_X], ax
273F:0F25                       loc_134:
273F:0F25  8B 47 04                             mov     ax, [bx+MOVEMENT_Y_CHANGE]
273F:0F28  C7 45 22 0000                        mov     word ptr [di+22h], 0
273F:0F2D  0B C0                                or      ax, ax                  ; Any y change?
273F:0F2F  74 1C                                jz      loc_137                 ; Jump if none
273F:0F31  78 06                                js      loc_135                 ; Jump if -y direction
273F:0F33  C6 45 26 01                          mov     byte ptr [di+ANIM_DIRECTION], FACING_DOWN
273F:0F37  EB 04                                jmp     short loc_136           ; (0F3D)
273F:0F39                       loc_135:                                        ;  xref 273F:0F31
273F:0F39  C6 45 26 00                          mov     byte ptr [di+ANIM_DIRECTION], FACING_UP
273F:0F3D                       loc_136:
273F:0F3D  C7 45 22 0002                        mov     word ptr [di+22h], 2
273F:0F42  03 45 02                             add     ax, [di+ANIM_Y]         ; Update char Y pos
273F:0F45  89 44 0F                             mov     [si+HS_Y], ax
273F:0F48  89 45 02                             mov     [di+ANIM_Y], ax
273F:0F4B  8B 05                                mov     ax, [di+ANIM_X]
273F:0F4D                       loc_137:
273F:0F4D  83 44 28 06                          add     word ptr [si+HS_FRAME_OFFSET], MOVEMENT_REC_SIZE
273F:0F51  83 44 26 01                          add     word ptr [si+HS_STEP_CTR], 1
273F:0F55  33 C0                                xor     ax, ax
273F:0F57  5B                                   pop     bx
273F:0F58  5F                                   pop     di
273F:0F59  5E                                   pop     si
273F:0F5A  C3                                   retn
                     character_update_frame     endp

                                ;
                                ;                              hotspot_script_execute
                                ;
                                ;


273F:0F5B                       loc_138:
273F:0F5B  26: 8B 04                            mov     ax,es:[si]              ; Set pointer to disk
273F:0F5E  83 C6 02                             add     si,2                    ;  animation record
273F:0F61  89 47 21                             mov     [bx+21h],ax
273F:0F64  53                                   push    bx
273F:0F65  8B D8                                mov     bx,ax
273F:0F67  8B 47 03                             mov     ax,[bx+3]               ; Copy over pixel segment?
273F:0F6A  5B                                   pop     bx
273F:0F6B  89 45 0A                             mov     [di+0Ah],ax
273F:0F6E  C7 45 08 0000                        mov     word ptr [di+8],0       ; Reset frame pointer
273F:0F73  EB 3F                                jmp     short loc_143           

273F:0F75                       loc_139:                                        ;  xref 273F:0FC7
273F:0F75  26: 8B 04                            mov     ax,es:[si]              ; Get X start pos
273F:0F78  83 C6 02                             add     si,2
273F:0F7B  89 47 0D                             mov     [bx+0Dh],ax             ; Store X start in hotspot
273F:0F7E  89 05                                mov     [di],ax                 ;  resource and anim slot
273F:0F80  26: 8B 04                            mov     ax,es:[si]              ; Get Y start pos
273F:0F83  83 C6 02                             add     si,2
273F:0F86  89 47 0F                             mov     [bx+0Fh],ax             ; Store Y start in hotspot
273F:0F89  89 45 02                             mov     [di+2],ax               ;  resource and anim slot
273F:0F8C  EB 26                                jmp     short loc_143

273F:0F8E                       loc_140:                                        ;  xref 273F:0FC2
273F:0F8E  26: 8B 04                            mov     ax,es:[si]
273F:0F91  83 C6 02                             add     si,2
273F:0F94  89 47 1F                             mov     [bx+1Fh],ax
273F:0F97  89 77 24                             mov     [bx+24h],si
273F:0F9A  8B F3                                mov     si,bx
273F:0F9C  5B                                   pop     bx
273F:0F9D  0D 0001                              or      ax,1
273F:0FA0  C3                                   retn
273F:0FA1                       loc_141:                                        ;  xref 273F:0FD1
273F:0FA1  26: 8B 34                            mov     si,es:[si]
273F:0FA4  EB 0E                                jmp     short loc_143           ; (0FB4)
273F:0FA6                       loc_142:                                        ;  xref 273F:0FE5
273F:0FA6  E9 00E8                              jmp     loc_153                 ; (1091)

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

273F:0FA9            hotspot_script_execute     proc    near
273F:0FA9  53                                   push    bx
273F:0FAA  8B DE                                mov     bx, si
273F:0FAC  8B 74 24                             mov     si, [si+HS_SCRIPT_OFFSET]
273F:0FAF  B8 40E6                              mov     ax, scripts2_seg
273F:0FB2  8E C0                                mov     es, ax

273F:0FB4                       loc_143:
273F:0FB4 26: 8B 04                            mov     ax,es:[si]
273F:0FB7  83 C6 02                             add     si,2
273F:0FBA  3D FFFC                              cmp     ax,0FFFCh
273F:0FBD  74 46                                je      loc_144                 ; Ends the execution
273F:0FBF  3D FFFF                              cmp     ax,0FFFFh
273F:0FC2  74 CA                                je      loc_140                 ; ??? Store word at 1fh of offset
273F:0FC4  3D FFFE                              cmp     ax,0FFFEh
273F:0FC7  74 AC                                je      loc_139                 ; Set start position
273F:0FC9  3D FFFB                              cmp     ax,0FFFBh
273F:0FCC  74 3D                                je      loc_145                 ; Set animation dimensions
273F:0FCE  3D FFFA                              cmp     ax,0FFFAh
273F:0FD1  74 CE                                je      loc_141                 ; Jump to location
273F:0FD3  3D FFF9                              cmp     ax,0FFF9h
273F:0FD6  74 83                                je      loc_138                 ; Set pixel data record
273F:0FD8  3D FFF8                              cmp     ax,0FFF8h
273F:0FDB  74 55                                je      loc_146                 ; Something to do with room
273F:0FDD  3D FFF7                              cmp     ax,0FFF7h
273F:0FE0  74 74                                je      loc_149                 ; play music #
273F:0FE2  3D FFF6                              cmp     ax,0FFF6h
273F:0FE5  74 BF                                je      loc_142                 ; Set action bitsets
273F:0FE7  3D FFFD                              cmp     ax,0FFFDh
273F:0FEA  75 7E                                jne     loc_150

273F:0FEC  26: 8B 04                            mov     ax,es:[si]              ; Change position by amount
273F:0FEF  83 C6 02                             add     si,2

273F:0FF2  01 05                                add     [di],ax                 ; Add to X start
273F:0FF4  01 47 0D                             add     [bx+0Dh],ax
273F:0FF7  26: 8B 04                            mov     ax,es:[si]
273F:0FFA  83 C6 02                             add     si,2
273F:0FFD  01 45 02                             add     [di+2],ax               ; Add to Y start
273F:1000  01 47 0F                             add     [bx+0Fh],ax
273F:1003  EB AF                                jmp     short loc_143

273F:1005                       loc_144:                                        ;  xref 273F:0FBD
273F:1005  33 C0                                xor     ax,ax                   ; Zero register
273F:1007  8B F3                                mov     si,bx
273F:1009  5B                                   pop     bx
273F:100A  C3                                   retn
273F:100B                       loc_145:                                        ;  xref 273F:0FCC
273F:100B  26: 8B 04                            mov     ax,es:[si]
273F:100E  83 C6 02                             add     si,2
273F:1011  D1 E0                                shl     ax,1
273F:1013  D1 E0                                shl     ax,1
273F:1015  D1 E0                                shl     ax,1
273F:1017  D1 E0                                shl     ax,1
273F:1019  89 45 04                             mov     [di+4],ax               ; Store width
273F:101C  89 45 13                             mov     [di+13h],ax
273F:101F  26: 8B 04                            mov     ax,es:[si]
273F:1022  83 C6 02                             add     si,2
273F:1025  89 45 06                             mov     [di+6],ax               ; Store height
273F:1028  EB 8A                                jmp     short loc_143

                                                                                ;* No entry point to code
273F:102A  26: 8B 04                            mov     ax,es:[si]
273F:102D  83 C6 02                             add     si,2
273F:1030  EB 82                                jmp     short loc_143           ; (0FB4)
273F:1032                       loc_146:                                        ;  xref 273F:0FDB
273F:1032  26: 8B 04                            mov     ax,es:[si]
273F:1035  83 C6 02                             add     si,2
273F:1038  26: 8B 0C                            mov     cx,es:[si]
273F:103B  83 C6 02                             add     si,2
273F:103E  0B C9                                or      cx,cx                   ; Zero ?
273F:1040  74 06                                jz      loc_147                 ; Jump if zero
273F:1042  3B 0E 9832                           cmp     cx, room_number
273F:1046  75 0B                                jne     loc_148                 ; Jump if not equal
273F:1048                       loc_147:                                        ;  xref 273F:1040
273F:1048  56                                   push    si
273F:1049  53                                   push    bx
273F:104A  57                                   push    di
273F:104B  8B D8                                mov     bx,ax
273F:104D  E8 8F8F                              call    sub_247                 ; (9FDF)
273F:1050  5F                                   pop     di
273F:1051  5B                                   pop     bx
273F:1052  5E                                   pop     si
273F:1053                       loc_148:                                        ;  xref 273F:1046
273F:1053  E9 FF5E                              jmp     loc_143                 ; (0FB4)

273F:1056                       loc_149:                                        ;  xref 273F:0FE0
273F:1056  26: 8B 04                            mov     ax,es:[si]
273F:1059  83 C6 02                             add     si,2
273F:105C  56                                   push    si
273F:105D  53                                   push    bx
273F:105E  57                                   push    di
273F:105F  8B D8                                mov     bx,ax
273F:1061  E8 91A8                              call    play_music
273F:1064  5F                                   pop     di
273F:1065  5B                                   pop     bx
273F:1066  5E                                   pop     si
273F:1067  E9 FF4A                              jmp     loc_143                 ; (0FB4)

273F:106A                       loc_150:
273F:106A  89 77 24                             mov     [bx+24h],si             ; Set execution offset
273F:106D  8B F3                                mov     si,bx
273F:106F  8B 5C 21                             mov     bx,[si+21h]             ; Get pixel data record
273F:1072  F6 47 02 04                          test    byte ptr [bx+2], 4      ; Test flags
273F:1076  74 0E                                jz      loc_151                 ; Jump if zero
273F:1078  8B 5F 03                             mov     bx, [bx+3]
273F:107B  8E C3                                mov     es,bx
273F:107D  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:107F  8B D8                                mov     bx,ax
273F:1081  26: 8B 07                            mov     ax,es:[bx]
273F:1084  EB 03                                jmp     short loc_152           ; (1089)
273F:1086                       loc_151:                                        ;  xref 273F:1076
273F:1086  F7 67 07                             mul     word ptr [bx+7]         ; dx:ax = data * ax
273F:1089                       loc_152:
273F:1089  89 45 08                             mov     [di+8],ax               ; Store current frame
273F:108C  0D 0001                              or      ax,1
273F:108F  5B                                   pop     bx
273F:1090  C3                                   retn

273F:1091                       loc_153:
273F:1091  26: 8B 04                            mov     ax,es:[si]              ; Set bitset actions
273F:1094  89 07                                mov     [bx],ax
273F:1096  26: 8B 44 02                         mov     ax,es:[si+2]
273F:109A  89 47 02                             mov     [bx+2],ax
273F:109D  83 C6 04                             add     si,4
273F:10A0  E9 FF11                              jmp     loc_143

                     hotspot_script_execute     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ; bx=character Id, cx=index in master script table
                                ; Usage of action block for hotspot likely to be making the alternate
                                ; hotspot script non-interruptable until done
                                ;

             seq_set_blocking_hotspot_script    proc    near
273F:10A3  81 FB 03E8                           cmp     bx, PLAYER_HOTSPOT_ID
273F:10A7  75 05                                jne     loc_154                 ; Jump if not equal
273F:10A9  C6 06 9834 02                        mov     cursor_state, CURSORSTATE_SEQUENCE
273F:10AE                       loc_154:                                        ;  xref 273F:10A7
273F:10AE  E8 FC37                              call    get_room_resource_pointer
273F:10B1  D1 E1                                shl     cx,1                    ; Shift w/zeros fill
273F:10B3  81 C1 57E0                           add     cx, offset hotspot_script_master_list
273F:10B7  8B D9                                mov     bx,cx
273F:10B9  8B 07                                mov     ax,[bx]
273F:10BB  89 44 24                             mov     [si+HS_SCRIPT_OFFSET], ax
273F:10BE  8B DE                                mov     bx, si
273F:10C0  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:10C3  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:10C6  C6 07 03                             mov     byte ptr [bx], CHAR_ACTION_EXEC_SCRIPT
273F:10C9  8B 7C 0B                             mov     di, [si+HS_ANIM_OFFSET]
273F:10CC  C6 44 49 01                          mov     byte ptr [si+HS_PATHFIND_COVERED], 1
273F:10D0  E9 605B                              jmp     pathfind_flag_covered_cells
             seq_set_blocking_hotspot_script    endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:7172
                                ;

273F:10D3              animation_find_slot      proc    near
273F:10D3 BF B14E                              mov     di, offset animation_table
273F:10D6  B9 002D                              mov     cx, NUM_ANIMATION_SLOTS

273F:10D9                       locloop_155:                                    ;  xref 273F:10E2
273F:10D9  F6 45 0C FF                          test    byte ptr [di+0Ch],0FFh
273F:10DD  74 08                                jz      loc_ret_156             ; Jump if zero
273F:10DF  83 C7 29                             add     di,29h
273F:10E2  E2 F5                                loop    locloop_155             ; Loop if cx > 0

273F:10E4  83 EF 29                             sub     di,29h

273F:10E7                       loc_ret_156:                                    ;  xref 273F:10DD
273F:10E7  C3                                   retn
                       animation_find_slot      endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:0027
                                ;

273F:10E8                 hotspots_unload       proc    near
273F:10E8 BF B14E                              mov     di,offset animation_table
273F:10EB  B9 002D                              mov     cx, NUM_ANIMATION_SLOTS

273F:10EE                       locloop_157:                                    ; Check if hotspot can be unloaded
273F:10EE  F6 45 10 FF                          test    byte ptr [di+ANIM_CAN_UNLOAD],0FFh
273F:10F2  74 11                                jz      loc_159                 ; If no, then skip

273F:10F4  33 C0                                xor     ax,ax
273F:10F6  83 7D 1B FE                          cmp     word ptr [di+ANIM_HOTSPOT_ID], 0FFFEh ; Check if hotspot Id
273F:10FA  73 06                                jae     loc_158                 ; is the special 0ffffh. Jump if yes
273F:10FC  8B 75 19                             mov     si, [di+ANIM_HOTSPOT_OFFSET]  ; Get hotspot resource
273F:10FF  89 44 0B                             mov     [si+HS_ANIM_OFFSET], ax ; Mark hotspot as inactive
273F:1102                       loc_158:
273F:1102  E8 0172                              call    animation_unload_2
273F:1105                       loc_159:
273F:1105  83 C7 29                             add     di, ANIMATION_SLOT_SIZE
273F:1108  E2 E4                                loop    locloop_157
273F:110A  C3                                   retn
                          hotspots_unload       endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:4FBF, 5E61, 60E7
                                ;

             character_find_impinging_chars     proc    near
273F:110B  56                                   push    si
273F:110C  53                                   push    bx
273F:110D  8B 55 0E                             mov     dx, [di+ANIM_ROOM_NUM]
273F:1110 BE B14E                              mov     si, offset animation_table
273F:1113  B9 002D                              mov     cx, NUM_ANIMATION_SLOTS
273F:1116 BB 10C0                              mov     bx, offset impinging_char_list
273F:1119  C7 06 10BE 0000                      mov     num_impinging_chars, 0
273F:111F  8B 05                                mov     ax, [di+ANIM_X]
273F:1121  A3 10E6                              mov     char_rect_left, ax
273F:1124  03 45 13                             add     ax, [di+ANIM_WIDTH_COPY]
273F:1127  A3 10E8                              mov     char_rect_right, ax
273F:112A  8B 45 02                             mov     ax, [di+ANIM_Y]
273F:112D  03 45 15                             add     ax, [di+ANIM_HEIGHT_COPY]
273F:1130  50                                   push    ax
273F:1131  2B 45 17                             sub     ax, [di+ANIM_Y_CORRECTION]
273F:1134  2B 45 22                             sub     ax, [di+ANIM_CHAR_RECT_Y]
273F:1137  A3 10EA                              mov     char_rect_top, ax
273F:113A  58                                   pop     ax
273F:113B  03 45 22                             add     ax, [di+ANIM_CHAR_RECT_Y]
273F:113E  A3 10EC                              mov     char_rect_bottom, ax

273F:1141                       locloop_160:                                    ; Loop through animations
273F:1141  3B FE                                cmp     di, si                  ; Is it the char's animation?
273F:1143  74 55                                je      loc_161                 ; Skip if yes
273F:1145  F6 44 0C FF                          test    byte ptr [si+ANIM_LAYER], 0FFh
273F:1149  74 4F                                jz      loc_161                 ; If no layer, then skip
273F:114B  3B 54 0E                             cmp     dx, [si+ANIM_ROOM_NUM]
273F:114E  75 4A                                jne     loc_161                 ; Skip if not in same room
273F:1150  8B 44 1B                             mov     ax, [si+ANIM_HOTSPOT_ID]
273F:1153  3D 0408                              cmp     ax, FIRST_OBJECT_HOTSPOT_ID
273F:1156  73 42                                jae     loc_161                 ; Skip if anim not a character
273F:1158  F6 44 1D FF                          test    byte ptr [si+ANIM_SKIP], 0FFh
273F:115C  75 3C                                jnz     loc_161                 ; Skip if skip flag set
273F:115E  8B 44 19                             mov     ax, [si+ANIM_HOTSPOT_OFFSET]
273F:1161  3B 45 24                             cmp     ax, [di+ANIM_VOICE_CTR]
273F:1164  74 34                                je      loc_161                 ; Jump if equal
273F:1166  8B 04                                mov     ax, [si+ANIM_X]
273F:1168  3B 06 10E8                           cmp     ax, char_rect_right
273F:116C  73 2C                                jae     loc_161                 ; Jump if above or =
273F:116E  03 44 13                             add     ax, [si+ANIM_WIDTH_COPY]
273F:1171  3B 06 10E6                           cmp     ax, char_rect_left
273F:1175  72 23                                jb      loc_161                 ; Jump if below
273F:1177  74 21                                jz      loc_161                 ; Jump if zero
273F:1179  8B 44 02                             mov     ax, [si+ANIM_Y]
273F:117C  03 44 15                             add     ax, [si+ANIM_HEIGHT_COPY]
273F:117F  8B E8                                mov     bp, ax
273F:1181  03 44 22                             add     ax, [si+ANIM_CHAR_RECT_Y]
273F:1184  3B 06 10EA                           cmp     ax, char_rect_top
273F:1188  72 10                                jb      loc_161                 ; Jump if below
273F:118A  8B C5                                mov     ax, bp
273F:118C  2B 44 17                             sub     ax, [si+ANIM_Y_CORRECTION]
273F:118F  2B 44 22                             sub     ax, [si+ANIM_CHAR_RECT_Y]
273F:1192  3B 06 10EC                           cmp     ax, char_rect_bottom
273F:1196  74 0E                                je      loc_162                 ; Jump if equal
273F:1198  72 0C                                jc      loc_162                 ; Jump if carry Set
273F:119A                       loc_161:
273F:119A 83 C6 29                             add     si, ANIMATION_SLOT_SIZE
273F:119D  E2 A2                                loop    locloop_160

273F:119F  C7 07 0000                           mov     word ptr [bx], 0        ; Flag end of list
273F:11A3  5B                                   pop     bx
273F:11A4  5E                                   pop     si
273F:11A5  C3                                   retn
273F:11A6                       loc_162:                                        ; Animation is impinging char
273F:11A6  8B 44 1B                             mov     ax, [si+ANIM_HOTSPOT_ID]
273F:11A9  89 07                                mov     [bx], ax                ; Store character Id
273F:11AB  83 C3 02                             add     bx, 2
273F:11AE  83 06 10BE 01                        add     num_impinging_chars, 1
273F:11B3  EB E5                                jmp     short loc_161           ; (119A)
             character_find_impinging_chars     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:5217, 6009
                                ;

273F:11B5                       sub_41          proc    near
273F:11B5  53                                   push    bx
273F:11B6 BB 10C0                              mov     bx, offset impinging_char_list
273F:11B9  C7 06 10EE 0000                      mov     data_617, 0
273F:11BF                       loc_163:

273F:11BF 8B 07                                mov     ax, [bx]                ; Get character Id
273F:11C1  83 C3 02                             add     bx, 2                   ; Move to next entry
273F:11C4  0B C0                                or      ax, ax                  ; Is it the end of the list?
273F:11C6  75 05                                jnz     loc_164                 ; Jump if not
273F:11C8  A1 10EE                              mov     ax, data_617            ; Set return result
273F:11CB  5B                                   pop     bx
273F:11CC  C3                                   retn
273F:11CD                       loc_164:

273F:11CD  8B EB                                mov     bp,bx                   ; Store current table offset
273F:11CF  50                                   push    ax
273F:11D0  56                                   push    si
273F:11D1  E8 FB16                              call    get_room_resource_pointer2 ;Get hotspot resource
273F:11D4  8B DE                                mov     bx, si
273F:11D6  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:11D9  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:11DC  8A 1F                                mov     bl, [bx]                ; bl = char's current action
273F:11DE  5E                                   pop     si
273F:11DF  58                                   pop     ax
273F:11E0  80 FB 03                             cmp     bl, CHAR_ACTION_EXEC_SCRIPT ; Char in animation sequence?
273F:11E3  74 12                                je      loc_166                 ; Jump if yes

273F:11E5  BB B0AE                              mov     bx, offset hotspot_action_list
273F:11E8  B9 0014                              mov     cx, NUM_HOTSPOT_ACTION_SLOTS
273F:11EB  8B 55 1B                             mov     dx, [di+ANIM_HOTSPOT_ID]

273F:11EE                       locloop_165:
273F:11EE  3B 17                                cmp     dx, [bx]                ; Source char in list?
273F:11F0  75 09                                jne     loc_167                 ; Jump if not
273F:11F2  3B 47 02                             cmp     ax, [bx+2]              ; List char Id in list?
273F:11F5  75 04                                jne     loc_167                 ; Jump if not equal
273F:11F7                       loc_166:
273F:11F7  8B DD                                mov     bx,bp                   ; Restore cached table offset
273F:11F9  EB C4                                jmp     short loc_163           ; Check next entry
273F:11FB                       loc_167:
273F:11FB  83 C3 08                             add     bx, HOTSPOT_ACTION_SLOT_SIZE
273F:11FE  E2 EE                                loop    locloop_165             ; Loop remaining action list

; At this point we've found a character in the impinging_char_list list that isn't
; currently blocked to execute a hotspot animation, and doesn't have a cross reference
; against the calling character (such as the player) in the hotspot action list

273F:1200  8B D8                                mov     bx, ax
273F:1202  57                                   push    di
273F:1203  8B FE                                mov     di, si
273F:1205  E8 FAE0                              call    get_room_resource_pointer
273F:1208  87 F7                                xchg    si, di                  ;di=list hotspot rec, si=caller rec
273F:120A  8B C3                                mov     ax, bx
273F:120C  3D 03E8                              cmp     ax, PLAYER_HOTSPOT_ID   ; Is caller Id the player?
273F:120F  75 0F                                jne     loc_168                 ; Jump if not
273F:1211  F6 45 49 FF                          test    byte ptr [di+49h], 0FFh ; ???
273F:1215  75 09                                jnz     loc_168                 ; Jump if not zero
273F:1217  5F                                   pop     di
273F:1218  E8 314B                              call    character_update_movement
273F:121B  5B                                   pop     bx
273F:121C  B8 0001                              mov     ax, 1
273F:121F  C3                                   retn

273F:1220                       loc_168:
273F:1220  BB B0AE                              mov     bx, offset hotspot_action_list
273F:1223                       loc_169:                                        ; Scan for end of list
273F:1223 F7 07 FFFF                           test    word ptr [bx], 0FFFFh
273F:1227  74 05                                jz      loc_170
273F:1229  83 C3 08                             add     bx, HOTSPOT_ACTION_SLOT_SIZE
273F:122C  EB F5                                jmp     short loc_169
273F:122E                       loc_170:                                        ; Inject entry into hotspot action list
273F:122E  89 17                                mov     [bx], dx
273F:1230  89 47 02                             mov     [bx+2], ax
273F:1233  C7 47 04 000F                        mov     word ptr [bx+4],0Fh
273F:1238  89 7F 06                             mov     [bx+6],di
273F:123B  C6 44 4C 01                          mov     byte ptr [si+HS_BLOCKED_FLAG], 1
273F:123F  3D 2710                              cmp     ax,2710h
273F:1242  73 1D                                jae     loc_173                 ; Jump if above or =
273F:1244  8A 5D 44                             mov     bl,[di+44h]
273F:1247  80 FB 03                             cmp     bl,3
273F:124A  74 0D                                je      loc_171                 ; Jump if equal
273F:124C  F7 45 4A FFFF                        test    word ptr [di+HS_V4A], 0FFFFh
273F:1251  75 09                                jnz     loc_172                 ; Jump if not zero
273F:1253  F6 45 44 FF                          test    byte ptr [di+HS_CHAR_MODE], 0FFh
273F:1257  75 03                                jnz     loc_172                 ; Jump if not zero
273F:1259                       loc_171:
273F:1259  89 55 47                             mov     [di+HS_USE2_HOTSPOT_ID], dx
273F:125C                       loc_172:
273F:125C  C7 45 4A 000F                        mov     word ptr [di+HS_V4A], 0Fh
273F:1261                       loc_173:
273F:1261  C7 06 10EE 0002                      mov     data_617, 2
273F:1267  5F                                   pop     di
273F:1268  5B                                   pop     bx
273F:1269  C6 07 01                             mov     byte ptr [bx], 1
273F:126C  53                                   push    bx
273F:126D  8B DD                                mov     bx,bp
273F:126F  E9 FF4D                              jmp     loc_163

                                sub_41          endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:544C, 7F46, 7F75, 7FAD, 7FFD, 811C, 8800
                                ;                             887E, 967C, 9E9E
                                ; si = hotspot resource, di = animation slot hotspot is being removed from
                                ;

273F:1272                 animation_unload      proc    near
273F:1272  C7 44 0B 0000                        mov     word ptr [si+HS_ANIM_OFFSET], 0 ; Mark hotspot as unloaded

                                ; External Entry into Subroutine 
                                ;
                                ;         Called from:   273F:1102

273F:1277                 animation_unload_2:
273F:1277 33 C0                                xor     ax,ax                   ; Clear some of the
273F:1279  88 45 0C                             mov     [di+ANIM_LAYER], al     ;   slot fields
273F:127C  89 45 1B                             mov     [di+ANIM_HOTSPOT_ID], ax
273F:127F  88 45 10                             mov     [di+ANIM_LOADED], al
273F:1282  C3                                   retn
                          animation_unload      endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                                                                                ;* No entry point to code
273F:1283 BF B14E                              mov     di, offset animation_table
273F:1286  B9 002D                              mov     cx, NUM_ANIMATION_SLOTS

273F:1289                       locloop_175:                                    ;  xref 273F:1291
273F:1289  39 5D 1E                             cmp     [di+1Eh],bx
273F:128C  74 06                                je      loc_176                 ; Jump if equal
273F:128E  83 C7 29                             add     di, ANIMATION_SLOT_SIZE
273F:1291  E2 F6                                loop    locloop_175             ; Loop if cx > 0
273F:1293  C3                                   retn

273F:1294  C6 45 0C 00          loc_176:        mov     byte ptr [di+ANIM_LAYER], 0
273F:1298                       loc_ret_177:    retn

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:010D
                                ;

273F:1299               room_handle_click       proc    near
                                                assume  ds:data_seg
273F:1299  F6 06 11DA 07                        test    mouse_buttons2, 7       ; Any mouse button pressed?
273F:129E  74 F8                                jz      loc_ret_177             ; Exit if not
273F:12A0  F6 06 0DB4 FF                        test    talk_dialog_close_flag, 0FFh ; Floating dialog active?
273F:12A5  75 2F                                jnz     loc_178                 ; If yes then jump
273F:12A7  F7 06 BA25 FFFF                      test    viewing_room, 0FFFFh    ; Viewing remote room?
273F:12AD  75 2A                                jnz     loc_179                 ; If yes then jump
273F:12AF  80 3E 9834 03                        cmp     cursor_state, CURSORSTATE_TALK
273F:12B4  74 49                                je      loc_ret_182             ; Jump if equal
273F:12B6  81 3E 11DD 0088                      cmp     char_dest_y, 80h + MENUBAR_Y_SIZE  ; In menubar area?
273F:12BC  72 42                                jb      loc_183                 ; If yes then jump
273F:12BE  80 3E 9834 02                        cmp     cursor_state, CURSORSTATE_SEQUENCE
273F:12C3  74 35                                je      loc_181                 ; Jump if equal
273F:12C5  80 3E 9834 04                        cmp     cursor_state, CURSORSTATE_BUMPED
273F:12CA  74 2E                                je      loc_181                 ; Jump if equal

273F:12CC  F6 06 11DA 01                        test    mouse_buttons2, 1
273F:12D1  75 30                                jnz     loc_184                 ; Jump if not zero
273F:12D3  E9 0154                              jmp     loc_193                 ; (142A)
273F:12D6                       loc_178:                                        ;  xref 273F:12A5
273F:12D6  E9 01A0                              jmp     loc_195                 ; (1479)

; Handle returning to a prior room from viewing another room remotely
273F:12D9                       loc_179:                                        ;  xref 273F:12AD
273F:12D9  83 3E 9832 23                        cmp     room_number, 23h
273F:12DE  75 08                                jne     loc_180                 ; Jump if not equal
273F:12E0  F7 06 BAB7 FFFF                      test    script_val_87, 0FFFFh
273F:12E6  75 12                                jnz     loc_181                 ; Jump if not zero
273F:12E8                       loc_180:
273F:12E8  C7 06 B15F 5E44                      mov     slot0_tick_proc, offset player_tick_proc
273F:12EE  A1 BA25                              mov     ax, old_room_number
273F:12F1  A3 BA23                              mov     new_room_number, ax
273F:12F4  C7 06 BA25 0000                      mov     old_room_number, 0
273F:12FA                       loc_181:                                        ;  xref 273F:12C3, 12CA, 12E6
273F:12FA  C6 06 11DA 00                        mov     mouse_buttons2, 0

273F:12FF                       loc_ret_182:                                    ;  xref 273F:12B4
273F:12FF  C3                                   retn

273F:1300                       loc_183:                                        ;  xref 273F:12BC
273F:1300  E9 5A4D                              jmp     menubar_handle_menu

; Left mouse clicked - can only be either for walking or looking at a hotspot
273F:1303                       loc_184:                                   `    ;  xref 273F:12D1
273F:1303  C6 06 11DA 00                        mov     mouse_buttons2, 0
273F:1308  F7 06 1922 FFFF                      test    dest_room_num, 0FFFFh
273F:130E  74 03                                jz      loc_185                 ; Jump if zero
273F:1310  E9 0094                              jmp     loc_190                 ; (13A7)
273F:1313                       loc_185:                                        ;  xref 273F:130E
273F:1313  A1 1924                              mov     ax, hotspot_id
273F:1316  0B C0                                or      ax,ax                   ; Clicked on hotspot?
273F:1318  74 13                                jz      loc_186                 ; If not, then jump
273F:131A BE 4CB0                              mov     si, offset exit_hotspots_list
273F:131D  8B D8                                mov     bx,ax
273F:131F  E8 3271                              call    is_roomexit_hotspot     ; Was the hotspot a room exit?
273F:1322  75 0B                                jnz     loc_187                 ; If not, then jump
273F:1324  8B C3                                mov     ax,bx
273F:1326  E8 5EC5                              call    room_exit_hs_get_pointer
273F:1329  F6 44 0C FF                          test    byte ptr [si+REHS_EXIT_BLOCKED], 0FFh ; Is exit blocked?
273F:132D                       loc_186:
273F:132D  74 78                                jz      loc_190                 ; If not blocked, standard walking

; Handler code for looking at a hotspot

273F:132F                       loc_187:
273F:132F  C6 06 9834 01                        mov     cursor_state, CURSORSTATE_ACTION
273F:1334 BE 6CEF                              mov     si, offset player_hotspot_rec
273F:1337  33 C0                                xor     ax,ax                   ; Zero register
273F:1339  89 44 52                             mov     [si+HS_DEST_HOTSPOT], ax
273F:133C  88 44 2A                             mov     [si+HS_ACTION_CTR],  al
273F:133F  89 44 42                             mov     [si+HS_DELAY_CTR], ax
273F:1342  88 44 44                             mov     [si+HS_CHAR_MODE], al
273F:1345  8B DE                                mov     bx,si
273F:1347  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:134A  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:134D BF 65F3                              mov     di, offset player_action_support_record
273F:1350  89 7F 01                             mov     [bx+CURRENT_ACTION_SUPPORT_TABLE], di
273F:1353  C7 05 0010                           mov     word ptr [di], ACTION_LOOK_AT
273F:1357  A1 1924                              mov     ax, hotspot_id
273F:135A  89 45 02                             mov     [di+2], ax
273F:135D  C7 45 04 0000                        mov     word ptr [di+4], 0
273F:1362  C6 07 02                             mov     byte ptr [bx], CHAR_ACTION_DISPATCH_ACTION
273F:1365  E8 5C9D                              call    menubar_clear_image
273F:1368 BF 4B93                              mov     di, offset action_name  ; Set up the "look at HOTSPOT"
273F:136B BE 10B5                              mov     si, offset look_at_str  ;  string
273F:136E  B9 0008                              mov     cx,8
273F:1371  1E                                   push    ds
273F:1372  07                                   pop     es
273F:1373  F3/ A4                               rep     movsb                   ; Rep when cx >0 Mov [si] to es:[di]
273F:1375  A1 1924                              mov     ax, hotspot_id
273F:1378  E8 F9A6                              call    get_room_resource_pointer3 ; Get hotspot name
273F:137B  8B 44 02                             mov     ax, [si+HSH_NAME]
273F:137E  80 E4 1F                             and     ah, 1Fh
273F:1381  E8 69B6                              call    decode_string
273F:1384  A1 4CE4                              mov     ax, data_segment2
273F:1387  8E C0                                mov     es,ax
273F:1389  33 FF                                xor     di,di                   ; Zero register
273F:138B  33 C9                                xor     cx,cx                   ; Zero register
273F:138D  8B 1E 076E                           mov     bx, data_571
273F:1391  8A 7F 04                             mov     bh,[bx+4]
273F:1394  8B 2E 0748                           mov     bp, screen_width
273F:1398 BE 4B93                              mov     si, offset action_name
273F:139B                       loc_188:                                        ; Loop to display action
273F:139B AC                                   lodsb                           ; String [si] to al
273F:139C  2C 20                                sub     al,20h                  ; ' '
273F:139E  72 06                                jc      loc_ret_189             ; Jump if carry Set
273F:13A0  FF 16 075A                           call    [display2_character_proc]
273F:13A4  EB F5                                jmp     short loc_188           ; (139B)

273F:13A6                       loc_ret_189:                                    ;  xref 273F:139E
273F:13A6  C3                                   retn

; Handler code for starting the player walking to the clicked location
273F:13A7                       loc_190:                                        ;  xref 273F:1310, 132D
273F:13A7  C7 06 11E1 0002                      mov     cursor_index, CURSOR_TIME_UP ; Start time animation
273F:13AD  8B 1E 1922                           mov     bx, dest_room_num
273F:13B1  0B DB                                or      bx,bx                   ; Going to change room?
273F:13B3  74 2C                                jz      loc_191                 ; No, so start in-room move

; Walking to another room
273F:13B5  A1 6CF5                              mov     ax, player_room_number
273F:13B8  E8 401F                              call    room_exit_get_coordinates
273F:13BB  81 E2 0FFF                           and     dx,0FFFh
273F:13BF BE 6CEF                              mov     si, offset player_hotspot_rec
273F:13C2  8B DE                                mov     bx, si
273F:13C4  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:13C7  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:13CA  89 4C 54                             mov     [si+HS_DEST_X], cx
273F:13CD  89 54 56                             mov     [si+HS_DEST_Y], dx
273F:13D0  C7 44 52 FFFF                        mov     [si+HS_DEST_HOTSPOT], 0FFFFh
273F:13D5  A1 1920                              mov     ax, room_exit_hotspot_id
273F:13D8  0B C0                                or      ax, ax
273F:13DA  74 2A                                jz      loc_192
273F:13DC  89 44 52                             mov     [si+HS_DEST_HOTSPOT], ax
273F:13DF  EB 25                                jmp     short loc_192           ; (1406)

; In room walking
273F:13E1                       loc_191:                                        ;  xref 273F:13B3
273F:13E1 BE 6CEF                              mov     si, offset player_hotspot_rec
273F:13E4  8B DE                                mov     bx,si
273F:13E6  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:13E9  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:13EC  C7 44 52 0000                        mov     [si+HS_DEST_HOTSPOT], 0
273F:13F1  C7 06 B172 0000                      mov     data_1116,0             ; (31E4:B172=0)
273F:13F7  A1 11DB                              mov     ax, char_dest_x
273F:13FA  2D 0010                              sub     ax,10h
273F:13FD  89 44 54                             mov     [si+HS_DEST_X], ax
273F:1400  A1 11DD                              mov     ax, char_dest_y
273F:1403  89 44 56                             mov     [si+HS_DEST_Y], ax
273F:1406                       loc_192:                                        ;  xref 273F:13DA, 13DF
273F:1406  C6 07 01                             mov     byte ptr [bx], CHAR_ACTION_START_WALK
273F:1409  33 C0                                xor     ax,ax                   ; Zero register
273F:140B  A2 9834                              mov     data_1084, al
273F:140E BF 65F3                              mov     di, offset player_action_support_record
273F:1411  89 7F 01                             mov     [bx+CURRENT_ACTION_SUPPORT_TABLE], di
273F:1414  89 05                                mov     [di],ax
273F:1416  88 44 FF                             mov     [si-1],al
273F:1419  88 44 2A                             mov     [si+HS_ACTION_CTR],al
273F:141C  89 44 42                             mov     [si+HS_DELAY_CTR], ax
273F:141F  88 44 44                             mov     [si+HS_CHAR_MODE], al
273F:1422  88 44 FF                             mov     [si-1],al
273F:1425  FF 16 075E                           call    word ptr [show_cursor_proc]
273F:1429  C3                                   retn

273F:142A                       loc_193:                                        ;  xref 273F:12D3
273F:142A  F6 06 11DA 04                        test    mouse_buttons2, 4
273F:142F  75 1A                                jnz     loc_194                 ; Jump if not zero

; At this point the right mouse button has been clicked for the right-click menu.
; This is either the context menu for a hotspot, or the general "Look/Status" menu

273F:1431  E8 51E0                              call    room_show_rightclick_menu
273F:1434  C7 06 11E4 FFFF                      mov     hotspot_name_id2, 0FFFFh
273F:143A  33 C0                                xor     ax,ax                   ; Zero register
273F:143C  33 DB                                xor     bx,bx                   ; Zero register
273F:143E  BD 0027                              mov     bp,27h
273F:1441  BA 0001                              mov     dx,1
273F:1444  B9 0081                              mov     cx,81h
273F:1447  E8 F739                              call    sub_21                  ; (0B83)
273F:144A  C3                                   retn
273F:144B                       loc_194:                                        ;  xref 273F:142F
273F:144B  C6 06 11DA 00                        mov     mouse_buttons2, 0
273F:1450  C3                                   retn
                        room_handle_click       endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                 sequence_set_hotspot_script    proc    near

273F:1451  E8 94 F8                             call    get_room_resource_pointer
273F:1454  80 3E 0742 02                        cmp     video_style, VIDEO_STYLE_EGA
273F:1459  75 08                                jnz     loc_194_2
273F:145B  83 F9 0C                             cmp     cx, 0Ch
273F:145E  75 03                                jnz     loc_194_2
273F:1460  83 C1 03                             add     cx, 3
273F:1463  D1 E1              loc_194_2:        shl     cx, 1
273F:1465  81 C1 57E0                           add     cx, offset hotspot_script_master_list
273F:1469  8B D9                                mov     bx, cx
273F:146B  8B 07                                mov     ax, [bx]                ; Get script offset from list
273F:146D  89 44 24                             mov     [si+HS_SCRIPT_OFFSET], ax
273F:1470  33 C0                                xor     ax, ax
273F:1472  89 44 26                             mov     word ptr [si+26h], ax
273F:1475  89 44 28                             mov     word ptr [si+28h], ax
273F:1478  C3                                   ret

                 sequence_set_hotspot_script    endp

; This code fragment is part of room_handle_click, and is called when either mouse
; button is pressed when a talk dialog is active

273F:1479                       loc_195:                                        ;  xref 273F:12D6
273F:1479  C6 06 11DA 00                        mov     mouse_buttons2, 0
273F:147E  A1 983B                              mov     ax, talk_character_id
273F:1481  E8 F866                              call    get_room_resource_pointer2
273F:1484  C7 44 37 0000                        mov     word ptr [si+37h],0
273F:1489  A1 9841                              mov     ax, data_1091  
273F:148C  0B C0                                or      ax,ax                   ; Zero ?
273F:148E  74 0F                                jz      loc_196                 ; Jump if zero
273F:1490  E8 F857                              call    get_room_resource_pointer2
273F:1493  F7 44 37 FFFF                        test    word ptr [si+37h],0FFFFh
273F:1498  74 05                                jz      loc_196                 ; Jump if zero
273F:149A  C7 44 37 0028                        mov     word ptr [si+37h],28h
273F:149F                       loc_196:                                        ;  xref 273F:148E, 1498
273F:149F  E9 4E23                              jmp     loc_1248                ; (62C5)
                                sub_44          endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:7B07, 8FC8, 93BE
                                ;

273F:14A2                       sub_45          proc    near
273F:14A2 BE B883                              mov     si, offset animation_block_list
273F:14A5                       loc_197:                                        ;  xref 273F:14B5
273F:14A5 AD                                   lodsw                           ; String [si] to ax
273F:14A6  0B C0                                or      ax,ax
273F:14A8  74 0D                                jz      loc_ret_198             ; End of list found
273F:14AA  8B F8                                mov     di,ax
273F:14AC  C7 45 03 0000                        mov     word ptr [di+3],0
273F:14B1  80 65 02 DF                          and     byte ptr [di+2],0DFh
273F:14B5  EB EE                                jmp     short loc_197           ; (14A5)

273F:14B7                       loc_ret_198:                                    ;  xref 273F:14A8
273F:14B7  C3                                   retn
                                sub_45          endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:012A, 1F8B, 1F9E, 93EF
                                ;

273F:14B8                  set_vga_palette      proc    near
273F:14B8  80 3E 0742 02                        cmp     video_style, VIDEO_STYLE_EGA
273F:14BD  74 40                                je      loc_ret_201             ; Jump if equal
273F:14BF  81 3E F010 2EE0                      cmp     timer_ticks, TIMER_TICKS_MAX
273F:14C5  72 38                                jb      loc_ret_201             ; Jump if below
273F:14C7  1E                                   push    ds
273F:14C8  07                                   pop     es
273F:14C9 BE 1457                              mov     si,offset unprocessed_vga_palette
273F:14CC BF 0DB5                              mov     di,offset processed_vga_palette
273F:14CF  B9 0300                              mov     cx,300h

273F:14D2                       locloop_199:                                    ;  xref 273F:14D6
273F:14D2  AC                                   lodsb                           ; String [si] to al
273F:14D3  D0 E8                                shr     al,1                    ; Shift w/zeros fill
273F:14D5  AA                                   stosb                           ; Store al to es:[di]
273F:14D6  E2 FA                                loop    locloop_199             ; Loop if cx > 0

273F:14D8 BA 0DB5                              mov     dx,offset processed_vga_palette
273F:14DB  B8 1012                              mov     ax,1012h
273F:14DE  BB 0000                              mov     bx,0
273F:14E1  B9 0100                              mov     cx,100h
273F:14E4  CD 10                                int     10h                     ; Video display   ah=functn 10h
                                                                                ;  set cx color registers from
                                                                                ;   ptr es:dx, bx=first reg
273F:14E6                       loc_200:                                        ;  xref 273F:14EF
273F:14E6  E8 7EDF                              call    room_check_keypresses
273F:14E9  81 3E F010 2EE0                      cmp     timer_ticks, TIMER_TICKS_MAX
273F:14EF  73 F5                                jae     loc_200                 ; Jump if above or =
273F:14F1 BA 1457                              mov     dx,offset unprocessed_vga_palette
273F:14F4  B8 1012                              mov     ax,1012h
273F:14F7  BB 0000                              mov     bx,0
273F:14FA  B9 0100                              mov     cx,100h
273F:14FD  CD 10                                int     10h                     ; Video display   ah=functn 10h
                                                                                ;  set cx color registers from
                                                                                ;   ptr es:dx, bx=first reg

273F:14FF                       loc_ret_201:                                    ;  xref 273F:14BD, 14C5
273F:14FF  C3                                   retn
                           set_vga_palette      endp

273F:1500  00 00                data_215        db      0, 0                    ;  xref 273F:2C88, 2D34, 2E9A, 2EA3
                                                                                ;            37F2, 385B, 38FB
273F:1502  0000                 data_216        dw      0                       ;  xref 273F:2C8C, 2D3C, 2EA8
273F:1504  00                   data_217        db      0                       ;  xref 273F:2C90, 2D6E, 2F47
273F:1505  0000                 data_218        dw      0                       ;  xref 273F:2D0B, 2F86, 3869, 388E
                                                                                ;            3939
273F:1507  0000                 data_219        dw      0                       ;  xref 273F:2D03, 2F8C
273F:1509  00                   data_220        db      0                       ;  xref 273F:2CFF, 2D42, 2D69, 2DBA
                                                                                ;            2E95
273F:150A  00 00 00 00                          db      0, 0, 0, 0

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:00A9, 00BB, 011D, 4171, 6A0D, 6E4B, 70D1
                                ;                             8922, 8FF3, 9769
                                ;

273F:150E               room_add_animations     proc    near
273F:150E  B9 002D                              mov     cx, NUM_ANIMATION_SLOTS
273F:1511 BB B14E                              mov     bx, offset animation_table

; This first part adds in any active hotspots for layer 3

273F:1514                       locloop_202:                                    ;  xref 273F:1551
273F:1514  80 7F 0C 03                          cmp     byte ptr [bx+ANIM_LAYER], 3 ; Is hotspot in layer 3?
273F:1518  75 34                                jne     loc_206                 ; If found, then skip entry
273F:151A  8B 16 9832                           mov     dx, room_number
273F:151E  39 57 0E                             cmp     [bx+ANIM_ROOM_NUM], dx  ; Is animation for room?
273F:1521  75 2B                                jne     loc_206                 ; If no, then skip
273F:1523  51                                   push    cx
273F:1524  53                                   push    bx
273F:1525  8B 47 0A                             mov     ax, [bx+ANIM_SEGMENT]
273F:1528  0B C0                                or      ax,ax                   ; Zero ?
273F:152A  75 05                                jnz     loc_203                 ; Jump if not zero
273F:152C  E8 61CE                              call    animation_resolve_segment
273F:152F  72 1B                                jc      loc_205                 ; Jump if carry Set
273F:1531                       loc_203:                                        ;  xref 273F:152A
273F:1531  8E C0                                mov     es,ax
273F:1533  8B 77 08                             mov     si, [bx+ANIM_FRAME_OFFSET]
273F:1536  FF 16 0754                           call    [add_animation_proc]
273F:153A  5F                                   pop     di
273F:153B  57                                   push    di
273F:153C  B0 01                                mov     al,1
273F:153E  F6 45 0D FF                          test    byte ptr [di+ANIM_FLAGS], 0FFh
273F:1542  74 02                                jz      loc_204                 ; Jump if zero
273F:1544  B0 81                                mov     al, 81h
273F:1546                       loc_204:                                        ;  xref 273F:1542
273F:1546  E8 F5DF                              call    flag_covered_cells
273F:1549  E8 F509                              call    room_add_layer
273F:154C                       loc_205:                                        ;  xref 273F:152F
273F:154C  5B                                   pop     bx
273F:154D  59                                   pop     cx
273F:154E                       loc_206:                                        ;  xref 273F:1518, 1521
273F:154E  83 C3 29                             add     bx, ANIMATION_SLOT_SIZE
273F:1551  E2 C1                                loop    locloop_202             ; Loop if cx > 0

; Next Get a set of animations where the layer = 1, forming a list of
; the animation slot entries and the bottom row of the animation

273F:1553 BF B14E                              mov     di, offset animation_table
273F:1556 BE 10F0                              mov     si, offset animation_table2
273F:1559  8B 16 9832                           mov     dx, room_number
273F:155D  B9 002D                              mov     cx, NUM_ANIMATION_SLOTS
273F:1560  33 DB                                xor     bx,bx                   ; Number of anims found
273F:1562                       locloop_207:
273F:1562  80 7D 0C 01                          cmp     byte ptr [di+ANIM_LAYER], 1 ; Animation is layer 1?
273F:1566  75 1E                                jne     loc_208                 ; If not, then skip
273F:1568  39 55 0E                             cmp     [di+ANIM_ROOM_NUM], dx  ; Animation in the room?
273F:156B  75 19                                jne     loc_208                 ; If not, skip animation
273F:156D  F6 45 1D FF                          test    byte ptr [di+ANIM_SKIP], 0FFh
273F:1571  75 13                                jnz     loc_208                 ; Jump if not zero
273F:1573  8B 45 02                             mov     ax,[di+ANIM_Y]          ; Get Y start
273F:1576  03 45 15                             add     ax,[di+ANIM_HEIGHT_COPY] ; Copy height
273F:1579  89 3C                                mov     [si],di                 ; Store anim offset
273F:157B  83 C6 02                             add     si, 2
273F:157E  89 04                                mov     [si], ax                ; Store bottom row
273F:1580  83 C6 02                             add     si,2
273F:1583  83 C3 01                             add     bx,1                    ; Increment number found
273F:1586                       loc_208:
273F:1586  83 C7 29                             add     di, ANIMATION_SLOT_SIZE
273F:1589  E2 D7                                loop    locloop_207             ; Loop if cx > 0

; This next part sorts the newly formed list by the bottom row of each

273F:158B  83 FB 01                             cmp     bx,1
273F:158E  8B CB                                mov     cx,bx
273F:1590  72 67                                jc      loc_217                 ; No entries
273F:1592  74 2F                                jz      loc_212                 ; Only one entry
273F:1594  51                                   push    cx
273F:1595  83 E9 01                             sub     cx,1
273F:1598                       locloop_209:                                    ;  xref 273F:15C0
273F:1598 BE 10F0                              mov     si,offset animation_table2
273F:159B  51                                   push    cx
273F:159C                       locloop_210:                                    ;  xref 273F:15BD
273F:159C  8B 44 06                             mov     ax, [si+6]         
273F:159F  3B 44 02                             cmp     ax, [si+2]
273F:15A2  73 16                                jae     loc_211
273F:15A4  8B 04                                mov     ax,[si]
273F:15A6  8B 5C 04                             mov     bx,[si+4]
273F:15A9  89 1C                                mov     [si],bx
273F:15AB  89 44 04                             mov     [si+4],ax
273F:15AE  8B 44 02                             mov     ax,[si+2]
273F:15B1  8B 5C 06                             mov     bx,[si+6]
273F:15B4  89 5C 02                             mov     [si+2],bx
273F:15B7  89 44 06                             mov     [si+6],ax
273F:15BA                       loc_211:
273F:15BA  83 C6 04                             add     si, 4
273F:15BD  E2 DD                                loop    locloop_210             ; Loop if cx > 0

273F:15BF  59                                   pop     cx
273F:15C0  E2 D6                                loop    locloop_209             ; Loop if cx > 0

273F:15C2  59                                   pop     cx
273F:15C3                       loc_212:                                        ;  xref 273F:1592

; Add in the animations in order of the sorted list

273F:15C3  BE 10F0                              mov     si, offset animation_table2
273F:15C6                       locloop_213:                                    ;  xref 273F:15F7
273F:15C6  8B 1C                                mov     bx, [si]
273F:15C8  56                                   push    si
273F:15C9  51                                   push    cx
273F:15CA  53                                   push    bx
273F:15CB  8B 47 0A                             mov     ax,[bx+ANIM_SEGMENT]
273F:15CE  0B C0                                or      ax,ax                   ; Zero ?
273F:15D0  75 08                                jnz     loc_214                 ; Jump if not zero
273F:15D2  E8 6128                              call    animation_resolve_segment
273F:15D5  73 03                                jnc     loc_214                 ; Jump if carry=0
273F:15D7  5F                                   pop     di
273F:15D8  EB 18                                jmp     short loc_216           ; (15F2)
273F:15DA                       loc_214:                                        ;  xref 273F:15D0, 15D5
273F:15DA  8E C0                                mov     es,ax
273F:15DC  8B 77 08                             mov     si,[bx+ANIM_FRAME_OFFSET]
273F:15DF  FF 16 0754                           call    [add_animation_proc]
273F:15E3  5F                                   pop     di
273F:15E4  F6 45 0D FF                          test    byte ptr [di+ANIM_FLAGS], 0FFh
273F:15E8  74 05                                jz      loc_215                 ; Jump if zero
273F:15EA  B0 81                                mov     al, 81h
273F:15EC  E8 F539                              call    flag_covered_cells
273F:15EF                       loc_215:                                        ;  xref 273F:15E8
273F:15EF  E8 F463                              call    room_add_layer
273F:15F2                       loc_216:                                        ;  xref 273F:15D8
273F:15F2  59                                   pop     cx
273F:15F3  5E                                   pop     si
273F:15F4  83 C6 04                             add     si,4
273F:15F7  E2 CD                                loop    locloop_213             ; Loop if cx > 0

; Add in animations for layer 2

273F:15F9                       loc_217:                                        ;  xref 273F:1590
273F:15F9  B9 002D                              mov     cx, NUM_ANIMATION_SLOTS
273F:15FC BB B14E                              mov     bx, offset animation_table

273F:15FF                       locloop_218:
273F:15FF  80 7F 0C 02                          cmp     byte ptr [bx+ANIM_LAYER],2
273F:1603  75 31                                jne     loc_222                 ; Jump if not equal
273F:1605  8B 16 9832                           mov     dx, room_number
273F:1609  39 57 0E                             cmp     [bx+ANIM_ROOM_NUM], dx
273F:160C  75 28                                jne     loc_222                 ; Jump if not equal
273F:160E  51                                   push    cx
273F:160F  53                                   push    bx
273F:1610  8B 47 0A                             mov     ax,[bx+ANIM_SEGMENT]
273F:1613  0B C0                                or      ax,ax                   ; Zero ?
273F:1615  75 05                                jnz     loc_219                 ; Jump if not zero
273F:1617  E8 60E3                              call    animation_resolve_segment
273F:161A  72 18                                jc      loc_221                 ; Jump if carry Set
273F:161C                       loc_219:                                        ;  xref 273F:1615
273F:161C  8E C0                                mov     es,ax
273F:161E  8B 77 08                             mov     si, [bx+ANIM_FRAME_OFFSET]
273F:1621  FF 16 0754                           call    [add_animation_proc]
273F:1625  5F                                   pop     di
273F:1626  57                                   push    di
273F:1627  B0 01                                mov     al,1
273F:1629  F6 45 0D FF                          test    byte ptr [di+ANIM_FLAGS],0FFh
273F:162D  74 02                                jz      loc_220                 ; Jump if zero
273F:162F  B0 81                                mov     al, 81h
273F:1631                       loc_220:                                        ;  xref 273F:162D
273F:1631  E8 F4F4                              call    flag_covered_cells
273F:1634                       loc_221:                                        ;  xref 273F:161A
273F:1634  5B                                   pop     bx
273F:1635  59                                   pop     cx
273F:1636                       loc_222:                                        ;  xref 273F:1603, 160C
273F:1636  83 C3 29                             add     bx, ANIMATION_SLOT_SIZE
273F:1639  E2 C4                                loop    locloop_218             ; Loop if cx > 0

273F:163B  F6 06 9837 FF                        test    talk_dialog_active, 0FFh
273F:1640  74 04                                jz      loc_ret_223             ; Jump if zero
273F:1642  FF 16 0758                           call    [talk_dialog_proc]

273F:1646                       loc_ret_223:                                    ;  xref 273F:1640
273F:1646  C3                                   retn
                        room_add_animations     endp

273F:1647  00                                   db      0

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:7D4E, 7D60
                                ;

273F:1648               decode_character        proc    near
273F:1648  E8 675A                              call    read_bit
273F:164B  74 03                                jz      loc_224                 ; Jump if zero
273F:164D  EB 3B                                jmp     short loc_235           ; (168A)
273F:164F  90                                   db      90h
273F:1650                       loc_224:                                        ; 0
273F:1650  E8 6752                              call    read_bit
273F:1653  74 03                                jz      loc_225                 ; Jump if zero
273F:1655  EB 04                                jmp     short loc_226           ; (165B)
273F:1657  90                                   db      90h
273F:1658                       loc_225:                                        ; 00
273F:1658  B0 20                                mov     al,20h                  ; ' '
273F:165A  C3                                   retn
273F:165B                       loc_226:                                        ; 01
273F:165B  E8 6747                              call    read_bit
273F:165E  74 03                                jz      loc_227                 ; Jump if zero
273F:1660  EB 0F                                jmp     short loc_230           ; (1671)
273F:1662  90                                   db      90h
273F:1663                       loc_227:                                        ; 010
273F:1663  E8 673F                              call    read_bit
273F:1666  74 03                                jz      loc_228                 ; Jump if zero
273F:1668  EB 04                                jmp     short loc_229           ; (166E)
273F:166A  90                                   db      90h
273F:166B                       loc_228:                                        ; 0100
273F:166B  B0 65                                mov     al,65h                  ; 'e'
273F:166D  C3                                   retn
273F:166E                       loc_229:                                        ; 0101
273F:166E  B0 6F                                mov     al,6Fh                  ; 'o'
273F:1670  C3                                   retn
273F:1671                       loc_230:                                        ; 011
273F:1671  E8 6731                              call    read_bit
273F:1674  74 03                                jz      loc_231
273F:1676  EB 04                                jmp     short loc_232
273F:1678  90                                   db      90h
273F:1679                       loc_231:                                        ; 0110
273F:1679  B0 74                                mov     al,74h                  ; 't'
273F:167B  C3                                   retn
273F:167C                       loc_232:                                        ; 0111
273F:167C  E8 6726                              call    read_bit
273F:167F  74 03                                jz      loc_233                 ; Jump if zero
273F:1681  EB 04                                jmp     short loc_234           ; (1687)
273F:1683  90                                   db      90h
273F:1684                       loc_233:                                        ; 01110
273F:1684  B0 61                                mov     al,61h                  ; 'a'
273F:1686  C3                                   retn
273F:1687                       loc_234:                                        ; 01111
273F:1687  B0 6E                                mov     al,6Eh                  ; 'n'
273F:1689  C3                                   retn
273F:168A                       loc_235:                                        ; 1
273F:168A  E8 6718                              call    read_bit
273F:168D  74 03                                jz      loc_236                 ; Jump if zero
273F:168F  EB 46                                jmp     short loc_249           ; (16D7)
273F:1691  90                                   db      90h
273F:1692                       loc_236:                                        ; 10
273F:1692  E8 6710                              call    read_bit
273F:1695  74 03                                jz      loc_237                 ; Jump if zero
273F:1697  EB 0F                                jmp     short loc_240           ; (16A8)
273F:1699  90                                   db      90h
273F:169A                       loc_237:                                        ; 100
273F:169A  E8 6708                              call    read_bit
273F:169D  74 03                                jz      loc_238                 ; Jump if zero
273F:169F  EB 04                                jmp     short loc_239           ; (16A5)
273F:16A1  90                                   db      90h
273F:16A2                       loc_238:                                        ; 1000
273F:16A2  B0 73                                mov     al,73h                  ; 's'
273F:16A4  C3                                   retn
273F:16A5                       loc_239:                                        ; 1001
273F:16A5  B0 69                                mov     al,69h                  ; 'i'
273F:16A7  C3                                   retn
273F:16A8                       loc_240:                                        ; 101
273F:16A8  E8 66FA                              call    read_bit
273F:16AB  74 03                                jz      loc_241                 ; Jump if zero
273F:16AD  EB 04                                jmp     short loc_242           ; (16B3)
273F:16AF  90                                   db      90h
273F:16B0                       loc_241:                                        ; 1010
273F:16B0  B0 72                                mov     al,72h                  ; 'r'
273F:16B2  C3                                   retn
273F:16B3                       loc_242:                                        ; 1011
273F:16B3  E8 66EF                              call    read_bit
273F:16B6  74 03                                jz      loc_243                 ; Jump if zero
273F:16B8  EB 04                                jmp     short loc_244           ; (16BE)
273F:16BA  90                                   db      90h
273F:16BB                       loc_243:                                        ; 10110
273F:16BB  B0 68                                mov     al,68h                  ; 'h'
273F:16BD  C3                                   retn
273F:16BE                       loc_244:                                        ; 10111
273F:16BE  E8 66E4                              call    read_bit
273F:16C1  74 03                                jz      loc_245                 ; Jump if zero
273F:16C3  EB 04                                jmp     short loc_246           ; (16C9)
273F:16C5  90                                   db      90h
273F:16C6                       loc_245:                                        ; 101110
273F:16C6  B0 75                                mov     al,75h                  ; 'u'
273F:16C8  C3                                   retn
273F:16C9                       loc_246:                                        ; 101111
273F:16C9  E8 66D9                              call    read_bit
273F:16CC  74 03                                jz      loc_247                 ; Jump if zero
273F:16CE  EB 04                                jmp     short loc_248           ; (16D4)
273F:16D0  90                                   db      90h
273F:16D1                       loc_247:                                        ; 1011110
273F:16D1  B0 6C                                mov     al,6Ch                  ; 'l'
273F:16D3  C3                                   retn
273F:16D4                       loc_248:                                        ; 1011111
273F:16D4  B0 64                                mov     al,64h                  ; 'd'
273F:16D6  C3                                   retn
273F:16D7                       loc_249:                                        ; 11
273F:16D7  E8 66CB                              call    read_bit
273F:16DA  74 03                                jz      loc_250                 ; Jump if zero
273F:16DC  EB 51                                jmp     short loc_265           ; (172F)
273F:16DE  90                                   db      90h
273F:16DF                       loc_250:                                        ; 110
273F:16DF  E8 66C3                              call    read_bit
273F:16E2  74 03                                jz      loc_251                 ; Jump if zero
273F:16E4  EB 1A                                jmp     short loc_256           ; (1700)
273F:16E6  90                                   db      90h
273F:16E7                       loc_251:                                        ; 1100
273F:16E7  E8 66BB                              call    read_bit
273F:16EA  74 03                                jz      loc_252                 ; Jump if zero
273F:16EC  EB 04                                jmp     short loc_253           ; (16F2)
273F:16EE  90                                   db      90h
273F:16EF                       loc_252:                                        ; 11000
273F:16EF  B0 79                                mov     al,79h                  ; 'y'
273F:16F1  C3                                   retn
273F:16F2                       loc_253:                                        ; 11001
273F:16F2  E8 66B0                              call    read_bit
273F:16F5  74 03                                jz      loc_254                 ; Jump if zero
273F:16F7  EB 04                                jmp     short loc_255           ; (16FD)
273F:16F9  90                                   db      90h
273F:16FA                       loc_254:                                        ; 110010
273F:16FA  B0 67                                mov     al,67h                  ; 'g'
273F:16FC  C3                                   retn
273F:16FD                       loc_255:                                        ; 110011
273F:16FD  B0 00                                mov     al,0
273F:16FF  C3                                   retn
273F:1700                       loc_256:                                        ; 1101
273F:1700  E8 66A2                              call    read_bit
273F:1703  74 03                                jz      loc_257                 ; Jump if zero
273F:1705  EB 0F                                jmp     short loc_260           ; (1716)
273F:1707  90                                   db      90h
273F:1708                       loc_257:                                        ; 11010
273F:1708  E8 669A                              call    read_bit
273F:170B  74 03                                jz      loc_258                 ; Jump if zero
273F:170D  EB 04                                jmp     short loc_259           ; (1713)
273F:170F  90                                   db      90h
273F:1710                       loc_258:                                        ; 110100
273F:1710  B0 77                                mov     al,77h                  ; 'w'
273F:1712  C3                                   retn
273F:1713                       loc_259:                                        ; 110101
273F:1713  B0 63                                mov     al,63h                  ; 'c'
273F:1715  C3                                   retn
273F:1716                       loc_260:                                        ; 11011
273F:1716  E8 668C                              call    read_bit
273F:1719  74 03                                jz      loc_261                 ; Jump if zero
273F:171B  EB 04                                jmp     short loc_262           ; (1721)
273F:171D  90                                   db      90h
273F:171E                       loc_261:                                        ; 110110
273F:171E  B0 66                                mov     al,66h                  ; 'f'
273F:1720  C3                                   retn
273F:1721                       loc_262:                                        ; 110111
273F:1721  E8 6681                              call    read_bit
273F:1724  74 03                                jz      loc_263                 ; Jump if zero
273F:1726  EB 04                                jmp     short loc_264           ; (172C)
273F:1728  90                                   db      90h
273F:1729                       loc_263:                                        ; 1101110
273F:1729  B0 2E                                mov     al,2Eh                  ; '.'
273F:172B  C3                                   retn
273F:172C                       loc_264:                                        ; 1101111
273F:172C  B0 6D                                mov     al,6Dh                  ; 'm'
273F:172E  C3                                   retn
273F:172F                       loc_265:                                        ; 111
273F:172F  E8 6673                              call    read_bit
273F:1732  74 03                                jz      loc_266                 ; Jump if zero
273F:1734  EB 46                                jmp     short loc_279           ; (177C)
273F:1736  90                                   db      90h
273F:1737                       loc_266:                                        ; 1110
273F:1737  E8 666B                              call    read_bit
273F:173A  74 03                                jz      loc_267                 ; Jump if zero
273F:173C  EB 0F                                jmp     short loc_270           ; (174D)
273F:173E  90                                   db      90h
273F:173F                       loc_267:                                        ; 11100
273F:173F  E8 6663                              call    read_bit
273F:1742  74 03                                jz      loc_268                 ; Jump if zero
273F:1744  EB 04                                jmp     short loc_269           ; (174A)
273F:1746  90                                   db      90h
273F:1747                       loc_268:                                        ; 111000
273F:1747  B0 70                                mov     al,70h                  ; 'p'
273F:1749  C3                                   retn
273F:174A                       loc_269:                                        ; 111001
273F:174A  B0 62                                mov     al,62h                  ; 'b'
273F:174C  C3                                   retn
273F:174D                       loc_270:                                        ; 11101
273F:174D  E8 6655                              call    read_bit
273F:1750  74 03                                jz      loc_271                 ; Jump if zero
273F:1752  EB 0F                                jmp     short loc_274           ; (1763)
273F:1754  90                                   db      90h
273F:1755                       loc_271:                                        ; 111010
273F:1755  E8 664D                              call    read_bit
273F:1758  74 03                                jz      loc_272                 ; Jump if zero
273F:175A  EB 04                                jmp     short loc_273           ; (1760)
273F:175C  90                                   db      90h
273F:175D                       loc_272:                                        ; 1110100
273F:175D  B0 2C                                mov     al,2Ch                  ; ','
273F:175F  C3                                   retn
273F:1760                       loc_273:                                        ; 1110101
273F:1760  B0 6B                                mov     al,6Bh                  ; 'k'
273F:1762  C3                                   retn
273F:1763                       loc_274:                                        ; 111011
273F:1763  E8 663F                              call    read_bit
273F:1766  74 03                                jz      loc_275                 ; Jump if zero
273F:1768  EB 04                                jmp     short loc_276           ; (176E)
273F:176A  90                                   db      90h
273F:176B                       loc_275:                                        ; 1110110
273F:176B  B0 27                                mov     al,27h                  ; '''
273F:176D  C3                                   retn
273F:176E                       loc_276:                                        ; 1110111
273F:176E  E8 6634                              call    read_bit
273F:1771  74 03                                jz      loc_277                 ; Jump if zero
273F:1773  EB 04                                jmp     short loc_278           ; (1779)
273F:1775  90                                   db      90h
273F:1776                       loc_277:                                        ; 11101110
273F:1776  B0 49                                mov     al,49h                  ; 'I'
273F:1778  C3                                   retn
273F:1779                       loc_278:                                        ; 11101111
273F:1779  B0 76                                mov     al,76h                  ; 'v'
273F:177B  C3                                   retn
273F:177C                       loc_279:                                        ; 1111
273F:177C  E8 6626                              call    read_bit
273F:177F  74 03                                jz      loc_280                 ; Jump if zero
273F:1781  EB 46                                jmp     short loc_293           ; (17C9)
273F:1783  90                                   db      90h
273F:1784                       loc_280:                                        ; 11110
273F:1784  E8 661E                              call    read_bit
273F:1787  74 03                                jz      loc_281                 ; Jump if zero
273F:1789  EB 0F                                jmp     short loc_284           ; (179A)
273F:178B  90                                   db      90h
273F:178C                       loc_281:                                        ; 111100
273F:178C  E8 6616                              call    read_bit
273F:178F  74 03                                jz      loc_282                 ; Jump if zero
273F:1791  EB 04                                jmp     short loc_283           ; (1797)
273F:1793  90                                   db      90h
273F:1794                       loc_282:                                        ; 1111000
273F:1794  B0 21                                mov     al,21h                  ; '!'
273F:1796  C3                                   retn
273F:1797                       loc_283:                                        ; 1111001
273F:1797  B0 B4                                mov     al,0B4h
273F:1799  C3                                   retn
273F:179A                       loc_284:                                        ; 111101
273F:179A  E8 6608                              call    read_bit
273F:179D  74 03                                jz      loc_285                 ; Jump if zero
273F:179F  EB 0F                                jmp     short loc_288           ; (17B0)
273F:17A1  90                                   db      90h
273F:17A2                       loc_285:                                        ; 1111010
273F:17A2  E8 6600                              call    read_bit
273F:17A5  74 03                                jz      loc_286                 ; Jump if zero
273F:17A7  EB 04                                jmp     short loc_287           ; (17AD)
273F:17A9  90                                   db      90h
273F:17AA                       loc_286:                                        ; 11110100
273F:17AA  B0 54                                mov     al,54h                  ; 'T'
273F:17AC  C3                                   retn
273F:17AD                       loc_287:                                        ; 11110101
273F:17AD  B0 B5                                mov     al,0B5h
273F:17AF  C3                                   retn
273F:17B0                       loc_288:                                        ; 1111011
273F:17B0  E8 65F2                              call    read_bit
273F:17B3  74 03                                jz      loc_289                 ; Jump if zero
273F:17B5  EB 04                                jmp     short loc_290           ; (17BB)
273F:17B7  90                                   db      90h
273F:17B8                       loc_289:                                        ; 11110110
273F:17B8  B0 3F                                mov     al,3Fh                  ; '?'
273F:17BA  C3                                   retn
273F:17BB                       loc_290:                                        ; 11110111
273F:17BB  E8 65E7                              call    read_bit
273F:17BE  74 03                                jz      loc_291                 ; Jump if zero
273F:17C0  EB 04                                jmp     short loc_292           ; (17C6)
273F:17C2  90                                   db      90h
273F:17C3                       loc_291:                                        ; 111101110
273F:17C3  B0 B2                                mov     al,0B2h
273F:17C5  C3                                   retn
273F:17C6                       loc_292:                                        ; 111101111
273F:17C6  B0 B3                                mov     al,0B3h
273F:17C8  C3                                   retn
273F:17C9                       loc_293:                                        ; 11111
273F:17C9  E8 65D9                              call    read_bit
273F:17CC  74 03                                jz      loc_294                 ; Jump if zero
273F:17CE  EB 5C                                jmp     short loc_311           ; (182C)
273F:17D0  90                                   db      90h
273F:17D1                       loc_294:                                        ; 111110
273F:17D1  E8 65D1                              call    read_bit
273F:17D4  74 03                                jz      loc_295                 ; Jump if zero
273F:17D6  EB 1A                                jmp     short loc_300           ; (17F2)
273F:17D8  90                                   db      90h
273F:17D9                       loc_295:                                        ; 1111100
273F:17D9  E8 65C9                              call    read_bit
273F:17DC  74 03                                jz      loc_296                 ; Jump if zero
273F:17DE  EB 04                                jmp     short loc_297           ; (17E4)
273F:17E0  90                                   db      90h
273F:17E1                       loc_296:                                        ; 11111000
273F:17E1  B0 57                                mov     al,57h                  ; 'W'
273F:17E3  C3                                   retn
273F:17E4                       loc_297:                                        ; 11111001
273F:17E4  E8 65BE                              call    read_bit
273F:17E7  74 03                                jz      loc_298                 ; Jump if zero
273F:17E9  EB 04                                jmp     short loc_299           ; (17EF)
273F:17EB  90                                   db      90h
273F:17EC                       loc_298:                                        ; 111110010
273F:17EC  B0 48                                mov     al,48h                  ; 'H'
273F:17EE  C3                                   retn
273F:17EF                       loc_299:                                        ; 111110011
273F:17EF  B0 41                                mov     al,41h                  ; 'A'
273F:17F1  C3                                   retn
273F:17F2                       loc_300:                                        ; 1111101
273F:17F2  E8 65B0                              call    read_bit
273F:17F5  74 03                                jz      loc_301                 ; Jump if zero
273F:17F7  EB 0F                                jmp     short loc_304           ; (1808)
273F:17F9  90                                   db      90h
273F:17FA                       loc_301:                                        ; 11111010
273F:17FA  E8 65A8                              call    read_bit
273F:17FD  74 03                                jz      loc_302                 ; Jump if zero
273F:17FF  EB 04                                jmp     short loc_303           ; (1805)
273F:1801  90                                   db      90h
273F:1802                       loc_302:                                        ; 111110100
273F:1802  B0 B1                                mov     al,0B1h
273F:1804  C3                                   retn
273F:1805                       loc_303:                                        ; 111110101
273F:1805  B0 53                                mov     al,53h                  ; 'S'
273F:1807  C3                                   retn
273F:1808                       loc_304:                                        ; 11111011
273F:1808  E8 659A                              call    read_bit
273F:180B  74 03                                jz      loc_305                 ; Jump if zero
273F:180D  EB 04                                jmp     short loc_306           ; (1813)
273F:180F  90                                   db      90h
273F:1810                       loc_305:                                        ; 111110110
273F:1810  B0 59                                mov     al,59h                  ; 'Y'
273F:1812  C3                                   retn
273F:1813                       loc_306:                                        ; 111110111
273F:1813  E8 658F                              call    read_bit
273F:1816  74 03                                jz      loc_307                 ; Jump if zero
273F:1818  EB 04                                jmp     short loc_308           ; (181E)
273F:181A  90                                   db      90h
273F:181B                       loc_307:                                        ; 1111101110
273F:181B  B0 47                                mov     al,47h                  ; 'G'
273F:181D  C3                                   retn
273F:181E                       loc_308:                                        ; 1111101111
273F:181E  E8 6584                              call    read_bit
273F:1821  74 03                                jz      loc_309                 ; Jump if zero
273F:1823  EB 04                                jmp     short loc_310           ; (1829)
273F:1825  90                                   db      90h
273F:1826                       loc_309:                                        ; 11111011110
273F:1826  B0 4D                                mov     al,4Dh                  ; 'M'
273F:1828  C3                                   retn
273F:1829                       loc_310:                                        ; 11111011111
273F:1829  B0 4E                                mov     al,4Eh                  ; 'N'
273F:182B  C3                                   retn
273F:182C                       loc_311:                                        ; 111111
273F:182C  E8 6576                              call    read_bit
273F:182F  74 03                                jz      loc_312                 ; Jump if zero
273F:1831  EB 51                                jmp     short loc_327           ; (1884)
273F:1833  90                                   db      90h
273F:1834                       loc_312:                                        ; 1111110
273F:1834  E8 656E                              call    read_bit
273F:1837  74 03                                jz      loc_313                 ; Jump if zero
273F:1839  EB 1A                                jmp     short loc_318           ; (1855)
273F:183B  90                                   db      90h
273F:183C                       loc_313:                                        ; 11111100
273F:183C  E8 6566                              call    read_bit
273F:183F  74 03                                jz      loc_314                 ; Jump if zero
273F:1841  EB 04                                jmp     short loc_315           ; (1847)
273F:1843  90                                   db      90h
273F:1844                       loc_314:                                        ; 111111000
273F:1844  B0 4F                                mov     al,4Fh                  ; 'O'
273F:1846  C3                                   retn
273F:1847                       loc_315:                                        ; 111111001
273F:1847  E8 655B                              call    read_bit
273F:184A  74 03                                jz      loc_316                 ; Jump if zero
273F:184C  EB 04                                jmp     short loc_317           ; (1852)
273F:184E  90                                   db      90h
273F:184F                       loc_316:                                        ; 1111110010
273F:184F  B0 45                                mov     al,45h                  ; 'E'
273F:1851  C3                                   retn
273F:1852                       loc_317:                                        ; 1111110011
273F:1852  B0 4C                                mov     al,4Ch                  ; 'L'
273F:1854  C3                                   retn
273F:1855                       loc_318:                                        ; 11111101
273F:1855  E8 654D                              call    read_bit
273F:1858  74 03                                jz      loc_319                 ; Jump if zero
273F:185A  EB 0F                                jmp     short loc_322           ; (186B)
273F:185C  90                                   db      90h
273F:185D                       loc_319:                                        ; 111111010
273F:185D  E8 6545                              call    read_bit
273F:1860  74 03                                jz      loc_320                 ; Jump if zero
273F:1862  EB 04                                jmp     short loc_321           ; (1868)
273F:1864  90                                   db      90h
273F:1865                       loc_320:                                        ; 1111110100
273F:1865  B0 2D                                mov     al,2Dh                  ; '-'
273F:1867  C3                                   retn
273F:1868                       loc_321:                                        ; 1111110101
273F:1868  B0 52                                mov     al,52h                  ; 'R'
273F:186A  C3                                   retn
273F:186B                       loc_322:                                        ; 111111011
273F:186B  E8 6537                              call    read_bit
273F:186E  74 03                                jz      loc_323                 ; Jump if zero
273F:1870  EB 04                                jmp     short loc_324           ; (1876)
273F:1872  90                                   db      90h
273F:1873                       loc_323:                                        ; 1111110110
273F:1873  B0 42                                mov     al,42h                  ; 'B'
273F:1875  C3                                   retn
273F:1876                       loc_324:                                        ; 1111110111
273F:1876  E8 652C                              call    read_bit
273F:1879  74 03                                jz      loc_325                 ; Jump if zero
273F:187B  EB 04                                jmp     short loc_326           ; (1881)
273F:187D  90                                   db      90h
273F:187E                       loc_325:                                        ; 11111101110
273F:187E  B0 44                                mov     al,44h                  ; 'D'
273F:1880  C3                                   retn
273F:1881                       loc_326:                                        ; 11111101111
273F:1881  B0 A6                                mov     al,0A6h
273F:1883  C3                                   retn
273F:1884                       loc_327:                                        ; 1111111
273F:1884  E8 651E                              call    read_bit
273F:1887  74 03                                jz      loc_328                 ; Jump if zero
273F:1889  EB 46                                jmp     short loc_341           ; (18D1)
273F:188B  90                                   db      90h
273F:188C                       loc_328:                                        ; 11111110
273F:188C  E8 6516                              call    read_bit
273F:188F  74 03                                jz      loc_329                 ; Jump if zero
273F:1891  EB 1A                                jmp     short loc_334           ; (18AD)
273F:1893  90                                   db      90h
273F:1894                       loc_329:                                        ; 111111100
273F:1894  E8 650E                              call    read_bit
273F:1897  74 03                                jz      loc_330                 ; Jump if zero
273F:1899  EB 04                                jmp     short loc_331           ; (189F)
273F:189B  90                                   db      90h
273F:189C                       loc_330:                                        ; 1111111000
273F:189C  B0 43                                mov     al,43h                  ; 'C'
273F:189E  C3                                   retn
273F:189F                       loc_331:                                        ; 1111111001
273F:189F  E8 6503                              call    read_bit
273F:18A2  74 03                                jz      loc_332                 ; Jump if zero
273F:18A4  EB 04                                jmp     short loc_333           ; (18AA)
273F:18A6  90                                   db      90h
273F:18A7                       loc_332:                                        ; 11111110010
273F:18A7  B0 78                                mov     al,78h                  ; 'x'
273F:18A9  C3                                   retn
273F:18AA                       loc_333:                                        ; 11111110011
273F:18AA  B0 6A                                mov     al,6Ah                  ; 'j'
273F:18AC  C3                                   retn
273F:18AD                       loc_334:                                        ; 111111101
273F:18AD  E8 64F5                              call    read_bit
273F:18B0  74 03                                jz      loc_335                 ; Jump if zero
273F:18B2  EB 04                                jmp     short loc_336           ; (18B8)
273F:18B4  90                                   db      90h
273F:18B5                       loc_335:                                        ; 1111111010
273F:18B5  B0 AC                                mov     al,0ACh
273F:18B7  C3                                   retn
273F:18B8                       loc_336:                                        ; 1111111011
273F:18B8  E8 64EA                              call    read_bit
273F:18BB  74 03                                jz      loc_337                 ; Jump if zero
273F:18BD  EB 04                                jmp     short loc_338           ; (18C3)
273F:18BF  90                                   db      90h
273F:18C0                       loc_337:                                        ; 11111110110
273F:18C0  B0 A3                                mov     al,0A3h
273F:18C2  C3                                   retn
273F:18C3                       loc_338:                                        ; 11111110111
273F:18C3  E8 64DF                              call    read_bit
273F:18C6  74 03                                jz      loc_339                 ; Jump if zero
273F:18C8  EB 04                                jmp     short loc_340           ; (18CE)
273F:18CA  90                                   db      90h
273F:18CB                       loc_339:                                        ; 111111101110
273F:18CB  B0 50                                mov     al,50h                  ; 'P'
273F:18CD  C3                                   retn
273F:18CE                       loc_340:                                        ; 111111101111
273F:18CE  B0 55                                mov     al,55h                  ; 'U'
273F:18D0  C3                                   retn
273F:18D1                       loc_341:                                        ; 11111111
273F:18D1  E8 64D1                              call    read_bit
273F:18D4  74 03                                jz      loc_342                 ; Jump if zero
273F:18D6  EB 46                                jmp     short loc_355           ; (191E)
273F:18D8  90                                   db      90h
273F:18D9                       loc_342:                                        ; 111111110
273F:18D9  E8 64C9                              call    read_bit
273F:18DC  74 03                                jz      loc_343                 ; Jump if zero
273F:18DE  EB 0F                                jmp     short loc_346           ; (18EF)
273F:18E0  90                                   db      90h
273F:18E1                       loc_343:                                        ; 1111111100
273F:18E1  E8 64C1                              call    read_bit
273F:18E4  74 03                                jz      loc_344                 ; Jump if zero
273F:18E6  EB 04                                jmp     short loc_345           ; (18EC)
273F:18E8  90                                   db      90h
273F:18E9                       loc_344:                                        ; 11111111000
273F:18E9  B0 71                                mov     al,71h                  ; 'q'
273F:18EB  C3                                   retn
273F:18EC                       loc_345:                                        ; 11111111001
273F:18EC  B0 AD                                mov     al,0ADh
273F:18EE  C3                                   retn
273F:18EF                       loc_346:                                        ; 1111111101
273F:18EF  E8 64B3                              call    read_bit
273F:18F2  74 03                                jz      loc_347                 ; Jump if zero
273F:18F4  EB 0F                                jmp     short loc_350           ; (1905)
273F:18F6  90                                   db      90h
273F:18F7                       loc_347:                                        ; 11111111010
273F:18F7  E8 64AB                              call    read_bit
273F:18FA  74 03                                jz      loc_348                 ; Jump if zero
273F:18FC  EB 04                                jmp     short loc_349           ; (1902)
273F:18FE  90                                   db      90h
273F:18FF                       loc_348:                                        ; 111111110100
273F:18FF  B0 46                                mov     al,46h                  ; 'F'
273F:1901  C3                                   retn
273F:1902                       loc_349:                                        ; 111111110101
273F:1902  B0 31                                mov     al,31h                  ; '1'
273F:1904  C3                                   retn
273F:1905                       loc_350:                                        ; 11111111011
273F:1905  E8 649D                              call    read_bit
273F:1908  74 03                                jz      loc_351                 ; Jump if zero
273F:190A  EB 04                                jmp     short loc_352           ; (1910)
273F:190C  90                                   db      90h
273F:190D                       loc_351:                                        ; 111111110110
273F:190D  B0 AF                                mov     al,0AFh
273F:190F  C3                                   retn
273F:1910                       loc_352:                                        ; 111111110111
273F:1910  E8 6492                              call    read_bit
273F:1913  74 03                                jz      loc_353                 ; Jump if zero
273F:1915  EB 04                                jmp     short loc_354           ; (191B)
273F:1917  90                                   db      90h
273F:1918                       loc_353:                                        ; 1111111101110
273F:1918  B0 3B                                mov     al,3Bh                  ; ';'
273F:191A  C3                                   retn
273F:191B                       loc_354:                                        ; 1111111101111
273F:191B  B0 7A                                mov     al,7Ah                  ; 'z'
273F:191D  C3                                   retn
273F:191E                       loc_355:                                        ; 111111111
273F:191E  E8 6484                              call    read_bit
273F:1921  74 03                                jz      loc_356                 ; Jump if zero
273F:1923  EB 46                                jmp     short loc_369           ; (196B)
273F:1925  90                                   nop
273F:1926                       loc_356:                                        ; 1111111110
273F:1926  E8 647C                              call    read_bit
273F:1929  74 03                                jz      loc_357                 ; Jump if zero
273F:192B  EB 1A                                jmp     short loc_362           ; (1947)
273F:192D  90                                   db      90h
273F:192E                       loc_357:                                        ; 11111111100
273F:192E  E8 6474                              call    read_bit
273F:1931  74 03                                jz      loc_358                 ; Jump if zero
273F:1933  EB 04                                jmp     short loc_359           ; (1939)
273F:1935  90                                   db      90h
273F:1936                       loc_358:                                        ; 111111111000
273F:1936  B0 A5                                mov     al,0A5h
273F:1938  C3                                   retn
273F:1939                       loc_359:                                        ; 111111111001
273F:1939  E8 6469                              call    read_bit
273F:193C  74 03                                jz      loc_360                 ; Jump if zero
273F:193E  EB 04                                jmp     short loc_361           ; (1944)
273F:1940  90                                   db      90h
273F:1941                       loc_360:                                        ; 1111111110010
273F:1941  B0 32                                mov     al,32h                  ; '2'
273F:1943  C3                                   retn
273F:1944                       loc_361:                                        ; 1111111110011
273F:1944  B0 B0                                mov     al,0B0h
273F:1946  C3                                   retn
273F:1947                       loc_362:                                        ; 11111111101
273F:1947  E8 645B                              call    read_bit
273F:194A  74 03                                jz      loc_363                 ; Jump if zero
273F:194C  EB 04                                jmp     short loc_364           ; (1952)
273F:194E  90                                   db      90h
273F:194F                       loc_363:                                        ; 111111111010
273F:194F  B0 4B                                mov     al,4Bh                  ; 'K'
273F:1951  C3                                   retn
273F:1952                       loc_364:                                        ; 111111111011
273F:1952  E8 6450                              call    read_bit
273F:1955  74 03                                jz      loc_365                 ; Jump if zero
273F:1957  EB 04                                jmp     short loc_366           ; (195D)
273F:1959  90                                   db      90h
273F:195A                       loc_365:                                        ; 1111111110110
273F:195A  B0 25                                mov     al,25h                  ; '%'
273F:195C  C3                                   retn
273F:195D                       loc_366:                                        ; 1111111110111
273F:195D  E8 6445                              call    read_bit
273F:1960  74 03                                jz      loc_367                 ; Jump if zero
273F:1962  EB 04                                jmp     short loc_368           ; (1968)
273F:1964  90                                   db      90h
273F:1965                       loc_367:                                        ; 11111111101110
273F:1965  B0 A2                                mov     al,0A2h
273F:1967  C3                                   retn
273F:1968                       loc_368:                                        ; 11111111101111
273F:1968  B0 35                                mov     al,35h                  ; '5'
273F:196A  C3                                   retn
273F:196B                       loc_369:                                        ; 1111111111
273F:196B  E8 6437                              call    read_bit
273F:196E  74 03                                jz      loc_370                 ; Jump if zero
273F:1970  EB 30                                jmp     short loc_379           ; (19A2)
273F:1972  90                                   db      90h
273F:1973                       loc_370:                                        ; 11111111110
273F:1973  E8 642F                              call    read_bit
273F:1976  74 03                                jz      loc_371                 ; Jump if zero
273F:1978  EB 0F                                jmp     short loc_374           ; (1989)
273F:197A  90                                   db      90h
273F:197B                       loc_371:                                        ; 111111111100
273F:197B  E8 6427                              call    read_bit
273F:197E  74 03                                jz      loc_372                 ; Jump if zero
273F:1980  EB 04                                jmp     short loc_373           ; (1986)
273F:1982  90                                   db      90h
273F:1983                       loc_372:                                        ;  1111111111000
273F:1983  B0 3A                                mov     al,3Ah                  ; ':'
273F:1985  C3                                   retn
273F:1986                       loc_373:                                        ;  1111111111001
273F:1986  B0 4A                                mov     al,4Ah                  ; 'J'
273F:1988  C3                                   retn
273F:1989                       loc_374:                                        ; 111111111101
273F:1989  E8 6419                              call    read_bit
273F:198C  74 03                                jz      loc_375                 ; Jump if zero
273F:198E  EB 04                                jmp     short loc_376           ; (1994)
273F:1990  90                                   db      90h
273F:1991                       loc_375:                                        ; 1111111111010
273F:1991  B0 56                                mov     al,56h                  ; 'V'
273F:1993  C3                                   retn
273F:1994                       loc_376:                                        ; 1111111111011
273F:1994  E8 640E                              call    read_bit
273F:1997  74 03                                jz      loc_377                 ; Jump if zero
273F:1999  EB 04                                jmp     short loc_378           ; (199F)
273F:199B  90                                   db      90h
273F:199C                       loc_377:                                        ; 11111111110110
273F:199C  B0 36                                mov     al,36h                  ; '6'
273F:199E  C3                                   retn
273F:199F                       loc_378:                                        ; 11111111110111
273F:199F  B0 33                                mov     al,33h                  ; '3'
273F:19A1  C3                                   retn
273F:19A2                       loc_379:                                        ; 11111111111
273F:19A2  E8 6400                              call    read_bit
273F:19A5  74 03                                jz      loc_380                 ; Jump if zero
273F:19A7  EB 25                                jmp     short loc_387           ; (19CE)
273F:19A9  90                                   db      90h
273F:19AA                       loc_380:                                        ; 111111111110
273F:19AA  E8 63F8                              call    read_bit
273F:19AD  74 03                                jz      loc_381                 ; Jump if zero
273F:19AF  EB 04                                jmp     short loc_382           ; (19B5)
273F:19B1  90                                   db      90h
273F:19B2                       loc_381:                                        ; 1111111111100
273F:19B2  B0 AB                                mov     al,0ABh
273F:19B4  C3                                   retn
273F:19B5                       loc_382:                                        ; 1111111111101
273F:19B5  E8 63ED                              call    read_bit
273F:19B8  74 03                                jz      loc_383                 ; Jump if zero
273F:19BA  EB 04                                jmp     short loc_384           ; (19C0)
273F:19BC  90                                   db      90h
273F:19BD                       loc_383:                                        ; 11111111111010
273F:19BD  B0 AE                                mov     al,0AEh
273F:19BF  C3                                   retn
273F:19C0                       loc_384:                                        ; 11111111111011
273F:19C0  E8 63E2                              call    read_bit
273F:19C3  74 03                                jz      loc_385                 ; Jump if zero
273F:19C5  EB 04                                jmp     short loc_386           ; (19CB)
273F:19C7  90                                   db      90h
273F:19C8                       loc_385:                                        ; 111111111110110
273F:19C8  B0 30                                mov     al,30h                  ; '0'
273F:19CA  C3                                   retn
273F:19CB                       loc_386:                                        ; 111111111110111
273F:19CB  B0 34                                mov     al,34h                  ; '4'
273F:19CD  C3                                   retn
273F:19CE                       loc_387:                                        ; 111111111111
273F:19CE  E8 63D4                              call    read_bit
273F:19D1  74 03                                jz      loc_388                 ; Jump if zero
273F:19D3  EB 1A                                jmp     short loc_393           ; (19EF)
273F:19D5  90                                   db      90h
273F:19D6                       loc_388:                                        ; 1111111111110
273F:19D6  E8 63CC                              call    read_bit
273F:19D9  74 03                                jz      loc_389                 ; Jump if zero
273F:19DB  EB 04                                jmp     short loc_390           ; (19E1)
273F:19DD  90                                   db      90h
273F:19DE                       loc_389:                                        ; 11111111111100
273F:19DE  B0 37                                mov     al,37h                  ; '7'
273F:19E0  C3                                   retn
273F:19E1                       loc_390:                                        ; 11111111111101
273F:19E1  E8 63C1                              call    read_bit
273F:19E4  74 03                                jz      loc_391                 ; Jump if zero
273F:19E6  EB 04                                jmp     short loc_392           ; (19EC)
273F:19E8  90                                   db      90h
273F:19E9                       loc_391:                                        ; 111111111111010
273F:19E9  B0 39                                mov     al,39h                  ; '9'
273F:19EB  C3                                   retn
273F:19EC                       loc_392:                                        ; 111111111111011
273F:19EC  B0 22                                mov     al,22h                  ; '"'
273F:19EE  C3                                   retn
273F:19EF                       loc_393:                                        ; 1111111111111
273F:19EF  E8 63B3                              call    read_bit
273F:19F2  74 03                                jz      loc_394                 ; Jump if zero
273F:19F4  EB 0F                                jmp     short loc_397           ; (1A05)
273F:19F6  90                                   db      90h
273F:19F7                       loc_394:                                        ; 11111111111110
273F:19F7  E8 63AB                              call    read_bit
273F:19FA  74 03                                jz      loc_395                 ; Jump if zero
273F:19FC  EB 04                                jmp     short loc_396           ; (1A02)
273F:19FE  90                                   db      90h
273F:19FF                       loc_395:                                        ; 111111111111100
273F:19FF  B0 38                                mov     al,38h                  ; '8'
273F:1A01  C3                                   retn
273F:1A02                       loc_396:                                        ; 111111111111101
273F:1A02  B0 A7                                mov     al,0A7h
273F:1A04  C3                                   retn
273F:1A05                       loc_397:                                        ; 11111111111111
273F:1A05  E8 639D                              call    read_bit
273F:1A08  74 03                                jz      loc_398                 ; Jump if zero
273F:1A0A  EB 0F                                jmp     short loc_401           ; (1A1B)
273F:1A0C  90                                   db      90h
273F:1A0D                       loc_398:                                        ; 111111111111110
273F:1A0D  E8 6395                              call    read_bit
273F:1A10  74 03                                jz      loc_399                 ; Jump if zero
273F:1A12  EB 04                                jmp     short loc_400           ; (1A18)
273F:1A14  90                                   db      90h
273F:1A15                       loc_399:                                        ; 1111111111111100
273F:1A15  B0 2F                                mov     al,2Fh                  ; '/'
273F:1A17  C3                                   retn
273F:1A18                       loc_400:                                        ; 1111111111111101
273F:1A18  B0 51                                mov     al,51h                  ; 'Q'
273F:1A1A  C3                                   retn
273F:1A1B                       loc_401:                                        ; 111111111111111
273F:1A1B  E8 6387                              call    read_bit
273F:1A1E  74 03                                jz      loc_402                 ; Jump if zero
273F:1A20  EB 0F                                jmp     short loc_405           ; (1A31)
273F:1A22  90                                   db      90h
273F:1A23                       loc_402:                                        ; 1111111111111110
273F:1A23  E8 637F                              call    read_bit
273F:1A26  74 03                                jz      loc_403                 ; Jump if zero
273F:1A28  EB 04                                jmp     short loc_404           ; (1A2E)
273F:1A2A  90                                   db      90h
273F:1A2B                       loc_403:                                        ; 11111111111111100
273F:1A2B  B0 A8                                mov     al,0A8h
273F:1A2D  C3                                   retn
273F:1A2E                       loc_404:                                        ; 11111111111111101
273F:1A2E  B0 28                                mov     al,28h                  ; '('
273F:1A30  C3                                   retn
273F:1A31                       loc_405:                                        ; 1111111111111111
273F:1A31  E8 6371                              call    read_bit
273F:1A34  74 03                                jz      loc_406                 ; Jump if zero
273F:1A36  EB 0F                                jmp     short loc_409           ; (1A47)
273F:1A38  90                                   db      90h
273F:1A39                       loc_406:                                        ; 11111111111111110
273F:1A39  E8 6369                              call    read_bit
273F:1A3C  74 03                                jz      loc_407                 ; Jump if zero
273F:1A3E  EB 04                                jmp     short loc_408           ; (1A44)
273F:1A40  90                                   db      90h
273F:1A41                       loc_407:                                        ; 111111111111111100
273F:1A41  B0 29                                mov     al,29h                  ; ')'
273F:1A43  C3                                   retn
273F:1A44                       loc_408:                                        ; 111111111111111101
273F:1A44  B0 99                                mov     al,99h
273F:1A46  C3                                   retn
273F:1A47                       loc_409:                                        ; 11111111111111111
273F:1A47  B0 A9                                mov     al,0A9h
273F:1A49  C3                                   retn
                        decode_character        endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:631D
                                ; si=Character name, di = speech text, talk_character_id = character hotspot Id
                                ;

                          talk_dialog_init      proc    near
273F:1A4A  89 3E B9F9                           mov     talk_speech_ptr, di
273F:1A4E  BD 0080                              mov     bp, 80h
273F:1A51  A1 4CF0                              mov     ax, font2_segment
273F:1A54  8E C0                                mov     es, ax
273F:1A56  56                                   push    si
273F:1A57  33 D2                                xor     dx, dx                  ; Zero register
273F:1A59  B1 03                                mov     cl, 3
273F:1A5B                       loc_410:                                        ;  xref 273F:1A68, 1A6D
273F:1A5B AC                                   lodsb                           ; String [si] to al
273F:1A5C  2C 20                                sub     al,20h                  ; ' '
273F:1A5E  72 0F                                jc      loc_411                 ; Jump if carry Set
273F:1A60  98                                   cbw                             ; Convrt byte to word
273F:1A61  D3 E0                                shl     ax,cl                   ; Convert to font data offset
273F:1A63  8B D8                                mov     bx,ax
273F:1A65  26: 02 17                            add     dl,es:[bx]              ; Increase width
273F:1A68  73 F1                                jnc     loc_410                 ; Jump if carry=0
273F:1A6A  80 C6 01                             add     dh,1
273F:1A6D  EB EC                                jmp     short loc_410           ; (1A5B)
; dx = size of the character name?
273F:1A6F                       loc_411:                                        ;  xref 273F:1A5E
273F:1A6F  B8 0080                              mov     ax,80h
273F:1A72  2B C2                                sub     ax,dx
273F:1A74  D1 E8                                shr     ax,1                    ; Calculate centering name?
273F:1A76  50                                   push    ax
273F:1A77 BB B9F9                              mov     bx, offset talk_speech_ptr
273F:1A7A  E8 00B3                              call    word_wrap_string
273F:1A7D  A1 4CE6                              mov     ax, talk_dialog_buffer
273F:1A80  A3 B9FF                              mov     talk_buffer_segment, ax
273F:1A83  8E C0                                mov     es, ax
273F:1A85  BF 0000                              mov     di,0
273F:1A88  89 3E BA01                           mov     talk_buffer_offset, di
273F:1A8C  8B 2E B9FD                           mov     bp, data_1122
273F:1A90  57                                   push    di
273F:1A91  FF 16 0756                           call    [draw_talk_dialog_proc]

273F:1A95  A1 983B                              mov     ax, talk_character_id
273F:1A98  E8 F24F                              call    get_room_resource_pointer2
273F:1A9B  8B 44 19                             mov     ax, [si+HS_WIDTH_COPY]  ; Figure out hotspot X center
273F:1A9E  D1 E8                                shr     ax,1
273F:1AA0  03 44 0D                             add     ax, [si+HS_X]
273F:1AA3  2D 0080                              sub     ax, 80h                 ; Remove 80h offset
273F:1AA6  72 19                                jc      loc_412                 ; Character off-screen
273F:1AA8  8B 1E 11C4                           mov     bx, talk_dialog_width
273F:1AAC  D1 EB                                shr     bx,1                    ; ax=X start for centering
273F:1AAE  2B C3                                sub     ax,bx                   ;   dialog on character
273F:1AB0  72 0F                                jc      loc_412
273F:1AB2  BB 0136                              mov     bx, 310
273F:1AB5  2B 1E 11C4                           sub     bx, talk_dialog_width
273F:1AB9  3B C3                                cmp     ax, bx                  ; Too far along horizontally?
273F:1ABB  72 06                                jb      loc_413
273F:1ABD  8B C3                                mov     ax,bx                   ; Yes, so limit x start
273F:1ABF  EB 02                                jmp     short loc_413
273F:1AC1                       loc_412:
273F:1AC1  33 C0                                xor     ax,ax
273F:1AC3                       loc_413:
273F:1AC3  A3 11C2                              mov     talk_dialog_left, ax    ; Set the x start
273F:1AC6  5F                                   pop     di
273F:1AC7  8B 36 076E                           mov     si, data_571
273F:1ACB  8A 7C 04                             mov     bh, [si+4]
273F:1ACE  8A 44 05                             mov     al, [si+5]
273F:1AD1  A2 BA06                              mov     data_ba06, al
273F:1AD4  58                                   pop     ax
273F:1AD5  5E                                   pop     si
273F:1AD6  80 3E 0742 01                        cmp     video_style, VIDEO_STYLE_VGA
273F:1ADB  74 2A                                je      loc_414                 ; Jump if equal
273F:1ADD  81 C7 0140                           add     di,140h
273F:1AE1  8B 0E BA01                           mov     cx, talk_buffer_offset
273F:1AE5  81 C1 03C0                           add     cx, SCREEN_WIDTH*3      ; 3C0h ?
273F:1AE9  89 0E BA01                           mov     talk_buffer_offset, cx
273F:1AED  89 0E BA03                           mov     talk_buffer_offset_2, cx
273F:1AF1  8A C8                                mov     cl,al
273F:1AF3  80 E1 07                             and     cl,7
273F:1AF6  D1 E8                                shr     ax,1                    ; Shift w/zeros fill
273F:1AF8  25 FFFC                              and     ax,0FFFCh
273F:1AFB  03 F8                                add     di,ax
273F:1AFD  BD 0040                              mov     bp,40h
273F:1B00  C6 06 BA05 05                        mov     byte ptr ds:data_465e,5 ; (273F:BA05=0)
273F:1B05  EB 19                                jmp     short loc_415           ; (1B20)
273F:1B07                       loc_414:                                        ;  xref 273F:1ADB
273F:1B07  03 F8                                add     di,ax
273F:1B09  81 C7 0280                           add     di,280h
273F:1B0D  8B 0E BA01                           mov     cx, talk_buffer_offset
273F:1B11  81 C1 0785                           add     cx,785h
273F:1B15  89 0E BA01                           mov     talk_buffer_offset, cx
273F:1B19  89 0E BA03                           mov     talk_buffer_offset_2, cx
273F:1B1D  BD 0080                              mov     bp,80h
273F:1B20                       loc_415:                                        ;  xref 273F:1B05
273F:1B20  89 2E B9FB                           mov     data_b9fb, bp

; Loop for adding the character name into the dialog
273F:1B24 AC                   loc_416:        lodsb                           ; String [si] to al
273F:1B25  2C 20                                sub     al,20h                  ; ' '
273F:1B27  72 06                                jc      loc_ret_417             ; Jump if carry Set
273F:1B29  FF 16 075A                           call    [display2_character_proc]
273F:1B2D  EB F5                                jmp     short loc_416           ; (1B24)
273F:1B2F                       loc_ret_417:                                    ;  xref 273F:1B27
273F:1B2F  C3                                   retn
                          talk_dialog_init      endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:1A7A, 8980
                                ; bx = talk data details record offset
                                ; di = text to handle
                                ;

273F:1B30              word_wrap_string         proc    near
273F:1B30  8B F7                                mov     si,di
273F:1B32  C7 47 04 0000                        mov     word ptr [bx+4],0
273F:1B37                       loc_418:                                        ;  xref 273F:1B5C, 1B92
273F:1B37 8B FE                                mov     di,si
273F:1B39  83 47 04 01                          add     word ptr [bx+4],1
273F:1B3D  BA 0009                              mov     dx,9
273F:1B40                       loc_419:                                        ;  xref 273F:1B8C
273F:1B40  32 ED                                xor     ch,ch                   ; Zero register
273F:1B42                       loc_420:                                        ;  xref 273F:1B51, 1B58
273F:1B42 AC                                   lodsb                           ; String [si] to al
273F:1B43  2C 20                                sub     al,20h                  ; ' '
273F:1B45  74 17                                jz      loc_423                 ; Jump if zero
273F:1B47  72 0A                                jc      loc_421                 ; Jump if carry Set
273F:1B49  98                                   cbw                             ; Convrt byte to word
273F:1B4A  D3 E0                                shl     ax,cl                   ; Shift w/zeros fill
273F:1B4C  93                                   xchg    bx,ax
273F:1B4D  26: 02 2F                            add     ch,es:[bx]
273F:1B50  93                                   xchg    bx,ax
273F:1B51  EB EF                                jmp     short loc_420           ; (1B42)
273F:1B53                       loc_421:                                        ;  xref 273F:1B47
273F:1B53  3C E1                                cmp     al,0E1h
273F:1B55  75 03                                jne     loc_422                 ; Jump if not equal
273F:1B57  AC                                   lodsb                           ; String [si] to al
273F:1B58  EB E8                                jmp     short loc_420           ; (1B42)
273F:1B5A                       loc_422:                                        ;  xref 273F:1B55
273F:1B5A  3C ED                                cmp     al,0EDh
273F:1B5C  74 D9                                je      loc_418                 ; Jump if equal
273F:1B5E                       loc_423:                                        ;  xref 273F:1B45
273F:1B5E  02 D5                                add     dl,ch
273F:1B60  73 03                                jnc     loc_424                 ; Jump if carry=0
273F:1B62  80 C6 01                             add     dh,1
273F:1B65                       loc_424:                                        ;  xref 273F:1B60
273F:1B65  3B EA                                cmp     bp,dx
273F:1B67  74 1D                                je      loc_426                 ; Jump if equal
273F:1B69  73 0F                                jnc     loc_425                 ; Jump if carry=0
273F:1B6B  C6 45 FF 0D                          mov     byte ptr [di-1],0Dh
273F:1B6F  8A D5                                mov     dl,ch
273F:1B71  80 C2 09                             add     dl,9
273F:1B74  32 F6                                xor     dh,dh                   ; Zero register
273F:1B76  83 47 04 01                          add     word ptr [bx+4],1
273F:1B7A                       loc_425:                                        ;  xref 273F:1B69
273F:1B7A  8B FE                                mov     di,si
273F:1B7C  26: 02 16 0000                       add     dl,es:data_1443e        ; (8B57:0000=0)
273F:1B81  73 03                                jnc     loc_426                 ; Jump if carry=0
273F:1B83  80 C6 01                             add     dh,1
273F:1B86                       loc_426:                                        ;  xref 273F:1B67, 1B81
273F:1B86  0A C0                                or      al,al                   ; Zero ?
273F:1B88  75 0A                                jnz     loc_427                 ; Jump if not zero
273F:1B8A  3B D5                                cmp     dx,bp
273F:1B8C  72 B2                                jb      loc_419                 ; Jump if below
273F:1B8E  C6 44 FF 0D                          mov     byte ptr [si-1],0Dh     ; Add a carriage return
273F:1B92  EB A3                                jmp     short loc_418
273F:1B94                       loc_427:                                        
273F:1B94  8B 47 04                             mov     ax,[bx+4]
273F:1B97  C3                                   retn
                       word_wrap_string         endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:634C, 899B, 8E28
                                ;

273F:1B98                       sub_51          proc    near
273F:1B98  8B 37                                mov     si,[bx]
273F:1B9A  8B 7F 08                             mov     di,[bx+8]
273F:1B9D  8A 4F 0C                             mov     cl,[bx+0Ch]
273F:1BA0  8B 47 06                             mov     ax,[bx+6]
273F:1BA3  8E C0                                mov     es,ax
273F:1BA5  53                                   push    bx
273F:1BA6  8B 6F 02                             mov     bp, [bx+2]
273F:1BA9  8A 7F 0D                             mov     bh, [bx+0Dh]
273F:1BAC                       loc_428:                                        ;  xref 273F:1BCE
273F:1BAC AC                                   lodsb                           ; String [si] to al
273F:1BAD  2C 20                                sub     al,20h                  ; ' '
273F:1BAF  74 1F                                jz      loc_430                 ; Jump if zero
273F:1BB1  73 17                                jnc     loc_429                 ; Jump if carry=0
273F:1BB3  3C E1                                cmp     al,0E1h
273F:1BB5  72 29                                jb      loc_432                 ; Jump if below
273F:1BB7  5B                                   pop     bx
273F:1BB8  8B 7F 0A                             mov     di,[bx+0Ah]
273F:1BBB  B8 0007                              mov     ax,7
273F:1BBE  F7 67 02                             mul     word ptr [bx+2]         ; dx:ax = data * ax
273F:1BC1  03 F8                                add     di,ax
273F:1BC3  89 7F 0A                             mov     [bx+0Ah], di
273F:1BC6  B1 05                                mov     cl, 5
273F:1BC8  EB 0B                                jmp     short loc_431           ; (1BD5)
273F:1BCA                       loc_429:                                        ;  xref 273F:1BB1
273F:1BCA  FF 16 075A                           call    [display2_character_proc]
273F:1BCE  EB DC                                jmp     short loc_428           ; (1BAC)
273F:1BD0                       loc_430:                                        ;  xref 273F:1BAF
273F:1BD0  FF 16 075A                           call    [display2_character_proc]
273F:1BD4  5B                                   pop     bx
273F:1BD5                       loc_431:                                        ;  xref 273F:1BC8
273F:1BD5  89 7F 08                             mov     [bx+8],di
273F:1BD8  88 4F 0C                             mov     [bx+0Ch],cl
273F:1BDB  89 37                                mov     [bx],si
273F:1BDD  33 C0                                xor     ax,ax                   ; Zero register
273F:1BDF  C3                                   retn
273F:1BE0                       loc_432:                                        ;  xref 273F:1BB5
273F:1BE0  5B                                   pop     bx
273F:1BE1  0D FFFF                              or      ax,0FFFFh
273F:1BE4  C3                                   retn
                                sub_51          endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:59D2, 59F6, 5A2E, 5A68
                                ;

273F:1BE5                       sub_52          proc    near
273F:1BE5  8B 0E 074C                           mov     cx, menubar_block_size
273F:1BE9  F7 E1                                mul     cx                      ; dx:ax = reg * ax
273F:1BEB  8B F8                                mov     di,ax
273F:1BED  A1 074A                              mov     ax, char_width
273F:1BF0  F7 E3                                mul     bx                      ; dx:ax = reg * ax
273F:1BF2  03 F8                                add     di,ax
273F:1BF4  A1 4CE4                              mov     ax, data_segment2
273F:1BF7  8E C0                                mov     es,ax
273F:1BF9  8B 2E 0748                           mov     bp, screen_width
273F:1BFD  32 C9                                xor     cl,cl                   ; Zero register
273F:1BFF  8B 1E 076E                           mov     bx, data_571
273F:1C03  8A 7F 05                             mov     bh,[bx+5]
273F:1C06                       loc_433:                                        ;  xref 273F:1C0F
273F:1C06 AC                                   lodsb                           ; String [si] to al
273F:1C07  2C 20                                sub     al,20h                  ; ' '
273F:1C09  72 06                                jc      loc_ret_434             ; Jump if carry Set
273F:1C0B  FF 16 075A                           call    [display2_character_proc]
273F:1C0F  EB F5                                jmp     short loc_433           ; (1C06)

273F:1C11                       loc_ret_434:                                    ;  xref 273F:1C09
273F:1C11  C3                                   retn
                                sub_52          endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:010A, 93EC
                                ;

                         room_check_cursors     proc    near

                                                assume  ds:data_seg
273F:1C12  A1 11E1                              mov     ax, cursor_index
273F:1C15  3D 0002                              cmp     ax, CURSOR_TIME_UP      ; Check if it's in the clock animation
273F:1C18  72 24                                jb      loc_437                 ; No
273F:1C1A  3D 0009                              cmp     ax, CURSOR_TIME_UP_LEFT
273F:1C1D  73 1F                                jae     loc_437                 ; Too high
273F:1C1F  80 3E 6D52 01                        cmp     player_action_state, CHAR_ACTION_START_WALK
273F:1C24  74 07                                je      loc_435                 ; Jump if equal
273F:1C26  80 3E 6D52 04                        cmp     player_action_state, CHAR_ACTION_PROCESSING_PATH
273F:1C2B  75 11                                jne     loc_437                 ; Jump if not equal
273F:1C2D                       loc_435:                                        ;  xref 273F:1C24
273F:1C2D  05 0001                              add     ax,1
273F:1C30  3D 000A                              cmp     ax, CURSOR_CROSS        ; Passed end of clock sequence?
273F:1C33  72 03                                jb      loc_436                 ; Jump if below
273F:1C35  A1 0002                              mov     ax,  CURSOR_TIME_UP     ; Set clock back to start
273F:1C38                       loc_436:
273F:1C38  A2 11E3                              mov     cursor_index_new, al
273F:1C3B  E9 0180                              jmp     loc_451

273F:1C3E                       loc_437:
273F:1C3E  E8 0374                              call    talk_dialog_mouse_check
273F:1C41  75 08                                jnz     loc_438                 ; Not in dialog
273F:1C43  C6 06 11E3 10                        mov     cursor_index_new, CURSOR_TALK ; Show talk cursor
273F:1C48  E9 0173                              jmp     loc_451

273F:1C4B                       loc_438:                                        ;  xref 273F:1C41
273F:1C4B  80 3E 9834 04                        cmp     cursor_state, CURSORSTATE_BUMPED
273F:1C50  74 5B                                je      loc_440                 ; Jump if equal
273F:1C52  80 3E 9834 03                        cmp     cursor_state, CURSORSTATE_TALK
273F:1C57  74 5C                                je      loc_441                 ; Jump if equal

; Check for cursor in menubar area

273F:1C59  83 3E 11D8 08                        cmp     mouse_y2, MENUBAR_Y_SIZE
273F:1C5E  73 10                                jae     loc_439                 ; Jump if above or =
273F:1C60  F7 06 BA25 FFFF                      test    old_room_number, 0FFFFh
273F:1C66  75 55                                jnz     loc_ret_442             ; Jump if not zero
273F:1C68  C6 06 11E3 11                        mov     cursor_index_new, CURSOR_MENUBAR_AREA
273F:1C6D  E9 014E                              jmp     loc_451                 ; (1DBE)
273F:1C70                       loc_439:                                        ;  xref 273F:1C5E
273F:1C70  F6 06 9834 FF                        test    cursor_state, 0FFh
273F:1C75  74 47                                jz      loc_443                 ; Jump if zero
273F:1C77  C7 06 1924 0000                      mov     hotspot_id, 0
273F:1C7D  C6 06 11E3 0F                        mov     cursor_index_new, CURSOR_CAMERA
273F:1C82  8B 16 9832                           mov     dx, room_number
273F:1C86 BF 623E                              mov     di, offset hotspot_table_3
273F:1C89  BD 2710                              mov     bp,2710h
273F:1C8C  E8 01BC                              call    room_check_hotspots
273F:1C8F BF 63B1                              mov     di, offset hotspot_table_4
273F:1C92  BD 7530                              mov     bp,7530h
273F:1C95  E8 01B3                              call    room_check_hotspots
273F:1C98 BF 5D98                              mov     di, offset hotspot_table_2
273F:1C9B  BD 03E8                              mov     bp, PLAYER_HOTSPOT_ID
273F:1C9E  E8 01AA                              call    room_check_hotspots
273F:1CA1 BF 5EB8                              mov     di, offset hotspot_table_5
273F:1CA4  BD 0408                              mov     bp, FIRST_OBJECT_HOTSPOT_ID
273F:1CA7  E8 01A1                              call    room_check_hotspots
273F:1CAA  E9 0111                              jmp     loc_451                 ; (1DBE)
273F:1CAD                       loc_440:                                        ;  xref 273F:1C50
273F:1CAD  C6 06 11E3 0F                        mov     cursor_index_new, CURSOR_CAMERA
273F:1CB2  E9 0109                              jmp     loc_451                 ; (1DBE)
273F:1CB5                       loc_441:                                        ;  xref 273F:1C57
273F:1CB5  C6 06 11E3 00                        mov     cursor_index_new, CURSOR_ARROW
273F:1CBA  E9 0101                              jmp     loc_451                 ; (1DBE)

273F:1CBD                       loc_ret_442:                                    ;  xref 273F:1C66
273F:1CBD  C3                                   retn
273F:1CBE                       loc_443:                                        ;  xref 273F:1C75
273F:1CBE  C6 06 11E3 00                        mov     cursor_index_new, CURSOR_ARROW
273F:1CC3  C7 06 1924 0000                      mov     hotspot_id, 0
273F:1CC9  C7 06 11E6 0000                      mov     hotspot_name_id, 0
273F:1CCF  8B 16 9832                           mov     dx, room_number
273F:1CD3 BF 623E                              mov     di, offset hotspot_table_3
273F:1CD6  BD 2710                              mov     bp,2710h
273F:1CD9  E8 016F                              call    room_check_hotspots
273F:1CDC BF 5D98                              mov     di, offset hotspot_table_2
273F:1CDF  BD 03E8                              mov     bp, PLAYER_HOTSPOT_ID
273F:1CE2  E8 0166                              call    room_check_hotspots
273F:1CE5 BF 63B1                              mov     di, offset hotspot_table_4
273F:1CE8  BD 7530                              mov     bp,7530h
273F:1CEB  E8 015D                              call    room_check_hotspots
273F:1CEE BF 5EB8                              mov     di, offset hotspot_table_5
273F:1CF1  BD 0408                              mov     bp, FIRST_OBJECT_HOTSPOT_ID
273F:1CF4  E8 0154                              call    room_check_hotspots
273F:1CF7  F7 06 1924 FFFF                      test    hotspot_id, 0FFFFh
273F:1CFD  74 05                                jz      loc_444                 ; Not on hotspot
273F:1CFF  C6 06 11E3 0A                        mov     cursor_index_new, CURSOR_CROSS
273F:1D04                       loc_444:                                        ;  xref 273F:1CFD
273F:1D04  A1 11E6                              mov     ax, hotspot_name_id
273F:1D07  3B 06 11E4                           cmp     ax, hotspot_name_id2
273F:1D0B  74 36                                je      loc_446                 ; Jump if equal
273F:1D0D  A3 11E4                              mov     hotspot_name_id2, ax
273F:1D10  E8 52F2                              call    menubar_clear_image
273F:1D13  A1 11E4                              mov     ax, hotspot_name_id2
273F:1D16  0B C0                                or      ax,ax                   ; Zero ?
273F:1D18  74 29                                jz      loc_446                 ; Jump if zero
273F:1D1A  BF 4B43                              mov     di, offset hotspot_name
273F:1D1D  E8 601A                              call    decode_string
273F:1D20  8B 36 076E                           mov     si, data_571 
273F:1D24  8A 7C 05                             mov     bh,[si+5]
273F:1D27 BE 4B43                              mov     si,offset hotspot_name
273F:1D2A  BF 0000                              mov     di,0
273F:1D2D  B1 04                                mov     cl,4
273F:1D2F  8B 2E 0748                           mov     bp, screen_width
273F:1D33  A1 4CE4                              mov     ax, data_segment2
273F:1D36  8E C0                                mov     es,ax
273F:1D38                       loc_445:                                        ;  xref 273F:1D41
273F:1D38 AC                                   lodsb                           ; String [si] to al
273F:1D39  2C 20                                sub     al,20h                  ; ' '
273F:1D3B  72 06                                jc      loc_446                 ; Jump if carry Set
273F:1D3D  FF 16 075A                           call    [display2_character_proc]
273F:1D41  EB F5                                jmp     short loc_445           ; (1D38)
273F:1D43                       loc_446:                                        ;  xref 273F:1D0B, 1D18, 1D3B
273F:1D43  C7 06 1920 0000                      mov     room_exit_hotspot_id, 0
273F:1D49  C7 06 1922 0000                      mov     dest_room_num, 0
273F:1D4F  8B 1E 9832                           mov     bx, room_number
273F:1D53  D1 E3                                shl     bx,1                    ; Shift w/zeros fill
273F:1D55  8B B7 2F61                           mov     si, room_exits_table[bx]
273F:1D59  0B F6                                or      si,si                   ; Zero ?
273F:1D5B  74 61                                jz      loc_451                 ; Jump if zero
273F:1D5D  8B 1E 11D6                           mov     bx, mouse_x2
273F:1D61  81 C3 0080                           add     bx, 80h
273F:1D65  8B 16 11D8                           mov     dx, mouse_y2          
273F:1D69  81 C2 0080                           add     dx,80h
273F:1D6D                       loc_447:                                        ;  xref 273F:1D89
273F:1D6D 8B 04                                mov     ax,[si]
273F:1D6F  0B C0                                or      ax,ax                   ; Record present?
273F:1D71  74 4B                                jz      loc_451                 ; If no, exit loop
273F:1D73  3B C3                                cmp     ax,bx
273F:1D75  73 0F                                jae     loc_448                 ; Jump if above or =
273F:1D77  3B 5C 02                             cmp     bx,[si+ROOMEXIT_X_END]
273F:1D7A  73 0A                                jae     loc_448                 ; Jump if above or =
273F:1D7C  3B 54 04                             cmp     dx,[si+ROOMEXIT_Y_START]
273F:1D7F  72 05                                jb      loc_448                 ; Jump if below
273F:1D81  3B 54 06                             cmp     dx,[si+ROOMEXIT_Y_END]
273F:1D84  72 05                                jb      loc_449                 ; Jump if below
273F:1D86                       loc_448:
273F:1D86  83 C6 0E                             add     si, ROOMEXIT_RECORD_SIZE ; Move to next record
273F:1D89  EB E2                                jmp     short loc_447
273F:1D8B                       loc_449:                                        ;  xref 273F:1D84
273F:1D8B  8B 44 0A                             mov     ax,[si+ROOMEXIT_HOTSPOT_ID] ; Get asssociated hotspot Id
273F:1D8E  0B C0                                or      ax,ax                   ; Is there one?
273F:1D90  74 0D                                jz      loc_450                 ; No, so allow exit
273F:1D92  56                                   push    si
273F:1D93  E8 5458                              call    room_exit_hs_get_pointer
273F:1D96  5F                                   pop     di
273F:1D97  87 F7                                xchg    si,di
273F:1D99  F6 45 0C FF                          test    byte ptr [di+REHS_EXIT_BLOCKED],0FFh  ; Is exit blocked?
273F:1D9D  75 1F                                jnz     loc_451                 ; Jump if yes
273F:1D9F                       loc_450:
273F:1D9F  8B 44 0A                             mov     ax,[si+ROOMEXIT_HOTSPOT_ID]
273F:1DA2  A3 1920                              mov     room_exit_hotspot_id, ax
273F:1DA5  8B 44 0C                             mov     ax,[si+ROOMEXIT_DEST_ROOM]
273F:1DA8  A3 1922                              mov     dest_room_num, ax
273F:1DAB  8B 44 08                             mov     ax,[si+ROOMEXIT_CURSOR_NUM]
273F:1DAE  A2 11E3                              mov     cursor_index_new, al
273F:1DB1  F7 06 1924 FFFF                      test    hotspot_id, 0FFFFh
273F:1DB7  74 05                                jz      loc_451                 ; Jump if zero
273F:1DB9  80 06 11E3 07                        add     cursor_index_new, CURSOR_ARROW_UP2-CURSOR_ARROW_UP
                                                                    ; Change standard arrow to cross arrow
273F:1DBE                       loc_451:                                        ;  xref 273F:1C3B, 1C48, 1C6D, 1CAA
                                                                                ;            1CB2, 1CBA, 1D5B, 1D71
                                                                                ;            1D9D, 1DB7
273F:1DBE  A0 11E3                              mov     al, cursor_index_new
273F:1DC1  3A 06 11E1                           cmp     al, cursor_index
273F:1DC5  74 15                                je      loc_ret_453             ; Jump if equal
273F:1DC7  A2 11E1                              mov     cursor_index, al
273F:1DCA  C6 06 11DF 00                        mov     cursor_centroid, 0     
273F:1DCF  3C 0A                                cmp     al, CURSOR_CROSS
273F:1DD1  75 05                                jne     loc_452                 ; Jump if not equal
273F:1DD3  C6 06 11DF 07                        mov     cursor_centroid, 7
273F:1DD8                       loc_452:                                        ;  xref 273F:1DD1
273F:1DD8  FF 16 075E                           call    word ptr [show_cursor_proc]

273F:1DDC                       loc_ret_453:                                    ;  xref 273F:1DC5, 1E50
273F:1DDC  C3                                   retn

                         room_check_cursors     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                                                                                ;* No entry point to code
273F:1DDD  C3                                   retn
                                                                                ;* No entry point to code
273F:1DDE  A1 11D8                              mov     ax, mouse_y2
273F:1DE1  3D 0008                              cmp     ax,8
273F:1DE4  72 18                                jb      loc_454                 ; Jump if below
273F:1DE6  8A 1E CF09                           mov     bl, talk_line_num
273F:1DEA  80 FB 02                             cmp     bl,2
273F:1DED  72 15                                jb      loc_455                 ; Jump if below
273F:1DEF  80 C3 01                             add     bl,1
273F:1DF2  32 FF                                xor     bh,bh                   ; Zero register
273F:1DF4  D1 E3                                shl     bx,1                    ; Shift w/zeros fill
273F:1DF6  D1 E3                                shl     bx,1                    ; Shift w/zeros fill
273F:1DF8  D1 E3                                shl     bx,1                    ; Shift w/zeros fill
273F:1DFA  3B C3                                cmp     ax,bx
273F:1DFC  73 06                                jae     loc_455                 ; Jump if above or =
273F:1DFE                       loc_454:                                        ;  xref 273F:1DE4
273F:1DFE  C6 06 11E3 00                        mov     byte ptr ds:[11E3h],0   ; (273F:11E3=74h)
273F:1E03  C3                                   retn
273F:1E04                       loc_455:                                        
273F:1E04  F6 06 9837 FF                        test    talk_dialog_active, 0FFh
273F:1E09  74 3A                                jz      loc_457                 ; Jump if zero
273F:1E0B  A1 11D6                              mov     ax, mouse_x2
273F:1E0E  3B 06 11C2                           cmp     ax, talk_dialog_left
273F:1E12  72 31                                jb      loc_457                 ; Jump if below
273F:1E14  2B 06 11C2                           sub     ax, talk_dialog_left
273F:1E18  3B 06 11C4                           cmp     ax, talk_dialog_width
273F:1E1C  73 27                                jae     loc_457                 ; Jump if above or =
273F:1E1E  80 3E CF08 03                        cmp     talk_state, 3
273F:1E23  74 07                                je      loc_456                 ; Jump if equal
273F:1E25  80 3E CF08 04                        cmp     talk_state, 4
273F:1E2A  75 19                                jne     loc_457                 ; Jump if not equal
273F:1E2C                       loc_456:                                        ;  xref 273F:1E23
273F:1E2C  A1 11D8                              mov     ax, mouse_y2
273F:1E2F  3B 06 11C0                           cmp     ax, talk_dialog_top
273F:1E33  72 10                                jb      loc_457                 ; Jump if below
273F:1E35  2B 06 11C0                           sub     ax, talk_dialog_top
273F:1E39  3B 06 11C6                           cmp     ax, talk_dialog_height
273F:1E3D  73 06                                jae     loc_457                 ; Jump if above or =
273F:1E3F  C6 06 11E3 10                        mov     byte ptr ds:[11E3h],10h ; (273F:11E3=74h)
273F:1E44  C3                                   retn
273F:1E45                       loc_457:                                        ;  xref 273F:1E09, 1E12, 1E1C, 1E2A
                                                                                ;            1E33, 1E3D
273F:1E45  C6 06 11E3 16                        mov     byte ptr ds:[11E3h],16h ; (273F:11E3=74h)
273F:1E4A  C3                                   retn

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:1C8C, 1C95, 1C9E, 1CA7, 1CD9, 1CE2, 1CEB
                                ;                             1CF4
                                ;

273F:1E4B               room_check_hotspots     proc    near
273F:1E4B 8B 35                                mov     si,[di]                 ; Get data ptr
273F:1E4D  83 FE FF                             cmp     si,0FFFFh               ; Reached end of list?
273F:1E50  74 8A                                je      loc_ret_453             ; If yes, then exit
273F:1E52  39 54 06                             cmp     [si+HS_ROOM_NUM], dx    ; Entry in same room?
273F:1E55  75 4F                                jne     loc_463                 ; No, so go move to next 

273F:1E57  F6 44 03 80                          test    byte ptr [si+HS_FLAGS],80h
273F:1E5B  75 06                                jnz     loc_459                 ; Jump if not zero
273F:1E5D  F6 44 03 40                          test    byte ptr [si+HS_FLAGS],40h
273F:1E61  75 43                                jnz     loc_463
273F:1E63                       loc_459:
273F:1E63  F6 44 03 20                          test    byte ptr [si+HS_FLAGS],20h
273F:1E67  75 3D                                jnz     loc_463                 ; Jump if not zero
273F:1E69  81 FD 0409                           cmp     bp,409h
273F:1E6D  73 05                                jae     loc_460                 ; Jump if above or =
273F:1E6F  E8 293C                              call    room_check_x_extents
273F:1E72  75 32                                jnz     loc_463                 ; Jump if not zero
273F:1E74                       loc_460:                                        ;  xref 273F:1E6D
273F:1E74 BB 2A01                              mov     bx,offset hotspot_table
273F:1E77                       loc_461:                                        ;  xref 273F:1E84
273F:1E77 8B 07                                mov     ax,[bx]
273F:1E79  0B C0                                or      ax,ax                   ; Zero ?
273F:1E7B  74 31                                jz      loc_464                 ; Jump if zero
273F:1E7D  3B C5                                cmp     ax,bp
273F:1E7F  74 05                                je      loc_462                 ; Jump if equal
273F:1E81  83 C3 0A                             add     bx, HOTSPOT_TABLE_ENTRY_SIZE
273F:1E84  EB F1                                jmp     short loc_461           ; Check next entry
273F:1E86                       loc_462:

273F:1E86  A1 11D6                              mov     ax, mouse_x2  
273F:1E89  05 0080                              add     ax,80h
273F:1E8C  3B 47 02                             cmp     ax,[bx+2]
273F:1E8F  72 15                                jb      loc_463                 ; Jump if below
273F:1E91  3B 47 04                             cmp     ax,[bx+4]
273F:1E94  73 10                                jae     loc_463                 ; Jump if above or =
273F:1E96  A1 11D8                              mov     ax, mouse_y2 
273F:1E99  05 0080                              add     ax,80h
273F:1E9C  3B 47 06                             cmp     ax,[bx+6]
273F:1E9F  72 05                                jb      loc_463                 ; Jump if below
273F:1EA1  3B 47 08                             cmp     ax,[bx+8]
273F:1EA4  72 30                                jb      loc_465                 ; Jump if below

273F:1EA6                       loc_463:
273F:1EA6  83 C7 09                             add     di,9                    ; Move to next entry
273F:1EA9  83 C5 01                             add     bp,1                    ; Increment result Id
273F:1EAC  EB 9D                                jmp     room_check_hotspots

273F:1EAE                       loc_464:
273F:1EAE  A1 11D6                              mov     ax, mouse_x2
273F:1EB1  05 0080                              add     ax,80h
273F:1EB4  8B 4C 0D                             mov     cx,[si+0Dh]
273F:1EB7  3B C1                                cmp     ax,cx
273F:1EB9  72 EB                                jb      loc_463                 ; Jump if below
273F:1EBB  03 4C 19                             add     cx,[si+19h]
273F:1EBE  3B C8                                cmp     cx,ax
273F:1EC0  72 E4                                jb      loc_463                 ; Jump if below
273F:1EC2  A1 11D8                              mov     ax, mouse_y2             
273F:1EC5  05 0080                              add     ax,80h
273F:1EC8  8B 4C 0F                             mov     cx,[si+0Fh]
273F:1ECB  3B C1                                cmp     ax,cx
273F:1ECD  72 D7                                jb      loc_463                 ; Jump if below
273F:1ECF  03 4C 13                             add     cx,[si+13h]
273F:1ED2  3B C8                                cmp     cx,ax
273F:1ED4  72 D0                                jb      loc_463                 ; Jump if below
273F:1ED6                       loc_465:                                        ;  xref 273F:1EA4
273F:1ED6  80 4C 03 80                          or      byte ptr [si+3],80h
273F:1EDA  89 2E 1924                           mov     hotspot_id, bp
273F:1EDE  8B 45 02                             mov     ax,[di+2]
273F:1EE1  80 E4 1F                             and     ah,1Fh
273F:1EE4  A3 11E6                              mov     hotspot_name_id, ax     ; Save actions for this hotspot
273F:1EE7  C3                                   retn
                        room_check_hotspots     endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:0785, 94C8, 9DCC, 9DE5, 9DFE, 9E19, 9E33
                                ;                             9E4D, 9E63, 9E79
                                ; cx=horiz, dx=vert, bx=buttons, ax=trigger, si/di=horiz/vert mickeys
                                ;

273F:1EE8                    mouse_handler      proc    near
273F:1EE8  50                                   push    ax
273F:1EE9  53                                   push    bx
273F:1EEA  51                                   push    cx
273F:1EEB  52                                   push    dx
273F:1EEC  56                                   push    si
273F:1EED  57                                   push    di
273F:1EEE  55                                   push    bp
273F:1EEF  1E                                   push    ds
273F:1EF0  06                                   push    es
273F:1EF1  9C                                   pushf                           ; Push flags
273F:1EF2  81 F9 027E                           cmp     cx, 638
273F:1EF6  72 03                                jb      loc_466                 ; Jump if below
273F:1EF8  B9 027D                              mov     cx, 637
273F:1EFB                       loc_466:
273F:1EFB  D1 E9                                shr     cx,1                    ; Translate horiz 0-637 to 0-318
273F:1EFD  81 FA 00C8                           cmp     dx, 200
273F:1F01  72 03                                jb      loc_467                 ; Jump if below
273F:1F03  BA 00C7                              mov     dx, 199
273F:1F06                       loc_467:
273F:1F06  FC                                   cld
273F:1F07  B8 31E4                              mov     ax,data_seg
273F:1F0A  8E D8                                mov     ds,ax
273F:1F0C  3A 1E 11D5                           cmp     bl, mouse_buttons       ; Check mouse buttons
273F:1F10  74 27                                je      loc_468                 ; Jump if no button change
273F:1F12  88 1E 11D5                           mov     mouse_buttons, bl       ; Save new button status
273F:1F16  0A DB                                or      bl,bl                   ; Zero ?
273F:1F18  74 1F                                jz      loc_468                 ; Jump if no buttons pressed

273F:1F1A  F6 06 11DA FF                        test    mouse_buttons2, 0FFh
273F:1F1F  75 18                                jnz     loc_468                 ; Jump if not zero
273F:1F21  88 1E 11DA                           mov     mouse_buttons2, bl
273F:1F25  89 0E 11DB                           mov     char_dest_x, cx
273F:1F29  81 06 11DB 0080                      add     char_dest_x, 80h
273F:1F2F  89 16 11DD                           mov     char_dest_y, dx
273F:1F33  81 06 11DD 0080                      add     char_dest_y, 80h

273F:1F39                       loc_468:                                        ;  xref 273F:1F10, 1F18, 1F1F
273F:1F39  89 0E 11D1                           mov     mouse_x, cx
273F:1F3D  89 16 11D3                           mov     mouse_y, dx
273F:1F41  F6 06 11D0 06                        test    menubar_state, 6     ; (31E4:11D0=3)
273F:1F46  75 0C                                jnz     loc_469                 ; Jump if not zero
273F:1F48  89 0E 11D6                           mov     mouse_x2, cx
273F:1F4C  89 16 11D8                           mov     mouse_y2, dx
273F:1F50  FF 16 075E                           call    word ptr [show_cursor_proc]
273F:1F54                       loc_469:                                        ;  xref 273F:1F46
273F:1F54  9D                                   popf                            ; Pop flags
273F:1F55  07                                   pop     es
273F:1F56  1F                                   pop     ds
273F:1F57  5D                                   pop     bp
273F:1F58  5F                                   pop     di
273F:1F59  5E                                   pop     si
273F:1F5A  5A                                   pop     dx
273F:1F5B  59                                   pop     cx
273F:1F5C  5B                                   pop     bx
273F:1F5D  58                                   pop     ax
273F:1F5E  CB                                   retf                            ; Return far
                             mouse_handler      endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:0013, 001D, 70B3, 77EA, 8F5A, 938B, A5B5
                                ;                             A661, A8E3
                                ;

273F:1F5F                   show_disk_cursor    proc    near
273F:1F5F  80 3E 11E1 01                        cmp     cursor_index, CURSOR_DISK
273F:1F64  74 0E                                je      loc_ret_470             ; Jump if equal
273F:1F66  C6 06 11E1 01                        mov     cursor_index, CURSOR_DISK
273F:1F6B  C6 06 11DF 00                        mov     cursor_centroid, 0
273F:1F70  FF 16 075E                           call    word ptr [show_cursor_proc]

273F:1F74                       loc_ret_470:                                    ;  xref 273F:1F64, 1F7A
273F:1F74  C3                                   retn
                            show_disk_cursor    endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:00D0, 3D2B, 6D5A, 6E7E, 9342
                                ;

273F:1F75                   show_arrow_cursor   proc    near
273F:1F75  80 3E 11E1 00                        cmp     cursor_index, CURSOR_ARROW
273F:1F7A  74 F8                                je      loc_ret_470             ; Jump if equal
273F:1F7C  C6 06 11E1 00                        mov     cursor_index, CURSOR_ARROW
273F:1F81  C6 06 11DF 00                        mov     cursor_centroid, 0     
273F:1F86  FF 16 075E                           call    word ptr [show_cursor_proc]
273F:1F8A  C3                                   retn
                            show_arrow_cursor   endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:40CB, 413F, 5A6F, 5A75, 705E, 88EA, 88F0
                                ;                             912C, 93E9, 9401
                                ;

273F:1F8B                       mouse_wait      proc    near
273F:1F8B                       loc_471:                                        ;  xref 273F:1F93
273F:1F8B  E8 F52A                              call    set_vga_palette         ; (14B8)
273F:1F8E  F6 06 11D5 07                        test    byte ptr mouse_buttons, 7
273F:1F93  75 F6                                jnz     loc_471                 ; Mouse button being held down
273F:1F95  C3                                   retn
                                mouse_wait      endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:40C7, 4142, 5A72, 7061, 70B0, 88ED
                                ;

273F:1F96                 pause_for_input       proc    near
273F:1F96                       loc_472:                                        ;  xref 273F:1F9C
273F:1F96  B4 06                                mov     ah,6
273F:1F98  B2 FF                                mov     dl,0FFh
273F:1F9A  CD 21                                int     21h                     ; Read character from STDIN
273F:1F9C  75 F8                                jnz     loc_472                 ; key pressed

273F:1F9E                       loc_473:                                        ;  xref 273F:1FAB
273F:1F9E  E8 F517                              call    set_vga_palette         ; (14B8)
273F:1FA1  E8 757C                              call    check_keypress                 ; (9520)
273F:1FA4  75 0E                                jnz     loc_ret_474             ; Jump if not zero
273F:1FA6  F6 06 11D5 07                        test    mouse_buttons, 7
273F:1FAB  74 F1                                jz      loc_473                 ; No buttons pressed
273F:1FAD  C6 06 11DA 00                        mov     mouse_buttons2, 0
273F:1FB2  33 C0                                xor     ax,ax                   ; Zero register

273F:1FB4                       loc_ret_474:                                    ;  xref 273F:1FA4
273F:1FB4  C3                                   retn
                          pause_for_input       endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:1C3E
                                ;

                   talk_dialog_mouse_check      proc    near
273F:1FB5  C6 06 0DB4 00                        mov     talk_dialog_close_flag, 0
273F:1FBA  F6 06 9837 FF                        test    talk_dialog_active, 0FFh ; Is the dialog active?
273F:1FBF  74 3D                                jz      loc_475                 ; Jump if zero
273F:1FC1  F6 06 4B40 FF                        test    data_791, 0FFh
273F:1FC6  75 36                                jnz     loc_475                 ; Jump if not zero
273F:1FC8  81 3E 983F 03E8                      cmp     data_1090, PLAYER_HOTSPOT_ID
273F:1FCE  75 2E                                jne     loc_475                 ; Jump if not equal
273F:1FD0  A1 11D6                              mov     ax, mouse_x2
273F:1FD3  3B 06 11C2                           cmp     ax, talk_dialog_left
273F:1FD7  72 25                                jb      loc_475                 ; Jump if below
273F:1FD9  2B 06 11C2                           sub     ax, talk_dialog_left
273F:1FDD  3B 06 11C4                           cmp     ax, talk_dialog_width
273F:1FE1  73 1B                                jae     loc_475                 ; Jump if above or =
273F:1FE3  A1 11D8                              mov     ax, mouse_y2
273F:1FE6  3B 06 11C0                           cmp     ax, talk_dialog_top
273F:1FEA  72 12                                jb      loc_475                 ; Jump if below
273F:1FEC  2B 06 11C0                           sub     ax, talk_dialog_top
273F:1FF0  3B 06 11C6                           cmp     ax, talk_dialog_height
273F:1FF4  73 08                                jae     loc_475                 ; Jump if above or =
273F:1FF6  C6 06 0DB4 01                        mov     talk_dialog_close_flag, 1
273F:1FFB  33 C0                                xor     ax,ax                   ; Zero register
273F:1FFD  C3                                   retn

273F:1FFE                       loc_475:                                        ;  xref 273F:1FBF, 1FC6, 1FCE, 1FD7
                                                                                ;            1FE1, 1FEA, 1FF4
273F:1FFE  B0 01                                mov     al,1
273F:2000  0B C0                                or      ax,ax                   ; Zero ?
273F:2002  C3                                   retn
                   talk_dialog_mouse_check      endp

273F:2003  00                                   db      0

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:00E7
                                ;

273F:2004                       sub_61          proc    near
273F:2004  83 3E 9832 1F                        cmp     room_number, ROOMNUM_TOWN_HALL
273F:2009  74 29                                je      loc_ret_476             ; Jump if equal
273F:200B  83 3E 9832 0E                        cmp     room_number, ROOMNUM_MIDDLE_STREET
273F:2010  74 22                                je      loc_ret_476             ; Jump if equal
273F:2012  F7 06 BAA9 FFFF                      test    script_val_80, 0FFFFh 
273F:2018  74 1A                                jz      loc_ret_476             ; Jump if zero
273F:201A  F7 06 BA4F FFFF                      test    script_val_29, 0FFFFh
273F:2020  74 12                                jz      loc_ret_476             ; Jump if zero
273F:2022  83 2E BA4F 01                        sub     script_val_29, 1
273F:2027  75 0B                                jnz     loc_ret_476             ; Jump if not zero
273F:2029  BB 0CB7                              mov     bx, 0CB7h
273F:202C  B9 0002                              mov     cx,2
273F:202F  33 D2                                xor     dx,dx                   ; Zero register
273F:2031  E8 27FC                              call    add_sequence_delay

273F:2034                       loc_ret_476:                                    ;  xref 273F:2009, 2010, 2018, 2020
                                                                                ;            2027
273F:2034  C3                                   retn
                                sub_61          endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;


273F:2035  83 3E BA3B 03                        cmp     talk_record_index, 3
273F:203A  73 1A                                jae     loc_ret_477             ; Jump if above or =
273F:203C  83 3E 9832 2D                        cmp     room_number, ROOMNUM_DINING_HALL
273F:2041  75 13                                jne     loc_ret_477             ; Jump if not equal
273F:2043  F6 06 BA9B FF                        test    byte ptr script_val_73, 0FFh 
273F:2048  75 0C                                jnz     loc_ret_477             ; Jump if not zero
273F:204A  C7 06 BA17 03E8                      mov     character_hotspot, PLAYER_HOTSPOT_ID
273F:2050  B8 1E15                              mov     ax,1E15h
273F:2053  E8 1DDE                              call    sequence_execute

273F:2056                       loc_ret_477:                                    ;  xref 273F:203A, 2041, 2048
273F:2056  C3                                   retn

273F:2057  00                                   db      0
273F:2058  00                   data_233        db      0                       ;  xref 273F:2DA2, 2DD0, 2DD5, 2E2F
                                                                                ;            2E7B, 2EB9, 2EE8, 2EED
                                                                                ;            2F4F
273F:2059  00                   data_234        db      0                       ;  xref 273F:2DA7, 2DE7, 2DEC, 2E3C
                                                                                ;            2E80, 2EC0, 2EFF, 2F04
                                                                                ;            2F5C
273F:205A  00                   data_235        db      0                       ;  xref 273F:2DAC, 2DFE, 2E03, 2E49
                                                                                ;            2E85, 2EC7, 2F16, 2F1B
                                                                                ;            2F69
273F:205B  00                   data_236        db      0                       ;  xref 273F:2DB1, 2E15, 2E1A, 2E56
                                                                                ;            2E8A, 2ECE, 2F2D, 2F32
                                                                                ;            2F76

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:7BBA, A7AD, A82B
                                ;

273F:205C                   ega_show_srceen     proc    near
273F:205C  80 0E 11D0 02                        or      menubar_state, 2     ; (31E4:11D0=3)
273F:2061  BA 03CE                              mov     dx,3CEh
273F:2064  B8 0805                              mov     ax,805h
273F:2067  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 5, mode
273F:2068  B8 0007                              mov     ax,7
273F:206B  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 7, ignore color bits
273F:206C  B0 03                                mov     al,3
273F:206E  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 3, data rotate
273F:206F  B8 FF08                              mov     ax,0FF08h
273F:2072  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 8, data bit mask
273F:2073  B2 C4                                mov     dl,0C4h
273F:2075  A1 0DB2                              mov     ax, screen_start_seg2
273F:2078  8E C0                                mov     es,ax
273F:207A  F6 06 4BF0 FF                        test    byte ptr data_794,0FFh  ; (31E4:4BF0=0)
273F:207F  74 03                                jz      loc_478                 ; Jump if zero
273F:2081  E8 0F41                              call    sub_68                  ; (2FC5)
273F:2084                       loc_478:                                        ;  xref 273F:207F
273F:2084 BB 07DC                              mov     bx, offset display_mask
273F:2087  03 1E 0990                           add     bx,data_587             ; (31E4:0990=0)
273F:208B  B9 060A                              mov     cx,60Ah
273F:208E BE 0500                              mov     si,data_12e             ; (0000:0500=0)
273F:2091 BF 0140                              mov     di,data_1449e           ; (A200:0140=0)
273F:2094                       loc_479:                                        ;  xref 273F:20E2, 20F4
273F:2094  F6 07 01                             test    byte ptr [bx],1
273F:2097  74 3D                                jz      loc_482                 ; Jump if zero
273F:2099  56                                   push    si
273F:209A  57                                   push    di
273F:209B  51                                   push    cx
273F:209C  80 27 FE                             and     byte ptr [bx],0FEh
273F:209F  1E                                   push    ds
273F:20A0  A1 4CE4                              mov     ax, data_segment2
273F:20A3  8E D8                                mov     ds,ax
273F:20A5  B8 0802                              mov     ax,802h
273F:20A8  B9 0004                              mov     cx,4

273F:20AB                       locloop_480:                                    ;  xref 273F:20D0
273F:20AB  51                                   push    cx
273F:20AC  56                                   push    si
273F:20AD  57                                   push    di
273F:20AE  EF                                   out     dx,ax                   ; port 3C4h, EGA sequencr index
                                                                                ;  al = 2, map mask register
273F:20AF  B9 0020                              mov     cx,20h

273F:20B2                       locloop_481:                                    ;  xref 273F:20C6
273F:20B2  A4                                   movsb                           ; Mov [si] to es:[di]
273F:20B3  83 C6 03                             add     si,3
273F:20B6  A4                                   movsb                           ; Mov [si] to es:[di]
273F:20B7  83 C6 03                             add     si,3
273F:20BA  A4                                   movsb                           ; Mov [si] to es:[di]
273F:20BB  83 C6 03                             add     si,3
273F:20BE  A4                                   movsb                           ; Mov [si] to es:[di]
273F:20BF  81 C6 0093                           add     si,93h
273F:20C3  83 C7 24                             add     di,24h
273F:20C6  E2 EA                                loop    locloop_481             ; Loop if cx > 0

273F:20C8  5F                                   pop     di
273F:20C9  5E                                   pop     si
273F:20CA  83 C6 01                             add     si,1
273F:20CD  D0 EC                                shr     ah,1                    ; Shift w/zeros fill
273F:20CF  59                                   pop     cx
273F:20D0  E2 D9                                loop    locloop_480             ; Loop if cx > 0

273F:20D2  1F                                   pop     ds
273F:20D3  59                                   pop     cx
273F:20D4  5F                                   pop     di
273F:20D5  5E                                   pop     si
273F:20D6                       loc_482:                                        ;  xref 273F:2097
273F:20D6  83 C6 10                             add     si,10h
273F:20D9  83 C7 04                             add     di,4
273F:20DC  83 C3 01                             add     bx,1
273F:20DF  80 E9 01                             sub     cl,1
273F:20E2  75 B0                                jnz     loc_479                 ; Jump if not zero
273F:20E4  83 C3 08                             add     bx,8
273F:20E7  81 C6 1360                           add     si,1360h
273F:20EB  81 C7 04D8                           add     di,4D8h
273F:20EF  B1 0A                                mov     cl,0Ah
273F:20F1  80 ED 01                             sub     ch,1
273F:20F4  75 9E                                jnz     loc_479                 ; Jump if not zero
273F:20F6  B8 0F02                              mov     ax,0F02h
273F:20F9  EF                                   out     dx,ax                   ; port 3C4h, EGA sequencr index
                                                                                ;  al = 2, map mask register
273F:20FA  B2 CE                                mov     dl,0CEh
273F:20FC  B8 0005                              mov     ax,5
273F:20FF  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 5, mode
273F:2100  B8 0F07                              mov     ax,0F07h
273F:2103  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 7, ignore color bits
273F:2104  B8 FF08                              mov     ax,0FF08h
273F:2107  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 8, data bit mask
273F:2108  A1 0DB0                              mov     ax, screen_start_seg    ; Swap screen segment
273F:210B  8B 1E 0DB2                           mov     bx, screen_start_seg2
273F:210F  89 1E 0DB0                           mov     screen_start_seg, bx
273F:2113  A3 0DB2                              mov     screen_start_seg2, ax
273F:2116  1E                                   push    ds
273F:2117  07                                   pop     es
273F:2118 BE 11E8                              mov     si,offset data_638      ; (31E4:11E8=0)
273F:211B BF 12AE                              mov     di,offset data_642      ; (31E4:12AE=0)
273F:211E  B9 0063                              mov     cx,63h
273F:2121  F3/ A5                               rep     movsw                   ; Rep when cx >0 Mov [si] to es:[di]
273F:2123  C7 06 11EC 0000                      mov     data_640,0              ; (31E4:11EC=0)
273F:2129  E8 0987                              call    ega_cursor
273F:212C  A0 0DB1                              mov     al, [screen_start_seg+1]
273F:212F  D0 E8                                shr     al,1                    ; Shift w/zeros fill
273F:2131  24 01                                and     al,1
273F:2133  B4 05                                mov     ah,5
273F:2135  CD 10                                int     10h                     ; Video display   ah=functn 05h
                                                                                ;  set display page al
273F:2137  B8 0040                              mov     ax,40h
273F:213A  8E C0                                mov     es,ax
273F:213C  26: 8B 16 0063                       mov     dx,es:video_port        ; (0040:0063=3D4h)
273F:2141  80 C2 06                             add     dl,6
273F:2144                       loc_483:                                        ;  xref 273F:2147
273F:2144  EC                                   in      al,dx                   ; port 3DAh, CGA/EGA vid status
           nlure.lst                           Sourcer v6.09   17-Nov- 5   5:53 pm   Page 85

273F:2145  A8 08                                test    al,8
273F:2147  74 FB                                jz      loc_483                 ; Jump if zero
273F:2149 BE 12AE                              mov     si,offset data_642      ; (31E4:12AE=0)
273F:214C  A1 0DB2                              mov     ax, screen_start_seg2
273F:214F  8E C0                                mov     es,ax
273F:2151  E8 0AD1                              call    sub_67                  ; (2C25)
273F:2154  80 36 0991 01                        xor     byte ptr data_587+1,1   ; (31E4:0991=0)
273F:2159  80 26 11D0 FD                        and     menubar_state, 0FDh  ; (31E4:11D0=3)
273F:215E  C3                                   retn
                             ega_show_screen    endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called indircetly via calls to word ptr [fade_out_proc]
                                ;

                          ega_empty_palette     proc    near

273F:215F  80 0E 073C 20                        or      byte ptr ds:[73Ch],20h  ; (273F:073C=17h) ' '
273F:2164  80 26 11D0 CF                        and     menubar_state, 0CFh ; (273F:11D0=56h)
273F:2169  B8 1002                              mov     ax,1002h
273F:216C  1E                                   push    ds
273F:216D  07                                   pop     es
273F:216E BA 0DB5                              mov     dx,0DB5h                ; (273F:0DB5=0C7h)
273F:2171  CD 10                                int     10h                     ; Video display   ah=functn 10h
                                                                                ;  set palette regs from es:dx
273F:2173  C3                                   retn

                          ega_empty_palette     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called indircetly via calls to word ptr [fade_in_proc]
                                ; For EGA cards, don't do a fade-in.. just set the whole palette
                                ;

                                ega_fade_in     proc    near
273F:2174  80 26 073C DF                        and     byte ptr ds:[73Ch],0DFh ; (273F:073C=17h)
273F:2179  B8 1002                              mov     ax,1002h
273F:217C  1E                                   push    ds
273F:217D  07                                   pop     es
273F:217E BA 1457                              mov     dx,offset unprocessed_vga_palette
273F:2181  CD 10                                int     10h                     ; Video display   ah=functn 10h
                                                                                ;  set palette regs from es:dx
273F:2183  C3                                   retn
                                ega_fade_in     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;


273F:2184  1E                                   push    ds
273F:2185  57                                   push    di
273F:2186  56                                   push    si
273F:2187  98                                   cbw                             ; Convrt byte to word
273F:2188  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:218A  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:218C  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:218E  8B F0                                mov     si,ax
273F:2190  8B 16 4CF0                           mov     dx, font2_segment
273F:2194  8E DA                                mov     ds,dx
273F:2196  AC                                   lodsb                           ; String [si] to al
273F:2197  50                                   push    ax
273F:2198  B5 07                                mov     ch,7
273F:219A                       loc_484:                                        ;  xref 273F:2202
273F:219A  AC                                   lodsb                           ; String [si] to al
273F:219B  8A E0                                mov     ah,al
273F:219D  32 C0                                xor     al,al                   ; Zero register
273F:219F  D3 E8                                shr     ax,cl                   ; Shift w/zeros fill
273F:21A1  8B D0                                mov     dx,ax
273F:21A3  F7 D2                                not     dx
273F:21A5  8A DF                                mov     bl,bh
273F:21A7  D0 EB                                shr     bl,1                    ; Shift w/zeros fill
273F:21A9  73 09                                jnc     loc_485                 ; Jump if carry=0
273F:21AB  26: 08 25                            or      es:[di],ah
273F:21AE  26: 08 45 04                         or      es:[di+4],al
273F:21B2  EB 07                                jmp     short loc_486           ; (21BB)

273F:21B4                       loc_485:                                        ;  xref 273F:21A9
273F:21B4  26: 20 35                            and     es:[di],dh
273F:21B7  26: 20 55 04                         and     es:[di+4],dl
273F:21BB                       loc_486:                                        ;  xref 273F:21B2
273F:21BB  D0 EB                                shr     bl,1                    ; Shift w/zeros fill
273F:21BD  73 0A                                jnc     loc_487                 ; Jump if carry=0
273F:21BF  26: 08 65 01                         or      es:[di+1],ah
273F:21C3  26: 08 45 05                         or      es:[di+5],al
273F:21C7  EB 08                                jmp     short loc_488           ; (21D1)
273F:21C9                       loc_487:                                        ;  xref 273F:21BD
273F:21C9  26: 20 75 01                         and     es:[di+1],dh
273F:21CD  26: 20 55 05                         and     es:[di+5],dl
273F:21D1                       loc_488:                                        ;  xref 273F:21C7
273F:21D1  D0 EB                                shr     bl,1                    ; Shift w/zeros fill
273F:21D3  73 0A                                jnc     loc_489                 ; Jump if carry=0
273F:21D5  26: 08 65 02                         or      es:[di+2],ah
273F:21D9  26: 08 45 06                         or      es:[di+6],al
273F:21DD  EB 08                                jmp     short loc_490           ; (21E7)
273F:21DF                       loc_489:                                        ;  xref 273F:21D3
273F:21DF  26: 20 75 02                         and     es:[di+2],dh
273F:21E3  26: 20 55 06                         and     es:[di+6],dl
273F:21E7                       loc_490:                                        ;  xref 273F:21DD
273F:21E7  D0 EB                                shr     bl,1                    ; Shift w/zeros fill
273F:21E9  73 0A                                jnc     loc_491                 ; Jump if carry=0
273F:21EB  26: 08 65 03                         or      es:[di+3],ah
273F:21EF  26: 08 45 07                         or      es:[di+7],al
273F:21F3  EB 08                                jmp     short loc_492           ; (21FD)
273F:21F5                       loc_491:                                        ;  xref 273F:21E9
273F:21F5  26: 20 75 03                         and     es:[di+3],dh
273F:21F9  26: 20 55 07                         and     es:[di+7],dl
273F:21FD                       loc_492:                                        ;  xref 273F:21F3
273F:21FD  03 FD                                add     di,bp
273F:21FF  80 ED 01                             sub     ch,1
273F:2202  75 96                                jnz     loc_484                 ; Jump if not zero
273F:2204  58                                   pop     ax
273F:2205  5E                                   pop     si
273F:2206  5F                                   pop     di
273F:2207  1F                                   pop     ds
273F:2208  02 C8                                add     cl,al
273F:220A  8A C1                                mov     al,cl
273F:220C  80 E1 07                             and     cl,7
273F:220F  25 00F8                              and     ax,0F8h
273F:2212  D1 E8                                shr     ax,1                    ; Shift w/zeros fill
273F:2214  03 F8                                add     di,ax
273F:2216  C3                                   retn

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                           ega_talk_dialog      proc    near
273F:2217  1E                                   push    ds
273F:2218  A1 11C0                              mov     ax, talk_dialog_top
273F:221B  50                                   push    ax
273F:221C  05 0008                              add     ax,8
273F:221F  8B D0                                mov     dx,ax
273F:2221  D1 E2                                shl     dx,1                    ; Shift w/zeros fill
273F:2223  D1 E2                                shl     dx,1                    ; Shift w/zeros fill
273F:2225  03 C2                                add     ax,dx
273F:2227  B1 05                                mov     cl,5
273F:2229  D3 E0                                shl     ax,cl                   ; Shift w/zeros fill
273F:222B  8B F8                                mov     di,ax
273F:222D  A1 11C2                              mov     ax, talk_dialog_left
273F:2230  24 F8                                and     al,0F8h
273F:2232  D1 E8                                shr     ax,1                    ; Shift w/zeros fill
273F:2234  03 F8                                add     di,ax
273F:2236  B8 0007                              mov     ax,7
273F:2239  F7 26 B9FD                           mul     data_1122               ; dx:ax = data * ax
273F:223D  05 0014                              add     ax,14h
273F:2240  8B D0                                mov     dx,ax
273F:2242  A3 11C6                              mov     talk_dialog_height, ax
273F:2245  A1 4CE4                              mov     ax, data_segment2
273F:2248  8E C0                                mov     es,ax
273F:224A  A1 4CE6                              mov     ax, talk_dialog_buffer
273F:224D  8E D8                                mov     ds,ax
273F:224F BE 0000                              mov     si,data_69e             ; (0874:0000=0C5h)
273F:2252                       loc_493:                                        ;  xref 273F:225D
273F:2252  B9 0020                              mov     cx,20h
273F:2255  F3/ A5                               rep     movsw                   ; Rep when cx >0 Mov [si] to es:[di]
273F:2257  83 C7 60                             add     di,60h
273F:225A  80 EA 01                             sub     dl,1
273F:225D  75 F3                                jnz     loc_493                 ; Jump if not zero
273F:225F  5B                                   pop     bx
273F:2260  1F                                   pop     ds
273F:2261  8B 16 11C6                           mov     dx, talk_dialog_height
273F:2265  A1 11C2                              mov     ax, talk_dialog_left
273F:2268  BD 0080                              mov     bp,80h
273F:226B  89 2E 11C4                           mov     talk_dialog_width, bp
273F:226F  B9 0001                              mov     cx,1
273F:2272  E9 E91A                              jmp     loc_93                  ; (0B8F)
                           ega_talk_dialog      endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                       ega_draw_talk_dialog     proc    near
273F:2275  B8 0007                              mov     ax,7
273F:2278  F7 E5                                mul     bp                      ; dx:ax = reg * ax
273F:227A  05 000E                              add     ax,0Eh
273F:227D  A3 11C6                              mov     talk_dialog_height, ax
273F:2280  8B E8                                mov     bp,ax
273F:2282  C7 06 11C4 0080                      mov     talk_dialog_width, 80h
273F:2288  1E                                   push    ds
273F:2289  55                                   push    bp
273F:228A  B8 44E4                              mov     ax, ega_talk_frame_seg
273F:228D  8E D8                                mov     ds,ax
273F:228F  33 F6                                xor     si,si                   ; Zero register
273F:2291  BB 000E                              mov     bx,0Eh
273F:2294  BA 0003                              mov     dx,3
273F:2297                       loc_494:                                        ;  xref 273F:22A0
273F:2297  E8 01B9                              call    sub_63                  ; (2453)
273F:229A  83 EF 60                             sub     di,60h
273F:229D  83 EA 01                             sub     dx,1
273F:22A0  75 F5                                jnz     loc_494                 ; Jump if not zero
273F:22A2  5A                                   pop     dx
273F:22A3                       loc_495:                                        ;  xref 273F:22AF
273F:22A3  E8 01AD                              call    sub_63                  ; (2453)
273F:22A6  83 EF 60                             sub     di,60h
273F:22A9  83 EE 0C                             sub     si,0Ch
273F:22AC  83 EA 01                             sub     dx,1
273F:22AF  75 F2                                jnz     loc_495                 ; Jump if not zero
273F:22B1  BA 0003                              mov     dx,3
273F:22B4  83 C6 0C                             add     si,0Ch
273F:22B7                       loc_496:                                        ;  xref 273F:22C0
273F:22B7  E8 0199                              call    sub_63                  ; (2453)
273F:22BA  83 EF 60                             sub     di,60h
273F:22BD  83 EA 01                             sub     dx,1
273F:22C0  75 F5                                jnz     loc_496                 ; Jump if not zero
273F:22C2  1F                                   pop     ds
273F:22C3  C3                                   retn
                       ega_draw_talk_dialog     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                             ega_menu_items     proc    near

273F:22C4  BA 03CE                              mov     dx,3CEh
273F:22C7  B8 0805                              mov     ax,805h
273F:22CA  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 5, mode
273F:22CB  B8 0007                              mov     ax,7
273F:22CE  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 7, ignore color bits
273F:22CF  B0 03                                mov     al,3
273F:22D1  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 3, data rotate
273F:22D2  B8 FF08                              mov     ax,0FF08h
273F:22D5  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 8, data bit mask
273F:22D6  B2 C4                                mov     dl,0C4h
273F:22D8  55                                   push    bp
273F:22D9  1E                                   push    ds
273F:22DA  8E DD                                mov     ds,bp
273F:22DC  A1 0DB2                              mov     ax,ds:data_25e          ; (0000:0DB2=8340h)
273F:22DF  1F                                   pop     ds
273F:22E0  8E C0                                mov     es,ax
273F:22E2 BF 08C1                              mov     di,data_1442e           ; (8340:08C1=0)
273F:22E5  8B 36 335A                           mov     si,word ptr ds:[335Ah]  ; (273F:335A=0ACA4h)
273F:22E9  8A 1E 334E                           mov     bl,byte ptr ds:[334Eh]  ; (273F:334E=0E4h)
273F:22ED  32 FF                                xor     bh,bh                   ; Zero register
273F:22EF  8B EB                                mov     bp,bx
273F:22F1  1E                                   push    ds
                                                assume  ds:seg_code
273F:22F2  A1 3376                              mov     ax,data_265             ; (273F:3376=0F632h)
273F:22F5  8E D8                                mov     ds,ax
273F:22F7  B8 0802                              mov     ax,802h
273F:22FA  B9 0004                              mov     cx,4

273F:22FD                       locloop_497:                                    ;  xref 273F:2323
273F:22FD  51                                   push    cx
273F:22FE  56                                   push    si
273F:22FF  57                                   push    di
273F:2300  EF                                   out     dx,ax                   ; port 3C4h, EGA sequencr index
                                                                                ;  al = 2, map mask register
273F:2301  B9 0048                              mov     cx,48h

273F:2304                       locloop_498:                                    ;  xref 273F:2319
273F:2304  51                                   push    cx
273F:2305  56                                   push    si
273F:2306  57                                   push    di
273F:2307  8B CD                                mov     cx,bp

273F:2309                       locloop_499:                                    ;  xref 273F:230D
273F:2309  A4                                   movsb                           ; Mov [si] to es:[di]
273F:230A  83 C6 03                             add     si,3
273F:230D  E2 FA                                loop    locloop_499             ; Loop if cx > 0

273F:230F  5F                                   pop     di
273F:2310  5E                                   pop     si
273F:2311  59                                   pop     cx
273F:2312  83 C7 28                             add     di,28h
273F:2315  81 C6 00A0                           add     si,0A0h
273F:2319  E2 E9                                loop    locloop_498             ; Loop if cx > 0

273F:231B  5F                                   pop     di
273F:231C  5E                                   pop     si
273F:231D  83 C6 01                             add     si,1
273F:2320  D0 EC                                shr     ah,1                    ; Shift w/zeros fill
273F:2322  59                                   pop     cx
273F:2323  E2 D8                                loop    locloop_497             ; Loop if cx > 0

273F:2325  1F                                   pop     ds
273F:2326  5D                                   pop     bp
273F:2327  B8 0F02                              mov     ax,0F02h
273F:232A  EF                                   out     dx,ax                   ; port 3C4h, EGA sequencr index
                                                                                ;  al = 2, map mask register
273F:232B  B2 CE                                mov     dl,0CEh
273F:232D  B8 0005                              mov     ax,5
273F:2330  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 5, mode
273F:2331  B8 0F07                              mov     ax,0F07h
273F:2334  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 7, ignore color bits
273F:2335  B8 FF08                              mov     ax,0FF08h
273F:2338  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 8, data bit mask
273F:2339  1E                                   push    ds
273F:233A  55                                   push    bp
273F:233B  8E DD                                mov     ds,bp
273F:233D  A1 0DB0                              mov     ax, screen_start_seg
273F:2340  8B 1E 0DB2                           mov     bx, screen_start_seg2
273F:2344  89 1E 0DB0                           mov     screen_start_seg, bx
273F:2348  A3 0DB2                              mov     screen_start_seg2, ax
273F:234B  A0 0DB1                              mov     al, [screen_start_seg+1]
273F:234E  D0 E8                                shr     al,1                    ; Shift w/zeros fill
273F:2350  24 01                                and     al,1
273F:2352  B4 05                                mov     ah,5
273F:2354  CD 10                                int     10h                     ; Video display   ah=functn 05h
                                                                                ;  set display page al
273F:2356  B8 0040                              mov     ax,40h
273F:2359  8E C0                                mov     es,ax
273F:235B  26: 8B 16 0063                       mov     dx,es:video_port        ; (0040:0063=3D4h)
273F:2360  80 C2 06                             add     dl,6
273F:2363                       loc_500:                                        ;  xref 273F:2366
273F:2363  EC                                   in      al,dx                   ; port 3DAh, CGA/EGA vid status
273F:2364  A8 08                                test    al,8
273F:2366  74 FB                                jz      loc_500                 ; Jump if zero
273F:2368  80 36 0991 01                        xor     byte ptr ds:data_22e,1  ; (0000:0991=8Eh)
273F:236D  5D                                   pop     bp
273F:236E  1F                                   pop     ds
273F:236F  C3                                   retn

                             ega_menu_items     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called indircetly via calls to word ptr [fade_out_proc]
                                ;

                           ega_draw_dialog      proc    near

273F:2370  32 E4                                xor     ah,ah                   ; Zero register
273F:2372  32 FF                                xor     bh,bh                   ; Zero register
273F:2374  32 ED                                xor     ch,ch                   ; Zero register
273F:2376  32 F6                                xor     dh,dh                   ; Zero register
273F:2378  52                                   push    dx
273F:2379  51                                   push    cx
273F:237A  53                                   push    bx
273F:237B  50                                   push    ax
273F:237C  52                                   push    dx
273F:237D  93                                   xchg    bx,ax
273F:237E  BA 0500                              mov     dx,500h
273F:2381  F7 E2                                mul     dx                      ; dx:ax = reg * ax
273F:2383  D1 E3                                shl     bx,1                    ; Shift w/zeros fill
273F:2385  D1 E3                                shl     bx,1                    ; Shift w/zeros fill
273F:2387  03 C3                                add     ax,bx
273F:2389  8B F8                                mov     di,ax
273F:238B  5A                                   pop     dx
273F:238C  83 C2 01                             add     dx,1
273F:238F  8B C2                                mov     ax,dx
273F:2391  D1 E2                                shl     dx,1                    ; Shift w/zeros fill
273F:2393  D1 E2                                shl     dx,1                    ; Shift w/zeros fill
273F:2395  D1 E2                                shl     dx,1                    ; Shift w/zeros fill
273F:2397  F7 C5 FFFF                           test    bp,0FFFFh
273F:239B  75 02                                jnz     loc_501                 ; Jump if not zero
273F:239D  2B D0                                sub     dx,ax
273F:239F                       loc_501:                                        ;  xref 273F:239B
273F:239F  83 C2 01                             add     dx,1
273F:23A2  8B D9                                mov     bx,cx
273F:23A4  A1 4CE4                              mov     ax, data_segment2
273F:23A7  8E C0                                mov     es,ax
273F:23A9  1E                                   push    ds
273F:23AA  B8 44E4                              mov     ax, ega_talk_frame_seg
273F:23AD  8E D8                                mov     ds,ax
273F:23AF  33 F6                                xor     si,si                   ; Zero register
273F:23B1  52                                   push    dx
273F:23B2  BA 0003                              mov     dx,3
273F:23B5                       loc_502:                                        ;  xref 273F:23BB
273F:23B5  E8 009B                              call    sub_63                  ; (2453)
273F:23B8  83 EA 01                             sub     dx,1
273F:23BB  75 F8                                jnz     loc_502                 ; Jump if not zero
273F:23BD  5A                                   pop     dx
273F:23BE                       loc_503:                                        ;  xref 273F:23C7
273F:23BE  E8 0092                              call    sub_63                  ; (2453)
273F:23C1  83 EE 0C                             sub     si,0Ch
273F:23C4  83 EA 01                             sub     dx,1
273F:23C7  75 F5                                jnz     loc_503                 ; Jump if not zero
273F:23C9  83 C6 0C                             add     si,0Ch
273F:23CC  BA 0003                              mov     dx,3
273F:23CF                       loc_504:                                        ;  xref 273F:23D5
273F:23CF  E8 0081                              call    sub_63                  ; (2453)
273F:23D2  83 EA 01                             sub     dx,1
273F:23D5  75 F8                                jnz     loc_504                 ; Jump if not zero
273F:23D7  1F                                   pop     ds
273F:23D8  58                                   pop     ax
273F:23D9  5B                                   pop     bx
273F:23DA  5D                                   pop     bp
273F:23DB  5A                                   pop     dx
273F:23DC  83 EB 01                             sub     bx,1
273F:23DF  83 C2 02                             add     dx,2
273F:23E2  83 C5 02                             add     bp,2
273F:23E5  B1 81                                mov     cl,81h
273F:23E7  E9 E799                              jmp     loc_92

                           ega_draw_dialog      endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

273F:23EA  32 FF                                xor     bh,bh                   ; Zero register
273F:23EC  32 F6                                xor     dh,dh                   ; Zero register
273F:23EE  53                                   push    bx
273F:23EF  B0 0B                                mov     al,0Bh
273F:23F1  2A C2                                sub     al,dl
273F:23F3  52                                   push    dx
273F:23F4  B9 0500                              mov     cx,500h
273F:23F7  F7 E1                                mul     cx                      ; dx:ax = reg * ax
273F:23F9  05 00A0                              add     ax,0A0h
273F:23FC  5A                                   pop     dx
273F:23FD  8B F8                                mov     di,ax
273F:23FF  D1 E2                                shl     dx,1                    ; Shift w/zeros fill
273F:2401  83 C2 01                             add     dx,1
273F:2404  D1 E2                                shl     dx,1                    ; Shift w/zeros fill
273F:2406  D1 E2                                shl     dx,1                    ; Shift w/zeros fill
273F:2408  D1 E2                                shl     dx,1                    ; Shift w/zeros fill
273F:240A  83 EA 08                             sub     dx,8
273F:240D  A1 4CE4                              mov     ax, data_segment2
273F:2410  8E C0                                mov     es,ax
273F:2412  1E                                   push    ds
273F:2413  B8 44E4                              mov     ax, ega_talk_frame_seg
273F:2416  8E D8                                mov     ds,ax
273F:2418  33 F6                                xor     si,si                   ; Zero register
273F:241A  52                                   push    dx
273F:241B  BA 0003                              mov     dx,3
273F:241E                       loc_505:                                        ;  xref 273F:2424
273F:241E  E8 0032                              call    sub_63                  ; (2453)
273F:2421  83 EA 01                             sub     dx,1
273F:2424  75 F8                                jnz     loc_505                 ; Jump if not zero
273F:2426  5A                                   pop     dx
273F:2427                       loc_506:                                        ;  xref 273F:2430
273F:2427  E8 0029                              call    sub_63                  ; (2453)
273F:242A  83 EE 0C                             sub     si,0Ch
273F:242D  83 EA 01                             sub     dx,1
273F:2430  75 F5                                jnz     loc_506                 ; Jump if not zero
273F:2432  83 C6 0C                             add     si,0Ch
273F:2435  BA 0003                              mov     dx,3
273F:2438                       loc_507:                                        ;  xref 273F:243E
273F:2438  E8 0018                              call    sub_63                  ; (2453)
273F:243B  83 EA 01                             sub     dx,1
273F:243E  75 F8                                jnz     loc_507                 ; Jump if not zero
273F:2440  1F                                   pop     ds
273F:2441  B8 0001                              mov     ax,1
273F:2444  BB 0007                              mov     bx,7
273F:2447  5D                                   pop     bp
273F:2448  83 C5 02                             add     bp,2
273F:244B  BA 0009                              mov     dx,9
273F:244E  B1 81                                mov     cl,81h
273F:2450  E9 E730                              jmp     loc_92                  ; (0B83)

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:2297, 22A3, 22B7, 23B5, 23BE, 23CF, 241E
                                ;                             2427, 2438, 3039, 303C, 303F, 3045, 3048
                                ;

273F:2453                       sub_63          proc    near
273F:2453  57                                   push    di
273F:2454  A5                                   movsw                           ; Mov [si] to es:[di]
273F:2455  A5                                   movsw                           ; Mov [si] to es:[di]
273F:2456  AD                                   lodsw                           ; String [si] to ax
273F:2457  8B E8                                mov     bp,ax
273F:2459  AD                                   lodsw                           ; String [si] to ax
273F:245A  8B CB                                mov     cx,bx

273F:245C                       locloop_508:                                    ;  xref 273F:2460
273F:245C  95                                   xchg    bp,ax
273F:245D  AB                                   stosw                           ; Store ax to es:[di]
273F:245E  95                                   xchg    bp,ax
273F:245F  AB                                   stosw                           ; Store ax to es:[di]
273F:2460  E2 FA                                loop    locloop_508             ; Loop if cx > 0

273F:2462  A5                                   movsw                           ; Mov [si] to es:[di]
273F:2463  A5                                   movsw                           ; Mov [si] to es:[di]
273F:2464  5F                                   pop     di
273F:2465  81 C7 00A0                           add     di,0A0h
273F:2469  C3                                   retn
                                sub_63          endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:0C6B, 7BB1
                                ;

273F:246A                   ega_decode_entry    proc    near
273F:246A  1E                                   push    ds
273F:246B  8E DA                                mov     ds,dx
273F:246D BE 0086                              mov     si,data_1435e           ; (45F6:0086=15h)
273F:2470  33 FF                                xor     di,di                   ; Zero register
273F:2472  BD 0020                              mov     bp,20h
273F:2475  8B 14                                mov     dx,[si]
273F:2477  86 F2                                xchg    dh,dl
273F:2479  83 C6 02                             add     si,2
273F:247C  B9 0008                              mov     cx,8
273F:247F  33 DB                                xor     bx,bx                   ; Zero register
273F:2481                       loc_509:                                        ;  xref 273F:24C9, 24D3
273F:2481  8A C6                                mov     al,dh
273F:2483  D0 E8                                shr     al,1                    ; Shift w/zeros fill
273F:2485  D0 E8                                shr     al,1                    ; Shift w/zeros fill
273F:2487  D0 E8                                shr     al,1                    ; Shift w/zeros fill
273F:2489  88 01                                mov     [bx+di],al
273F:248B  D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:248D  E2 07                                loop    locloop_510             ; Loop if cx > 0

273F:248F  86 D0                                xchg    dl,al
273F:2491  AC                                   lodsb                           ; String [si] to al
           nlure.lst                           Sourcer v6.09   17-Nov- 5   5:53 pm   Page 93

273F:2492  86 D0                                xchg    dl,al
273F:2494  B1 08                                mov     cl,8

273F:2496                       locloop_510:                                    ;  xref 273F:248D
273F:2496  D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:2498  E2 07                                loop    locloop_511             ; Loop if cx > 0

273F:249A  86 D0                                xchg    dl,al
273F:249C  AC                                   lodsb                           ; String [si] to al
273F:249D  86 D0                                xchg    dl,al
273F:249F  B1 08                                mov     cl,8

273F:24A1                       locloop_511:                                    ;  xref 273F:2498
273F:24A1  D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:24A3  E2 07                                loop    locloop_512             ; Loop if cx > 0

273F:24A5  86 D0                                xchg    dl,al
273F:24A7  AC                                   lodsb                           ; String [si] to al
273F:24A8  86 D0                                xchg    dl,al
273F:24AA  B1 08                                mov     cl,8

273F:24AC                       locloop_512:                                    ;  xref 273F:24A3
273F:24AC  D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:24AE  E2 07                                loop    locloop_513             ; Loop if cx > 0

273F:24B0  86 D0                                xchg    dl,al
273F:24B2  AC                                   lodsb                           ; String [si] to al
273F:24B3  86 D0                                xchg    dl,al
273F:24B5  B1 08                                mov     cl,8

273F:24B7                       locloop_513:                                    ;  xref 273F:24AE
273F:24B7  D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:24B9  E2 07                                loop    locloop_514             ; Loop if cx > 0

273F:24BB  86 D0                                xchg    dl,al
273F:24BD  AC                                   lodsb                           ; String [si] to al
273F:24BE  86 D0                                xchg    dl,al
273F:24C0  B1 08                                mov     cl,8

273F:24C2                       locloop_514:                                    ;  xref 273F:24B9
273F:24C2  83 C3 20                             add     bx,20h
273F:24C5 81 FB 0080                           cmp     bx,data_1434e           ; (45F6:0080=0)
273F:24C9  75 B6                                jne     loc_509                 ; Jump if not equal
273F:24CB  33 DB                                xor     bx,bx                   ; Zero register
273F:24CD  83 C7 01                             add     di,1
273F:24D0  83 ED 01                             sub     bp,1
273F:24D3  75 AC                                jnz     loc_509                 ; Jump if not zero
273F:24D5  90                                   nop
273F:24D6  33 FF                                xor     di,di                   ; Zero register
273F:24D8  8A C6                                mov     al,dh
273F:24DA  D0 E8                                shr     al,1                    ; Shift w/zeros fill
273F:24DC  D0 E8                                shr     al,1                    ; Shift w/zeros fill
273F:24DE  D0 E8                                shr     al,1                    ; Shift w/zeros fill
273F:24E0  AA                                   stosb                           ; Store al to es:[di]
273F:24E1  D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:24E3  E2 07                                loop    locloop_515             ; Loop if cx > 0

273F:24E5  86 D0                                xchg    dl,al
273F:24E7  AC                                   lodsb                           ; String [si] to al
273F:24E8  86 D0                                xchg    dl,al
273F:24EA  B1 08                                mov     cl,8

273F:24EC                       locloop_515:                                    ;  xref 273F:24E3
273F:24EC  D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:24EE  E2 07                                loop    locloop_516             ; Loop if cx > 0

273F:24F0  86 D0                                xchg    dl,al
273F:24F2  AC                                   lodsb                           ; String [si] to al
273F:24F3  86 D0                                xchg    dl,al
273F:24F5  B1 08                                mov     cl,8

273F:24F7                       locloop_516:                                    ;  xref 273F:24EE
273F:24F7  D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:24F9  E2 07                                loop    locloop_517             ; Loop if cx > 0

273F:24FB  86 D0                                xchg    dl,al
273F:24FD  AC                                   lodsb                           ; String [si] to al
273F:24FE  86 D0                                xchg    dl,al
273F:2500  B1 08                                mov     cl,8

273F:2502                       locloop_517:                                    ;  xref 273F:24F9
273F:2502  D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:2504  E2 07                                loop    locloop_518             ; Loop if cx > 0

273F:2506  86 D0                                xchg    dl,al
273F:2508  AC                                   lodsb                           ; String [si] to al
273F:2509  86 D0                                xchg    dl,al
273F:250B  B1 08                                mov     cl,8

273F:250D                       locloop_518:                                    ;  xref 273F:2504
273F:250D  D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:250F  E2 07                                loop    locloop_519             ; Loop if cx > 0

273F:2511  86 D0                                xchg    dl,al
273F:2513  AC                                   lodsb                           ; String [si] to al
273F:2514  86 D0                                xchg    dl,al
273F:2516  B1 08                                mov     cl,8

273F:2518                       locloop_519:                                    ;  xref 273F:250F
273F:2518  8A D8                                mov     bl,al
273F:251A  32 FF                                xor     bh,bh                   ; Zero register
273F:251C                       loc_520:                                        ;  xref 273F:252E, 2550, 2558, 256D
                                                                                ;            25C4, 2681
273F:251C D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:251E  E2 07                                loop    locloop_521             ; Loop if cx > 0

273F:2520  86 D0                                xchg    dl,al
273F:2522  AC                                   lodsb                           ; String [si] to al
273F:2523  86 D0                                xchg    dl,al
273F:2525  B1 08                                mov     cl,8

273F:2527                       locloop_521:                                    ;  xref 273F:251E
273F:2527  72 07                                jc      loc_522                 ; Jump if carry Set
273F:2529  8A 1F                                mov     bl,[bx]
273F:252B  8A C3                                mov     al,bl
273F:252D  AA                                   stosb                           ; Store al to es:[di]
273F:252E  EB EC                                jmp     short loc_520           ; (251C)
273F:2530                       loc_522:                                        ;  xref 273F:2527
273F:2530  D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:2532  E2 07                                loop    locloop_523             ; Loop if cx > 0

273F:2534  86 D0                                xchg    dl,al
273F:2536  AC                                   lodsb                           ; String [si] to al
273F:2537  86 D0                                xchg    dl,al
273F:2539  B1 08                                mov     cl,8

273F:253B                       locloop_523:                                    ;  xref 273F:2532
273F:253B  72 1D                                jc      loc_526                 ; Jump if carry Set
273F:253D  D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:253F  E2 07                                loop    locloop_524             ; Loop if cx > 0

273F:2541  86 D0                                xchg    dl,al
273F:2543  AC                                   lodsb                           ; String [si] to al
273F:2544  86 D0                                xchg    dl,al
273F:2546  B1 08                                mov     cl,8

273F:2548                       locloop_524:                                    ;  xref 273F:253F
273F:2548  72 08                                jc      loc_525                 ; Jump if carry Set
273F:254A  8A 5F 20                             mov     bl,[bx+20h]
273F:254D  8A C3                                mov     al,bl
273F:254F  AA                                   stosb                           ; Store al to es:[di]
273F:2550  EB CA                                jmp     short loc_520           ; (251C)
273F:2552                       loc_525:                                        ;  xref 273F:2548
273F:2552  8A 5F 40                             mov     bl,[bx+40h]
273F:2555  8A C3                                mov     al,bl
273F:2557  AA                                   stosb                           ; Store al to es:[di]
273F:2558  EB C2                                jmp     short loc_520           ; (251C)
273F:255A                       loc_526:                                        ;  xref 273F:253B
273F:255A  D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:255C  E2 07                                loop    locloop_527             ; Loop if cx > 0

273F:255E  86 D0                                xchg    dl,al
273F:2560  AC                                   lodsb                           ; String [si] to al
273F:2561  86 D0                                xchg    dl,al
273F:2563  B1 08                                mov     cl,8

273F:2565                       locloop_527:                                    ;  xref 273F:255C
273F:2565  72 08                                jc      loc_528                 ; Jump if carry Set
273F:2567  8A 5F 60                             mov     bl,[bx+60h]
273F:256A  8A C3                                mov     al,bl
273F:256C  AA                                   stosb                           ; Store al to es:[di]
273F:256D  EB AD                                jmp     short loc_520           ; (251C)
273F:256F                       loc_528:                                        ;  xref 273F:2565
273F:256F  8A C6                                mov     al,dh
273F:2571  D0 E8                                shr     al,1                    ; Shift w/zeros fill
273F:2573  D0 E8                                shr     al,1                    ; Shift w/zeros fill
273F:2575  D0 E8                                shr     al,1                    ; Shift w/zeros fill
273F:2577  D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:2579  E2 07                                loop    locloop_529             ; Loop if cx > 0

273F:257B  86 D0                                xchg    dl,al
273F:257D  AC                                   lodsb                           ; String [si] to al
273F:257E  86 D0                                xchg    dl,al
273F:2580  B1 08                                mov     cl,8

273F:2582                       locloop_529:                                    ;  xref 273F:2579
273F:2582  D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:2584  E2 07                                loop    locloop_530             ; Loop if cx > 0

273F:2586  86 D0                                xchg    dl,al
273F:2588  AC                                   lodsb                           ; String [si] to al
273F:2589  86 D0                                xchg    dl,al
273F:258B  B1 08                                mov     cl,8

273F:258D                       locloop_530:                                    ;  xref 273F:2584
273F:258D  D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:258F  E2 07                                loop    locloop_531             ; Loop if cx > 0

273F:2591  86 D0                                xchg    dl,al
273F:2593  AC                                   lodsb                           ; String [si] to al
273F:2594  86 D0                                xchg    dl,al
273F:2596  B1 08                                mov     cl,8

273F:2598                       locloop_531:                                    ;  xref 273F:258F
273F:2598  D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:259A  E2 07                                loop    locloop_532             ; Loop if cx > 0

273F:259C  86 D0                                xchg    dl,al
273F:259E  AC                                   lodsb                           ; String [si] to al
273F:259F  86 D0                                xchg    dl,al
273F:25A1  B1 08                                mov     cl,8

273F:25A3                       locloop_532:                                    ;  xref 273F:259A
273F:25A3  D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:25A5  E2 07                                loop    locloop_533             ; Loop if cx > 0

273F:25A7  86 D0                                xchg    dl,al
273F:25A9  AC                                   lodsb                           ; String [si] to al
273F:25AA  86 D0                                xchg    dl,al
273F:25AC  B1 08                                mov     cl,8

273F:25AE                       locloop_533:                                    ;  xref 273F:25A5
273F:25AE  3A 07                                cmp     al,[bx]
273F:25B0  74 15                                je      loc_534                 ; Jump if equal
273F:25B2  3A 47 20                             cmp     al,[bx+20h]
273F:25B5  74 27                                je      loc_536                 ; Jump if equal
273F:25B7  3A 47 40                             cmp     al,[bx+40h]
273F:25BA  74 2D                                je      loc_537                 ; Jump if equal
273F:25BC  3A 47 60                             cmp     al,[bx+60h]
273F:25BF  74 77                                je      loc_544                 ; Jump if equal
273F:25C1  8A D8                                mov     bl,al
273F:25C3  AA                                   stosb                           ; Store al to es:[di]
273F:25C4  E9 FF55                              jmp     loc_520                 ; (251C)
273F:25C7                       loc_534:                                        ;  xref 273F:25B0
273F:25C7  51                                   push    cx
273F:25C8  E8 4F56                              call    sub_187                 ; (7521)
273F:25CB  8A E0                                mov     ah,al
273F:25CD  E8 4F51                              call    sub_187                 ; (7521)
273F:25D0  8A EC                                mov     ch,ah
273F:25D2  8A C8                                mov     cl,al
273F:25D4  0B C9                                or      cx,cx                   ; Zero ?
273F:25D6  74 03                                jz      loc_535                 ; Jump if zero
273F:25D8  E9 00A1                              jmp     loc_550                 ; (267C)
273F:25DB                       loc_535:                                        ;  xref 273F:25D6
273F:25DB  E9 00A6                              jmp     loc_551                 ; (2684)
273F:25DE                       loc_536:                                        ;  xref 273F:25B5
273F:25DE  51                                   push    cx
273F:25DF  E8 4F3F                              call    sub_187                 ; (7521)
273F:25E2  8A C8                                mov     cl,al
273F:25E4  32 ED                                xor     ch,ch                   ; Zero register
273F:25E6  E9 0093                              jmp     loc_550                 ; (267C)
273F:25E9                       loc_537:                                        ;  xref 273F:25BA
273F:25E9  8A C6                                mov     al,dh
273F:25EB  D0 E8                                shr     al,1                    ; Shift w/zeros fill
273F:25ED  D0 E8                                shr     al,1                    ; Shift w/zeros fill
273F:25EF  D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:25F1  E2 07                                loop    locloop_538             ; Loop if cx > 0

273F:25F3  86 D0                                xchg    dl,al
273F:25F5  AC                                   lodsb                           ; String [si] to al
273F:25F6  86 D0                                xchg    dl,al
273F:25F8  B1 08                                mov     cl,8

273F:25FA                       locloop_538:                                    ;  xref 273F:25F1
273F:25FA  D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:25FC  E2 07                                loop    locloop_539             ; Loop if cx > 0

273F:25FE  86 D0                                xchg    dl,al
273F:2600  AC                                   lodsb                           ; String [si] to al
273F:2601  86 D0                                xchg    dl,al
273F:2603  B1 08                                mov     cl,8

273F:2605                       locloop_539:                                    ;  xref 273F:25FC
273F:2605  D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:2607  E2 07                                loop    locloop_540             ; Loop if cx > 0

273F:2609  86 D0                                xchg    dl,al
273F:260B  AC                                   lodsb                           ; String [si] to al
273F:260C  86 D0                                xchg    dl,al
273F:260E  B1 08                                mov     cl,8

273F:2610                       locloop_540:                                    ;  xref 273F:2607
273F:2610  D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:2612  E2 07                                loop    locloop_541             ; Loop if cx > 0

273F:2614  86 D0                                xchg    dl,al
273F:2616  AC                                   lodsb                           ; String [si] to al
273F:2617  86 D0                                xchg    dl,al
273F:2619  B1 08                                mov     cl,8

273F:261B                       locloop_541:                                    ;  xref 273F:2612
273F:261B  D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:261D  E2 07                                loop    locloop_542             ; Loop if cx > 0

273F:261F  86 D0                                xchg    dl,al
273F:2621  AC                                   lodsb                           ; String [si] to al
273F:2622  86 D0                                xchg    dl,al
273F:2624  B1 08                                mov     cl,8

273F:2626                       locloop_542:                                    ;  xref 273F:261D
273F:2626  D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:2628  E2 07                                loop    locloop_543             ; Loop if cx > 0

273F:262A  86 D0                                xchg    dl,al
273F:262C  AC                                   lodsb                           ; String [si] to al
273F:262D  86 D0                                xchg    dl,al
273F:262F  B1 08                                mov     cl,8

273F:2631                       locloop_543:                                    ;  xref 273F:2628
273F:2631  51                                   push    cx
273F:2632  8A C8                                mov     cl,al
273F:2634  32 ED                                xor     ch,ch                   ; Zero register
273F:2636  EB 44                                jmp     short loc_550           ; (267C)
273F:2638                       loc_544:                                        ;  xref 273F:25BF
273F:2638  8A C6                                mov     al,dh
273F:263A  D0 E8                                shr     al,1                    ; Shift w/zeros fill
273F:263C  D0 E8                                shr     al,1                    ; Shift w/zeros fill
273F:263E  D0 E8                                shr     al,1                    ; Shift w/zeros fill
273F:2640  D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:2642  E2 07                                loop    locloop_545             ; Loop if cx > 0

273F:2644  86 D0                                xchg    dl,al
273F:2646  AC                                   lodsb                           ; String [si] to al
273F:2647  86 D0                                xchg    dl,al
273F:2649  B1 08                                mov     cl,8

273F:264B                       locloop_545:                                    ;  xref 273F:2642
273F:264B  D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:264D  E2 07                                loop    locloop_546             ; Loop if cx > 0

273F:264F  86 D0                                xchg    dl,al
273F:2651  AC                                   lodsb                           ; String [si] to al
273F:2652  86 D0                                xchg    dl,al
273F:2654  B1 08                                mov     cl,8

273F:2656                       locloop_546:                                    ;  xref 273F:264D
273F:2656  D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:2658  E2 07                                loop    locloop_547             ; Loop if cx > 0

273F:265A  86 D0                                xchg    dl,al
273F:265C  AC                                   lodsb                           ; String [si] to al
273F:265D  86 D0                                xchg    dl,al
273F:265F  B1 08                                mov     cl,8

273F:2661                       locloop_547:                                    ;  xref 273F:2658
273F:2661  D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:2663  E2 07                                loop    locloop_548             ; Loop if cx > 0

273F:2665  86 D0                                xchg    dl,al
273F:2667  AC                                   lodsb                           ; String [si] to al
273F:2668  86 D0                                xchg    dl,al
273F:266A  B1 08                                mov     cl,8

273F:266C                       locloop_548:                                    ;  xref 273F:2663
273F:266C  D1 D2                                rcl     dx,1                    ; Rotate thru carry
273F:266E  E2 07                                loop    locloop_549             ; Loop if cx > 0

273F:2670  86 D0                                xchg    dl,al
273F:2672  AC                                   lodsb                           ; String [si] to al
273F:2673  86 D0                                xchg    dl,al
273F:2675  B1 08                                mov     cl,8

273F:2677                       locloop_549:                                    ;  xref 273F:266E
273F:2677  51                                   push    cx
273F:2678  8A C8                                mov     cl,al
273F:267A  32 ED                                xor     ch,ch                   ; Zero register
273F:267C                       loc_550:                                        ;  xref 273F:25D8, 25E6, 2636
273F:267C  8A C3                                mov     al,bl
273F:267E  F3/ AA                               rep     stosb                   ; Rep when cx >0 Store al to es:[di]
273F:2680  59                                   pop     cx
273F:2681  E9 FE98                              jmp     loc_520                 ; (251C)
273F:2684                       loc_551:                                        ;  xref 273F:25DB
273F:2684  58                                   pop     ax
273F:2685  1F                                   pop     ds
273F:2686  EB 00                                jmp     short $+2               ; delay for I/O
273F:2688  57                                   push    di
273F:2689  8B EF                                mov     bp,di
273F:268B  1E                                   push    ds
273F:268C  06                                   push    es
273F:268D  1F                                   pop     ds
273F:268E  8B F7                                mov     si,di
273F:2690  83 EE 02                             sub     si,2
273F:2693  83 C7 06                             add     di,6
273F:2696  8B CD                                mov     cx,bp
273F:2698  FD                                   std                             ; Set direction flag
273F:2699  D1 E9                                shr     cx,1                    ; Shift w/zeros fill
273F:269B  F3/ A5                               rep     movsw                   ; Rep when cx >0 Mov [si] to es:[di]
273F:269D  FC                                   cld                             ; Clear direction
273F:269E  33 FF                                xor     di,di                   ; Zero register
273F:26A0 BE 0008                              mov     si,data_1459e           ; (FF12:0008=0)
273F:26A3                       loc_552:                                        ;  xref 273F:26C2
273F:26A3  B9 0008                              mov     cx,8

273F:26A6                       locloop_553:                                    ;  xref 273F:26BA
273F:26A6  AC                                   lodsb                           ; String [si] to al
273F:26A7  D0 D8                                rcr     al,1                    ; Rotate thru carry
273F:26A9  D0 55 03                             rcl     byte ptr [di+3],1       ; Rotate thru carry
273F:26AC  D0 D8                                rcr     al,1                    ; Rotate thru carry
273F:26AE  D0 55 02                             rcl     byte ptr [di+2],1       ; Rotate thru carry
273F:26B1  D0 D8                                rcr     al,1                    ; Rotate thru carry
273F:26B3  D0 55 01                             rcl     byte ptr [di+1],1       ; Rotate thru carry
273F:26B6  D0 D8                                rcr     al,1                    ; Rotate thru carry
273F:26B8  D0 15                                rcl     byte ptr [di],1         ; Rotate thru carry
273F:26BA  E2 EA                                loop    locloop_553             ; Loop if cx > 0

273F:26BC  83 C7 04                             add     di,4
273F:26BF  83 ED 08                             sub     bp,8
273F:26C2  77 DF                                ja      loc_552                 ; Jump if above
273F:26C4  1F                                   pop     ds
273F:26C5  59                                   pop     cx
273F:26C6  C3                                   retn
                           ega_decode_entry     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

273F:26C7  1E                                   push    ds
273F:26C8  06                                   push    es
273F:26C9  1F                                   pop     ds
273F:26CA BE 0040                              mov     si,40h                  ; (273F:0040=0)
273F:26CD  57                                   push    di
273F:26CE  2B FE                                sub     di,si
273F:26D0  8B EF                                mov     bp,di
273F:26D2  32 D2                                xor     dl,dl                   ; Zero register
273F:26D4                       loc_554:                                        ;  xref 273F:2708
273F:26D4  8A 04                                mov     al,[si]
273F:26D6  8A 64 01                             mov     ah,[si+1]
273F:26D9  8A 5C 02                             mov     bl,[si+2]
273F:26DC  8A 7C 03                             mov     bh,[si+3]
273F:26DF  B9 0004                              mov     cx,4

273F:26E2                       locloop_555:                                    ;  xref 273F:26F8, 2700
273F:26E2  D0 D0                                rcl     al,1                    ; Rotate thru carry
273F:26E4  D0 14                                rcl     byte ptr [si],1         ; Rotate thru carry
273F:26E6  D0 D0                                rcl     al,1                    ; Rotate thru carry
273F:26E8  D0 54 01                             rcl     byte ptr [si+1],1       ; Rotate thru carry
273F:26EB  D0 D0                                rcl     al,1                    ; Rotate thru carry
273F:26ED  D0 54 02                             rcl     byte ptr [si+2],1       ; Rotate thru carry
273F:26F0  D0 D0                                rcl     al,1                    ; Rotate thru carry
273F:26F2  D0 54 03                             rcl     byte ptr [si+3],1       ; Rotate thru carry
273F:26F5  80 F2 01                             xor     dl,1
273F:26F8  75 E8                                jnz     locloop_555             ; Jump if not zero
273F:26FA  8A C4                                mov     al,ah
273F:26FC  8A E3                                mov     ah,bl
273F:26FE  8A DF                                mov     bl,bh
273F:2700  E2 E0                                loop    locloop_555             ; Loop if cx > 0

273F:2702  83 C6 04                             add     si,4
273F:2705  83 ED 04                             sub     bp,4
273F:2708  77 CA                                ja      loc_554                 ; Jump if above
273F:270A  5F                                   pop     di
273F:270B  1F                                   pop     ds
273F:270C  C3                                   retn

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                          ega_segment_screen    proc    near
273F:270D  C6 06 0DA4 00                        mov     datavar1, 0
273F:2712  88 0E 0DA5                           mov     current_layer, cl
273F:2716  C7 06 0DA2 0200                      mov     rectangle_size, 200h
273F:271C  0A C9                                or      cl,cl                   ; Zero ?
273F:271E  74 06                                jz      loc_556                 ; Jump if zero
273F:2720  81 06 0DA2 0080                      add     rectangle_size, 80h
273F:2726                       loc_556:                                        ;  xref 273F:271E
273F:2726  33 F6                                xor     si,si                   ; Zero register
273F:2728  B5 06                                mov     ch,6
273F:272A                       loc_557:                                        ;  xref 273F:2771
273F:272A  B1 0A                                mov     cl,0Ah
273F:272C                       loc_558:                                        ;  xref 273F:2765
273F:272C  1E                                   push    ds
273F:272D  53                                   push    bx
273F:272E  51                                   push    cx
273F:272F  56                                   push    si
273F:2730  57                                   push    di
273F:2731  A1 4CE4                              mov     ax, data_segment2
273F:2734  8E D8                                mov     ds,ax
273F:2736  E8 003B                              call    sub_65                  ; (2774)
273F:2739  5F                                   pop     di
273F:273A  5E                                   pop     si
273F:273B  59                                   pop     cx
273F:273C  5B                                   pop     bx
273F:273D  1F                                   pop     ds
273F:273E  F6 06 0DA5 FF                        test    byte ptr ds:[0DA5h],0FFh ; (273F:0DA5=31h)
273F:2743  74 09                                jz      loc_559                 ; Jump if zero
273F:2745  0A F6                                or      dh,dh                   ; Zero ?
273F:2747  75 05                                jnz     loc_559                 ; Jump if not zero
273F:2749  C6 07 FF                             mov     byte ptr [bx],0FFh
273F:274C  EB 0E                                jmp     short loc_560           ; (275C)
273F:274E                       loc_559:                                        ;  xref 273F:2743, 2747
273F:274E  03 3E 0DA2                           add     di, [rectangle_size]
273F:2752  A0 0DA4                              mov     al, datavar1
273F:2755  88 07                                mov     [bx], al
273F:2757  80 06 0DA4 01                        add     datavar1, 1
273F:275C                       loc_560:                                        ;  xref 273F:274C
273F:275C  83 C6 10                             add     si,10h
273F:275F  83 C3 01                             add     bx,1
273F:2762  80 E9 01                             sub     cl,1
273F:2765  75 C5                                jnz     loc_558                 ; Jump if not zero
273F:2767 81 C6 1360                           add     si,data_1464e           ; (FF12:1360=1Eh)
273F:276B  83 C3 08                             add     bx,8
273F:276E  80 ED 01                             sub     ch,1
273F:2771  75 B7                                jnz     loc_557                 ; Jump if not zero
273F:2773  C3                                   retn
                          ega_segment_screen    endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:2736
                                ;

273F:2774                       sub_65          proc    near
273F:2774  8B DF                                mov     bx,di
273F:2776 81 C3 0200                           add     bx,200h                 ; (273F:0200=0F6h)
273F:277A  32 F6                                xor     dh,dh                   ; Zero register
273F:277C  B5 20                                mov     ch,20h                  ; ' '
273F:277E                       loc_561:                                        ;  xref 273F:27AE
273F:277E  B1 04                                mov     cl,4
273F:2780                       loc_562:                                        ;  xref 273F:27A5
273F:2780  32 D2                                xor     dl,dl                   ; Zero register
273F:2782  AC                                   lodsb                           ; String [si] to al
273F:2783  0A D0                                or      dl,al
273F:2785  0A F0                                or      dh,al
273F:2787  AA                                   stosb                           ; Store al to es:[di]
273F:2788  AC                                   lodsb                           ; String [si] to al
273F:2789  0A D0                                or      dl,al
273F:278B  0A F0                                or      dh,al
273F:278D  AA                                   stosb                           ; Store al to es:[di]
273F:278E  AC                                   lodsb                           ; String [si] to al
           nlure.lst                           Sourcer v6.09   17-Nov- 5   5:53 pm   Page 102

273F:278F  0A D0                                or      dl,al
273F:2791  0A F0                                or      dh,al
273F:2793  AA                                   stosb                           ; Store al to es:[di]
273F:2794  AC                                   lodsb                           ; String [si] to al
273F:2795  0A D0                                or      dl,al
273F:2797  0A F0                                or      dh,al
273F:2799  AA                                   stosb                           ; Store al to es:[di]
273F:279A  F6 D2                                not     dl
273F:279C  26: 88 17                            mov     es:[bx],dl
273F:279F  83 C3 01                             add     bx,1
273F:27A2  80 E9 01                             sub     cl,1
273F:27A5  75 D9                                jnz     loc_562                 ; Jump if not zero
273F:27A7  81 C6 0090                           add     si,90h
273F:27AB  80 ED 01                             sub     ch,1
273F:27AE  75 CE                                jnz     loc_561                 ; Jump if not zero
273F:27B0  C3                                   retn
                                sub_65          endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                 ega_show_compressed_screen     proc    near

273F:27B1 BB 07DC                              mov     bx, offset display_mask
273F:27B4  A1 4CE4                              mov     ax, data_segment2
273F:27B7  8E C0                                mov     es,ax
273F:27B9 BF 0500                              mov     di,data_1462e           ; (FF12:0500=0)
273F:27BC  8B 16 4CE0                           mov     dx, current_room_segment
273F:27C0  33 F6                                xor     si,si                   ; Zero register
273F:27C2  B5 06                                mov     ch,6
273F:27C4                       loc_563:                                        ;  xref 273F:280C
273F:27C4  B1 0A                                mov     cl,0Ah
273F:27C6                       loc_564:                                        ;  xref 273F:2800
273F:27C6  F6 07 80                             test    byte ptr [bx],80h
273F:27C9  74 28                                jz      loc_567                 ; Jump if zero
273F:27CB  80 27 7F                             and     byte ptr [bx],7Fh
273F:27CE  80 0F 01                             or      byte ptr [bx],1
273F:27D1  80 8F 0100 01                        or      byte ptr ds:[100h][bx],1 ; (273F:0100=6)
273F:27D6  57                                   push    di
273F:27D7  1E                                   push    ds
273F:27D8  56                                   push    si
273F:27D9  8E DA                                mov     ds,dx
273F:27DB  B6 20                                mov     dh,20h                  ; ' '
273F:27DD                       loc_565:                                        ;  xref 273F:27EC
273F:27DD  B2 08                                mov     dl,8
273F:27DF                       loc_566:                                        ;  xref 273F:27E3
273F:27DF  A5                                   movsw                           ; Mov [si] to es:[di]
273F:27E0  80 EA 01                             sub     dl,1
273F:27E3  75 FA                                jnz     loc_566                 ; Jump if not zero
273F:27E5  81 C7 0090                           add     di,90h
273F:27E9  80 EE 01                             sub     dh,1
273F:27EC  75 EF                                jnz     loc_565                 ; Jump if not zero
273F:27EE  5E                                   pop     si
273F:27EF  8C DA                                mov     dx,ds
273F:27F1  1F                                   pop     ds
273F:27F2  5F                                   pop     di
273F:27F3                       loc_567:                                        ;  xref 273F:27C9
273F:27F3  83 C3 01                             add     bx,1
273F:27F6  83 C7 10                             add     di,10h
273F:27F9  81 C6 0200                           add     si,200h
273F:27FD  80 E9 01                             sub     cl,1
273F:2800  75 C4                                jnz     loc_564                 ; Jump if not zero
273F:2802  83 C3 08                             add     bx,8
273F:2805 81 C7 1360                           add     di,1360h                ; (273F:1360=0)
273F:2809  80 ED 01                             sub     ch,1
273F:280C  75 B6                                jnz     loc_563                 ; Jump if not zero
273F:280E  80 0E 11D0 30                        or      menubar_state, 30h ; (273F:11D0=56h) '0'
273F:2813  C3                                   retn

                 ega_show_compressed_screen     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                                                                                ;* No entry point to code
273F:2814 BE 0992                              mov     si, offset rects_layer_0
273F:2817  83 C6 4C                             add     si,4Ch
273F:281A  C7 06 0DA6 0D92                      mov     rect_x_start, offset room_layers
273F:2820  C7 06 0DAA 0D96                      mov     num_horiz_rects, 0D96h
273F:2826  B9 0003                              mov     cx,3
273F:2829                       loc_568:                                        ;  xref 273F:28E9
273F:2829 51                                   push    cx
273F:282A BB 0100                              mov     bx,100h                 ; (273F:0100=6)
273F:282D                       loc_569:                                        ;  xref 273F:28CF
273F:282D 51                                   push    cx
273F:282E  56                                   push    si
273F:282F  8B 3E 0DA6                           mov     di, rect_x_start
273F:2833  8B 05                                mov     ax,[di]
273F:2835  8E C0                                mov     es,ax
273F:2837  8B 45 02                             mov     ax,[di+2]
273F:283A  A3 0DA8                              mov     rect_y_end, ax
273F:283D  8B 3E 0DAA                           mov     di, num_horiz_rects
273F:2841  8B 05                                mov     ax,[di]
273F:2843  8B D0                                mov     dx,ax
273F:2845  8B 45 02                             mov     ax,[di+2]
273F:2848  A3 0DAC                              mov     word ptr ds:[0DACh],ax  ; (273F:0DAC=0EB09h)
273F:284B  B5 06                                mov     ch,6
273F:284D                       loc_570:                                        ;  xref 273F:28BE
273F:284D  B1 0A                                mov     cl,0Ah
273F:284F                       loc_571:                                        ;  xref 273F:28B6
273F:284F  F6 04 80                             test    byte ptr [si],80h
273F:2852  75 5C                                jnz     loc_573                 ; Jump if not zero
273F:2854  F6 00 80                             test    byte ptr [bx+si],80h
273F:2857  75 57                                jnz     loc_573                 ; Jump if not zero
273F:2859  56                                   push    si
273F:285A  52                                   push    dx
273F:285B  8A 04                                mov     al,[si]
273F:285D  32 E4                                xor     ah,ah                   ; Zero register
273F:285F  F7 26 0DA8                           mul     rect_y_end
273F:2863  8B F8                                mov     di,ax
273F:2865  8A 00                                mov     al,[bx+si]
273F:2867  32 E4                                xor     ah,ah                   ; Zero register
273F:2869  F7 26 0DAC                           mul     word ptr ds:[0DACh]     ; (273F:0DAC=0EB09h) dx:ax = data * ax
273F:286D  8B F0                                mov     si,ax
273F:286F  5A                                   pop     dx
273F:2870  1E                                   push    ds
273F:2871  51                                   push    cx
273F:2872  53                                   push    bx
273F:2873  8E DA                                mov     ds,dx
273F:2875  B9 0080                              mov     cx,80h
273F:2878  8B DE                                mov     bx,si
273F:287A 81 C3 0200                           add     bx,data_11e             ; (0000:0200=0)

273F:287E                       locloop_572:                                    ;  xref 273F:28A8
273F:287E  8A 17                                mov     dl,[bx]
273F:2880  AC                                   lodsb                           ; String [si] to al
273F:2881  26: 20 15                            and     es:[di],dl
273F:2884  26: 08 05                            or      es:[di],al
273F:2887  AC                                   lodsb                           ; String [si] to al
273F:2888  26: 20 55 01                         and     es:[di+1],dl
273F:288C  26: 08 45 01                         or      es:[di+1],al
273F:2890  AC                                   lodsb                           ; String [si] to al
273F:2891  26: 20 55 02                         and     es:[di+2],dl
273F:2895  26: 08 45 02                         or      es:[di+2],al
273F:2899  AC                                   lodsb                           ; String [si] to al
273F:289A  26: 20 55 03                         and     es:[di+3],dl
273F:289E  26: 08 45 03                         or      es:[di+3],al
273F:28A2  83 C7 04                             add     di,4
273F:28A5  83 C3 01                             add     bx,1
273F:28A8  E2 D4                                loop    locloop_572             ; Loop if cx > 0

273F:28AA  5B                                   pop     bx
273F:28AB  59                                   pop     cx
273F:28AC  8C DA                                mov     dx,ds
273F:28AE  1F                                   pop     ds
273F:28AF  5E                                   pop     si
273F:28B0                       loc_573:                                        ;  xref 273F:2852, 2857
273F:28B0  83 C6 01                             add     si,1
273F:28B3  80 E9 01                             sub     cl,1
273F:28B6  75 97                                jnz     loc_571                 ; Jump if not zero
273F:28B8  83 C6 08                             add     si,8
273F:28BB  80 ED 01                             sub     ch,1
273F:28BE  75 8D                                jnz     loc_570                 ; Jump if not zero
273F:28C0  83 06 0DAA 04                        add     num_horiz_rects, 4
273F:28C5  81 C3 0100                           add     bx,100h
273F:28C9  5E                                   pop     si
273F:28CA  59                                   pop     cx
273F:28CB  E2 02                                loop    locloop_574             ; Loop if cx > 0

273F:28CD  EB 03                                jmp     short loc_575           ; (28D2)

273F:28CF                       locloop_574:                                    ;  xref 273F:28CB
273F:28CF  E9 FF5B                              jmp     loc_569                 ; (282D)
273F:28D2                       loc_575:                                        ;  xref 273F:28CD
273F:28D2  59                                   pop     cx
273F:28D3  E2 02                                loop    locloop_576             ; Loop if cx > 0

273F:28D5  EB 15                                jmp     short loc_577           ; (28EC)

273F:28D7                       locloop_576:                                    ;  xref 273F:28D3
273F:28D7  81 C6 0100                           add     si,100h
273F:28DB  83 06 0DA6 04                        add     rect_x_start, 4
273F:28E0  A1 0DA6                              mov     ax, rect_x_start
273F:28E3  05 0004                              add     ax,4
273F:28E6  A3 0DAA                              mov     num_horiz_rects, ax
273F:28E9  E9 FF3D                              jmp     loc_568                 ; (2829)
273F:28EC                       loc_577:                                        ;  xref 273F:28D5
273F:28EC BE 0A92                              mov     si, offset rects_layer_1
273F:28EF  83 C6 4C                             add     si, FULL_HORIZ_RECTS * 4 + 4 ; 4Ch
273F:28F2  C7 06 0DA6 0D96                      mov     rect_x_start, 0D96h 
273F:28F8  C7 06 0DAA 0D9A                      mov     num_horiz_rects, 0D9Ah
273F:28FE  B9 0002                              mov     cx,2
273F:2901                       loc_578:                                        ;  xref 273F:29A0
273F:2901 51                                   push    cx
273F:2902 BB 0100                              mov     bx,100h                 ; (273F:0100=6)
273F:2905                       loc_579:                                        ;  xref 273F:2986
273F:2905 51                                   push    cx
273F:2906  56                                   push    si
273F:2907  8B 3E 0DA6                           mov     di, rect_x_start
273F:290B  8B 05                                mov     ax,[di]
273F:290D  8E C0                                mov     es,ax
273F:290F  8B 45 02                             mov     ax,[di+2]
273F:2912  A3 0DA8                              mov     rect_y_end, ax
273F:2915  8B 3E 0DAA                           mov     di, num_horiz_rects
273F:2919  8B 05                                mov     ax,[di]
273F:291B  8B D0                                mov     dx,ax
273F:291D  8B 45 02                             mov     ax,[di+2]
273F:2920  A3 0DAC                              mov     word ptr ds:[0DACh],ax  ; (273F:0DAC=0EB09h)
273F:2923  B5 06                                mov     ch,6
273F:2925                       loc_580:                                        ;  xref 273F:2975
273F:2925  B1 0A                                mov     cl,0Ah
273F:2927                       loc_581:                                        ;  xref 273F:296D
273F:2927  F6 04 80                             test    byte ptr [si],80h
273F:292A  75 3B                                jnz     loc_583                 ; Jump if not zero
273F:292C  F6 00 80                             test    byte ptr [bx+si],80h
273F:292F  75 36                                jnz     loc_583                 ; Jump if not zero
273F:2931  56                                   push    si
273F:2932  52                                   push    dx
273F:2933  8A 04                                mov     al,[si]
273F:2935  32 E4                                xor     ah,ah                   ; Zero register
273F:2937  F7 26 0DA8                           mul     rect_y_end
273F:293B  8B F8                                mov     di,ax
273F:293D  8A 00                                mov     al,[bx+si]
273F:293F  32 E4                                xor     ah,ah                   ; Zero register
273F:2941  F7 26 0DAC                           mul     word ptr ds:[0DACh]     ; (273F:0DAC=0EB09h) dx:ax = data * ax
273F:2945  8B F0                                mov     si,ax
273F:2947  5A                                   pop     dx
273F:2948  1E                                   push    ds
273F:2949  51                                   push    cx
273F:294A  53                                   push    bx
273F:294B  8E DA                                mov     ds,dx
273F:294D  B9 0080                              mov     cx,80h
273F:2950 81 C6 0200                           add     si,data_11e             ; (0000:0200=0)
273F:2954 81 C7 0200                           add     di,data_1436e           ; (4789:0200=27h)

273F:2958                       locloop_582:                                    ;  xref 273F:295F
273F:2958  AC                                   lodsb                           ; String [si] to al
273F:2959  26: 20 05                            and     es:[di],al
273F:295C  83 C7 01                             add     di,1
273F:295F  E2 F7                                loop    locloop_582             ; Loop if cx > 0

273F:2961  5B                                   pop     bx
273F:2962  59                                   pop     cx
273F:2963  8C DA                                mov     dx,ds
273F:2965  1F                                   pop     ds
273F:2966  5E                                   pop     si
273F:2967                       loc_583:                                        ;  xref 273F:292A, 292F
273F:2967  83 C6 01                             add     si,1
273F:296A  80 E9 01                             sub     cl,1
273F:296D  75 B8                                jnz     loc_581                 ; Jump if not zero
273F:296F  83 C6 08                             add     si,8
273F:2972  80 ED 01                             sub     ch,1
273F:2975  75 AE                                jnz     loc_580                 ; Jump if not zero
273F:2977  83 06 0DAA 04                        add     num_horiz_rects, 4
273F:297C 81 C3 0100                           add     bx,100h                 ; (273F:0100=6)
273F:2980  5E                                   pop     si
273F:2981  59                                   pop     cx
273F:2982  E2 02                                loop    locloop_584             ; Loop if cx > 0

273F:2984  EB 03                                jmp     short loc_585           ; (2989)

273F:2986                       locloop_584:                                    ;  xref 273F:2982
273F:2986  E9 FF7C                              jmp     loc_579                 ; (2905)
273F:2989                       loc_585:                                        ;  xref 273F:2984
273F:2989  59                                   pop     cx
273F:298A  E2 02                                loop    locloop_586             ; Loop if cx > 0

273F:298C  EB 15                                jmp     short loc_ret_587       ; (29A3)

273F:298E                       locloop_586:                                    ;  xref 273F:298A
273F:298E 81 C6 0100                           add     si,100h                 ; (273F:0100=6)
273F:2992  83 06 0DA6 04                        add     rect_x_start, 4
273F:2997  A1 0DA6                              mov     ax, rect_x_start
273F:299A  05 0004                              add     ax,4
273F:299D  A3 0DAA                              mov     num_horiz_rects, ax
273F:29A0  E9 FF5E                              jmp     loc_578                 ; (2901)

273F:29A3                       loc_ret_587:                                    ;  xref 273F:298C
273F:29A3  C3                                   retn

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                              ega_add_layer     proc     near
273F:29A4  8B CD                                mov      cx, bp
273F:29A6                       locloop_588:
273F:29A6  80 39 FE                             cmp     byte ptr [bx+di],0FEh
273F:29A9  72 0A                                jb      loc_589                 ; Jump if below
273F:29AB 81 C7 0100                           add     di,100h                 ; (273F:0100=6)
273F:29AF  83 C6 04                             add     si,4
273F:29B2  E2 F2                                loop    locloop_588             ; Loop if cx > 0

273F:29B4  C3                                   retn
273F:29B5                       loc_589:                                        ;  xref 273F:29A9
273F:29B5  1E                                   push    ds
273F:29B6  52                                   push    dx
273F:29B7  8B D0                                mov     dx,ax
273F:29B9  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:29BB  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:29BD  03 D0                                add     dx,ax
273F:29BF  B1 0A                                mov     cl,0Ah
273F:29C1  D3 E2                                shl     dx,cl                   ; Shift w/zeros fill
273F:29C3  81 C2 0500                           add     dx,500h
273F:29C7  58                                   pop     ax
273F:29C8  B1 04                                mov     cl,4
273F:29CA  D3 E0                                shl     ax,cl                   ; Shift w/zeros fill
273F:29CC  03 D0                                add     dx,ax
273F:29CE  8A 01                                mov     al,[bx+di]
273F:29D0  8B 1E 4CE4                           mov     bx, data_segment2
273F:29D4  8E C3                                mov     es,bx
273F:29D6  8B 1C                                mov     bx,[si]
273F:29D8  8E DB                                mov     ds,bx
273F:29DA  8B FA                                mov     di,dx
273F:29DC  32 E4                                xor     ah,ah                   ; Zero register
273F:29DE  8B D0                                mov     dx,ax
273F:29E0  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:29E2  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:29E4  03 C2                                add     ax,dx
273F:29E6  B1 07                                mov     cl,7
273F:29E8  D3 E0                                shl     ax,cl                   ; Shift w/zeros fill
273F:29EA  8B F0                                mov     si,ax
273F:29EC  8B DE                                mov     bx,si
273F:29EE 81 C3 0200                           add     bx,data_1455e           ; (E4B8:0200=0)
273F:29F2  B9 0020                              mov     cx,20h

273F:29F5                       locloop_590:                                    ;  xref 273F:2A2D
273F:29F5  51                                   push    cx
273F:29F6  B9 0004                              mov     cx,4

273F:29F9                       locloop_591:                                    ;  xref 273F:2A26
273F:29F9  8A 17                                mov     dl,[bx]
273F:29FB  AC                                   lodsb                           ; String [si] to al
273F:29FC  26: 20 15                            and     es:[di],dl
273F:29FF  26: 08 05                            or      es:[di],al
273F:2A02  83 C7 01                             add     di,1
273F:2A05  AC                                   lodsb                           ; String [si] to al
273F:2A06  26: 20 15                            and     es:[di],dl
273F:2A09  26: 08 05                            or      es:[di],al
273F:2A0C  83 C7 01                             add     di,1
273F:2A0F  AC                                   lodsb                           ; String [si] to al
273F:2A10  26: 20 15                            and     es:[di],dl
273F:2A13  26: 08 05                            or      es:[di],al
273F:2A16  83 C7 01                             add     di,1
273F:2A19  AC                                   lodsb                           ; String [si] to al
273F:2A1A  26: 20 15                            and     es:[di],dl
273F:2A1D  26: 08 05                            or      es:[di],al
273F:2A20  83 C7 01                             add     di,1
273F:2A23  83 C3 01                             add     bx,1
273F:2A26  E2 D1                                loop    locloop_591             ; Loop if cx > 0

273F:2A28 81 C7 0090                           add     di,90h                  ; (273F:0090=15h)
273F:2A2C  59                                   pop     cx
273F:2A2D  E2 C6                                loop    locloop_590             ; Loop if cx > 0

273F:2A2F  1F                                   pop     ds
273F:2A30  C3                                   retn
                              ega_add_layer     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                      ega_display_character     proc    near

273F:2A31  57                                   push    di
273F:2A32  1E                                   push    ds
273F:2A33  51                                   push    cx
273F:2A34  56                                   push    si
273F:2A35  8E DD                                mov     ds,bp
273F:2A37  8A F2                                mov     dh,dl
273F:2A39  2C 20                                sub     al,20h                  ; ' '
273F:2A3B  B1 03                                mov     cl,3
273F:2A3D  32 E4                                xor     ah,ah                   ; Zero register
273F:2A3F  D3 E0                                shl     ax,cl                   ; Shift w/zeros fill
273F:2A41  8B F0                                mov     si,ax
273F:2A43  B9 0008                              mov     cx,8

273F:2A46                       locloop_592:                                    ;  xref 273F:2AA2
273F:2A46  AC                                   lodsb                           ; String [si] to al
273F:2A47  8A E0                                mov     ah,al
273F:2A49  F6 D4                                not     ah
273F:2A4B  26: C6 05 00                         mov     byte ptr es:[di],0
273F:2A4F  D0 E2                                shl     dl,1                    ; Shift w/zeros fill
273F:2A51  73 03                                jnc     loc_593                 ; Jump if carry=0
273F:2A53  26: 88 05                            mov     es:[di],al
273F:2A56                       loc_593:                                        ;  xref 273F:2A51
273F:2A56  D0 E2                                shl     dl,1                    ; Shift w/zeros fill
273F:2A58  73 03                                jnc     loc_594                 ; Jump if carry=0
273F:2A5A  26: 08 25                            or      es:[di],ah
273F:2A5D                       loc_594:                                        ;  xref 273F:2A58
273F:2A5D  83 C7 01                             add     di,1
273F:2A60  26: C6 05 00                         mov     byte ptr es:[di],0
273F:2A64  D0 E2                                shl     dl,1                    ; Shift w/zeros fill
273F:2A66  73 03                                jnc     loc_595                 ; Jump if carry=0
273F:2A68  26: 88 05                            mov     es:[di],al
273F:2A6B                       loc_595:                                        ;  xref 273F:2A66
273F:2A6B  D0 E2                                shl     dl,1                    ; Shift w/zeros fill
273F:2A6D  73 03                                jnc     loc_596                 ; Jump if carry=0
273F:2A6F  26: 08 25                            or      es:[di],ah
273F:2A72                       loc_596:                                        ;  xref 273F:2A6D
273F:2A72  83 C7 01                             add     di,1
273F:2A75  26: C6 05 00                         mov     byte ptr es:[di],0
273F:2A79  D0 E2                                shl     dl,1                    ; Shift w/zeros fill
273F:2A7B  73 03                                jnc     loc_597                 ; Jump if carry=0
273F:2A7D  26: 88 05                            mov     es:[di],al
273F:2A80                       loc_597:                                        ;  xref 273F:2A7B
273F:2A80  D0 E2                                shl     dl,1                    ; Shift w/zeros fill
273F:2A82  73 03                                jnc     loc_598                 ; Jump if carry=0
273F:2A84  26: 08 25                            or      es:[di],ah
273F:2A87                       loc_598:                                        ;  xref 273F:2A82
273F:2A87  83 C7 01                             add     di,1
273F:2A8A  26: C6 05 00                         mov     byte ptr es:[di],0
273F:2A8E  D0 E2                                shl     dl,1                    ; Shift w/zeros fill
273F:2A90  73 03                                jnc     loc_599                 ; Jump if carry=0
273F:2A92  26: 88 05                            mov     es:[di],al
273F:2A95                       loc_599:                                        ;  xref 273F:2A90
273F:2A95  D0 E2                                shl     dl,1                    ; Shift w/zeros fill
273F:2A97  73 03                                jnc     loc_600                 ; Jump if carry=0
273F:2A99  26: 08 25                            or      es:[di],ah
273F:2A9C                       loc_600:                                        ;  xref 273F:2A97
273F:2A9C  81 C7 009D                           add     di,9Dh
273F:2AA0  8A D6                                mov     dl,dh
273F:2AA2  E2 A2                                loop    locloop_592             ; Loop if cx > 0

273F:2AA4  5E                                   pop     si
273F:2AA5  59                                   pop     cx
273F:2AA6  1F                                   pop     ds
273F:2AA7  5F                                   pop     di

273F:2AA8                       loc_ret_601:                                    ;  xref 273F:2ABE
273F:2AA8  C3                                   retn

                      ega_display_character     endp

273F:2AA9  00                   data_238        db      0                       ;  xref 273F:2B37, 2BA1
273F:2AAA  00                   data_239        db      0                       ;  xref 273F:2B0C, 2B9A
273F:2AAB  0000                 data_240        dw      0                       ;  xref 273F:2B3C, 2C04
273F:2AAD                       loc_602:                                        ;  xref 273F:2ADD
273F:2AAD  80 26 11D0 FB                        and     menubar_state, 0FBh ; (273F:11D0=56h)
273F:2AB2  C3                                   retn

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:2129
                                ;

273F:2AB3                       ega_cursor      proc    near
273F:2AB3  C7 06 F010 0000                      mov     timer_ticks, 0
273F:2AB9  F6 06 11D0 04                        test    menubar_state, 4   ; (273F:11D0=56h)
273F:2ABE  75 E8                                jnz     loc_ret_601             ; Jump if not zero
273F:2AC0  80 0E 11D0 04                        or      menubar_state, 4   ; (273F:11D0=56h)
273F:2AC5  F7 06 11EC FFFF                      test    word ptr ds:[11ECh],0FFFFh ; (273F:11EC=1B55h)
273F:2ACB  74 0B                                jz      loc_603                 ; Jump if zero
273F:2ACD  A1 0DB0                              mov     ax, screen_start_seg
273F:2AD0  8E C0                                mov     es,ax
273F:2AD2 BE 11E8                              mov     si,offset data_638      ; (31E4:11E8=0)
273F:2AD5  E8 014D                              call    sub_67                  ; (2C25)
273F:2AD8                       loc_603:                                        ;  xref 273F:2ACB
                                                assume  ds:data_seg
273F:2AD8  F6 06 11D0 01                        test    menubar_state, 1     ; (31E4:11D0=3)
273F:2ADD  75 CE                                jnz     loc_602                 ; Jump if not zero
273F:2ADF  A1 11D8                              mov     ax, mouse_y2  
273F:2AE2  2B 06 11DF                           sub     ax, cursor_centroid 
273F:2AE6  73 02                                jnc     loc_604                 ; Jump if carry=0
273F:2AE8  33 C0                                xor     ax,ax                   ; Zero register
273F:2AEA                       loc_604:                                        ;  xref 273F:2AE6
273F:2AEA  BD 00C8                              mov     bp,0C8h
273F:2AED  2B E8                                sub     bp,ax
273F:2AEF  83 FD 11                             cmp     bp,11h
273F:2AF2  72 03                                jb      loc_605                 ; Jump if below
273F:2AF4  BD 0010                              mov     bp,10h
273F:2AF7                       loc_605:                                        ;  xref 273F:2AF2
273F:2AF7  89 2E 11EC                           mov     data_640,bp             ; (31E4:11EC=0)
273F:2AFB  8B 36 11D6                           mov     si, mouse_x2
273F:2AFF  2B 36 11DF                           sub     si, cursor_centroid
273F:2B03  73 02                                jnc     loc_606                 ; Jump if carry=0
273F:2B05  33 F6                                xor     si,si                   ; Zero register
273F:2B07                       loc_606:                                        ;  xref 273F:2B03
273F:2B07  8B CE                                mov     cx,si
273F:2B09  80 E1 07                             and     cl,7
273F:2B0C  2E: 88 0E 2AAA                       mov     cs:data_239,cl          ; (273F:2AAA=0)
273F:2B11  B1 03                                mov     cl,3
273F:2B13  D3 EE                                shr     si,cl                   ; Shift w/zeros fill
273F:2B15  BB 0028                              mov     bx,28h
273F:2B18  2B DE                                sub     bx,si
273F:2B1A  80 FB 04                             cmp     bl,4
273F:2B1D  72 02                                jb      loc_607                 ; Jump if below
273F:2B1F  B3 03                                mov     bl,3
273F:2B21                       loc_607:                                        ;  xref 273F:2B1D
273F:2B21  88 1E 11EA                           mov     data_639,bl             ; (31E4:11EA=0)
273F:2B25  8B D0                                mov     dx,ax
273F:2B27  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:2B29  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:2B2B  03 C2                                add     ax,dx
273F:2B2D  D3 E0                                shl     ax,cl                   ; Shift w/zeros fill
273F:2B2F  03 F0                                add     si,ax
273F:2B31  89 36 11E8                           mov     data_638,si             ; (31E4:11E8=0)
273F:2B35  32 FF                                xor     bh,bh                   ; Zero register
273F:2B37  2E: 88 1E 2AA9                       mov     cs:data_238,bl          ; (273F:2AA9=0)
273F:2B3C  2E: 89 2E 2AAB                       mov     cs:data_240,bp          ; (273F:2AAB=0)
273F:2B41  BA 03CE                              mov     dx,3CEh
273F:2B44  B8 0005                              mov     ax,5
273F:2B47  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 5, mode
273F:2B48  B8 0007                              mov     ax,7
273F:2B4B  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 7, ignore color bits
273F:2B4C  B0 03                                mov     al,3
273F:2B4E  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 3, data rotate
273F:2B4F  FF 36 4CF4                           push    cursors_segment
273F:2B53  FF 36 11E1                           push    cursor_index
273F:2B57  1E                                   push    ds
273F:2B58  07                                   pop     es
273F:2B59  A1 0DB0                              mov     ax, screen_start_seg
273F:2B5C  8E D8                                mov     ds,ax
273F:2B5E  B8 0304                              mov     ax,304h
273F:2B61 BF 11EE                              mov     di,offset data_641      ; (31E4:11EE=0)
273F:2B64                       loc_608:                                        ;  xref 273F:2B7A
273F:2B64  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 4, read map select
273F:2B65  56                                   push    si
273F:2B66  55                                   push    bp
273F:2B67                       loc_609:                                        ;  xref 273F:2B73
273F:2B67  56                                   push    si
273F:2B68  8B CB                                mov     cx,bx
273F:2B6A  F3/ A4                               rep     movsb                   ; Rep when cx >0 Mov [si] to es:[di]
273F:2B6C  5E                                   pop     si
273F:2B6D  83 C6 28                             add     si,28h
273F:2B70  83 ED 01                             sub     bp,1
273F:2B73  75 F2                                jnz     loc_609                 ; Jump if not zero
273F:2B75  5D                                   pop     bp
273F:2B76  5E                                   pop     si
273F:2B77  80 EC 01                             sub     ah,1
273F:2B7A  73 E8                                jnc     loc_608                 ; Jump if carry=0
273F:2B7C  8B FE                                mov     di,si
273F:2B7E  BA 03CE                              mov     dx,3CEh
273F:2B81  B8 0805                              mov     ax,805h
273F:2B84  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 5, mode
273F:2B85  B8 0007                              mov     ax,7
273F:2B88  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 7, ignore color bits
273F:2B89  B0 03                                mov     al,3
273F:2B8B  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 3, data rotate
273F:2B8C  B8 FF08                              mov     ax,0FF08h
273F:2B8F  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 8, data bit mask
273F:2B90  1E                                   push    ds
273F:2B91  07                                   pop     es
273F:2B92  5E                                   pop     si
273F:2B93  B1 06                                mov     cl,6
273F:2B95  D3 E6                                shl     si,cl                   ; Shift w/zeros fill
273F:2B97  1F                                   pop     ds
273F:2B98  87 D5                                xchg    dx,bp
273F:2B9A  2E: 8A 0E 2AAA                       mov     cl,cs:data_239          ; (273F:2AAA=0)
273F:2B9F                       loc_610:                                        ;  xref 273F:2C0A
273F:2B9F  56                                   push    si
273F:2BA0  57                                   push    di
273F:2BA1  2E: 8A 2E 2AA9                       mov     ch,cs:data_238          ; (273F:2AA9=0)
273F:2BA6  33 DB                                xor     bx,bx                   ; Zero register
273F:2BA8  33 D2                                xor     dx,dx                   ; Zero register
273F:2BAA  8A 34                                mov     dh,[si]
273F:2BAC  D3 EA                                shr     dx,cl                   ; Shift w/zeros fill
273F:2BAE  8A E6                                mov     ah,dh
273F:2BB0  B0 08                                mov     al,8
273F:2BB2  87 D5                                xchg    dx,bp
273F:2BB4  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 8, data bit mask
273F:2BB5  87 D5                                xchg    dx,bp
273F:2BB7  8A 7C 01                             mov     bh,[si+1]
273F:2BBA  D3 EB                                shr     bx,cl                   ; Shift w/zeros fill
273F:2BBC  8A C7                                mov     al,bh
273F:2BBE  26: 8A 25                            mov     ah,es:[di]
273F:2BC1  AA                                   stosb                           ; Store al to es:[di]
273F:2BC2  80 ED 01                             sub     ch,1
273F:2BC5  74 35                                jz      loc_612                 ; Jump if zero
273F:2BC7  8A 64 02                             mov     ah,[si+2]
273F:2BCA  32 C0                                xor     al,al                   ; Zero register
273F:2BCC  D3 E8                                shr     ax,cl                   ; Shift w/zeros fill
273F:2BCE  0A E2                                or      ah,dl
273F:2BD0  8A D0                                mov     dl,al
273F:2BD2  87 D5                                xchg    dx,bp
273F:2BD4  B0 08                                mov     al,8
273F:2BD6  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 8, data bit mask
273F:2BD7  8A 64 03                             mov     ah,[si+3]
273F:2BDA  32 C0                                xor     al,al                   ; Zero register
273F:2BDC  D3 E8                                shr     ax,cl                   ; Shift w/zeros fill
273F:2BDE  0A E3                                or      ah,bl
273F:2BE0  8A D8                                mov     bl,al
273F:2BE2  8A C4                                mov     al,ah
273F:2BE4  26: 8A 25                            mov     ah,es:[di]
273F:2BE7  AA                                   stosb                           ; Store al to es:[di]
273F:2BE8  80 ED 01                             sub     ch,1
273F:2BEB  74 0D                                jz      loc_611                 ; Jump if zero
273F:2BED  8B C5                                mov     ax,bp
273F:2BEF  8A E0                                mov     ah,al
273F:2BF1  B0 08                                mov     al,8
273F:2BF3  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 8, data bit mask
273F:2BF4  8A C3                                mov     al,bl
           nlure.lst                           Sourcer v6.09   17-Nov- 5   5:53 pm   Page 112

273F:2BF6  26: 8A 25                            mov     ah,es:[di]
273F:2BF9  AA                                   stosb                           ; Store al to es:[di]
273F:2BFA                       loc_611:                                        ;  xref 273F:2BEB
273F:2BFA  87 D5                                xchg    dx,bp
273F:2BFC                       loc_612:                                        ;  xref 273F:2BC5
273F:2BFC  5F                                   pop     di
273F:2BFD  5E                                   pop     si
273F:2BFE  83 C6 04                             add     si,4
273F:2C01  83 C7 28                             add     di,28h
273F:2C04  2E: 83 2E 2AAB 01                    sub     cs:data_240,1           ; (273F:2AAB=0)
273F:2C0A  75 93                                jnz     loc_610                 ; Jump if not zero
273F:2C0C  87 D5                                xchg    dx,bp
273F:2C0E  B8 0005                              mov     ax,5
273F:2C11  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 5, mode
273F:2C12  B8 0F07                              mov     ax,0F07h
273F:2C15  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 7, ignore color bits
273F:2C16  B8 FF08                              mov     ax,0FF08h
273F:2C19  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 8, data bit mask
273F:2C1A  B8 31E4                              mov     ax,data_seg
273F:2C1D  8E D8                                mov     ds,ax
273F:2C1F  80 26 11D0 FB                        and     menubar_state, 0FBh  ; (31E4:11D0=3)

273F:2C24                       loc_ret_613:                                    ;  xref 273F:2C31
273F:2C24  C3                                   retn

                                ega_cursor      endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:2151, 2AD5
                                ;

273F:2C25                       sub_67          proc    near
273F:2C25  8B 3C                                mov     di,[si]
273F:2C27  8A 5C 02                             mov     bl,[si+2]
273F:2C2A  32 FF                                xor     bh,bh                   ; Zero register
273F:2C2C  8B 6C 04                             mov     bp,[si+4]
273F:2C2F  0B ED                                or      bp,bp                   ; Zero ?
273F:2C31  74 F1                                jz      loc_ret_613             ; Jump if zero
273F:2C33  C7 44 04 0000                        mov     word ptr [si+4],0
273F:2C38  83 C6 06                             add     si,6
273F:2C3B  BA 03CE                              mov     dx,3CEh
273F:2C3E  B8 0805                              mov     ax,805h
273F:2C41  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 5, mode
273F:2C42  B8 0007                              mov     ax,7
273F:2C45  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 7, ignore color bits
273F:2C46  B0 03                                mov     al,3
273F:2C48  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
                                                                                ;  al = 3, data rotate
273F:2C49  B8 FF08                              mov     ax,0FF08h
273F:2C4C  EF                                   out     dx,ax                   ; port 3CEh, EGA graphic index
           nlure.lst                           Sourcer v6.09   17-Nov- 5   5:53 pm   Page 113

                                                                                ;  al = 8, data bit mask
273F:2C4D  B8 31E4                              mov     ax,data_seg
273F:2C50  8E D8                                mov     ds,ax
273F:2C52  B2 C4                                mov     dl,0C4h
273F:2C54  B8 0802                              mov     ax,802h
273F:2C57  B9 0004                              mov     cx,4

273F:2C5A                       locloop_614:                                    ;  xref 273F:2C70
273F:2C5A  EF                                   out     dx,ax                   ; port 3C4h, EGA sequencr index
                                                                                ;  al = 2, map mask register
273F:2C5B  51                                   push    cx
273F:2C5C  57                                   push    di
273F:2C5D  8B CD                                mov     cx,bp

273F:2C5F                       locloop_615:                                    ;  xref 273F:2C6A
273F:2C5F  51                                   push    cx
273F:2C60  57                                   push    di
273F:2C61  8B CB                                mov     cx,bx
273F:2C63  F3/ A4                               rep     movsb                   ; Rep when cx >0 Mov [si] to es:[di]
273F:2C65  5F                                   pop     di
273F:2C66  83 C7 28                             add     di,28h
273F:2C69  59                                   pop     cx
273F:2C6A  E2 F3                                loop    locloop_615             ; Loop if cx > 0

273F:2C6C  5F                                   pop     di
273F:2C6D  59                                   pop     cx
273F:2C6E  D0 EC                                shr     ah,1                    ; Shift w/zeros fill
273F:2C70  E2 E8                                loop    locloop_614             ; Loop if cx > 0

273F:2C72  B4 0F                                mov     ah,0Fh
273F:2C74  EF                                   out     dx,ax                   ; port 3C4h, EGA sequencr index
                                                                                ;  al = 2, map mask register
273F:2C75  C3                                   retn
                                sub_67          endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                          ega_add_animation     proc    near

273F:2C76  8A 47 04                             mov     al,[bx+4]
273F:2C79  8A 6F 06                             mov     ch,[bx+6]
273F:2C7C  F6 E5                                mul     ch                      ; ax = reg * al
273F:2C7E  D1 E8                                shr     ax,1                    ; Shift w/zeros fill
273F:2C80  03 C6                                add     ax,si
273F:2C82  A3 1440                              mov     word ptr ds:[1440h],ax  ; (273F:1440=0BA00h)
273F:2C85  B8 FFFF                              mov     ax,0FFFFh
                                                assume  ds:seg_code
273F:2C88  2E: A3 1500                          mov     word ptr cs:data_215,ax ; (273F:1500=0)
273F:2C8C  2E: A3 1502                          mov     cs:data_216,ax          ; (273F:1502=0)
273F:2C90  2E: A2 1504                          mov     cs:data_217,al          ; (273F:1504=0)
273F:2C94  C6 06 11B0 00                        mov     byte ptr ds:[11B0h],0   ; (273F:11B0=0BEh)
273F:2C99  8B 47 02                             mov     ax,[bx+2]
273F:2C9C  2D 0088                              sub     ax,88h
273F:2C9F  73 2A                                jnc     loc_618                 ; Jump if carry=0
273F:2CA1  50                                   push    ax
273F:2CA2  03 47 06                             add     ax,[bx+6]
273F:2CA5  58                                   pop     ax
273F:2CA6  74 02                                jz      loc_616                 ; Jump if zero
273F:2CA8  72 03                                jc      loc_617                 ; Jump if carry Set
273F:2CAA                       loc_616:                                        ;  xref 273F:2CA6, 2D26
273F:2CAA  E9 02EE                              jmp     loc_ret_636             ; (2F9B)
273F:2CAD                       loc_617:                                        ;  xref 273F:2CA8
273F:2CAD  F7 D8                                neg     ax
273F:2CAF  2A E8                                sub     ch,al
273F:2CB1  F6 67 04                             mul     byte ptr [bx+4]         ; ax = data * al
273F:2CB4  B1 03                                mov     cl,3
273F:2CB6  D3 E8                                shr     ax,cl                   ; Shift w/zeros fill
273F:2CB8  01 06 1440                           add     word ptr ds:[1440h],ax  ; (273F:1440=0BA00h)
273F:2CBC  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:2CBE  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:2CC0  03 F0                                add     si,ax
273F:2CC2  33 C0                                xor     ax,ax                   ; Zero register
273F:2CC4  C6 06 11B0 01                        mov     byte ptr ds:[11B0h],1   ; (273F:11B0=0BEh)
273F:2CC9  EB 1C                                jmp     short loc_621           ; (2CE7)
273F:2CCB                       loc_618:                                        ;  xref 273F:2C9F
273F:2CCB  3D 00C0                              cmp     ax,0C0h
273F:2CCE  72 03                                jb      loc_619                 ; Jump if below
273F:2CD0  E9 02C8                              jmp     loc_ret_636             ; (2F9B)
273F:2CD3                       loc_619:                                        ;  xref 273F:2CCE
273F:2CD3  50                                   push    ax
273F:2CD4  03 47 06                             add     ax,[bx+6]
273F:2CD7  3D 00C1                              cmp     ax,0C1h
273F:2CDA  72 0A                                jb      loc_620                 ; Jump if below
273F:2CDC  2D 00C0                              sub     ax,0C0h
273F:2CDF  2A E8                                sub     ch,al
273F:2CE1  C6 06 11B0 01                        mov     byte ptr ds:[11B0h],1   ; (273F:11B0=0BEh)
273F:2CE6                       loc_620:                                        ;  xref 273F:2CDA
273F:2CE6  58                                   pop     ax
273F:2CE7                       loc_621:                                        ;  xref 273F:2CC9
273F:2CE7  8B D0                                mov     dx,ax
273F:2CE9  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:2CEB  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:2CED  03 C2                                add     ax,dx
273F:2CEF  B1 05                                mov     cl,5
273F:2CF1  D3 E0                                shl     ax,cl                   ; Shift w/zeros fill
273F:2CF3  05 0500                              add     ax,500h
273F:2CF6  8B F8                                mov     di,ax
273F:2CF8  8B 47 04                             mov     ax,[bx+4]
273F:2CFB  B1 03                                mov     cl,3
273F:2CFD  D3 E8                                shr     ax,cl                   ; Shift w/zeros fill
273F:2CFF  2E: A2 1509                          mov     cs:data_220,al          ; (273F:1509=0)
273F:2D03  2E: A3 1507                          mov     cs:data_219,ax          ; (273F:1507=0)
273F:2D07  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:2D09  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:2D0B  2E: A3 1505                          mov     cs:data_218,ax          ; (273F:1505=0)
273F:2D0F  8B 07                                mov     ax,[bx]
273F:2D11  8A C8                                mov     cl,al
273F:2D13  80 E1 07                             and     cl,7
273F:2D16  89 0E 1442                           mov     word ptr ds:[1442h],cx  ; (273F:1442=1)
273F:2D1A  2D 0080                              sub     ax,80h
273F:2D1D  73 31                                jnc     loc_623                 ; Jump if carry=0
273F:2D1F  50                                   push    ax
273F:2D20  8B 57 04                             mov     dx,[bx+4]
273F:2D23  03 C2                                add     ax,dx
273F:2D25  58                                   pop     ax
273F:2D26  74 82                                jz      loc_616                 ; Jump if zero
273F:2D28  72 03                                jc      loc_622                 ; Jump if carry Set
273F:2D2A  E9 026E                              jmp     loc_ret_636             ; (2F9B)
273F:2D2D                       loc_622:                                        ;  xref 273F:2D28
273F:2D2D  F7 D0                                not     ax
273F:2D2F  25 FFF8                              and     ax,0FFF8h
273F:2D32  D1 E8                                shr     ax,1                    ; Shift w/zeros fill
273F:2D34  2E: A3 1500                          mov     word ptr cs:data_215,ax ; (273F:1500=0)
273F:2D38  D1 E8                                shr     ax,1                    ; Shift w/zeros fill
273F:2D3A  D1 E8                                shr     ax,1                    ; Shift w/zeros fill
273F:2D3C  2E: A3 1502                          mov     cs:data_216,ax          ; (273F:1502=0)
273F:2D40  04 01                                add     al,1
273F:2D42  2E: 28 06 1509                       sub     cs:data_220,al          ; (273F:1509=0)
273F:2D47  C6 06 11B0 01                        mov     byte ptr ds:[11B0h],1   ; (273F:11B0=0BEh)
273F:2D4C  33 C0                                xor     ax,ax                   ; Zero register
273F:2D4E  EB 29                                jmp     short loc_625           ; (2D79)
273F:2D50                       loc_623:                                        ;  xref 273F:2D1D
273F:2D50  3D 0140                              cmp     ax,140h
273F:2D53  72 03                                jb      loc_624                 ; Jump if below
273F:2D55  E9 0243                              jmp     loc_ret_636             ; (2F9B)
273F:2D58                       loc_624:                                        ;  xref 273F:2D53
273F:2D58  8B 57 04                             mov     dx,[bx+4]
273F:2D5B  03 D0                                add     dx,ax
273F:2D5D  81 EA 0140                           sub     dx,140h
273F:2D61  72 16                                jc      loc_625                 ; Jump if carry Set
273F:2D63  74 14                                jz      loc_625                 ; Jump if zero
273F:2D65  B1 03                                mov     cl,3
273F:2D67  D3 EA                                shr     dx,cl                   ; Shift w/zeros fill
273F:2D69  2E: 28 16 1509                       sub     cs:data_220,dl          ; (273F:1509=0)
273F:2D6E  2E: C6 06 1504 00                    mov     cs:data_217,0           ; (273F:1504=0)
273F:2D74  C6 06 11B0 01                        mov     byte ptr ds:[11B0h],1   ; (273F:11B0=0BEh)
273F:2D79                       loc_625:                                        ;  xref 273F:2D4E, 2D61, 2D63
273F:2D79  25 FFF8                              and     ax,0FFF8h
273F:2D7C  D1 E8                                shr     ax,1                    ; Shift w/zeros fill
273F:2D7E  03 F8                                add     di,ax
273F:2D80  8B 0E 1442                           mov     cx,word ptr ds:[1442h]  ; (273F:1442=1)
273F:2D84  80 F1 07                             xor     cl,7
273F:2D87  80 C1 01                             add     cl,1
273F:2D8A  8B 1E 1440                           mov     bx,word ptr ds:[1440h]  ; (273F:1440=0BA00h)
273F:2D8E  80 3E 11B0 01                        cmp     byte ptr ds:[11B0h],1   ; (273F:11B0=0BEh)
273F:2D93  75 03                                jne     loc_626                 ; Jump if not equal
273F:2D95  E9 00D9                              jmp     loc_630                 ; (2E71)
273F:2D98                       loc_626:                                        ;  xref 273F:2D93
273F:2D98  1E                                   push    ds
273F:2D99  06                                   push    es
273F:2D9A  A1 4CE4                              mov     ax, data_segment2
273F:2D9D  8E C0                                mov     es,ax
273F:2D9F  1F                                   pop     ds
273F:2DA0                       loc_627:                                        ;  xref 273F:2E6B
273F:2DA0 32 D2                                xor     dl,dl                   ; Zero register
273F:2DA2  2E: 88 16 2058                       mov     cs:data_233,dl          ; (273F:2058=0)
273F:2DA7  2E: 88 16 2059                       mov     cs:data_234,dl          ; (273F:2059=0)
273F:2DAC  2E: 88 16 205A                       mov     cs:data_235,dl          ; (273F:205A=0)
273F:2DB1  2E: 88 16 205B                       mov     cs:data_236,dl          ; (273F:205B=0)
273F:2DB6  F6 D2                                not     dl
273F:2DB8  51                                   push    cx
273F:2DB9  57                                   push    di
273F:2DBA  2E: 8A 2E 1509                       mov     ch,cs:data_220          ; (273F:1509=0)
273F:2DBF                       loc_628:                                        ;  xref 273F:2E2D
273F:2DBF  33 C0                                xor     ax,ax                   ; Zero register
273F:2DC1  8A 07                                mov     al,[bx]
273F:2DC3  D3 E0                                shl     ax,cl                   ; Shift w/zeros fill
273F:2DC5  F7 D0                                not     ax
273F:2DC7  22 E2                                and     ah,dl
273F:2DC9  8B D0                                mov     dx,ax
273F:2DCB  AC                                   lodsb                           ; String [si] to al
273F:2DCC  32 E4                                xor     ah,ah                   ; Zero register
273F:2DCE  D3 E0                                shl     ax,cl                   ; Shift w/zeros fill
273F:2DD0  2E: 0A 26 2058                       or      ah,cs:data_233          ; (273F:2058=0)
273F:2DD5  2E: A2 2058                          mov     cs:data_233,al          ; (273F:2058=0)
273F:2DD9  26: 20 35                            and     es:[di],dh
273F:2DDC  26: 08 25                            or      es:[di],ah
273F:2DDF  83 C7 01                             add     di,1
273F:2DE2  AC                                   lodsb                           ; String [si] to al
273F:2DE3  32 E4                                xor     ah,ah                   ; Zero register
273F:2DE5  D3 E0                                shl     ax,cl                   ; Shift w/zeros fill
273F:2DE7  2E: 0A 26 2059                       or      ah,cs:data_234          ; (273F:2059=0)
273F:2DEC  2E: A2 2059                          mov     cs:data_234,al          ; (273F:2059=0)
273F:2DF0  26: 20 35                            and     es:[di],dh
273F:2DF3  26: 08 25                            or      es:[di],ah
273F:2DF6  83 C7 01                             add     di,1
273F:2DF9  AC                                   lodsb                           ; String [si] to al
273F:2DFA  32 E4                                xor     ah,ah                   ; Zero register
273F:2DFC  D3 E0                                shl     ax,cl                   ; Shift w/zeros fill
273F:2DFE  2E: 0A 26 205A                       or      ah,cs:data_235          ; (273F:205A=0)
273F:2E03  2E: A2 205A                          mov     cs:data_235,al          ; (273F:205A=0)
273F:2E07  26: 20 35                            and     es:[di],dh
273F:2E0A  26: 08 25                            or      es:[di],ah
273F:2E0D  83 C7 01                             add     di,1
273F:2E10  AC                                   lodsb                           ; String [si] to al
273F:2E11  32 E4                                xor     ah,ah                   ; Zero register
273F:2E13  D3 E0                                shl     ax,cl                   ; Shift w/zeros fill
273F:2E15  2E: 0A 26 205B                       or      ah,cs:data_236          ; (273F:205B=0)
273F:2E1A  2E: A2 205B                          mov     cs:data_236,al          ; (273F:205B=0)
273F:2E1E  26: 20 35                            and     es:[di],dh
273F:2E21  26: 08 25                            or      es:[di],ah
273F:2E24  83 C7 01                             add     di,1
273F:2E27  83 C3 01                             add     bx,1
273F:2E2A  80 ED 01                             sub     ch,1
273F:2E2D  75 90                                jnz     loc_628                 ; Jump if not zero
273F:2E2F  2E: A0 2058                          mov     al,cs:data_233          ; (273F:2058=0)
273F:2E33  26: 20 15                            and     es:[di],dl
273F:2E36  26: 08 05                            or      es:[di],al
273F:2E39  83 C7 01                             add     di,1
273F:2E3C  2E: A0 2059                          mov     al,cs:data_234          ; (273F:2059=0)
273F:2E40  26: 20 15                            and     es:[di],dl
273F:2E43  26: 08 05                            or      es:[di],al
273F:2E46  83 C7 01                             add     di,1
273F:2E49  2E: A0 205A                          mov     al,cs:data_235          ; (273F:205A=0)
273F:2E4D  26: 20 15                            and     es:[di],dl
273F:2E50  26: 08 05                            or      es:[di],al
273F:2E53  83 C7 01                             add     di,1
273F:2E56  2E: A0 205B                          mov     al,cs:data_236          ; (273F:205B=0)
273F:2E5A  26: 20 15                            and     es:[di],dl
273F:2E5D  26: 08 05                            or      es:[di],al
273F:2E60  5F                                   pop     di
273F:2E61 81 C7 00A0                           add     di,data_1460e           ; (FF12:00A0=0)
273F:2E65  59                                   pop     cx
273F:2E66  80 ED 01                             sub     ch,1
273F:2E69  74 03                                jz      loc_629                 ; Jump if zero
273F:2E6B  E9 FF32                              jmp     loc_627                 ; (2DA0)
273F:2E6E                       loc_629:                                        ;  xref 273F:2E69
273F:2E6E  E9 0129                              jmp     loc_635                 ; (2F9A)
273F:2E71                       loc_630:                                        ;  xref 273F:2D95
273F:2E71  1E                                   push    ds
273F:2E72  06                                   push    es
273F:2E73  A1 4CE4                              mov     ax, data_segment2
273F:2E76  8E C0                                mov     es,ax
273F:2E78  1F                                   pop     ds
273F:2E79                       loc_631:                                        ;  xref 273F:2F97
273F:2E79 32 D2                                xor     dl,dl                   ; Zero register
273F:2E7B  2E: 88 16 2058                       mov     cs:data_233,dl          ; (273F:2058=0)
273F:2E80  2E: 88 16 2059                       mov     cs:data_234,dl          ; (273F:2059=0)
273F:2E85  2E: 88 16 205A                       mov     cs:data_235,dl          ; (273F:205A=0)
273F:2E8A  2E: 88 16 205B                       mov     cs:data_236,dl          ; (273F:205B=0)
273F:2E8F  F6 D2                                not     dl
273F:2E91  51                                   push    cx
273F:2E92  53                                   push    bx
273F:2E93  56                                   push    si
273F:2E94  57                                   push    di
273F:2E95  2E: 8A 2E 1509                       mov     ch,cs:data_220          ; (273F:1509=0)
273F:2E9A  2E: F7 06 1500 0080                  test    word ptr cs:data_215,80h ; (273F:1500=0)
273F:2EA1  75 34                                jnz     loc_632                 ; Jump if not zero
273F:2EA3  2E: 03 36 1500                       add     si,word ptr cs:data_215 ; (273F:1500=0)
273F:2EA8  2E: 03 1E 1502                       add     bx,cs:data_216          ; (273F:1502=0)
273F:2EAD  8A 17                                mov     dl,[bx]
273F:2EAF  D3 E2                                shl     dx,cl                   ; Shift w/zeros fill
273F:2EB1  F6 D2                                not     dl
273F:2EB3  83 C3 01                             add     bx,1
273F:2EB6  AC                                   lodsb                           ; String [si] to al
273F:2EB7  D3 E0                                shl     ax,cl                   ; Shift w/zeros fill
273F:2EB9  2E: A2 2058                          mov     cs:data_233,al          ; (273F:2058=0)
273F:2EBD  AC                                   lodsb                           ; String [si] to al
273F:2EBE  D3 E0                                shl     ax,cl                   ; Shift w/zeros fill
273F:2EC0  2E: A2 2059                          mov     cs:data_234,al          ; (273F:2059=0)
273F:2EC4  AC                                   lodsb                           ; String [si] to al
273F:2EC5  D3 E0                                shl     ax,cl                   ; Shift w/zeros fill
273F:2EC7  2E: A2 205A                          mov     cs:data_235,al          ; (273F:205A=0)
273F:2ECB  AC                                   lodsb                           ; String [si] to al
273F:2ECC  D3 E0                                shl     ax,cl                   ; Shift w/zeros fill
273F:2ECE  2E: A2 205B                          mov     cs:data_236,al          ; (273F:205B=0)
273F:2ED2  F6 C5 FF                             test    ch,0FFh
273F:2ED5  74 78                                jz      loc_633                 ; Jump if zero
273F:2ED7                       loc_632:                                        ;  xref 273F:2EA1, 2F45
273F:2ED7  33 C0                                xor     ax,ax                   ; Zero register
273F:2ED9  8A 07                                mov     al,[bx]
273F:2EDB  D3 E0                                shl     ax,cl                   ; Shift w/zeros fill
273F:2EDD  F7 D0                                not     ax
273F:2EDF  22 E2                                and     ah,dl
273F:2EE1  8B D0                                mov     dx,ax
273F:2EE3  AC                                   lodsb                           ; String [si] to al
273F:2EE4  32 E4                                xor     ah,ah                   ; Zero register
273F:2EE6  D3 E0                                shl     ax,cl                   ; Shift w/zeros fill
273F:2EE8  2E: 0A 26 2058                       or      ah,cs:data_233          ; (273F:2058=0)
273F:2EED  2E: A2 2058                          mov     cs:data_233,al          ; (273F:2058=0)
273F:2EF1  26: 20 35                            and     es:[di],dh
273F:2EF4  26: 08 25                            or      es:[di],ah
273F:2EF7  83 C7 01                             add     di,1
273F:2EFA  AC                                   lodsb                           ; String [si] to al
273F:2EFB  32 E4                                xor     ah,ah                   ; Zero register
273F:2EFD  D3 E0                                shl     ax,cl                   ; Shift w/zeros fill
273F:2EFF  2E: 0A 26 2059                       or      ah,cs:data_234          ; (273F:2059=0)
273F:2F04  2E: A2 2059                          mov     cs:data_234,al          ; (273F:2059=0)
273F:2F08  26: 20 35                            and     es:[di],dh
273F:2F0B  26: 08 25                            or      es:[di],ah
273F:2F0E  83 C7 01                             add     di,1
273F:2F11  AC                                   lodsb                           ; String [si] to al
273F:2F12  32 E4                                xor     ah,ah                   ; Zero register
273F:2F14  D3 E0                                shl     ax,cl                   ; Shift w/zeros fill
273F:2F16  2E: 0A 26 205A                       or      ah,cs:data_235          ; (273F:205A=0)
273F:2F1B  2E: A2 205A                          mov     cs:data_235,al          ; (273F:205A=0)
273F:2F1F  26: 20 35                            and     es:[di],dh
273F:2F22  26: 08 25                            or      es:[di],ah
273F:2F25  83 C7 01                             add     di,1
273F:2F28  AC                                   lodsb                           ; String [si] to al
273F:2F29  32 E4                                xor     ah,ah                   ; Zero register
273F:2F2B  D3 E0                                shl     ax,cl                   ; Shift w/zeros fill
273F:2F2D  2E: 0A 26 205B                       or      ah,cs:data_236          ; (273F:205B=0)
273F:2F32  2E: A2 205B                          mov     cs:data_236,al          ; (273F:205B=0)
273F:2F36  26: 20 35                            and     es:[di],dh
273F:2F39  26: 08 25                            or      es:[di],ah
273F:2F3C  83 C7 01                             add     di,1
273F:2F3F  83 C3 01                             add     bx,1
273F:2F42  80 ED 01                             sub     ch,1
273F:2F45  75 90                                jnz     loc_632                 ; Jump if not zero
273F:2F47  2E: F6 06 1504 FF                    test    cs:data_217,0FFh        ; (273F:1504=0)
273F:2F4D  74 31                                jz      loc_634                 ; Jump if zero
273F:2F4F                       loc_633:                                        ;  xref 273F:2ED5
273F:2F4F  2E: A0 2058                          mov     al,cs:data_233          ; (273F:2058=0)
273F:2F53  26: 20 15                            and     es:[di],dl
273F:2F56  26: 08 05                            or      es:[di],al
273F:2F59  83 C7 01                             add     di,1
273F:2F5C  2E: A0 2059                          mov     al,cs:data_234          ; (273F:2059=0)
273F:2F60  26: 20 15                            and     es:[di],dl
273F:2F63  26: 08 05                            or      es:[di],al
273F:2F66  83 C7 01                             add     di,1
273F:2F69  2E: A0 205A                          mov     al,cs:data_235          ; (273F:205A=0)
273F:2F6D  26: 20 15                            and     es:[di],dl
273F:2F70  26: 08 05                            or      es:[di],al
273F:2F73  83 C7 01                             add     di,1
273F:2F76  2E: A0 205B                          mov     al,cs:data_236          ; (273F:205B=0)
273F:2F7A  26: 20 15                            and     es:[di],dl
273F:2F7D  26: 08 05                            or      es:[di],al
273F:2F80                       loc_634:                                        ;  xref 273F:2F4D
273F:2F80  5F                                   pop     di
273F:2F81 81 C7 00A0                           add     di,data_1460e           ; (FF12:00A0=0)
273F:2F85  5E                                   pop     si
273F:2F86  2E: 03 36 1505                       add     si,cs:data_218          ; (273F:1505=0)
273F:2F8B  5B                                   pop     bx
273F:2F8C  2E: 03 1E 1507                       add     bx,cs:data_219          ; (273F:1507=0)
           nlure.lst                           Sourcer v6.09   17-Nov- 5   5:53 pm   Page 119

273F:2F91  59                                   pop     cx
273F:2F92  80 ED 01                             sub     ch,1
273F:2F95  74 03                                jz      loc_635                 ; Jump if zero
273F:2F97  E9 FEDF                              jmp     loc_631                 ; (2E79)
273F:2F9A                       loc_635:                                        ;  xref 273F:2E6E, 2F95
273F:2F9A  1F                                   pop     ds

273F:2F9B                       loc_ret_636:                                    ;  xref 273F:2CAA, 2CD0, 2D2A, 2D55
273F:2F9B  C3                                   retn
273F:2F9C                       loc_637:                                        ;  xref 273F:8E45
273F:2F9C D1 EF                                shr     di,1                    ; Shift w/zeros fill
273F:2F9E  D1 EB                                shr     bx,1                    ; Shift w/zeros fill
273F:2FA0  D1 EB                                shr     bx,1                    ; Shift w/zeros fill
273F:2FA2  D1 EB                                shr     bx,1                    ; Shift w/zeros fill
273F:2FA4  A1 4CE4                              mov     ax, data_segment2
273F:2FA7  8E C0                                mov     es,ax
273F:2FA9  BA 0008                              mov     dx,8
273F:2FAC                       loc_638:                                        ;  xref 273F:2FC2
273F:2FAC  57                                   push    di
273F:2FAD  8B CB                                mov     cx,bx

273F:2FAF                       locloop_639:                                    ;  xref 273F:2FBA
273F:2FAF  26: 8A 45 02                         mov     al,es:[di+2]
273F:2FB3  26: 30 45 01                         xor     es:[di+1],al
273F:2FB7  83 C7 04                             add     di,4
273F:2FBA  E2 F3                                loop    locloop_639             ; Loop if cx > 0

273F:2FBC  5F                                   pop     di
273F:2FBD 81 C7 00A0                           add     di,data_68e             ; (0031:00A0=0)
273F:2FC1  4A                                   dec     dx
273F:2FC2  75 E8                                jnz     loc_638                 ; Jump if not zero
273F:2FC4  C3                                   retn

                          ega_add_animation     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:2081
                                ;

273F:2FC5                       sub_68          proc    near
273F:2FC5  1E                                   push    ds
273F:2FC6  A1 4CE4                              mov     ax, data_segment2
273F:2FC9  8E D8                                mov     ds,ax
273F:2FCB  33 F6                                xor     si,si                   ; Zero register
273F:2FCD  33 FF                                xor     di,di                   ; Zero register
273F:2FCF  B8 0802                              mov     ax,802h
273F:2FD2  B9 0004                              mov     cx,4

273F:2FD5                       locloop_640:                                    ;  xref 273F:2FEA
273F:2FD5  51                                   push    cx
273F:2FD6  56                                   push    si
273F:2FD7  57                                   push    di
273F:2FD8  EF                                   out     dx,ax                   ; port 3C4h, EGA sequencr index
                                                                                ;  al = 2, map mask register
273F:2FD9  B9 0140                              mov     cx,140h

273F:2FDC                       locloop_641:                                    ;  xref 273F:2FE0
273F:2FDC  A4                                   movsb                           ; Mov [si] to es:[di]
273F:2FDD  83 C6 03                             add     si,3
273F:2FE0  E2 FA                                loop    locloop_641             ; Loop if cx > 0

273F:2FE2  5F                                   pop     di
273F:2FE3  5E                                   pop     si
273F:2FE4  83 C6 01                             add     si,1
273F:2FE7  D0 EC                                shr     ah,1                    ; Shift w/zeros fill
273F:2FE9  59                                   pop     cx
273F:2FEA  E2 E9                                loop    locloop_640             ; Loop if cx > 0

273F:2FEC  1F                                   pop     ds
273F:2FED  80 2E 4BF0 01                        sub     byte ptr ds:[4BF0h],1   ; (273F:4BF0=3)
273F:2FF2  C3                                   retn
                                sub_68          endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                  ega_toggle_menu_highlight     proc    near

273F:2FF3  D1 EF                                shr     di,1                    ; Shift w/zeros fill
273F:2FF5  83 E7 FC                             and     di,0FFFCh
273F:2FF8  B1 03                                mov     cl,3
273F:2FFA  83 C3 07                             add     bx,7
273F:2FFD  D3 EB                                shr     bx,cl                   ; Shift w/zeros fill
273F:2FFF  A1 4CE4                              mov     ax, data_segment2
273F:3002  8E C0                                mov     es,ax
273F:3004  BA 0008                              mov     dx,8
273F:3007                       loc_642:                                        ;  xref 273F:3022
273F:3007  57                                   push    di
273F:3008  8B CB                                mov     cx,bx

273F:300A                       locloop_643:                                    ;  xref 273F:301A
273F:300A  26: 8A 05                            mov     al,es:[di]
273F:300D  F6 D0                                not     al
273F:300F  26: 30 45 01                         xor     es:[di+1],al
273F:3013  26: 30 45 02                         xor     es:[di+2],al
273F:3017  83 C7 04                             add     di,4
273F:301A  E2 EE                                loop    locloop_643             ; Loop if cx > 0

273F:301C  5F                                   pop     di
273F:301D  81 C7 00A0                           add     di,0A0h
273F:3021  4A                                   dec     dx
273F:3022  75 E3                                jnz     loc_642                 ; Jump if not zero
273F:3024  C3                                   retn

                  ega_toggle_menu_highlight     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:90CB
                                ;

273F:3025                       sub_69          proc    near
273F:3025  1E                                   push    ds
273F:3026  A1 4CE4                              mov     ax, data_segment2
273F:3029  8E C0                                mov     es,ax
273F:302B BF 1F48                              mov     di,data_1407e           ; (44E4:1F48=0)
273F:302E  B8 44E4                              mov     ax, ega_talk_frame_seg
273F:3031  8E D8                                mov     ds,ax
273F:3033 BE 0030                              mov     si,offset data_1405     ; (44E4:0030=3Fh)
273F:3036  BB 0020                              mov     bx,20h
273F:3039  E8 F417                              call    sub_63                  ; (2453)
273F:303C  E8 F414                              call    sub_63                  ; (2453)
273F:303F  E8 F411                              call    sub_63                  ; (2453)
273F:3042 BE 000C                              mov     si,offset data_1404     ; (44E4:000C=0)
273F:3045  E8 F40B                              call    sub_63                  ; (2453)
273F:3048  E8 F408                              call    sub_63                  ; (2453)
273F:304B  1F                                   pop     ds
273F:304C  C3                                   retn
                                sub_69          endp

273F:304D  00                                   db      0

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

273F:304E                    vga_show_screen    proc    near

273F:304E 80 0E 11D0 02                         or      menubar_state, 2
273F:3053 E8FD06                                call    sub_unknown_1

273F:3056 F6 06 4BF0 FF                         test    byte ptr [4BF0h], 0ffh
273F:305B 74 03                                 jz      vga_loc_1
273F:305D E8 0F 09                              call    menubar_copy_to_screen
273F:3060 BE 0A00             vga_loc_1:        mov     si, MENUBAR_BLOCK_SIZE  ; Set SI and DI to after menubar area
273F:3063 8B FE                                 mov     di, si
273F:3065 B9 060A                               mov     cx, 060Ah               ; 10x6 sets of 32x32 rectangles
273F:3068 8C DA                                 mov     dx, ds                  ; Make a backup of DS
273F:306A A1 0DB0                               mov     ax, screen_start_seg
273F:306D 8E C0                                 mov     es, ax
273F:306F BB DC 07                              mov     bx, offset display_mask

273F:3072                       loc_644:
273F:3072  F6 07 01                             test    byte ptr [bx],1         ; Is bit 0 turned on?
273F:3075  74 23                                jz      loc_646                 ; No, so jump
273F:3077  80 27 FE                             and     byte ptr [bx],0FEh      ; Clear bit 0

; The following code copies a rectangle from (x+0,y+0) - (x+31,y+31) from data_segment2 to screen_start_seg

273F:307A  57                                   push    di
273F:307B  51                                   push    cx
273F:307C  A1 4CE4                              mov     ax, data_segment2       ; Get screen source from data_segment2
273F:307F  8E D8                                mov     ds, ax
273F:3081  B8 0020                              mov     ax,20h                  ; Number of lines
273F:3084                       loc_645:
273F:3084  B9 0010                              mov     cx,10h                  ; Rep when cx >0 Mov [si] to es:[di]
273F:3087  F3/ A5                               rep     movsw                   ;  (moves first 32 pixels of line)
273F:3089  81 C6 0120                           add     si,120h                 ; Move to start of next line
273F:308D  81 C7 0120                           add     di,120h
273F:3091  2D 0001                              sub     ax,1                    ; Decrement number of lines to do
273F:3094  75 EE                                jnz     loc_645                 ; Jump if not zero
273F:3096  8E DA                                mov     ds,dx                   ; Restore data segment
273F:3098  59                                   pop     cx
273F:3099  5F                                   pop     di

273F:309A                       loc_646:
273F:309A  83 C7 20                             add     di,20h                  ; Move to next rectangle position
273F:309D  8B F7                                mov     si,di                   ; Match source to destination
273F:309F  83 C3 01                             add     bx,1                    ; Move to next mask position
273F:30A2  80 E9 01                             sub     cl,1                    ; Subtract remaining horiz blocks
273F:30A5  75 CB                                jnz     loc_644                 ; Jump if not yet end of line
273F:30A7  81 C7 26C0                           add     di,26C0h                ; Reset soruce/dest to start of next
273F:30AB  8B F7                                mov     si,di                   ;   rect vertically at start of line
273F:30AD  83 C3 08                             add     bx,8
273F:30B0  B1 0A                                mov     cl,0Ah                  ; Number of horizontal rectangles
273F:30B2  80 ED 01                             sub     ch,1                    ; Decrement remaining vertical rectangles
273F:30B5  75 BB                                jnz     loc_644                 ; Jump if not done

273F:30B7  E8 0704                              call    sub_73                  ; (37BE)
273F:30BA  A1 11D6                              mov     ax, mouse_x2
273F:30BD  39 06 11D1                           cmp     mouse_x, ax
273F:30C1  75 09                                jne     loc_647                 ; Jump if not equal
273F:30C3  A1 11D8                              mov     ax, mouse_y2
273F:30C6  39 06 11D3                           cmp     mouse_y, ax
273F:30CA  74 10                                je      loc_648                 ; Jump if equal
273F:30CC                       loc_647:                                        ;  xref 273F:30C1
273F:30CC  A1 11D1                              mov     ax, mouse_x
273F:30CF  A3 11D6                              mov     mouse_x2, ax
273F:30D2  A1 11D3                              mov     ax, mouse_y
273F:30D5  A3 11D8                              mov     mouse_y2, ax
273F:30D8  FF 16 075E                           call    word ptr ds:data_18e    ; (0000:075E=0)
273F:30DC                       loc_648:                                        ;  xref 273F:30CA
273F:30DC  80 26 11D0 FD                        and     byte ptr ds:data_26e,0FDh ; (0000:11D0=80h)

273F:30E1                       loc_ret_649:                                    ;  xref 273F:30EC
273F:30E1  C3                                   retn

                             vga_show_screen    endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called indircetly via calls to word ptr [fade_out_proc]
                                ;


273F:30E2                    vga_fade_out       proc    near
273F:30E2  80 26 11D0 CF                        and     menubar_state, 0CFh ; (273F:11D0=56h)
273F:30E7  F6 06 073C 20                        test    byte ptr ds:[73Ch],20h  ; (273F:073C=17h) ' '
273F:30EC  75 F3                                jnz     loc_ret_649             ; Jump if not zero
273F:30EE  80 0E 073C 20                        or      byte ptr ds:[73Ch],20h  ; (273F:073C=17h) ' '

273F:30F3 BE 1457                              mov     si, offset unprocessed_vga_palette
273F:30F6 BF 0DB5                              mov     di, offset processed_vga_palette
273F:30F9  1E                                   push    ds
273F:30FA  07                                   pop     es
273F:30FB  B9 0156                              mov     cx,156h
273F:30FE  F3/ A5                               rep     movsw                   ; Rep when cx >0 Mov [si] to es:[di]
273F:3100  B9 0040                              mov     cx,40h

273F:3103                       locloop_650:                                    ;  xref 273F:3156
273F:3103  51                                   push    cx
273F:3104 BB 0DB5                              mov     bx, offset processed_vga_palette
273F:3107  B9 00E4                              mov     cx,0E4h

273F:310A                       locloop_651:                                    ;  xref 273F:3129
273F:310A  F6 07 3F                             test    byte ptr [bx],3Fh       ; '?'
273F:310D  74 03                                jz      loc_652                 ; Jump if zero
273F:310F  80 2F 01                             sub     byte ptr [bx],1
273F:3112                       loc_652:                                        ;  xref 273F:310D
273F:3112  F6 47 01 3F                          test    byte ptr [bx+1],3Fh     ; '?'
273F:3116  74 04                                jz      loc_653                 ; Jump if zero
273F:3118  80 6F 01 01                          sub     byte ptr [bx+1],1
273F:311C                       loc_653:                                        ;  xref 273F:3116
273F:311C  F6 47 02 3F                          test    byte ptr [bx+2],3Fh     ; '?'
273F:3120  74 04                                jz      loc_654                 ; Jump if zero
273F:3122  80 6F 02 01                          sub     byte ptr [bx+2],1
273F:3126                       loc_654:                                        ;  xref 273F:3120
273F:3126  83 C3 03                             add     bx,3
273F:3129  E2 DF                                loop    locloop_651             ; Loop if cx > 0

273F:312B  E8 002B                              call    wait_for_video_port     ; (3159)
273F:312E  56                                   push    si
273F:312F  32 C0                                xor     al,al                   ; Zero register
273F:3131  BA 03C8                              mov     dx,3C8h
273F:3134  EE                                   out     dx,al                   ; port 3C8h, VGA pel address
273F:3135  42                                   inc     dx
273F:3136 BE 0DB5                              mov     si, offset processed_vga_palette
273F:3139  B9 0156                              mov     cx,156h

273F:313C                       locloop_655:                                    ;  xref 273F:313E
273F:313C  AC                                   lodsb                           ; String [si] to al
273F:313D  EE                                   out     dx,al                   ; port 3C9h, VGA pel data reg
273F:313E  E2 FC                                loop    locloop_655             ; Loop if cx > 0

273F:3140  E8 0016                              call    wait_for_video_port     ; (3159)
273F:3143  B0 72                                mov     al,72h                  ; 'r'
273F:3145  BA 03C8                              mov     dx,3C8h
273F:3148  EE                                   out     dx,al                   ; port 3C8h, VGA pel address
273F:3149  42                                   inc     dx
273F:314A BE 0F0B                              mov     si, offset processed_vga_palette + 156h
273F:314D  B9 0156                              mov     cx,156h

273F:3150                       locloop_656:                                    ;  xref 273F:3152
273F:3150  AC                                   lodsb                           ; String [si] to al
273F:3151  EE                                   out     dx,al                   ; port 3C9h, VGA pel data reg
273F:3152  E2 FC                                loop    locloop_656             ; Loop if cx > 0

273F:3154  5E                                   pop     si
273F:3155  59                                   pop     cx
273F:3156  E2 AB                                loop    locloop_650             ; Loop if cx > 0

273F:3158  C3                                   retn
                             vga_fade_out       endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:312B, 3140, 31A5, 31BA, 3C86
                                ;

273F:3159              wait_for_video_port      proc    near
273F:3159  50                                   push    ax
273F:315A  06                                   push    es
273F:315B  52                                   push    dx
273F:315C  B8 0040                              mov     ax,40h
273F:315F  8E C0                                mov     es,ax
273F:3161  26: 8B 16 0063                       mov     dx,es:video_port        ; (0040:0063=3D4h)
273F:3166  80 C2 06                             add     dl,6
273F:3169                       loc_657:                                        ;  xref 273F:316C
273F:3169  EC                                   in      al,dx                   ; port 3DAh, CGA/EGA vid status
273F:316A  A8 08                                test    al,8
273F:316C  74 FB                                jz      loc_657                 ; Jump if zero
273F:316E                       loc_658:                                        ;  xref 273F:3171
273F:316E  EC                                   in      al,dx                   ; port 3DAh, CGA/EGA vid status
273F:316F  A8 08                                test    al,8
273F:3171  75 FB                                jnz     loc_658                 ; Jump if not zero
273F:3173  5A                                   pop     dx
273F:3174  07                                   pop     es
273F:3175  58                                   pop     ax
273F:3176  C3                                   retn
                       wait_for_video_port      endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called indircetly via calls to word ptr [fade_in_proc]
                                ;

                                vga_fade_in     proc    near
273F:3177  80 26 073C DF                        and     byte ptr ds:[73Ch],0DFh ; (273F:073C=17h)
273F:317C  1E                                   push    ds
273F:317D  07                                   pop     es
273F:317E BF 0DB5                              mov     di, offset processed_vga_palette
273F:3181  B9 0156                              mov     cx, 156h                ; Only first 228 palette entries used
273F:3184  33 C0                                xor     ax,ax                   ; Zero register
273F:3186  F3/ AB                               rep     stosw                   ; Rep when cx >0 Store ax to es:[di]

273F:3188 BE 0DB5                              mov     si, offset processed_vga_palette
273F:318B BF 1457                              mov     di, offset unprocessed_vga_palette
273F:318E  B9 0040                              mov     cx,40h                  ; Number of fade-in increments

273F:3191                       locloop_659:
273F:3191  51                                   push    cx
273F:3192  B9 02AC                              mov     cx,2ACh                 ; 228*3 (each paleete entry is 3 bytes)
273F:3195  33 DB                                xor     bx,bx
; Update the RGB components of each palette entry by 1 unless a colour has already reached it's final value
273F:3197                       locloop_660:
273F:3197  8A 00                                mov     al,[bx+si]              ; Get in current palette intensity
273F:3199  3A 01                                cmp     al,[bx+di]              ; Has it reached final intensity?
273F:319B  74 03                                je      loc_661                 ; Jump if equal
273F:319D  80 00 01                             add     byte ptr [bx+si],1      ; Increment the intensity
273F:31A0                       loc_661:
273F:31A0  83 C3 01                             add     bx,1
273F:31A3  E2 F2                                loop    locloop_660             ; Loop if cx > 0

273F:31A5  E8 FFB1                              call    wait_for_video_port     ; (3159)
273F:31A8  56                                   push    si
273F:31A9  32 C0                                xor     al,al                   ; Zero register
273F:31AB  BA 03C8                              mov     dx,3C8h
273F:31AE  EE                                   out     dx,al                   ; port 3C8h, VGA pel address
273F:31AF  42                                   inc     dx
; Output the first half ot the new set of palette entries
273F:31B0 BE 0DB5                              mov     si,0DB5h                ; (273F:0DB5=0C7h)
273F:31B3  B9 0156                              mov     cx,156h
273F:31B6                       locloop_662:                                    ;  xref 273F:31B8
273F:31B6  AC                                   lodsb                           ; String [si] to al
273F:31B7  EE                                   out     dx,al                   ; port 3C9h, VGA pel data reg
273F:31B8  E2 FC                                loop    locloop_662             ; Loop if cx > 0

273F:31BA  E8 FF9C                              call    wait_for_video_port     ; (3159)
273F:31BD  B0 72                                mov     al,72h                  ; 'r'
273F:31BF  BA 03C8                              mov     dx,3C8h
273F:31C2  EE                                   out     dx,al                   ; port 3C8h, VGA pel address
273F:31C3  42                                   inc     dx

; Output the second half ot the new set of palette entries
273F:31C4 BE 0F0B                              mov     si, offset processed_vga_palette + 156h
273F:31C7  B9 0156                              mov     cx,156h
273F:31CA                       locloop_663:                                    ;  xref 273F:31CC
273F:31CA  AC                                   lodsb                           ; String [si] to al
273F:31CB  EE                                   out     dx,al                   ; port 3C9h, VGA pel data reg
273F:31CC  E2 FC                                loop    locloop_663             ; Loop if cx > 0

; Loop for remaining increments of fade-in sequence
273F:31CE  5E                                   pop     si
273F:31CF  59                                   pop     cx
273F:31D0  E2 BF                                loop    locloop_659             ; Loop if cx > 0

273F:31D2  C3                                   retn
                                vga_fade_in     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:312B, 3140, 31A5, 31BA, 3C86
                                ;

                        vga_set_lower_palette   proc    near

273F:31D3  80 26 073C DF                        and     byte ptr ds:[73Ch],0DFh ; (273F:073C=17h)
273F:31D8  1E                                   push    ds
273F:31D9  07                                   pop     es
273F:31DA BA 1457                              mov     dx,offset unprocessed_vga_palette
273F:31DD  B8 1012                              mov     ax,1012h
273F:31E0  BB 0000                              mov     bx,0
273F:31E3  B9 00E4                              mov     cx,0E4h
273F:31E6  CD 10                                int     10h                     ; Video display   ah=functn 10h
                                                                                ;  set cx color registers from
                                                                                ;   ptr es:dx, bx=first reg
273F:31E8  C3                                   retn

                        vga_set_lower_palette   endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:312B, 3140, 31A5, 31BA, 3C86
                                ;

                          vga_empty_palette     proc    near

273F:31E9  80 0E 073C 20                        or      byte ptr ds:[73Ch],20h
273F:31EE  1E                                   push    ds
273F:31EF  07                                   pop     es
273F:31F0 BF 0DB5                              mov     di, offset processed_vga_palette
273F:31F3  B9 0156                              mov     cx,156h
273F:31F6  33 C0                                xor     ax,ax                   ; Zero register
273F:31F8  F3/ AB                               rep     stosw                   ; Rep when cx >0 Store ax to es:[di]
273F:31FA BA 0DB5                              mov     dx, offset processed_vga_palette
273F:31FD  B8 1012                              mov     ax,1012h
273F:3200  BB 0000                              mov     bx,0
273F:3203  B9 00E4                              mov     cx,0E4h
273F:3206  CD 10                                int     10h                     ; Video display   ah=functn 10h
                                                                                ;  set cx color registers from
                                                                                ;   ptr es:dx, bx=first reg
273F:3208  C3                                   retn

                          vga_empty_palette     endp

                     vga_display2_character     proc    near
273F:3209  1E                                   push    ds
273F:320A  57                                   push    di
273F:320B  56                                   push    si
273F:320C  98                                   cbw                             ; Convrt byte to word
273F:320D  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:320F  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:3211  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:3213  8B F0                                mov     si,ax
273F:3215  8B 16 4CF0                           mov     dx, font2_segment
273F:3219  8E DA                                mov     ds,dx
273F:321B  AC                                   lodsb                           ; String [si] to al
273F:321C  32 E4                                xor     ah,ah                   ; Zero register
273F:321E  50                                   push    ax
273F:321F  B2 07                                mov     dl,7
273F:3221                       loc_664:                                        ;  xref 273F:3239
273F:3221  AC                                   lodsb                           ; String [si] to al
273F:3222  B9 0008                              mov     cx,8

273F:3225                       locloop_665:                                    ;  xref 273F:322F
273F:3225  D0 E0                                shl     al,1                    ; Shift w/zeros fill
273F:3227  73 03                                jnc     loc_666                 ; Jump if carry=0
273F:3229  26: 88 3D                            mov     es:[di],bh
273F:322C                       loc_666:                                        ;  xref 273F:3227
273F:322C  83 C7 01                             add     di,1
273F:322F  E2 F4                                loop    locloop_665             ; Loop if cx > 0

273F:3231  03 FD                                add     di,bp
273F:3233  83 EF 08                             sub     di,8
273F:3236  80 EA 01                             sub     dl,1
273F:3239  75 E6                                jnz     loc_664                 ; Jump if not zero
273F:323B  58                                   pop     ax
273F:323C  5E                                   pop     si
273F:323D  5F                                   pop     di
273F:323E  1F                                   pop     ds
273F:323F  03 F8                                add     di,ax
273F:3241  C3                                   retn
                     vga_display2_character     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                            vga_talk_dialog     proc    near
273F:3242  1E                                   push    ds
273F:3243  A1 11C0                              mov     ax, talk_dialog_top
273F:3246  50                                   push    ax
273F:3247  05 0008                              add     ax, 8
273F:324A  8B D0                                mov     dx, ax
273F:324C  D1 E2                                shl     dx, 1                   ; Shift w/zeros fill
273F:324E  D1 E2                                shl     dx, 1                   ; Shift w/zeros fill
273F:3250  03 C2                                add     ax, dx
273F:3252  B1 06                                mov     cl, 6
273F:3254  D3 E0                                shl     ax, cl                  ; Shift w/zeros fill
273F:3256  8B F8                                mov     di, ax
273F:3258  03 3E 11C2                           add     di, talk_dialog_left
273F:325C  B8 0007                              mov     ax, 7
273F:325F  F7 26 B9FD                           mul     data_1122               ; dx:ax = data * ax
273F:3263  05 0013                              add     ax, 19                  ; Number of lines?
273F:3266  8B D0                                mov     dx, ax
273F:3268  A1 4CE4                              mov     ax, data_segment2
273F:326B  8E C0                                mov     es, ax
273F:326D  A1 4CE6                              mov     ax, talk_dialog_buffer
273F:3270  8E D8                                mov     ds, ax
273F:3272 BE 0000                              mov     si, 0
273F:3275                       loc_667:                                        ;  xref 273F:3281
273F:3275  B9 0040                              mov     cx, TALK_DIALOG_WIDTH/2
273F:3278  F3/ A5                               rep     movsw                   ; Rep when cx >0 Mov [si] to es:[di]
273F:327A  81 C7 00C0                           add     di, FULL_SCREEN_WIDTH-TALK_DIALOG_WIDTH 
273F:327E  80 EA 01                             sub     dl, 1
273F:3281  75 F2                                jnz     loc_667                 ; Jump if not zero
273F:3283  5B                                   pop     bx
273F:3284  1F                                   pop     ds
273F:3285  8B 16 11C6                           mov     dx, talk_dialog_height
273F:3289  A1 11C2                              mov     ax, talk_dialog_left
273F:328C  BD 0080                              mov     bp, 80h
273F:328F  B1 01                                mov     cl, 1
273F:3291  E8 D8FB                              call    sub_22                  ; Specify non-redraw area
273F:3294  C3                                   retn
                            vga_talk_dialog     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ; Called by the table entry [draw_dialog_proc]
                                ;
; DL = number of lines?
;???? Not sure about this method.

                               vga_draw_dialog  proc    near

273F:3295  32 E4                                xor     ah,ah                   ; Zero register
273F:3297  32 FF                                xor     bh,bh                   ; Zero register
273F:3299  32 ED                                xor     ch,ch                   ; Zero register
273F:329B  32 F6                                xor     dh,dh                   ; Zero register
273F:329D  52                                   push    dx
273F:329E  51                                   push    cx
273F:329F  53                                   push    bx
273F:32A0  50                                   push    ax
273F:32A1  8A EA                                mov     ch,dl
273F:32A3  93                                   xchg    bx,ax
273F:32A4  32 E4                                xor     ah,ah                   ; Zero register
273F:32A6  BA 0A00                              mov     dx,0A00h
273F:32A9  F7 E2                                mul     dx                      ; dx:ax = reg * ax
273F:32AB  2D 03C0                              sub     ax,3C0h
273F:32AE  3D 0640                              cmp     ax,640h
273F:32B1  75 03                                jne     loc_668                 ; Jump if not equal
273F:32B3  05 03C0                              add     ax,3C0h
273F:32B6                       loc_668:                                        ;  xref 273F:32B1
273F:32B6  32 FF                                xor     bh,bh                   ; Zero register
273F:32B8  D1 E3                                shl     bx,1                    ; Shift w/zeros fill
273F:32BA  D1 E3                                shl     bx,1                    ; Shift w/zeros fill
273F:32BC  D1 E3                                shl     bx,1                    ; Shift w/zeros fill
273F:32BE  03 C3                                add     ax,bx
273F:32C0  2D 0003                              sub     ax,3
273F:32C3  8B F8                                mov     di,ax
273F:32C5  A1 4CE4                              mov     ax, data_segment2
273F:32C8  8E C0                                mov     es,ax
273F:32CA  8A D9                                mov     bl,cl
273F:32CC  32 FF                                xor     bh,bh                   ; Zero register
273F:32CE  D1 E3                                shl     bx,1                    ; Shift w/zeros fill
273F:32D0  D1 E3                                shl     bx,1                    ; Shift w/zeros fill
273F:32D2  D1 E3                                shl     bx,1                    ; Shift w/zeros fill
273F:32D4  83 C3 04                             add     bx,4
273F:32D7  8A D5                                mov     dl,ch
273F:32D9  32 F6                                xor     dh,dh                   ; Zero register
273F:32DB  8B C2                                mov     ax,dx
273F:32DD  D1 E2                                shl     dx,1                    ; Shift w/zeros fill
273F:32DF  D1 E2                                shl     dx,1                    ; Shift w/zeros fill
273F:32E1  D1 E2                                shl     dx,1                    ; Shift w/zeros fill
273F:32E3  F7 C5 FFFF                           test    bp,0FFFFh
273F:32E7  75 02                                jnz     loc_669                 ; Jump if not zero
273F:32E9  2B D0                                sub     dx,ax
273F:32EB                       loc_669:                                        ;  xref 273F:32E7
273F:32EB  83 C2 05                             add     dx,5
273F:32EE  E8 001A                              call    draw_dialog_frame
273F:32F1  58                                   pop     ax
273F:32F2  2D 0001                              sub     ax,1
273F:32F5  5B                                   pop     bx
273F:32F6  83 EB 02                             sub     bx,2
273F:32F9  73 02                                jnc     loc_670                 ; Jump if carry=0
273F:32FB  33 DB                                xor     bx,bx                   ; Zero register
273F:32FD                       loc_670:                                        ;  xref 273F:32F9
273F:32FD  5D                                   pop     bp
273F:32FE  83 C5 04                             add     bp,4
273F:3301  5A                                   pop     dx
273F:3302  83 C2 04                             add     dx,4
273F:3305  B1 81                                mov     cl,81h
273F:3307  E8 D879                              call    sub_21                  ; (0B83)
273F:330A  C3                                   retn

                               vga_draw_menu    endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:32EE, 339D
                                ;

273F:330B                draw_dialog_frame      proc    near
273F:330B  1E                                   push    ds
273F:330C  B8 44EA                              mov     ax, dialog_segment
273F:330F  8E D8                                mov     ds,ax
273F:3311  33 F6                                xor     si,si                   ; Zero register
273F:3313  BD 0009                              mov     bp,9
273F:3316                       loc_671:                                        ;  xref 273F:3331
273F:3316  57                                   push    di
273F:3317  B9 0007                              mov     cx,7
273F:331A  F3/ A4                               rep     movsb                   ; Rep when cx >0 Mov [si] to es:[di]
273F:331C  AC                                   lodsb                           ; String [si] to al
273F:331D  8B CB                                mov     cx,bx
273F:331F  83 C1 02                             add     cx,2
273F:3322  F3/ AA                               rep     stosb                   ; Rep when cx >0 Store al to es:[di]
273F:3324  B9 0009                              mov     cx,9
273F:3327  F3/ A4                               rep     movsb                   ; Rep when cx >0 Mov [si] to es:[di]
273F:3329  5F                                   pop     di
273F:332A 81 C7 0140                           add     di, SCREEN_WIDTH
273F:332E  83 ED 01                             sub     bp,1
273F:3331  75 E3                                jnz     loc_671                 ; Jump if not zero
273F:3333                       loc_672:                                        ;  xref 273F:334D
273F:3333  56                                   push    si
273F:3334  57                                   push    di
273F:3335  B9 0009                              mov     cx,9
273F:3338  F3/ A4                               rep     movsb                   ; Rep when cx >0 Mov [si] to es:[di]
273F:333A  AC                                   lodsb                           ; String [si] to al
273F:333B  8B CB                                mov     cx,bx
273F:333D  F3/ AA                               rep     stosb                   ; Rep when cx >0 Store al to es:[di]
273F:333F  B9 0009                              mov     cx,9
273F:3342  F3/ A4                               rep     movsb                   ; Rep when cx >0 Mov [si] to es:[di]
273F:3344  5F                                   pop     di
273F:3345  5E                                   pop     si
273F:3346 81 C7 0140                           add     di, SCREEN_WIDTH
273F:334A  83 EA 01                             sub     dx,1
273F:334D  75 E4                                jnz     loc_672                 ; Jump if not zero
273F:334F  83 C6 13                             add     si,13h
273F:3352  BD 0009                              mov     bp,9
273F:3355                       loc_673:                                        ;  xref 273F:3370
273F:3355  57                                   push    di
273F:3356  B9 0009                              mov     cx,9
273F:3359  F3/ A4                               rep     movsb                   ; Rep when cx >0 Mov [si] to es:[di]
273F:335B  AC                                   lodsb                           ; String [si] to al
273F:335C  8B CB                                mov     cx,bx
273F:335E  83 C1 01                             add     cx,1
273F:3361  F3/ AA                               rep     stosb                   ; Rep when cx >0 Store al to es:[di]
273F:3363  B9 0008                              mov     cx,8
273F:3366  F3/ A4                               rep     movsb                   ; Rep when cx >0 Mov [si] to es:[di]
273F:3368  5F                                   pop     di
273F:3369  81 C7 0140                           add     di, SCREEN_WIDTH
273F:336D  83 ED 01                             sub     bp,1
273F:3370  75 E3                                jnz     loc_673                 ; Jump if not zero
273F:3372  1F                                   pop     ds
273F:3373  C3                                   retn

                         draw_dialog_frame      endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

273F:3374  32 FF                                xor     bh, bh
273F:3376  32 F6                                xor     dh, dh
273F:3378  BF 62C0                              mov     di, 62C0h
273F:337B  B9 004E                              mov     cx, 4Eh
273F:337E  8B C2                                mov     ax, dx
273F:3380  2D 0001                              sub     ax, 1
273F:3383  74 0C                                jz      loc_675                 ; Jump if zero
273F:3385  81 EF 0A00                           sub     di,0A00h
273F:3389  83 E9 08                             sub     cx,8
273F:338C  80 C2 01                             add     dl,1
273F:338F  EB EF                                jmp     short loc_674           ; (3380)
273F:3391                       loc_675:                                        ;  xref 273F:3383
273F:3391  51                                   push    cx
273F:3392  B1 03                                mov     cl,3
273F:3394  D3 E3                                shl     bx,cl                   ; Shift w/zeros fill
273F:3396  D3 E2                                shl     dx,cl                   ; Shift w/zeros fill
273F:3398  83 EB 01                             sub     bx,1
273F:339B  53                                   push    bx
273F:339C  52                                   push    dx
273F:339D  E8 FF6B                              call    draw_dialog_frame
273F:33A0  33 C0                                xor     ax,ax                   ; Zero register
273F:33A2  5A                                   pop     dx
273F:33A3  5D                                   pop     bp
273F:33A4  5B                                   pop     bx
273F:33A5  83 EB 08                             sub     bx,8
273F:33A8  83 C5 12                             add     bp,12h
273F:33AB  83 C2 14                             add     dx,14h
273F:33AE  B1 81                                mov     cl,81h
273F:33B0  E9 D7DC                              jmp     loc_93                  ; (0B8F)

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                       vga_draw_talk_dialog     proc    near
273F:33B3  8B C5                                mov     ax,bp
273F:33B5  D1 E5                                shl     bp,1                    ; Shift w/zeros fill
273F:33B7  D1 E5                                shl     bp,1                    ; Shift w/zeros fill
273F:33B9  D1 E5                                shl     bp,1                    ; Shift w/zeros fill
273F:33BB  2B E8                                sub     bp,ax
273F:33BD  83 C5 0D                             add     bp,0Dh
273F:33C0  89 2E 11C6                           mov     talk_dialog_height, bp
273F:33C4  83 06 11C6 12                        add     talk_dialog_height, 12h
273F:33C9  C7 06 11C4 0080                      mov     talk_dialog_width, TALK_DIALOG_WIDTH
273F:33CF  1E                                   push    ds
273F:33D0  B8 44FF                              mov     ax, vga_talk_frame_seg
273F:33D3  8E D8                                mov     ds,ax
273F:33D5  33 F6                                xor     si,si                   ; Zero register

273F:33D7  BA 0003                              mov     dx,3                    ; First three lines

273F:33DA                       loc_676:
273F:33DA  A5                                   movsw                           ; Mov [si] to es:[di]
273F:33DB  AC                                   lodsb                           ; String [si] to al
273F:33DC  B9 007B                              mov     cx,7Bh
273F:33DF  F3/ AA                               rep     stosb                   ; Rep when cx >0 Store al to es:[di]
273F:33E1  A5                                   movsw                           ; Mov [si] to es:[di]
273F:33E2  A4                                   movsb                           ; Mov [si] to es:[di]
273F:33E3  83 EA 01                             sub     dx,1
273F:33E6  75 F2                                jnz     loc_676                 ; Jump if not zero
273F:33E8                       loc_677:                                        ;  xref 273F:33F7
273F:33E8  56                                   push    si
273F:33E9  A5                                   movsw                           ; Mov [si] to es:[di]
273F:33EA  A4                                   movsb                           ; Mov [si] to es:[di]
273F:33EB  AC                                   lodsb                           ; String [si] to al
273F:33EC  B9 007A                              mov     cx,7Ah
273F:33EF  F3/ AA                               rep     stosb                   ; Rep when cx >0 Store al to es:[di]
273F:33F1  A5                                   movsw                           ; Mov [si] to es:[di]
273F:33F2  A4                                   movsb                           ; Mov [si] to es:[di]
273F:33F3  5E                                   pop     si
273F:33F4  83 ED 01                             sub     bp,1
273F:33F7  75 EF                                jnz     loc_677                 ; Jump if not zero
273F:33F9  83 C6 07                             add     si,7
273F:33FC  BA 0003                              mov     dx,3
273F:33FF                       loc_678:                                        ;  xref 273F:340B
273F:33FF  A5                                   movsw                           ; Mov [si] to es:[di]
273F:3400  A4                                   movsb                           ; Mov [si] to es:[di]
273F:3401  AC                                   lodsb                           ; String [si] to al
273F:3402  B9 007B                              mov     cx,7Bh
273F:3405  F3/ AA                               rep     stosb                   ; Rep when cx >0 Store al to es:[di]
273F:3407  A5                                   movsw                           ; Mov [si] to es:[di]
273F:3408  83 EA 01                             sub     dx,1
273F:340B  75 F2                                jnz     loc_678                 ; Jump if not zero
273F:340D  1F                                   pop     ds
273F:340E  C3                                   retn
                       vga_draw_talk_dialog     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                  vga_show_compressed_screen    proc    near

273F:340F BB 07DC                              mov     bx, offset display_mask
273F:3412  A1 4CE4                              mov     ax, data_segment2
273F:3415  8E C0                                mov     es,ax
273F:3417 BF 0A00                              mov     di,data_1463e           ; (FF12:0A00=0)
273F:341A  8B 16 4CE0                           mov     dx, current_room_segment
273F:341E  33 F6                                xor     si,si                   ; Zero register
273F:3420  B5 06                                mov     ch,6
273F:3422                       loc_679:                                        ;  xref 273F:3465
273F:3422  B1 0A                                mov     cl, NUM_HORIZ_RECTS
273F:3424                       loc_680:                                        ; Screen horizontal loop
273F:3424  F6 07 80                             test    byte ptr [bx],80h       ; Does rect need displaying?
273F:3427  74 23                                jz      loc_683                 ; If not then skip
273F:3429  80 27 7F                             and     byte ptr [bx],7Fh       ; Clear displayed bit
273F:342C  80 0F 01                             or      byte ptr [bx],1
273F:342F  57                                   push    di
273F:3430  56                                   push    si
273F:3431  1E                                   push    ds
273F:3432  8E DA                                mov     ds,dx

273F:3434  B6 20                                mov     dh, RECT_SIZE
273F:3436                       loc_681:                                        ; Vertical loop
273F:3436  B2 10                                mov     dl, RECT_SIZE/2
273F:3438                       loc_682:                                        ; Horizontal loop
273F:3438  A5                                   movsw                           ; Mov [si] to es:[di]
273F:3439  80 EA 01                             sub     dl,1
273F:343C  75 FA                                jnz     loc_682                 ; End of horizontal loop

273F:343E  81 C7 0120                           add     di, SCREEN_WIDTH-RECT_SIZE
273F:3442  80 EE 01                             sub     dh,1
273F:3445  75 EF                                jnz     loc_681                 ; End of vertical loop

273F:3447  8C DA                                mov     dx,ds
273F:3449  1F                                   pop     ds
273F:344A  5E                                   pop     si
273F:344B  5F                                   pop     di
273F:344C                       loc_683:                                        ;  xref 273F:3427
273F:344C  83 C3 01                             add     bx,1
273F:344F  83 C7 20                             add     di, RECT_SIZE           ; Next horizontal rect
273F:3452  81 C6 0400                           add     si, RECT_SIZE*RECT_SIZE ; Move to data for next src rect
273F:3456  80 E9 01                             sub     cl,1
273F:3459  75 C9                                jnz     loc_680                 ; Jump if not zero

273F:345B  83 C3 08                             add     bx,8
273F:345E 81 C7 26C0                           add     di,26C0h                ; (273F:26C0=0EDh)
273F:3462  80 ED 01                             sub     ch,1
273F:3465  75 BB                                jnz     loc_679                 ; Jump if not zero
273F:3467  80 0E 11D0 30                        or      menubar_state, 30h ; (273F:11D0=56h) '0'
273F:346C  C3                                   retn

                  vga_show_compressed_screen    endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;
                  
273F:346D BE 0992                              mov     si, offset rects_layer_0
273F:3470  83 C6 4C                             add     si,4Ch
273F:3473  C7 06 0DA6 0D92                      mov     rect_x_start, room_layers
273F:3479  C7 06 0DAA 0D96                      mov     num_horiz_rects, 0D96h
273F:347F  B9 0003                              mov     cx,3
273F:3482                       loc_684:                                        ;  xref 273F:3523
273F:3482 51                                   push    cx
273F:3483 BB 0100                              mov     bx,100h                 ; (273F:0100=6)
273F:3486                       loc_685:                                        ;  xref 273F:3509
273F:3486 51                                   push    cx
273F:3487  56                                   push    si
273F:3488  8B 3E 0DA6                           mov     di, rect_x_start
273F:348C  8B 05                                mov     ax,[di]
273F:348E  8E C0                                mov     es,ax
273F:3490  8B 45 02                             mov     ax,[di+2]
273F:3493  A3 0DA8                              mov     rect_y_end, ax
273F:3496  8B 3E 0DAA                           mov     di, num_horiz_rects
273F:349A  8B 05                                mov     ax,[di]
273F:349C  8B D0                                mov     dx,ax
273F:349E  8B 45 02                             mov     ax,[di+2]
273F:34A1  A3 0DAC                              mov     word ptr ds:[0DACh],ax  ; (273F:0DAC=0EB09h)
273F:34A4  B5 06                                mov     ch,6
273F:34A6                       loc_686:                                        ;  xref 273F:34F8
273F:34A6  B1 0A                                mov     cl,0Ah
273F:34A8                       loc_687:                                        ;  xref 273F:34F0
273F:34A8  F6 04 80                             test    byte ptr [si],80h
273F:34AB  75 3D                                jnz     loc_690                 ; Jump if not zero
273F:34AD  F6 00 80                             test    byte ptr [bx+si],80h
273F:34B0  75 38                                jnz     loc_690                 ; Jump if not zero
273F:34B2  56                                   push    si
273F:34B3  52                                   push    dx
273F:34B4  8A 04                                mov     al,[si]
273F:34B6  32 E4                                xor     ah,ah                   ; Zero register
273F:34B8  F7 26 0DA8                           mul     rect_y_end
273F:34BC  8B F8                                mov     di,ax
273F:34BE  8A 00                                mov     al,[bx+si]
273F:34C0  32 E4                                xor     ah,ah                   ; Zero register
273F:34C2  F7 26 0DAC                           mul     word ptr ds:[0DACh]     ; (273F:0DAC=0EB09h) dx:ax = data * ax
273F:34C6  8B F0                                mov     si,ax
273F:34C8  5A                                   pop     dx
273F:34C9  1E                                   push    ds
273F:34CA  51                                   push    cx
273F:34CB  53                                   push    bx
273F:34CC  8E DA                                mov     ds,dx
273F:34CE  B9 0400                              mov     cx,400h
273F:34D1  8B DE                                mov     bx,si
273F:34D3  81 C3 0200                           add     bx,200h

273F:34D7                       locloop_688:                                    ;  xref 273F:34E2
273F:34D7  AC                                   lodsb                           ; String [si] to al
273F:34D8  0A C0                                or      al,al                   ; Zero ?
273F:34DA  74 03                                jz      loc_689                 ; Jump if zero
273F:34DC  26: 88 05                            mov     es:[di],al
273F:34DF                       loc_689:                                        ;  xref 273F:34DA
273F:34DF  83 C7 01                             add     di,1
273F:34E2  E2 F3                                loop    locloop_688             ; Loop if cx > 0

273F:34E4  5B                                   pop     bx
273F:34E5  59                                   pop     cx
273F:34E6  8C DA                                mov     dx,ds
273F:34E8  1F                                   pop     ds
273F:34E9  5E                                   pop     si
273F:34EA                       loc_690:                                        ;  xref 273F:34AB, 34B0
273F:34EA  83 C6 01                             add     si,1
273F:34ED  80 E9 01                             sub     cl,1
273F:34F0  75 B6                                jnz     loc_687                 ; Jump if not zero
273F:34F2  83 C6 08                             add     si,8
273F:34F5  80 ED 01                             sub     ch,1
273F:34F8  75 AC                                jnz     loc_686                 ; Jump if not zero
273F:34FA  83 06 0DAA 04                        add     num_horiz_rects, 4
273F:34FF  81 C3 0100                           add     bx,100h
273F:3503  5E                                   pop     si
273F:3504  59                                   pop     cx
273F:3505  E2 02                                loop    locloop_691             ; Loop if cx > 0

273F:3507  EB 03                                jmp     short loc_692           ; (350C)

273F:3509                       locloop_691:                                    ;  xref 273F:3505
273F:3509  E9 FF7A                              jmp     loc_685                 ; (3486)
273F:350C                       loc_692:                                        ;  xref 273F:3507
273F:350C  59                                   pop     cx
273F:350D  E2 02                                loop    locloop_693             ; Loop if cx > 0

273F:350F  EB 15                                jmp     short loc_ret_694       ; (3526)

273F:3511                       locloop_693:                                    ;  xref 273F:350D
273F:3511  81 C6 0100                           add     si,100h
273F:3515  83 06 0DA6 04                        add     rect_x_start, 4
273F:351A  A1 0DA6                              mov     ax, rect_x_start
273F:351D  05 0004                              add     ax,4
273F:3520  A3 0DAA                              mov     num_horiz_rects, ax
273F:3523  E9 FF5C                              jmp     loc_684                 ; (3482)

273F:3526                       loc_ret_694:                                    ;  xref 273F:350F
273F:3526  C3                                   retn

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;  es:di = pointer to decoded screen
                                ;     bx = buffer to store status of each screen rectangle
                                ;     cl = layer number (0 to 3)
                                ;

                         vga_segment_screen     proc    near
273F:3527  88 0E 0DA5                           mov     current_layer, cl
273F:352B  C6 06 0DA4 00                        mov     num_occupied_rects, 0
273F:3530  C7 06 0DA2 0400                      mov     rectangle_size, RECTANGLE_SIZE
273F:3536  33 F6                                xor     si, si                  ; Zero register
273F:3538  B5 06                                mov     ch, NUM_VERT_RECTS
273F:353A                       loc_695:
273F:353A  B1 0A                                mov     cl, NUM_HORIZ_RECTS
273F:353C                       loc_696:
273F:353C  1E                                   push    ds
273F:353D  51                                   push    cx
273F:353E  56                                   push    si
273F:353F  57                                   push    di
273F:3540  A1 4CE4                              mov     ax, data_segment2
273F:3543  8E D8                                mov     ds,ax
273F:3545  E8 003A                              call    copy_rectangle
273F:3548  5F                                   pop     di
273F:3549  5E                                   pop     si
273F:354A  59                                   pop     cx
273F:354B  1F                                   pop     ds
273F:354C  F6 06 0DA5 FF                        test    current_layer, 0FFh     ; Background layer?
273F:3551  74 09                                jz      loc_697                 ; If yes, ignore empty check
273F:3553  0B D2                                or      dx,dx                   ; Was rectangle non-empty?
273F:3555  75 05                                jnz     loc_697                 ; If yes, then jump
273F:3557  C6 07 FF                             mov     byte ptr [bx], 0FFh     ; Flag rect as empty
273F:355A  EB 0E                                jmp     short loc_698
273F:355C                       loc_697:
273F:355C  03 3E 0DA2                           add     di, rectangle_size
273F:3560  A0 0DA4                              mov     al, num_occupied_rects
273F:3563  88 07                                mov     [bx], al
273F:3565  80 06 0DA4 01                        add     num_occupied_rects, 1
273F:356A                       loc_698:                                        ;  xref 273F:355A
273F:356A  83 C6 20                             add     si, RECT_SIZE           ; Move to next src rect
273F:356D  83 C3 01                             add     bx, 1
273F:3570  80 E9 01                             sub     cl, 1
273F:3573  75 C7                                jnz     loc_696                 ; Loop for horiz rects
273F:3575 81 C6 26C0                           add     si, (RECT_SIZE-1) * SCREEN_WIDTH
273F:3579  83 C3 08                             add     bx, 8
273F:357C  80 ED 01                             sub     ch, 1
273F:357F  75 B9                                jnz     loc_695                 ; Loop for vert rects
273F:3581  C3                                   retn
                         vga_segment_screen     endp
                             
                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:3545
                                ;

273F:3582               copy_rectangle          proc    near
273F:3582  33 D2                                xor     dx,dx                   ; Zero register
273F:3584  B9 0020                              mov     cx, 32

273F:3587                       locloop_699:                                    ;  xref 273F:3596
273F:3587  51                                   push    cx
273F:3588  B9 0010                              mov     cx, 32/2

273F:358B                       locloop_700:                                    ; Horizontal loop
273F:358B  AD                                   lodsw
273F:358C  0B D0                                or      dx, ax
273F:358E  AB                                   stosw                           ; Store ax to es:[di]
273F:358F  E2 FA                                loop    locloop_700             ; Loop if cx > 0

273F:3591  81 C6 0120                           add     si, 320 - 32            ; Move to next line
273F:3595  59                                   pop     cx
273F:3596  E2 EF                                loop    locloop_699             ; Vertical loop

273F:3598  C3                                   retn
                        copy_rectangle          endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ; ax = Y rect, dx = x rect, bp = current layer num
                                ; bx = rect mapping index
                                ;

                               vga_add_rect     proc    near
273F:3599  8B CD                                mov     cx, bp
273F:359B                       locloop_701:                                    ;  xref 273F:35A7
273F:359B  80 39 FE                             cmp     byte ptr [bx+di],0FEh
273F:359E  72 0A                                jb      loc_702                 ; Jump if below
273F:35A0 81 C7 0100                           add     di, 100h
273F:35A4  83 C6 04                             add     si, 4
273F:35A7  E2 F2                                loop    locloop_701             ; Loop if cx > 0

273F:35A9  C3                                   retn
273F:35AA                       loc_702:                                        ;  xref 273F:359E
273F:35AA  1E                                   push    ds
273F:35AB  52                                   push    dx
273F:35AC  8B D0                                mov     dx, ax                  ; dx = y rect
273F:35AE  D1 E0                                shl     ax, 1                   ; ax=y*2
273F:35B0  D1 E0                                shl     ax, 1                   ; ax=y*4
273F:35B2  03 D0                                add     dx, ax                  ; dx=y*5
273F:35B4  B1 0B                                mov     cl, 11
273F:35B6  D3 E2                                shl     dx,cl                   ; dx=y*(32*320)
273F:35B8  81 C2 0A00                           add     dx, MENUBAR_BLOCK_SIZE  ; dx =Y start on screen
273F:35BC  58                                   pop     ax                      ; ax = x rect
273F:35BD  B1 05                                mov     cl,5
273F:35BF  D3 E0                                shl     ax,cl                   ; ax=x*32
273F:35C1  03 D0                                add     dx,ax                   ; dx=start pos on screen

273F:35C3  8A 01                                mov     al, [bx+di]             ; get cell status
273F:35C5  8B 1E 4CE4                           mov     bx, data_segment2
273F:35C9  8E C3                                mov     es,bx
273F:35CB  8B 1C                                mov     bx, [si]                ; Get segment for layer to use
273F:35CD  8E DB                                mov     ds, bx                  ; ds = source data
273F:35CF  8B FA                                mov     di, dx                  ; es:di = destination
273F:35D1  32 E4                                xor     ah, ah
273F:35D3  B1 0A                                mov     cl, 10
273F:35D5  D3 E0                                shl     ax, cl                  ; ax=cell status*1024
273F:35D7  8B F0                                mov     si, ax

273F:35D9  B9 0020                              mov     cx, 32                  ; Number of rows

273F:35DC                       locloop_703:                                    ;  xref 273F:35F2
273F:35DC  51                                   push    cx
273F:35DD  B9 0020                              mov     cx, 32                  ; Set pixel width

273F:35E0                       locloop_704:
273F:35E0  AC                                   lodsb                           ; Get next pixel
273F:35E1  0A C0                                or      al,al                   ; Zero (transparent)?
273F:35E3  74 03                                jz      loc_705                 ; If yes, then skip
273F:35E5  26: 88 05                            mov     es:[di],al              ; Store pixel
273F:35E8                       loc_705:
273F:35E8  83 C7 01                             add     di,1                    ; Move to next dest pos
273F:35EB  E2 F3                                loop    locloop_704

273F:35ED 81 C7 0120                           add     di, 320 - 32            ; Move to next line of rect
273F:35F1  59                                   pop     cx
273F:35F2  E2 E8                                loop    locloop_703             ; Loop remaining lines

273F:35F4  1F                                   pop     ds
273F:35F5  C3                                   retn
                               vga_add_rect     endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                      vga_display_character     proc    near

273F:35F6  57                                   push    di
273F:35F7  1E                                   push    ds
273F:35F8  53                                   push    bx
273F:35F9  51                                   push    cx
273F:35FA  56                                   push    si
273F:35FB  8E DD                                mov     ds,bp
273F:35FD  2C 20                                sub     al,20h                  ; ' '
273F:35FF  32 E4                                xor     ah,ah                   ; Zero register
273F:3601  B1 03                                mov     cl,3
273F:3603  D3 E0                                shl     ax,cl                   ; Shift w/zeros fill
273F:3605  8B F0                                mov     si,ax
273F:3607  B3 08                                mov     bl,8                    ; Number of rows
273F:3609                       loc_706:
273F:3609  B9 0008                              mov     cx,8
273F:360C  AC                                   lodsb                           ; String [si] to al

273F:360D                       locloop_707:                                    ;  xref 273F:361C
273F:360D  D0 E0                                shl     al,1                    ; Shift w/zeros fill
273F:360F  72 05                                jc      loc_708                 ; Jump if carry Set
273F:3611  26: 88 15                            mov     es:[di],dl
273F:3614  EB 03                                jmp     short loc_709           ; (3619)
273F:3616                       loc_708:                                        ;  xref 273F:360F
273F:3616  26: 88 35                            mov     es:[di],dh
273F:3619                       loc_709:                                        ;  xref 273F:3614
273F:3619  83 C7 01                             add     di,1
273F:361C  E2 EF                                loop    locloop_707             ; Loop if cx > 0

273F:361E 81 C7 0138                           add     di,data_1445e           ; (A000:0138=0)
273F:3622  80 EB 01                             sub     bl,1
273F:3625  75 E2                                jnz     loc_706                 ; Jump if not zero
273F:3627  5E                                   pop     si
273F:3628  59                                   pop     cx
273F:3629  5B                                   pop     bx
273F:362A  1F                                   pop     ds
273F:362B  5F                                   pop     di
273F:362C  C3                                   retn

                      vga_display_character     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                              vga_menu_items    proc    near

273F:362D  B8 A000                              mov     ax, VGA_SEGMENT
273F:3630  8E C0                                mov     es,ax
273F:3632  B1 03                                mov     cl,3
273F:3634  BA 0048                              mov     dx,48h
273F:3637  8A 1E 334E                           mov     bl,byte ptr ds:[334Eh]  ; (273F:334E=0E4h)
273F:363B  32 FF                                xor     bh,bh                   ; Zero register
273F:363D  D3 E3                                shl     bx,cl                   ; Shift w/zeros fill
273F:363F  1E                                   push    ds
273F:3640  8B 36 335A                           mov     si,word ptr ds:[335Ah]  ; (273F:335A=0ACA4h)
273F:3644  8B FE                                mov     di,si
273F:3646  A1 3376                              mov     ax,data_265             ; (273F:3376=0F632h)
273F:3649  8E D8                                mov     ds,ax
273F:364B                       loc_710:                                        ;  xref 273F:365A
273F:364B  56                                   push    si
273F:364C  8B CB                                mov     cx,bx
273F:364E  F3/ A4                               rep     movsb                   ; Rep when cx >0 Mov [si] to es:[di]
273F:3650  5E                                   pop     si
273F:3651  81 C6 0140                           add     si,140h
273F:3655  8B FE                                mov     di,si
273F:3657  83 EA 01                             sub     dx,1
273F:365A  75 EF                                jnz     loc_710                 ; Jump if not zero
273F:365C  1F                                   pop     ds

273F:365D                       loc_ret_711:                                    ;  xref 273F:366F
273F:365D  C3                                   retn
273F:365E                       loc_712:                                        ;  xref 273F:36AD
273F:365E  80 26 11D0 FB                        and     menubar_state, 0FBh ; (273F:11D0=56h)
273F:3663  C3                                   retn

                              vga_menu_items    endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called indircetly via calls to word ptr [show_cursor_proc]
                                ;

                                  vga_cursor    proc    near

273F:3664  C7 06 F010 0000                      mov     timer_ticks, 0
273F:366A  F6 06 11D0 04                        test    menubar_state, 4   ; (273F:11D0=56h)
273F:366F  75 EC                                jnz     loc_ret_711             ; Jump if not zero
273F:3671  80 0E 11D0 04                        or      menubar_state, 4   ; (273F:11D0=56h)
273F:3676  8B 3E 11E8                           mov     di,word ptr ds:[11E8h]  ; (273F:11E8=14B9h)
273F:367A BE 11EE                              mov     si, offset data_641
273F:367D  8B 1E 11EA                           mov     bx,word ptr ds:[11EAh]  ; (273F:11EA=8B00h)
273F:3681  8B 16 11EC                           mov     dx,word ptr ds:[11ECh]  ; (273F:11EC=1B55h)
273F:3685  0B D2                                or      dx,dx                   ; Zero ?
273F:3687  74 1F                                jz      loc_714                 ; Jump if zero

273F:3689  B8 A000                              mov     ax, VGA_SEGMENT
273F:368C  8E C0                                mov     es,ax
273F:368E                       loc_713:                                        ;  xref 273F:36A0
273F:368E  56                                   push    si
273F:368F  57                                   push    di
273F:3690  8B CB                                mov     cx,bx
273F:3692  F3/ A4                               rep     movsb                   ; Rep when cx >0 Mov [si] to es:[di]
273F:3694  5F                                   pop     di
273F:3695  5E                                   pop     si
273F:3696  83 C6 10                             add     si,10h
273F:3699  81 C7 0140                           add     di,140h
273F:369D  83 EA 01                             sub     dx,1
273F:36A0  75 EC                                jnz     loc_713                 ; Jump if not zero
273F:36A2  C7 06 11EC 0000                      mov     word ptr ds:[11ECh],0   ; (273F:11EC=1B55h)
273F:36A8                       loc_714:                                        ;  xref 273F:3687
273F:36A8  F6 06 11D0 01                        test    menubar_state, 1   ; (273F:11D0=56h)
273F:36AD  75 AF                                jnz     loc_712                 ; Jump if not zero
273F:36AF  A1 11D8                              mov     ax, mouse_y2
273F:36B2  2B 06 11DF                           sub     ax, cursor_centroid
273F:36B6  73 02                                jnc     loc_715                 ; Jump if carry=0
273F:36B8  33 C0                                xor     ax,ax                   ; Zero register
273F:36BA                       loc_715:                                        ;  xref 273F:36B6
273F:36BA  BA 00C8                              mov     dx,0C8h
273F:36BD  2B D0                                sub     dx,ax
273F:36BF  83 FA 11                             cmp     dx,11h
273F:36C2  72 03                                jb      loc_716                 ; Jump if below
273F:36C4  BA 0010                              mov     dx,10h
273F:36C7                       loc_716:                                        ;  xref 273F:36C2
273F:36C7  89 16 11EC                           mov     word ptr ds:[11ECh],dx  ; (273F:11EC=1B55h)
273F:36CB  8B 36 11D6                           mov     si, mouse_x2
273F:36CF  2B 36 11DF                           sub     si, cursor_centroid
273F:36D3  73 02                                jnc     loc_717                 ; Jump if carry=0
273F:36D5  33 F6                                xor     si,si                   ; Zero register
273F:36D7                       loc_717:                                        ;  xref 273F:36D3
273F:36D7  BD 0140                              mov     bp,140h
273F:36DA  2B EE                                sub     bp,si
273F:36DC  83 FD 11                             cmp     bp,11h
273F:36DF  72 03                                jb      loc_718                 ; Jump if below
273F:36E1  BD 0010                              mov     bp,10h
273F:36E4                       loc_718:                                        ;  xref 273F:36DF
273F:36E4  89 2E 11EA                           mov     word ptr ds:[11EAh],bp  ; (273F:11EA=8B00h)
273F:36E8  8B C8                                mov     cx,ax
273F:36EA  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:36EC  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:36EE  03 C1                                add     ax,cx
273F:36F0  B1 06                                mov     cl,6
273F:36F2  D3 E0                                shl     ax,cl                   ; Shift w/zeros fill
273F:36F4  03 F0                                add     si,ax
273F:36F6  89 36 11E8                           mov     word ptr ds:[11E8h],si  ; (273F:11E8=14B9h)
273F:36FA  1E                                   push    ds
273F:36FB  FF 36 4CF4                           push    cursors_segment
273F:36FF  FF 36 11E1                           push    cursor_index
273F:3703  1E                                   push    ds
273F:3704  07                                   pop     es
273F:3705  B8 A000                              mov     ax, VGA_SEGMENT
273F:3708  8E D8                                mov     ds,ax
273F:370A BF 11EE                              mov     di, offset data_641
273F:370D  56                                   push    si
273F:370E  52                                   push    dx
273F:370F                       loc_719:                                        ;  xref 273F:3721
273F:370F  56                                   push    si
273F:3710  57                                   push    di
273F:3711  8B CD                                mov     cx,bp
273F:3713  F3/ A4                               rep     movsb                   ; Rep when cx >0 Mov [si] to es:[di]
273F:3715  5F                                   pop     di
273F:3716  5E                                   pop     si
273F:3717 81 C6 0140                           add     si,data_1451e           ; (B2DE:0140=0)
273F:371B  83 C7 10                             add     di,10h
273F:371E  83 EA 01                             sub     dx,1
273F:3721  75 EC                                jnz     loc_719                 ; Jump if not zero
273F:3723  1E                                   push    ds
273F:3724  07                                   pop     es

273F:3725  5A                                   pop     dx
273F:3726  5F                                   pop     di
273F:3727  58                                   pop     ax
273F:3728  86 E0                                xchg    ah,al
273F:372A  8B F0                                mov     si,ax
273F:372C  1F                                   pop     ds
273F:372D                       loc_720:                                        ;  xref 273F:374A
273F:372D  56                                   push    si
273F:372E  57                                   push    di
273F:372F  8B CD                                mov     cx,bp

273F:3731                       locloop_721:                                    ;  xref 273F:373C
273F:3731  AC                                   lodsb                           ; String [si] to al
273F:3732  0A C0                                or      al,al                   ; Zero ?
273F:3734  74 03                                jz      loc_722                 ; Jump if zero
273F:3736  26: 88 05                            mov     es:[di],al
273F:3739                       loc_722:                                        ;  xref 273F:3734
273F:3739  83 C7 01                             add     di,1
273F:373C  E2 F3                                loop    locloop_721             ; Loop if cx > 0

273F:373E  5F                                   pop     di
273F:373F  5E                                   pop     si
273F:3740  83 C6 10                             add     si,10h
273F:3743  81 C7 0140                           add     di,140h
273F:3747  83 EA 01                             sub     dx,1
273F:374A  75 E1                                jnz     loc_720                 ; Jump if not zero
273F:374C  1F                                   pop     ds
273F:374D  80 26 11D0 FB                        and     menubar_state, 0FBh ; (273F:11D0=56h)

273F:3752                       loc_ret_723:                                    ;  xref 273F:3758
273F:3752  C3                                   retn

                                  vga_cursor    endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                             sub_unknown_1      proc    near

273F:3753  F6 06 11D0 01                        test    menubar_state, 1
273F:3758  75 F8                                jnz     loc_ret_723
273F:375A  1E                                   push    ds
273F:375B  8B 36 11E8                           mov     si,word ptr ds:[11E8h]
273F:375F  8B 1E 11EA                           mov     bx,word ptr ds:[11EAh]
273F:3763  8B 16 11EC                           mov     dx,word ptr ds:[11ECh]
273F:3767  0B D2                                or      dx,dx
273F:3769  74 51                                jz      loc_728
273F:376B  FF 36 4CF4                           push    cursors_segment
273F:376F  FF 36 11E1                           push    cursor_index
273F:3773  52                                   push    dx
273F:3774  56                                   push    si
273F:3775  1E                                   push    ds
273F:3776  07                                   pop     es
273F:3777  A1 4CE4                              mov     ax, data_segment2
273F:377A  8E D8                                mov     ds,ax
273F:377C BF 11EE                              mov     di,11EEh
273F:377F                       loc_724:
273F:377F  56                                   push    si
273F:3780  57                                   push    di
273F:3781  8B CB                                mov     cx,bx
273F:3783  F3/ A4                               rep     movsb                   ; Rep when cx >0 Mov [si] to es:[di]
273F:3785  5F                                   pop     di
273F:3786  5E                                   pop     si
273F:3787  83 C7 10                             add     di,10h
273F:378A 81 C6 0140                           add     si,data_1451e           ; (B2DE:0140=0)
273F:378E  83 EA 01                             sub     dx,1
273F:3791  75 EC                                jnz     loc_724                 ; Jump if not zero
273F:3793  1E                                   push    ds
273F:3794  07                                   pop     es
273F:3795  5F                                   pop     di
273F:3796  5A                                   pop     dx
273F:3797  58                                   pop     ax
273F:3798  86 E0                                xchg    ah,al
273F:379A  8B F0                                mov     si,ax
273F:379C  1F                                   pop     ds
273F:379D                       loc_725:                                        ;  xref 273F:37BA
273F:379D  57                                   push    di
273F:379E  56                                   push    si
273F:379F  8B CB                                mov     cx,bx

273F:37A1                       locloop_726:                                    ;  xref 273F:37AC
273F:37A1  AC                                   lodsb                           ; String [si] to al
273F:37A2  0A C0                                or      al,al                   ; Zero ?
273F:37A4  74 03                                jz      loc_727                 ; Jump if zero
273F:37A6  26: 88 05                            mov     es:[di],al
273F:37A9                       loc_727:                                        ;  xref 273F:37A4
273F:37A9  83 C7 01                             add     di,1
273F:37AC  E2 F3                                loop    locloop_726             ; Loop if cx > 0

273F:37AE  5E                                   pop     si
273F:37AF  5F                                   pop     di
273F:37B0  83 C6 10                             add     si,10h
273F:37B3 81 C7 0140                           add     di, SCREEN_WIDTH
273F:37B7  83 EA 01                             sub     dx,1
273F:37BA  75 E1                                jnz     loc_725                 ; Jump if not zero
273F:37BC                       loc_728:                                        ;  xref 273F:3769
273F:37BC  1F                                   pop     ds
273F:37BD  C3                                   retn

                             sub_unknown_1      endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:30B7
                                ;

273F:37BE                       sub_73          proc    near
273F:37BE  F6 06 11D0 01                        test    menubar_state, 1   ; (273F:11D0=56h)
273F:37C3  75 2C                                jnz     loc_ret_730             ; Jump if not zero
273F:37C5  A1 4CE4                              mov     ax, data_segment2
273F:37C8  8E C0                                mov     es,ax
273F:37CA  8B 3E 11E8                           mov     di,word ptr ds:[11E8h]  ; (273F:11E8=14B9h)
273F:37CE  8B 1E 11EA                           mov     bx,word ptr ds:[11EAh]  ; (273F:11EA=8B00h)
273F:37D2  8B 16 11EC                           mov     dx,word ptr ds:[11ECh]  ; (273F:11EC=1B55h)
273F:37D6  0B D2                                or      dx,dx                   ; Zero ?
273F:37D8  74 17                                jz      loc_ret_730             ; Jump if zero
273F:37DA BE 11EE                              mov     si,11EEh                ; (273F:11EE=3Bh)
273F:37DD                       loc_729:                                        ;  xref 273F:37EF
273F:37DD  57                                   push    di
273F:37DE  56                                   push    si
273F:37DF  8B CB                                mov     cx,bx
273F:37E1  F3/ A4                               rep     movsb                   ; Rep when cx >0 Mov [si] to es:[di]
273F:37E3  5E                                   pop     si
273F:37E4  5F                                   pop     di
273F:37E5  81 C7 0140                           add     di,140h
273F:37E9  83 C6 10                             add     si,10h
273F:37EC  83 EA 01                             sub     dx,1
273F:37EF  75 EC                                jnz     loc_729                 ; Jump if not zero

273F:37F1                       loc_ret_730:                                    ;  xref 273F:37C3, 37D8
273F:37F1  C3                                   retn
                                sub_73          endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                         vga_add_animation      proc    near

273F:37F2  2E: C7 06 1500 0000                  mov     word ptr cs:data_215,0  ; (273F:1500=0)
273F:37F9  C6 06 11B0 00                        mov     byte ptr ds:[11B0h],0   ; (273F:11B0=0BEh)
273F:37FE  8A 6F 06                             mov     ch,[bx+ANIM_HEIGHT]     ; Get height
273F:3801  8A 4F 04                             mov     cl,[bx+ANIM_WIDTH]      ; Get width
273F:3804  8B 47 02                             mov     ax,[bx+ANIM_Y]          ; Get Y position
273F:3807  2D 0088                              sub     ax,88h
273F:380A  73 16                                jnc     loc_731

273F:380C  8B D0                                mov     dx,ax
273F:380E  02 D5                                add     dl,ch
273F:3810  73 15                                jnc     loc_ret_732             ; Jump if carry=0
273F:3812  74 13                                jz      loc_ret_732             ; Jump if zero
273F:3814  F7 D8                                neg     ax
273F:3816  2A E8                                sub     ch,al
273F:3818  F6 E1                                mul     cl                      ; ax = reg * al
273F:381A  D1 E8                                shr     ax,1                    ; Shift w/zeros fill
273F:381C  03 F0                                add     si,ax
273F:381E  33 C0                                xor     ax,ax                   ; Zero register
273F:3820  EB 13                                jmp     short loc_734           ; (3835)
273F:3822                       loc_731:                                        ;  xref 273F:380A
273F:3822  3D 00C0                              cmp     ax, 192                 ; Row too high?
273F:3825  72 01                                jb      loc_733

273F:3827                       loc_ret_732:                                    ;  xref 273F:3810, 3812
273F:3827  C3                                   retn
273F:3828                       loc_733:
273F:3828  8B D0                                mov     dx,ax                   ; Get start row
273F:382A  03 57 06                             add     dx,[bx+ANIM_HEIGHT]     ; Add number of rows
273F:382D  81 EA 00C0                           sub     dx, 192                 ; Bottom row > 192?
273F:3831  76 02                                jbe     loc_734
273F:3833  2A EA                                sub     ch,dl                   ; Yes, reduce height to fit
273F:3835                       loc_734:
273F:3835  51                                   push    cx
273F:3836  8B D0                                mov     dx,ax                   ; ax = line number, and
273F:3838  D1 E0                                shl     ax,1                    ; will be * 320
273F:383A  D1 E0                                shl     ax,1
273F:383C  03 D0                                add     dx,ax
273F:383E  B1 06                                mov     cl,6
273F:3840  D3 E2                                shl     dx,cl
273F:3842  8B FA                                mov     di,dx                   ; di = start of line
273F:3844 81 C7 0A00                           add     di, MENUBAR_BLOCK_SIZE  ; Compensate for menubar
273F:3848  59                                   pop     cx

273F:3849  8B 07                                mov     ax,[bx]                 ; Get start X position
273F:384B  2D 0080                              sub     ax,80h
273F:384E  73 21                                jnc     loc_736                 ; Jump if carry=0
273F:3850  8B D0                                mov     dx,ax
273F:3852  02 D1                                add     dl,cl
273F:3854  72 01                                jc      loc_735                 ; Jump if carry Set
273F:3856  C3                                   retn
273F:3857                       loc_735:                                        ;  xref 273F:3854
273F:3857  F7 D0                                not     ax
273F:3859  2A C8                                sub     cl,al
273F:385B  2E: A3 1500                          mov     word ptr cs:data_215,ax ; (273F:1500=0)
273F:385F  C6 06 11B0 01                        mov     byte ptr ds:[11B0h],1   ; (273F:11B0=0BEh)
273F:3864  8B 47 04                             mov     ax,[bx+ANIM_WIDTH]
273F:3867  D1 E8                                shr     ax,1                    ; Shift w/zeros fill
273F:3869  2E: A3 1505                          mov     cs:data_218,ax          ; (273F:1505=0)
273F:386D  33 C0                                xor     ax,ax                   ; Zero register
273F:386F  EB 22                                jmp     short loc_738           ; (3893)
273F:3871                       loc_736:                                        ;  xref 273F:384E
273F:3871  3D 0140                              cmp     ax,140h
273F:3874  72 01                                jb      loc_737                 ; Jump if below
273F:3876  C3                                   retn

273F:3877                       loc_737:                                        ;  xref 273F:3874
273F:3877  8B D0                                mov     dx,ax
273F:3879  03 57 04                             add     dx,[bx+ANIM_WIDTH]
273F:387C  81 EA 0140                           sub     dx,140h
273F:3880  76 11                                jbe     loc_738                 ; Jump if below or =
273F:3882  2A CA                                sub     cl,dl
273F:3884  C6 06 11B0 01                        mov     byte ptr ds:[11B0h],1   ; (273F:11B0=0BEh)

273F:3889  8B 57 04                             mov     dx,[bx+ANIM_WIDTH]
273F:388C  D1 EA                                shr     dx,1                    ; Shift w/zeros fill
273F:388E  2E: 89 16 1505                       mov     cs:data_218,dx          ; (273F:1505=0)
273F:3893                       loc_738:                                        ;  xref 273F:386F, 3880
273F:3893  03 F8                                add     di,ax
273F:3895  8A 5F 28                             mov     bl,[bx+ANIM_START_COLOUR] ; Colour offset start
273F:3898  F6 06 11B0 FF                        test    byte ptr ds:[11B0h],0FFh
273F:389D  75 47                                jnz     loc_743                   ; Jump if not zero
273F:389F  1E                                   push    ds
273F:38A0  06                                   push    es
273F:38A1  A1 4CE4                              mov     ax, data_segment2
273F:38A4  8E C0                                mov     es,ax
273F:38A6  1F                                   pop     ds
273F:38A7  8A D1                                mov     dl,cl
273F:38A9  8A CD                                mov     cl,ch
273F:38AB  32 ED                                xor     ch,ch                   ; Zero register
273F:38AD  32 F6                                xor     dh,dh                   ; Zero register
273F:38AF  D1 EA                                shr     dx,1                    ; Divide by 2

; This seems to be the loop for applying an animation to the off-screen buffer
; cx = height, dx = width/2, es:di = dest, bl = starting colour offset
; ds:si = source - each byte consists of two pixels. An output pixel will
; be the starting colour offset + the nibble value of the source byte

273F:38B1                       locloop_739:                                    ;  xref 273F:38E2
273F:38B1  51                                   push    cx
273F:38B2  52                                   push    dx
273F:38B3  B1 04                                mov     cl,4
273F:38B5  57                                   push    di
273F:38B6                       loc_740:                                        ;  xref 273F:38D9
273F:38B6  AC                                   lodsb                           ; String [si] to al
273F:38B7  8A E0                                mov     ah,al
273F:38B9  D2 EC                                shr     ah,cl                   ; Shift w/zeros fill
273F:38BB  25 0F0F                              and     ax,0F0Fh
273F:38BE  0A E4                                or      ah,ah                   ; Zero ?
273F:38C0  74 05                                jz      loc_741                 ; Jump if zero
273F:38C2  02 E3                                add     ah,bl
273F:38C4  26: 88 25                            mov     es:[di],ah
273F:38C7                       loc_741:                                        ;  xref 273F:38C0
273F:38C7  83 C7 01                             add     di,1
273F:38CA  0A C0                                or      al,al                   ; Zero ?
273F:38CC  74 05                                jz      loc_742                 ; Jump if zero
273F:38CE  02 C3                                add     al,bl
273F:38D0  26: 88 05                            mov     es:[di],al
273F:38D3                       loc_742:                                        ;  xref 273F:38CC
273F:38D3  83 C7 01                             add     di,1
273F:38D6  83 EA 01                             sub     dx,1
273F:38D9  75 DB                                jnz     loc_740                 ; Jump if not zero

273F:38DB  5F                                   pop     di
273F:38DC 81 C7 0140                           add     di,SCREEN_WIDTH
273F:38E0  5A                                   pop     dx
273F:38E1  59                                   pop     cx
273F:38E2  E2 CD                                loop    locloop_739             ; Loop if cx > 0

273F:38E4  1F                                   pop     ds
273F:38E5  C3                                   retn


273F:38E6                       loc_743:                                        ;  xref 273F:389D
273F:38E6  1E                                   push    ds
273F:38E7  06                                   push    es
273F:38E8  A1 4CE4                              mov     ax, data_segment2
273F:38EB  8E C0                                mov     es,ax
273F:38ED  1F                                   pop     ds
273F:38EE  8A D1                                mov     dl,cl
273F:38F0  8A CD                                mov     cl,ch
273F:38F2  32 ED                                xor     ch,ch                   ; Zero register
273F:38F4  32 F6                                xor     dh,dh                   ; Zero register

273F:38F6                       locloop_744:                                    ;  xref 273F:3944
273F:38F6  51                                   push    cx
273F:38F7  8B CA                                mov     cx,dx
273F:38F9  57                                   push    di
273F:38FA  56                                   push    si
273F:38FB  2E: A1 1500                          mov     ax,word ptr cs:data_215 ; (273F:1500=0)
273F:38FF  D1 E8                                shr     ax,1                    ; Shift w/zeros fill
273F:3901  9C                                   pushf                           ; Push flags
273F:3902  03 F0                                add     si,ax
273F:3904  9D                                   popf                            ; Pop flags
273F:3905  73 05                                jnc     locloop_745             ; Jump if carry=0
273F:3907  AC                                   lodsb                           ; String [si] to al
273F:3908  24 0F                                and     al,0Fh
273F:390A  EB 1E                                jmp     short locloop_747       ; (392A)

273F:390C                       locloop_745:                                    ;  xref 273F:3905, 3936
273F:390C  AC                                   lodsb                           ; String [si] to al
273F:390D  8A E0                                mov     ah,al
273F:390F  D0 EC                                shr     ah,1                    ; Shift w/zeros fill
273F:3911  D0 EC                                shr     ah,1                    ; Shift w/zeros fill
273F:3913  D0 EC                                shr     ah,1                    ; Shift w/zeros fill
273F:3915  D0 EC                                shr     ah,1                    ; Shift w/zeros fill
273F:3917  25 0F0F                              and     ax,0F0Fh
273F:391A  0A E4                                or      ah,ah                   ; Zero ?
273F:391C  74 05                                jz      loc_746                 ; Jump if zero
273F:391E  02 E3                                add     ah,bl
273F:3920  26: 88 25                            mov     es:[di],ah
273F:3923                       loc_746:                                        ;  xref 273F:391C
273F:3923  83 C7 01                             add     di,1
273F:3926  E2 02                                loop    locloop_747             ; Loop if cx > 0

273F:3928  EB 0E                                jmp     short loc_749           ; (3938)

273F:392A                       locloop_747:                                    ;  xref 273F:390A, 3926
273F:392A  0A C0                                or      al,al                   ; Zero ?
273F:392C  74 05                                jz      loc_748                 ; Jump if zero
273F:392E  02 C3                                add     al,bl
273F:3930  26: 88 05                            mov     es:[di],al
273F:3933                       loc_748:                                        ;  xref 273F:392C
273F:3933  83 C7 01                             add     di,1
273F:3936  E2 D4                                loop    locloop_745             ; Loop if cx > 0

273F:3938                       loc_749:                                        ;  xref 273F:3928
273F:3938  5E                                   pop     si
273F:3939  2E: 03 36 1505                       add     si,cs:data_218          ; (273F:1505=0)
273F:393E  5F                                   pop     di
273F:393F 81 C7 0140                           add     di, SCREEN_WIDTH
273F:3943  59                                   pop     cx
273F:3944  E2 B0                                loop    locloop_744             ; Loop if cx > 0

273F:3946  1F                                   pop     ds
273F:3947  C3                                   retn

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                                                                                ;* No entry point to code
273F:3948  A1 4CE4                              mov     ax, data_segment2
273F:394B  8E C0                                mov     es,ax
273F:394D  B2 08                                mov     dl,8
273F:394F                       loc_750:                                        ;  xref 273F:396C
273F:394F  57                                   push    di
273F:3950  8B CB                                mov     cx,bx

273F:3952                       locloop_751:                                    ;  xref 273F:3963
273F:3952  26: 80 3D E2                         cmp     byte ptr es:[di],0E2h
273F:3956  74 06                                je      loc_752                 ; Jump if equal
273F:3958  26: 80 3D FF                         cmp     byte ptr es:[di],0FFh
273F:395C  75 04                                jne     loc_753                 ; Jump if not equal
273F:395E                       loc_752:                                        ;  xref 273F:3956
273F:395E  26: 80 35 1D                         xor     byte ptr es:[di],1Dh
273F:3962                       loc_753:                                        ;  xref 273F:395C
273F:3962  47                                   inc     di
273F:3963  E2 ED                                loop    locloop_751             ; Loop if cx > 0

273F:3965  5F                                   pop     di
273F:3966 81 C7 0140                           add     di,data_1446e           ; (A000:0140=0)
273F:396A  FE CA                                dec     dl
273F:396C  75 E1                                jnz     loc_750                 ; Jump if not zero
273F:396E  C3                                   retn

                         vga_add_animation      endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                      menubar_copy_to_screen    proc    near

273F:396F  B8 A000                              mov     ax, VGA_SEGMENT
273F:3972  8E C0                                mov     es,ax
273F:3974  1E                                   push    ds
273F:3975  A1 4CE4                              mov     ax, data_segment2
273F:3978  8E D8                                mov     ds,ax
273F:397A  B9 0500                              mov     cx, MENUBAR_BLOCK_SIZE/2 ; 500h words
500h
273F:397D  33 F6                                xor     si,si                   ; Zero register
273F:397F  33 FF                                xor     di,di                   ; Zero register
273F:3981  F3/ A5                               rep     movsw                   ; Rep when cx >0 Mov [si] to es:[di]
273F:3983  1F                                   pop     ds
273F:3984  C6 06 4BF0 00                        mov     byte ptr ds:[4BF0h],0   ; (273F:4BF0=3)
273F:3989  C3                                   retn

                      menubar_copy_to_screen    endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:0BF9, 7B99, A7CC
                                ;

273F:398A                  decode_file_entry    proc    near
273F:398A  83 C2 08                             add     dx,8
273F:398D  1E                                   push    ds
273F:398E  8C C3                                mov     bx,es
273F:3990  8E C2                                mov     es,dx
273F:3992  8E DA                                mov     ds,dx
273F:3994  A1 0402                              mov     ax, ds:[402h]
273F:3997  B1 0C                                mov     cl,0Ch
273F:3999  D3 E0                                shl     ax,cl                   ; Shift w/zeros fill
273F:399B  03 D0                                add     dx,ax
273F:399D  A1 0400                              mov     ax, ds:[400h]
273F:39A0  B1 04                                mov     cl,4
273F:39A2  D3 E8                                shr     ax,cl                   ; Shift w/zeros fill
273F:39A4  03 D0                                add     dx,ax
273F:39A6  8B 36 0400                           mov     si, ds:[400h]
273F:39AA  83 E6 0F                             and     si,0Fh
273F:39AD  8E DA                                mov     ds,dx
273F:39AF  8B D3                                mov     dx,bx
273F:39B1  33 FF                                xor     di,di                   ; Zero register
273F:39B3 BB 0404                              mov     bx, ds:[404h]
273F:39B6  26: 8A 2F                            mov     ch,es:[bx]
273F:39B9  83 C3 01                             add     bx,1
273F:39BC  B1 09                                mov     cl,9
273F:39BE                       loc_754:                                        ;  xref 273F:3A70
273F:39BE AC                                   lodsb                           ; String [si] to al
273F:39BF  06                                   push    es
273F:39C0  8E C2                                mov     es,dx
273F:39C2  AA                                   stosb                           ; Store al to es:[di]
273F:39C3  07                                   pop     es
273F:39C4  32 E4                                xor     ah,ah                   ; Zero register
273F:39C6  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:39C8  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:39CA  8B E8                                mov     bp,ax
273F:39CC                       loc_755:                                        ;  xref 273F:3A02, 3A1D, 3A9C
273F:39CC 80 E9 01                             sub     cl,1
273F:39CF  75 08                                jnz     loc_756                 ; Jump if not zero
273F:39D1  26: 8A 2F                            mov     ch,es:[bx]
273F:39D4  B1 08                                mov     cl,8
273F:39D6  83 C3 01                             add     bx,1
273F:39D9                       loc_756:                                        ;  xref 273F:39CF
273F:39D9  D0 E5                                shl     ch,1                    ; Shift w/zeros fill
273F:39DB  72 42                                jc      loc_761                 ; Jump if carry Set
273F:39DD  80 E9 01                             sub     cl,1
273F:39E0  75 08                                jnz     loc_757                 ; Jump if not zero
273F:39E2  26: 8A 2F                            mov     ch,es:[bx]
273F:39E5  B1 08                                mov     cl,8
273F:39E7  83 C3 01                             add     bx,1
273F:39EA                       loc_757:                                        ;  xref 273F:39E0
273F:39EA  D0 E5                                shl     ch,1                    ; Shift w/zeros fill
273F:39EC  72 16                                jc      loc_759                 ; Jump if carry Set
273F:39EE  87 DD                                xchg    bx,bp
273F:39F0  26: 8A 07                            mov     al,es:[bx]
273F:39F3  8B DD                                mov     bx,bp
273F:39F5                       loc_758:                                        ;  xref 273F:3A49, 3A53, 3A6E
273F:39F5 06                                   push    es
273F:39F6  8E C2                                mov     es,dx
273F:39F8  AA                                   stosb                           ; Store al to es:[di]
273F:39F9  07                                   pop     es
273F:39FA  32 E4                                xor     ah,ah                   ; Zero register
273F:39FC  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:39FE  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:3A00  8B E8                                mov     bp,ax
273F:3A02  EB C8                                jmp     short loc_755           ; (39CC)
273F:3A04                       loc_759:                                        ;  xref 273F:39EC
273F:3A04  8B C5                                mov     ax,bp
273F:3A06  D1 E8                                shr     ax,1                    ; Shift w/zeros fill
273F:3A08  D1 E8                                shr     ax,1                    ; Shift w/zeros fill
273F:3A0A  8A 24                                mov     ah,[si]
273F:3A0C  83 C6 01                             add     si,1
273F:3A0F  0A E4                                or      ah,ah                   ; Zero ?
273F:3A11  74 60                                jz      loc_768                 ; Jump if zero
273F:3A13  06                                   push    es
273F:3A14  8E C2                                mov     es,dx
273F:3A16                       loc_760:                                        ;  xref 273F:3A1A
273F:3A16  AA                                   stosb                           ; Store al to es:[di]
273F:3A17  80 EC 01                             sub     ah,1
273F:3A1A  75 FA                                jnz     loc_760                 ; Jump if not zero
273F:3A1C  07                                   pop     es
273F:3A1D  EB AD                                jmp     short loc_755           ; (39CC)
273F:3A1F                       loc_761:                                        ;  xref 273F:39DB
273F:3A1F  80 E9 01                             sub     cl,1
273F:3A22  75 08                                jnz     loc_762                 ; Jump if not zero
273F:3A24  26: 8A 2F                            mov     ch,es:[bx]
273F:3A27  B1 08                                mov     cl,8
273F:3A29  83 C3 01                             add     bx,1
273F:3A2C                       loc_762:                                        ;  xref 273F:3A22
273F:3A2C  D0 E5                                shl     ch,1                    ; Shift w/zeros fill
273F:3A2E  72 25                                jc      loc_765                 ; Jump if carry Set
273F:3A30  80 E9 01                             sub     cl,1
273F:3A33  75 08                                jnz     loc_763                 ; Jump if not zero
273F:3A35  26: 8A 2F                            mov     ch,es:[bx]
273F:3A38  B1 08                                mov     cl,8
273F:3A3A  83 C3 01                             add     bx,1
273F:3A3D                       loc_763:                                        ;  xref 273F:3A33
273F:3A3D  D0 E5                                shl     ch,1                    ; Shift w/zeros fill
273F:3A3F  72 0A                                jc      loc_764                 ; Jump if carry Set
273F:3A41  87 DD                                xchg    bx,bp
273F:3A43  26: 8A 47 01                         mov     al,es:[bx+1]
273F:3A47  8B DD                                mov     bx,bp
273F:3A49  EB AA                                jmp     short loc_758           ; (39F5)
273F:3A4B                       loc_764:                                        ;  xref 273F:3A3F
273F:3A4B  87 DD                                xchg    bx,bp
273F:3A4D  26: 8A 47 02                         mov     al,es:[bx+2]
273F:3A51  8B DD                                mov     bx,bp
273F:3A53  EB A0                                jmp     short loc_758           ; (39F5)
273F:3A55                       loc_765:                                        ;  xref 273F:3A2E
273F:3A55  80 E9 01                             sub     cl,1
273F:3A58  75 08                                jnz     loc_766                 ; Jump if not zero
273F:3A5A  26: 8A 2F                            mov     ch,es:[bx]
273F:3A5D  B1 08                                mov     cl,8
273F:3A5F  83 C3 01                             add     bx,1
273F:3A62                       loc_766:                                        ;  xref 273F:3A58
273F:3A62  D0 E5                                shl     ch,1                    ; Shift w/zeros fill
273F:3A64  72 0A                                jc      loc_767                 ; Jump if carry Set
273F:3A66  87 DD                                xchg    bx,bp
273F:3A68  26: 8A 47 03                         mov     al,es:[bx+3]
273F:3A6C  8B DD                                mov     bx,bp
273F:3A6E  EB 85                                jmp     short loc_758           ; (39F5)
273F:3A70                       loc_767:                                        ;  xref 273F:3A64
273F:3A70  E9 FF4B                              jmp     loc_754                 ; (39BE)
273F:3A73                       loc_768:                                        ;  xref 273F:3A11
273F:3A73  AC                                   lodsb                           ; String [si] to al
273F:3A74  0A C0                                or      al,al                   ; Zero ?
273F:3A76  74 27                                jz      loc_769                 ; Jump if zero
273F:3A78  8B C7                                mov     ax,di
273F:3A7A  D1 E8                                shr     ax,1                    ; Shift w/zeros fill
273F:3A7C  D1 E8                                shr     ax,1                    ; Shift w/zeros fill
273F:3A7E  D1 E8                                shr     ax,1                    ; Shift w/zeros fill
273F:3A80  D1 E8                                shr     ax,1                    ; Shift w/zeros fill
273F:3A82  03 D0                                add     dx,ax
273F:3A84  83 E7 0F                             and     di,0Fh
273F:3A87  51                                   push    cx
273F:3A88  8C D9                                mov     cx,ds
273F:3A8A  8B C6                                mov     ax,si
273F:3A8C  D1 E8                                shr     ax,1                    ; Shift w/zeros fill
273F:3A8E  D1 E8                                shr     ax,1                    ; Shift w/zeros fill
273F:3A90  D1 E8                                shr     ax,1                    ; Shift w/zeros fill
273F:3A92  D1 E8                                shr     ax,1                    ; Shift w/zeros fill
273F:3A94  03 C8                                add     cx,ax
273F:3A96  8E D9                                mov     ds,cx
273F:3A98  83 E6 0F                             and     si,0Fh
273F:3A9B  59                                   pop     cx
273F:3A9C  E9 FF2D                              jmp     loc_755                 ; (39CC)
273F:3A9F                       loc_769:                                        ;  xref 273F:3A76
273F:3A9F  1F                                   pop     ds
273F:3AA0  83 C7 0F                             add     di,0Fh
273F:3AA3  D1 EF                                shr     di,1                    ; Shift w/zeros fill
273F:3AA5  D1 EF                                shr     di,1                    ; Shift w/zeros fill
273F:3AA7  D1 EF                                shr     di,1                    ; Shift w/zeros fill
273F:3AA9  D1 EF                                shr     di,1                    ; Shift w/zeros fill
273F:3AAB  03 D7                                add     dx,di
273F:3AAD  C3                                   retn
                           decode_file_entry    endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:00C9, 70CA, 8FFA
                                ;

273F:3AAE               replace_vga_palette     proc    near
273F:3AAE  1E                                   push    ds
273F:3AAF  07                                   pop     es
273F:3AB0 BE 1757                              mov     si,offset replacement_vga_palette
273F:3AB3 BF 15DA                              mov     di,offset unprocessed_vga_palette2
273F:3AB6  B9 00B4                              mov     cx, 60*3                ; Move 60 palette entries
273F:3AB9  F3/ A4                               rep     movsb

273F:3ABB               replace_vga_palette2:
273F:3ABB BE 180B                              mov     si, offset replacement_vga_ palette2
273F:3ABE BF 16EB                              mov     di, offset unprocessed_vga_palette3
273F:3AC1  B9 0018                              mov     cx, 8*3                 ; Move 8 palette entries
273F:3AC4  F3/ A4                               rep     movsb                   ; Rep when cx >0 Mov [si] to es:[di]
273F:3AC6  C3                                   retn
                        replace_vga_palette     endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:0C13, 0C35, 0C5A, 3C95, 75AE, 75D2, 75F0
                                ;                             760E, A549, A5BB, A66D, A6C4, A914
                                ;

273F:3AC7                     read_palette      proc    near
273F:3AC7  8C D9                                mov     cx,ds
273F:3AC9  BA 1457                              mov     dx, unprocessed_vga_palette
273F:3ACC  56                                   push    si
273F:3ACD  E8 C844                              call    read_entry              ; (0314)
273F:3AD0  5E                                   pop     si
273F:3AD1  C6 06 1456 FF                        mov     current_room_num, 0FFh  ; (31E4:1456=0FFh)
273F:3AD6  C3                                   retn
                              read_palette      endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                  vga_toggle_menu_highlight     proc    near

273F:3AD7  A1 4CE4                              mov     ax, data_segment2
273F:3ADA  8E C0                                mov     es,ax
273F:3ADC  BA 0008                              mov     dx,8                    ; Number of lines
273F:3ADF  B0 F7                                mov     al,0F7h
273F:3AE1                       loc_770:                                        ;  xref 273F:3AFA
273F:3AE1  57                                   push    di
273F:3AE2  8B CB                                mov     cx,bx

273F:3AE4                       locloop_771:                                    ;  xref 273F:3AF2
273F:3AE4  26: 84 05                            test    al,es:[di]
273F:3AE7  74 05                                jz      loc_772                 ; Jump if zero
273F:3AE9  26: 38 05                            cmp     es:[di],al
273F:3AEC  75 03                                jne     loc_773                 ; Jump if not equal
273F:3AEE                       loc_772:                                        ;  xref 273F:3AE7
273F:3AEE  26: 30 05                            xor     es:[di],al
273F:3AF1                       loc_773:                                        ;  xref 273F:3AEC
273F:3AF1  47                                   inc     di
273F:3AF2  E2 F0                                loop    locloop_771             ; Loop if cx > 0

273F:3AF4  5F                                   pop     di
273F:3AF5  81 C7 0140                           add     di,140h
273F:3AF9  4A                                   dec     dx
273F:3AFA  75 E5                                jnz     loc_770                 ; Jump if not zero
273F:3AFC  C3                                   retn

                  vga_toggle_menu_highlight     endp

273F:3AFD  00                                   db      0

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                     copy_protection_check      proc    near

273F:3AFE  F6 06 1854 FF                        test    cp_num_digits, 0FFh     ; Sequence previously entered?
273F:3B03  74 01                                jz      loc_3B06
273F:3B05  C3                                   ret
273F:3B06  8B 04              loc_3B06:         mov     ax, [si]
273F:3B08  E8 86 01                             call    read_screen_alt
273F:3B0B  BB 1830                              mov     bx, offset animation_rec_1
273F:3B0E  E8 D1 3C                             call    animation_decode
273F:3B11  BB 1839                              mov     bx, offset animation_rec_2
273F:3B14  E8 CB 3C                             call    animation_decode
273F:3B17  BB 1842                              mov     bx, offset animation_rec_3
273F:3B1A  E8 C5 3C                             call    animation_decode

; Make a backup copy of the first 10 animation table entries

273F:3B1D  A1 4D00                              mov     ax, buffer_segment
273F:3B20  8EC0                                 mov     es, ax
273F:3B22  BE4EB1                               mov     si, offset animation_table
273F:3B25  33FF                                 xor     di, di
273F:3B27  B9CD00                               mov     cx, ANIMATION_SLOT_SIZE*10/2 ; 00CDh
273F:3B2A  F3 A5                                rep     movsw

; Current hard coded jump to bypass copy protection code

273F:3B2C  E92401                               jmp     loc_784

; Original program's code below

273F:3B2C  1E                                   push    ds
273F:3B2D  07                                   pop     es
273F:3B2E  BF B14E                              mov     di, offset animation_table
273F:3B31  BE 1850                              mov     si, offset anim_src_table
273F:3B34  BB 1830                              mov     bx, offset animation_rec_1
273F:3B37  8B4703                               mov     ax, [bx+3]
273F:3B3A  B200                                 mov     dl, 0
273F:3B3C  E8BE01                               call    animation_set_entry
273F:3B3F  E8BB01                               call    animation_set_entry
273F:3B42  BB3918                               mov     bx, offset animation_rec_2
273F:3B45  8B4703                               mov     ax, [bx+03]
273F:3B48  B220                                 mov     dl, 20
273F:3B4A  E8B001                               call    animation_set_entry
273F:3B4D  BB4218                               mov     bx, offset animation_rec_3
273F:3B50  8B4703                               mov     ax, [bx+3]
273F:3B53  E8A701                               call    animation_set_entry
273F:3B56  E8A401                               call    animation_set_entry
273F:3B59  E8A101                               call    animation_set_entry
273F:3B5C  E89E01                               call    animation_set_entry
273F:3B5F  FF164407                             call    [show_screen_proc]
273F:3B63  FF166207                             call    [set_lower_palette_proc]

273F:3B67                       loc_774:                                        ;  xref 273F:3C48
273F:3B67 B8 0002                              mov     ax,2
273F:3B6A BB 0001                              mov     bx,1                    ; (273F:0001=0E4h)
273F:3B6D  E8 0169                              call    animation_draw
273F:3B70  FF 16 0744                           call    word ptr [show_screen_proc]
273F:3B74                       loc_775:                                        ;  xref 273F:3B82
273F:3B74  B8 0005                              mov     ax,5
273F:3B77  E8 0E6F                              call    sleep                   ; (49E9)
273F:3B7A  E8 00EE                              call    protection_cycle_characters
273F:3B7D  F6 06 11D5 FF                        test    mouse_buttons, 0FFh
273F:3B82  75 F0                                jnz     loc_775                 ; Jump if not zero
273F:3B84                       loc_776:                                        ;  xref 273F:3B87
273F:3B84  E8 5999                              call    check_keypress                 ; (9520)
273F:3B87  75 FB                                jnz     loc_776                 ; Jump if not zero

273F:3B89                       loc_777:                                        ;  xref 273F:3B9C
273F:3B89  B8 0005                              mov     ax,5
273F:3B8C  E8 0E5A                              call    sleep                   ; (49E9)
273F:3B8F  E8 00D9                              call    protection_cycle_characters
273F:3B92  E8 598B                              call    check_keypress                 ; (9520)
273F:3B95  75 07                                jnz     loc_778                 ; Jump if not zero
273F:3B97  F6 06 11D5 FF                        test    mouse_buttons, 0FFh
273F:3B9C  74 EB                                jz      loc_777                 ; Jump if zero
273F:3B9E                       loc_778:                                        ;  xref 273F:3B95
273F:3B9E  B8 0002                              mov     ax,2                    ; Change title text
273F:3BA1  33 DB                                xor     bx,bx                   ; Anim #2, frame #0
273F:3BA3  E8 0133                              call    animation_draw
273F:3BA6  FF 16 0744                           call    word ptr [show_screen_proc]
273F:3BAA  C6 06 1854 00                        mov     cp_num_digits, 0

273F:3BAF                       loc_779:                                        ; Get keypress
273F:3BAF E8 596E                              call    check_keypress
273F:3BB2  74 FB                                jz      loc_779
273F:3BB4  3C 08                                cmp     al,8                    ; Backspace?
273F:3BB6  74 28                                je      cp_backspace            ; Jump if equal
273F:3BB8  3C 30                                cmp     al,30h                  ; '0'
273F:3BBA  72 F3                                jb      loc_779                 ; Jump if below
273F:3BBC  3C 3A                                cmp     al,3Ah                  ; '9' + 1
273F:3BBE  73 EF                                jae     loc_779                 ; Jump if above or =

; At this point a numeric key has been pressed

273F:3BC0  25 000F                              and     ax,0Fh
273F:3BC3  8B D8                                mov     bx,ax
273F:3BC5  A0 1854                              mov     al, cp_num_digits
273F:3BC8  05 0003                              add     ax,3
273F:3BCB  E8 010B                              call    animation_draw
273F:3BCE  FF 16 0744                           call    word ptr [show_screen_proc]
273F:3BD2  80 06 1854 01                        add     cp_num_digits, 1
273F:3BD7  80 3E 1854 04                        cmp     cp_num_digits, 4
273F:3BDC  72 D1                                jb      loc_779                 ; Jump if below
273F:3BDE  73 1F                                jnc     cp_done                 ; Entered all 4 digits

273F:3BE0                    cp_backspace:                                      ;  xref 273F:3BB6
273F:3BE0  F6 06 1854 FF                        test    cp_num_digits, 0FFh
273F:3BE5  74 C8                                jz      loc_779                 ; Jump if zero
273F:3BE7  80 2E 1854 01                        sub     cp_num_digits, 1
273F:3BEC  A0 1854                              mov     al, cp_num_digits
273F:3BEF  04 03                                add     al,3
273F:3BF1  32 E4                                xor     ah,ah                   ; Zero register
273F:3BF3 BB 000A                              mov     bx,0Ah                  ; (273F:000A=23h)
273F:3BF6  E8 00E0                              call    animation_draw
273F:3BF9  FF 16 0744                           call    word ptr [show_screen_proc]
273F:3BFD  EB B0                                jmp     short loc_779           ; (3BAF)

; At this point four digits have been entered, so it's time to check if it's valid

273F:3BFF                       cp_done:                                        ;  xref 273F:3BDE
273F:3BFF  C7 06 38B1 0000                      mov     time_ctr, 0
273F:3C05                       loc_782:                                        ;  xref 273F:3C0B
273F:3C05  81 3E 38B1 00C8                      cmp     time_ctr, 0C8h
273F:3C0B  72 F8                                jb      loc_782

273F:3C0D  FF 16 1856                           call    [cp_proc]
273F:3C11  73 7D                                jnc     loc_ret_786             ; Numbers correct

; Redraw the originally displayed message

273F:3C13  C6 06 1854 00                        mov     cp_num_digits, 0
273F:3C18  B8 0003                              mov     ax,3
273F:3C1B BB 000A                              mov     bx,0Ah                  ; (273F:000A=23h)
273F:3C1E  E8 00B8                              call    animation_draw
273F:3C21  B8 0004                              mov     ax,4
273F:3C24 BB 000A                              mov     bx,0Ah                  ; (273F:000A=23h)
273F:3C27  E8 00AF                              call    animation_draw
273F:3C2A  B8 0005                              mov     ax,5
273F:3C2D BB 000A                              mov     bx,0Ah                  ; (273F:000A=23h)
273F:3C30  E8 00A6                              call    animation_draw
273F:3C33  B8 0006                              mov     ax,6
273F:3C36 BB 000A                              mov     bx,0Ah                  ; (273F:000A=23h)
273F:3C39  E8 009D                              call    animation_draw
273F:3C3C  80 06 1855 01                        add     cp_num_tries, 1
273F:3C41  80 3E 1855 03                        cmp     cp_num_tries, 3
273F:3C46  73 03                                jae     loc_783                 ; Jump if above or =
273F:3C48  E9 FF1C                              jmp     loc_774                 ; (3B67)
273F:3C4B                       loc_783:                                        
273F:3C4B  B8 000A                              mov     ax,0Ah                  ; Copy protection failed
273F:3C4E  B6 01                                mov     dh,1
273F:3C50  E8 0351                              call    display_message         ; (3FA4)

; Restore the backup copy of the current animation table

273F:3C53                       loc_784:
273F:3C53  1E                                   push    ds
273F:3C54  1E                                   push    ds
273F:3C55  07                                   pop     es
273F:3C56  A1 4D00                              mov     ax, buffer_segment
273F:3C59  8E D8                                mov     ds,ax
273F:3C5B  33 F6                                xor     si,si                   ; Zero register
273F:3C5D BF B14E                              mov     di, offset animation_table
273F:3C60  B9 00CD                              mov     cx, ANIMATION_SLOT_SIZE*10/2 ; 0CDh
273F:3C63  F3/ A5                               rep     movsw                   ; Rep when cx >0 Mov [si] to es:[di]
273F:3C65  1F                                   pop     ds
273F:3C66  FF 16 0766                           call    word ptr ds:[fade_out_proc]
273F:3C6A  C3                                   retn

                     copy_protection_check      endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:3B7A, 3B8F
                                ;

273F:3C6B       protection_cycle_characters     proc    near

273F:3C6B  56                                   push    si
273F:3C6C  57                                   push    di
273F:3C6D  06                                   push    es
273F:3C6E  B9 0014                              mov     cx,14h

; Loop below to choose two random frames from the animation of possible characters.
; If both selections are identical, it will loop back and re-generate two new values

273F:3C71                       loc_785:                                        ;  xref 273F:3C81
273F:3C71  E8 07F8                              call    random
273F:3C74  F7 E1                                mul     cx                      ; dx:ax = reg * ax
273F:3C76  8B DA                                mov     bx,dx
273F:3C78  E8 07F1                              call    random
273F:3C7B  F7 E1                                mul     cx                      ; dx:ax = reg * ax
273F:3C7D  8B C2                                mov     ax,dx
273F:3C7F  3B C3                                cmp     ax,bx                   ; Prevent both images
273F:3C81  74 EE                                je      loc_785                 ;  being identical

273F:3C83  E8 0045                              call    protection_draw_characters
273F:3C86  E8 F4D0                              call    wait_for_video_port     
273F:3C89  FF 16 0744                           call    word ptr [show_screen_proc]
273F:3C8D  07                                   pop     es
273F:3C8E  5F                                   pop     di
273F:3C8F  5E                                   pop     si

273F:3C90                       loc_ret_786:                                    ;  xref 273F:3C11
273F:3C90  C3                                   retn

                protection_cycle_characters     endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:3D22
                                ;

273F:3C91                read_screen_alt        proc    near
273F:3C91  50                                   push    ax
273F:3C92  2D 0001                              sub     ax,1
273F:3C95  E8 FE2F                              call    read_palette            ; (3AC7)
273F:3C98  E8 336A                              call    menubar_clear_image
273F:3C9B  58                                   pop     ax
273F:3C9C  8B 0E 4CE2                           mov     cx, data_segment
273F:3CA0  BA 0080                              mov     dx,80h
273F:3CA3  E8 C66E                              call    read_entry              ; (0314)
273F:3CA6  A1 4CE4                              mov     ax, data_segment2
273F:3CA9  8B 1E 074C                           mov     bx, menubar_block_size
273F:3CAD  B1 04                                mov     cl,4
273F:3CAF  D3 EB                                shr     bx,cl                   ; Shift w/zeros fill
273F:3CB1  03 C3                                add     ax,bx
273F:3CB3  8E C0                                mov     es,ax
273F:3CB5  8B 16 4CE2                           mov     dx, data_segment
273F:3CB9  FF 16 077C                           call    [decode_entry_proc]
273F:3CBD  E8 CCA1                              call    clear_hotspot_rects
273F:3CC0  80 0E 11D0 10                        or      menubar_state, 10h      ; (273F:11D0=56h)
273F:3CC5  80 26 11D0 DF                        and     menubar_state, 0DFh     ; (273F:11D0=56h)
273F:3CCA  C3                                   retn
                         read_screen_alt        endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:3C83
                                ;

273F:3CCB        protection_draw_characters     proc    near
273F:3CCB  50                                   push    ax
273F:3CCC  B8 0001                              mov     ax,1
273F:3CCF  E8 0007                              call    animation_draw          ; Draw right character
273F:3CD2  5B                                   pop     bx
273F:3CD3  33 C0                                xor     ax,ax
273F:3CD5  E8 0001                              call    animation_draw          ; Draw left character
273F:3CD8  C3                                   retn
                 protection_draw_characters     endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:3B6D, 3BA3, 3BCB, 3BF6, 3C1E, 3C27, 3C30
                                ;                             3C39, 3CCF, 3CD5, 3D48, 3D51, 3D8F, 3D98
                                ;                             3DE1, 3DEA, 3E11, 3E1A
                                ;

                            animation_draw      proc    near
273F:3CD9  B9 0029                              mov     cx, ANIMATION_SLOT_SIZE
273F:3CDC  F7 E1                                mul     cx
273F:3CDE  05 B14E                              add     ax, offset animation_table ; Calculate anim offset
273F:3CE1  93                                   xchg    bx,ax
273F:3CE2  8B 77 19                             mov     si,[bx+19h]             ; Get address for hotspot
273F:3CE5  F7 64 07                             mul     word ptr [si+7]         ; multiply by frame size
273F:3CE8  8B F0                                mov     si,ax                   ; Store pixel data start
273F:3CEA  89 77 08                             mov     [bx+8],si               
273F:3CED  53                                   push    bx
273F:3CEE  FF 77 0A                             push    word ptr [bx+0Ah]       ; Pixel segment
273F:3CF1  07                                   pop     es
273F:3CF2  FF 16 0754                           call    [add_animation_proc]
273F:3CF6  5F                                   pop     di
273F:3CF7  B0 01                                mov     al,1
273F:3CF9  E8 CE2C                              call    flag_covered_cells
273F:3CFC  C3                                   retn
                            animation_draw      endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:3D3E, 3D41
                                ;

273F:3CFD              animation_set_entry      proc    near

273F:3CFD  89 45 0A                             mov     [di+0Ah],ax
273F:3D00  89 5D 19                             mov     [di+19h],bx
273F:3D03  88 55 28                             mov     [di+28h],dl
273F:3D06  B9 0004                              mov     cx,4
273F:3D09  F3/ A5                               rep     movsw        ; Copy first 8 bytes
273F:3D0B  83 C7 21                             add     di, ANIMATION_SLOT_SIZE - 8
273F:3D0E  C3                                   retn

                       animation_set_entry      endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                                  cp_proc_1     proc    near

273F:3D0F  E8 075A                              call    random
273F:3D12  8A 1E 1855                           mov     bl, cp_num_tries
273F:3D16  F6 26 1854                           mul     cp_num_digits           ; ax = data * al
273F:3D1A  F8                                   clc                             ; Clear carry flag
273F:3D1B  0B C0                                or      ax,ax                   ; Zero ?
273F:3D1D  C3                                   retn

                                  cp_proc_1     proc    near

273F:3D1E  00                                   db      0

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:937C
                                ;

273F:3D1F           restart_restore_dialog      proc    near

273F:3D1F  B8 7900                              mov     ax,7900h                ; Restart/Restore image
273F:3D22  E8 FF6C                              call    sub_79                  ; Decode it
273F:3D25 BB 184B                              mov     bx,offset data_657
273F:3D28  E8 3AB7                              call    animation_decode
273F:3D2B  E8 E247                              call    show_arrow_cursor
273F:3D2E  1E                                   push    ds
273F:3D2F  07                                   pop     es
273F:3D30 BF B14E                              mov     di, offset animation_table
273F:3D33 BE 1890                              mov     si,1890h                ; (31E4:1890=0F6h)
273F:3D36 BB 184B                              mov     bx,offset data_657      ; (31E4:184B=1)
273F:3D39  8B 47 03                             mov     ax,[bx+3]
273F:3D3C  B2 00                                mov     dl,0
273F:3D3E  E8 FFBC                              call    animation_set_entry                  ; (3CFD)
273F:3D41  E8 FFB9                              call    animation_set_entry                  ; (3CFD)
273F:3D44  33 C0                                xor     ax,ax                   ; Zero register
273F:3D46  33 DB                                xor     bx,bx                   ; Zero register
273F:3D48  E8 FF8E                              call    animation_draw
273F:3D4B  B8 0001                              mov     ax,1
273F:3D4E BB 0001                              mov     bx,offset copyright+1   ; (31E4:0001='o')
273F:3D51  E8 FF85                              call    animation_draw
273F:3D54  FF 16 0744                           call    word ptr [show_screen_proc]
273F:3D58  FF 16 0760                           call    word ptr [fade_in_proc]
273F:3D5C  C6 06 11DA 00                        mov     mouse_buttons2, 0
273F:3D61                       loc_787:                                        ;  xref 273F:3DB0, 3E02, 3E30
273F:3D61 FF 16 0744                           call    word ptr [show_screen_proc]
273F:3D65                       loc_788:                                        ;  xref 273F:3DA8
273F:3D65  E8 5660                              call    room_check_keypresses
273F:3D68  A1 11D6                              mov     ax, mouse_x2  
273F:3D6B  05 0080                              add     ax,80h
273F:3D6E  2B 06 1890                           sub     ax,word ptr ds:[1890h]  ; (31E4:1890=0F6h)
273F:3D72  72 47                                jc      loc_791                 ; Jump if carry Set
273F:3D74  3D 0025                              cmp     ax,25h
273F:3D77  73 42                                jae     loc_791                 ; Jump if above or =
273F:3D79  A1 11D8                              mov     ax, mouse_y2  
273F:3D7C  05 0080                              add     ax,80h
273F:3D7F  2B 06 1892                           sub     ax,word ptr ds:[1892h]  ; (31E4:1892=118h)
273F:3D83  72 36                                jc      loc_791                 ; Jump if carry Set
273F:3D85  3D 000E                              cmp     ax,0Eh
273F:3D88  73 31                                jae     loc_791                 ; Jump if above or =
273F:3D8A  33 C0                                xor     ax,ax                   ; Zero register
273F:3D8C BB 0002                              mov     bx,offset copyright+2   ; (31E4:0002='py')
273F:3D8F  E8 FF47                              call    animation_draw
273F:3D92  B8 0001                              mov     ax,1
273F:3D95 BB 0001                              mov     bx,offset copyright+1   ; (31E4:0001='o')
273F:3D98  E8 FF3E                              call    animation_draw
273F:3D9B  F6 06 11DA FF                        test    mouse_buttons2, 0FFh
273F:3DA0  75 10                                jnz     loc_790                 ; Jump if not zero
273F:3DA2  2E: 80 3E 3D1E 01                    cmp     cs:data_288,1           ; (273F:3D1E=0)
273F:3DA8                       loc_789:                                        ;  xref 273F:3DFA
273F:3DA8  74 BB                                je      loc_788                 ; Jump if equal
273F:3DAA  2E: C6 06 3D1E 01                    mov     cs:data_288,1           ; (273F:3D1E=0)
273F:3DB0  EB AF                                jmp     short loc_787           ; (3D61)
273F:3DB2                       loc_790:                                        ;  xref 273F:3DA0
273F:3DB2  C6 06 11DA 00                        mov     mouse_buttons2, 0
273F:3DB7  0D 0001                              or      ax,1
273F:3DBA  C3                                   retn
273F:3DBB                       loc_791:                                        ;  xref 273F:3D72, 3D77, 3D83, 3D88
273F:3DBB  A1 11D6                              mov     ax, mouse_x2
273F:3DBE  05 0080                              add     ax,80h
273F:3DC1  2B 06 1898                           sub     ax,word ptr ds:[1898h]  ; (31E4:1898=128h)
273F:3DC5  72 46                                jc      loc_794                 ; Jump if carry Set
273F:3DC7  3D 0025                              cmp     ax,25h
273F:3DCA  73 41                                jae     loc_794                 ; Jump if above or =
273F:3DCC  A1 11D8                              mov     ax, mouse_y2
273F:3DCF  05 0080                              add     ax,80h
273F:3DD2  2B 06 189A                           sub     ax,word ptr ds:[189Ah]  ; (31E4:189A=118h)
273F:3DD6  72 35                                jc      loc_794                 ; Jump if carry Set
273F:3DD8  3D 000E                              cmp     ax,0Eh
273F:3DDB  73 30                                jae     loc_794                 ; Jump if above or =
273F:3DDD  33 C0                                xor     ax,ax                   ; Zero register
273F:3DDF  33 DB                                xor     bx,bx                   ; Zero register
273F:3DE1  E8 FEF5                              call    animation_draw
273F:3DE4  B8 0001                              mov     ax,1
273F:3DE7 BB 0003                              mov     bx,offset copyright+3   ; (31E4:0003='y')
273F:3DEA  E8 FEEC                              call    animation_draw
273F:3DED  F6 06 11DA FF                        test    mouse_buttons2, 0FFh
273F:3DF2  75 11                                jnz     loc_793                 ; Jump if not zero
273F:3DF4  2E: 80 3E 3D1E 02                    cmp     cs:data_288,2           ; (273F:3D1E=0)
273F:3DFA                       loc_792:                                        ;  xref 273F:3E28
273F:3DFA  74 AC                                je      loc_789                 ; Jump if equal
273F:3DFC  2E: C6 06 3D1E 02                    mov     cs:data_288,2           ; (273F:3D1E=0)
273F:3E02  E9 FF5C                              jmp     loc_787                 ; (3D61)
273F:3E05                       loc_793:                                        ;  xref 273F:3DF2
273F:3E05  C6 06 11DA 00                        mov     mouse_buttons2, 0
273F:3E0A  33 C0                                xor     ax,ax                   ; Zero register
273F:3E0C  C3                                   retn
273F:3E0D                       loc_794:                                        ;  xref 273F:3DC5, 3DCA, 3DD6, 3DDB
273F:3E0D  33 C0                                xor     ax,ax                   ; Zero register
273F:3E0F  33 DB                                xor     bx,bx                   ; Zero register
273F:3E11  E8 FEC5                              call    animation_draw
273F:3E14  B8 0001                              mov     ax,1
273F:3E17 BB 0001                              mov     bx,offset copyright+1   ; (31E4:0001='o')
273F:3E1A  E8 FEBC                              call    animation_draw
273F:3E1D  C6 06 11DA 00                        mov     mouse_buttons2, 0
273F:3E22  2E: F6 06 3D1E FF                    test    cs:data_288,0FFh        ; (273F:3D1E=0)
273F:3E28  74 D0                                jz      loc_792                 ; Jump if zero
273F:3E2A  2E: C6 06 3D1E 00                    mov     cs:data_288,0           ; (273F:3D1E=0)
273F:3E30  E9 FF2E                              jmp     loc_787                 ; (3D61)

                    restart_restore_dialog      endp

273F:3E33  00                                   db      0

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:000B, 009D, 2053, 4792, 4FAB, 5024, 5423
                                ;                             5738, 57D3, 5838, 58DA, 592B, 5AF2, 5B55
                                ;                             5BCF, 5C21, 5C66, 5C87, 5CD7, 5D40, 8A0D
                                ;                             8AFF, 8C52, 8C67, 8C7A, 8CA4, 95F7, 962F
                                ;                             9635
                                ;

273F:3E34                 sequence_execute      proc    near
273F:3E34 57                                   push    di
273F:3E35  56                                   push    si
273F:3E36  55                                   push    bp
273F:3E37  53                                   push    bx
273F:3E38  8B F0                                mov     si,ax
273F:3E3A  C7 06 BA1D 0000                      mov     sequence_result, 0
273F:3E40  E8 000A                              call    sequence_execute_inner
273F:3E43  5B                                   pop     bx
273F:3E44  5D                                   pop     bp
273F:3E45  5E                                   pop     si
273F:3E46  5F                                   pop     di
273F:3E47  A1 BA1D                              mov     ax, sequence_result
273F:3E4A  0B C0                                or      ax,ax                   ; Zero ?
273F:3E4C  C3                                   retn
                          sequence_execute      endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:3E40, 3F51
                                ;


                       sequence_execute_inner   proc    near
273F:3E4D  89 26 1910                           mov     current_sp, sp
273F:3E51  BF 1910                              mov     di, offset current_sp   ; Set up stack frame
273F:3E54  B8 450F                              mov     ax, scripts_seg
273F:3E57  8E C0                                mov     es,ax

273F:3E59                       loc_796:
273F:3E59 26: 8A 1C                            mov     bl,es:[si]
273F:3E5C  83 C6 01                             add     si,1
273F:3E5F  F6 C3 01                             test    bl,1
273F:3E62  74 06                                jz      loc_797                 ; Jump if zero
273F:3E64  26: 8B 14                            mov     dx,es:[si]
273F:3E67  83 C6 02                             add     si,2
273F:3E6A                       loc_797:                                        ;  xref 273F:3E62
273F:3E6A  81 E3 00FE                           and     bx,0FEh
273F:3E6E  FF A7 18A0                           jmp     word ptr ds:[sequence_table][bx]
                       sequence_execute_inner   endp


273F:3E72  8B 05             sequence_add:      mov     ax,[di]
273F:3E74  01 45 02                             add     [di+2],ax
273F:3E77  83 C7 02                             add     di,2
273F:3E7A  EB DD                                jmp     short loc_796           ; (3E59)


                                                                                ;* No entry point to code
273F:3E7C  8B 05         sequence_subtract:     mov     ax,[di]
273F:3E7E  29 45 02                             sub     [di+2],ax
273F:3E81  83 C7 02                             add     di,2
273F:3E84  EB D3                                jmp     short loc_796           ; (3E59)
                                                                                ;* No entry point to code
273F:3E86  8B 05         sequence_multiply:     mov     ax,[di]
273F:3E88  F7 65 02                             mul     word ptr [di+2]         ; dx:ax = data * ax
273F:3E8B  83 C7 02                             add     di,2
273F:3E8E  89 05                                mov     [di],ax
273F:3E90  EB C7                                jmp     short loc_796           ; (3E59)

273F:3E92  8B 45 02        sequence_divide:     mov     ax,[di+2]
273F:3E95  33 D2                                xor     dx,dx                   ; Zero register
273F:3E97  F7 35                                div     word ptr [di]           ; ax,dxrem=dx:ax/data
273F:3E99  83 C7 02                             add     di,2
273F:3E9C  89 05                                mov     [di],ax
273F:3E9E  EB B9                                jmp     short loc_796           ; (3E59)

273F:3EA0  8B 05       sequence_not_equals:     mov     ax,[di]
273F:3EA2  3B 45 02                             cmp     ax,[di+2]
273F:3EA5  74 0A                                je      loc_one                 ; Jump if equal

273F:3EA7 C7 45 02 0000        loc_zero:       mov     word ptr [di+2],0
273F:3EAC  83 C7 02                             add     di,2
273F:3EAF  EB A8                                jmp     short loc_796           ; (3E59)

273F:3EB1 83 C7 02             loc_one:        add     di,2
273F:3EB4  C7 05 0001                           mov     word ptr [di],1
273F:3EB8  EB 9F                                jmp     short loc_796           ; (3E59)
273F:3EBA  8B 05             sequence_equals:   mov     ax,[di]
273F:3EBC  3B 45 02                             cmp     ax,[di+2]
273F:3EBF  75 F0                                jne     loc_one                 ; Jump if not equal
273F:3EC1  EB E4                                jmp     short loc_zero           ; (3EA7)

273F:3EC3  8B 45 02       sequence_greater:     mov     ax,[di+2]
273F:3EC6  2B 05                                sub     ax,[di]
273F:3EC8  72 E7                                jc      loc_one                 ; Jump if carry Set
273F:3ECA  EB DB                                jmp     short loc_zero           ; (3EA7)

273F:3ECC  8B 05          sequence_smaller:     mov     ax,[di]
273F:3ECE  2B 45 02                             sub     ax,[di+2]
273F:3ED1  72 DE                                jc      loc_one                 ; Jump if carry Set
273F:3ED3  EB D2                                jmp     short loc_zero           ; (3EA7)

273F:3ED5  8B 05          sequence_smaller2:    mov     ax,[di]
273F:3ED7  2B 45 02                             sub     ax,[di+2]
273F:3EDA  78 CB                                js      loc_zero                 ; Jump if sign=1
273F:3EDC  EB D3                                jmp     short loc_one           ; (3EB1)

273F:3EDE  8B 45 02       sequence_greater2:    mov     ax,[di+2]
273F:3EE1  2B 05                                sub     ax,[di]
273F:3EE3  78 C2                                js      loc_zero                 ; Jump if sign=1
273F:3EE5  EB CA                                jmp     short loc_one           ; (3EB1)

273F:3EE7  8B 05               sequence_and:    mov     ax,[di]
273F:3EE9  21 45 02                             and     [di+2],ax
273F:3EEC  83 C7 02                             add     di,2
273F:3EEF  E9 FF67                              jmp     loc_796                 ; (3E59)

273F:3EF2  8B 05                sequence_or:    mov     ax,[di]
273F:3EF4  09 45 02                             or      [di+2],ax
273F:3EF7  83 C7 02                             add     di,2
273F:3EFA  E9 FF5C                              jmp     loc_796                 ; (3E59)

273F:3EFD  F7 45 02 FFFF  sequence_logical_and: test    word ptr [di+2],0FFFFh
273F:3F02  74 A3                                jz      loc_zero                 ; Jump if zero
273F:3F04  F7 05 FFFF                           test    word ptr [di],0FFFFh
273F:3F08  74 9D                                jz      loc_zero                 ; Jump if zero
273F:3F0A  EB A5                                jmp     short loc_one           ; (3EB1)

273F:3F0C  F7 45 02 FFFF  sequence_logical_or: test    word ptr [di+2],0FFFFh
273F:3F11  75 9E                                jnz     loc_one                 ; Jump if not zero
273F:3F13  F7 05 FFFF                           test    word ptr [di],0FFFFh
273F:3F17  75 98                                jnz     loc_one                 ; Jump if not zero
273F:3F19  EB 8C                                jmp     short loc_zero           ; (3EA7)

273F:3F1B  83 EF 02       sequence_get_field:   sub     di,2
273F:3F1E  81 C2 BA15                           add     dx, offset room_number_2
273F:3F22  57                                   push    di
273F:3F23  8B FA                                mov     di,dx
273F:3F25  8B 05                                mov     ax,[di]
273F:3F27  5F                                   pop     di
273F:3F28  89 05                                mov     [di],ax
273F:3F2A  E9 FF2C                              jmp     loc_796                 ; (3E59)

273F:3F2D  81 C2 BA15     sequence_set_field:   add     dx, offset room_number_2
273F:3F31  8B 05                                mov     ax,[di]                 ; Get value off stack
273F:3F33  57                                   push    di
273F:3F34  8B FA                                mov     di,dx
273F:3F36  89 05                                mov     [di],ax                 ; Set field value
273F:3F38  5F                                   pop     di
273F:3F39  83 C7 02                             add     di,2                    ; Pop stack element
273F:3F3C  E9 FF1A                              jmp     loc_796

273F:3F3F  E8 052A           sequence_random:   call    random
273F:3F42  8A D4                                mov     dl,ah
273F:3F44  32 F6                                xor     dh,dh                   ; Zero register

273F:3F46  83 EF 02      sequence_push_value:   sub     di,2
273F:3F49  89 15                                mov     [di],dx
273F:3F4B  E9 FF0B                              jmp     loc_796                 ; (3E59)
                                                                                ;* No entry point to code
273F:3F4E  56            sequence_subroutine:   push    si
273F:3F4F  8B F2                                mov     si,dx
273F:3F51  E8 FEF9                              call    sequence_execute_inner
273F:3F54  5E                                   pop     si
273F:3F55                       loc_800:                                        ;  xref 273F:3F97
273F:3F55  E9 FF01                              jmp     loc_796                 ; (3E59)

273F:3F58  D1 E2        sequence_call_method:   shl     dx,1
273F:3F5A  81 C2 BABF                           add     dx, offset sequence_method_list
273F:3F5E  57                                   push    di
273F:3F5F  8B FA                                mov     di,dx
273F:3F61  8B 05                                mov     ax,[di]                 ; Get address of method
273F:3F63  5F                                   pop     di
273F:3F64 81 FF 1910                           cmp     di, offset current_sp   ; Any value on stack?
273F:3F68  74 1B                                je      loc_801                 ; No, so go call method
273F:3F6A  8B 1D                                mov     bx,[di]                 ; bx = top stack value
273F:3F6C  83 C7 02                             add     di,2
273F:3F6F 81 FF 1910                           cmp     di, offset current_sp   ; Any value on stack?
273F:3F73  74 10                                je      loc_801                 ; No, so go call method
273F:3F75  8B 0D                                mov     cx,[di]                 ; cx = top stack value
273F:3F77  83 C7 02                             add     di,2
273F:3F7A 81 FF 1910                           cmp     di, offset current_sp   ; Any value on stack?
273F:3F7E  74 05                                je      loc_801                 ; No, so go call method
273F:3F80  8B 15                                mov     dx,[di]                 ; dx = top stack value
273F:3F82  83 C7 02                             add     di,2
273F:3F85                       loc_801:
273F:3F85  56                                   push    si
273F:3F86  57                                   push    di
273F:3F87  06                                   push    es
273F:3F88  FF D0                                call    ax                      ; Call method
273F:3F8A  07                                   pop     es
273F:3F8B  5F                                   pop     di
273F:3F8C  5E                                   pop     si
273F:3F8D  E9 FEC9                              jmp     loc_796                 ; (3E59)

273F:3F90  8B 05        sequence_cond_jump:     mov     ax,[di]
273F:3F92  83 C7 02                             add     di,2
273F:3F95  0B C0                                or      ax,ax                   ; Zero ?
273F:3F97  75 BC                                jnz     loc_800                 ; Jump if not zero
273F:3F99  03 F2             sequence_jump:     add     si,dx
273F:3F9B  E9 FEBB                              jmp     loc_796                 ; (3E59)

273F:3F9E  C3             sequence_end:         retn

273F:3F9F  8B 26 10 19    sequence_restore_sp:  mov     sp, current_sp
273F:3FA3  C3                                   retn

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:029A, 02A6, 0365, 03BB, 03C7, 0426, 04FC
                                ;                             0691, 3C50, 7041, 7591, 7B04, 902C, 9414
                                ;                             AA1B
                                ;

273F:3FA4                       display_message proc    near
273F:3FA4  80 0E 073D 01                        or      status_flags2, 1
273F:3FA9  80 0E 11D0 08                        or      menubar_state, 8   
273F:3FAE  3D 000C                              cmp     ax,0Ch
273F:3FB1  72 03                                jb      loc_802                 ; Jump if below
273F:3FB3  B8 000C                              mov     ax,0Ch
273F:3FB6                       loc_802:                                        ;  xref 273F:3FB1
273F:3FB6  F6 C6 FF                             test    dh,0FFh
273F:3FB9  75 03                                jnz     loc_803                 ; Jump if not zero
273F:3FBB  E9 0128                              jmp     loc_816                 ; (40E6)
273F:3FBE                       loc_803:                                        ;  xref 273F:3FB9
273F:3FBE  50                                   push    ax
273F:3FBF  B8 31E4                              mov     ax,data_seg
273F:3FC2  8E D8                                mov     ds,ax
273F:3FC4  F6 06 073C 04                        test    status_flags, STATUS_TIMER_SET
273F:3FC9  74 12                                jz      loc_804                 ; Jump if zero
273F:3FCB  1E                                   push    ds
273F:3FCC  2E: A1 04AC                          mov     ax,word ptr cs:old_timer_int_proc+2 ; (273F:04AC=40h)
273F:3FD0  8E D8                                mov     ds,ax
273F:3FD2  2E: 8B 16 04AA                       mov     dx,cs:old_timer_int_proc
273F:3FD7  B8 2508                              mov     ax,2508h
273F:3FDA  CD 21                                int     21h                     ; DOS Services  ah=function 25h
                                                                                ;  set intrpt vector al to ds:dx
273F:3FDC  1F                                   pop     ds
273F:3FDD                       loc_804:                                        ;  xref 273F:3FC9
273F:3FDD  F6 06 073C 10                        test    status_flags, STATUS_CRITICAL_SET
273F:3FE2  74 12                                jz      loc_805                 ; Jump if zero
273F:3FE4  1E                                   push    ds
273F:3FE5  2E: A1 04B4                          mov     ax,cs:old_critical_int_proc+2
273F:3FE9  8E D8                                mov     ds,ax
273F:3FEB  2E: 8B 16 04B2                       mov     dx,cs:old_critical_int_proc
273F:3FF0  B8 2524                              mov     ax,2524h
273F:3FF3  CD 21                                int     21h                     ; DOS Services  ah=function 25h
                                                                                ;  set intrpt vector al to ds:dx
273F:3FF5  1F                                   pop     ds
273F:3FF6                       loc_805:                                        ;  xref 273F:3FE2
273F:3FF6  F6 06 073C 40                        test    status_flags, STATUS_KEYBOARD_SET
273F:3FFB  74 12                                jz      loc_806                 ; Jump if zero
273F:3FFD  1E                                   push    ds
273F:3FFE  2E: A1 04B0                          mov     ax, word ptr cs:old_kbd_int_proc+2
273F:4002  8E D8                                mov     ds,ax
273F:4004  2E: 8B 16 04AE                       mov     dx, cs:old_kbd_int_proc
273F:4009  B8 2509                              mov     ax,2509h
273F:400C  CD 21                                int     21h                     ; DOS Services  ah=function 25h
                                                                                ;  set intrpt vector al to ds:dx
273F:400E  1F                                   pop     ds
273F:400F                       loc_806:                                        ;  xref 273F:3FFB
273F:400F  F6 06 073C 01                        test    status_flags, STATUS_VIDEO_MODE_SET
273F:4014  74 07                                jz      loc_807                 ; Jump if zero
273F:4016  A0 073B                              mov     al,data_542             ; (31E4:073B=0)
273F:4019  32 E4                                xor     ah,ah                   ; Zero register
273F:401B  CD 10                                int     10h                     ; Video display   ah=functn 00h
                                                                                ;  set display mode in al
273F:401D                       loc_807:                                        ;  xref 273F:4014
273F:401D  B8 0000                              mov     ax,0
273F:4020  CD 33                                int     33h                     ; Mouse driver    ax=func 0000h
                                                                                ;  installed?, ax=0 no, =-1 yes
                                                                                ;   bx=number of mouse buttons
273F:4022  F6 06 073C 08                        test    status_flags, STATUS_CTRL_BREAK_SET
273F:4027  74 24                                jz      loc_808                 ; Jump if zero
273F:4029  B8 3301                              mov     ax,3301h
273F:402C  8A 16 073E                           mov     dl, old_ctrl_break_flag
273F:4030  CD 21                                int     21h                     ; DOS Services  ah=function 33h
                                                                                ;  set ctrl-break flag dl=off/on
273F:4032  B8 0040                              mov     ax,40h
273F:4035  8E C0                                mov     es,ax
273F:4037  A0 073F                              mov     al,data_546             ; (31E4:073F=1)
273F:403A  24 70                                and     al,70h                  ; 'p'
273F:403C  26: 80 26 0017 8F                    and     byte ptr es:keybd_flags_1,8Fh ; (0040:0017=0)
273F:4042  26: 08 06 0017                       or      es:keybd_flags_1,al     ; (0040:0017=0)
273F:4047  B4 06                                mov     ah,6
273F:4049  B2 FF                                mov     dl,0FFh
273F:404B  CD 21                                int     21h                     ; DOS Services  ah=function 06h
                                                                                ;  special char i/o, dl=subfunc
273F:404D                       loc_808:                                        ;  xref 273F:4027
273F:404D  58                                   pop     ax
273F:404E  0B C0                                or      ax,ax                   ; Zero ?
273F:4050  74 15                                jz      loc_809                 ; Jump if zero
273F:4052  50                                   push    ax
273F:4053  B4 09                                mov     ah,9
273F:4055 BA 3848                              mov     dx,offset data_779      ; (31E4:3848='')
273F:4058  CD 21                                int     21h                     ; DOS Services  ah=function 09h
                                                                                ;  display char string at ds:dx
273F:405A  58                                   pop     ax
273F:405B  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:405D  8B D8                                mov     bx,ax
273F:405F  8B 97 3670                           mov     dx,errormsg_list[bx]    ; (31E4:3670=0)
273F:4063  B4 09                                mov     ah,9
273F:4065  CD 21                                int     21h                     ; DOS Services  ah=function 09h
                                                                                ;  display char string at ds:dx
273F:4067                       loc_809:                                        ;  xref 273F:4050
273F:4067  E8 6189                              call    sub_257                 ; (A1F3)
273F:406A  B9 FFFF                              mov     cx,0FFFFh
273F:406D  B0 36                                mov     al,36h                  ; '6'
273F:406F  E6 43                                out     43h,al                  ; port 43h, 8253 timer control
273F:4071  EB 00                                jmp     short $+2               ; delay for I/O
273F:4073  EB 00                                jmp     short $+2               ; delay for I/O
273F:4075  8A C1                                mov     al,cl
273F:4077  E6 40                                out     40h,al                  ; port 40h, 8253 timer 0 clock
273F:4079  EB 00                                jmp     short $+2               ; delay for I/O
273F:407B  EB 00                                jmp     short $+2               ; delay for I/O
273F:407D  8A C5                                mov     al,ch
273F:407F  E6 40                                out     40h,al                  ; port 40h, 8253 timer 0 clock
273F:4081  B0 00                                mov     al,0
273F:4083  B4 4C                                mov     ah,4Ch
273F:4085  CD 21                                int     21h                     ; DOS Services  ah=function 4Ch
                                                                                ;  terminate with al=return code
273F:4087                       loc_810:                                        ;  xref 273F:40F2
273F:4087  50                                   push    ax
273F:4088  A0 073B                              mov     al,data_542             ; (31E4:073B=0)
273F:408B  32 E4                                xor     ah,ah                   ; Zero register
273F:408D  CD 10                                int     10h                     ; Video display   ah=functn 00h
                                                                                ;  set display mode in al
273F:408F  EB 01                                jmp     short loc_812           ; (4092)
273F:4091                       loc_811:                                        ;  xref 273F:40EB
273F:4091  50                                   push    ax
273F:4092                       loc_812:                                        ;  xref 273F:408F
273F:4092  B4 09                                mov     ah,9
273F:4094 BA 3848                              mov     dx,offset data_779      ; (31E4:3848='')
273F:4097  CD 21                                int     21h                     ; DOS Services  ah=function 09h
                                                                                ;  display char string at ds:dx
273F:4099  58                                   pop     ax
273F:409A  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:409C  8B D8                                mov     bx,ax
273F:409E  8B 97 3670                           mov     dx,errormsg_list[bx]    ; (31E4:3670=0)
273F:40A2  83 C2 02                             add     dx,2
273F:40A5  B4 09                                mov     ah,9
273F:40A7  CD 21                                int     21h                     ; DOS Services  ah=function 09h
                                                                                ;  display char string at ds:dx
273F:40A9  B4 09                                mov     ah,9
273F:40AB BA 3848                              mov     dx,offset data_779      ; (31E4:3848='')
273F:40AE  CD 21                                int     21h                     ; DOS Services  ah=function 09h
                                                                                ;  display char string at ds:dx
273F:40B0  F6 06 073C 80                        test    status_flags, STATUS_MOUSE_HANDLER_SET
273F:40B5  74 09                                jz      loc_813                 ; Jump if zero
273F:40B7  B4 09                                mov     ah,9
273F:40B9 BA 37D0                              mov     dx,offset data_777      ; (31E4:37D0='Press a mouse bu')
273F:40BC  CD 21                                int     21h                     ; DOS Services  ah=function 09h
                                                                                ;  display char string at ds:dx
273F:40BE  EB 07                                jmp     short loc_814           ; (40C7)
273F:40C0                       loc_813:                                        ;  xref 273F:40B5
273F:40C0  B4 09                                mov     ah,9
273F:40C2 BA 37F2                              mov     dx,offset data_778      ; (31E4:37F2='and press any ke')
273F:40C5  CD 21                                int     21h                     ; DOS Services  ah=function 09h
                                                                                ;  display char string at ds:dx
273F:40C7                       loc_814:                                        ;  xref 273F:40BE
273F:40C7  E8 DECC                              call    pause_for_input         ; (1F96)
273F:40CA  50                                   push    ax
273F:40CB  E8 DEBD                              call    mouse_wait              ; (1F8B)
273F:40CE  F6 06 073C 01                        test    status_flags, STATUS_VIDEO_MODE_SET
273F:40D3  74 0A                                jz      loc_815                 ; Jump if zero
273F:40D5  A0 0743                              mov     al,video_mode           ; (31E4:0743=0)
273F:40D8  32 E4                                xor     ah,ah                   ; Zero register
273F:40DA  CD 10                                int     10h                     ; Video display   ah=functn 00h
                                                                                ;  set display mode in al
273F:40DC  E8 00A6                              call    set_upper_vga_palette   ; (4185)
273F:40DF                       loc_815:                                        ;  xref 273F:40D3
273F:40DF  58                                   pop     ax
273F:40E0  80 26 073D FE                        and     status_flags2, 0FEh
273F:40E5  C3                                   retn
273F:40E6                       loc_816:                                        ;  xref 273F:3FBB
273F:40E6  F6 06 073C 01                        test    status_flags, STATUS_VIDEO_MODE_SET
273F:40EB  74 A4                                jz      loc_811                 ; Jump if zero
273F:40ED  F6 06 073C 02                        test    status_flags, STATUS_UNKNOWN
273F:40F2  74 93                                jz      loc_810                 ; Jump if zero
273F:40F4  8A 1E 11D0                           mov     bl,data_623             ; (31E4:11D0=3)
273F:40F8  53                                   push    bx
273F:40F9  50                                   push    ax
273F:40FA  80 0E 11D0 01                        or      menubar_state, 1     ; (31E4:11D0=3)
273F:40FF  FF 16 075E                           call    word ptr [show_cursor_proc]
273F:4103  F6 06 11D0 10                        test    menubar_state, 10h   ; (31E4:11D0=3)
273F:4108  75 14                                jnz     loc_817                 ; Jump if not zero
273F:410A  A1 4CE4                              mov     ax, data_segment2
273F:410D  8E C0                                mov     es,ax
273F:410F  33 C0                                xor     ax,ax                   ; Zero register
273F:4111  8B 0E 0746                           mov     cx, screen_size
273F:4115  D1 E9                                shr     cx,1                    ; Shift w/zeros fill
273F:4117  33 FF                                xor     di,di                   ; Zero register
273F:4119  F3/ AB                               rep     stosw                   ; Rep when cx >0 Store ax to es:[di]
273F:411B  E8 C843                              call    clear_hotspot_rects
273F:411E                       loc_817:                                        ;  xref 273F:4108
273F:411E  58                                   pop     ax
273F:411F  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:4121  8B D8                                mov     bx,ax
273F:4123  8B B7 3670                           mov     si,errormsg_list[bx]    ; (31E4:3670=0)
273F:4127  8B 34                                mov     si,[si]
273F:4129  E8 47E1                              call    sub_216                 ; (890D)
273F:412C  F6 06 073C 20                        test    status_flags, STATUS_UNKNOWN2
273F:4131  74 0C                                jz      loc_818                 ; Jump if zero
273F:4133  FF 36 073C                           push    status_flags
273F:4137  FF 16 0762                           call    [set_lower_palette_proc] 
273F:413B  8F 06 073C                           pop     status_flags
273F:413F                       loc_818:                                        ;  xref 273F:4131
273F:413F  E8 DE49                              call    mouse_wait              ; (1F8B)
273F:4142  E8 DE51                              call    pause_for_input         ; (1F96)
273F:4145  5B                                   pop     bx
273F:4146  50                                   push    ax
273F:4147  53                                   push    bx
273F:4148  F6 06 073C 20                        test    status_flags, STATUS_UNKNOWN2
273F:414D  74 09                                jz      loc_819                 ; Jump if zero
273F:414F  80 26 073C DF                        and     status_flags, !STATUS_UNKNOWN2
273F:4154  FF 16 0764                           call    [empty_palette_proc]
273F:4158                       loc_819:                                    
273F:4158  58                                   pop     ax
273F:4159  24 01                                and     al,1
273F:415B  75 09                                jnz     loc_820                 ; Jump if not zero
273F:415D  80 26 11D0 FE                        and     menubar_state, 0FEh  ; (31E4:11D0=3)
273F:4162  FF 16 075E                           call    word ptr [show_cursor_proc]
273F:4166                       loc_820:                                        ;  xref 273F:415B
273F:4166  F6 06 11D0 20                        test    menubar_state, 20h   ; (31E4:11D0=3) ' '
273F:416B  74 0B                                jz      loc_821                 ; Jump if zero
273F:416D  FF 16 0752                           call    [show_compressed_screen_proc]
273F:4171  E8 D39A                              call    room_add_animations
273F:4174  FF 16 0744                           call    word ptr [show_screen_proc]
273F:4178                       loc_821:                                        ;  xref 273F:416B
273F:4178  58                                   pop     ax
273F:4179  80 26 073D FE                        and     status_flags2, 0FEh
273F:417E  C3                                   retn
                                display_message endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                            seq_kill_player     proc    near
273F:417F  80 0E 073D 50                        or      status_flags2, FLAG_RESTART|FLAG_RESTORERESTART ;50h
273F:4184  C3                                   retn
                            seq_kill_player     endp

                                ;
                                ; Sets the upper 16 palette entries of the VGA palette
                                ;
                                ;         Called from:   273F:075B, 40DC
                                ;

273F:4185             set_upper_vga_palette     proc    near
273F:4185  1E                                   push    ds
273F:4186  07                                   pop     es
273F:4187  B8 1012                              mov     ax,1012h
273F:418A  BB 00F0                              mov     bx,0F0h                 ; Start with palette entry #F0h
273F:418D  B9 0010                              mov     cx,10h                  ; Set 16 palette entries
273F:4190 BA 1727                              mov     dx,offset vga_palette   ; es:dx pointer to table
273F:4193  CD 10                                int     10h                     ; Video display   ah=functn 10h
                                                                                ;  set cx color registers from
                                                                                ;   ptr es:dx, bx=first reg
273F:4195  C3                                   retn
                      set_upper_vga_palette     endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:00AF, 0110, 60FF, 9762
                                ;

                            animation_tick      proc    near

273F:4196 BF B14E                              mov     di, offset animation_table
273F:4199  B9 002D                              mov     cx, NUM_ANIMATION_SLOTS

273F:419C                       locloop_822:
273F:419C  F6 45 0C FF                          test    byte ptr [di+0Ch], 0FFh
273F:41A0  74 16                                jz      loc_823

273F:41A2  8B 45 1B                             mov     ax, [di+ANIM_HOTSPOT_ID]
273F:41A5  A3 BA17                              mov     character_hotspot, ax
273F:41A8  89 3E 1927                           mov     active_animation_offset, di
273F:41AC  8B 45 11                             mov     ax, [di+ANIM_TICK_PROC]
273F:41AF  8B 75 19                             mov     si, [di+ANIM_HOTSPOT_OFFSET]
273F:41B2  57                                   push    di
273F:41B3  51                                   push    cx
273F:41B4  FF D0                                call    ax                      ; Call entry's handler proc
273F:41B6  59                                   pop     cx
273F:41B7  5F                                   pop     di

273F:41B8                       loc_823:
273F:41B8  83 C7 29                             add     di, ANIMATION_SLOT_SIZE
273F:41BB  E2 DF                                loop    locloop_822             ; Loop if cx > 0

273F:41BD  C3               null_tick_proc:     retn

                            animation_tick      endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:5F41
                                ;

273F:41BE                action_dispatch        proc    near
273F:41BE C7 44 52 0000                        mov     [si+HS_DEST_HOTSPOT], 0
273F:41C3  8B 5F 01                             mov     bx, [bx+CURRENT_ACTION_SUPPORT_TABLE]
273F:41C6  8B EB                                mov     bp, bx
273F:41C8  8B 1F                                mov     bx, [bx]
273F:41CA  89 1E BB45                           mov     current_action_num, bx
273F:41CE  83 C5 02                             add     bp, 2
273F:41D1  D1 E3                                shl     bx, 1                   ; Shift w/zeros fill
273F:41D3  8B 87 3850                           mov     ax,word ptr ds:[actions2_proc_list][bx]
273F:41D7  FF E0                                jmp     ax
                         action_dispatch        endp

                                ;
                                ;                              JUMP POINT
                                ;
                                ;

273F:41D9                       loc_825:                                        ;  xref 273F:52BB
273F:41D9 8B DE                                mov     bx, si
273F:41DB  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:41DE  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:41E1  F7 44 61 FFFF                        test    word ptr [si+HS_ACTION_OFFSET], 0FFFFh
273F:41E6  74 0F                                jz      loc_826                 ; Jump if zero
273F:41E8  83 6C 61 05                          sub     word ptr [si+HS_ACTION_OFFSET], CURRENT_ACTION_RECORD_SIZE
273F:41EC  83 EB 05                             sub     bx, CURRENT_ACTION_RECORD_SIZE
273F:41EF  C6 44 4D 00                          mov     byte ptr [si+4Dh], 0
273F:41F3  C6 07 02                             mov     byte ptr [bx], CHAR_ACTION_DISPATCH_ACTION
273F:41F6  C3                                   retn
273F:41F7                       loc_826:                                        ;  xref 273F:41E6
273F:41F7  C6 07 00                             mov     byte ptr [bx], CHAR_ACTION_NONE
273F:41FA  81 7D 1B 03E8                        cmp     word ptr [di+ANIM_HOTSPOT_ID], PLAYER_HOTSPOT_ID
273F:41FF  75 0B                                jne     loc_ret_827             ; Jump if not equal
273F:4201  C6 06 9834 00                        mov     cursor_state, CURSORSTATE_NONE
273F:4206  C7 06 11E4 FFFF                      mov     hotspot_name_id2, 0FFFFh

273F:420C                       loc_ret_827:                                    ;  xref 273F:41FF
273F:420C  C3                                   retn


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:51EE, 5FE0
                                ;

               character_translate_movements    proc    near
273F:420D  8B 4C 21                             mov     cx, [si+HS_PIXEL_OFFSET]
273F:4210  8B 44 5A                             mov     ax, [si+HS_MOVEMENT_SRC_OFFSET]
273F:4213  89 44 24                             mov     [si+HS_MOVEMENT_OFFSET], ax
273F:4216  C7 44 26 0000                        mov     word ptr [si+HS_STEP_CTR], 0
273F:421B  C7 44 28 0000                        mov     word ptr [si+HS_FRAME_OFFSET], 0
273F:4220  56                                   push    si
273F:4221  57                                   push    di
273F:4222  53                                   push    bx
273F:4223  8B F8                                mov     di, ax
273F:4225  8B F1                                mov     si, cx
273F:4227  8B DA                                mov     bx, dx

273F:4229                       loc_828:
273F:4229 8B 0F                                mov     cx, [bx]
273F:422B  0B C9                                or      cx, cx                  ; No more movements needed?
273F:422D  74 51                                jz      loc_832                 ; Exit if yes
273F:422F  8B 57 02                             mov     dx, [bx+2]              ; Get direction
273F:4232  83 C3 04                             add     bx, 4                   ; Move ptr to next move rec
273F:4235  83 FA 01                             cmp     dx, FACING2_LEFT
273F:4238  74 26                                je      loc_830                 ; Jump if equal
273F:423A  83 FA 02                             cmp     dx, FACING2_RIGHT
273F:423D  74 31                                je      loc_831                 ; Jump if equal
273F:423F  83 FA 04                             cmp     dx, FACING2_UP
273F:4242  74 0E                                je      loc_829                 ; Jump if equal
273F:4244  83 C1 01                             add     cx, 1
273F:4247  D1 E9                                shr     cx, 1
273F:4249  8B 44 0B                             mov     ax, [si+PIXEL_MOVEREC_DOWN]
273F:424C  AB                                   stosw                           ; Store movement records
273F:424D  8B C1                                mov     ax,cx
273F:424F  AB                                   stosw                           ; Store steps
273F:4250  EB D7                                jmp     short loc_828
273F:4252                       loc_829:
273F:4252  83 C1 01                             add     cx, 1
273F:4255  D1 E9                                shr     cx, 1
273F:4257  8B 44 09                             mov     ax, [si+PIXEL_MOVEREC_UP]
273F:425A  AB                                   stosw                           ; Store movement records
273F:425B  8B C1                                mov     ax,cx
273F:425D  AB                                   stosw                           ; Store steps
273F:425E  EB C9                                jmp     short loc_828
273F:4260                       loc_830:
273F:4260  83 C1 03                             add     cx, 3
273F:4263  D1 E9                                shr     cx, 1
273F:4265  D1 E9                                shr     cx, 1
273F:4267  8B 44 0D                             mov     ax, [si+PIXEL_MOVEREC_LEFT]
273F:426A  AB                                   stosw                           ; Store movement records
273F:426B  8B C1                                mov     ax,cx
273F:426D  AB                                   stosw                           ; Store steps
273F:426E  EB B9                                jmp     short loc_828
273F:4270                       loc_831:
273F:4270  83 C1 03                             add     cx, 3
273F:4273  D1 E9                                shr     cx, 1
273F:4275  D1 E9                                shr     cx, 1
273F:4277  8B 44 0F                             mov     ax, [si+PIXEL_MOVEREC_RIGHT]
273F:427A  AB                                   stosw                           ; Store movement records
273F:427B  8B C1                                mov     ax,cx
273F:427D  AB                                   stosw                           ; Store steps
273F:427E  EB A9                                jmp     short loc_828
273F:4280                       loc_832:
273F:4280  B8 FFFF                              mov     ax,0FFFFh
273F:4283  AB                                   stosw                           ; Store end makrer
273F:4284  5B                                   pop     bx
273F:4285  5F                                   pop     di
273F:4286  5E                                   pop     si
273F:4287  C3                                   retn
               character_translate_movements    endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:5242
                                ;

                 character_check_room_change    proc    near
273F:4288 56                                   push    si
273F:4289  8B 45 0E                             mov     ax, [di+ANIM_ROOM_NUM]
273F:428C  E8 CA5B                              call    get_room_resource_pointer2 ; Get room resource
273F:428F  83 C6 1D                             add     si, ROOM_EXITS_START    ; Get pointer to room exits list
273F:4292  8B 05                                mov     ax, [di+ANIM_X]         ; get X start
273F:4294  8B 4D 13                             mov     cx, [di+ANIM_WIDTH_COPY]; Get animation width
273F:4297  D1 E9                                shr     cx, 1
273F:4299  03 C1                                add     ax, cx
273F:429B  8B 55 02                             mov     dx, [di+ANIM_Y]
273F:429E  03 55 15                             add     dx, [di+ANIM_HEIGHT_COPY]
273F:42A1  8B 4D 17                             mov     cx, [di+ANIM_Y_CORRECTION]
273F:42A4  D1 E9                                shr     cx,1
273F:42A6  2B D1                                sub     dx,cx                   ; ax=x, dx=y

273F:42A8                       loc_834:
273F:42A8 83 3C FF                             cmp     word ptr [si],0FFFFh    ; End of list reached?
273F:42AB  74 3A                                je      loc_837                 ; Jump if yes
273F:42AD  3B 04                                cmp     ax, [si+ROOMREC_EXIT_X_START] ; Check bounds of the
273F:42AF  72 27                                jb      loc_836                 ;  room exit against character
273F:42B1  3B 44 02                             cmp     ax, [si+ROOMREC_EXIT_X_END]
273F:42B4  73 22                                jae     loc_836
273F:42B6  3B 54 04                             cmp     dx, [si+ROOMREC_EXIT_Y_START]
273F:42B9  72 1D                                jb      loc_836
273F:42BB  3B 54 06                             cmp     dx, [si+ROOMREC_EXIT_Y_END]
273F:42BE  73 18                                jae     loc_836
273F:42C0  8B 44 08                             mov     ax, [si+ROOMREC_EXIT_SEQUENCE]
273F:42C3  3D FFFF                              cmp     ax, 0FFFFh              ; Any sequence to run?
273F:42C6  74 04                                je      loc_835                 ; If no, go set room directly
273F:42C8  5E                                   pop     si
273F:42C9  E9 FB68                              jmp     sequence_execute
273F:42CC                       loc_835:                                        ;  xref 273F:42C6
273F:42CC  8B 54 0A                             mov     dx, [si+ROOMREC_EXIT_ROOM_NUM] ; Get new room #/direction
273F:42CF  8B 4C 0C                             mov     cx, [si+ROOMREC_EXIT_NEW_X]    ; Get new X
273F:42D2  8B 5C 0E                             mov     bx, [si+ROOMREC_EXIT_NEW_Y]    ; Get new Y
273F:42D5  5E                                   pop     si
273F:42D6  EB 11                                jmp     character_change_room
273F:42D8                       loc_836:
273F:42D8  8B 5C 08                             mov     bx, [si+ROOMREC_EXIT_SEQUENCE] ; Get sequence Id
273F:42DB  83 C6 0A                             add     si, 0Ah                 ; Move to next entry
273F:42DE  0B DB                                or      bx, bx                  ; Did entry have a script?
273F:42E0  79 C6                                jns     loc_834                 ; If not, go check next record
273F:42E2  83 C6 06                             add     si, 6                   ; Skip over room/x/y vals
273F:42E5  EB C1                                jmp     short loc_834           ; Check next record
273F:42E7                       loc_837:
273F:42E7  5E                                   pop     si
273F:42E8  C3                                   retn
                 character_check_room_change    endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:960F, 9628
                                ;

                      character_change_room     proc    near
273F:42E9  A1 BA17                              mov     ax, character_hotspot
273F:42EC  3D 03E8                              cmp     ax, PLAYER_HOTSPOT_ID   ; Is character the player?
273F:42EF  75 2E                                jne     loc_840                 ; Jump if not
273F:42F1  F6 06 9834 FF                        test    cursor_state, 0FFh
273F:42F6  75 26                                jnz     loc_ret_839             ; Jump if not zero

; Room change code for the player
273F:42F8 BE 6CEF                              mov     si, offset player_hotspot_rec
273F:42FB  88 74 50                             mov     [si+HS_DIRECTION], dh
273F:42FE  C6 44 51 00                          mov     byte ptr [si+HS_DIRECTION+1], 0
273F:4302  32 F6                                xor     dh,dh                   ; Zero register
273F:4304  83 EB 30                             sub     bx,30h
273F:4307  89 16 982C                           mov     new_room_number_2, dx
273F:430B  89 0E 982E                           mov     new_room_x, cx
273F:430F  89 1E 9830                           mov     new_room_y, bx
273F:4313  E8 1D23                              call    sub_136                 ; (6039)
273F:4316  75 06                                jnz     loc_ret_839             ; Jump if not zero
273F:4318  C7 06 982C 0000                      mov     new_room_number_2, 0
273F:431E                       loc_ret_839:    retn

; Room change code for other characters
273F:431F                       loc_840:
273F:431F  8B 3E 1927                           mov     di, active_animation_offset
273F:4323  8B 75 19                             mov     si, [di+ANIM_HOTSPOT_OFFSET]
273F:4326  53                                   push    bx
273F:4327  51                                   push    cx
273F:4328  52                                   push    dx
273F:4329  E8 017D                              call    check_for_impinging_characters
273F:432C  5A                                   pop     dx
273F:432D  59                                   pop     cx
273F:432E  5B                                   pop     bx
273F:432F  75 06                                jnz     loc_841                 ; Jump if not zero
273F:4331  33 C0                                xor     ax,ax                   ; Zero register
273F:4333  E8 01F2                              call    set_new_dispatch_action
273F:4336  C3                                   retn
273F:4337                       loc_841:                                        ;  xref 273F:432F
273F:4337  83 E1 F8                             and     cx, 0FFF8h
273F:433A  83 C9 05                             or      cx, 5
273F:433D  89 0D                                mov     [di+ANIM_X], cx
273F:433F  89 4C 0D                             mov     [si+HS_X], cx
273F:4342  8A CE                                mov     cl, dh
273F:4344  32 F6                                xor     dh, dh                  ; Zero register
273F:4346  89 55 0E                             mov     [di+ANIM_ROOM_NUM], dx
273F:4349  89 54 06                             mov     [si+HS_ROOM_NUM], dx
273F:434C  2B 5C 1B                             sub     bx, [si+HS_HEIGHT_COPY]
273F:434F  83 E3 F8                             and     bx, 0FFF8h
273F:4352  89 5D 02                             mov     [di+ANIM_Y], bx
273F:4355  89 5C 0F                             mov     [si+HS_Y], bx
273F:4358  8B DE                                mov     bx, si
273F:435A  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:435D  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:4360  E9 0EE3                              jmp     character_change_room_2
                      character_change_room     endp

                                ;
                                ;                              JUMP POINT
                                ;
                                ;

                 character_update_movement_2:
273F:4363 88 44 44                             mov     [si+HS_CHAR_MODE], al


                   character_update_movement    proc    near
273F:4366 53                                   push    bx
273F:4367  8B DE                                mov     bx, si
273F:4369  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:436C  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:436F  8A 07                                mov     al, [bx]
273F:4371  5B                                   pop     bx
273F:4372  3C 03                                cmp     al, CHAR_ACTION_EXEC_SCRIPT
273F:4374  74 10                                je      loc_ret_845             ; Exit if running script
273F:4376  F6 44 49 FF                          test    byte ptr [si+HS_PATHFIND_COVERED], 0FFh
273F:437A  75 07                                jnz     loc_844                 ; Jump if not zero
273F:437C  C6 44 49 01                          mov     byte ptr [si+HS_PATHFIND_COVERED], 1
273F:4380  E8 2DAB                              call    pathfind_flag_covered_cells
273F:4383                       loc_844:                                        ;  xref 273F:437A
273F:4383  E9 032B                              jmp     character_reset_direction

273F:4386                       loc_ret_845:                                    ;  xref 273F:4374, 438B
273F:4386  C3                                   retn
                   character_update_movement    endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:5050, 50B1, 512D, 5224, 5EC4, 5EF1, 5F5C
                                ;                             7758
                                ;

                    character_pathfind_clear    proc    near
273F:4387  F6 44 49 FF                          test    byte ptr [si+HS_PATHFIND_COVERED], 0FFh
273F:438B  74 F9                                jz      loc_ret_845             ; Jump if zero
273F:438D  C6 44 49 00                          mov     byte ptr [si+HS_PATHFIND_COVERED], 0
273F:4391  E9 2DAF                              jmp     pathfind_clear_covered_cells
                    character_pathfind_clear    endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:56D0, 712F, 7144
                                ;

                          pathfind_get_cell     proc    near
273F:4394  8B 45 0E                             mov     ax, [di+ANIM_ROOM_NUM]
273F:4397  2D 0001                              sub     ax, 1                   ; ax=room # - 1
273F:439A  8B D8                                mov     bx, ax
273F:439C  B1 04                                mov     cl, 4
273F:439E  D3 E3                                shl     bx, cl                  ; bx=(R-1)*16
273F:43A0  2B D8                                sub     bx, ax                  ; bx=(R-1)*15
273F:43A2  B1 03                                mov     cl, 3
273F:43A4  D3 E3                                shl     bx, cl                  ; bx=(R-1)*120
273F:43A6  81 C3 984A                           add     bx, offset pathfind_data2
273F:43AA  8B 45 02                             mov     ax, [di+ANIM_Y]
273F:43AD  2D 0088                              sub     ax, 88h
273F:43B0  03 45 15                             add     ax, [di+ANIM_HEIGHT_COPY]
273F:43B3  2D 0004                              sub     ax, 4
273F:43B6  D3 E8                                shr     ax, cl
273F:43B8  3D 0018                              cmp     ax, 18h                 ; (y+height-8-4) >= 200?
273F:43BB  73 50                                jae     loc_850                 ; If yes then jump to exit
273F:43BD  8B D0                                mov     dx, ax                  ; ax=0->17
273F:43BF  D1 E0                                shl     ax, 1
273F:43C1  D1 E0                                shl     ax, 1                   ; ax=ax*4
273F:43C3  03 C2                                add     ax, dx                  ; ax=ax*5
273F:43C5  03 D8                                add     bx, ax                  ; Add bx onto offset

; At this point bx = (Room# - 1) * 120 + (Y# * 5), where Y# is between 0 to 17
273F:43C7  8B 05                                mov     ax, [di+ANIM_X]
273F:43C9  D3 E8                                shr     ax, cl
273F:43CB  8B 55 13                             mov     dx, [di+ANIM_WIDTH_COPY]
273F:43CE  D3 EA                      `          shr     dx, cl                  ; ax=left/8, dx=width/8
273F:43D0  75 03                                jnz     loc_846                 ; Is width < 8 pixels?
273F:43D2  BA 0001                              mov     dx, 1                   ; Yes, default to 1 (8 pixels)
273F:43D5                       loc_846:
273F:43D5  2D 0010                              sub     ax, 10h                 ; Is left < 0
273F:43D8  73 0A                                jnc     loc_847                 ; Jump if not
273F:43DA  F7 D8                                neg     ax
273F:43DC  2B D0                                sub     dx, ax
273F:43DE  72 2D                                jc      loc_850                 ; Exit if offscreen to left
273F:43E0  74 2B                                jz      loc_850
273F:43E2  33 C0                                xor     ax, ax                  ; Default to 0
273F:43E4                       loc_847:
273F:43E4  8B E8                                mov     bp, ax
273F:43E6  03 EA                                add     bp, dx                  ; Add width
273F:43E8  83 ED 29                             sub     bp, ROOM_PATHS_WIDTH+1
273F:43EB  72 09                                jc      loc_848                 ; Jump if on screen
273F:43ED  83 C5 01                             add     bp, 1
273F:43F0  2B D5                                sub     dx, bp
273F:43F2  72 19                                jc      loc_850                 ; Jump if carry Set
273F:43F4  74 17                                jz      loc_850                 ; Jump if zero
273F:43F6                       loc_848:
273F:43F6  8B E8                                mov     bp, ax                  ; bp,ax=(left/8)-10h
273F:43F8  D3 E8                                shr     ax, cl
273F:43FA  03 D8                                add     bx, ax                  ; Increment X offset
273F:43FC  8B CD                                mov     cx, bp
273F:43FE  B8 0080                              mov     ax, 80h
273F:4401  83 E1 07                             and     cx, 7
273F:4404  74 02                                jz      loc_849
273F:4406  D3 E8                                shr     ax, cl                  ; Setup bit mask
273F:4408                       loc_849:                                        ;  xref 273F:4404
273F:4408  8B CA                                mov     cx, dx
273F:440A  0B C9                                or      cx, cx 
273F:440C  C3                                   retn
273F:440D                       loc_850:                                        ;  xref 273F:43BB, 43DE, 43E0, 43F2
                                                                                ;            43F4
273F:440D  33 C9                                xor     cx, cx                  ; Zero register
273F:440F  C3                                   retn
                          pathfind_get_cell     endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:0107, 60FC
                                ;

                                sub_96          proc    near
273F:4410  BB B0AE                              mov     bx, offset hotspot_action_list
273F:4413  B9 0014                              mov     cx, NUM_HOTSPOT_ACTION_SLOTS

273F:4416                       locloop_851:
273F:4416  F7 07 FFFF                           test    word ptr [bx],0FFFFh    ; Entry position in use?
273F:441A  74 1F                                jz      loc_853                 ; Skip entry if not
273F:441C  83 6F 04 01                          sub     word ptr [bx+4], 1      ; Decrement entry counter
273F:4420  8B 47 04                             mov     ax, [bx+4]
273F:4423  0B C0                                or      ax,ax                   ; Reached zero?
273F:4425  75 04                                jnz     loc_852                 ; Jump if not
273F:4427  C7 07 0000                           mov     word ptr [bx], 0        ; Clear slot
273F:442B                       loc_852:
273F:442B  81 7F 02 2710                        cmp     word ptr [bx+2], 2710h  ; Check Id of entry
273F:4430  73 09                                jae     loc_853                 ; Jump if >= 2710h
273F:4432  8B 77 06                             mov     si,[bx+6]               ; Hotspot rec ptr?
273F:4435  05 0001                              add     ax, 1
273F:4438  89 44 4A                             mov     [si+4Ah], ax            ; Set 4Ah to countdown ctr
273F:443B                       loc_853:
273F:443B  83 C3 08                             add     bx, HOTSPOT_ACTION_SLOT_SIZE
273F:443E  E2 D6                                loop    locloop_851             ; Loop if cx > 0

273F:4440  C3                                   retn
                                sub_96          endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:479F, 51A8, 5FB9
                                ;

273F:4441                       sub_97          proc    near
273F:4441  53                                   push    bx
273F:4442  BB B0AE                              mov     bx, offset hotspot_action_list
273F:4445  B9 0014                              mov     cx, NUM_HOTSPOT_ACTION_SLOTS
273F:4448  8B 45 1B                             mov     ax, [di+ANIM_HOTSPOT_ID]

273F:444B                       locloop_854:                                    ;  xref 273F:4468
273F:444B  3B 07                                cmp     ax, [bx]
273F:444D  75 16                                jne     loc_855                 ; Skip if hotspot not found
273F:444F  C7 47 04 0001                        mov     word ptr [bx+4], 1
273F:4454  81 7F 02 2710                        cmp     word ptr [bx+2], 2710h
273F:4459  73 0A                                jae     loc_855                 ; Jump if above or =
273F:445B  56                                   push    si
273F:445C  8B 77 06                             mov     si, [bx+6]
273F:445F  C7 44 4A 0001                        mov     word ptr [si+HS_V4A], 1
273F:4464  5E                                   pop     si
273F:4465                       loc_855:                                        ; Move to next entry
273F:4465  83 C3 08                             add     bx, HOTSPOT_ACTION_SLOT_SIZE
273F:4468  E2 E1                                loop    locloop_854             ; Loop through list

273F:446A  5B                                   pop     bx
273F:446B  C3                                   retn
                                sub_97          endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:3C71, 3C78, 3D0F, 3F3F, 4971, 5687, 5697
                                ;                             7CAF, 7D2C, 81E1, 8224, 830A, 833D, 8385
                                ;                             988C, 9F4B
                                ;

273F:446C                       random          proc    near
273F:446C  56                                   push    si
273F:446D  57                                   push    di
273F:446E  53                                   push    bx
273F:446F  51                                   push    cx
273F:4470  8B 16 38A2                           mov     dx, random_v1
273F:4474  A1 38A4                              mov     ax, random_v2
273F:4477  B9 015A                              mov     cx,15Ah
273F:447A  BB 4E35                              mov     bx,4E35h
273F:447D  56                                   push    si
273F:447E  96                                   xchg    si,ax
273F:447F  92                                   xchg    dx,ax
273F:4480  85 C0                                test    ax,ax
273F:4482  74 02                                jz      loc_856                 ; Jump if zero
273F:4484  F7 E3                                mul     bx                      ; dx:ax = reg * ax
273F:4486                       loc_856:                                        ;  xref 273F:4482
273F:4486  91                                   xchg    cx,ax
273F:4487  85 C0                                test    ax,ax
273F:4489  74 04                                jz      loc_857                 ; Jump if zero
273F:448B  F7 E6                                mul     si                      ; dx:ax = reg * ax
273F:448D  03 C8                                add     cx,ax
273F:448F                       loc_857:                                        ;  xref 273F:4489
273F:448F  96                                   xchg    si,ax
273F:4490  F7 E3                                mul     bx                      ; dx:ax = reg * ax
273F:4492  03 D1                                add     dx,cx
273F:4494  5E                                   pop     si
273F:4495  05 0001                              add     ax,1
273F:4498  83 D2 00                             adc     dx,0
273F:449B  89 16 38A2                           mov     random_v1, dx
273F:449F  A3 38A4                              mov     random_v2, ax
273F:44A2  D1 E0                                shl     ax,1                    ; Shift w/zeros fill
273F:44A4  59                                   pop     cx
273F:44A5  5B                                   pop     bx
273F:44A6  5F                                   pop     di
273F:44A7  5E                                   pop     si
273F:44A8  C3                                   retn
                                random          endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:4329, 603C
                                ;

             check_for_impinging_characters     proc    near
273F:44A9 BB B14E                              mov     bx, offset animation_table
273F:44AC  B9 002D                              mov     cx, NUM_ANIMATION_SLOTS
273F:44AF  8B 55 0E                             mov     dx, [di+ANIM_ROOM_NUM]

273F:44B2                       locloop_858:                                    ;  xref 273F:44D0
273F:44B2  F6 47 1D FF                          test    byte ptr [bx+ANIM_SKIP], 0FFh
273F:44B6  74 15                                jz      loc_859                 ; Jump if zero
273F:44B8  F6 47 0C FF                          test    byte ptr [bx+ANIM_LAYER], 0FFh
273F:44BC  74 0F                                jz      loc_859                 ; Jump if zero
273F:44BE  3B 57 0E                             cmp     dx, [bx+ANIM_ROOM_NUM]
273F:44C1  75 0A                                jne     loc_859                 ; Jump if not equal
273F:44C3  53                                   push    bx
273F:44C4  8B 5F 19                             mov     bx, [bx+ANIM_HOTSPOT_OFFSET]
273F:44C7  E8 10D7                              call    characters_impinging_check
273F:44CA  5B                                   pop     bx
273F:44CB  75 09                                jnz     loc_860                 ; Jump if not zero
273F:44CD                       loc_859:                                        ;  xref 273F:44B6, 44BC, 44C1
273F:44CD  83 C3 29                             add     bx, ANIMATION_SLOT_SIZE
273F:44D0  E2 E0                                loop    locloop_858             ; Loop if cx > 0

273F:44D2  0D 0001                              or      ax, 1
273F:44D5  C3                                   retn
273F:44D6                       loc_860:                                        ;  xref 273F:44CB
273F:44D6  33 C0                                xor     ax, ax
273F:44D8  C3                                   retn
             check_for_impinging_characters     endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:476C, 85A3
                                ;

                             char_face_up       proc    near
273F:44D9 8B 5C 21                             mov     bx, [si+HS_PIXEL_OFFSET]
273F:44DC  8A 47 11                             mov     al, [bx+PIXEL_FRAMENUM_UP]
273F:44DF  C7 45 22 0004                        mov     word ptr [di+ANIM_CHAR_RECT_Y], 4
273F:44E4  C6 45 26 00                          mov     byte ptr [di+ANIM_DIRECTION], FACING_UP
273F:44E8  EB 33                                jmp     short char_face_end
                             char_face_up       endp

                           char_face_down       proc    near
273F:44EA 8B 5C 21                             mov     bx, [si+HS_PIXEL_OFFSET]
273F:44ED  8A 47 12                             mov     al, [bx+PIXEL_FRAMENUM_DOWN]
273F:44F0  C7 45 22 0004                        mov     word ptr [di+ANIM_CHAR_RECT_Y], 4
273F:44F5  C6 45 26 01                          mov     byte ptr [di+ANIM_DIRECTION], FACING_DOWN
273F:44F9  EB 22                                jmp     short char_face_end
                           char_face_down       endp

                           char_face_left       proc    near
273F:44FB 8B 5C 21                             mov     bx, [si+HS_PIXEL_OFFSET]
273F:44FE  8A 47 13                             mov     al, [bx+PIXEL_FRAMENUM_LEFT]
273F:4501  C7 45 22 0000                        mov     word ptr [di+ANIM_CHAR_RECT_Y], 0
273F:4506  C6 45 26 02                          mov     byte ptr [di+ANIM_DIRECTION], FACING_LEFT
273F:450A  EB 11                                jmp     short char_face_end
                           char_face_left       endp

                          char_face_right       proc    near
273F:450C 8B 5C 21                             mov     bx, [si+HS_PIXEL_OFFSET]
273F:450F  8A 47 14                             mov     al, [bx+PIXEL_FRAMENUM_RIGHT]
273F:4512  C7 45 22 0000                        mov     word ptr [di+ANIM_CHAR_RECT_Y], 0
273F:4517  C6 45 26 03                          mov     byte ptr [di+ANIM_DIRECTION], FACING_RIGHT
273F:451B  EB 00                                jmp     short char_face_end
                          char_face_right       endp

273F:451D                 char_face_end:
273F:451D  8B 5F 07                             mov     bx, [bx+PIXEL_FRAME_SIZE] ; Calculate frame offset
273F:4520  32 E4                                xor     ah, ah
273F:4522  F7 E3                                mul     bx
273F:4524  89 45 08                             mov     [di+ANIM_FRAME_OFFSET], ax
273F:4527  C3                                   retn


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:4333
                                ;

                     set_new_dispatch_action    proc    near
273F:4528 83 44 61 05                          add     word ptr [si+HS_ACTION_OFFSET], CURRENT_ACTION_RECORD_SIZE
273F:452C  EB 0C                                jmp     short loc_868
                     set_new_dispatch_action    endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                 seq_set_new_dispatch_action    proc    near
273F:452E  53                                   push    bx
273F:452F  8B C1                                mov     ax, cx                  ; Get param
273F:4531  E8 C7B6                              call    get_room_resource_pointer2 ; Get HS resource
273F:4534  58                                   pop     ax
273F:4535                       loc_867:
273F:4535 C7 44 61 0005                        mov     word ptr [si+HS_ACTION_OFFSET], CURRENT_ACTION_RECORD_SIZE
273F:453A                       loc_868:
273F:453A  C6 44 4D 00                          mov     byte ptr [si+HS_V4D], 0
273F:453E  D1 E0                                shl     ax, 1                    ; Shift w/zeros fill
273F:4540  05 1380                              add     ax, offset support_data_offset_list
273F:4543  8B D8                                mov     bx, ax
273F:4545  8B 07                                mov     ax, [bx]                ; Get support entry
273F:4547  8B DE                                mov     bx, si
273F:4549  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:454C  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:454F  89 47 01                             mov     [bx+CURRENT_ACTION_SUPPORT_TABLE], ax
273F:4552  C6 07 02                             mov     byte ptr [bx], CHAR_ACTION_DISPATCH_ACTION
273F:4555  8B 44 06                             mov     ax, [si+HS_ROOM_NUM]
273F:4558  89 47 03                             mov     [bx+CURRENT_ACTION_ROOM_NUM], ax
273F:455B  C6 44 2A 00                          mov     byte ptr [si+HS_ACTION_CTR], 0
273F:455F  C3                                   retn
                 seq_set_new_dispatch_action    endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:5133, 5F63
                                ;

273F:4560                       sub_105         proc    near
273F:4560                       loc_869:                                        ;  xref 273F:5EC8
273F:4560 F6 44 4C FF                          test    byte ptr [si+HS_BLOCKED_FLAG], 0FFh
273F:4564  74 2C                                jz      loc_ret_873             ; Jump if zero
273F:4566                       loc_870:                                        ;  xref 273F:5042
273F:4566 53                                   push    bx
273F:4567  BB B0AE                              mov     bx, offset hotspot_action_list
273F:456A  B9 0014                              mov     cx, NUM_HOTSPOT_ACTION_SLOTS
273F:456D  8B 45 1B                             mov     ax, [di+ANIM_HOTSPOT_ID]

273F:4570                       locloop_871:                                    ;  xref 273F:458F
273F:4570  3B 07                                cmp     ax, [bx]
273F:4572  75 18                                jne     loc_872                 ; Jump if not equal
273F:4574  C7 47 04 000F                        mov     word ptr [bx+4], 0Fh
273F:4579  81 7F 02 2710                        cmp     word ptr [bx+2], 2710h
273F:457E  73 0C                                jae     loc_872
273F:4580  56                                   push    si
273F:4581  51                                   push    cx
273F:4582  8B 77 06                             mov     si, [bx+6]
273F:4585  C7 44 4A 000F                        mov     word ptr [si+HS_V4A], 0Fh
273F:458A  59                                   pop     cx
273F:458B  5E                                   pop     si
273F:458C                       loc_872:                                        ;  xref 273F:4572, 457E
273F:458C  83 C3 08                             add     bx, HOTSPOT_ACTION_SLOT_SIZE
273F:458F  E2 DF                                loop    locloop_871             ; Loop if cx > 0

273F:4591  5B                                   pop     bx

273F:4592                       loc_ret_873:                                    ;  xref 273F:4564
273F:4592  C3                                   retn
                                sub_105         endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:131F, 56FC
                                ;

                       is_roomexit_hotspot      proc    near
273F:4593                       loc_874:                                        ;  xref 273F:459F
273F:4593  3B 04                                cmp     ax,[si]
273F:4595  74 0D                                je      loc_875                 ; Jump if equal
273F:4597  83 C6 02                             add     si,2
273F:459A  F7 44 FE FFFF                        test    word ptr [si-2],0FFFFh
273F:459F  75 F2                                jnz     loc_874                 ; Jump if not zero
273F:45A1  0C 01                                or      al,1
273F:45A3  C3                                   retn
273F:45A4                       loc_875:                                        ;  xref 273F:4595
273F:45A4  33 C0                                xor     ax,ax                   ; Zero register
273F:45A6  C3                                   retn
                       is_roomexit_hotspot      endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:5402, 5713, 5816, 5909, 5944, 5AB8, 5B30
                                ;                             5B96, 5C34, 5CB3, 5D7E, 5DAA, 89F0
                                ;

                    hotspot_action_precheck     proc    near
273F:45A7  3D 0420                              cmp     ax, 420h
273F:45AA  74 0A                                je      loc_876                 ; Jump if equal
273F:45AC  3D 0436                              cmp     ax, 436h
273F:45AF  74 05                                je      loc_876                 ; Jump if equal
273F:45B1  3D 0429                              cmp     ax, 429h
273F:45B4  75 1A                                jne     loc_879                 ; Jump if not equal
273F:45B6                       loc_876:                                        ;  xref 273F:45AA, 45AF
273F:45B6  50                                   push    ax
273F:45B7  55                                   push    bp
273F:45B8  E8 3F9F                              call    sub_213                 ; (855A)
273F:45BB  5D                                   pop     bp
273F:45BC  0B C0                                or      ax, ax                  ; Zero ?
273F:45BE  74 0B                                jz      loc_878                 ; Jump if zero
273F:45C0  58                                   pop     ax
273F:45C1  56                                   push    si
273F:45C2  E8 C725                              call    get_room_resource_pointer2
273F:45C5  5B                                   pop     bx
273F:45C6  87 F3                                xchg    si, bx
273F:45C8                       loc_877:                                        ;  xref 273F:45F4, 4600
273F:45C8  E9 00BB                              jmp     loc_888                 ; (4686)
273F:45CB                       loc_878:
273F:45CB  58                                   pop     ax
273F:45CC  B8 0003                              mov     ax, 3                   ; Initial call for action
273F:45CF  C3                                   retn                            ;  (prior to moving to it)
273F:45D0                       loc_879:
273F:45D0  56                                   push    si
273F:45D1  E8 C716                              call    get_room_resource_pointer2
273F:45D4  5B                                   pop     bx
273F:45D5  87 DE                                xchg    bx, si

                                ; External Entry into Subroutine 
                                ;
                                ;         Called from:   273F:58B0

                   hotspot_action_precheck_2:
273F:45D7  8B 44 06                             mov     ax, [si+HS_ROOM_NUM]    ; Is object in same room
273F:45DA  3B 47 06                             cmp     ax, [bx+HS_ROOM_NUM]    ;  as the character?
273F:45DD  75 72                                jne     loc_884                 ; Jump if not
273F:45DF  F6 44 2A FF                          test    byte ptr [si+HS_ACTION_CTR], 0FFh
273F:45E3  75 46                                jnz     loc_883                 ; Jump if not zero
273F:45E5  C6 44 2A 01                          mov     byte ptr [si+HS_ACTION_CTR], 1
273F:45E9  81 3E BA1B 0408                      cmp     active_hotspot_id, FIRST_OBJECT_HOTSPOT_ID
273F:45EF  72 09                                jb      loc_881                 ; Jump if below
273F:45F1                       loc_880:                                        ;  xref 273F:4606, 463B, 4641, 4647
                                                                                ;            464F
273F:45F1 E8 0E95                              call    character_walking_check
273F:45F4  75 D2                                jnz     loc_877                 ; Jump if not zero
273F:45F6  B8 0003                              mov     ax, 3                   ; Flag walking is required
273F:45F9  C3                                   retn
273F:45FA                       loc_881:                                        ;  xref 273F:45EF
273F:45FA  8B 45 1B                             mov     ax, [di+ANIM_HOTSPOT_ID]
273F:45FD  3B 47 50                             cmp     ax, [bx+HS_DIRECTION]
273F:4600  74 C6                                je      loc_877                 ; Jump if equal
273F:4602  80 7F 44 04                          cmp     byte ptr [bx+HS_CHAR_MODE], CHARMODE_4
273F:4606  74 E9                                je      loc_880                 ; Jump if equal
273F:4608  80 3E BAB9 02                        cmp     byte ptr script_val_88, 2
273F:460D  74 0D                                je      loc_882                 ; Jump if equal
273F:460F  53                                   push    bx
273F:4610  BB 0005                              mov     bx,5
273F:4613  E8 1D8C                              call    display_message_dialog_2
273F:4616  5B                                   pop     bx
273F:4617  C7 44 42 0004                        mov     word ptr [si+HS_DELAY_CTR], 4
273F:461C                       loc_882:                                        ;  xref 273F:460D
273F:461C  C7 47 2B 002A                        mov     word ptr [bx+HS_V2B], 2Ah
273F:4621  8B 45 1B                             mov     ax, [di+ANIM_HOTSPOT_ID]
273F:4624  89 47 2F                             mov     [bx+HS_USE_HOTSPOT_ID], ax
273F:4627  B8 0003                              mov     ax,3
273F:462A  C3                                   retn
273F:462B                       loc_883:                                        ;  xref 273F:45E3
273F:462B  80 44 2A 01                          add     byte ptr [si+HS_ACTION_CTR], 1
273F:462F  80 7C 2A 06                          cmp     byte ptr [si+HS_ACTION_CTR], 6
273F:4633  73 41                                jae     loc_887                 ; Jump if above or =
273F:4635  81 3E BA1B 0408                      cmp     active_hotspot_id, FIRST_OBJECT_HOTSPOT_ID
273F:463B  73 B4                                jae     loc_880                 ; Jump if above or =
273F:463D  80 7F 44 08                          cmp     byte ptr [bx+44h],8
273F:4641  74 AE                                je      loc_880                 ; Jump if equal
273F:4643  80 7F 44 04                          cmp     byte ptr [bx+44h],4
273F:4647  74 A8                                je      loc_880                 ; Jump if equal
273F:4649  80 7F 44 07                          cmp     byte ptr [bx+44h],7
273F:464D  75 17                                jne     loc_886                 ; Jump if not equal
273F:464F  EB A0                                jmp     short loc_880           ; (45F1)
273F:4651                       loc_884:                                        ;  xref 273F:45DD
273F:4651  F6 44 2A FF                          test    byte ptr [si+HS_ACTION_CTR],0FFh  
273F:4655  75 07                                jnz     loc_885                 ; Jump if yes
273F:4657  33 C0                                xor     ax, ax                  ; Zero register
273F:4659  53                                   push    bx
273F:465A  E8 1D54                              call    display_message_dialog_3
273F:465D  5B                                   pop     bx
273F:465E                       loc_885:
273F:465E  C6 44 2A 00                          mov     byte ptr [si+HS_ACTION_CTR], 0
273F:4662  B8 0001                              mov     ax, 1
273F:4665  C3                                   retn
273F:4666                       loc_886:                                        ;  xref 273F:464D
273F:4666  C6 44 2A 00                          mov     byte ptr [si+HS_ACTION_CTR], 0
273F:466A  B8 000E                              mov     ax,0Eh
273F:466D  53                                   push    bx
273F:466E  E8 1D40                              call    display_message_dialog_3
273F:4671  5B                                   pop     bx
273F:4672  B8 0002                              mov     ax,2
273F:4675  C3                                   retn
273F:4676                       loc_887:                                        ;  xref 273F:4633
273F:4676  C6 44 2A 00                          mov     byte ptr [si+HS_ACTION_CTR], 0
273F:467A  B8 000D                              mov     ax, 0Dh
273F:467D  53                                   push    bx
273F:467E  E8 1D30                              call    display_message_dialog_3
273F:4681  5B                                   pop     bx
273F:4682  B8 0004                              mov     ax,4
273F:4685  C3                                   retn
273F:4686                       loc_888:                                        ;  xref 273F:45C8
273F:4686  C6 44 2A 00                          mov     byte ptr [si+HS_ACTION_CTR], 0
273F:468A  81 3E BA1B 0408                      cmp     active_hotspot_id, FIRST_OBJECT_HOTSPOT_ID
273F:4690  73 0F                                jae     loc_889                 ; Jump if above or =
273F:4692  C6 47 44 08                          mov     byte ptr [bx+HS_CHAR_MODE], CHARMODE_8
273F:4696  C7 47 42 001E                        mov     word ptr [bx+HS_DELAY_CTR], 30
273F:469B  8B 45 1B                             mov     ax, [di+ANIM_HOTSPOT_ID]
273F:469E  89 47 50                             mov     [bx+50h], ax
273F:46A1                       loc_889:                                        ;  xref 273F:4690
273F:46A1  33 C0                                xor     ax,ax                   ; Zero register
273F:46A3  C3                                   retn
                    hotspot_action_precheck     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                             seq_method_45      proc    near
273F:46A4  E8 C641                              call    get_room_resource_pointer
273F:46A7  C6 44 44 07                          mov     byte ptr [si+HS_CHAR_MODE], CHARMODE_7
273F:46AB  C7 44 42 0082                        mov     word ptr [si+HS_DELAY_CTR], 130
273F:46B0  C3                                   retn
                             seq_method_45      endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                  character_reset_direction     proc    near
273F:46B1  53                                   push    bx
273F:46B2  80 25 F8                             and     byte ptr [di+ANIM_X], 0F8h
273F:46B5  80 64 0D F8                          and     byte ptr [si+HS_X], 0F8h
273F:46B9  80 0D 05                             or      byte ptr [di+ANIM_X], 5
273F:46BC  80 4C 0D 05                          or      byte ptr [si+HS_X], 5
273F:46C0  8B 5C 21                             mov     bx, [si+HS_PIXEL_OFFSET]
273F:46C3  8A 45 26                             mov     al, [di+ANIM_DIRECTION]
273F:46C6  3C 01                                cmp     al, FACING_DOWN
273F:46C8  72 10                                jb      loc_893                 ; Jump if up
273F:46CA  74 09                                jz      loc_892                 ; Jump if down
273F:46CC  3C 03                                cmp     al, 3
273F:46CE  72 0F                                jb      loc_894                 ; Jump if left
273F:46D0                       loc_891:
273F:46D0 8A 47 14                             mov     al, [bx+PIXEL_FRAMENUM_RIGHT]
273F:46D3  EB 0D                                jmp     short loc_895
273F:46D5                       loc_892:
273F:46D5  8A 47 12                             mov     al, [bx+PIXEL_FRAMENUM_DOWN]
273F:46D8  EB 08                                jmp     short loc_895
273F:46DA                       loc_893:
273F:46DA  8A 47 11                             mov     al, [bx+PIXEL_FRAMENUM_UP]
273F:46DD  EB 03                                jmp     short loc_895
273F:46DF                       loc_894:
273F:46DF  8A 47 13                             mov     al, [bx+PIXEL_FRAMENUM_LEFT]
273F:46E2                       loc_895:
273F:46E2  8B 5F 07                             mov     bx, [bx+PIXEL_FRAME_SIZE]
273F:46E5  32 E4                                xor     ah, ah                  ; Zero register
273F:46E7  F7 E3                                mul     bx                      ; dx:ax = reg * ax
273F:46E9  89 45 08                             mov     [di+ANIM_FRAME_OFFSET], ax
273F:46EC  5B                                   pop     bx
273F:46ED  C3                                   retn
                  character_reset_direction     endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:5411, 572B, 57C6, 58C3, 5920, 5958, 5ACA
                                ;                             5B43, 5BAA, 5C76, 5CC7, 8A00
                                ;

                    character_face_hotspot      proc    near
273F:46EE  53                                   push    bx
273F:46EF  57                                   push    di
273F:46F0  56                                   push    si
273F:46F1  EB 17                                jmp     short loc_896           ; (470A)
                                                                                ;* No entry point to code

273F:46F3  8B 45 1B                             mov     ax, [di+ANIM_HOTSPOT_ID]
273F:46F6  8B 1E BA1B                           mov     bx, active_hotspot_id

                                ; External Entry into Subroutine 
                                ;
                                ;         Called from:   273F:61C5, 61CA

                  character_face_hotspot_2:
273F:46FA  53                                   push    bx
273F:46FB  57                                   push    di
273F:46FC  56                                   push    si
273F:46FD  50                                   push    ax
273F:46FE  E8 C5E7                              call    get_room_resource_pointer
273F:4701  5B                                   pop     bx
273F:4702  56                                   push    si
273F:4703  E8 C5E2                              call    get_room_resource_pointer
273F:4706  5B                                   pop     bx
273F:4707  8B 7C 0B                             mov     di, [si+HS_ANIM_OFFSET]
273F:470A                       loc_896:                                        ;  xref 273F:46F1
273F:470A  8B 45 1B                             mov     ax, [di+ANIM_HOTSPOT_ID]
273F:470D  3D 03E8                              cmp     ax, PLAYER_HOTSPOT_ID
273F:4710  72 70                                jb      loc_903                 ; Jump if below
273F:4712  3D 0408                              cmp     ax, FIRST_OBJECT_HOTSPOT_ID
273F:4715  73 6B                                jae     loc_903                 ; Jump if above or =
273F:4717  53                                   push    bx
273F:4718  8B DE                                mov     bx, si
273F:471A  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:471D  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:4720  8A 07                                mov     al, [bx]                ; Get current action
273F:4722  5B                                   pop     bx
273F:4723  81 3E BA1B 7530                      cmp     active_hotspot_id, 7530h
273F:4729  72 17                                jb      loc_897
273F:472B  5E                                   pop     si                      ; Non selectable hotspot
273F:472C  5F                                   pop     di
273F:472D  8A 47 08                             mov     al, [bx+HS_LOAD_FLAG]
273F:4730  88 45 26                             mov     [di+ANIM_DIRECTION], al
273F:4733  8B 5C 21                             mov     bx, [si+HS_PIXEL_OFFSET]
273F:4736  3C 01                                cmp     al, FACING_DOWN
273F:4738  72 A0                                jb      loc_893                 ; Jump if up
273F:473A  74 99                                jz      loc_892                 ; Jump if down
273F:473C  3C 03                                cmp     al, FACING_LEFT
273F:473E  72 9F                                jb      loc_894                 ; Jump if left
273F:4740  EB 8E                                jmp     short loc_891           ; Jump for right
273F:4742                       loc_897:
273F:4742  8B 54 0F                             mov     dx, [si+HS_Y]
273F:4745  03 54 1B                             add     dx, [si+HS_HEIGHT_COPY]
273F:4748  2B 57 0F                             sub     dx, [bx+HS_Y]
273F:474B  2B 57 1B                             sub     dx, [bx+HS_HEIGHT_COPY]
273F:474E  8B 4C 0D                             mov     cx, [si+HS_X]
273F:4751  2B 4F 0D                             sub     cx, [bx+HS_X]
273F:4754  8B C1                                mov     ax, cx
273F:4756  0B C0                                or      ax, ax                   ; Zero ?
273F:4758  79 02                                jns     loc_898                 ; Jump if not sign
273F:475A  F7 D8                                neg     ax
273F:475C                       loc_898:                                        ;  xref 273F:4758
273F:475C  8B DA                                mov     bx, dx
273F:475E  0B DB                                or      bx, bx                  ; Zero ?
273F:4760  79 02                                jns     loc_899                 ; Jump if not sign
273F:4762  F7 DB                                neg     bx
273F:4764                       loc_899:                                        ;  xref 273F:4760
273F:4764  3B D8                                cmp     bx, ax
273F:4766  72 09                                jb      loc_900                 ; Jump if below
273F:4768  0B D2                                or      dx, dx                   ; Zero ?
273F:476A  78 0E                                js      loc_901                 ; Jump if sign=1
273F:476C  E8 FD6A                              call    char_face_up
273F:476F  EB 11                                jmp     short loc_903           ; (4782)
273F:4771                       loc_900:                                        ;  xref 273F:4766
273F:4771  0B C9                                or      cx,cx                   ; Zero ?
273F:4773  78 0A                                js      loc_902                 ; Jump if sign=1
273F:4775  E8 FD83                              call    char_face_left
273F:4778  EB 08                                jmp     short loc_903           ; (4782)
273F:477A                       loc_901:                                        ;  xref 273F:476A
273F:477A  E8 FD6D                              call    char_face_down
273F:477D  EB 03                                jmp     short loc_903           ; (4782)
273F:477F                       loc_902:                                        ;  xref 273F:4773
273F:477F  E8 FD8A                              call    char_face_right
273F:4782                       loc_903:                                        ;  xref 273F:4710, 4715, 476F, 4778
                                                                                ;            477D
273F:4782  5E                                   pop     si
273F:4783  5F                                   pop     di
273F:4784  5B                                   pop     bx
273F:4785  C3                                   retn
                    character_face_hotspot      endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                    npc_execute_script_proc     proc    near
273F:4786  8B DD                                mov     bx, bp
273F:4788  8B 07                                mov     ax, [bx]
273F:478A  50                                   push    ax
273F:478B  83 C5 02                             add     bp, 2
273F:478E  E8 0DF0                              call    character_walking_end
273F:4791  58                                   pop     ax
273F:4792  E8 F69F                              call    sequence_execute
273F:4795  C3                                   retn
                    npc_execute_script_proc     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                              npc_unknown_2     proc    near
273F:4796  C6 44 44 01                          mov     byte ptr [si+HS_CHAR_MODE], CHARMODE_1
273F:479A  C7 44 42 0016                        mov     word ptr [si+HS_DELAY_CTR], 16h
273F:479F  E8 FC9F                              call    sub_97                  ; (4441)
273F:47A2  8B DE                                mov     bx,si                   ; Move to next npc action
273F:47A4  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:47A7  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:47AA  89 6F 01                             mov     [bx+CURRENT_ACTION_SUPPORT_TABLE], bp
273F:47AD  C3                                   retn
                              npc_unknown_2     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:1E6F, 6279, 6585
                                ; si = hotspot record
                                ;

273F:47AE               room_check_x_extents    proc    near
273F:47AE  53                                   push    bx
273F:47AF  8B 44 06                             mov     ax, [si+HS_ROOM_NUM]
273F:47B2  B3 09                                mov     bl, RH_TABLE_ENTRY_SIZE
273F:47B4  F6 E3                                mul     bl                      ; Calculate offset
273F:47B6  8B D8                                mov     bx,ax
273F:47B8  8B 9F BF40                           mov     bx, [room_info_table][bx] ; Get room record ptr
273F:47BC  83 C3 19                             add     bx, ROOM_X_START
273F:47BF  8B 44 0D                             mov     ax, [si+HS_X]           ; Get X start
273F:47C2  3B 07                                cmp     ax, [bx]
273F:47C4  72 13                                jb      loc_905                 ; Jump if below
273F:47C6  05 0020                              add     ax, 20h
273F:47C9  F7 47 02 FFFF                        test    word ptr [bx+2], 0FFFFh
273F:47CE  74 05                                jz      loc_904                 ; Jump if zero
273F:47D0  3B 47 02                             cmp     ax, [bx+2]
273F:47D3  73 04                                jae     loc_905                 ; Jump if above or =
273F:47D5                       loc_904:                                        ;  xref 273F:47CE
273F:47D5  5B                                   pop     bx
273F:47D6  33 C0                                xor     ax,ax                   ; Zero register
273F:47D8  C3                                   retn
273F:47D9                       loc_905:                                        ;  xref 273F:47C4, 47D3
273F:47D9  5B                                   pop     bx
273F:47DA  0D 0001                              or      ax,1
273F:47DD  C3                                   retn
                        room_check_x_extents    endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:00A3
                                ;

273F:47DE                       sub_113         proc    near
273F:47DE  A1 9832                              mov     ax, room_number
273F:47E1  E8 C506                              call    get_room_resource_pointer2
273F:47E4  83 7C 13 FF                          cmp     word ptr [si+ROOM_ENTRY_TIME], 0FFFFh
273F:47E8  74 3F                                je      loc_909                 ; Jump if equal
273F:47EA  8B 0E B0AA                           mov     cx, game_time_ctr
273F:47EE  2B 4C 13                             sub     cx, [si+ROOM_ENTRY_TIME]
273F:47F1  74 36                                jz      loc_909                 ; Jump if zero
273F:47F3  C6 06 1926 01                        mov     data_669, 1

273F:47F8  81 F9 012C                           cmp     cx, 12Ch
273F:47FC  72 03                                jb      locloop_906             ; Jump if below
273F:47FE  B9 012C                              mov     cx, 12Ch

273F:4801                       locloop_906:                                    ;  xref 273F:47FC, 4827
273F:4801  51                                   push    cx
273F:4802 BF B14E                              mov     di, offset animation_table
273F:4805  B9 002D                              mov     cx, NUM_ANIMATION_SLOTS

273F:4808                       locloop_907:                                    ;  xref 273F:4824
273F:4808  F6 45 0C FF                          test    byte ptr [di+ANIM_LAYER], 0FFh
273F:480C  74 13                                jz      loc_908                 ; Jump if zero
273F:480E  81 7D 1B 0408                        cmp     word ptr [di+ANIM_HOTSPOT_ID], FIRST_OBJECT_HOTSPOT_ID
273F:4813  72 0C                                jb      loc_908                 ; Jump if below
273F:4815  8B 75 19                             mov     si, [di+ANIM_HOTSPOT_OFFSET]
273F:4818  8B 45 11                             mov     ax, [di+ANIM_TICK_PROC]
273F:481B  57                                   push    di
273F:481C  51                                   push    cx
273F:481D  FF D0                                call    ax
273F:481F  59                                   pop     cx
273F:4820  5F                                   pop     di
273F:4821                       loc_908:                                        ;  xref 273F:480C, 4813
273F:4821  83 C7 29                             add     di, ANIMATION_SLOT_SIZE
273F:4824  E2 E2                                loop    locloop_907             ; Loop if cx > 0

273F:4826  59                                   pop     cx
273F:4827  E2 D8                                loop    locloop_906             ; Loop if cx > 0

273F:4829                       loc_909:                                        ;  xref 273F:47E8, 47F1
273F:4829  C6 06 1926 00                        mov     data_669, 0
273F:482E  C3                                   retn
                                sub_113         endp

273F:482F  00                                   db      0

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:2031
                                ;

                        add_sequence_delay      proc    near
273F:4830  03 0E B8AB                           add     cx, seq_timer_ctr
273F:4834  33 C0                                xor     ax,ax                   ; Zero register
273F:4836  13 06 B8AD                           adc     ax, seq_timer_ctr_2
273F:483A  BE B8AF                              mov     si, offset sequence_delay_table
273F:483D  EB 62                                jmp     short loc_915           ; (48A1)
                        add_sequence_delay      endp

                                ; External Entry into Subroutine 
                                ;
                                ;         Called from:   273F:0024

273F:483F                       sub_115:
273F:483F BE B8AF                              mov     si,offset sequence_delay_table     ; (31E4:B8AF=0)
273F:4842  B9 0028                              mov     cx, NUM_DELAY_ENTRIES

273F:4845                       locloop_910:                                    ;  xref 273F:4857
273F:4845  F6 44 06 FF                          test    byte ptr [si+6],0FFh
273F:4849  74 09                                jz      loc_911                 ; Jump if zero
273F:484B  C7 04 0000                           mov     word ptr [si],0
273F:484F  C7 44 02 0000                        mov     word ptr [si+2],0
273F:4854                       loc_911:                                        ;  xref 273F:4849
273F:4854  83 C6 07                             add     si, DELAY_ENTRY_SIZE
273F:4857  E2 EC                                loop    locloop_910             ; Loop if cx > 0

273F:4859  C3                                   retn

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                      sequence_delay_check      proc    near
273F:485A  8B 16 B8AB                           mov     dx, seq_timer_ctr
273F:485E  8B 1E B8AD                           mov     bx, seq_timer_ctr_2
273F:4862 BE B8AF                              mov     si, offset sequence_delay_table
273F:4865  B9 0028                              mov     cx, NUM_DELAY_ENTRIES

273F:4868                       locloop_912:                                    ;  xref 273F:4889
273F:4868  F7 04 FFFF                           test    word ptr [si], 0FFFFh   ; Any entry here?
273F:486C  74 18                                jz      loc_913                 ; Skip if not
273F:486E  3B 5C 02                             cmp     bx, [si+2]
273F:4871  72 13                                jb      loc_913                 ; Jump if below
273F:4873  3B 14                                cmp     dx, [si]
273F:4875  72 0F                                jb      loc_913                 ; Jump if below
273F:4877  C7 04 0000                           mov     word ptr [si], 0        ; Timeout for entry reached
273F:487B  C7 44 02 0000                        mov     word ptr [si+2], 0
273F:4880  8B 44 04                             mov     ax,[si+4]
273F:4883  E9 F5AE                              jmp     sequence_execute
273F:4886                       loc_913:
273F:4886  83 C6 07                             add     si, DELAY_ENTRY_SIZE    ; Move to next entry
273F:4889  E2 DD                                loop    locloop_912             ; Loop if cx > 0
273F:488B  C3                                   retn
                      sequence_delay_check      endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                    sequence_delay_list_init    proc    near
273F:488C BE B8AF                              mov     si, offset sequence_delay_table
273F:488F  B9 0028                              mov     cx, NUM_DELAY_ENTRIES
273F:4892                       locloop_914:
273F:4892  C7 04 0000                           mov     word ptr [si],0
273F:4896  83 C6 07                             add     si, DELAY_ENTRY_SIZE
273F:4899  E2 F7                                loop    locloop_914             ; Loop if cx > 0
273F:489B  C3                                   retn
                    sequence_delay_list_init    endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;


273F:489C  BE B8AF                              mov     si, offset sequence_delay_table
273F:489F  33 C0                                xor     ax, ax
273F:48A1                       loc_915:
273F:48A1  8B E9                                mov     bp,cx
273F:48A3  B9 0028                              mov     cx, NUM_DELAY_ENTRIES

273F:48A6                       locloop_916:
273F:48A6  F7 04 FFFF                           test    word ptr [si],0FFFFh    ; Slot free?
273F:48AA  75 13                                jnz     loc_917                 ; If not, then skip
273F:48AC  F7 44 02 FFFF                        test    word ptr [si+2],0FFFFh
273F:48B1  75 0C                                jnz     loc_917
273F:48B3  89 2C                                mov     [si],bp                 ; Store sequence details
273F:48B5  89 44 02                             mov     [si+2], ax
273F:48B8  89 5C 04                             mov     [si+4], bx
273F:48BB  88 54 06                             mov     [si+6], dl
273F:48BE  C3                                   retn
273F:48BF                       loc_917:
273F:48BF  83 C6 07                             add     si, DELAY_ENTRY_SIZE    ; Loop through table
273F:48C2  E2 E2                                loop    locloop_916

273F:48C4  03 00                                add     ax, [bx+si]

                                ;
                                ;
                                ;                       External Entry Point
                                ;
                                ; Timer Handler
                                ;

273F:48C6                       timer_handler   proc    far                     ;  xref 273F:06AA
273F:48C6  50                                   push    ax
273F:48C7  53                                   push    bx
273F:48C8  51                                   push    cx
273F:48C9  52                                   push    dx
273F:48CA  56                                   push    si
273F:48CB  57                                   push    di
273F:48CC  55                                   push    bp
273F:48CD  1E                                   push    ds
273F:48CE  06                                   push    es
273F:48CF  9C                                   pushf                           ; Push flags
273F:48D0  B8 31E4                              mov     ax,data_seg
273F:48D3  8E D8                                mov     ds,ax

; Timer ticks incrementor

273F:48D5  81 3E F010 2EE0                      cmp     timer_ticks, TIMER_TICKS_MAX
273F:48DB  73 05                                jae     loc_918                 ; Jump if above or =
273F:48DD  83 06 F010 01                        add     timer_ticks, 1          ; (31E4:F010=0)
273F:48E2                       loc_918:

; Code below is responsible for blinking musical note and playing music if a music sequence is set

273F:48E2  F6 06 5668 FF                        test    note_flag, 0FFh        ; Any need to display note?
273F:48E7  74 52                                jz      loc_923                 ; No, so skip this section
273F:48E9  A0 5668                              mov     al, note_flag
273F:48EC  24 3F                                and     al,3Fh
273F:48EE  75 46                                jnz     loc_922                 ; Not yet at blink switch over
273F:48F0  80 0E 5668 0F                        or      note_flag, 0Fh         ; Reset for blink interval
273F:48F5  80 36 5668 40                        xor     note_flag, 40h         ; Toggle whether note is visble
273F:48FA  B8 A000                              mov     ax, VGA_SEGMENT
273F:48FD  8E C0                                mov     es,ax
273F:48FF BF E740                              mov     di, NOTE_DISPLAY_ADDR   ; Where note will be displayed
273F:4902  BB 0007                              mov     bx, NOTE_IMAGE_WIDTH/2  ; Number of horiz words (width/2)
273F:4905  BA 000E                              mov     dx, NOTE_IMAGE_HEIGHT   ; Number of lines to display
273F:4908  F6 06 5668 40                        test    note_flag, MUSIC_NOTE_VISIBLE
273F:490D  74 18                                jz      loc_920                 ; No, so wipe out area
273F:490F  1E                                   push    ds
273F:4910  B8 4502                              mov     ax, musical_note_seg
273F:4913  8E D8                                mov     ds,ax
273F:4915  33 F6                                xor     si,si
273F:4917                       loc_919:
273F:4917  8B CB                                mov     cx,bx
273F:4919  F3/ A5                               rep     movsw                   ; Loop for moving one line of image
273F:491B 81 C7 0132                           add     di, 320-MUSIC_NOTE_WIDTH ; Move to start of next line
273F:491F  83 EA 01                             sub     dx,1
273F:4922  75 F3                                jnz     loc_919                 ; Jump if not zero
273F:4924  1F                                   pop     ds
273F:4925  EB 14                                jmp     short loc_923           ; (493B)
273F:4927                       loc_920:                                        ;  xref 273F:490D
273F:4927  33 C0                                xor     ax,ax                   ; Blank out area where note is
273F:4929                       loc_921:
273F:4929  8B CB                                mov     cx,bx
273F:492B  F3/ AB                               rep     stosw                   ; Rep when cx >0 Store ax to es:[di]
273F:492D  81 C7 0132                           add     di,132h
273F:4931  83 EA 01                             sub     dx,1
273F:4934  75 F3                                jnz     loc_921                 ; Jump if not zero
273F:4936                       loc_922:                                        ;  xref 273F:48EE
273F:4936  80 2E 5668 01                        sub     note_flag, 1           ; Decrement remaining time until
273F:493B                       loc_923:                                        ;  next time note is shown/hidden
273F:493B  F6 06 5660 04                        test    music_status,4          ; Once every 8 cycles (approx every
273F:4940  74 0D                                jz      loc_924                 ; 1/2 second), keep music playing
273F:4942  F6 06 5660 02                        test    music_status,2
273F:4947  75 06                                jnz     loc_924
273F:4949  B4 02                                mov     ah,2
273F:494B  FF 1E 5662                           call    dword ptr [play_music_proc]

; Remaining code is as of yet unknown

273F:494F                       loc_924:
273F:494F  F6 06 38B0 FF                        test    data_781, 0FFh
273F:4954  75 1E                                jnz     loc_925                 ; Jump if not zero
273F:4956  80 2E 38B3 01                        sub     byte ptr data_783,1     ; (31E4:38B3=32h)
273F:495B  75 17                                jnz     loc_925                 ; Jump if not zero
273F:495D  83 06 B8AB 01                        add     seq_timer_ctr, 1
273F:4962  83 16 B8AD 00                        adc     seq_timer_ctr_2, 0
273F:4967  C6 06 38B3 32                        mov     byte ptr data_783,32h   ; (31E4:38B3=32h) '2'
273F:496C  80 0E 073D 02                        or      status_flags2, 2
273F:4971  E8 FAF8                              call    random
273F:4974                       loc_925:                                        ;  xref 273F:4954, 495B
273F:4974  83 06 38B1 01                        add     time_ctr, 1             ; (31E4:38B1=0)
273F:4979  2E: 80 2E 48C4 01                    sub     byte ptr cs:[48C4h],1   ; (273F:48C4=3)
273F:497F  75 2C                                jnz     loc_928                 ; Jump if not zero
273F:4981  B0 02                                mov     al,2
273F:4983  2E: 80 3E 48C5 44                    cmp     byte ptr cs:[48C5h],44h ; (273F:48C5=0) 'D'
273F:4989  73 02                                jae     loc_926                 ; Jump if above or =
273F:498B  04 01                                add     al,1
273F:498D                       loc_926:                                        ;  xref 273F:4989
273F:498D  2E: A2 48C4                          mov     byte ptr cs:[48C4h],al  ; (273F:48C4=3)
273F:4991  2E: 80 06 48C5 01                    add     byte ptr cs:[48C5h],1   ; (273F:48C5=0)
273F:4997  2E: 80 3E 48C5 5B                    cmp     byte ptr cs:[48C5h],5Bh ; (273F:48C5=0) '['
273F:499D  72 06                                jb      loc_927                 ; Jump if below
273F:499F  2E: C6 06 48C5 00                    mov     byte ptr cs:[48C5h],0   ; (273F:48C5=0)


; Interrupt ending code - either send to old timer interrupt, or signal end without calling it

273F:49A5                       loc_927:                                        ;  xref 273F:499D
273F:49A5  9C                                   pushf                           ; Push flags
273F:49A6  2E: FF 1E 04AA                       call    dword ptr cs:old_timer_int_proc
273F:49AB  EB 04                                jmp     short loc_929           ; (49B1)
273F:49AD                       loc_928:                                        ;  xref 273F:497F
273F:49AD  B0 20                                mov     al,20h                  ; ' '
273F:49AF  E6 20                                out     20h,al                  ; port 20h, 8259-1 int command
                                                                                ;  al = 20h, end of interrupt
273F:49B1                       loc_929:                                        ;  xref 273F:49AB
273F:49B1  9D                                   popf                            ; Pop flags
273F:49B2  07                                   pop     es
273F:49B3  1F                                   pop     ds
273F:49B4  5D                                   pop     bp
273F:49B5  5F                                   pop     di
273F:49B6  5E                                   pop     si
273F:49B7  5A                                   pop     dx
273F:49B8  59                                   pop     cx
273F:49B9  5B                                   pop     bx
273F:49BA  58                                   pop     ax
273F:49BB  CF                                   iret                            ; Interrupt return
                                timer_handler   endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:0127
                                ;

273F:49BC                       room_sleep      proc    near
273F:49BC  83 3E 9832 23                        cmp     room_number, ROOMNUM_VILLAGE_SHOP
273F:49C1  75 26                                jne     sleep
273F:49C3  F7 06 BA25 FFFF                      test    old_room_number, 0FFFFh
273F:49C9  75 1E                                jnz     sleep
273F:49CB  F6 06 073D 02                        test    status_flags2, 2
273F:49D0  74 17                                jz      sleep
273F:49D2  50                                   push    ax
273F:49D3  BB 0010                              mov     bx,10h
273F:49D6  F6 06 073D 04                        test    status_flags2, 4
273F:49DB  75 03                                jnz     loc_930                 ; Jump if not zero
273F:49DD  BB 0032                              mov     bx,32h
273F:49E0                       loc_930:                                        ;  xref 273F:49DB
273F:49E0  E8 561A                              call    play_sound                 ; (9FFD)
273F:49E3  80 36 073D 06                        xor     status_flags2, 6
273F:49E8  58                                   pop     ax

                                ; External Entry into Subroutine 
                                ;
                                ;         Called from:   273F:3B77, 3B8C, 75BC, 75C8, 75DA, 75E6, 75F8
                                ;                             7604, 7616, 764A, 977D, A1C3, A1D9, A5E6
                                ;                             A615, A63A, A68D, A6F0, A93F, AA03

273F:49E9                       sleep:
273F:49E9                       loc_931:                                        ;  xref 273F:49C1, 49C9, 49D0, 49ED
273F:49E9  39 06 38B1                           cmp     time_ctr, ax
273F:49ED  72 FA                                jb      loc_931
273F:49EF  C7 06 38B1 0000                      mov     time_ctr, 0
273F:49F5  C3                                   retn
                                room_sleep      endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:5142, 5F79
                                ; ax=character Hotspot Id, bx=dest x, cx=dest y, dl=[4ch]
                                ;

                        character_pathfind      proc    near
273F:49F6  89 26 3942                           mov     pathfind_sp, sp         ; Backup current SP
273F:49FA  C7 06 3944 0FA0                      mov     pathfind_countdown_ctr, 0FA0h
273F:4A00  F6 06 3946 FF                        test    pathfind_in_progress, 0FFh
273F:4A05  74 0E                                jz      loc_933                 ; Jump if zero
273F:4A07  3D 03E8                              cmp     ax, PLAYER_HOTSPOT_ID
273F:4A0A  74 03                                je      loc_932                 ; Jump if equal
273F:4A0C  33 C0                                xor     ax,ax                   ; Zero register
273F:4A0E  C3                                   retn
273F:4A0F                       loc_932:
273F:4A0F BE 3983                              mov     si, offset player_pathfind_data
273F:4A12  8B 24                                mov     sp, [si]                ; Get SP for restore point
273F:4A14  C3                                   retn                            ; (ie. carry on where we left off)
273F:4A15                       loc_933:
273F:4A15  BE 3983                              mov     si, offset player_pathfind_data
273F:4A18  BD 03E8                              mov     bp, PLAYER_HOTSPOT_ID
273F:4A1B  3D 03E8                              cmp     ax, PLAYER_HOTSPOT_ID
273F:4A1E  74 17                                je      loc_935                 ; Jump if equal
273F:4A20 BE 4227                              mov     si, offset chars_pathfind_data
273F:4A23  BD 057A                              mov     bp, 57Ah
273F:4A26  F7 04 FFFF                           test    word ptr [si], 0FFFFh
273F:4A2A  74 10                                jz      loc_936                 ; Jump if zero
273F:4A2C  3B 44 02                             cmp     ax, [si+2]
273F:4A2F  74 03                                je      loc_934                 ; Jump if equal
273F:4A31  33 C0                                xor     ax, ax                  ; Zero register
273F:4A33  C3                                   retn
273F:4A34                       loc_934:                                        ;  xref 273F:4A2F
273F:4A34  8B 24                                mov     sp, [si]
273F:4A36  C3                                   retn
273F:4A37                       loc_935:                                        ;  xref 273F:4A1E
273F:4A37  C6 06 3946 01                        mov     pathfind_in_progress, 1
273F:4A3C                       loc_936:                                        ;  xref 273F:4A2A
273F:4A3C  88 54 04                             mov     [si+PATHFIND_HS4C], dl
273F:4A3F  89 44 02                             mov     [si+PATHFIND_CHARACTER_ID], ax ; Store character Id
273F:4A42  8B E5                                mov     sp, bp

; Handle adjusting destination X for left & right screen edges to place it completely
; off-screen. This will allows characters to walk completely off-screen as they exit
273F:4A44  81 FB 008A                           cmp     bx, 80h + 10            ; dest x >= 10?
273F:4A48  73 05                                jae     loc_937                 ; Jump if yes
273F:4A4A  83 EB 32                             sub     bx, 50
273F:4A4D  EB 09                                jmp     short loc_938           ; (4A58)
273F:4A4F                       loc_937:                                        ;  xref 273F:4A48
273F:4A4F  81 FB 01B6                           cmp     bx, 80h + 310
273F:4A53  72 03                                jb      loc_938                 ; Jump if below
273F:4A55  83 C3 32                             add     bx, 50
273F:4A58                       loc_938:
273F:4A58  89 5C 06                             mov     [si+PATHFIND_DEST_X], bx    ; Store X
273F:4A5B  89 4C 08                             mov     [si+PATHFIND_DEST_Y], cx    ; Store Y

273F:4A5E  8B 6D 13                             mov     bp, [di+ANIM_WIDTH_COPY]
273F:4A61  83 ED 01                             sub     bp, 1
273F:4A64  B1 03                                mov     cl, 3
273F:4A66  D3 ED                                shr     bp, cl                  ; bp=(width copy-1)/8
273F:4A68  57                                   push    di                                         
273F:4A69 81 C6 08A2                           add     si, 8A2h

; Figure out the address for the bit-compressed data for screen walkable areas
273F:4A6D  8B 45 0E                             mov     ax, [di+ANIM_ROOM_NUM]
273F:4A70  8B D8                                mov     bx, ax
273F:4A72  B1 04                                mov     cl, 4
273F:4A74  D3 E0                                shl     ax, cl
273F:4A76  2B C3                                sub     ax, bx
273F:4A78  B1 03                                mov     cl, 3
273F:4A7A  D3 E0                                shl     ax, cl                  ; ax=Room # * 120

; Extract the bit-compressed data of the pathfinding data for the room into an
; uncompressed 26*42 byte array indicating whether each 8x8 pixel block on screen
; (and a surrounding column and row around the screen edge) can be traveled on
; cx = bit number, dl = number of columns, dh = number of rows

273F:4A7C  05 9849                              add     ax, offset pathfind_data2 - 1
273F:4A7F  1E                                   push    ds
273F:4A80  07                                   pop     es
273F:4A81  8B FE                                mov     di, si                  ; for player di=4225h
273F:4A83  8B F0                                mov     si, ax                  ; si=end of pathfind layer for room
273F:4A85  FD                                   std                             ; Set for reverse direction
273F:4A86  33 C0                                xor     ax, ax
273F:4A88  B9 002B                              mov     cx, 2Bh                 ; # cols + end col of 2nd last row
273F:4A8B  F3/ AB                               rep     stosw                   ; Clear area
273F:4A8D  83 C7 01                             add     di, 1                   ; For player di=41D0h

273F:4A90  B6 18                                mov     dh, 24                  ; Number of rows on-screen
273F:4A92                       loc_939:
273F:4A92  B2 05                                mov     dl, 5                   ; Number of bytes horizontally

273F:4A94                       loc_940:
273F:4A94  AC                                   lodsb                           ; Get next byte
273F:4A95  86 E0                                xchg    ah, al                  ; Move it into AH
273F:4A97  32 C0                                xor     al, al                  ; Reset AL to 0 for storage
273F:4A99  B9 0008                              mov     cx, 8                   ; Number of bits in the byte

273F:4A9C                       locloop_941:                                    ;  xref 273F:4AA2, 4AB3
273F:4A9C  D0 EC                                shr     ah, 1                   ; Move next bit for processing
273F:4A9E  72 06                                jc      loc_942                 ; Jump if bit set (block occupied)
273F:4AA0  AA                                   stosb                           ; Store 0 to es:[di]
273F:4AA1  AA                                   stosb                           ; Store 0 to es:[di]
273F:4AA2  E2 F8                                loop    locloop_941             ; Loop for remaining bits

273F:4AA4  EB 33                                jmp     short loc_948
273F:4AA6                       loc_942:                                        ; Handling for occupied blocks
273F:4AA6  F6 D0                                not     al
273F:4AA8  AA                                   stosb                           ; Store 0FFh to es:[di]
273F:4AA9  AA                                   stosb                           ; Store 0FFh to es:[di]
273F:4AAA  F6 D0                                not     al
273F:4AAC  8B DD                                mov     bx, bp                  ; Get width/8 val
273F:4AAE  83 EB 01                             sub     bx, 1
273F:4AB1  73 1D                                jnc     loc_947                 ; Jump if width/8 val != 0
273F:4AB3                       loc_943:
273F:4AB3  E2 E7                                loop    locloop_941             ; Keep looping

273F:4AB5  EB 22                                jmp     short loc_948           ; (4AD9)
273F:4AB7                       loc_944:                                        ;  xref 273F:4AD5
273F:4AB7  B9 0008                              mov     cx,8
273F:4ABA  AC                                   lodsb                           ; String [si] to al
273F:4ABB  86 E0                                xchg    ah,al
273F:4ABD  32 C0                                xor     al,al                   ; Zero register

273F:4ABF                       locloop_945:                                    ;  xref 273F:4AD0
273F:4ABF  D0 EC                                shr     ah,1                    ; Shift w/zeros fill
273F:4AC1  73 02                                jnc     loc_946                 ; Jump if carry=0
273F:4AC3  8B DD                                mov     bx,bp
273F:4AC5                       loc_946:                                        ;  xref 273F:4AC1
273F:4AC5  F6 D0                                not     al
273F:4AC7  AA                                   stosb                           ; Store al to es:[di]
273F:4AC8  AA                                   stosb                           ; Store al to es:[di]
273F:4AC9  F6 D0                                not     al
273F:4ACB  83 EB 01                             sub     bx,1
273F:4ACE  72 E3                                jc      loc_943                 ; Jump if carry Set
273F:4AD0                       loc_947:                                        ;  xref 273F:4AB1
273F:4AD0  E2 ED                                loop    locloop_945             ; Loop if cx > 0

273F:4AD2  80 EA 01                             sub     dl,1
273F:4AD5  75 E0                                jnz     loc_944                 ; Jump if not zero
273F:4AD7  EB 05                                jmp     short loc_949           ; (4ADE)

273F:4AD9                       loc_948:                                        ;  xref 273F:4AA4, 4AB5
273F:4AD9  80 EA 01                             sub     dl,1
273F:4ADC  75 B6                                jnz     loc_940                 ; Jump if not zero
273F:4ADE                       loc_949:
273F:4ADE  B9 0004                              mov     cx, 4                   ; Store end col, next row start col
273F:4AE1  F3/ AA                               rep     stosb                   
273F:4AE3  B2 05                                mov     dl, 5
273F:4AE5  80 EE 01                             sub     dh, 1
273F:4AE8  75 A8                                jnz     loc_939                 ; Jump if not zero

273F:4AEA  83 EF 01                             sub     di, 1
273F:4AED  B9 0029                              mov     cx, 29h                 ; Handle final top off-screen row
273F:4AF0  33 C0                                xor     ax, ax
273F:4AF2  F3/ AB                               rep     stosw

; End of decompression code for the path finding layer.

273F:4AF4  83 EF 1A                             sub     di, 1Ah                 ; di=3983 again (skips local variables)
273F:4AF7  5E                                   pop     si                      ; si=anim slot
273F:4AF8  33 C0                                xor     ax, ax                  ; Zero register
273F:4AFA  89 45 0A                             mov     [di+PATHFIND_Y], ax
273F:4AFD  89 45 0C                             mov     [di+PATHFIND_X], ax
273F:4B00  89 45 10                             mov     [di+PATHFIND_DEST_X2], ax
273F:4B03  89 45 0E                             mov     [di+PATHFIND_0E], ax
273F:4B06  88 45 05                             mov     [di+PATHFIND_DEST_STATE], al
273F:4B09  81 2E 3944 02BC                      sub     pathfind_countdown_ctr, 2BCh       ; v2=0FA0h-2BCh=CE4h
273F:4B0F  8B 04                                mov     ax, [si+ANIM_X]         ; Get current X
273F:4B11  2D 0080                              sub     ax, 80h                 ; Subtract the 80h offset
273F:4B14  73 05                                jnc     loc_950                 ; Jump if current X on-screen
273F:4B16  89 45 0C                             mov     [di+PATHFIND_X], ax
273F:4B19  33 C0                                xor     ax, ax                  ; Zero register
273F:4B1B                       loc_950:                                        ; ax = max(0, X)
273F:4B1B  BB 013F                              mov     bx, 319
273F:4B1E  2B 5C 13                             sub     bx, [si+ANIM_WIDTH_COPY]
273F:4B21  3B C3                                cmp     ax, bx
273F:4B23  72 07                                jb      loc_951                 ; X + full width on screen?
273F:4B25  2B C3                                sub     ax, bx
273F:4B27  89 45 0C                             mov     [di+PATHFIND_X], ax         ; X = min(X, 319 - width)
273F:4B2A  8B C3                                mov     ax, bx
273F:4B2C                       loc_951:
273F:4B2C  8B 5C 02                             mov     bx, [si+ANIM_Y]
273F:4B2F  80 E3 F8                             and     bl, 0F8h
273F:4B32  03 5C 15                             add     bx, [si+ANIM_HEIGHT_COPY]
273F:4B35  83 EB 04                             sub     bx, 4
273F:4B38  81 EB 0088                           sub     bx, 88h                 ; bx=(Y&0F8h+height-4-8)
273F:4B3C  73 05                                jnc     loc_952                 ; Jump if bx (y bottom) < 0
273F:4B3E  89 5D 0A                             mov     [di+PATHFIND_Y], bx
273F:4B41  33 DB                                xor     bx, bx                  ; Zero register
273F:4B43                       loc_952:
273F:4B43  81 FB 00C0                           cmp     bx, 192                 ; Is it on-screen?
273F:4B47  72 0A                                jb      loc_953                 ; Jump if below
273F:4B49  81 EB 00BF                           sub     bx, 191
273F:4B4D  89 5D 0A                             mov     [di+PATHFIND_Y], bx
273F:4B50  BB 00BF                              mov     bx, 191

273F:4B53                       loc_953:
273F:4B53  8B 4D 06                             mov     cx, [di+PATHFIND_DEST_X]
273F:4B56  81 E9 0080                           sub     cx, 128
273F:4B5A  73 05                                jnc     loc_954                 ; Jump if x >= 0
273F:4B5C  89 4D 10                             mov     [di+PATHFIND_DEST_X2], cx   ; Store X (will be negative)
273F:4B5F  33 C9                                xor     cx, cx
273F:4B61                       loc_954:
273F:4B61  BA 0140                              mov     dx, SCREEN_WIDTH
273F:4B64  2B 54 13                             sub     dx, [si+ANIM_WIDTH_COPY]
273F:4B67  3B CA                                cmp     cx, dx
273F:4B69  72 07                                jb      loc_955                 ; Jump if fully on screen
273F:4B6B  2B CA                                sub     cx, dx
273F:4B6D  89 4D 10                             mov     [di+PATHFIND_DEST_X2], cx
273F:4B70  8B CA                                mov     cx, dx
273F:4B72                       loc_955:
273F:4B72  8B 55 08                             mov     dx, [di+PATHFIND_DEST_Y]
273F:4B75  81 EA 0088                           sub     dx, 88h
273F:4B79  73 02                                jnc     loc_956                 ; Jump if y >= 0
273F:4B7B  33 D2                                xor     dx, dx                  ; Zero register
273F:4B7D                       loc_956:                                        
273F:4B7D  81 FA 00C0                           cmp     dx, 192
273F:4B81  72 03                                jb      loc_957                 ; Jump if below
273F:4B83  BA 00BF                              mov     dx, 191
273F:4B86                       loc_957:                                        ;  xref 273F:4B81
273F:4B86  8B E9                                mov     bp, cx

; current=(ax,bx), dest=(bp,dx). Check to see if a move of only a few pixels is required
273F:4B88  B1 03                                mov     cl, 3
273F:4B8A  D3 E8                                shr     ax, cl
273F:4B8C  D3 EB                                shr     bx, cl
273F:4B8E  D3 ED                                shr     bp, cl
273F:4B90  D3 EA                                shr     dx, cl
273F:4B92  3B C5                                cmp     ax, bp                  ; Is x/8=dest_x/8?
273F:4B94  75 2B                                jne     loc_961                 ; Jump if not
273F:4B96  3B DA                                cmp     bx, dx                  ; Is y/8=dest_y/8?
273F:4B98  75 27                                jne     loc_961                 ; Jump if not

; Destination is very close to source.
; If (I think) the PATHFIND_DEST_X2 != 0 (ie. dest is partially off-screen), then
; an initial walk entry is placed. Then irrespective, control jumps to loc_1003,
; which puts another left/right walking entry to move the character to dest X

273F:4B9A BB 3940                              mov     bx, offset pathfind_buffer_end
273F:4B9D  C7 07 0000                           mov     word ptr [bx], 0        ; Set end of pathfind sequence
273F:4BA1  8B 45 10                             mov     ax, [di+PATHFIND_DEST_X2]
273F:4BA4  0B C0                                or      ax, ax                  ; Any partial off-screen move?
273F:4BA6  74 16                                jz      loc_960                 ; Jump if zero
273F:4BA8  78 07                                js      loc_958                 ; Jump if sign=1
273F:4BAA  C7 47 FE 0002                        mov     word ptr [bx-2], FACING2_RIGHT
273F:4BAF  EB 07                                jmp     short loc_959           ; (4BB8)
273F:4BB1                       loc_958:                                        ;  xref 273F:4BA8
273F:4BB1  C7 47 FE 0001                        mov     word ptr [bx-2], FACING2_LEFT
273F:4BB6  F7 D8                                neg     ax
273F:4BB8                       loc_959:                                        ;  xref 273F:4BAF
273F:4BB8  89 47 FC                             mov     [bx-4], ax              ; Store # steps
273F:4BBB  83 EB 04                             sub     bx, 4                   ; Move back for next record
273F:4BBE                       loc_960:
273F:4BBE  E9 02B3                              jmp     loc_1003

; Destination isn't close, so here's where the actual pathfinding needs to be done
; current=(ax,bx)/8, dest=(bp,dx)/8

273F:4BC1                       loc_961:                                        ;  xref 273F:4B94, 4B98
273F:4BC1  50                                   push    ax
273F:4BC2  53                                   push    bx
273F:4BC3  55                                   push    bp
273F:4BC4  52                                   push    dx
273F:4BC5  89 6D 06                             mov     [di+PATHFIND_DEST_X], bp    ; Store dest pos/8
273F:4BC8  89 55 08                             mov     [di+PATHFIND_DEST_Y], dx

273F:4BCB  D1 E0                                shl     ax, 1                   ; ax=sb_x*2
273F:4BCD  8B F3                                mov     si, bx                  ; si=sb_y
273F:4BCF  B1 02                                mov     cl, 2
273F:4BD1  D3 E3                                shl     bx, cl                  ; bx=sb_y*4
273F:4BD3  03 DE                                add     bx, si                  ; bx=sb_y*5
273F:4BD5  D3 E3                                shl     bx, cl                  ; bx=sb_y*20
273F:4BD7  03 DE                                add     bx, si                  ; bx=sb_y*21
273F:4BD9  D3 E3                                shl     bx, cl                  ; bx=sb_y*84
273F:4BDB  03 D8                                add     bx, ax                  ; bx=sb_y*84 + sb_x*2
273F:4BDD  83 C3 72                             add     bx, 72h                 ; Add on buffer & blank line offset
273F:4BE0  03 DF                                add     bx, di                  ; bx=source cell
273F:4BE2  C7 07 0001                           mov     word ptr [bx],1         ; Flag source cell
273F:4BE6  D1 E5                                shl     bp, 1
273F:4BE8  8B F2                                mov     si, dx
273F:4BEA  D3 E6                                shl     si, cl
273F:4BEC  03 F2                                add     si, dx
273F:4BEE  D3 E6                                shl     si, cl
273F:4BF0  03 F2                                add     si, dx
273F:4BF2  D3 E6                                shl     si, cl
273F:4BF4  03 F5                                add     si, bp
273F:4BF6  83 C6 72                             add     si, 72h
273F:4BF9  03 F7                                add     si, di                  ; si=dest cell
273F:4BFB  C6 45 12 00                          mov     byte ptr [di+PATHFIND_DEST_OCCUPIED], 0
273F:4BFF  F6 04 FF                             test    byte ptr [si], 0FFh     ; Is dest cell blocked?
273F:4C02  74 0C                                jz      loc_962                 ; Jump if clear
273F:4C04  C7 04 0000                           mov     word ptr [si], 0        ; Mark dest cell as unblocked
273F:4C08  C6 45 12 01                          mov     byte ptr [di+PATHFIND_DEST_OCCUPIED], 1
273F:4C0C  C6 45 05 01                          mov     byte ptr [di+PATHFIND_DEST_STATE], 1 ; Dest occupied
273F:4C10                       loc_962:
273F:4C10  F6 45 04 FF                          test    byte ptr [di+PATHFIND_HS4C],0FFh
273F:4C14  74 00                                jz      $+2
273F:4C16  5A                                   pop     dx
273F:4C17  59                                   pop     cx
273F:4C18  5D                                   pop     bp
273F:4C19  58                                   pop     ax

; Source/8=(ax,bp), Dest/8=(cx,dx), bx=source cell, si=dest cell 
273F:4C1A  3B C1                                cmp     ax,cx                   ; Start X against Dest X
273F:4C1C  73 19                                jae     loc_964                 ; Jump if >=
273F:4C1E  0B C0                                or      ax,ax                   ; Is Start X 0?
273F:4C20  74 06                                jz      loc_963                 ; Jump if yes
273F:4C22  2D 0001                              sub     ax, 1
273F:4C25  83 EB 02                             sub     bx, 2
273F:4C28                       loc_963:
273F:4C28  C7 45 14 0002                        mov     word ptr [di+PATHFIND_X_CHANGE1], 2
273F:4C2D  B9 0028                              mov     cx, ROOM_PATHS_WIDTH
273F:4C30  2B C8                                sub     cx, ax
273F:4C32  89 4D 18                             mov     [di+PATHFIND_X_CHANGE2], cx
273F:4C35  EB 17                                jmp     short loc_966           ; (4C4E)
273F:4C37                       loc_964:                                        ;  xref 273F:4C1C
273F:4C37  3D 0027                              cmp     ax, ROOM_PATHS_WIDTH - 1
273F:4C3A  74 06                                je      loc_965                 ; Jump if equal
273F:4C3C  05 0001                              add     ax, 1
273F:4C3F  83 C3 02                             add     bx, 2
273F:4C42                       loc_965:                                        ;  xref 273F:4C3A
273F:4C42  C7 45 14 FFFE                        mov     word ptr [di+PATHFIND_X_CHANGE1], 0FFFEh
273F:4C47  89 45 18                             mov     [di+PATHFIND_X_CHANGE2],ax
273F:4C4A  83 45 18 01                          add     word ptr [di+PATHFIND_X_CHANGE2], 1
273F:4C4E                       loc_966:                                        ;  xref 273F:4C35
273F:4C4E  3B EA                                cmp     bp, dx
273F:4C50  72 19                                jb      loc_968                 ; Jump if below
273F:4C52  83 FD 17                             cmp     bp, ROOM_PATHS_HEIGHT - 1
273F:4C55  74 06                                je      loc_967                 ; Jump if equal
273F:4C57  83 C5 01                             add     bp, 1
273F:4C5A  83 C3 54                             add     bx, DECODED_PATHS_WIDTH * 2
273F:4C5D                       loc_967:                                        ;  xref 273F:4C55
273F:4C5D  C7 45 16 FFAC                        mov     [di+PATHFIND_Y_CHANGE1], -DECODED_PATHS_WIDTH*2
273F:4C62  89 6D 1A                             mov     [di+PATHFIND_Y_CHANGE2], bp
273F:4C65  83 45 1A 01                          add     [di+PATHFIND_Y_CHANGE2], 1
273F:4C69  EB 17                                jmp     short loc_970           ; (4C82)
273F:4C6B                       loc_968:                                        ;  xref 273F:4C50
273F:4C6B  0B ED                                or      bp, bp                   ; Zero ?
273F:4C6D  74 06                                jz      loc_969                 ; Jump if zero
273F:4C6F  83 ED 01                             sub     bp, 1
273F:4C72  83 EB 54                             sub     bx, DECODED_PATHS_WIDTH * 2
273F:4C75                       loc_969:                                        ;  xref 273F:4C6D
273F:4C75  C7 45 16 0054                        mov     word ptr [di+PATHFIND_Y_CHANGE1], DECODED_PATHS_WIDTH * 2
273F:4C7A  B9 0018                              mov     cx, ROOM_PATHS_HEIGHT
273F:4C7D  2B CD                                sub     cx, bp
273F:4C7F  89 4D 1A                             mov     [di+PATHFIND_Y_CHANGE2], cx
273F:4C82                       loc_970:

; This next section populates the walkable sections of the decompressed array
; with incrementing numbers indicating the number of cells away each cell is
; from the source. A walkable path can be later formed by following the
; path of decrementing numbers from the destination to the source and reversing it

273F:4C82  8B 55 14                             mov     dx,[di+PATHFIND_X_CHANGE1]
273F:4C85                       loc_971:                                        ;  xref 273F:4CC6, 4CCE, 4CDA
273F:4C85 56                                   push    si
273F:4C86  53                                   push    bx
273F:4C87  8B 36 3944                           mov     si, pathfind_countdown_ctr
273F:4C8B  8B 4D 1A                             mov     cx, [di+PATHFIND_Y_CHANGE2]

273F:4C8E                       locloop_972:                                    ;  xref 273F:4C9F
273F:4C8E  51                                   push    cx
273F:4C8F  53                                   push    bx
273F:4C90  8B 4D 18                             mov     cx, [di+PATHFIND_X_CHANGE2]

273F:4C93                       locloop_973:                                    ;  xref 273F:4C98
273F:4C93  E8 021A                              call    pathfind_populate_cells
273F:4C96  03 DA                                add     bx, dx
273F:4C98  E2 F9                                loop    locloop_973             ; Loop if cx > 0

273F:4C9A  5B                                   pop     bx
273F:4C9B  59                                   pop     cx
273F:4C9C  03 5D 16                             add     bx, [di+PATHFIND_Y_CHANGE1]
273F:4C9F  E2 ED                                loop    locloop_972             ; Loop if cx > 0

273F:4CA1  89 36 3944                           mov     pathfind_countdown_ctr, si
273F:4CA5  5B                                   pop     bx
273F:4CA6  5E                                   pop     si
273F:4CA7  F7 04 FFFF                           test    word ptr [si], 0FFFFh   ; Dest been filled in yet?
273F:4CAB  75 2F                                jnz     loc_977                 ; Jump if yes

273F:4CAD  80 7D 1A 18                          cmp     byte ptr [di+PATHFIND_Y_CHANGE2], ROOM_PATHS_HEIGHT
273F:4CB1  75 08                                jne     loc_974                 ; Jump if not equal
273F:4CB3  80 7D 18 28                          cmp     byte ptr [di+PATHFIND_X_CHANGE2], ROOM_PATHS_WIDTH
273F:4CB7  74 17                                je      loc_976                 ; Jump if equal
273F:4CB9  EB 07                                jmp     short loc_975
273F:4CBB                       loc_974:                                        ;  xref 273F:4CB1
273F:4CBB  2B 5D 16                             sub     bx, [di+PATHFIND_Y_CHANGE1]
273F:4CBE  83 45 1A 01                          add     word ptr [di+PATHFIND_Y_CHANGE2], 1
273F:4CC2                       loc_975:
273F:4CC2  80 7D 18 28                          cmp     byte ptr [di+PATHFIND_X_CHANGE2], ROOM_PATHS_WIDTH
273F:4CC6  74 BD                                je      loc_971                 ; Jump if equal
273F:4CC8  2B DA                                sub     bx, dx
273F:4CCA  83 45 18 01                          add     word ptr [di+PATHFIND_X_CHANGE2], 1
273F:4CCE  EB B5                                jmp     short loc_971

273F:4CD0                       loc_976:
273F:4CD0  F6 45 13 FF                          test    byte ptr [di+PATHFIND_CELL_POPULATED], 0FFh
273F:4CD4  74 08                                jz      loc_978                 ; Jump if no cell populated
273F:4CD6  C6 45 13 00                          mov     byte ptr [di+PATHFIND_CELL_POPULATED], 0
273F:4CDA  EB A9                                jmp     short loc_971           ; Jump for another try
273F:4CDC                       loc_977:
273F:4CDC  EB 66                                jmp     short loc_982
273F:4CDE                       loc_978:
273F:4CDE  C6 45 05 02                          mov     byte ptr [di+PATHFIND_DEST_STATE], 2 ; No path to destination
273F:4CE2                       loc_979:
273F:4CE2  F6 45 12 FF                          test    byte ptr [di+PATHFIND_DEST_OCCUPIED], 0FFh
273F:4CE6  74 08                                jz      loc_980                 ; Jump if zero
273F:4CE8  C7 04 FFFF                           mov     word ptr [si], 0FFFFh   ; Restore destination occupied
273F:4CEC  C6 45 12 00                          mov     byte ptr [di+PATHFIND_DEST_OCCUPIED], 0
273F:4CF0                       loc_980:

; Do a scan of the lines, if necessary, to allow the character to walk up to
; a wall without walking into it
273F:4CF0  57                                   push    di
273F:4CF1  8B EE                                mov     bp, si
273F:4CF3  8B DE                                mov     bx, si                  ; bx=bp=destination cell
273F:4CF5  B2 FF                                mov     dl, 0FFh
273F:4CF7  8B 4D 06                             mov     cx, [di+PATHFIND_DEST_X]
273F:4CFA  83 C1 01                             add     cx, 1
273F:4CFD  BF FFFE                              mov     di, 0FFFEh
273F:4D00  E8 0220                              call    pathfind_scan_line
273F:4D03  5F                                   pop     di
273F:4D04  57                                   push    di
273F:4D05  B9 0028                              mov     cx, ROOM_PATHS_WIDTH
273F:4D08  2B 4D 06                             sub     cx, [di+PATHFIND_DEST_X]
273F:4D0B  BF 0002                              mov     di, 2
273F:4D0E  E8 0212                              call    pathfind_scan_line
273F:4D11  5F                                   pop     di
273F:4D12  57                                   push    di
273F:4D13  8B 4D 08                             mov     cx, [di+PATHFIND_DEST_Y]
273F:4D16  83 C1 01                             add     cx, 1
273F:4D19  BF FFAC                              mov     di, -DECODED_PATHS_WIDTH*2
273F:4D1C  E8 0204                              call    pathfind_scan_line
273F:4D1F  5F                                   pop     di
273F:4D20  57                                   push    di
273F:4D21  B9 0018                              mov     cx, ROOM_PATHS_HEIGHT
273F:4D24  2B 4D 08                             sub     cx, [di+PATHFIND_DEST_Y]
273F:4D27  BF 0054                              mov     di, DECODED_PATHS_WIDTH*2
273F:4D2A  E8 01F6                              call    pathfind_scan_line
273F:4D2D  5F                                   pop     di
273F:4D2E  8B F5                                mov     si, bp
273F:4D30  3B DE                                cmp     bx, si
273F:4D32  75 0E                                jne     loc_981                 ; Jump if not equal
273F:4D34  C6 45 05 03                          mov     byte ptr [di+PATHFIND_DEST_STATE], 3
273F:4D38 BB 3940                              mov     bx, offset pathfind_buffer_end
273F:4D3B  C7 07 0000                           mov     word ptr [bx], 0
273F:4D3F  E9 0132                              jmp     loc_1003                ; (4E74)
273F:4D42                       loc_981:                                        ;  xref 273F:4D32
273F:4D42  8B F3                                mov     si, bx

273F:4D44                       loc_982:                                        ;  xref 273F:4CDC
273F:4D44  F6 45 12 FF                          test    byte ptr [di+PATHFIND_DEST_OCCUPIED], 0FFh
273F:4D48  75 98                                jnz     loc_979                 ; Jump if not zero

; end of cell population
; Fill out any cells that are still blank (ie. anywhere that can't reach the
; destination) as occupied

273F:4D4A  FC                                   cld                             ; Clear direction
273F:4D4B  57                                   push    di
273F:4D4C  83 C7 1C                             add     di, 1Ch                 ; di=start of grid
273F:4D4F  B9 0445                              mov     cx, DECODED_PATHS_WIDTH*DECODED_PATHS_HEIGHT+1 ;445h
273F:4D52  33 C0                                xor     ax, ax
273F:4D54                       loc_983:                              
273F:4D54 F2/ AF                               repne   scasw                   ; Scan for an empty cell
273F:4D56  0B C9                                or      cx, cx                  ; Reached end of list?
273F:4D58  74 07                                jz      loc_984                 ; Jump if yes
273F:4D5A  C7 45 FE FFFF                        mov     word ptr [di-2], 0FFFFh ; Replace it with occupied state
273F:4D5F  EB F3                                jmp     short loc_983
           
273F:4D61                       loc_984:                                        
273F:4D61  5F                                   pop     di
273F:4D62  33 D2                                xor     dx, dx
273F:4D64  B1 FF                                mov     cl,0FFh
273F:4D66 BB 3940                              mov     bx, offset pathfind_buffer_end
273F:4D69  C7 07 0000                           mov     word ptr [bx], 0
273F:4D6D  F6 45 05 FF                          test    byte ptr [di+PATHFIND_DEST_STATE], 0FFh
273F:4D71  75 1D                                jnz     loc_987                 ; Jump if not zero
273F:4D73  8B 45 10                             mov     ax, [di+PATHFIND_DEST_X2]
273F:4D76  0B C0                                or      ax,ax                   ; Zero ?
273F:4D78  74 16                                jz      loc_987                 ; Jump if zero
273F:4D7A  78 07                                js      loc_985                 ; Jump if sign=1
273F:4D7C  C7 47 FE 0002                        mov     word ptr [bx-2], FACING2_RIGHT
273F:4D81  EB 07                                jmp     short loc_986           ; (4D8A)
273F:4D83                       loc_985:                                        ;  xref 273F:4D7A
273F:4D83  C7 47 FE 0001                        mov     word ptr [bx-2], FACING2_LEFT
273F:4D88  F7 D8                                neg     ax
273F:4D8A                       loc_986:                                        ;  xref 273F:4D81
273F:4D8A  89 47 FC                             mov     [bx-4], ax              ; Save # steps
273F:4D8D  83 EB 04                             sub     bx, 4
273F:4D90                       loc_987:                                        ;  xref 273F:4D71, 4D78, 4E64, 4E6F

273F:4D90 53                                   push    bx
273F:4D91  56                                   push    si

; Form a set of steps starting at the source
273F:4D92                       loc_988:
273F:4D92 8B 04                                mov     ax, [si]                ; Get steps value from current pos
273F:4D94  2D 0001                              sub     ax, 1
273F:4D97  74 4A                                jz      loc_992                 ; Jump if zero
273F:4D99  F6 C2 26                             test    dl, 38
273F:4D9C  75 11                                jnz     loc_989                 ; Jump if not zero
273F:4D9E  39 44 AC                             cmp     [si-DECODED_PATHS_WIDTH*2], ax
273F:4DA1  74 67                                je      loc_996                 ; Jump if equal
273F:4DA3  39 44 54                             cmp     [si+DECODED_PATHS_WIDTH*2], ax
273F:4DA6  74 60                                je      loc_995                 ; Jump if equal
273F:4DA8  39 44 02                             cmp     [si+2], ax
273F:4DAB  74 38                                je      loc_993                 ; Jump if equal
273F:4DAD  EB 11                                jmp     short loc_990           ; (4DC0)
273F:4DAF                       loc_989:                                        ;  xref 273F:4D9C
273F:4DAF  39 44 02                             cmp     [si+2], ax
273F:4DB2  74 31                                je      loc_993                 ; Jump if equal
273F:4DB4  39 44 FE                             cmp     [si-2], ax
273F:4DB7  74 07                                je      loc_990                 ; Jump if equal
273F:4DB9  39 44 54                             cmp     [si+DECODED_PATHS_WIDTH*2], ax
273F:4DBC  74 70                                je      loc_998                 ; Jump if equal
273F:4DBE  EB 4A                                jmp     short loc_996           ; (4E0A)
273F:4DC0                       loc_990:                                        ;  xref 273F:4DAD, 4DB7
273F:4DC0  80 E2 03                             and     dl,3
273F:4DC3  F6 C2 02                             test    dl,2
273F:4DC6  75 10                                jnz     loc_991                 ; Jump if not zero
273F:4DC8  80 C6 01                             add     dh,1
273F:4DCB  C7 47 FE 0002                        mov     word ptr [bx-2], FACING2_RIGHT
273F:4DD0  C7 47 FC 0000                        mov     word ptr [bx-4], 0
273F:4DD5  83 EB 04                             sub     bx, 4
273F:4DD8                       loc_991:                                        ;  xref 273F:4DC6
273F:4DD8  83 EE 02                             sub     si,2
273F:4DDB  83 07 08                             add     word ptr [bx],8
273F:4DDE  80 CA 02                             or      dl,2
273F:4DE1  EB AF                                jmp     short loc_988           ; (4D92)
273F:4DE3                       loc_992:                                        ;  xref 273F:4D97
273F:4DE3  EB 6D                                jmp     short loc_1000          ; (4E52)
273F:4DE5                       loc_993:                                        ;  xref 273F:4DAB, 4DB2
273F:4DE5  80 E2 05                             and     dl,5
273F:4DE8  F6 C2 04                             test    dl,4
273F:4DEB  75 10                                jnz     loc_994                 ; Jump if not zero
273F:4DED  80 C6 01                             add     dh,1
273F:4DF0  C7 47 FE 0001                        mov     word ptr [bx-2], FACING2_LEFT
273F:4DF5  C7 47 FC 0000                        mov     word ptr [bx-4], 0
273F:4DFA  83 EB 04                             sub     bx, 4
273F:4DFD                       loc_994:                                        ;  xref 273F:4DEB
273F:4DFD  83 C6 02                             add     si, 2
273F:4E00  83 07 08                             add     word ptr [bx], 8        ; Add # steps
273F:4E03  80 CA 04                             or      dl, 4
273F:4E06  EB 8A                                jmp     short loc_988           ; (4D92)
273F:4E08                       loc_995:                                        ;  xref 273F:4DA6
273F:4E08  EB 24                                jmp     short loc_998           ; (4E2E)
273F:4E0A                       loc_996:                                        ;  xref 273F:4DA1, 4DBE
273F:4E0A  80 E2 09                             and     dl,9
273F:4E0D  F6 C2 08                             test    dl,8
273F:4E10  75 10                                jnz     loc_997                 ; Jump if not zero
273F:4E12  80 C6 01                             add     dh,1
273F:4E15  C7 47 FE 0008                        mov     word ptr [bx-2], FACING2_DOWN
273F:4E1A  C7 47 FC 0000                        mov     word ptr [bx-4], 0
273F:4E1F  83 EB 04                             sub     bx, 4
273F:4E22                       loc_997:                                        ;  xref 273F:4E10
273F:4E22  83 EE 54                             sub     si, DECODED_PATHS_WIDTH*2
273F:4E25  83 07 08                             add     word ptr [bx], 8        ; Add # steps
273F:4E28  80 CA 08                             or      dl, 8
273F:4E2B  E9 FF64                              jmp     loc_988                 ; (4D92)
273F:4E2E                       loc_998:                                        ;  xref 273F:4DBC, 4E08
273F:4E2E  80 E2 11                             and     dl,11h
273F:4E31  F6 C2 10                             test    dl,10h
273F:4E34  75 10                                jnz     loc_999                 ; Jump if not zero
273F:4E36  80 C6 01                             add     dh,1
273F:4E39  C7 47 FE 0004                        mov     word ptr [bx-2], FACING2_UP
273F:4E3E  C7 47 FC 0000                        mov     word ptr [bx-4], 0
273F:4E43  83 EB 04                             sub     bx, 4
273F:4E46                       loc_999:                                        ;  xref 273F:4E34
273F:4E46  83 C6 54                             add     si, DECODED_PATHS_WIDTH*2
273F:4E49  83 07 08                             add     word ptr [bx], 8        ; Add # steps
273F:4E4C  80 CA 10                             or      dl, 10h
273F:4E4F  E9 FF40                              jmp     loc_988                 ; (4D92)

; This post-check is used to go through the paths two times - the first two
; tries the path using standard direction checks, the second using the alternate
; checks. If the first run through was the shortest, redo the process a third
; time to get the walking sequence that was obtained the first time
273F:4E52                       loc_1000:
273F:4E52  F6 C2 01                             test    dl, 1                   ; Test for exit flag
273F:4E55  75 1B                                jnz     loc_1002                ; Jump if yes
273F:4E57  F6 C1 80                             test    cl, 80h
273F:4E5A  74 0B                                jz      loc_1001                ; Jump if zero
273F:4E5C  5E                                   pop     si
273F:4E5D  5B                                   pop     bx
273F:4E5E  8A CE                                mov     cl, dh                  ; Store number of steps
273F:4E60  32 F6                                xor     dh, dh                  ; Reset counter
273F:4E62  B2 20                                mov     dl, 20h                 ; Flag for alt direction check
273F:4E64  E9 FF29                              jmp     loc_987                 ; Go get directions again
273F:4E67                       loc_1001:
273F:4E67  3A CE                                cmp     cl, dh
273F:4E69  73 07                                jae     loc_1002                ; Jump if above or =
273F:4E6B  5E                                   pop     si
273F:4E6C  5B                                   pop     bx
273F:4E6D  B2 01                                mov     dl, 1                   ; Flag for exit after retry
273F:4E6F  E9 FF1E                              jmp     loc_987

273F:4E72                       loc_1002:
273F:4E72  5E                                   pop     si
273F:4E73  58                                   pop     ax

273F:4E74                       loc_1003:
273F:4E74  FC                                   cld                             ; Clear direction
273F:4E75  8B 45 0C                             mov     ax, [di+PATHFIND_X]
273F:4E78  A9 FFFF                              test    ax, 0FFFFh              ; Check X position
273F:4E7B  74 19                                jz      loc_1006
273F:4E7D  78 0A                                js      loc_1004                ; Move
273F:4E7F  C7 47 FE 0001                        mov     word ptr [bx-2], FACING2_LEFT
273F:4E84  89 47 FC                             mov     [bx-4], ax              ; Save # steps
273F:4E87  EB 0A                                jmp     short loc_1005
273F:4E89                       loc_1004:                                       ;  xref 273F:4E7D
273F:4E89  C7 47 FE 0002                        mov     word ptr [bx-2], FACING2_RIGHT
273F:4E8E  F7 D8                                neg     ax
273F:4E90  89 47 FC                             mov     [bx-4], ax              ; Save # steps
273F:4E93                       loc_1005:
273F:4E93  83 EB 04                             sub     bx, 4                   ; Move back one record
273F:4E96                       loc_1006:                                       ; End of pathfinding
273F:4E96  C7 05 0000                           mov     word ptr [di], 0
273F:4E9A  8B 26 3942                           mov     sp, pathfind_sp
273F:4E9E  C6 06 3946 00                        mov     pathfind_in_progress, 0 ; Reset in-progress flag
273F:4EA3  B8 0001                              mov     ax, 1                   ; Set return value
273F:4EA6  02 45 05                             add     al, [di+PATHFIND_DEST_STATE]
273F:4EA9  50                                   push    ax
273F:4EAA  53                                   push    bx
273F:4EAB  06                                   push    es
273F:4EAC  07                                   pop     es
273F:4EAD  5B                                   pop     bx
273F:4EAE  58                                   pop     ax
273F:4EAF  C3                                   retn
                        character_pathfind      endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:4C93
                                ;

                     pathfind_populate_cells    proc    near
273F:4EB0  F7 07 FFFF                           test    word ptr [bx], 0FFFFh   ; Is cell occupied?
273F:4EB4  75 48                                jnz     loc_1013                ; Jump if it is
273F:4EB6  BD FFFF                              mov     bp, 0FFFFh
273F:4EB9  8B 47 AC                             mov     ax, [bx-(DECODED_PATHS_WIDTH*2)] ; Get cell from one line up
273F:4EBC  0B C0                                or      ax, ax                  ; Is it occupied
273F:4EBE  74 06                                jz      loc_1007                ; Jump if not
273F:4EC0  3B C5                                cmp     ax, bp                  ; Is it standard occupied indicator?
273F:4EC2  73 02                                jae     loc_1007
273F:4EC4  8B E8                                mov     bp,ax                   ; Store loaded cell value
273F:4EC6                       loc_1007:
273F:4EC6  8B 47 54                             mov     ax, [bx+(DECODED_PATHS_WIDTH*2)] ; Get cell from next line
273F:4EC9  0B C0                                or      ax, ax                  ; Is it occupied?
273F:4ECB  74 06                                jz      loc_1008                ; Jump if not
273F:4ECD  3B C5                                cmp     ax, bp
273F:4ECF  73 02                                jae     loc_1008
273F:4ED1  8B E8                                mov     bp, ax                  ; Store loaded cell value
273F:4ED3                       loc_1008:
273F:4ED3  8B 47 FE                             mov     ax, [bx-2]              ; Get cell from left
273F:4ED6  0B C0                                or      ax, ax                  ; Is it occupied?
273F:4ED8  74 06                                jz      loc_1009                ; Jump if not
273F:4EDA  3B C5                                cmp     ax, bp
273F:4EDC  73 02                                jae     loc_1009                ; Store loaded cell value
273F:4EDE  8B E8                                mov     bp, ax
273F:4EE0                       loc_1009:
273F:4EE0  8B 47 02                             mov     ax, [bx+2]              ; Get cell from right
273F:4EE3  0B C0                                or      ax, ax                  ; Is it occupied?
273F:4EE5  74 06                                jz      loc_1010                ; Jump if not
273F:4EE7  3B C5                                cmp     ax, bp
273F:4EE9  73 02                                jae     loc_1010
273F:4EEB  8B E8                                mov     bp, ax                  ; Store loaded cell value
273F:4EED                       loc_1010:

; At this point, bp contains the lowest value from the surrounding cells, not
; counting entries with 0ffff (occupied). Below we will now add 1 to the value
; and store it in the cell. By repeated calls processing the entire grid, we
; can figure out a path to the destination by following sequential numbers
273F:4EED  83 C5 01                             add     bp, 1
273F:4EF0  74 06                                jz      loc_1011                ; If no vals found, skip save
273F:4EF2  89 2F                                mov     [bx], bp                ; Store value
273F:4EF4  C6 45 13 01                          mov     byte ptr [di+PATHFIND_CELL_POPULATED], 1
273F:4EF8                       loc_1011:                                       ;  xref 273F:4EF0
273F:4EF8  83 EE 03                             sub     si, 3                   ; Decrement countdown ctr
273F:4EFB  72 06                                jc      loc_1014                ; Break if countdown ended

273F:4EFD                       loc_ret_1012:                                   ;  xref 273F:4F01
273F:4EFD  C3                                   retn
273F:4EFE                       loc_1013:                                       ;  xref 273F:4EB4
273F:4EFE  83 EE 01                             sub     si, 1                   ; Decrement countdown ctr
273F:4F01  73 FA                                jnc     loc_ret_1012            ; Don't break if countdown not ended
273F:4F03                       loc_1014:                                       
273F:4F03  89 36 3944                           mov     pathfind_countdown_ctr, si
273F:4F07  50                                   push    ax
273F:4F08  53                                   push    bx
273F:4F09  51                                   push    cx
273F:4F0A  52                                   push    dx
273F:4F0B  56                                   push    si
273F:4F0C  57                                   push    di
273F:4F0D  55                                   push    bp
273F:4F0E  1E                                   push    ds
273F:4F0F  06                                   push    es
273F:4F10  9C                                   pushf
273F:4F11  E8 0034                              call    pathfind_return_to_sp
273F:4F14  9D                                   popf
273F:4F15  07                                   pop     es
273F:4F16  1F                                   pop     ds
273F:4F17  5D                                   pop     bp
273F:4F18  5F                                   pop     di
273F:4F19  5E                                   pop     si
273F:4F1A  5A                                   pop     dx
273F:4F1B  59                                   pop     cx
273F:4F1C  5B                                   pop     bx
273F:4F1D  58                                   pop     ax
273F:4F1E  8B 36 3944                           mov     si, pathfind_countdown_ctr
273F:4F22  C3                                   retn
                     pathfind_populate_cells    endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:4D00, 4D0E, 4D1C, 4D2A
                                ;

                         pathfind_scan_line     proc    near
273F:4F23  8B F5                                mov     si, bp
273F:4F25  32 F6                                xor     dh, dh

273F:4F27                       locloop_1015:                                   ;  xref 273F:4F45
273F:4F27  03 F7                                add     si, di                  ; Add increment amount
273F:4F29  80 C6 01                             add     dh,1
273F:4F2C  F7 04 FFFF                           test    word ptr [si], 0FFFFh   ; Check cell
273F:4F30  74 13                                jz      loc_1018                ; Skip if empty (unpopulated)
273F:4F32  78 11                                js      loc_1018                ; Or if occupied
273F:4F34  3A D6                                cmp     dl, dh                  ; Check ctr against max
273F:4F36  72 0C                                jb      loc_ret_1017            ; Exit if below
273F:4F38  75 06                                jnz     loc_1016                ; Jump if not equal
273F:4F3A  8B 04                                mov     ax, [si]
273F:4F3C  3B 07                                cmp     ax, [bx]
273F:4F3E  73 04                                jae     loc_ret_1017            ; Jump if above or =
273F:4F40                       loc_1016:                                       ;  xref 273F:4F38
273F:4F40  8B DE                                mov     bx,si
273F:4F42  8A D6                                mov     dl, dh

273F:4F44                       loc_ret_1017:                                   ;  xref 273F:4F36, 4F3E
273F:4F44  C3                                   retn
273F:4F45                       loc_1018:                                       ;  xref 273F:4F30, 4F32
273F:4F45  E2 E0                                loop    locloop_1015            ; Loop if cx > 0

273F:4F47  C3                                   retn
                         pathfind_scan_line     endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:4F11
                                ;

                     pathfind_return_to_sp      proc    near
273F:4F48  89 25                                mov     [di], sp
273F:4F4A  8B 26 3942                           mov     sp, pathfind_sp
273F:4F4E  33 C0                                xor     ax, ax
273F:4F50  FC                                   cld                             ; Clear direction
273F:4F51  C3                                   retn
                     pathfind_return_to_sp      endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:5039, 5127, 5EB0, 5EE9, 5F56
                                ;

                             pathfind_reset     proc    near
273F:4F52  53                                   push    bx
273F:4F53  3D 03E8                              cmp     ax, PLAYER_HOTSPOT_ID
273F:4F56  75 0E                                jne     loc_1019                ; Jump if not equal
273F:4F58 BB 3983                              mov     bx, offset player_pathfind_data
273F:4F5B  C6 06 3946 00                        mov     pathfind_in_progress, 0
273F:4F60  C7 07 0000                           mov     word ptr [bx], 0
273F:4F64  5B                                   pop     bx
273F:4F65  C3                                   retn
273F:4F66                       loc_1019:                                       ;  xref 273F:4F56
273F:4F66 BB 4227                              mov     bx, offset chars_pathfind_data
273F:4F69  3B 47 02                             cmp     ax, [bx+2]
273F:4F6C  75 04                                jne     loc_1020                ; Jump if not equal
273F:4F6E  C7 07 0000                           mov     word ptr [bx], 0
273F:4F72                       loc_1020:                                       ;  xref 273F:4F6C
273F:4F72  5B                                   pop     bx
273F:4F73  C3                                   retn
                             pathfind_reset     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:8FE4
                                ;

273F:4F74                       sub_124         proc    near
273F:4F74  C6 06 3946 00                        mov     byte ptr ds:[3946h],0   ; (273F:3946=1Fh)
273F:4F79 BE 4227                              mov     si, offset chars_pathfind_data
273F:4F7C  C7 04 0000                           mov     word ptr [si],0
273F:4F80  C3                                   retn
                                sub_124         endp

273F:4F81  00                                   db      0

                                ;
                                ;                              SUBROUTINE
                                ;
                                ; Contains all the standard handling for characters, such as the Skorl
                                ;

                standard_character_tick_proc    proc    near
273F:4F82 8B DE                                mov     bx, si
273F:4F84  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:4F87  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:4F8A  E8 11EB                              call    talk_countdown_handler
273F:4F8D  F7 44 2F FFFF                        test    word ptr [si+HS_USE_HOTSPOT_ID], 0FFFFh
273F:4F92  74 1F                                jz      loc_1023                ; Jump if no hotspot to use
273F:4F94  8B 44 2B                             mov     ax, [si+HS_V2B]
273F:4F97  3D 002A                              cmp     ax, 2Ah
273F:4F9A  74 03                                je      loc_1022                ; Jump if equal
273F:4F9C  E9 F3C7                              jmp     character_update_movement

273F:4F9F                       loc_1022:                                       ;  xref 273F:4F9A
273F:4F9F  A3 BA1B                              mov     active_hotspot_id, ax
273F:4FA2  8B 44 2F                             mov     ax, [si+HS_USE_HOTSPOT_ID]
273F:4FA5  A3 BA19                              mov     use_hotspot_id, ax
273F:4FA8  8B 44 2D                             mov     ax, [si+HS_HOTSPOT_SCRIPT_ID
273F:4FAB  E8 EE86                              call    sequence_execute
273F:4FAE  C7 44 2F 0000                        mov     word ptr [si+HS_USE_HOTSPOT_ID], 0
273F:4FB3                       loc_1023:
273F:4FB3  F7 44 1F FFFF                        test    word ptr [si+HS_FRAME_CTR], 0FFFFh
273F:4FB8  74 05                                jz      loc_1024
273F:4FBA  83 6C 1F 01                          sub     word ptr [si+HS_FRAME_CTR], 1
273F:4FBE  C3                                   retn
273F:4FBF                       loc_1024:
273F:4FBF  E8 C149                              call    character_find_impinging_chars
273F:4FC2  F6 45 1D FF                          test    byte ptr [di+ANIM_SKIP], 0FFh
273F:4FC6  74 4C                                jz      loc_1028                ; Skip if necessary
273F:4FC8  F7 06 10BE FFFF                      test    num_impinging_chars, 0FFFFh ; Bumped into anyone?
273F:4FCE  74 40                                jz      loc_1027                ; Jump if not
273F:4FD0  56                                   push    si
273F:4FD1 BE 10C0                              mov     si, offset impinging_char_list
273F:4FD4                       loc_1025:
273F:4FD4  AD                                   lodsw                           ; Get character Id
273F:4FD5  0B C0                                or      ax, ax                  ; End of list reached?
273F:4FD7  74 2C                                jz      loc_1026                ; Jump if yes
273F:4FD9  3D 03E8                              cmp     ax, PLAYER_HOTSPOT_ID   ; Is it the player?
273F:4FDC  75 F6                                jne     loc_1025                ; Skip if yes
273F:4FDE  80 3E 6D33 02                        cmp     [player_hotspot_rec+HS_CHAR_MODE], CHARMODE_IDLE
273F:4FE3  75 20                                jne     loc_1026                ; Jump if not equal
273F:4FE5  5E                                   pop     si                      ; Signal the player to move
273F:4FE6 BE 6CEF                              mov     si, offset player_hotspot_rec   ; out of the way
273F:4FE9  BF B14E                              mov     di, offset animation_table
273F:4FEC  8B DE                                mov     bx, si
273F:4FEE  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:4FF1  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:4FF4  C6 44 4C 01                          mov     byte ptr [si+HS_BLOCKED_FLAG], 1
273F:4FF8  C7 44 52 0000                        mov     [si+HS_DEST_HOTSPOT], 0
273F:4FFD  C6 06 9834 04                        mov     cursor_state, CURSORSTATE_BUMPED
273F:5002  E9 0661                              jmp     character_set_random_dest

273F:5005                       loc_1026:                                     
273F:5005  5E                                   pop     si
273F:5006  C6 44 44 03                          mov     byte ptr [si+HS_CHAR_MODE], CHARMODE_PAUSED
273F:500A  C7 44 42 000A                        mov     word ptr [si+HS_DELAY_CTR], 10
273F:500F  C3                                   retn

273F:5010                       loc_1027:
273F:5010  C6 45 1D 00                          mov     byte ptr [di+ANIM_SKIP], 0
273F:5014                       loc_1028:
273F:5014  F7 44 47 FFFF                        test    [si+HS_USE2_HOTSPOT_ID], 0FFFFh
273F:5019  74 11                                jz      loc_1029                ; Jump if zero
273F:501B  8B 44 47                             mov     ax, [si+HS_USE2_HOTSPOT_ID]
273F:501E  A3 BA19                              mov     use_hotspot_id, ax
273F:5021  8B 44 45                             mov     ax, [si+HS_TICK_SCRIPT_OFFSET]
273F:5024  E8 EE0D                              call    sequence_execute
273F:5027  C7 44 47 0000                        mov     word ptr [si+HS_USE2_HOTSPOT_ID], 0

273F:502C                       loc_1029:
273F:502C  F7 44 4A FFFF                        test    word ptr [si+HS_V4A], 0FFFFh
273F:5031  74 21                                jz      loc_1031                ; Jump if zero
273F:5033  E8 F330                              call    character_update_movement
273F:5036  8B 45 1B                             mov     ax, [di+ANIM_HOTSPOT_ID]
273F:5039  E8 FF16                              call    pathfind_reset
273F:503C  83 7C 4A 01                          cmp     word ptr [si+HS_V4A], 1
273F:5040  74 03                                je      loc_1030                ; Jump if equal
273F:5042  E9 F521                              jmp     loc_870                 ; (4566)
273F:5045                       loc_1030:                                       ;  xref 273F:5040
273F:5045  C7 44 4A 0000                        mov     word ptr [si+HS_V4A], 0
273F:504A  F6 44 44 FF                          test    byte ptr [si+HS_V4A], 0FFh
273F:504E  75 04                                jnz     loc_1031                ; Jump if not zero
273F:5050  E8 F334                              call    character_pathfind_clear
273F:5053  C3                                   retn

273F:5054                       loc_1031:                                       ;  xref 273F:5031, 504E
273F:5054  F6 44 44 FF                          test    byte ptr [si+HS_CHAR_MODE], 0FFh
273F:5058  75 02                                jnz     loc_1032                ; Jump if not zero
273F:505A  EB 6C                                jmp     short loc_1040          ; (50C8)
273F:505C                       loc_1032:                                       ;  xref 273F:5058
273F:505C  8A 44 44                             mov     al, [si+HS_CHAR_MODE]
273F:505F  3C 06                                cmp     al, CHARMODE_6
273F:5061  75 17                                jne     loc_1034                ; Jump if not equal
273F:5063  E8 F300                              call    character_update_movement
273F:5066  53                                   push    bx
273F:5067 BB 10BE                              mov     bx, offset num_impinging_chars
273F:506A                       loc_1033:                                       ;  xref 273F:5076
273F:506A  8B 07                                mov     ax, [bx]                ; Get impinging char Id
273F:506C  0B C0                                or      ax, ax                  ; End of list reached?
273F:506E  74 37                                jz      loc_1037
273F:5070  83 C3 02                             add     bx, 2                   ; Move to next entry
273F:5073  3D 03E8                              cmp     ax, PLAYER_HOTSPOT_ID   ; Is character the player?
273F:5076  75 F2                                jne     loc_1033                ; Keep looping
273F:5078  5B                                   pop     bx
273F:5079  C3                                   retn

273F:507A                       loc_1034:                                       ; HS[44h] != 6
273F:507A  F7 44 42 FFFF                        test    word ptr [si+HS_DELAY_CTR], 0FFFFh
273F:507F  74 27                                jz      loc_1038                ; Jump if zero
273F:5081  E8 F2E2                              call    character_update_movement
273F:5084  F7 44 50 FFFF                        test    word ptr [si+HS_DIRECTION], 0FFFFh
273F:5089  74 17                                jz      loc_1035                ; Jump if zero
273F:508B  56                                   push    si
273F:508C  8B 5C 50                             mov     bx, [si+HS_DIRECTION]
273F:508F  E8 BC56                              call    get_room_resource_pointer
273F:5092  5B                                   pop     bx
273F:5093  87 F3                                xchg    si, bx                  ; si=char Id,
273F:5095  8B 44 06                             mov     ax, [si+HS_ROOM_NUM]
273F:5098  3B 47 06                             cmp     ax, [bx+HS_ROOM_NUM]
273F:509B  75 0B                                jne     loc_1038                ; Jump if not equal
273F:509D  E8 0501                              call    characters_impinging_check
273F:50A0  74 06                                jz      loc_1038                ; Jump if zero
273F:50A2                       loc_1035:                                       ;  xref 273F:5089
273F:50A2  83 6C 42 01                          sub     word ptr [si+HS_DELAY_CTR], 1

273F:50A6                       loc_ret_1036:                                   ;  xref 273F:50BB
273F:50A6  C3                                   retn
273F:50A7                       loc_1037:                                       ;  xref 273F:506E
273F:50A7  5B                                   pop     bx
273F:50A8                       loc_1038:                                       ;  xref 273F:507F, 509B, 50A0
273F:50A8  33 C0                                xor     ax,ax                   ; Zero register
273F:50AA  89 44 50                             mov     [si+HS_DIRECTION], ax
273F:50AD  86 44 44                             xchg    [si+HS_CHAR_MODE], al
273F:50B0  50                                   push    ax
273F:50B1  E8 F2D3                              call    character_pathfind_clear
273F:50B4  58                                   pop     ax
273F:50B5  3C 04                                cmp     al, CHARMODE_4
273F:50B7  74 04                                je      loc_1039                ; Jump if equal
273F:50B9  3C 07                                cmp     al, CHARMODE_7
273F:50BB  75 E9                                jne     loc_ret_1036            ; Jump if not equal
273F:50BD                       loc_1039:                                       ;  xref 273F:50B7
273F:50BD  C7 44 33 0000                        mov     word ptr [si+HS_V33], 0
273F:50C2  B8 0001                              mov     ax, 1
273F:50C5  E9 12E9                              jmp     display_message_dialog

273F:50C8                       loc_1040:                                       ;  xref 273F:505A
273F:50C8  F7 44 58 FFFF                        test    word ptr [si+58h],0FFFFh
273F:50CD  74 0F                                jz      loc_1041                ; Jump if zero
273F:50CF  F6 06 6D52 FF                        test    player_action_state, 0FFh
273F:50D4  74 08                                jz      loc_1041                ; Jump if zero
273F:50D6  C6 44 2A C7                          mov     byte ptr [si+HS_ACTION_CTR], 199
273F:50DA  C6 07 02                             mov     byte ptr [bx], CHAR_ACTION_DISPATCH_ACTION
273F:50DD  C3                                   retn

273F:50DE                       loc_1041:                                       ;  xref 273F:50CD, 50D4
273F:50DE  8A 07                                mov     al, [bx]                ; Get current atcion
273F:50E0  0A C0                                or      al,al                   ; Any defined?
273F:50E2  75 06                                jnz     loc_1042                ; Jump if yes
273F:50E4  B8 0002                              mov     ax, 2
273F:50E7  E9 F279                              jmp     character_update_movement_2
273F:50EA                       loc_1042:                                       ;  xref 273F:50E2
273F:50EA  3C 05                                cmp     al, CHAR_ACTION_CONTINUE_WALK
273F:50EC  74 28                                je      loc_1045
273F:50EE  3C 01                                cmp     al, CHAR_ACTION_START_WALK
273F:50F0  74 32                                je      loc_1048                ; Jump if equal
273F:50F2  3C 04                                cmp     al, CHAR_ACTION_PROCESSING_PATH
273F:50F4  74 3A                                je      loc_1049                ; Jump if equal
273F:50F6  3C 03                                cmp     al, CHAR_ACTION_EXEC_SCRIPT
273F:50F8  74 1F                                je      loc_1046                ; Jump if equal

; Dispatching action
273F:50FA  8B 45 0E                             mov     ax, [di+ANIM_ROOM_NUM]
273F:50FD  F7 47 03 FFFF                        test    word ptr [bx+CURRENT_ACTION_ROOM_NUM], 0FFFFh
273F:5102  75 03                                jnz     loc_1043                ; Jump if not zero
273F:5104  89 47 03                             mov     [bx+CURRENT_ACTION_ROOM_NUM], ax
273F:5107                       loc_1043:                                       ;  xref 273F:5102
273F:5107  3B 47 03                             cmp     ax, [bx+CURRENT_ACTION_ROOM_NUM] ; Compare against room number
273F:510A  74 03                                je      loc_1044                ; Jump if equal
273F:510C  E9 01F6                              jmp     loc_1078
273F:510F                       loc_1044:                                       ;  xref 273F:510A
273F:510F  C6 45 1D 00                          mov     byte ptr [di+ANIM_SKIP], 0
273F:5113  E9 F0A8                              jmp     action_dispatch
273F:5116                       loc_1045:                                       ;  xref 273F:50EC
273F:5116  E9 00E0                              jmp     loc_1060                ; (51F9)
273F:5119                       loc_1046:                                       ;  xref 273F:50F8
273F:5119  E8 BE8D                              call    hotspot_script_execute
273F:511C  0B C0                                or      ax,ax                   ; Zero ?
273F:511E  75 03                                jnz     loc_ret_1047            ; Jump if not zero
273F:5120  C6 07 02                             mov     byte ptr [bx], CHAR_ACTION_DISPATCH_ACTION

273F:5123                       loc_ret_1047:                                   ;  xref 273F:511E
273F:5123  C3                                   retn
273F:5124                       loc_1048:                                       ; Start walk
273F:5124  8B 45 1B                             mov     ax, [di+ANIM_HOTSPOT_ID]
273F:5127  E8 FE28                              call    pathfind_reset
273F:512A  C6 07 04                             mov     byte ptr [bx], CHAR_ACTION_PROCESSING_PATH
273F:512D  E8 F257                              call    character_pathfind_clear

273F:5130                       loc_1049:                                       ; Processing walk path
273F:5130  56                                   push    si
273F:5131  57                                   push    di
273F:5132  53                                   push    bx
273F:5133  E8 F42A                              call    sub_105                 ; (4560)
273F:5136  8B 4C 56                             mov     cx, [si+HS_DEST_Y]
273F:5139  8B 5C 54                             mov     bx, [si+HS_DEST_X]
273F:513C  8B 45 1B                             mov     ax, [di+ANIM_HOTSPOT_ID]
273F:513F  8A 54 4C                             mov     dl, [si+HS_BLOCKED_FLAG]
273F:5142  E8 F8B1                              call    character_pathfind
273F:5145  5A                                   pop     dx
273F:5146  5F                                   pop     di
273F:5147  5E                                   pop     si
273F:5148  0B C0                                or      ax,ax                   ; Zero ?
273F:514A  75 01                                jnz     loc_1050                ; Jump if not zero
273F:514C  C3                                   retn
273F:514D                       loc_1050:                                       ;  xref 273F:514A
273F:514D  3D 0001                              cmp     ax,1
273F:5150  74 0C                                je      loc_1051                ; Jump if equal
273F:5152  F7 44 52 FFFF                        test    [si+HS_DEST_HOTSPOT], 0FFFFh
273F:5157  75 07                                jnz     loc_1052                ; Jump if not zero
273F:5159  3D 0002                              cmp     ax,2
273F:515C  75 02                                jne     loc_1052                ; Jump if not equal
273F:515E                       loc_1051:                                       ;  xref 273F:5150
273F:515E  EB 79                                jmp     short loc_1058          ; (51D9)
273F:5160                       loc_1052:                                       ;  xref 273F:5157, 515C
273F:5160  87 D3                                xchg    dx,bx
273F:5162  80 7C 4C 02                          cmp     byte ptr [si+HS_BLOCKED_FLAG], 2
273F:5166  74 24                                je      loc_1054                ; Jump if equal
273F:5168  80 44 4C 01                          add     byte ptr [si+HS_BLOCKED_FLAG], 1
273F:516C  F6 44 4D FF                          test    byte ptr [si+HS_V4D], 0FFh
273F:5170  75 0B                                jnz     loc_1053                ; Jump if not zero
273F:5172  83 44 61 05                          add     word ptr [si+HS_ACTION_OFFSET], CURRENT_ACTION_RECORD_SIZE
273F:5176  C6 44 4D 01                          mov     byte ptr [si+HS_V4D], 1
273F:517A  83 C3 05                             add     bx, CURRENT_ACTION_RECORD_SIZE
273F:517D                       loc_1053:                                       ;  xref 273F:5170
273F:517D  C7 47 01 13C2                        mov     word ptr [bx+CURRENT_ACTION_SUPPORT_TABLE], 13C2h
273F:5182  C6 07 02                             mov     byte ptr [bx], CHAR_ACTION_DISPATCH_ACTION
273F:5185  8B 44 06                             mov     ax, [si+HS_ROOM_NUM]
273F:5188  89 47 03                             mov     [bx+CURRENT_ACTION_ROOM_NUM], ax
273F:518B  C3                                   retn
273F:518C                       loc_1054:                                       ;  xref 273F:5166
273F:518C  53                                   push    bx
273F:518D BB 10C0                              mov     bx, offset impinging_char_list
273F:5190                       loc_1055:                                       ;  xref 273F:519C
273F:5190  8B 07                                mov     ax, [bx]
273F:5192  0B C0                                or      ax,ax                   ; Zero ?
273F:5194  74 11                                jz      loc_1056                ; Jump if zero
273F:5196  83 C3 02                             add     bx,2
273F:5199  3D 03E8                              cmp     ax, PLAYER_HOTSPOT_ID
273F:519C  75 F2                                jne     loc_1055                ; Jump if not equal
273F:519E  5B                                   pop     bx
273F:519F  E8 0006                              call    sub_125                 ; (51A8)
273F:51A2  C6 44 44 06                          mov     byte ptr [si+HS_CHAR_MODE], CHARMODE_6
273F:51A6  C3                                   retn
273F:51A7                       loc_1056:                                       ;  xref 273F:5194
273F:51A7  5B                                   pop     bx

273F:51A8                       sub_125         proc    near
273F:51A8  E8 F296                              call    sub_97                  ; (4441)
273F:51AB  E8 F1B8                              call    character_update_movement
273F:51AE  83 6C 61 05                          sub     word ptr [si+HS_ACTION_OFFSET], CURRENT_ACTION_RECORD_SIZE
273F:51B2  C6 44 4D 00                          mov     byte ptr [si+HS_V4D], 0
273F:51B6  C6 44 4C 00                          mov     byte ptr [si+HS_BLOCKED_FLAG], 0
273F:51BA  C6 44 44 03                          mov     byte ptr [si+HS_CHAR_MODE], CHARMODE_3
273F:51BE  C7 44 42 0002                        mov     word ptr [si+HS_DELAY_CTR], 2
273F:51C3  8B DE                                mov     bx, si
273F:51C5  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:51C8  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:51CB  8B 44 06                             mov     ax, [si+HS_ROOM_NUM]
273F:51CE  3B 47 03                             cmp     ax, [bx+CURRENT_ACTION_ROOM_NUM]
273F:51D1  74 05                                je      loc_ret_1057            ; Jump if equal
273F:51D3  C7 44 52 FFFF                        mov     [si+HS_DEST_HOTSPOT], 0FFFFh

273F:51D8                       loc_ret_1057:                                   ;  xref 273F:51D1
273F:51D8  C3                                   retn
                                sub_125         endp
                standard_character_tick_proc    endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

273F:51D9                       loc_1058:                                       ;  xref 273F:515E
273F:51D9  C6 44 4C 00                          mov     byte ptr [si+HS_BLOCKED_FLAG],0
273F:51DD  F7 07 FFFF                           test    word ptr [bx],0FFFFh
273F:51E1  75 06                                jnz     loc_1059                ; Jump if not zero
273F:51E3  8B DA                                mov     bx,dx
273F:51E5  C6 07 02                             mov     byte ptr [bx],2
273F:51E8  C3                                   retn
273F:51E9                       loc_1059:                                       ;  xref 273F:51E1
273F:51E9  87 DA                                xchg    bx,dx
273F:51EB  C6 07 05                             mov     byte ptr [bx], CHAR_ACTION_CONTINUE_WALK
273F:51EE  E8 F01C                              call    character_translate_movements
273F:51F1  83 65 02 F8                          and     word ptr [di+2],0FFF8h
273F:51F5  83 64 0F F8                          and     word ptr [si+0Fh],0FFF8h
273F:51F9                       loc_1060:                                       ;  xref 273F:5116
273F:51F9  8B 44 52                             mov     ax, [si+HS_DEST_HOTSPOT]
273F:51FC  0B C0                                or      ax,ax                   ; Zero ?
273F:51FE  74 17                                jz      loc_1062                ; Jump if zero
273F:5200  3D FFFF                              cmp     ax,0FFFFh
273F:5203  74 12                                je      loc_1062                ; Jump if equal
273F:5205  56                                   push    si
273F:5206  53                                   push    bx
273F:5207  E8 1FE4                              call    room_exit_hs_get_pointer
273F:520A  8A 44 0C                             mov     al,[si+REHS_EXIT_BLOCKED]
273F:520D  5B                                   pop     bx
273F:520E  5E                                   pop     si
273F:520F  0A C0                                or      al,al                   ; Zero ?
273F:5211  74 04                                jz      loc_1062                ; Jump if zero
273F:5213  C6 07 02                             mov     byte ptr [bx], CHAR_ACTION_DISPATCH_ACTION

273F:5216                       loc_ret_1061:                                   ;  xref 273F:521C
273F:5216  C3                                   retn
273F:5217                       loc_1062:                                       ;  xref 273F:51FE, 5203, 5211
273F:5217  E8 BF9B                              call    sub_41                  ; (11B5)
273F:521A  0B C0                                or      ax,ax                   ; Zero ?
273F:521C  75 F8                                jnz     loc_ret_1061            ; Jump if not zero
273F:521E  F6 44 49 FF                          test    byte ptr [si+HS_PATHFIND_COVERED], 0FFh
273F:5222  74 03                                jz      loc_1063                ; Jump if zero
273F:5224  E8 F160                              call    character_pathfind_clear
273F:5227                       loc_1063:
273F:5227  8B DE                                mov     bx,si
273F:5229  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:522C  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:522F  E8 BC7E                              call    character_update_frame
273F:5232  0A C0                                or      al, al                  ; Zero ?
273F:5234  75 02                                jnz     loc_1064                ; Jump if not zero
273F:5236  EB 03                                jmp     short loc_1065
273F:5238                       loc_1064:
273F:5238  C6 07 02                             mov     byte ptr [bx], CHAR_ACTION_DISPATCH_ACTION
273F:523B                       loc_1065:
273F:523B  F7 44 52 FFFF                        test    [si+HS_DEST_HOTSPOT], 0FFFFh ; Walking to exit?
273F:5240  74 03                                jz      loc_ret_1066            ; If not then return
273F:5242  E8 F043                              call    character_check_room_change ; Room change check

273F:5245                       loc_ret_1066:
273F:5245  C3                                   retn

                                ;
                                ;                              JUMP POINT
                                ;
                                ;

                     character_change_room_2:
273F:5246  80 25 F8                             and     byte ptr [di+ANIM_X], 0F8h
273F:5249  80 64 0D F8                          and     byte ptr [si+HS_X], 0F8h
273F:524D  80 0D 05                             or      byte ptr [di+ANIM_X], 5
273F:5250  80 4C 0D 05                          or      byte ptr [si+HS_X], 5
273F:5254  C6 44 60 00                          mov     byte ptr [si+HS_EXIT_CTR], 0
273F:5258  C6 45 1D 2A                          mov     byte ptr [di+ANIM_SKIP], 2Ah
273F:525C  C6 07 02                             mov     byte ptr [bx], CHAR_ACTION_DISPATCH_ACTION
273F:525F  F6 C1 FF                             test    cl, 0FFh                ; Any direction specified?
273F:5262  74 12                                jz      loc_ret_1068            ; Exit if not
273F:5264  F6 C1 80                             test    cl, 80h
273F:5267  75 0E                                jnz     loc_1069                ; Face up
273F:5269  F6 C1 40                             test    cl, 40h
273F:526C  75 0C                                jnz     loc_1070                ; Face down
273F:526E  F6 C1 20                             test    cl, 20h
273F:5271  75 0A                                jnz     loc_1071                ; Face left
273F:5273  E9 F296                              jmp     char_face_right

273F:5276                       loc_ret_1068:
273F:5276  C3                                   retn
273F:5277                       loc_1069:
273F:5277  E9 F25F                              jmp     char_face_up
273F:527A                       loc_1070:
273F:527A  E9 F26D                              jmp     char_face_down
273F:527D                       loc_1071:
273F:527D  E9 F27B                              jmp     char_face_left

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                              npc_unknown_1     proc    near
273F:5280  F6 06 6D52 FF                        test    player_action_state, 0FFh
273F:5285  74 0E                                jz      loc_1072                ; Jump if zero
273F:5287  C7 44 42 000C                        mov     word ptr [si+HS_DELAY_CTR], 0Ch
273F:528C  C6 44 44 03                          mov     byte ptr [si+HS_CHAR_MODE], CHARMODE_3
273F:5290  C6 44 2A 00                          mov     byte ptr [si+HS_ACTION_CTR], 0
273F:5294  C3                                   retn
273F:5295                       loc_1072:
273F:5295  8B 4D 1B                             mov     cx, [di+ANIM_HOTSPOT_ID]
273F:5298  89 0E 983F                           mov     data_1090, cx
273F:529C  C7 06 9841 0000                      mov     data_1091, 0
273F:52A2  55                                   push    bp
273F:52A3  BB 0022                              mov     bx,22h
273F:52A6  BA 03E8                              mov     dx, PLAYER_HOTSPOT_ID
273F:52A9  E8 10E4                              call    display_message_dialog

273F:52AC  C6 44 44 04                          mov     byte ptr [si+HS_CHAR_MODE], CHARMODE_4
273F:52B0  C7 44 42 0082                        mov     word ptr [si+HS_DELAY_CTR], 82h
273F:52B5  5B                                   pop     bx
273F:52B6  8B 07                                mov     ax, [bx]
273F:52B8  89 44 33                             mov     [si+HS_V33], ax
273F:52BB  E9 EF1B                              jmp     loc_825                 ; (41D9)
                              npc_unknown_1     endp

                                ;
                                ;                              JUMP POINT
                                ;
                                ;

273F:52BE                       loc_1073:                                       ;  xref 273F:530D
273F:52BE  C6 44 60 00                          mov     byte ptr [si+HS_EXIT_CTR], 0
273F:52C2  F7 44 61 FFFF                        test    word ptr [si+HS_ACTION_OFFSET], 0FFFFh
273F:52C7  74 28                                jz      loc_1077                ; Jump if no cached actions
273F:52C9  53                                   push    bx
273F:52CA  F7 44 4E FFFF                        test    word ptr [si+HS_V4E], 0FFFFh
273F:52CF  74 18                                jz      loc_1075                ; Jump if zero
273F:52D1  8B 5F 01                             mov     bx, [bx+CURRENT_ACTION_SUPPORT_TABLE]
273F:52D4  81 FB 13BE                           cmp     bx, 13BEh
273F:52D8  72 06                                jb      loc_1074                ; Jump if below
273F:52DA 81 FB 13CE                           cmp     bx, 13CEh               ; (273F:13CE=54h)
273F:52DE  72 09                                jb      loc_1075                ; Jump if below
273F:52E0                       loc_1074:                                       ;  xref 273F:52D8
273F:52E0  C7 07 0017                           mov     word ptr [bx], ACTION_RETURN
273F:52E4  C7 47 02 0000                        mov     word ptr [bx+2], 0
273F:52E9                       loc_1075:                                       ;  xref 273F:52CF, 52DE
273F:52E9  5B                                   pop     bx
273F:52EA  8B 44 06                             mov     ax, [si+HS_ROOM_NUM]
273F:52ED  89 47 03                             mov     [bx+CURRENT_ACTION_ROOM_NUM], ax

273F:52F0                       loc_ret_1076:                                   ;  xref 273F:52F6
273F:52F0  C3                                   retn
273F:52F1                       loc_1077:                                       ;  xref 273F:52C7
273F:52F1  F7 44 5E FFFF                        test    word ptr [si+HS_BLOCKED_SUPPORT_OFFSET], 0FFFFh
273F:52F6  74 F8                                jz      loc_ret_1076            ; Jump if zero
273F:52F8  8B 44 5E                             mov     ax, [si+HS_BLOCKED_SUPPORT_OFFSET]
273F:52FB  89 47 01                             mov     [bx+CURRENT_ACTION_SUPPORT_TABLE], ax
273F:52FE  8B 44 06                             mov     ax, [si+HS_ROOM_NUM]
273F:5301  89 47 03                             mov     [bx+CURRENT_ACTION_ROOM_NUM], ax
273F:5304  C3                                   retn

                                ;
                                ;                              JUMP POINT
                                ;
                                ; This code is jumped to if the NPC is not in the room designated
                                ; by the room number in the current action record. It starts the
                                ; character walking to the exit to route them to the right room
                                ;

273F:5305                       loc_1078:                                       ;  xref 273F:510C
273F:5305  80 44 60 01                          add     byte ptr [si+HS_EXIT_CTR], 1
273F:5309  80 7C 60 05                          cmp     byte ptr [si+HS_EXIT_CTR], 5
273F:530D  73 AF                                jae     loc_1073                ; Jump if above or =
273F:530F  53                                   push    bx
273F:5310  8B 5F 03                             mov     bx,[bx+CURRENT_ACTION_ROOM_NUM]
273F:5313  E8 00C4                              call    room_exit_get_coordinates
273F:5316  81 7D 1B 03E9                        cmp     word ptr [di+ANIM_HOTSPOT_ID], RATPOUCH_HOTSPOT_ID
273F:531B  74 39                                je      loc_1081                ; Jump if equal

; The following loop counts up the number of characters in that room into dl
273F:531D  51                                   push    cx
273F:531E  52                                   push    dx
273F:531F BB B14E                              mov     bx, offset animation_table
273F:5322  B9 002D                              mov     cx, NUM_ANIMATION_SLOTS
273F:5325  33 D2                                xor     dx,dx                   ; Zero register
273F:5327                       locloop_1079:                                   ;  xref 273F:5346
273F:5327  39 47 0E                             cmp     [bx+ANIM_ROOM_NUM], ax
273F:532A  75 17                                jne     loc_1080                ; Jump if not equal
273F:532C  F6 47 0C FF                          test    byte ptr [bx+ANIM_LAYER], 0FFh
273F:5330  74 11                                jz      loc_1080                ; Jump if zero
273F:5332  81 7F 1B 03E8                        cmp     word ptr [bx+ANIM_HOTSPOT_ID], PLAYER_HOTSPOT_ID
273F:5337  72 0A                                jb      loc_1080                ; Jump if below
273F:5339  81 7F 1B 0408                        cmp     word ptr [bx+ANIM_HOTSPOT_ID], FIRST_OBJECT_HOTSPOT_ID
273F:533E  73 03                                jae     loc_1080                ; Jump if above or =
273F:5340  80 C2 01                             add     dl,1
273F:5343                       loc_1080:
273F:5343  83 C3 29                             add     bx, ANIMATION_SLOT_SIZE
273F:5346  E2 DF                                loop    locloop_1079            ; Loop if cx > 0
273F:5348  8A C2                                mov     al,dl
273F:534A  5A                                   pop     dx
273F:534B  59                                   pop     cx

273F:534C  3C 04                                cmp     al,4                    ; 4 or more chars in room?
273F:534E  72 06                                jb      loc_1081                ; Jump if not
273F:5350  5B                                   pop     bx
273F:5351  33 C0                                xor     ax,ax                   ; Set action to index #0 in list
273F:5353  E9 F1D2                              jmp     set_new_dispatch_action

273F:5356                       loc_1081:
273F:5356  5B                                   pop     bx
273F:5357  8A C6                                mov     al,dh
273F:5359  80 E6 0F                             and     dh,0Fh
273F:535C  89 4C 54                             mov     [si+HS_DEST_X],cx
273F:535F  89 54 56                             mov     [si+HS_DEST_Y],dx
273F:5362  C7 44 52 FFFF                        mov     [si+HS_DEST_HOTSPOT], 0FFFFh
273F:5367  53                                   push    bx

273F:5368 BB 2E57                              mov     bx, offset room_exit_hotspots
273F:536B  24 F0                                and     al, 0F0h
273F:536D  8B 54 06                             mov     dx, [si+HS_ROOM_NUM]
273F:5370                       loc_1082:                                       ;  xref 273F:5381
273F:5370 F6 07 FF                             test    byte ptr [bx], 0FFh
273F:5373  74 5C                                jz      loc_1085                ; Jump if zero
273F:5375  3A 17                                cmp     dl, [bx]
273F:5377  75 05                                jne     loc_1083                ; Jump if not equal
273F:5379  3A 47 01                             cmp     al, [bx+1]
273F:537C  74 05                                je      loc_1084                ; Jump if equal
273F:537E                       loc_1083:                                       ;  xref 273F:5377
273F:537E  83 C3 04                             add     bx, 4
273F:5381  EB ED                                jmp     short loc_1082          ; (5370)
273F:5383                       loc_1084:
273F:5383  8B 47 02                             mov     ax, [bx+2]              ; Found an entry, set it
273F:5386  89 44 52                             mov     [si+HS_DEST_HOTSPOT], ax ; into the dest hotspot Id
273F:5389  50                                   push    ax
273F:538A  56                                   push    si
273F:538B  E8 1E60                              call    room_exit_hs_get_pointer
273F:538E  5B                                   pop     bx
273F:538F  87 DE                                xchg    bx,si
273F:5391  58                                   pop     ax
273F:5392  F6 47 0C FF                          test    byte ptr [bx+REHS_EXIT_BLOCKED], 0FFh ; Exit blocked?
273F:5396  74 39                                jz      loc_1085                ; Jump if not blocked

; Code reaches this point if the needed exit is blocked
273F:5398  50                                   push    ax                      ; Save dest hotspot Id
273F:5399  8B 45 1B                             mov     ax, [di+ANIM_HOTSPOT_ID]; Calc offset into support
273F:539C  BB 0006                              mov     bx, 6                   ;   data set starting at 0bb95h
273F:539F  2D 03E9                              sub     ax, RATPOUCH_HOTSPOT_ID
273F:53A2  F7 E3                                mul     bx
273F:53A4 BB BB95                              mov     bx, offset support_data_rec_bb95
273F:53A7  03 D8                                add     bx, ax
273F:53A9  58                                   pop     ax                      ; Restore dest hotspot Id
273F:53AA  89 47 02                             mov     [bx+2], ax              ; Store id into record as param #1
273F:53AD  C6 44 4D 00                          mov     byte ptr [si+HS_V4D], 0
273F:53B1  83 44 61 05                          add     word ptr [si+HS_ACTION_OFFSET], CURRENT_ACTION_RECORD_SIZE
273F:53B5  8B C3                                mov     ax, bx
273F:53B7  5B                                   pop     bx
273F:53B8  8B DE                                mov     bx, si
273F:53BA  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:53BD  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:53C0  89 47 01                             mov     [bx+CURRENT_ACTION_SUPPORT_TABLE], ax
273F:53C3  C6 07 02                             mov     byte ptr [bx], CHAR_ACTION_DISPATCH_ACTION
273F:53C6  8B 44 06                             mov     ax, [si+HS_ROOM_NUM]
273F:53C9  89 47 03                             mov     [bx+CURRENT_ACTION_ROOM_NUM], ax
273F:53CC  C6 44 2A 00                          mov     byte ptr [si+HS_ACTION_CTR], 0
273F:53D0  C3                                   retn

; Exit has no hotspot, or has one that's not not blocked, so it's safe to simply start walking to it
273F:53D1                       loc_1085:
273F:53D1  5B                                   pop     bx
273F:53D2  C6 07 01                             mov     byte ptr [bx], CHAR_ACTION_START_WALK
273F:53D5  C6 45 27 01                          mov     byte ptr [di+ANIM_UNKNOWN1], 1
273F:53D9  C3                                   retn

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:13B8, 5313
                                ;

                   room_exit_get_coordinates    proc    near
273F:53DA  48                                   dec     ax
273F:53DB  B9 0058                              mov     cx,58h
273F:53DE  F7 E1                                mul     cx                      ; dx:ax = reg * ax
273F:53E0  05 1929                              add     ax, offset exit_coord_list
273F:53E3  03 D8                                add     bx, ax                  ; Move offset for indexing
273F:53E5  8A 5F 23                             mov     bl, [bx+23h]
273F:53E8  32 FF                                xor     bh, bh                  ; Zero register
273F:53EA  03 D8                                add     bx, ax
273F:53EC  8B 0F                                mov     cx, [bx]
273F:53EE  8B 57 02                             mov     dx, [bx+2]
273F:53F1  8B 47 04                             mov     ax, [bx+4]
273F:53F4  C3                                   retn
                   room_exit_get_coordinates    endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ; bp = Address of offset 2 in the Support data for the DISPATCH_ACTION
                                ; character action that launched this action
                                ;

                                 get_proc       proc    near
273F:53F5  8B DD                                mov     bx, bp
273F:53F7  8B 07                                mov     ax, [bx]                ; Get hotspot Id
273F:53F9  83 C5 02                             add     bp,2
273F:53FC  A3 BA19                              mov     use_hotspot_id, ax
273F:53FF  A3 BA1B                              mov     active_hotspot_id, ax
273F:5402  E8 F1A2                              call    hotspot_action_precheck
273F:5405  0B C0                                or      ax,ax                   ; Zero ?
273F:5407  74 08                                jz      loc_1086                ; Jump if zero
273F:5409  3D 0003                              cmp     ax,3
273F:540C  74 4E                                je      loc_ret_1090            ; Jump if equal
273F:540E  E9 0170                              jmp     character_walking_end
273F:5411                       loc_1086:                                       ;  xref 273F:5407
273F:5411  E8 F2DA                              call    character_face_hotspot
273F:5414  53                                   push    bx
273F:5415  E8 0169                              call    character_walking_end
273F:5418  5B                                   pop     bx
273F:5419  E8 01DA                              call    hotspot_get_action_sequence
273F:541C  79 03                                jns     loc_1087                ; Jump if not sign
273F:541E  E9 0F90                              jmp     display_message_dialog_3
273F:5421                       loc_1087:                                       ;  xref 273F:541C
273F:5421  74 0D                                jz      loc_1088                ; Jump if zero
273F:5423  E8 EA0E                              call    sequence_execute
273F:5426  74 08                                jz      loc_1088                ; Jump if zero
273F:5428  3D 0001                              cmp     ax,1
273F:542B  74 2F                                je      loc_ret_1090            ; Jump if equal
273F:542D  E9 0F81                              jmp     display_message_dialog_3
273F:5430                       loc_1088:
273F:5430  8B 45 1B                             mov     ax,[di+ANIM_HOTSPOT_ID] ; Move item into char's inventory
273F:5433  89 47 06                             mov     [bx+HS_ROOM_NUM], ax
273F:5436  E8 0920                              call    player_inc_inventory_items
273F:5439  81 3E BA19 7530                      cmp     use_hotspot_id, 7530h
273F:543F  73 1B                                jae     loc_ret_1090            ; Jump if above or =
273F:5441  56                                   push    si
273F:5442  57                                   push    di
273F:5443  8B F3                                mov     si,bx
273F:5445  8B 7C 0B                             mov     di,[si+HS_ANIM_OFFSET]
273F:5448  0B FF                                or      di,di                   ; Zero ?
273F:544A  74 03                                jz      loc_1089                ; Jump if zero
273F:544C  E8 BE23                              call    animation_unload
273F:544F                       loc_1089:                                       ;  xref 273F:544A
273F:544F  A1 BA19                              mov     ax, use_hotspot_id    ; Get hotspot header
273F:5452  E8 B8CC                              call    get_room_resource_pointer3
273F:5455  C7 44 06 0000                        mov     word ptr [si+HSH_DESC_2], 0 ; Remove first description
273F:545A  5F                                   pop     di
273F:545B  5E                                   pop     si

273F:545C                       loc_ret_1090:                                   ;  xref 273F:540C, 542B, 543F, 5487
273F:545C  C3                                   retn
                                 get_proc       endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                          npc_walking_check     proc    near
273F:545D  8B DD                                mov     bx, bp
273F:545F  8B 07                                mov     ax, [bx]                ; Get hotspot Id
273F:5461  83 C5 02                             add     bp, 2
273F:5464  8B DE                                mov     bx, si
273F:5466  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:5469  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:546C  89 6F 01                             mov     [bx+CURRENT_ACTION_SUPPORT_TABLE], bp
273F:546F  A3 BA19                              mov     use_hotspot_id, ax
273F:5472  A3 BA1B                              mov     active_hotspot_id, ax
273F:5475  3D 03E8                              cmp     ax, PLAYER_HOTSPOT_ID
273F:5478  72 0F                                jb      character_walking_check
273F:547A  56                                   push    si
273F:547B  E8 B86C                              call    get_room_resource_pointer2
273F:547E  5B                                   pop     bx
273F:547F  87 DE                                xchg    bx, si
273F:5481  8B 44 06                             mov     ax, [si+HS_ROOM_NUM]    ; Make sure hotspot
273F:5484  3B 47 06                             cmp     ax, [bx+HS_ROOM_NUM]    ;   is in char's room
273F:5487  75 D3                                jne     loc_ret_1090            

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:45F1
                                ;

                    character_walking_check     proc    near
273F:5489  57                                   push    di
273F:548A BF BC4B                              mov     di, offset hotspot_walkto_list
273F:548D  A1 BA1B                              mov     ax, active_hotspot_id
273F:5490                       loc_1092:                                       ;  xref 273F:549D
273F:5490 F7 05 FFFF                           test    word ptr [di+WALKTO_HOTSPOT_ID], 0FFFFh ; End of list reached?
273F:5494  74 4F                                jz      loc_1094                ; Jump if yes
273F:5496  3B 05                                cmp     ax, [diWALKTO_HOTSPOT_ID] ; Found entry for active hotspot?
273F:5498  74 05                                je      loc_1093                ; Jump if yes
273F:549A  83 C7 06                             add     di, 6                   ; Move to next record
273F:549D  EB F1                                jmp     short loc_1092
273F:549F                       loc_1093:
273F:549F  8B 4D 02                             mov     cx, [di+WALKTO_X]
273F:54A2  8B 55 04                             mov     dx, [di+WALKTO_Y]
273F:54A5  B0 01                                mov     al, 1
273F:54A7  F6 C6 80                             test    dh, 80h
273F:54AA  74 47                                jz      loc_1095                ; Jump if zero
273F:54AC  5F                                   pop     di
273F:54AD  88 45 27                             mov     [di+ANIM_UNKNOWN1], al
273F:54B0  80 E6 7F                             and     dh, 7Fh
273F:54B3  8B 44 0D                             mov     ax, [si+HS_X]
273F:54B6  D1 E8                                shr     ax, 1
273F:54B8  D1 E8                                shr     ax, 1
273F:54BA  D1 E8                                shr     ax, 1                   ; ax = player X / 8
273F:54BC  51                                   push    cx
273F:54BD  D1 E9                                shr     cx, 1
273F:54BF  D1 E9                                shr     cx, 1
273F:54C1  D1 E9                                shr     cx, 1                   ; cx = list[2] / 8
273F:54C3  2B C1                                sub     ax, cx                  ; ax -= cx
273F:54C5  59                                   pop     cx
273F:54C6  75 51                                jnz     character_start_walking ; If NZ, jump to start walking
273F:54C8  8B 44 0F                             mov     ax, [si+HS_Y]
273F:54CB  03 44 1B                             add     ax, [si+HS_HEIGHT_COPY]
273F:54CE  D1 E8                                shr     ax, 1
273F:54D0  D1 E8                                shr     ax, 1
273F:54D2  D1 E8                                shr     ax, 1
273F:54D4  2D 0001                              sub     ax, 1                   ; ax = (HS+height)/8 - 1
273F:54D7  52                                   push    dx
273F:54D8  D1 EA                                shr     dx, 1
273F:54DA  D1 EA                                shr     dx, 1
273F:54DC  D1 EA                                shr     dx, 1
273F:54DE  2B C2                                sub     ax, dx                  ; ax -= dx
273F:54E0  5A                                   pop     dx
273F:54E1  75 36                                jnz     character_start_walking ; If NZ, jump to start walking
273F:54E3  EB 65                                jmp     short loc_1100

273F:54E5                       loc_1094:                                       ;  xref 273F:5494
273F:54E5  8B 4F 0D                             mov     cx, [bx+HS_X]
273F:54E8  8B 57 0F                             mov     dx, [bx+HS_Y]
273F:54EB  03 57 1B                             add     dx, [bx+HS_HEIGHT_COPY]
273F:54EE  83 EA 04                             sub     dx, 4
273F:54F1  B0 00                                mov     al, 0
273F:54F3                       loc_1095:                                       ;  xref 273F:54AA
273F:54F3  5F                                   pop     di
273F:54F4  88 45 27                             mov     [di+ANIM_UNKNOWN1], al
273F:54F7  8B 44 0D                             mov     ax, [si+HS_X]
273F:54FA  2B C1                                sub     ax, cx
273F:54FC  73 02                                jnc     loc_1096                ; Jump if carry=0
273F:54FE  F7 D8                                neg     ax
273F:5500                       loc_1096:                                       ;  xref 273F:54FC
273F:5500  3D 0008                              cmp     ax, 8
273F:5503  73 14                                jae     character_start_walking ; If NZ, jump to start walking
273F:5505  8B 44 0F                             mov     ax, [si+HS_Y]
273F:5508  03 44 1B                             add     ax, [si+HS_HEIGHT_COPY]
273F:550B  2D 0001                              sub     ax, 1
273F:550E  2B C2                                sub     ax, dx
273F:5510  73 02                                jnc     loc_1097                ; Jump if carry=0
273F:5512  F7 D8                                neg     ax
273F:5514                       loc_1097:                                       ;  xref 273F:5510
273F:5514  3D 0013                              cmp     ax, 13h
273F:5517  72 31                                jb      loc_1100                ; Jump if below

                                ; External Entry into Subroutine 
                                ;
                                ;         Called from:   273F:8541

                    character_start_walking     proc    near
273F:5519  81 FE 6CEF                           cmp     si, offset player_hotspot_rec
273F:551D  75 17                                jne     loc_1099                ; Jump if not equal
273F:551F  C7 06 11E1 0002                      mov     cursor_index, CURSOR_TIME_UP
273F:5525  C6 06 11DF 00                        mov     cursor_centroid, 0
273F:552A  56                                   push    si
273F:552B  57                                   push    di
273F:552C  51                                   push    cx
273F:552D  52                                   push    dx
273F:552E  FF 16 075E                           call    [show_cursor_proc]
273F:5532  5A                                   pop     dx
273F:5533  59                                   pop     cx
273F:5534  5F                                   pop     di
273F:5535  5E                                   pop     si
273F:5536                       loc_1099:                                       ;  xref 273F:551D
273F:5536  8B DE                                mov     bx,si
273F:5538  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:553B  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:553E  C6 07 01                             mov     byte ptr [bx], CHAR_ACTION_START_WALK
273F:5541  89 54 56                             mov     [si+HS_DEST_Y], dx
273F:5544  89 4C 54                             mov     [si+HS_DEST_X], cx
273F:5547  33 C0                                xor     ax, ax
273F:5549  C3                                   retn
273F:554A                       loc_1100:                                       ;  xref 273F:54E3, 5517
273F:554A  0D 0001                              or      ax,1
273F:554D  C3                                   retn
                    character_start_walking     endp
                    character_walking_check     endp
                          npc_walking_check     endp
                          
                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

         npc_set_support_offset_conditional     proc    near
273F:554E  8B DD                                mov     bx, bp
273F:5550  8B 07                                mov     ax, [bx]                ; Get sequence offset
273F:5552  E8 DF E8                             call    sequence_execute        ; Execute it
273F:5555  74 11                                jz      loca_5568               ; Skip if zero return
273F:5557  8B 47 02                             mov     ax, [bx+2]              ; Get new action offset
273F:555A                       loc_1101:
273F:555A 8B DE                                mov     bx, si
273F:555C  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:555F  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:5562  89 47 01                             mov     [bx+CURRENT_ACTION_SUPPORT_TABLE], ax  ; Set it action rec
273F:5565  E9 EC56                              jmp     action_dispatch
                               loca_5568:
273F:5568  8B C5                                mov     ax, bp
273F:556A  05 0004                              add     ax, 4
273F:556D  EB EB                                jmp     short loc_1101          ; (555A)
         npc_set_support_offset_conditional     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                     npc_set_support_offset     proc    near
273F:556F  8B DD                                mov     bx,bp
273F:5571  8B 07                                mov     ax, [bx]
273F:5573  8B DE                                mov     bx, si
273F:5575  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:5578  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:557B  89 47 01                             mov     [bx+CURRENT_ACTION_SUPPORT_TABLE], ax
273F:557E  E9 EC3D                              jmp     action_dispatch
                     npc_set_support_offset     endp                                

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:478E, 5415, 5723, 57BE, 58CC, 591C, 5954
                                ;                             5968, 5ACE, 5B47, 5BA6, 5C15, 5C7A, 5D32
                                ;

                       character_walking_end    proc    near
273F:5581 81 7D 1B 03E8                        cmp     word ptr [di+ANIM_HOTSPOT_ID], PLAYER_HOTSPOT_ID
273F:5586  75 05                                jne     character_walking_end_2
273F:5588  80 26 9834 02                        and     cursor_state, 2

                                ; External Entry into Subroutine 
                                ;

                     character_walking_end_2:
273F:558D 33 C0                                xor     ax, ax
273F:558F  89 45 24                             mov     [di+ANIM_VOICE_CTR], ax
273F:5592  88 44 2A                             mov     [si+HS_ACTION_CTR], al
273F:5595  8B DE                                mov     bx, si
273F:5597  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:559A  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:559D  89 6F 01                             mov     [bx+CURRENT_ACTION_SUPPORT_TABLE], bp
273F:55A0  C3                                   retn
                       character_walking_end    endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:44C7, 509D, 7F5D
                                ;

                  characters_impinging_check    proc    near
273F:55A1  8B 47 0D                             mov     ax, [bx+HS_X]
273F:55A4  03 47 19                             add     ax, [bx+HS_WIDTH_COPY]
273F:55A7  05 0004                              add     ax, 4
273F:55AA  3B 44 0D                             cmp     ax, [si+HS_X]
273F:55AD  72 44                                jb      loc_1104                ; Jump if below
273F:55AF  8B 44 0D                             mov     ax, [si+HS_X]
273F:55B2  03 44 19                             add     ax, [si+HS_WIDTH_COPY]
273F:55B5  05 0004                              add     ax, 4
273F:55B8  3B 47 0D                             cmp     ax, [bx+HS_X]
273F:55BB  72 36                                jb      loc_1104                ; Jump if below

273F:55BD  8B 44 0F                             mov     ax, [si+HS_Y]
273F:55C0  03 44 1B                             add     ax, [si+HS_HEIGHT_COPY]
273F:55C3  2B 44 1D                             sub     ax, [si+HS_Y_CORRECTION]
273F:55C6  2D 0002                              sub     ax, 2
273F:55C9  8B 4F 0F                             mov     cx, [bx+HS_Y]
273F:55CC  03 4F 1B                             add     cx, [bx+HS_HEIGHT_COPY]
273F:55CF  83 C1 02                             add     cx, 2
273F:55D2  3B C1                                cmp     ax, cx
273F:55D4  73 1D                                jae     loc_1104                ; Jump if above or =
273F:55D6  8B 44 0F                             mov     ax, [si+HS_Y]
273F:55D9  03 44 1B                             add     ax, [si+HS_HEIGHT_COPY]
273F:55DC  05 0002                              add     ax, 2
273F:55DF  8B 4F 0F                             mov     cx, [bx+HS_Y]
273F:55E2  03 4F 1B                             add     cx, [bx+HS_HEIGHT_COPY]
273F:55E5  2B 4F 1D                             sub     cx, [bx+HS_Y_CORRECTION]
273F:55E8  83 E9 02                             sub     cx, 2
273F:55EB  3B C1                                cmp     ax, cx
273F:55ED  72 04                                jb      loc_1104                ; Jump if below
273F:55EF  0D 0001                              or      ax,1
273F:55F2  C3                                   retn
273F:55F3                       loc_1104:                                       ;  xref 273F:55AD, 55BB, 55D4, 55ED
273F:55F3  33 C0                                xor     ax,ax                   ; Zero register
273F:55F5  C3                                   retn
                  characters_impinging_check    endp


                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:5419, 572E, 57C9, 5830, 58D0, 5923, 595B
                                ;                             5AE2, 5B4B, 5BC5, 5C19, 5C82, 5CD0, 5D36
                                ;                             8A03
                                ;

                hotspot_get_action_sequence     proc    near
273F:55F6  53                                   push    bx
273F:55F7  8B 5F 04                             mov     bx, [bx+HS_ACTIONS_OFFSET]
273F:55FA  0B DB                                or      bx, bx                  ; Hotspot have actions?
273F:55FC  74 1C                                jz      loc_1107                ; Jump if not

273F:55FE  8B 0F                                mov     cx,[bx]                 ; Get # entries
273F:5600  83 C3 02                             add     bx,2                    ; Move to first entry
273F:5603  A1 BB45                              mov     ax, current_action_num  ; Get action number
273F:5606  0B C9                                or      cx,cx                   ; List have any items?
273F:5608  74 10                                jz      loc_1107                ; Jump if not

273F:560A                       locloop_1105:
273F:560A  3A 07                                cmp     al, [bx]                ; Get action number
273F:560C  75 07                                jne     loc_1106                ; Skip if not wanted action
273F:560E  8B 47 01                             mov     ax, [bx+1]              ; Get sequence offset
273F:5611  5B                                   pop     bx
273F:5612  0B C0                                or      ax, ax                  ; Zero ?
273F:5614  C3                                   retn
273F:5615                       loc_1106:                                       ;  xref 273F:560C
273F:5615  83 C3 03                             add     bx,3
273F:5618  E2 F0                                loop    locloop_1105            ; Loop if cx > 0

273F:561A                       loc_1107:                                       ;  xref 273F:55FC, 5608
273F:561A  5B                                   pop     bx
273F:561B  33 C0                                xor     ax, ax                  ; Zero register
273F:561D  C3                                   retn
                hotspot_get_action_sequence     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                npc_set_blocked_offset_proc     proc    near
273F:561E  8B DD                                mov     bx, bp
273F:5620  8B 07                                mov     ax, [bx]
273F:5622  8B 4F 02                             mov     cx, [bx+2]
273F:5625  83 C5 04                             add     bp, 4
273F:5628  89 4C 5E                             mov     [si+HS_BLOCKED_SUPPORT_OFFSET], cx
273F:562B  C6 44 60 00                          mov     byte ptr [si+HS_EXIT_CTR], 0
273F:562F  8B DE                                mov     bx, si
273F:5631  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:5634  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:5637  89 47 03                             mov     [bx+CURRENT_ACTION_ROOM_NUM], ax
273F:563A  E9 FF44                              jmp     character_walking_end
                npc_set_blocked_offset_proc     endp
                             
                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                                go_to_proc      proc    near
273F:563D  8B DD                                mov     bx,bp
273F:563F  8B 07                                mov     ax,[bx]
273F:5641  83 C5 02                             add     bp,2
273F:5644  C7 44 5E 0000                        mov     word ptr [si+HS_BLOCKED_SUPPORT_OFFSET], 0
273F:5649  C6 44 60 00                          mov     byte ptr [si+HS_EXIT_CTR], 0
273F:564D  8B DE                                mov     bx,si
273F:564F  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:5652  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:5655  89 47 03                             mov     [bx+CURRENT_ACTION_ROOM_NUM], ax
273F:5658  E9 FF26                              jmp     character_walking_end
                                go_to_proc      endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                        npc_set_random_dest     proc    near
273F:565B  8B DE                                mov     bx, si
273F:565D  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:5660  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:5663  89 6F 01                             mov     [bx+CURRENT_ACTION_SUPPORT_TABLE], bp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:606B
                                ;

                  character_set_random_dest     proc    near
273F:5666 C6 07 01                             mov     byte ptr [bx], CHAR_ACTION_START_WALK
273F:5669  C6 45 27 01                          mov     byte ptr [di+ANIM_UNKNOWN1], 1
273F:566D  56                                   push    si
273F:566E  56                                   push    si
273F:566F  8B 44 06                             mov     ax, [si+HS_ROOM_NUM]    ; Get char's room rsc
273F:5672  E8 B675                              call    get_room_resource_pointer2
273F:5675  8A 5C 18                             mov     bl, [si+ROOM_BOUNDS_INDEX]
273F:5678  32 FF                                xor     bh, bh
273F:567A  B1 03                                mov     cl, 3
273F:567C  D3 E3                                shl     bx, cl
273F:567E  81 C3 2EB1                           add     bx, offset room_bounds_table
273F:5682  B9 0014                              mov     cx, 20                  ; # attempts
273F:5685  5E                                   pop     si

273F:5686                       locloop_1109:                                   ;  xref 273F:56C3
273F:5686  51                                   push    cx

; Chooses a random destination for the character within the given rectangle
273F:5687  E8 EDE2                              call    random                  ; Get random value
273F:568A  8B 4F 02                             mov     cx, [bx+2]
273F:568D  2B 0F                                sub     cx, [bx]
273F:568F  F7 E1                                mul     cx                      ; dx:ax = reg * ax
273F:5691  03 17                                add     dx,[bx]
273F:5693  89 54 54                             mov     [si+HS_DEST_X],dx
273F:5696  52                                   push    dx
273F:5697  E8 EDD2                              call    random
273F:569A  8B 4F 06                             mov     cx, [bx+6]
273F:569D  2B 4F 04                             sub     cx, [bx+4]
273F:56A0  F7 E1                                mul     cx                      ; dx:ax = reg * ax
273F:56A2  03 57 04                             add     dx, [bx+4]
273F:56A5  89 54 56                             mov     [si+HS_DEST_Y], dx
273F:56A8  8B C2                                mov     ax, dx
273F:56AA  5A                                   pop     dx
273F:56AB  B9 0003                              mov     cx,3
273F:56AE  E8 001D                              call    character_check_dest_occupied
273F:56B1  0B C0                                or      ax, ax                  ; Occupied?
273F:56B3  75 0D                                jnz     loc_1110                ; Jump if yes
273F:56B5  05 0008                              add     ax, 8
273F:56B8  B9 0003                              mov     cx, 3
273F:56BB  E8 0010                              call    character_check_dest_occupied
273F:56BE  0B C0                                or      ax, ax                  ; Occupied
273F:56C0  74 07                                jz      loc_1111                ; Jump if not
273F:56C2                       loc_1110:
273F:56C2  59                                   pop     cx                      ; Loop to choose another
273F:56C3  E2 C1                                loop    locloop_1109            ;   random destination

273F:56C5  5B                                   pop     bx
273F:56C6  87 DE                                xchg    bx,si
273F:56C8  C3                                   retn
273F:56C9                       loc_1111:                                       ;  xref 273F:56C0
273F:56C9  59                                   pop     cx
273F:56CA  5B                                   pop     bx
273F:56CB  87 DE                                xchg    bx,si
273F:56CD  C3                                   retn
                  character_set_random_dest     endp
                        npc_set_random_dest     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:56AE, 56BB
                                ;

              character_check_dest_occupied     proc    near
273F:56CE  53                                   push    bx
273F:56CF  51                                   push    cx
273F:56D0  E8 ECC1                              call    pathfind_get_cell
273F:56D3  59                                   pop     cx

273F:56D4                       locloop_1112:                                   ;  xref 273F:56E1
273F:56D4  85 07                                test    ax,[bx]                 ; Is the dest occupied?
273F:56D6  75 0F                                jnz     loc_1114                ; Jump if yes
273F:56D8  D0 E8                                shr     al,1                    ; Shift w/zeros fill
273F:56DA  73 05                                jnc     loc_1113                ; Jump if carry=0
273F:56DC  83 C3 01                             add     bx,1
273F:56DF  B0 80                                mov     al,80h
273F:56E1                       loc_1113:                                       ;  xref 273F:56DA
273F:56E1  E2 F1                                loop    locloop_1112            ; Loop if cx > 0

273F:56E3  5B                                   pop     bx
273F:56E4  33 C0                                xor     ax,ax                   ; Zero register
273F:56E6  C3                                   retn
273F:56E7                       loc_1114:                                       ;  xref 273F:56D6
273F:56E7  5B                                   pop     bx
273F:56E8  B0 01                                mov     al,1
273F:56EA  C3                                   retn
              character_check_dest_occupied     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                                 open_proc      proc    near
273F:56EB  8B DD                                mov     bx,bp
273F:56ED  8B 07                                mov     ax,[bx]
273F:56EF  83 C5 02                             add     bp,2
273F:56F2  A3 BA19                              mov     use_hotspot_id, ax
273F:56F5  A3 BA1B                              mov     active_hotspot_id, ax
273F:56F8  56                                   push    si
273F:56F9 BE 4CB0                              mov     si, offset exit_hotspots_list
273F:56FC  E8 EE94                              call    is_roomexit_hotspot
273F:56FF  75 0E                                jnz     loc_1115                ; Not a valid door
273F:5701  53                                   push    bx
273F:5702  A1 BA19                              mov     ax, use_hotspot_id
273F:5705  E8 1AE6                              call    room_exit_hs_get_pointer
273F:5708  5B                                   pop     bx
273F:5709  F6 44 0C FF                          test    byte ptr [si+REHS_EXIT_BLOCKED], 0FFh
273F:570D  74 58                                jz      loc_1120                ; Jump if exit blocked (closed)
273F:570F                       loc_1115:
273F:570F  5E                                   pop     si
273F:5710  A1 BA19                              mov     ax, use_hotspot_id
273F:5713  E8 EE91                              call    hotspot_action_precheck
273F:5716  0B C0                                or      ax, ax                  ; Execute?
273F:5718  74 08                                jz      loc_1116                ; Jump if yes
273F:571A  3D 0003                              cmp     ax, 3                   ; Initial?
273F:571D  74 47                                je      loc_ret_1119            ; Exit if not
273F:571F  E9 FE5F                              jmp     character_walking_end
273F:5722                       loc_1116:                                       ;  xref 273F:5718
273F:5722  53                                   push    bx
273F:5723  E8 FE5B                              call    character_walking_end
273F:5726  5B                                   pop     bx
273F:5727  C6 44 2A 00                          mov     byte ptr [si+HS_ACTION_CTR], 0
273F:572B  E8 EFC0                              call    character_face_hotspot
273F:572E  E8 FEC5                              call    hotspot_get_action_sequence
273F:5731  79 03                                jns     loc_1117                ; Jump if not sign
273F:5733  E9 0C7B                              jmp     display_message_dialog_3
273F:5736                       loc_1117:                                       ;  xref 273F:5731
273F:5736  74 0A                                jz      loc_1118                ; Jump if zero
273F:5738  E8 E6F9                              call    sequence_execute
273F:573B  3D 0001                              cmp     ax,1
273F:573E  74 26                                je      loc_ret_1119            ; Jump if equal
273F:5740  73 2F                                jnc     loc_1121                ; Jump if carry=0
273F:5742                       loc_1118:                                       ;  xref 273F:5736
273F:5742  A1 BA19                              mov     ax, use_hotspot_id
273F:5745  56                                   push    si
273F:5746  E8 1AA5                              call    room_exit_hs_get_pointer
273F:5749  5B                                   pop     bx
273F:574A  87 F3                                xchg    si,bx
273F:574C  F6 47 0C FF                          test    byte ptr [bx+REHS_EXIT_BLOCKED], 0FFh
273F:5750  74 14                                jz      loc_ret_1119            ; Jump if zero
273F:5752  C6 47 0C 00                          mov     byte ptr [bx+REHS_EXIT_BLOCKED], 0
273F:5756  81 7D 1B 03E8                        cmp     word ptr [di+ANIM_HOTSPOT_ID], PLAYER_HOTSPOT_ID
273F:575B  74 09                                je      loc_ret_1119            ; Jump if equal
273F:575D  C6 44 44 03                          mov     byte ptr [si+HS_CHAR_MODE], CHARMODE_3
273F:5761  C7 44 42 0004                        mov     word ptr [si+HS_DELAY_CTR], 4

273F:5766                       loc_ret_1119:                                   ;  xref 273F:571D, 573E, 5750, 575B
273F:5766  C3                                   retn
273F:5767                       loc_1120:                                       ;  xref 273F:570D
273F:5767  5E                                   pop     si
273F:5768  B8 0004                              mov     ax,4
273F:576B  E8 0C43                              call    display_message_dialog_3
273F:576E  E9 FE10                              jmp     character_walking_end
273F:5771                       loc_1121:                                       ;  xref 273F:5740
273F:5771  F6 44 60 FF                          test    byte ptr [si+HS_EXIT_CTR],0FFh
273F:5775  74 04                                jz      loc_1122                ; Jump if zero
273F:5777  C6 44 60 04                          mov     byte ptr [si+HS_EXIT_CTR], 4
273F:577B                       loc_1122:                                       ;  xref 273F:5775
273F:577B  E9 0C33                              jmp     display_message_dialog_3
                                 open_proc      endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                                close_proc      proc    near
273F:577E 8B DD                                 mov     bx, bp
273F:5780 8B07                                  mov     ax, [bx]
273F:5782 83C502                                add     bp, 2
273F:5785 A319BA                                mov     use_hotspot_id, ax
273F:5788 A31BBA                                mov     active_hotspot_id, ax
273F:578B 56                                    push    si
273F:578C BEB04C                                mov     si, offset exit_hotspots_list
273F:578F E801EE                                call    is_roomexit_hotspot
273F:5792 7516                                  jnz     close_proc_2
273F:5794 A119BA                                mov     ax, use_hotspot_id
273F:5797 E8541A                                call    room_exit_hs_get_pointer
273F:579A F6440CFF                              test    byte ptr [si+REHS_EXIT_BLOCKED], 0FFh
273F:579E 740A                                  jz      close_proc_2
273F:57A0 5E                                    pop     si
273F:57A1 B80300                                mov     ax, 3
273F:57A4 E80A0C                                call    display_message_dialog_3
273F:57A7 E9D7FD                                jmp     character_walking_end
273F:57AA A119BA            close_proc_2:       mov     ax, use_hotspot_id
273F:57AD 5E                                    pop     si
273F:57AE E8F6ED                                call    hotspot_action_precheck
273F:57B1 0BC0                                  or      ax, ax
273F:57B3 7408                                  jz      loc_1123
273F:57B5 3D0300                                cmp     ax, 3
273F:57B8 7448                                  jz      loc_ret_1127
273F:57BA E9C4FD                                jmp     character_walking_end
273F:57BD                       loc_1123:
273F:57BD  53                                   push    bx
273F:57BE  E8 FDC0                              call    character_walking_end
273F:57C1  5B                                   pop     bx
273F:57C2  C6 44 2A 00                          mov     byte ptr [si+HS_ACTION_CTR], 0
273F:57C6  E8 EF25                              call    character_face_hotspot
273F:57C9  E8 FE2A                              call    hotspot_get_action_sequence
273F:57CC  79 03                                jns     loc_1125                ; Jump if not sign
273F:57CE                       loc_1124:                                       ;  xref 273F:57D6
273F:57CE  E9 0BE0                              jmp     display_message_dialog_3
273F:57D1                       loc_1125:                                       ;  xref 273F:57CC
273F:57D1  74 05                                jz      loc_1126                ; Jump if zero
273F:57D3  E8 E65E                              call    sequence_execute
273F:57D6  75 F6                                jnz     loc_1124                ; Jump if not zero
273F:57D8                       loc_1126:                                       ;  xref 273F:57D1
273F:57D8  56                                   push    si
273F:57D9  A1 BA19                              mov     ax, use_hotspot_id
273F:57DC  E8 1A0F                              call    room_exit_hs_get_pointer 
273F:57DF  5B                                   pop     bx
273F:57E0  87 DE                                xchg    bx,si
273F:57E2  F6 47 0C FF                          test    byte ptr [bx+REHS_EXIT_BLOCKED], 0FFh
273F:57E6  75 1A                                jnz     loc_ret_1127            ; Jump if not zero
273F:57E8  8B EB                                mov     bp, bx

273F:57EA  8B 5F 0D                             mov     bx, [bx+REHS_HOTSPOT1_OFFSET]
273F:57ED  E8 1A7B                              call    door_close_check
273F:57F0  74 11                                jz      loc_1128                ; Jump if can't close
273F:57F2  8B DD                                mov     bx, bp
273F:57F4  8B 5F 0F                             mov     bx, [bx+REHS_HOTSPOT2_OFFSET]
273F:57F7  E8 1A71                              call    door_close_check
273F:57FA  74 07                                jz      loc_1128                ; Jump if can't close
273F:57FC  8B DD                                mov     bx,bp
273F:57FE  C6 47 0C 01                          mov     byte ptr [bx+REHS_EXIT_BLOCKED], 1

273F:5802                       loc_ret_1127:                                   ;  xref 273F:57E6, 581F
273F:5802  C3                                   retn
273F:5803                       loc_1128:                                       ;  xref 273F:57F0, 57FA
273F:5803  B8 0002                              mov     ax,2
273F:5806  E9 0BA8                              jmp     display_message_dialog_3

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                                 tell_proc      proc    near
273F:5809  8B DD                                mov     bx,bp
273F:580B  8B 07                                mov     ax,[bx]
273F:580D  83 C5 02                             add     bp,2
273F:5810  A3 BA19                              mov     use_hotspot_id, ax
273F:5813  A3 BA1B                              mov     active_hotspot_id, ax
273F:5816  E8 ED8E                              call    hotspot_action_precheck
273F:5819  0B C0                                or      ax,ax                   ; Zero ?
273F:581B  74 06                                jz      loc_1129                ; Jump if zero
273F:581D  3C 03                                cmp     al,3
273F:581F  74 E1                                je      loc_ret_1127            ; Jump if equal
273F:5821  EB 68                                jmp     short loc_1134          ; (588B)
273F:5823                       loc_1129:                                       ;  xref 273F:581B
273F:5823  8B 0E BA19                           mov     cx, use_hotspot_id
273F:5827  B8 0001                              mov     ax,1
273F:582A  BA 007C                              mov     dx,7Ch
273F:582D  E8 0922                              call    talk_converse_2
273F:5830  E8 FDC3                              call    hotspot_get_action_sequence
273F:5833  79 03                                jns     loc_1130                ; Jump if not sign
273F:5835  E9 0B79                              jmp     display_message_dialog_3
273F:5838                       loc_1130:                                       ;  xref 273F:5833
273F:5838  E8 E5F9                              call    sequence_execute
273F:583B  75 4E                                jnz     loc_1134                ; Jump if not zero
273F:583D  8B 44 06                             mov     ax, [si+HS_ROOM_NUM]
273F:5840  89 47 4E                             mov     [bx+HS_V4E],ax
273F:5843  C7 47 61 0005                        mov     word ptr [bx+HS_ACTION_OFFSET], CURRENT_ACTION_RECORD_SIZE
273F:5848  C6 47 4D 00                          mov     byte ptr [bx+4Dh],0
273F:584C  8B 4F 5C                             mov     cx,[bx+5Ch]
273F:584F  89 4F 69                             mov     [bx+69h],cx
273F:5852  8B 44 06                             mov     ax,[si+6]
273F:5855  89 47 6B                             mov     [bx+6Bh],ax
273F:5858  C6 47 68 02                          mov     byte ptr [bx+68h],2
273F:585C  56                                   push    si
273F:585D  57                                   push    di
273F:585E  8B F5                                mov     si,bp
273F:5860  8B F9                                mov     di,cx
273F:5862  1E                                   push    ds
273F:5863  07                                   pop     es
273F:5864                       loc_1131:                                       ;  xref 273F:5875, 587B
273F:5864 AD                                   lodsw                           ; String [si] to ax
273F:5865  8B D0                                mov     dx,ax
273F:5867                       loc_1132:                                       ;  xref 273F:5870
273F:5867  AB                                   stosw                           ; Store ax to es:[di]
273F:5868  0B C0                                or      ax,ax                   ; Zero ?
273F:586A  74 11                                jz      loc_1133                ; Jump if zero
273F:586C  AD                                   lodsw                           ; String [si] to ax
273F:586D  3D 7D00                              cmp     ax,7D00h
273F:5870  75 F5                                jne     loc_1132                ; Jump if not equal
273F:5872  83 FA 17                             cmp     dx,17h
273F:5875  75 ED                                jne     loc_1131                ; Jump if not equal
273F:5877  B8 0020                              mov     ax,20h
273F:587A  AB                                   stosw                           ; Store ax to es:[di]
273F:587B  EB E7                                jmp     short loc_1131          ; (5864)
273F:587D                       loc_1133:                                       ;  xref 273F:586A
273F:587D  26: C7 45 FE 0020                    mov     word ptr es:[di-2],20h
273F:5883  AB                                   stosw                           ; Store ax to es:[di]
273F:5884  8B EE                                mov     bp,si
273F:5886  83 ED 02                             sub     bp,2
273F:5889  5F                                   pop     di
273F:588A  5E                                   pop     si
273F:588B                       loc_1134:                                       ;  xref 273F:5821, 583B
273F:588B  8B DD                                mov     bx,bp
273F:588D  C7 07 0000                           mov     word ptr [bx],0
273F:5891  E9 FCF9                              jmp     character_walking_end_2
                                 tell_proc      endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ; xi=player hotspot, di=player anim slot, bp=??
                                ;

                         look_through_proc      proc    near
273F:5894  8B DD                                mov     bx,bp
273F:5896  8B 07                                mov     ax,[bx]
273F:5898  83 C5 02                             add     bp,2
273F:589B  A3 BA19                              mov     use_hotspot_id, ax
273F:589E  A3 BA1B                              mov     active_hotspot_id, ax
273F:58A1  56                                   push    si
273F:58A2  E8 B445                              call    get_room_resource_pointer2 ; Get hotspot ptr
273F:58A5  5B                                   pop     bx
273F:58A6  87 DE                                xchg    bx,si                   ; si=player, bx=hotspot
273F:58A8  8B 47 06                             mov     ax, [bx+HS_ROOM_NUM]
273F:58AB  3B 45 1B                             cmp     ax, [di+ANIM_HOTSPOT_ID] ; In player's inventory?
273F:58AE  74 1B                                je      loc_1136                ; If yes then jump
273F:58B0  E8 ED24                              call    hotspot_action_precheck_2
273F:58B3  0B C0                                or      ax, ax                  ; Zero ?
273F:58B5  74 08                                jz      loc_1135                ; Jump if zero
273F:58B7  3D 0003                              cmp     ax,3
273F:58BA  74 3E                                je      loc_ret_1139            ; Jump if equal
273F:58BC  E9 FCC2                              jmp     character_walking_end
273F:58BF                       loc_1135:                                       ;  xref 273F:58B5
273F:58BF  C6 44 2A 00                          mov     byte ptr [si+2Ah],0
273F:58C3  E8 EE28                              call    character_face_hotspot
273F:58C6  55                                   push    bp
273F:58C7  E8 EA9C                              call    character_update_movement
273F:58CA  5D                                   pop     bp
273F:58CB                       loc_1136:
273F:58CB  53                                   push    bx
273F:58CC  E8 FCB2                              call    character_walking_end
273F:58CF  5B                                   pop     bx
273F:58D0  E8 FD23                              call    hotspot_get_action_sequence
273F:58D3  79 03                                jns     loc_1137                ; Jump if not sign
273F:58D5  E9 0AD9                              jmp     display_message_dialog_3
273F:58D8                       loc_1137:                                       ;  xref 273F:58D3
273F:58D8  74 13                                jz      loc_ret_1138            ; Jump if zero
273F:58DA  E8 E557                              call    sequence_execute
273F:58DD  74 0E                                jz      loc_ret_1138            ; Jump if zero
273F:58DF  3D 002A                              cmp     ax,2Ah
273F:58E2  75 09                                jne     loc_ret_1138            ; Jump if not equal
273F:58E4  C7 44 42 0050                        mov     word ptr [si+HS_DELAY_CTR],  80
273F:58E9  C6 44 44 02                          mov     byte ptr [si+HS_CHAR_MODE], CHARMODE_IDLE

273F:58ED                       loc_ret_1138:                                   ;  xref 273F:58D8, 58DD, 58E2
273F:58ED  C3                                   retn
                         look_through_proc      endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ; Sets up things for remotely viewing a room - storing the room to
                                ; return to, and disabling the tick proc for the player
                                ;

                  seq_room_remote_view_setup    proc    near
                                                assume  ds:seg_code
273F:58EE  A1 9832                              mov     ax, room_number
273F:58F1  A3 BA25                              mov     old_room_number, ax
273F:58F4  C7 06 B15F 58FB                      mov     slot0_tick_proc, offset loc_ret_1140

273F:58FA                       loc_ret_1139:                                   ;  xref 273F:58BA
273F:58FA  C3                                   retn
                  seq_room_remote_view_setup    endp



273F:58FB                       loc_ret_1140:                                   ;  xref 273F:5913, 594E, 5963
273F:58FB  C3                                   retn

                                ;
                                ;                              SUBROUTINE
                                ;
                                ; xi=player hotspot, di=player anim slot, bp=??
                                ;

                              operate_proc      proc    near
273F:58FC  8B DD                                mov     bx,bp
273F:58FE  8B 07                                mov     ax,[bx]
273F:5900  83 C5 02                             add     bp,2
273F:5903  A3 BA19                              mov     use_hotspot_id, ax
273F:5906  A3 BA1B                              mov     active_hotspot_id, ax
273F:5909  E8 EC9B                              call    hotspot_action_precheck
273F:590C  0B C0                                or      ax,ax                   ; Zero ?
273F:590E  74 08                                jz      loc_1141                ; Jump if zero
273F:5910  3D 0003                              cmp     ax,3
273F:5913  74 E6                                je      loc_ret_1140            ; Jump if equal
273F:5915  E9 FC69                              jmp     character_walking_end
273F:5918                       loc_1141:                                       ;  xref 273F:590E
273F:5918  88 44 2A                             mov     [si+HS_ACTION_CTR], al
273F:591B  53                                   push    bx
273F:591C  E8 FC62                              call    character_walking_end
273F:591F  5B                                   pop     bx
273F:5920  E8 EDCB                              call    character_face_hotspot
273F:5923  E8 FCD0                              call    hotspot_get_action_sequence
273F:5926  79 03                                jns     loc_1142                ; Jump if not sign
273F:5928  E9 0A86                              jmp     display_message_dialog_3
273F:592B                       loc_1142:                                       ;  xref 273F:5926
273F:592B  E8 E506                              call    sequence_execute
273F:592E  3D 0002                              cmp     ax,2
273F:5931  72 03                                jb      loc_ret_1143            ; Jump if below
273F:5933  E9 0A7B                              jmp     display_message_dialog_3

273F:5936                       loc_ret_1143:                                   ;  xref 273F:5931
273F:5936  C3                                   retn
                              operate_proc      endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                           lock_unlock_proc     proc    near
273F:5937  8B DD                                mov     bx,bp
273F:5939  8B 07                                mov     ax,[bx]
273F:593B  83 C5 02                             add     bp,2
273F:593E  A3 BA19                              mov     use_hotspot_id, ax
273F:5941  A3 BA1B                              mov     active_hotspot_id, ax
273F:5944  E8 EC60                              call    hotspot_action_precheck
273F:5947  0B C0                                or      ax,ax                   ; Zero ?
273F:5949  74 08                                jz      loc_1144                ; Jump if zero
273F:594B  3D 0003                              cmp     ax,3
273F:594E  74 AB                                je      loc_ret_1140            ; Jump if equal
273F:5950  E9 FC2E                              jmp     character_walking_end
273F:5953                       loc_1144:                                       ;  xref 273F:5949
273F:5953  53                                   push    bx
273F:5954  E8 FC2A                              call    character_walking_end
273F:5957  5B                                   pop     bx
273F:5958  E8 ED93                              call    character_face_hotspot
273F:595B  E8 FC98                              call    hotspot_get_action_sequence
273F:595E  79 03                                jns     loc_1145                ; Jump if not sign
273F:5960  E9 0A4E                              jmp     display_message_dialog_3
273F:5963                       loc_1145:                                       ;  xref 273F:595E
273F:5963  74 96                                jz      loc_ret_1140            ; Jump if zero
273F:5965  E9 E4CC                              jmp     sequence_execute
                           lock_unlock_proc     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:56AE, 56BB
                                ;

                              look_proc         proc    near

273F:5968  E8 FC16                              call    character_walking_end
273F:596B  8B 44 06                             mov     ax, [si+6]
273F:596E  E8 B3B0                              call    get_room_resource_pointer4
273F:5971  8B 5C 04                             mov     bx, [si+RH_DESC_ID]
273F:5974  E9 2F45                              jmp     display_dialog

                              look_proc         endp
                             
273F:5977  00                     data_359      db      0

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                               status_proc      proc    near

31E4:5978  E8 06 FC                             call    character_walking_end
31E4:597B  80 0E 11D0 01                        or      menubar_state, 1
31E4:5980  FF 16 075E                           call    [show_cursor_proc]
31E4:5984  B0 09                                mov     al, 9
31E4:5986  B1 16                                mov     cl, 16
31E4:5988  B2 03                                mov     dl, 3
31E4:598A  F7 06 BC49 FFFF                      test    num_groats, 0ffffh
31E4:5990  74 03                                jz      status_loc_2
31E4:5992  80 C2 02                             add     dl, 2
                            status_loc_2:
31E4:5995  F6 06 9835 FF                        test    num_inventory_items, 0ffh
31E4:599A  74 07                                jz      loc_1146
31E4:599C  02 16 9835                           mov     dl, num_inventory_items
31E4:59A0  80 EA 01                             sub     dl, 1

273F:59A3                       loc_1146:
273F:59A3  B3 18                                mov     bl,18h
273F:59A5  2A DA                                sub     bl,dl
273F:59A7  D0 EB                                shr     bl,1                    ; Shift w/zeros fill
273F:59A9  2E: 88 1E 5977                       mov     cs:data_359,bl          ; (273F:5977=0)
273F:59AE  BD 0001                              mov     bp,1
273F:59B1  FF 16 077A                           call    [draw_dialog_proc]
273F:59B5  A1 9832                              mov     ax, room_number         ; Get the current room's
273F:59B8  E8 B366                              call    get_room_resource_pointer3 ; short name
273F:59BB  8B 44 02                             mov     ax,[si+2]
273F:59BE  BF 4B43                              mov     di, offset hotspot_name
273F:59C1  E8 2376                              call    decode_string
273F:59C4  2E: A0 5977                          mov     al, cs:data_359
273F:59C8  04 01                                add     al,1
273F:59CA  32 E4                                xor     ah,ah                   ; Zero register
273F:59CC BB 000A                              mov     bx, 10
273F:59CF BE 4B43                              mov     si, offset hotspot_name
273F:59D2  E8 C210                              call    sub_52

273F:59D5  C7 06 4B19 6F6E                      mov     data_789,6F6Eh          ; (31E4:4B19=6F6Eh)
273F:59DB  F6 06 9835 FF                        test    num_inventory_items, 0FFh
273F:59E0  74 06                                jz      loc_1147                ; Jump if zero
273F:59E2  C7 06 4B19 003A                      mov     data_789,3Ah            ; (31E4:4B19=6F6Eh)
273F:59E8                       loc_1147:                                       ;  xref 273F:59E0
273F:59E8  2E: A0 5977                          mov     al,cs:data_359          ; (273F:5977=0)
273F:59EC  04 03                                add     al,3
273F:59EE  32 E4                                xor     ah,ah                   ; Zero register
273F:59F0 BB 000A                              mov     bx, 10
273F:59F3 BE 4B08                              mov     si, offset carrying_str
273F:59F6  E8 C1EC                              call    sub_52                  ; (1BE5)

273F:59F9  2E: 8A 0E 5977                       mov     cl,cs:data_359          ; (273F:5977=0)
273F:59FE  80 C1 03                             add     cl,3
273F:5A01  32 ED                                xor     ch,ch                   ; Zero register
273F:5A03  F6 06 9835 FF                        test    num_inventory_items, 0FFh
273F:5A08  74 34                                jz      loc_1151                ; Jump if zero

273F:5A0A BE 623E                              mov     si, offset hotspot_table_3
273F:5A0D                       loc_1148:
273F:5A0D 8B 3C                                mov     di,[si]                 ; Get hotspot offset
273F:5A0F  83 FF FF                             cmp     di,0FFFFh               ; End of sublist?
273F:5A12  74 27                                je      loc_1150                ; If yes, then jump
273F:5A14  81 7D 06 03E8                        cmp     word ptr [di+HS_ROOM_NUM], PLAYER_HOTSPOT_ID  ; In player's inventory?
273F:5A19  75 1B                                jne     loc_1149                ; If not, move to next
273F:5A1B  56                                   push    si
273F:5A1C  8B 44 02                             mov     ax, [si+HSH_NAME]       ; Get hotspot name
273F:5A1F  BF 4B43                              mov     di, offset hotspot_name
273F:5A22  51                                   push    cx
273F:5A23  E8 2314                              call    decode_string
273F:5A26  58                                   pop     ax
273F:5A27  50                                   push    ax
273F:5A28 BB 0016                              mov     bx,16h                  ; (273F:0016=0EBh)
273F:5A2B BE 4B43                              mov     si, offset hotspot_name
273F:5A2E  E8 C1B4                              call    sub_52                  ; (1BE5)
273F:5A31  59                                   pop     cx
273F:5A32  83 C1 01                             add     cx,1
273F:5A35  5E                                   pop     si
273F:5A36                       loc_1149:                                       ;  xref 273F:5A19
273F:5A36  83 C6 09                             add     si,9
273F:5A39  EB D2                                jmp     short loc_1148          ; (5A0D)
273F:5A3B                       loc_1150:                                       ;  xref 273F:5A12
273F:5A3B  83 E9 01                             sub     cx,1
273F:5A3E                       loc_1151:                                       ;  xref 273F:5A08
273F:5A3E  A1 BC49                              mov     ax, num_groats
273F:5A41  0B C0                                or      ax,ax                   ; Zero ?
273F:5A43  74 26                                jz      loc_1153                ; Jump if zero
273F:5A45  04 30                                add     al,30h                  ; '0'
273F:5A47  A2 4B2B                              mov     s_num_groats, al        ; Fill out # groats
273F:5A4A  C7 06 4B32 0073                      mov     s_groats_plural, 's'    ; Add in a plural 's'

273F:5A50  83 3E BC49 01                        cmp     num_groats, 1           ; Is a plural necessary?
273F:5A55  75 06                                jne     loc_1152                ; Yes, so skip removal
273F:5A57  C7 06 4B32 0000                      mov     s_groats_plural, 0      ; Remove plural 's'
273F:5A5D                       loc_1152:
273F:5A5D  8B C1                                mov     ax,cx
273F:5A5F  05 0002                              add     ax,2
273F:5A62 BB 000A                              mov     bx,0Ah                  ; (273F:000A=23h)
273F:5A65 BE 4B22                              mov     si, offset money_str
273F:5A68  E8 C17A                              call    sub_52                  ; (1BE5)
273F:5A6B                       loc_1153:                                       ;  xref 273F:5A43
273F:5A6B  FF 16 0744                           call    word ptr [show_screen_proc]
273F:5A6F  E8 C519                              call    mouse_wait              ; (1F8B)
273F:5A72  E8 C521                              call    pause_for_input         ; (1F96)
273F:5A75  E8 C513                              call    mouse_wait              ; (1F8B)
273F:5A78  80 26 11D0 FE                        and     menubar_state, 0FEh ; (273F:11D0=56h)
273F:5A7D  FF 16 075E                           call    [show_cursor_proc]
273F:5A81  C3                                   retn

                               status_proc      endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                               return_proc      proc    near
273F:5A82  8B DE                                mov     bx, si
273F:5A84  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:5A87  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:5A8A  8B 44 4E                             mov     ax, [si+HS_V4E]
273F:5A8D  89 47 03                             mov     [bx+CURRENT_ACTION_ROOM_NUM], ax
273F:5A90  E9 FAEE                              jmp     character_walking_end
                               return_proc      endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                                   use_proc     proc    near
273F:5A93  8B DD                                mov     bx,bp
273F:5A95  8B 07                                mov     ax,[bx]
273F:5A97  A3 BA19                              mov     use_hotspot_id, ax
273F:5A9A  8B 47 02                             mov     ax,[bx+2]
273F:5A9D  A3 BA1B                              mov     active_hotspot_id, ax
273F:5AA0  83 C5 04                             add     bp,4
273F:5AA3  56                                   push    si
273F:5AA4  A1 BA19                              mov     ax, use_hotspot_id
273F:5AA7  E8 B240                              call    get_room_resource_pointer2
273F:5AAA  5B                                   pop     bx
273F:5AAB  87 DE                                xchg    bx,si                   ; bx=item to use, si=hotspot
273F:5AAD  8B 47 06                             mov     ax, [bx+HS_ROOM_NUM]
273F:5AB0  3B 45 1B                             cmp     ax, [di+ANIM_HOTSPOT_ID]; Item in char's inventory?
273F:5AB3  75 12                                jne     loc_1155                ; Jump if not equal
273F:5AB5  A1 BA1B                              mov     ax, active_hotspot_id
273F:5AB8  E8 EAEC                              call    hotspot_action_precheck
273F:5ABB  0B C0                                or      ax,ax                   ; Zero ?
273F:5ABD  74 0B                                jz      loc_1156                ; Jump if zero
273F:5ABF  3C 03                                cmp     al,3
273F:5AC1  74 03                                je      loc_ret_1154            ; Jump if equal
273F:5AC3  E9 FABB                              jmp     character_walking_end

273F:5AC6                       loc_ret_1154:                                   ;  xref 273F:5AC1, 5AF5, 5B3A
273F:5AC6  C3                                   retn
273F:5AC7                       loc_1155:                                       ;  xref 273F:5AB3
273F:5AC7  E9 0242                              jmp     loc_1187                ; (5D0C)
273F:5ACA                       loc_1156:                                       ;  xref 273F:5ABD
273F:5ACA  E8 EC21                              call    character_face_hotspot
273F:5ACD  53                                   push    bx
273F:5ACE  E8 FAB0                              call    character_walking_end
273F:5AD1  5B                                   pop     bx
273F:5AD2  81 7D 1B 03E9                        cmp     word ptr [di+ANIM_HOTSPOT_ID], RATPOUCH_HOTSPOT_ID
273F:5AD7  75 09                                jne     loc_1157                ; Jump if not equal
273F:5AD9  C6 44 FF 28                          mov     byte ptr [si-1], 28h    ; '('
273F:5ADD  C7 44 1F 0050                        mov     word ptr [si+HS_FRAME_CTR], 50h
273F:5AE2                       loc_1157:                                       ;  xref 273F:5AD7
273F:5AE2  E8 FB11                              call    hotspot_get_action_sequence
273F:5AE5  79 03                                jns     loc_1158                ; Jump if not sign
273F:5AE7  E9 08C7                              jmp     display_message_dialog_3
273F:5AEA                       loc_1158:                                       ;  xref 273F:5AE5
273F:5AEA  75 06                                jnz     loc_1159                ; Jump if not zero
273F:5AEC  B8 0011                              mov     ax,11h
273F:5AEF  E9 08BF                              jmp     display_message_dialog_3
273F:5AF2                       loc_1159:                                       ;  xref 273F:5AEA
273F:5AF2  E8 E33F                              call    sequence_execute
273F:5AF5  74 CF                                jz      loc_ret_1154            ; Jump if zero
273F:5AF7  E9 08B7                              jmp     display_message_dialog_3
                                   use_proc     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                            look_at_proc        proc    near
273F:5AFA  8B DD                                mov     bx,bp
273F:5AFC  8B 07                                mov     ax,[bx]
273F:5AFE  83 C5 02                             add     bp,2
273F:5B01  A3 BA19                              mov     use_hotspot_id, ax
273F:5B04  A3 BA1B                              mov     active_hotspot_id, ax
273F:5B07  56                                   push    si
273F:5B08  E8 B1DF                              call    get_room_resource_pointer2
273F:5B0B  5B                                   pop     bx
273F:5B0C  87 DE                                xchg    bx,si
273F:5B0E  81 3E BA19 0408                      cmp     use_hotspot_id, FIRST_OBJECT_HOTSPOT_ID
273F:5B14  72 29                                jb      loc_1163                ; Jump if below
273F:5B16  56                                   push    si
273F:5B17 BE 4AD0                              mov     si, offset lookat_hotspot_list
273F:5B1A  8B 0E BA19                           mov     cx, use_hotspot_id
273F:5B1E                       loc_1160:
273F:5B1E AD                                   lodsw                           ; Get next hotspot Id
273F:5B1F  0B C0                                or      ax,ax                   ; Reached end of list?
273F:5B21  74 09                                jz      loc_1162                ; Jump if yes
273F:5B23  3B C1                                cmp     ax,cx                   ; Found hotspot?
273F:5B25  74 02                                je      loc_1161                ; Jump if yes
273F:5B27  EB F5                                jmp     short loc_1160          ; Keep scanning
273F:5B29                       loc_1161:
273F:5B29  5E                                   pop     si
273F:5B2A  EB 13                                jmp     short loc_1163          
273F:5B2C                       loc_1162:
273F:5B2C  5E                                   pop     si                      ; Hotspot not found
273F:5B2D  A1 BA19                              mov     ax, use_hotspot_id
273F:5B30  E8 EA74                              call    hotspot_action_precheck
273F:5B33  0B C0                                or      ax,ax                   ; Zero ?
273F:5B35  74 08                                jz      loc_1163                ; Jump if zero
273F:5B37  3D 0003                              cmp     ax,3
273F:5B3A  74 8A                                je      loc_ret_1154            ; Jump if equal
273F:5B3C  E9 FA42                              jmp     character_walking_end
273F:5B3F                       loc_1163:                                       ;  xref 273F:5B14, 5B2A, 5B35
273F:5B3F  C6 44 2A 00                          mov     byte ptr [si+HS_ACTION_CTR], 0
273F:5B43  E8 EBA8                              call    character_face_hotspot
273F:5B46  53                                   push    bx
273F:5B47  E8 FA37                              call    character_walking_end
273F:5B4A  5B                                   pop     bx
273F:5B4B  E8 FAA8                              call    hotspot_get_action_sequence
273F:5B4E  79 03                                jns     loc_1164                ; Jump if not sign
273F:5B50  E9 085E                              jmp     display_message_dialog_3
273F:5B53                       loc_1164:                                       ;  xref 273F:5B4E
273F:5B53  74 05                                jz      loc_1165                ; Jump if zero
273F:5B55  E8 E2DC                              call    sequence_execute
273F:5B58  75 16                                jnz     loc_ret_1167            ; Jump if not zero
273F:5B5A                       loc_1165:                                       ;  xref 273F:5B53, 5C1E
273F:5B5A A1 BA1B                              mov     ax, active_hotspot_id
273F:5B5D  E8 B1C1                              call    get_room_resource_pointer3
273F:5B60  8B 5C 06                             mov     bx, [si+HSH_DESC_2]
273F:5B63  0B DB                                or      bx, bx                  ; Zero ?
273F:5B65  75 03                                jnz     loc_1166                ; Jump if not zero
273F:5B67  8B 5C 04                             mov     bx, [si+HSH_DESC]
273F:5B6A                       loc_1166:
273F:5B6A  80 E7 1F                             and     bh, 1Fh
273F:5B6D  E9 2D4C                              jmp     display_dialog
273F:5B70                       loc_ret_1167:                                   ;  xref 273F:5B58, 5BA0, 5BCD, 5BDD
273F:5B70  C3                                   retn
                            look_at_proc        endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                                  give_proc     proc    near
273F:5B71  8B DD                                mov     bx,bp
273F:5B73  8B 47 02                             mov     ax, [bx+2]
273F:5B76  A3 BA1B                              mov     active_hotspot_id, ax
273F:5B79  8B 07                                mov     ax, [bx]
273F:5B7B  A3 BA19                              mov     use_hotspot_id, ax
273F:5B7E  83 C5 04                             add     bp, 4
273F:5B81  56                                   push    si
273F:5B82  E8 B165                              call    get_room_resource_pointer2
273F:5B85  5B                                   pop     bx
273F:5B86  87 DE                                xchg    bx,si
273F:5B88  8B 47 06                             mov     ax, [bx+HS_ROOM_NUM]
273F:5B8B  3B 45 1B                             cmp     ax, [di+ANIM_HOTSPOT_ID]; Is item in char's inventory?
273F:5B8E  74 03                                je      loc_1168                ; Jump if equal
273F:5B90  E9 0179                              jmp     loc_1187                ; (5D0C)
273F:5B93                       loc_1168:                                       ;  xref 273F:5B8E
273F:5B93  A1 BA1B                              mov     ax, active_hotspot_id
273F:5B96  E8 EA0E                              call    hotspot_action_precheck
273F:5B99  0B C0                                or      ax,ax                   ; Zero ?
273F:5B9B  74 08                                jz      loc_1169                ; Jump if zero
273F:5B9D  3D 0003                              cmp     ax,3
273F:5BA0  74 CE                                je      loc_ret_1167            ; Jump if equal
273F:5BA2  E9 F9DC                              jmp     character_walking_end
273F:5BA5                       loc_1169:                                       ;  xref 273F:5B9B
273F:5BA5  53                                   push    bx
273F:5BA6  E8 F9D8                              call    character_walking_end
273F:5BA9  5B                                   pop     bx
273F:5BAA  E8 EB41                              call    character_face_hotspot
273F:5BAD  81 3E BA1B 0412                      cmp     active_hotspot_id, 412h
273F:5BB3  75 08                                jne     loc_1170                ; Jump if not equal
273F:5BB5  81 3E BA19 2710                      cmp     use_hotspot_id, 2710h
273F:5BBB  74 08                                je      loc_1171                ; Jump if equal
273F:5BBD                       loc_1170:                                       ;  xref 273F:5BB3
273F:5BBD  53                                   push    bx
273F:5BBE  BB 0007                              mov     bx,7
273F:5BC1  E8 07DE                              call    display_message_dialog_2
273F:5BC4  5B                                   pop     bx
273F:5BC5                       loc_1171:                                       ;  xref 273F:5BBB
273F:5BC5  E8 FA2E                              call    hotspot_get_action_sequence
273F:5BC8  79 03                                jns     loc_1172                ; Jump if not sign
273F:5BCA  E9 07E4                              jmp     display_message_dialog_3
273F:5BCD                       loc_1172:                                       ;  xref 273F:5BC8
273F:5BCD  74 A1                                jz      loc_ret_1167            ; Jump if zero
273F:5BCF  E8 E262                              call    sequence_execute
273F:5BD2  3D 03E7                              cmp     ax,3E7h
273F:5BD5  75 03                                jne     loc_1173                ; Jump if not equal
273F:5BD7  E9 2DD6                              jmp     loc_1705                ; (89B0)
273F:5BDA                       loc_1173:                                       ;  xref 273F:5BD5
273F:5BDA  3D 0001                              cmp     ax,1
273F:5BDD  74 91                                je      loc_ret_1167            ; Jump if equal
273F:5BDF  73 13                                jnc     loc_1174                ; Jump if carry=0
273F:5BE1  56                                   push    si
273F:5BE2  53                                   push    bx
273F:5BE3  A1 BA19                              mov     ax, use_hotspot_id
273F:5BE6  E8 B101                              call    get_room_resource_pointer2
273F:5BE9  A1 BA1B                              mov     ax, active_hotspot_id
273F:5BEC  89 44 06                             mov     [si+6],ax
273F:5BEF  5B                                   pop     bx
273F:5BF0  5E                                   pop     si
273F:5BF1  E9 0171                              jmp     loc_1193                ; (5D65)
273F:5BF4                       loc_1174:                                       ;  xref 273F:5BDF
273F:5BF4  8B D8                                mov     bx,ax
273F:5BF6  8B 0E BA1B                           mov     cx, active_hotspot_id
273F:5BFA  8B 55 1B                             mov     dx, [di+ANIM_HOTSPOT_ID]
273F:5BFD  E9 0790                              jmp     display_message_dialog
                                  give_proc     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                               examine_proc     proc    near
273F:5C00  8B DD                                mov     bx,bp
273F:5C02  8B 07                                mov     ax,[bx]
273F:5C04  A3 BA19                              mov     use_hotspot_id, ax
273F:5C07  A3 BA1B                              mov     active_hotspot_id, ax
273F:5C0A  83 C5 02                             add     bp,2
273F:5C0D  56                                   push    si
273F:5C0E  E8 B0D9                              call    get_room_resource_pointer2
273F:5C11  5B                                   pop     bx
273F:5C12  87 DE                                xchg    bx,si
273F:5C14  53                                   push    bx
273F:5C15  E8 F969                              call    character_walking_end
273F:5C18  5B                                   pop     bx
273F:5C19  E8 F9DA                              call    hotspot_get_action_sequence
273F:5C1C  75 03                                jnz     loc_1176                ; Jump if not zero
273F:5C1E                       loc_1175:                                       ;  xref 273F:5C24
273F:5C1E  E9 FF39                              jmp     loc_1165                ; (5B5A)
273F:5C21                       loc_1176:                                       ;  xref 273F:5C1C
273F:5C21  E8 E210                              call    sequence_execute
273F:5C24  74 F8                                jz      loc_1175                ; Jump if zero

273F:5C26                       loc_ret_1177:                                   ;  xref 273F:5C3E, 5C8A
273F:5C26  C3                                   retn
                               examine_proc     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                                bribe_proc      proc    near
273F:5C27  8B DD                                mov     bx,bp
273F:5C29  8B 07                                mov     ax,[bx]
273F:5C2B  A3 BA19                              mov     use_hotspot_id, ax
273F:5C2E  A3 BA1B                              mov     active_hotspot_id, ax
273F:5C31  83 C5 02                             add     bp,2
273F:5C34  E8 E970                              call    hotspot_action_precheck
273F:5C37  0B C0                                or      ax,ax                   ; Zero ?
273F:5C39  74 08                                jz      loc_1178                ; Jump if zero
273F:5C3B  3D 0003                              cmp     ax,3
273F:5C3E  74 E6                                je      loc_ret_1177            ; Jump if equal
273F:5C40  E9 F93E                              jmp     character_walking_end
273F:5C43                       loc_1178:                                       ;  xref 273F:5C39
273F:5C43  B8 014B                              mov     ax,14Bh
273F:5C46  8B 16 BA1B                           mov     dx, active_hotspot_id
273F:5C4A  53                                   push    bx
273F:5C4B BB 4AE6                              mov     bx, offset bribe_hotspot_list - 4
273F:5C4E                       loc_1179:                                       
273F:5C4E  83 C3 04                             add     bx, 4                   ; Move to next entry
273F:5C51  F7 07 FFFF                           test    word ptr [bx],0FFFFh    ; End of list reached?
273F:5C55  74 12                                jz      loc_1180                ; Jump if yes
273F:5C57  3B 17                                cmp     dx, [bx]                ; Char Id found?
273F:5C59  75 F3                                jne     loc_1179                ; Keep scanning if not
273F:5C5B  8B 47 02                             mov     ax, [bx+2]              ; Get 
273F:5C5E  F6 C4 80                             test    ah, 80h
273F:5C61  74 06                                jz      loc_1180                ; Jump if zero
273F:5C63  80 E4 7F                             and     ah,7Fh
273F:5C66  E8 E1CB                              call    sequence_execute
273F:5C69                       loc_1180:                                       ;  xref 273F:5C55, 5C61
273F:5C69  8B D0                                mov     dx,ax
273F:5C6B  BB 03E8                              mov     bx, PLAYER_HOTSPOT_ID
273F:5C6E  8B 0E BA1B                           mov     cx, active_hotspot_id
273F:5C72  E8 04A7                              call    talk_setup
273F:5C75  5B                                   pop     bx
273F:5C76  E8 EA75                              call    character_face_hotspot
273F:5C79  53                                   push    bx
273F:5C7A  E8 F904                              call    character_walking_end
273F:5C7D  5B                                   pop     bx
273F:5C7E  C6 44 2A 00                          mov     byte ptr [si+HS_ACTION_CTR], 0
273F:5C82  E8 F971                              call    hotspot_get_action_sequence
273F:5C85  74 05                                jz      loc_1181                ; Jump if zero
273F:5C87  E8 E1AA                              call    sequence_execute
273F:5C8A  75 9A                                jnz     loc_ret_1177            ; Jump if not zero
273F:5C8C                       loc_1181:                                       ;  xref 273F:5C85
273F:5C8C  BA 03E8                              mov     dx, PLAYER_HOTSPOT_ID
273F:5C8F  8B 0E BA19                           mov     cx, use_hotspot_id
273F:5C93  BB 0029                              mov     bx, 29h
273F:5C96  83 3E BA3B 06                        cmp     talk_record_index, 6
273F:5C9B  75 03                                jne     loc_1182                ; Jump if not equal
273F:5C9D BB 0030                              mov     bx, 30h  
273F:5CA0                       loc_1182:                                       ;  xref 273F:5C9B
273F:5CA0  E9 06ED                              jmp     display_message_dialog
                                bribe_proc      endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                                  ask_proc      proc    near
273F:5CA3  8B DD                                mov     bx,bp
273F:5CA5  8B 47 02                             mov     ax,[bx+2]
273F:5CA8  A3 BA19                              mov     use_hotspot_id, ax
273F:5CAB  8B 07                                mov     ax,[bx]
273F:5CAD  A3 BA1B                              mov     active_hotspot_id, ax
273F:5CB0  83 C5 04                             add     bp,4
273F:5CB3  E8 E8F1                              call    hotspot_action_precheck
273F:5CB6  0B C0                                or      ax,ax                   ; Zero ?
273F:5CB8  74 08                                jz      loc_1183                ; Jump if zero
273F:5CBA  3D 0003                              cmp     ax,3
273F:5CBD  74 4C                                je      loc_ret_1186            ; Jump if equal
273F:5CBF  E9 F8BF                              jmp     character_walking_end
273F:5CC2                       loc_1183:                                       ;  xref 273F:5CB8
273F:5CC2  53                                   push    bx
273F:5CC3  E8 F8C7                              call    character_walking_end_2
273F:5CC6  5B                                   pop     bx
273F:5CC7  E8 EA24                              call    character_face_hotspot
273F:5CCA  BB 0009                              mov     bx,9
273F:5CCD  E8 06D2                              call    display_message_dialog_2
273F:5CD0  E8 F923                              call    hotspot_get_action_sequence
273F:5CD3  78 0C                                js      loc_1184                ; Jump if sign=1
273F:5CD5  74 34                                jz      loc_ret_1186            ; Jump if zero
273F:5CD7  E8 E15A                              call    sequence_execute
273F:5CDA  74 11                                jz      loc_1185                ; Jump if zero
273F:5CDC  3D 0001                              cmp     ax,1
273F:5CDF  74 2A                                je      loc_ret_1186            ; Jump if equal
273F:5CE1                       loc_1184:                                       ;  xref 273F:5CD3
273F:5CE1  8B 0E BA1B                           mov     cx, active_hotspot_id
273F:5CE5  8B 55 1B                             mov     dx,[di+1Bh]
273F:5CE8  8B D8                                mov     bx,ax
273F:5CEA  E9 06A3                              jmp     display_message_dialog
273F:5CED                       loc_1185:                                       ;  xref 273F:5CDA
273F:5CED  56                                   push    si
273F:5CEE  A1 BA19                              mov     ax, use_hotspot_id
273F:5CF1  E8 AFF6                              call    get_room_resource_pointer2
273F:5CF4  8B 4D 1B                             mov     cx,[di+1Bh]
273F:5CF7  89 4C 06                             mov     [si+6],cx
273F:5CFA  5E                                   pop     si
273F:5CFB  E8 005B                              call    player_inc_inventory_items
273F:5CFE  BB 0020                              mov     bx,20h
273F:5D01  8B 0E BA1B                           mov     cx, active_hotspot_id
273F:5D05  8B 55 1B                             mov     dx,[di+1Bh]
273F:5D08  E9 0685                              jmp     display_message_dialog

273F:5D0B                       loc_ret_1186:                                   ;  xref 273F:5CBD, 5CD5, 5CDF
273F:5D0B  C3                                   retn
                                  ask_proc      endp

                                ;
                                ;                              JUMP POINT
                                ;
                                ;


273F:5D0C                       loc_1187:                                       ;  xref 273F:5AC7, 5B90, 5D2F
273F:5D0C  B8 000F                              mov     ax, 0Fh                 ; "What???"
273F:5D0F  E8 069F                              call    display_message_dialog_3
273F:5D12  E9 F86C                              jmp     character_walking_end

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                               drink_proc       proc    near
273F:5D15  8B DD                                mov     bx,bp
273F:5D17  8B 07                                mov     ax,[bx]
273F:5D19  83 C5 02                             add     bp,2
273F:5D1C  A3 BA19                              mov     use_hotspot_id, ax
273F:5D1F  A3 BA1B                              mov     active_hotspot_id, ax
273F:5D22  56                                   push    si
273F:5D23  E8 AFC4                              call    get_room_resource_pointer2
273F:5D26  5B                                   pop     bx
273F:5D27  87 DE                                xchg    bx,si
273F:5D29  8B 45 1B                             mov     ax,[di+ANIM_HOTSPOT_ID] ; Validate item is in
273F:5D2C  3B 47 06                             cmp     ax,[bx+HS_ROOM_NUM]     ; character's inventory
273F:5D2F  75 DB                                jne     loc_1187                ; Jump if not equal
273F:5D31  53                                   push    bx
273F:5D32  E8 F84C                              call    character_walking_end
273F:5D35  5B                                   pop     bx
273F:5D36  E8 F8BD                              call    hotspot_get_action_sequence
273F:5D39  79 03                                jns     loc_1188                ; Jump if not sign
273F:5D3B  E9 0673                              jmp     display_message_dialog_3
273F:5D3E                       loc_1188:                                       ;  xref 273F:5D39
273F:5D3E  74 13                                jz      loc_1191                ; Jump if zero
273F:5D40  E8 E0F1                              call    sequence_execute
273F:5D43  74 08                                jz      loc_1189                ; Jump if zero
273F:5D45  3D 0001                              cmp     ax,1
273F:5D48  74 08                                je      loc_ret_1190            ; Jump if equal
273F:5D4A  E9 0664                              jmp     display_message_dialog_3
273F:5D4D                       loc_1189:                                       ;  xref 273F:5D43
273F:5D4D  C7 47 06 0000                        mov     word ptr [bx+HS_ROOM_NUM], 0

273F:5D52                       loc_ret_1190:                                   ;  xref 273F:5D48
273F:5D52  C3                                   retn
273F:5D53                       loc_1191:                                       ;  xref 273F:5D3E
273F:5D53  B8 0016                              mov     ax,16h
273F:5D56  E9 0658                              jmp     display_message_dialog_3
                               drink_proc       endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;         Called from:   273F:5436, 5CFB
                                ;

                 player_inc_inventory_items     proc    near
273F:5D59  81 FE 6CEF                           cmp     si, offset player_hotspot_rec
273F:5D5D  75 05                                jne     loc_ret_1192            ; Jump if not equal
273F:5D5F  80 06 9835 01                        add     num_inventory_items, 1
273F:5D64                       loc_ret_1192:                                   ;  xref 273F:5D5D, 5D69, 5DB4
273F:5D64  C3                                   retn
                 player_inc_inventory_items     proc    near


273F:5D65                       loc_1193:                                       ;  xref 273F:5BF1
273F:5D65 81 FE 6CEF                           cmp     si, offset player_hotspot_rec
273F:5D69  75 F9                                jne     loc_ret_1192            ; Jump if not equal
273F:5D6B  80 2E 9835 01                        sub     num_inventory_items, 1

273F:5D70                       loc_ret_1194:                                   ;  xref 273F:5D8B
273F:5D70  C3                                   retn

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                        npc_dispatch_action     proc    near                                                                
273F:5D71  8B DD                                mov     bx,bp
273F:5D73  8B 07                                mov     ax,[bx]
273F:5D75  83 C5 04                             add     bp,4
273F:5D78  A3 BA19                              mov     use_hotspot_id, ax
273F:5D7B  A3 BA1B                              mov     active_hotspot_id, ax
273F:5D7E  E8 E826                              call    hotspot_action_precheck
273F:5D81  0B C0                                or      ax,ax                   ; Zero ?
273F:5D83  75 03                                jnz     loc_1195                ; Jump if not zero
273F:5D85  E9 F7F9                              jmp     character_walking_end
273F:5D88                       loc_1195:                                       ;  xref 273F:5D83
273F:5D88  3D 0003                              cmp     ax, 3                   ; Initial state?
273F:5D8B  74 E3                                je      loc_ret_1194            ; Exit if yes
273F:5D8D  8B DD                                mov     bx,bp
273F:5D8F  8B 47 FE                             mov     ax,[bx-2]
273F:5D92  8B DE                                mov     bx,si
273F:5D94  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:5D97  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:5D9A  89 47 01                             mov     [bx+CURRENT_ACTION_SUPPORT_TABLE], ax
273F:5D9D  E9 E41E                              jmp     action_dispatch
                        npc_dispatch_action     endp                                                                

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                              npc_unknown_3     proc    near
273F:5DA0  8B DD                                mov     bx,bp
273F:5DA2  8B 07                                mov     ax,[bx]
273F:5DA4  A3 BA19                              mov     use_hotspot_id, ax
273F:5DA7  A3 BA1B                              mov     active_hotspot_id, ax
273F:5DAA  E8 E7FA                              call    hotspot_action_precheck
273F:5DAD  0B C0                                or      ax,ax                   ; Zero ?
273F:5DAF  74 0B                                jz      loc_1196                ; Jump if zero
273F:5DB1  3D 0003                              cmp     ax,3
273F:5DB4  74 AE                                je      loc_ret_1192            ; Jump if equal
273F:5DB6  83 C5 0A                             add     bp,0Ah
273F:5DB9  E9 F7C5                              jmp     character_walking_end
273F:5DBC                       loc_1196:                                       ;  xref 273F:5DAF
273F:5DBC  A1 BA1B                              mov     ax, active_hotspot_id
273F:5DBF  56                                   push    si
273F:5DC0  E8 AF27                              call    get_room_resource_pointer2
273F:5DC3  5B                                   pop     bx
273F:5DC4  87 DE                                xchg    bx,si
273F:5DC6  F7 47 37 FFFF                        test    word ptr [bx+HS_TALK_COUNTDOWN], 0FFFFh
273F:5DCB  75 36                                jnz     loc_ret_1199            ; Jump if not zero
273F:5DCD  83 C5 02                             add     bp, 2
273F:5DD0  8B DD                                mov     bx, bp
273F:5DD2  8B 17                                mov     dx, [bx]                ; Get param #2
273F:5DD4  0B D2                                or      dx, dx                  ; Zero ?
273F:5DD6  74 11                                jz      loc_1197                ; Jump if zero
273F:5DD8  8B 4F FE                             mov     cx, [bx-2]
273F:5DDB  53                                   push    bx
273F:5DDC  E8 0350                              call    talk_setup_3                 ; (612F)
273F:5DDF  5B                                   pop     bx
273F:5DE0  8B 47 02                             mov     ax, [bx+2]
273F:5DE3  01 44 42                             add     [si+HS_DELAY_CTR], ax
273F:5DE6  01 44 37                             add     [si+HS_TALK_COUNTDOWN], ax
273F:5DE9                       loc_1197:                                       ;  xref 273F:5DD6
273F:5DE9  83 C3 04                             add     bx, 4
273F:5DEC  8B 17                                mov     dx, [bx]                ; Param #4
273F:5DEE  0B D2                                or      dx, dx                  ; Zero ?
273F:5DF0  74 0B                                jz      loc_1198                ; Jump if zero
273F:5DF2  8B 5F FA                             mov     bx, [bx-6]              ; Param #1
273F:5DF5  8B 4D 1B                             mov     cx, [di+ANIM_HOTSPOT_ID]
273F:5DF8  56                                   push    si
273F:5DF9  E8 032E                              call    talk_setup_2
273F:5DFC  5E                                   pop     si
273F:5DFD                       loc_1198:
273F:5DFD  83 C5 08                             add     bp, 8
273F:5E00  E9 F77E                              jmp     character_walking_end

273F:5E03                       loc_ret_1199:
273F:5E03  C3                                   retn
                              npc_unknown_3     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                                  npc_pause     proc    near
273F:5E04  8B DD                                mov     bx,bp
273F:5E06  8B 47 02                             mov     ax, [bx+2]
273F:5E09  89 44 42                             mov     [si+HS_DELAY_CTR], ax
273F:5E0C  C6 44 44 03                          mov     byte ptr [si+HS_CHAR_MODE], CHARMODE_3
273F:5E10  83 C5 04                             add     bp, 4
273F:5E13  E9 F76B                              jmp     character_walking_end
                                  npc_pause     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                          npc_start_talking     proc    near
273F:5E16  8B DE                                mov     bx, si
273F:5E18  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:5E1B  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:5E1E  83 47 01 06                          add     word ptr [bx+CURRENT_ACTION_SUPPORT_TABLE], 6
273F:5E22  8B DD                                mov     bx, bp
273F:5E24  8B 17                                mov     dx, [bx]
273F:5E26  8B 47 02                             mov     ax, [bx+2]
273F:5E29  8B 5D 1B                             mov     bx, [di+ANIM_HOTSPOT_ID]
273F:5E2C  B9 03E7                              mov     cx,3E7h
273F:5E2F  E9 0319                              jmp     talk_converse
                          npc_start_talking     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ;

                        npc_jump_to_address     proc    near
273F:5E32  8B DE                                mov     bx,si
273F:5E34  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:5E37  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:5E3A  83 47 01 04                          add     word ptr [bx+CURRENT_ACTION_SUPPORT_TABLE], 4
273F:5E3E  8B DD                                mov     bx,bp
273F:5E40  8B 07                                mov     ax,[bx]                 ; Load address
273F:5E42  FF E0                                jmp     ax                      ; Jump to it
                        npc_jump_to_address     endp

                                ;
                                ;                              SUBROUTINE
                                ;
                                ; This method is the tick handler proc for the player, and gets
                                ; called once every frame
                                ; di = animation slot entry, si = hotspot resource
                                ;

                            player_tick_proc    proc    near

273F:5E44  8B DE                                mov     bx, si
273F:5E46  03 5C 61                             add     bx, [si+HS_ACTION_OFFSET]
273F:5E49  83 C3 63                             add     bx, HS_FIRST_ACTION_OFFSET
273F:5E4C  E8 0329                              call    talk_countdown_handler
273F:5E4F  F7 44 1F FFFF                        test    word ptr [si+HS_FRAME_CTR], 0FFFFh
273F:5E54  74 0B                                jz      loc_1200                ; Jump if zero
273F:5E56  C7 06 F010 0000                      mov     timer_ticks, 0
273F:5E5C  83 6C 1F 01                          sub     word ptr [si+HS_FRAME_CTR],1
273F:5E60  C3                                   retn
273F:5E61                       loc_1200:
273F:5E61  E8 B2A7                              call    character_find_impinging_chars
273F:5E64  F6 45 1D FF                          test    byte ptr [di+ANIM_SKIP], 0FFh
273F:5E68  74 13                                jz      loc_1202                ; Jump if zero
273F:5E6A  C7 06 F010 0000                      mov     timer_ticks, 0
273F:5E70  F7 06 10BE FFFF                      test    num_impinging_chars, 0FFFFh
273F:5E76  74 01                                jz      loc_1201                ; Jump if zero
273F:5E78  C3                                   retn
273F:5E79                       loc_1201:                                       ;  xref 273F:5E76
273F:5E79  C6 45 1D 00                          mov     byte ptr [di+ANIM_SKIP], 0
273F:5E7D                       loc_1202:                                       ;  xref 273F:5E68
273F:5E7D  8B 44 58                             mov     ax, [si+HS_V58]
273F:5E80  0B C0                                or      ax, ax                  ; Zero ?
273F:5E82  74 19                                jz      loc_1203                ; Jump if zero
273F:5E84  C7 06 F010 0000                      mov     timer_ticks, 0
273F:5E8A  C7 44 58 0000                        mov     word ptr [si+HS_V58], 0
273F:5E8F  56                                   push    si
273F:5E90  E8 AE57                              call    get_room_resource_pointer2
273F:5E93  80 7C 44 07                          cmp     byte ptr [si+HS_CHAR_MODE], CHARMODE_7
273F:5E97  5E                                   pop     si
273F:5E98  74 03                                jz      loc_1203
273F:5E9A  C6 07 00                             mov     byte ptr [bx], 0        ; Reset action

273F:5E9D                       loc_1203:                                       
273F:5E9D  F7 44 4A FFFF                        test    word ptr [si+HS_V4A], 0FFFFh
273F:5EA2  74 27                                jz      loc_1205                ; Jump if zero
273F:5EA4  C7 06 F010 0000                      mov     timer_ticks, 0
273F:5EAA  E8 E4B9                              call    character_update_movement
273F:5EAD  8B 45 1B                             mov     ax, [di+ANIM_HOTSPOT_ID]
273F:5EB0  E8 F09F                              call    pathfind_reset
273F:5EB3  83 7C 4A 01                          cmp     word ptr [si+HS_V4A], 1
273F:5EB7  75 0F                                jne     loc_1204                ; Jump if not equal
273F:5EB9  C7 44 4A 0000                        mov     word ptr [si+HS_V4A], 0
273F:5EBE  F6 44 44 FF                          test    byte ptr [si+HS_CHAR_MODE], 0FFh
273F:5EC2  75 07                                jnz     loc_1205                ; Jump if not zero
273F:5EC4  E8 E4C0                              call    character_pathfind_clear
273F:5EC7  C3                                   retn
273F:5EC8                       loc_1204:                                       ;  xref 273F:5EB7
273F:5EC8  E9 E695                              jmp     loc_869                 ; (4560)
273F:5ECB                       loc_1205:                                       ;  xref 273F:5EA2, 5EC2
273F:5ECB  8A 44 44                             mov     al, [si+HS_CHAR_MODE]
273F:5ECE  0A C0                                or      al, al                  ; CHARMODE_NONE?
273F:5ED0  74 44                                jz      loc_1208                ; Jump if yes
273F:5ED2  3C 02                                cmp     al, CHARMODE_IDLE
273F:5ED4  74 40                                je      loc_1208
273F:5ED6  C7 06 F010 0000                      mov     timer_ticks, 0
273F:5EDC  F7 44 42 FFFF                        test    word ptr [si+HS_DELAY_CTR], 0FFFFh
273F:5EE1  74 0E                                jz      loc_1206                ; Jump if zero
273F:5EE3  E8 E480                              call    character_update_movement
273F:5EE6  8B 45 1B                             mov     ax, [di+ANIM_HOTSPOT_ID]
273F:5EE9  E8 F066                              call    pathfind_reset
273F:5EEC  83 6C 42 01                          sub     word ptr [si+HS_DELAY_CTR], 1
273F:5EF0  C3                                   retn
273F:5EF1                       loc_1206:                                       ;  xref 273F:5EE1
273F:5EF1  E8 E493                              call    character_pathfind_clear
273F:5EF4  C6 44 44 00                          mov     byte ptr [si+HS_CHAR_MODE], CHARMODE_NONE
273F:5EF8  F6 44 FF FF                          test    byte ptr [si-1],0FFh
273F:5EFC  74 17                                jz      loc_ret_1207            ; Jump if zero
273F:5EFE  C6 44 FF 00                          mov     byte ptr [si-1],0
273F:5F02  8B 44 FB                             mov     ax,[si-5]
273F:5F05  89 44 54                             mov     [si+HS_DEST_X], ax
273F:5F08  8B 44 FD                             mov     ax,[si-3]
273F:5F0B  89 44 56                             mov     [si+HS_DEST_Y], ax
273F:5F0E  C6 07 01                             mov     byte ptr [bx], CHAR_ACTION_START_WALK
273F:5F11  C6 45 27 00                          mov     byte ptr [di+ANIM_UNKNOWN1], 0

273F:5F15                       loc_ret_1207:                                   ;  xref 273F:5EFC
273F:5F15  C3                                   retn

273F:5F16                       loc_1208:                                       ;  xref 273F:5ED0, 5ED4
273F:5F16  B0 02                                mov     al, CHARMODE_IDLE
273F:5F18  8A 27                                mov     ah, [bx]
273F:5F1A  F6 C4 FF                             test    ah, 0FFh
273F:5F1D  75 08                                jnz     loc_1209                ; Jump if not zero
273F:5F1F  C7 44 52 0000                        mov     [si+HS_DEST_HOTSPOT], 0
273F:5F24  E9 E43C                              jmp     character_update_movement_2

273F:5F27                       loc_1209:
273F:5F27  C7 06 F010 0000                      mov     timer_ticks, 0
273F:5F2D  80 FC 05                             cmp     ah, CHAR_ACTION_CONTINUE_WALK
273F:5F30  74 13                                je      loc_1211                ; Jump if equal
273F:5F32  80 FC 03                             cmp     ah, CHAR_ACTION_EXEC_SCRIPT
273F:5F35  74 11                                je      loc_1212                ; Jump if equal
273F:5F37  80 FC 01                             cmp     ah, CHAR_ACTION_START_WALK
273F:5F3A  74 17                                je      loc_1213                ; Jump if equal
273F:5F3C  80 FC 04                             cmp     ah, CHAR_ACTION_PROCESSING_PATH
273F:5F3F  74 1E                                je      loc_1214                ; Jump if equal
273F:5F41  E8 E27A                              call    action_dispatch

273F:5F44                       loc_ret_1210:                                   ;  xref 273F:5F4D
273F:5F44  C3                                   retn
273F:5F45                       loc_1211:                                       ;  xref 273F:5F30
273F:5F45  E9 00A3                              jmp     loc_1219                ; (5FEB)
273F:5F48                       loc_1212:                                       ;  xref 273F:5F35
273F:5F48  E8 B05E                              call    hotspot_script_execute
273F:5F4B  0B C0                                or      ax,ax                   ; Zero ?
273F:5F4D  75 F5                                jnz     loc_ret_1210            ; Jump if not zero
273F:5F4F  C6 07 02                             mov     byte ptr [bx], CHAR_ACTION_DISPATCH_ACTION
273F:5F52  C3                                   retn

; Code below is responsible for starting the player walking

273F:5F53                       loc_1213:                                       ;  xref 273F:5F3A
273F:5F53  B8 03E8                              mov     ax, PLAYER_HOTSPOT_ID
273F:5F56  E8 EFF9                              call    pathfind_reset
273F:5F59  C6 07 04                             mov     byte ptr [bx], CHAR_ACTION_PROCESSING_PATH
273F:5F5C  E8 E428                              call    character_pathfind_clear

; Jump point here calculates one sequence of the path finding required to get
; the player to a given destination

273F:5F5F                       loc_1214:                                       ;  xref 273F:5F3F
273F:5F5F  C6 44 44 00                          mov     byte ptr [si+HS_CHAR_MODE], CHARMODE_NONE
273F:5F63  E8 E5FA                              call    sub_105                 ; (4560)
273F:5F66  8B 4C 54                             mov     cx, [si+HS_DEST_X]
273F:5F69  8B 54 56                             mov     dx, [si+HS_DEST_Y]
273F:5F6C  53                                   push    bx
273F:5F6D  56                                   push    si
273F:5F6E  57                                   push    di
273F:5F6F  8B 45 1B                             mov     ax, [di+ANIM_HOTSPOT_ID]
273F:5F72  8B D9                                mov     bx,cx
273F:5F74  8B CA                                mov     cx,dx
273F:5F76  8A 54 4C                             mov     dl, [si+HS_BLOCKED_FLAG]
273F:5F79  E8 EA7A                              call    character_pathfind
273F:5F7C  8B D3                                mov     dx,bx
273F:5F7E  5F                                   pop     di
273F:5F7F  5E                                   pop     si
273F:5F80  5B                                   pop     bx
273F:5F81  0B C0                                or      ax,ax                   ; Zero ?
273F:5F83  75 01                                jnz     loc_1215                ; Jump if not zero
273F:5F85  C3                                   retn

; The code below gets jumped to when the final segment of pathfinding is
; complete.

273F:5F86                       loc_1215:
273F:5F86  3D 0001                              cmp     ax, 1
273F:5F89  74 42                                je      loc_1218                ; Immediate translate
273F:5F8B  F6 45 27 01                          test    byte ptr [di+ANIM_UNKNOWN1], 1
273F:5F8F  75 05                                jnz     loc_1216                ; Jump if not zero
273F:5F91  3D 0002                              cmp     ax, 2
273F:5F94  74 37                                je      loc_1218                ; Jump to translate
273F:5F96                       loc_1216:                                       ;  xref 273F:5F8F
273F:5F96  F6 44 4C FF                          test    byte ptr [si+HS_BLOCKED_FLAG], 0FFh
273F:5F9A  74 31                                jz      loc_1218                ; Jump if zero
273F:5F9C  80 7C 4C 02                          cmp     byte ptr [si+HS_BLOCKED_FLAG], 2
273F:5FA0  74 17                                je      loc_1217                ; Jump if equal
273F:5FA2  C6 44 FF 01                          mov     byte ptr [si-1], 1
273F:5FA6  8B 44 54                             mov     ax, [si+HS_DEST_X]
273F:5FA9  89 44 FB                             mov     [si-5], ax
273F:5FAC  8B 44 56                             mov     ax, [si+HS_DEST_Y]
273F:5FAF  89 44 FD                             mov     [si-3], ax
273F:5FB2  80 44 4C 01                          add     byte ptr [si+HS_BLOCKED_FLAG], 1
273F:5FB6  E9 F6AD                              jmp     character_set_random_dest
273F:5FB9                       loc_1217:                                       ;  xref 273F:5FA0
273F:5FB9  E8 E485                              call    sub_97                  ; (4441)
273F:5FBC  C6 44 4C 00        