.TH SCRAM "1" "September 2016" "SCRAM 0.11.4" "SCRAM Manual"
.SH NAME
SCRAM \- Command-line Risk Analysis Multi-tool
.SH SYNOPSIS
.B scram
[\fIinput-files\fR] [\fIoptions\fR]
.SH DESCRIPTION
.PP
\fBSCRAM\fP is a probabilistic risk analysis (PRA) tool.
It can perform static fault tree analysis,
analysis with common cause failure models,
probability calculations with importance analysis,
and uncertainty analysis with Monte Carlo simulations.
This tool can handle non-coherent fault trees, containing NOT logic.
.PP
\fBSCRAM\fP works with PRA models and constructs described
in OpenPSA Model Exchange Format.
.SH OPTIONS
.TP
\fB\-\-version\fR
Prints version information of SCRAM and its dependencies
.TP
\fB\-\-help\fR
Prints the help message with a list of commands
.TP
\fB\-\-input\-files\fR arg
Run with analysis constructs from XML input files
.TP
\fB\-\-config\-file\fR arg
Run analysis with configurations from XML configuration file
.TP
\fB\-\-validate\fR
Validate input and configuration files without analysis
.TP
\fB\-\-bdd\fR
Perform qualitative analysis with Binary Decision Diagrams
.TP
\fB\-\-zbdd\fR
Perform qualitative analysis with Zero-Suppressed Binary Decision Diagrams
.TP
\fB\-\-mocus\fR
Perform qualitative analysis with the MOCUS algorithm
.TP
\fB\-\-prime\-implicants\fR
Calcualte prime implicants instead of minimal cut sets
.TP
\fB\-\-probability\fR arg
Perform probability analysis
.TP
\fB\-\-importance\fR arg
Perform importance analysis
.TP
\fB\-\-uncertainty\fR arg
Perform uncertainty analysis
.TP
\fB\-\-ccf\fR arg
Perform common\-cause failure analysis
.TP
\fB\-\-rare\-event\fR
Use the rare event approximation for probability
calculations
.TP
\fB\-\-mcub\fR
Use the MCUB approximation for probability
calculations
.HP
\fB\-l\fR [ \fB\-\-limit\-order\fR ] arg
Upper limit for the product order
.TP
\fB\-\-cut\-off\fR arg
Cut\-off probability for products
.TP
\fB\-\-mission\-time\fR arg
Set the system mission time in hours for probability calculations
.TP
\fB\-\-num\-trials\fR arg
Set the number of trials for Monte Carlo simulations
.TP
\fB\-\-num\-quantiles\fR arg
Set the number of quantiles for distributions
.TP
\fB\-\-num\-bins\fR arg
Set the number of bins for histograms
.TP
\fB\-\-seed\fR arg
Set the seed for the pseudo\-random number generator
.HP
\fB\-o\fR [ \fB\-\-output\-path\fR ] arg Output path for reports
.TP
\fB\-\-verbosity\fR arg
Set the log verbosity
.SH "SEE ALSO"
http://scram-pra.org
