INSERT INTO vars VALUES ('rdf_http_proxy','','If set, then the proxy to use when fetching RDF''s. Otherwise, disables proxy use. Should be in the form http://host:port/','text','RDF');

INSERT INTO vars VALUES ('rdf_max_headlines','15','Default max number of titles to display for each RDF channel.','num','RDF');

UPDATE box SET content = 'return unless $S->{UI}->{VARS}->{use_rdf_feeds};
\n
\nmy $to_display = {};
\nif (@ARGS || $S->{CGI}->param(\'rdf\')) {
\n	my $rdf_arg = $S->{CGI}->param(\'rdf\');
\n	@ARGS = split(/,/, $rdf_arg) if $rdf_arg;
\n	foreach (@ARGS) {
\n		$to_display->{$_} = 1;
\n	}
\n}
\n
\nmy $content;
\nmy $channels = $S->rdf_channels();
\nmy $user_feeds = $S->rdf_get_prefs() unless @ARGS;
\nmy $item_limit = defined($S->{prefs}->{rdf_max_headlines}) ?
\n	$S->{prefs}->{rdf_max_headlines} :
\n	defined($S->{UI}->{VARS}->{rdf_max_headlines}) ?
\n	$S->{UI}->{VARS}->{rdf_max_headlines} : 15;
\n
\nif ($S->have_perm(\'submit_rdf\')) {
\n	$content = qq|<A CLASS="light" HREF="%%rootdir%%/?op=submitrdf">Submit Feed</A><BR><BR>\\n|;
\n}	
\n
\nforeach my $c (@{$channels}) {
\n	if (@ARGS) {
\n		next unless $to_display->{ $c->{rid} };
\n	} else {
\n		next unless $user_feeds->{ $c->{rid} };
\n	}
\n	next unless $c->{title};
\n	unless ($S->have_perm(\'rdf_admin\')) {
\n		next if $c->{submitted} || !$c->{enabled};
\n	}
\n
\n	if ($S->{UI}->{VARS}->{rdf_use_images} && $c->{image_url}) {
\n		$content .= qq~<A HREF="$c->{image_link}"><IMG SRC="$c->{image_url}" ALT="$c->{image_title}" BORDER="1"></a><br>\\n~;
\n	} else {
\n		$content .= qq~<B><A CLASS="light" HREF="$c->{link}">$c->{title}</a></b><BR>\\n~;
\n	}
\n
\n	my $items = $S->rdf_items($c->{rid}, $item_limit);
\n	foreach my $i (@{$items}) {
\n		$content .= qq~%%dot%% <A CLASS="light" HREF="$i->{link}">$i->{title}</a><BR>\\n~;
\n	}
\n
\n	if ($S->{UI}->{VARS}->{rdf_use_forms} && $c->{form_link}) {
\n		$content .= qq~<FORM ACTION="$c->{form_link}" METHOD="GET">$c->{form_title}: <INPUT TYPE="TEXT" NAME="$c->{form_name}"></form><br>\\n~;
\n	}
\n
\n	$content .= "<BR>\\n";
\n}
\n
\nreturn $content;
\n' WHERE boxid = 'rdf_feeds';

REPLACE INTO box (boxid, title, content, description, template) VALUES ('submit_rdf', 'Submit Feed', 'return "Sorry, you don\'t have permission to submit a feed."
\n	unless $S->have_perm(\'submit_rdf\');
\nmy $action = $S->{CGI}->param(\'action\') || \'showform\';
\nif ($action eq \'showform\') {
\n	return &disp_form();
\n} elsif ($action eq \'save\') {
\n	my $url = $S->{CGI}->param(\'url\');
\n	return (\'Please fill in the URL field\') unless $url;
\n	# check to see if this RDF already exists
\n	my $is_dup = 0;
\n	my $channels = $S->rdf_channels;
\n	foreach my $c (@{$channels}) {
\n		$is_dup = 1 if $c->{rdf_link} eq $url;
\n	}
\n	return &disp_form(\'That RDF already exists, or has been submitted already.\') if $is_dup;
\n
\n	my $do_fetch = $S->{UI}->{VARS}->{allow_rdf_fetch} ? 1 : 0;
\n	my ($id, $res) = $S->rdf_add_channel($url, $do_fetch, $S->{NICK});
\n	unless ($res) {
\n		$S->rdf_remove_channel($id);
\n		return &disp_form(\'Error adding RDF file: $res\');
\n	}
\n	my $fetched_msg = qq|
\n%%norm_font%%You\'re RDF has been fetched. An admin will check it out as soon as possible%%norm_font_end%%|;
\n	return $fetched_msg;
\n}
\n
\nsub disp_form {
\n	my $form = qq|
\n%%norm_font%% %%submit_rdf_message%% %%norm_font_end%%
\n<p>
\n<form action="%%rootdir%%/?" method="GET">
\n<input type="hidden" name="op" value="submitrdf">
\n<input type="hidden" name="action" value="save">
\n<table border=0 cellspacing=0 cellpadding=0>|;
\n	$form .= qq|
\n	<tr>
\n		<td><FONT color="#FF0000">%%norm_font%%$_[0]%%norm_font_end%%</font></td>
\n	</tr>| if $_[0];
\n	$form .= qq|
\n	<tr>
\n		<td>%%norm_font%%URL of RDF file:%%norm_font_end%% <input type="text" name="url" size="50"></td>
\n	</tr>
\n	<tr>
\n		<td><input type="submit" value="Submit"></td>
\n	</tr>
\n</table>
\n</form>
\n|;
\n	return $form;
\n}
\n', 'Box to do submitrdf op and such.', 'titled_box');
