package Scoop;
use strict;

sub edit_special {
	my $S = shift;
	my $msg = $S->_write_special_page();
	my $form = $S->_get_special_form($msg);
	return $form;
}


sub _get_special_form {
	my $S = shift;
	my $msg = shift || '&nbsp;';
	my $id = $S->{CGI}->param('id');
	my $pageid = $S->{CGI}->param('pageid');
	my $get = $S->{CGI}->param('get');
	my $check_html = $S->{CGI}->param('html_check') || 0;
	my $spell_check = $S->{CGI}->param('spell_check') || 0;
	
	if ($id eq '' && !$get) {
		$id = $pageid;
	}
	
	my ($page_selector, $page_data) = $S->_special_page_selector($id);
	
	$page_data->{content} =~ s/%%/\|/g;
	$page_data->{title} =~ s/"/&quot;/g;
	
	# Preserve &'s literally.
	$page_data->{content} =~ s/&/&amp;/g;
	
	# this is so that any tags in the special page don't trail out of the <textblock>
	$page_data->{content} =~ s/\</&lt;/g;
	$page_data->{content} =~ s/\>/&gt;/g;
	my $preview;
	
	if ($id) {
		$preview = qq|
			<TR>
				<TD>%%norm_font%%View <A HREF="%%rootdir%%/?op=special;page=$id" target="new">$page_data->{title}</A> (opens in new window)%%norm_font_end%%</TD>
			</TR>|;
	}
	my $chkhtml_checked = $check_html ? ' CHECKED' : '';
	my $splchk_checked  = $spell_check ? ' CHECKED' : '';
	
	my $page = qq|
		<FORM NAME="special" ACTION="%%rootdir%%/" METHOD="post">
		<INPUT TYPE="hidden" NAME="op" VALUE="admin">
		<INPUT TYPE="hidden" NAME="tool" VALUE="special">
		<TABLE WIDTH="100%" BORDER=0 CELLPADDING=0 CELLSPACING=0>
			<TR BGCOLOR="%%title_bgcolor%%">
				<TD>%%title_font%%Edit Special Pages%%title_font_end%%</TD>
			</TR>
			<TR><TD>%%title_font%%<FONT COLOR="#FF0000">$msg</FONT>%%title_font_end%%</TD>			
			$preview
			<TR>
				<TD>%%norm_font%%<B>Page:</B> $page_selector <INPUT TYPE="submit" NAME="get" VALUE="Get Page">%%norm_font_end%%</TD>
			</TR>
			<TR>
				<TD>%%norm_font%%<B>Page ID:</B> <INPUT TYPE="text" NAME="pageid" VALUE="$page_data->{pageid}" SIZE=40>%%norm_font_end%%</TD>
			</TR>
			<TR>
				<TD>%%norm_font%%<B>Title:</B> <INPUT TYPE="text" NAME="title" VALUE="$page_data->{title}" SIZE=40>%%norm_font_end%%</TD>
			</TR>	
			<TR>
				<TD><input type="checkbox" name="html_check" value="1"$chkhtml_checked> %%norm_font%%Check the HTML of this page%%norm_font_end%%</TD>
			</TR>|;
	if ($S->spellcheck_enabled()) {
			$page .= qq|
			<TR>
				<TD><input type="checkbox" name="spell_check" value="1"$splchk_checked> %%norm_font%%Spellcheck this page%%norm_font_end%%</TD>
			</TR>|;
	}
	$page .= qq|
			<TR>
				<TD>%%norm_font%%<B>Description:</B></TD>
			</TR>
			<TR>
				<TD>%%norm_font%%<TEXTAREA COLS=50 ROWS=3 NAME="description" WRAP="soft">$page_data->{description}</TEXTAREA>%%norm_font_end%%</TD>
			</TR>
			<TR>
				<TD>%%norm_font%%<B>Content:</B></TD>
			</TR>
			<TR>
				<TD>%%norm_font%%<TEXTAREA COLS=50 ROWS=10 NAME="content" WRAP="soft">$page_data->{content}</TEXTAREA>%%norm_font_end%%</TD>
			</TR>
			<TR>
			<TD>%%norm_font%%<INPUT TYPE="submit" NAME="write" VALUE="Save Page"> <INPUT TYPE="reset">%%norm_font_end%%</TD>
			</TR>
			</TABLE>
			</FORM>|;
	
	return $page;
}

sub _special_page_selector {
	my $S = shift;
	my $id = shift;
	
	my ($rv, $sth) = $S->db_select({
		WHAT => '*',
		FROM => 'special'});
	
	my $select = '';
	$select = ' SELECTED' unless $id;
	my $page = qq|
		<SELECT NAME="id" SIZE=1>
		<OPTION VALUE=""$select>Select Special Page|;
	
	my $return_data;	
	while (my $page_data = $sth->fetchrow_hashref) {
		$select = '';
		$page_data->{title} =~ s/"/&quot;/g;
		if ($id eq $page_data->{pageid}) {
			$select = ' SELECTED';
			$return_data = $page_data;
		}
		$page .= qq|
			<OPTION VALUE="$page_data->{pageid}"$select>$page_data->{title}|;
	}
	$sth->finish;
	$page .= qq|
		</SELECT>|;
	
	return ($page, $return_data);
}

sub _write_special_page {
	my $S = shift;
	my $write = $S->{CGI}->param('write');
	
	return unless $write;
	
	my $id = $S->{CGI}->param('id');
	my $pageid = $S->{CGI}->param('pageid');
	my $title = $S->{CGI}->param('title');
	my $description = $S->{CGI}->param('description');
	my $content = $S->{CGI}->param('content');
	my $check_html = $S->{CGI}->param('html_check');
	my $spell_check = $S->{CGI}->param('spell_check');

	my @mis_spell;
	if ($spell_check && $S->spellcheck_enabled()) {
		my $callback = sub {
			my $word = shift;
			push(@mis_spell, $word);
			return $word;
		};

		if ($check_html) {
			$S->spellcheck_html_delayed($callback);
		} else {
			$S->spellcheck_html($content, $callback);
		}
	}

	my $errs;
	if ($check_html) {
		my $page_ref = $S->html_checker->clean_html(\$content, 1);
		$content = $$page_ref;

		$errs = $S->html_checker->errors_as_string
	}

	if (@mis_spell) {
		my $words_are = (@mis_spell == 1) ? 'word is' : 'words are';
		my $sc_errs = "The following $words_are mis-spelled:<BR>\n<UL>\n";
		foreach my $m (@mis_spell) {
			$sc_errs .= "<LI>$m<BR>\n";
		}
		$sc_errs .= "</UL>\n";

		$errs .= "<P>" if $errs;
		$errs .= $sc_errs;
	}

	return $errs if $errs;

	my $write_cont = $content;
	$write_cont =~ s/\|/%%/g;
	$write_cont =~ s/\\%%/\|/g;
	$write_cont = $S->{DBH}->quote($write_cont);
	
	my ($rv, $sth);
	if ($id eq $pageid) {
		($rv, $sth) = $S->db_update({
			WHAT => 'special',
			SET => qq|title = "$title", description = "$description", content = $write_cont|,
			WHERE => qq|pageid = "$pageid"|});
	} else {
		($rv, $sth) = $S->db_insert({
			INTO => 'special',
			COLS => 'pageid, title, description, content',
			VALUES => qq|"$pageid", "$title", "$description", $write_cont|});
	}
	$sth->finish;
	
	return "Page \"$title\" updated." if $rv;
	my $err = $S->{DBH}->errstr;
	return "Error updating \"$title\". DB said: $err";
}

1;
