#!/usr/bin/python
# -*- coding: utf-8 -*-
# 	$Id: preferences.py 42 2011-01-15 22:38:04Z georgesk $	

licence={}
licence['en']="""
    file preferences.py
    this file is part of the project scolasync
    
    Copyright (C) 2010 Georges Khaznadar <georgesk@ofset.org>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

from PyQt4.QtCore import *
from PyQt4.QtGui import *

class preferenceWindow(QDialog):
    def __init__(self, parent=None):
        """
        Le constructeur
        """
        QDialog.__init__(self, parent)
        from Ui_preferences import Ui_Dialog
        self.ui=Ui_Dialog()
        self.ui.setupUi(self)

    def values(self):
        """
        @return un dictionnaire de préférences
        """
        prefs={}
        prefs["checkable"]=bool(self.ui.checkCheck.isChecked())
        prefs["workdir"]= "%s" %self.ui.dirEdit.text().toUtf8()
        return prefs

    def setValues(self, prefs):
        """
        Met en place les préférences dans le dialogue
        @param prefs un dictionnaire de préférences
        """
        if prefs["checkable"]:
            state=Qt.Checked
        else:
            state=Qt.Unchecked
        self.ui.checkCheck.setCheckState(state)
        self.ui.dirEdit.setText(prefs["workdir"])


