# -*- coding: utf-8 -*-    
# $Id: chooseFromUsbDialog.py 43 2011-01-15 23:12:57Z georgesk $	

licenceEn="""
    file chooseFromUsbDialog.py
    this file is part of the project scolasync
    
    Copyright (C) 2010 Georges Khaznadar <georgesk@ofset.org>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

from PyQt4.QtCore import *
from PyQt4.QtGui import *
import os.path

import Ui_deleteDialog

class chooseDialog(QDialog):
    """
    Un dialogue pour choisir un ensemble de fichiers à copier depuis une clé USB.
    """
    def __init__(self,parent = None):
        """
        Le constructeur
        @param parent un QWidget
        """
        QDialog.__init__(self,parent)
        self._ui=Ui_deleteDialog.Ui_Dialog()
        self._ui.setupUi(self)
        self.setWindowTitle(QApplication.translate("Dialog", "Choix de fichiers à copier", None, QApplication.UnicodeUTF8))
        self._ui.groupBox.setTitle(QApplication.translate("Dialog", "Choix de fichiers à copier depuis les baladeurs", None, QApplication.UnicodeUTF8))
        okButton=self._ui.buttonBox.button(QDialogButtonBox.Ok)
        self._ui.buttonBox.removeButton(okButton)
        self._ui.buttonBox.addButton(QPushButton(self.tr(u"Continue ...")),
                                     QDialogButtonBox.AcceptRole)
        self._model=QStandardItemModel()
        self._proxyModel = QSortFilterProxyModel()
        self._proxyModel.setSourceModel(self._model)
	self._ui.listView.setModel(self._proxyModel)
        self._proxyModel.setDynamicSortFilter(True)
        self._ui.minusButton.setEnabled(False)
        QObject.connect(self._ui.plusButton, SIGNAL("clicked()"), self.plus)
        QObject.connect(self._ui.chooseButton, SIGNAL("clicked()"), self.choose)
        QObject.connect(self._ui.chooseButton_dir, SIGNAL("clicked()"), self.choose_dir)
        QObject.connect(self._ui.minusButton, SIGNAL("clicked()"), self.minus)
        QObject.connect(self._ui.listView, SIGNAL("clicked(QModelIndex)"), self.activate)

    def choose(self):
        """
        Facilite le choix de motifs de fichiers en recherchant dans
        les clés USB, modifie l'éditeur de ligne de texte et place le
        fichier choisi dans la liste
        """
        if self.chooseDir!=None:
            f = QFileDialog.getOpenFileName (None,
                                             self.tr(u"Choissez un fichier"),
                                             self.chooseDir)
            if f and len(f)>0:
                path=f.remove(self.chooseDir+"/")
                self._ui.lineEdit.setText(path)
                # par défaut, on ajoute le nouveau texte et on pourrait aller
                # jusqu'à le sélectionner !
                self.plus()
        else:
             msgBox=QMessageBox.warning(None,
                                        self.tr(u"Aucune clé modèle sélectionnée"),
                                        self.tr(u"Veuillez choisir une clé modèle<br>parmi les clés connectées en cliquant<br>sur une ligne du tableau, pour<br>bénéficier de l'aide à la suppression de fichiers.<br><br>Cette clé doit contenir au moins<br>un répertoire de Travail."))
        
    def choose_dir(self):
        """
        Facilite le choix de motifs de répertoires en recherchant dans
        les clés USB, modifie l'éditeur de ligne de texte et place le
        répertoire choisi dans la liste
        """
        if self.chooseDir!=None:
            f = QFileDialog.getExistingDirectory(None,
                                                 self.tr(u"Choissez un répertoire"),
                                                 self.chooseDir)
            if f and len(f)>0:
                path=f.remove(self.chooseDir+"/")
                self._ui.lineEdit.setText(path)
                # par défaut, on ajoute le nouveau texte et on pourrait aller
                # jusqu'à le sélectionner !
                self.plus()
        else:
             msgBox=QMessageBox.warning(None,
                                        self.tr(u"Aucune clé modèle sélectionnée"),
                                        self.tr(u"Veuillez choisir une clé modèle<br>parmi les clés connectées en cliquant<br>sur une ligne du tableau, pour<br>bénéficier de l'aide à la suppression de fichiers.<br><br>Cette clé doit contenir au moins<br>un répertoire de Travail."))
        
    def activate(self, item):
        """
        Fonction de rappel quand un item de la liste est activé
        @param item désignation de l'item activé
        """
        self._ui.minusButton.setEnabled(True)
        
    def plus(self):
        """
        Permet de choisir et d'ajouter un nouveau fichier ou répertoire à
        supprimer
        """
        text=self._ui.lineEdit.text()
        if len(text)>0 :
            self.append(text)
        
    def minus(self):
        """
        Permet de retirer de la liste des fichiers à supprimer ceux qu'on
        a sélectionnés
        """
        sel=self._ui.listView.selectedIndexes()
        sel1=map(self._proxyModel.mapToSource,sel)
        rows=map(lambda x: x.row(), sel1)
        rows.sort("descending")
        for r in rows:
            self._model.removeRow(r)
        sel=self._ui.listView.selectedIndexes()
        if len(sel)==0:
            self._ui.minusButton.setEnabled(False)
        
    def append(self, path):
        """
        Ajoute un chemin avec ou sans jokers à la liste des chemins à supprimer
        @param path le chemin
        """
        f=self._model.findItems(path)
        if len(f)==0:
            item=QStandardItem(path)
            self._model.appendRow(item)
            self._proxyModel.sort(0)
        else:
            print path, "est déjà sélectionné"

    def pathList(self):
        """
        renvoie la liste des chemins à effacer
        @return une liste de chemins, sous forme de QStrings
        """
        itemList=self._model.findItems("*",Qt.MatchWildcard)
        result=map(lambda x: x.text(), itemList)
        return result
        
