; Script for Inno Setup (http://www.jrsoftware.org/)
; CygWin is expected to be installed unter C:\cygwin

[Setup]
AppName=SCMxx
AppVerName=SCMxx 0.8.2
AppPublisher=Hendrik Sattler
AppPublisherURL=http://www.hendrik-sattler.de
AppSupportURL=http://www.hendrik-sattler.de/scmxx
AppUpdatesURL=http://sourceforge.net/project/showfiles.php?group_id=88510&package_id=92540
AppReadmeFile={app}\ReadMe.txt
DefaultDirName={pf}\SCMxx
DefaultGroupName=SCMxx
AllowNoIcons=yes
LicenseFile=LICENSE
OutputBaseFilename=scmxx-0.8.2-win32-setup
Compression=lzma
SolidCompression=yes

[Types]
Name: "full"; Description: "Full installation"
Name: "custom"; Description: "Custom installation"; Flags: iscustom

[Components]
Name: "scmxx"; Description: "the main binary files"; Types: full custom; Flags: fixed
Name: "cygwin"; Description: "cygwin libraries"; Types: full custom; Flags: fixed
Name: "translation"; Description: "translation files"; Types: full custom
Name: "help"; Description: "HTML help files"; Types: full custom

[Files]
Source: "scmxx.exe"; DestDir: "{app}"; Flags: ignoreversion; Components: "scmxx"
Source: "LICENSE"; DestDir: "{app}"; DestName: "License.txt"; Flags: ignoreversion; Components: "scmxx"
Source: "docs\README_WIN32.txt"; DestDir: "{app}"; DestName: "ReadMe.txt"; Flags: ignoreversion isreadme; Components: "scmxx"
Source: "cygwin1.dll"; DestDir: "{app}"; Components: "cygwin"
Source: "cygiconv-2.dll"; DestDir: "{app}"; Components: "cygwin"
Source: "cygintl-3.dll"; DestDir: "{app}"; Components: "cygwin"
Source: "docs\*.html"; DestDir: "{app}\help"; Flags: ignoreversion recursesubdirs createallsubdirs; Components: "help"
Source: "po\de.mo"; DestDir: "{app}\locale\de\LC_MESSAGES"; DestName: "scmxx.mo"; Flags: ignoreversion recursesubdirs createallsubdirs; Components: "translation"
Source: "po\fr.mo"; DestDir: "{app}\locale\fr\LC_MESSAGES"; DestName: "scmxx.mo"; Flags: ignoreversion recursesubdirs createallsubdirs; Components: "translation"
Source: "po\it.mo"; DestDir: "{app}\locale\it\LC_MESSAGES"; DestName: "scmxx.mo"; Flags: ignoreversion recursesubdirs createallsubdirs; Components: "translation"
Source: "po\ru.mo"; DestDir: "{app}\locale\ru\LC_MESSAGES"; DestName: "scmxx.mo"; Flags: ignoreversion recursesubdirs createallsubdirs; Components: "translation"

