/***************************************************************************
 *   copyright           : (C) 2005 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef W32COMPAT_H
#define W32COMPAT_H

#if defined(WINDOWS_API)
#include <windows.h>

#define sleep(sec) Sleep(1000*sec)
#define usleep(usec) Sleep(usec/1000)

#define setenv(name,value,ow) SetEnvironmentVariable(name,value)
#define unsetenv(name) SetEnvironmentVariable(name,NULL)

#include <sys/types.h>
#define S_IRGRP S_IRUSR

/* TODO: this entry is not correct */
#define ETIMEDOUT 116

#define PATH_SEPERATOR '\\'

#endif

#endif
