/***************************************************************************
 *   copyright           : (C) 2005 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <helper.h>

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#if ! ( defined(OS2) || defined(WINDOWS_API) )
#define UNIX_API 1
#endif

#if defined(UNIX_API)
#include <sys/ioctl.h>
#include <termios.h>
static long console_width_sys (int fd) {
  struct winsize wsize;
#if defined(TIOCGWINSZ)
  if (ioctl(fd,TIOCGWINSZ,&wsize) == 0)
    return wsize.ws_col;
#endif
  return 0;
}
#else
static long console_width_sys (int fd) {
  return 0;
}
#endif


long console_width(int fd) {
  char* cols = getenv("COLUMNS");
  long width = console_width_sys(fd);
  char* temp = NULL;
  
  if (!width && cols)
    width = strtol(cols,&temp,10);

  return (width < 80)? 80: width;
}

void console_print_status (int fd,
			   const char* text,
			   size_t textlen,
			   unsigned long current,
			   unsigned long total)
{
  long width = console_width(fd);
  size_t textlen2 = 4;
  size_t barlen = width-textlen2-1;
  size_t i = 1;
  size_t k = 0;
  char* numout;

  write(fd,"\r",1);

  if (str_len(text) && textlen) {
    write(fd,text,textlen);
    barlen -= strn_width(text,textlen)+1;
    write(fd," ",1);
  }

  /* print status bar */
  write(fd,"[",1);
  for (i = 1; i < barlen-1; ++i) {
    if (k < (current*barlen/total)) write(fd,"=",1);
    else if (k == (current*barlen/total)) write(fd,">",1);
    else write(fd," ",1);
    ++k;
  }
  write(fd,"] ",2);

  /* status in numbers */
  numout = mem_alloc(textlen2+1,1);
  snprintf(numout,textlen2+1,"%3lu%%",100*current/total);
  write(fd,numout,textlen2);
  mem_realloc(numout,0);

  write(fd,"\r",1);
}
