/*							-- DO NOT EDIT --
 * Generated by smidump version 0.4.5:
 *   smidump -f scli TUNNEL-MIB
 *
 * Derived from TUNNEL-MIB:
 *   The MIB module for management of IP Tunnels,
 *   independent of the specific encapsulation scheme in
 *   use.
 *   
 *   Copyright (C) The Internet Society (2005).  This
 *   version of this MIB module is part of RFC 4087;  see
 *   the RFC itself for full legal notices.
 *
 * Revision 2005-05-16 00:00:
 *   IPv4-specific objects were deprecated, including
 *   tunnelIfLocalAddress, tunnelIfRemoteAddress, the
 *   tunnelConfigTable, and the tunnelMIBBasicGroup.
 *   
 *   Added IP version-agnostic objects that should be used
 *   instead, including tunnelIfAddressType,
 *   tunnelIfLocalInetAddress, tunnelIfRemoteInetAddress,
 *   the tunnelInetConfigTable, and the
 *   tunnelIMIBInetGroup.
 *   
 *   The new tunnelIfLocalInetAddress and
 *   tunnelIfRemoteInetAddress objects are read-write,
 *   rather than read-only.
 *   
 *   Updated DESCRIPTION clauses of existing version-
 *   agnostic objects (e.g., tunnelIfTOS) that contained
 *   IPv4-specific text to cover IPv6 as well.
 *   
 *   Added tunnelIfFlowLabel for tunnels over IPv6.
 *   
 *   The encapsulation method was previously an INTEGER
 *   type, and is now an IANA-maintained textual
 *   convention.
 *   
 *   Published as RFC 4087.
 *
 * Revision 1999-08-24 12:00:
 *   Initial version, published as RFC 2667.
 *
 * $Id: tunnel-mib.h 1996 2006-08-22 22:13:26Z schoenw $
 */

#ifndef _TUNNEL_MIB_H_
#define _TUNNEL_MIB_H_

#include "gsnmp.h"

G_BEGIN_DECLS

/*
 * Tables to map enumerations to strings and vice versa.
 */

#define TUNNEL_MIB_TUNNELIFSECURITY_NONE  1
#define TUNNEL_MIB_TUNNELIFSECURITY_IPSEC 2
#define TUNNEL_MIB_TUNNELIFSECURITY_OTHER 3

extern GNetSnmpEnum const tunnel_mib_enums_tunnelIfSecurity[];


/*
 * C type definitions for TUNNEL-MIB::tunnelIfEntry.
 */

#define TUNNEL_MIB_TUNNELIFLOCALADDRESS      (1 << 0) 
#define TUNNEL_MIB_TUNNELIFREMOTEADDRESS     (1 << 1) 
#define TUNNEL_MIB_TUNNELIFENCAPSMETHOD      (1 << 2) 
#define TUNNEL_MIB_TUNNELIFHOPLIMIT          (1 << 3) 
#define TUNNEL_MIB_TUNNELIFSECURITY          (1 << 4) 
#define TUNNEL_MIB_TUNNELIFTOS               (1 << 5) 
#define TUNNEL_MIB_TUNNELIFFLOWLABEL         (1 << 6) 
#define TUNNEL_MIB_TUNNELIFADDRESSTYPE       (1 << 7) 
#define TUNNEL_MIB_TUNNELIFLOCALINETADDRESS  (1 << 8) 
#define TUNNEL_MIB_TUNNELIFREMOTEINETADDRESS (1 << 9) 
#define TUNNEL_MIB_TUNNELIFENCAPSLIMIT       (1 << 10) 

typedef struct {
    gint32   ifIndex;                        /* ro IF-MIB::InterfaceIndex */
    guchar   *tunnelIfLocalAddress;          /* ro SNMPv2-SMI::IpAddress */
#define TUNNEL_MIB_TUNNELIFLOCALADDRESSLENGTH 4
    guchar   *tunnelIfRemoteAddress;         /* ro SNMPv2-SMI::IpAddress */
#define TUNNEL_MIB_TUNNELIFREMOTEADDRESSLENGTH 4
    gint32   *tunnelIfEncapsMethod;          /* ro IANAifType-MIB::IANAtunnelType */
    gint32   *tunnelIfHopLimit;              /* rw */
    gint32   *tunnelIfSecurity;              /* ro */
    gint32   *tunnelIfTOS;                   /* rw */
    gint32   *tunnelIfFlowLabel;             /* rw IPV6-FLOW-LABEL-MIB::IPv6FlowLabelOrAny */
    gint32   *tunnelIfAddressType;           /* rw INET-ADDRESS-MIB::InetAddressType */
    guchar   *tunnelIfLocalInetAddress;      /* rw INET-ADDRESS-MIB::InetAddress */
#define TUNNEL_MIB_TUNNELIFLOCALINETADDRESSMINLENGTH 0
#define TUNNEL_MIB_TUNNELIFLOCALINETADDRESSMAXLENGTH 255
    guint16  _tunnelIfLocalInetAddressLength;
    guchar   *tunnelIfRemoteInetAddress;     /* rw INET-ADDRESS-MIB::InetAddress */
#define TUNNEL_MIB_TUNNELIFREMOTEINETADDRESSMINLENGTH 0
#define TUNNEL_MIB_TUNNELIFREMOTEINETADDRESSMAXLENGTH 255
    guint16  _tunnelIfRemoteInetAddressLength;
    gint32   *tunnelIfEncapsLimit;           /* rw */
} tunnel_mib_tunnelIfEntry_t;

extern void
tunnel_mib_get_tunnelIfTable(GNetSnmp *s, tunnel_mib_tunnelIfEntry_t ***tunnelIfEntry, gint64 mask);

extern void
tunnel_mib_free_tunnelIfTable(tunnel_mib_tunnelIfEntry_t **tunnelIfEntry);

extern tunnel_mib_tunnelIfEntry_t *
tunnel_mib_new_tunnelIfEntry(void);

extern void
tunnel_mib_get_tunnelIfEntry(GNetSnmp *s, tunnel_mib_tunnelIfEntry_t **tunnelIfEntry, gint32 ifIndex, gint64 mask);

extern void
tunnel_mib_set_tunnelIfEntry(GNetSnmp *s, tunnel_mib_tunnelIfEntry_t *tunnelIfEntry, gint64 mask);

extern void
tunnel_mib_free_tunnelIfEntry(tunnel_mib_tunnelIfEntry_t *tunnelIfEntry);

/*
 * C type definitions for TUNNEL-MIB::tunnelConfigEntry.
 */

#define TUNNEL_MIB_TUNNELCONFIGIFINDEX (1 << 0) 
#define TUNNEL_MIB_TUNNELCONFIGSTATUS  (1 << 1) 

typedef struct {
    guchar   tunnelConfigLocalAddress[4];   /* na SNMPv2-SMI::IpAddress */
#define TUNNEL_MIB_TUNNELCONFIGLOCALADDRESSLENGTH 4
    guchar   tunnelConfigRemoteAddress[4];    /* na SNMPv2-SMI::IpAddress */
#define TUNNEL_MIB_TUNNELCONFIGREMOTEADDRESSLENGTH 4
    gint32   tunnelConfigEncapsMethod; /* na IANAifType-MIB::IANAtunnelType */
    gint32   tunnelConfigID;           /* na */
    gint32   *tunnelConfigIfIndex;     /* ro IF-MIB::InterfaceIndexOrZero */
    gint32   *tunnelConfigStatus;      /* rw SNMPv2-TC::RowStatus */
} tunnel_mib_tunnelConfigEntry_t;

extern void
tunnel_mib_get_tunnelConfigTable(GNetSnmp *s, tunnel_mib_tunnelConfigEntry_t ***tunnelConfigEntry, gint64 mask);

extern void
tunnel_mib_free_tunnelConfigTable(tunnel_mib_tunnelConfigEntry_t **tunnelConfigEntry);

extern tunnel_mib_tunnelConfigEntry_t *
tunnel_mib_new_tunnelConfigEntry(void);

extern void
tunnel_mib_get_tunnelConfigEntry(GNetSnmp *s, tunnel_mib_tunnelConfigEntry_t **tunnelConfigEntry, guchar *tunnelConfigLocalAddress, guchar *tunnelConfigRemoteAddress, gint32 tunnelConfigEncapsMethod, gint32 tunnelConfigID, gint64 mask);

extern void
tunnel_mib_set_tunnelConfigEntry(GNetSnmp *s, tunnel_mib_tunnelConfigEntry_t *tunnelConfigEntry, gint64 mask);

extern void
tunnel_mib_free_tunnelConfigEntry(tunnel_mib_tunnelConfigEntry_t *tunnelConfigEntry);

/*
 * C type definitions for TUNNEL-MIB::tunnelInetConfigEntry.
 */

#define TUNNEL_MIB_TUNNELINETCONFIGIFINDEX     (1 << 0) 
#define TUNNEL_MIB_TUNNELINETCONFIGSTATUS      (1 << 1) 
#define TUNNEL_MIB_TUNNELINETCONFIGSTORAGETYPE (1 << 2) 

typedef struct {
    gint32   tunnelInetConfigAddressType;      /* na INET-ADDRESS-MIB::InetAddressType */
    guchar   tunnelInetConfigLocalAddress[115]; /* na INET-ADDRESS-MIB::InetAddress */
#define TUNNEL_MIB_TUNNELINETCONFIGLOCALADDRESSMINLENGTH 0
#define TUNNEL_MIB_TUNNELINETCONFIGLOCALADDRESSMAXLENGTH 115
    guint16  _tunnelInetConfigLocalAddressLength;
    guchar   tunnelInetConfigRemoteAddress[115];/* na INET-ADDRESS-MIB::InetAddress */
#define TUNNEL_MIB_TUNNELINETCONFIGREMOTEADDRESSMINLENGTH 0
#define TUNNEL_MIB_TUNNELINETCONFIGREMOTEADDRESSMAXLENGTH 115
    guint16  _tunnelInetConfigRemoteAddressLength;
    gint32   tunnelInetConfigEncapsMethod;     /* na IANAifType-MIB::IANAtunnelType */
    gint32   tunnelInetConfigID;               /* na */
    gint32   *tunnelInetConfigIfIndex;         /* ro IF-MIB::InterfaceIndexOrZero */
    gint32   *tunnelInetConfigStatus;          /* rw SNMPv2-TC::RowStatus */
    gint32   *tunnelInetConfigStorageType;     /* rw SNMPv2-TC::StorageType */
} tunnel_mib_tunnelInetConfigEntry_t;

extern void
tunnel_mib_get_tunnelInetConfigTable(GNetSnmp *s, tunnel_mib_tunnelInetConfigEntry_t ***tunnelInetConfigEntry, gint64 mask);

extern void
tunnel_mib_free_tunnelInetConfigTable(tunnel_mib_tunnelInetConfigEntry_t **tunnelInetConfigEntry);

extern tunnel_mib_tunnelInetConfigEntry_t *
tunnel_mib_new_tunnelInetConfigEntry(void);

extern void
tunnel_mib_get_tunnelInetConfigEntry(GNetSnmp *s, tunnel_mib_tunnelInetConfigEntry_t **tunnelInetConfigEntry, gint32 tunnelInetConfigAddressType, guchar *tunnelInetConfigLocalAddress, guint16 _tunnelInetConfigLocalAddressLength, guchar *tunnelInetConfigRemoteAddress, guint16 _tunnelInetConfigRemoteAddressLength, gint32 tunnelInetConfigEncapsMethod, gint32 tunnelInetConfigID, gint64 mask);

extern void
tunnel_mib_set_tunnelInetConfigEntry(GNetSnmp *s, tunnel_mib_tunnelInetConfigEntry_t *tunnelInetConfigEntry, gint64 mask);

extern void
tunnel_mib_free_tunnelInetConfigEntry(tunnel_mib_tunnelInetConfigEntry_t *tunnelInetConfigEntry);


G_END_DECLS

#endif /* _TUNNEL_MIB_H_ */
