/* prefs.h - prefs for sciteproj
 *
 *  Copyright 2006 Roy Wood, 2009 Andreas Ronnquist
 *
 * This file is part of Sciteproj.
 * 
 * Sciteproj is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Sciteproj is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Sciteproj.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
#ifndef __PREFS_HEADER_
#define __PREFS_HEADER_

#define PREFS_BUFSIZE 256

/**
 *
 */
typedef struct {
	int lhs;
	int width, height;
	int verbosity;
	int last_file_filter;
	int xpos,ypos;
	
	gboolean dirty_on_folder_change;
	gboolean give_scite_focus;
	
	gboolean allow_duplicates;
	
	gchar *scite_path;
	
	gchar *file_to_load;
	
	gboolean identify_sciteproj_xml;
	
} sciteproj_prefs;

extern sciteproj_prefs gPrefs;

gboolean init_prefs();

#endif /*__PREFS_HEADER_*/
