/* folder_to_xml.c - file system to xml convertion for sciteproj
 *
 *  Copyright 2009 Andreas Ronnquist
 *
 * This file is part of Sciteproj.
 * 
 * Sciteproj is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Sciteproj is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Sciteproj.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <stdio.h>
#include <gtk/gtk.h>
#include <string.h>

#include <unistd.h>

#include "folder_to_xml.h"

/*
 *
 */
gchar *directory_string=0;

FILE *save_file=NULL;

/**
 *
 */
gchar *get_short_folder_name(gchar *base,gchar *current)
{
	int co=0;
	
	gchar *result=current;
	
	for (co=0;co<(int)(strlen(base));co++) {
		result++;
	}
	
	return result;
}

/**
 *
 */
void print_indent(int in)
{
	int co;
	for (co=0;co<in;co++) { 
		//g_printf("  "); '
		if (save_file!=NULL) {
			fprintf(save_file,"  ");
		}
	}
}

/**
 *
 */
void traverse_folder(gchar *folder,int *indent,gboolean ignore_hidden)
{
	gchar *folder_string=g_strdup_printf("%s%c",folder,G_DIR_SEPARATOR);
	
	int newin=*indent;
	
	int chdir_result=0;
	
	gchar *newfolder;
	
	chdir_result=chdir(folder_string);
	
	gboolean ignore_item=FALSE;
	
	(*indent)++;
	
	GDir *dir=g_dir_open(".",0,NULL);
	
	g_free(folder_string);
	
	const gchar *file;
	
	gchar *current_dir=g_get_current_dir();
	
	print_indent(newin);
	
	gchar *shortname=get_short_folder_name(directory_string,current_dir);
	
	//printf("strlen short:%d\n",(int)strlen((char*)shortname));
	
	if ((int)strlen((char*)shortname)==0) {
		shortname=g_strdup_printf(".");
	}
	
	/*
	g_printf("<group name='%s'>",shortname);
	g_printf("\n");
	*/
	
	if (save_file!=NULL) {
		fprintf(save_file,"<group name='%s'>\n",shortname);
	}


	while((file=(gchar*)g_dir_read_name(dir)))
	{
		if (file!=NULL) {
			
			ignore_item=FALSE;
			
			if (ignore_hidden) {
				if (file[0]=='.') {
					ignore_item=TRUE;
				}
			}
			
			// Ignore hidden folders
			if (!ignore_item) {
			
				newfolder=g_strdup_printf("%s%c",file,G_DIR_SEPARATOR);
				
				if (g_file_test(newfolder,G_FILE_TEST_IS_DIR)) {
					// success, we can step into that folder
			
					traverse_folder((char*)newfolder,indent,ignore_hidden);
				} else {
					print_indent(*indent);
					
					gchar *folder=get_short_folder_name(directory_string,current_dir);
					
					if ((folder!=NULL) && ((int)(strlen(folder))!=0)) {
						//g_printf("<file>./%s/%s</file>\n",folder,file);
						if (save_file!=NULL) fprintf(save_file,"<file>./%s/%s</file>\n",folder,file);
					} else {
						//g_printf("<file>./%s</file>\n",file);
						if (save_file!=NULL) fprintf(save_file,"<file>./%s</file>\n",file);
					}
				}
				
				g_free(newfolder);
			}
		
		} else { 
			break;
		}
		
	// end of while loop
	}
	
	g_dir_close(dir);

	print_indent(newin);
	//g_printf("</group>\n");
	if (save_file!=NULL) fprintf(save_file,"</group>\n");
						
	chdir_result=chdir("..");
						
	(*indent)--;
}

/**
 *	folder_to_xml
 *
 *	@param folder folder to begin traverse
 * @param save_filename filename to save resulting XML in
 *	
 * @return gboolean TRUE if success, otherwise FALSE
 */
gboolean folder_to_xml(gchar *folder,gchar *save_filename)
{
	directory_string=(gchar*)folder;
	
	gchar *stored_current_dir=g_get_current_dir();
	
	int chdir_result=0;
	
	if (!g_file_test(directory_string,G_FILE_TEST_IS_DIR)) {
		g_error("Error: Invalid directory!");
		return FALSE;
	}
	
	chdir_result=chdir(directory_string);
	
	if (save_filename!=NULL) {
	
	if ((save_file=fopen(save_filename,"w"))==NULL) {
		g_error("Couldn't create file!");
		return FALSE;
	}
	
	}
	
	//g_printf("<root>\n");
	if (save_file!=NULL) fprintf(save_file,"<root>\n");
	
	int q=0;
	
	traverse_folder((char*)".",&q,TRUE);
	
	//g_printf("</root>\n");
	if (save_file!=NULL) fprintf(save_file,"</root>\n");

	if (save_filename!=NULL) {	
		fclose(save_file);
		save_file=NULL;
	}
	
	chdir_result=chdir(stored_current_dir);
	
	g_free(stored_current_dir);
	
	
	// it worked fine
	return TRUE;
}
