/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2012 - Scilab Enterprises - Calixte Denizet
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.implementation.g2d.motor;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;

import org.scilab.forge.scirenderer.tranformations.Vector3d;

/**
 * @author Calixte DENIZET
 */
public class PolyLine extends AbstractDrawable3DObject {

    public PolyLine(Vector3d[] vertices, Color[] colors) throws InvalidPolygonException {
	super(vertices, colors);
    }

    public static List<PolyLine> get(Vector3d[] vertices, Color[] colors) {
	int start = 0;
	int end;
	List<PolyLine> list = new ArrayList<PolyLine>();
	
	while (start < vertices.length) {
	    for (int i = start; i < vertices.length; i++) {
		if (AbstractDrawable3DObject.isNanOrInf(vertices[i])) {
		    start++;
		} else {
		    break;
		}
	    }
	    end = start;
	    for (int i = start; i < vertices.length; i++) {
		if (AbstractDrawable3DObject.isNanOrInf(vertices[i])) {
		    break;
		} else {
		    end++;
		}
	    }
	    
	    Vector3d[] vs = new Vector3d[end - start + 1];
	    Color[] cs = new Color[vs.length];
	    for (int i = start; i < end; i++) {
		vs[i - start] = vertices[i];
		cs[i - start] = colors[i];
	    }
	    
	    try {
		list.add(new PolyLine(vs, cs));
	    } catch (InvalidPolygonException e) { }

	    start = end + 1;
	}
	
	return list;
    }

    public void draw(Graphics2D g2d) {

    }
}