/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2012 - Scilab Enterprises - Calixte Denizet
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.implementation.g2d.motor;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.Map;

import org.scilab.forge.scirenderer.DrawingTools;
import org.scilab.forge.scirenderer.shapes.appearance.Appearance;
import org.scilab.forge.scirenderer.shapes.geometry.Geometry;

/**
 * @author Calixte DENIZET
 */
public class G2DStroke extends BasicStroke {

    private static final int[] array = new int[16];
    private static Map<Long, Stroke> strokes = new HashMap<Long, Stroke>();

    static {
        strokes.put((long)Appearance.DEFAULT_LINE_PATTERN, new BasicStroke());
    }

    private G2DStroke(float lineWidth, float[] dash) {
        super(lineWidth, CAP_SQUARE, JOIN_MITER, 10.0f, dash, 0f);
    }

    public static Stroke getStroke(Appearance appearance) {
        Appearance usedAppearance;
        if (appearance == null) {
            usedAppearance = new Appearance();
        } else {
            usedAppearance = appearance;
        }

        short pattern = appearance.getLinePattern();
        if (pattern == -1) {
            return strokes.get((long) Appearance.DEFAULT_LINE_PATTERN);
        }

        float factor = appearance.getLineWidth();
        long id = ((long) pattern) | (long) (((int) factor) << 16);
        Stroke s = strokes.get(id);

        if (s != null) {
            return s;
        }

        s = new G2DStroke(factor, decodePattern(factor, pattern));
        strokes.put(id, s);

        return s;
    }

    private static final float[] decodePattern(final float factor, final short pattern) {
        int n = 0xFFFF & pattern;
        int i = 0;
        int k = Integer.numberOfLeadingZeros(n) - 16;
        while (n != 0) {
            int t = Integer.numberOfTrailingZeros(n);
            if (t == 0) {
                t = Integer.numberOfTrailingZeros(0xFFFF - n);
            }

            array[i++] = t;
            n = n >> t;
        }
        array[i] = k;

        float[] ret = new float[i + 1];

        for (int j = 0; j <= i; j++) {
            ret[j] = ((float) array[j]) * factor;
        }

        return ret;
    }

}