/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2011 - DIGITEO - Pierre Lando
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.implementation.jogl.depthtest;

import org.scilab.forge.scirenderer.depthtest.DepthTestManager;

/**
 * The JoGL implementation of the {@link org.scilab.forge.scirenderer.depthtest.DepthTestManager}.
 * @author Pierre Lando
 */
public class JoGLDepthBufferManager implements DepthTestManager {

    /**
     * The current 'auto clear depth buffer' state.
     */
    private boolean autoClearDepthBuffer = DEFAULT_AUTO_CLEAR_DEPTH_BUFFER_STATUS;

    /**
     * Default constructor.
     */
    public JoGLDepthBufferManager() {
    }

    @Override
    public boolean isAutoClearDepthBufferEnable() {
        return autoClearDepthBuffer;
    }

    @Override
    public void setAutoClearDepthBufferEnable(boolean status) {
        autoClearDepthBuffer = status;
    }
}
