/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2012 - Scilab Enterprises - Calixte DENIZET
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.implementation.g2d;

import java.awt.Dimension;
import java.awt.Graphics2D;

import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.Drawer;
import org.scilab.forge.scirenderer.depthtest.DepthTestManager;
import org.scilab.forge.scirenderer.implementation.g2d.buffers.G2DBuffersManager;
import org.scilab.forge.scirenderer.implementation.g2d.motor.Motor3D;
import org.scilab.forge.scirenderer.implementation.g2d.renderer.G2DRendererManager;
import org.scilab.forge.scirenderer.implementation.g2d.texture.G2DTextureManager;
import org.scilab.forge.scirenderer.texture.TextureManager;
import org.scilab.forge.scirenderer.picking.PickingManager;
import org.scilab.forge.scirenderer.picking.PickingTask;

/**
 * G2D implementation of a Canvas.
 *
 * @author Calixte DENIZET
 */
public final class G2DCanvas implements Canvas {

    private final G2DDrawingTools drawingTools;
    private final G2DBuffersManager buffersManager;
    private final G2DRendererManager rendererManager;
    private final G2DTextureManager textureManager;

    private final Motor3D motor;
    private final Dimension dimension;

    private static final DepthTestManager DEPTHTESTMANAGER = new DepthTestManager() {
	    
	    @Override
	    public boolean isAutoClearDepthBufferEnable() {
		return true;
	    }
	    
	    @Override
	    public void setAutoClearDepthBufferEnable(boolean status) { }
	};

    private static final PickingManager PICKINGMANAGER = new PickingManager() {
	    
	    @Override
	    public void addPickingTask(PickingTask pickingTask) { }
	};

    /**
     * The current mainDrawer.
     */
    private Drawer mainDrawer;

    /**
     * Default constructor.
     * @param autoDrawable the G2D autoDrawable this canvas depend on.
     */
    G2DCanvas(Graphics2D g2d, int width, int height) {
	this.dimension = new Dimension(width, height);
	this.motor = new Motor3D(g2d, dimension);

        buffersManager = new G2DBuffersManager();
        rendererManager = new G2DRendererManager();
        drawingTools = new G2DDrawingTools(this);
	motor.setClippingPlanes(drawingTools.getClippingManager().getClippingPlanes());
        textureManager = new G2DTextureManager(this);
    }

    // Implementation of getter & setter from Canvas.

    @Override
    public void setMainDrawer(Drawer mainDrawer) {
        this.mainDrawer = mainDrawer;
    }

    @Override
    public Drawer getMainDrawer() {
        return mainDrawer;
    }

    @Override
    public G2DRendererManager getRendererManager() {
        return rendererManager;
    }

    @Override
    public G2DBuffersManager getBuffersManager() {
        return buffersManager;
    }

    @Override
    public DepthTestManager getDepthTestManager() {
	return DEPTHTESTMANAGER;
    }

    @Override
    public PickingManager getPickingManager() {
    	return PICKINGMANAGER;
    }

    @Override
    public G2DTextureManager getTextureManager() {
	return textureManager;
    }

    @Override
    public int getWidth() {
        return dimension.width;
    }

    @Override
    public int getHeight() {
        return dimension.height;
    }

    @Override
    public Dimension getDimension() {
        return dimension;
    }

    @Override
    public void redraw() {
	draw();
    }

    // G2DCanvas specific getter.

    public void draw() {
	try {
	    mainDrawer.draw(drawingTools);
	    getMotor3D().draw();
	} catch (Exception e) {
	    System.out.println(e+"::::"+mainDrawer);
	    e.printStackTrace();
	}
    }

    /**
     * Return the OpenGl context.
     * @return the OpenGl context.
     */
    public Motor3D getMotor3D() {
        return motor;
    }
}
