/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2012 - DIGITEO - Pierre Lando
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.texture;

/**
 * @author Pierre Lando
 */
public interface Texture extends DataUser{

    /**
     * Enumeration of wrapping possibility.
     */
    public enum Wrap {
        /**
         * REPEAT: the integer part of the texture coordinate to be ignored.
         */
        REPEAT,

        /**
         * CLAMP: the texture coordinate is clamped to [0, 1].
         */
        CLAMP
    }

    /**
     * Enumeration of filtering possibility.
     */
    public enum Filter {
        /**
         * Use the value of the texture element that is nearest (in Manhattan distance) to the center of the pixel being textured.
         */
        NEAREST,

        /**
         * Use the weighted average of the four texture elements that are closest to the center of the pixel being textured.
         */
        LINEAR
    }

    /**
     * Texture validity getter.
     * @return true is this texture is valid and can be used for rendering.
     */
    boolean isValid();

    /**
     * Wrapping mode on the first dimension getter.
     * For more information on wrapping mode {see Wrap}.
     * @return the wrapping mode on the first dimension.
     */
    Wrap getSWrappingMode();

    void setSWrappingMode(Wrap wrappingMode);

    /**
     * Wrapping mode on the second dimension getter.
     * If the texture dimension is 1, this method will return <code>null</code>.
     * For more information on wrapping mode {see Wrap}.
     * @return the wrapping mode on the second dimension.
     */
    Wrap getTWrappingMode();

    void setTWrappingMode(Wrap wrappingMode);

    /**
     * Minifying filter getter.
     * @return the used minifying filter.
     */
    Filter getMinifyingFilter();

    void setMinifyingFilter(Filter minifyingFilter);

    /**
     * Magnification filter getter.
     * @return the used magnification filter.
     */
    Filter getMagnificationFilter();

    void setMagnificationFilter(Filter magnificationFilter);



    TextureDataProvider getDataProvider();

    void setDataProvider(TextureDataProvider provider);
}
